<?php
/**
 * Required plugins
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$chrimson_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'chrimson' ),
	'page_builders' => esc_html__( 'Page Builders', 'chrimson' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'chrimson' ),
	'socials'       => esc_html__( 'Socials and Communities', 'chrimson' ),
	'events'        => esc_html__( 'Events and Appointments', 'chrimson' ),
	'content'       => esc_html__( 'Content', 'chrimson' ),
	'other'         => esc_html__( 'Other', 'chrimson' ),
);
$chrimson_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'chrimson' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'chrimson' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $chrimson_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'chrimson' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'chrimson' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $chrimson_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'chrimson' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'chrimson' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $chrimson_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'chrimson' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'chrimson' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $chrimson_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'chrimson' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'chrimson' ),
		'required'    => false,
		'logo'        => 'woocommerce.png',
		'group'       => $chrimson_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'chrimson' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'chrimson' ),
		'required'    => false,
		'install'     => false, // TRX_addons has marked the "Elegro Crypto Payment" plugin as obsolete and no longer recommends it for installation, even if it had been previously recommended by the theme
		'logo'        => 'elegro-payment.png',
		'group'       => $chrimson_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'chrimson' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'chrimson' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $chrimson_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'chrimson' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'chrimson' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $chrimson_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'chrimson' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $chrimson_theme_required_plugins_groups['events'],
	),
	'quickcal'                     => array(
		'title'       => esc_html__( 'QuickCal', 'chrimson' ),
		'description' => '',
		'required'    => false,
        	'install'     => false,
		'logo'        => 'quickcal.png',
		'group'       => $chrimson_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'chrimson' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $chrimson_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'chrimson' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'chrimson' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $chrimson_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'chrimson' ),
		'description' => '',
		'required'    => false,
        	'install'     => false,
		'logo'        => chrimson_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $chrimson_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'chrimson' ),
		'description' => '',
		'required'    => false,
		'logo'        => chrimson_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $chrimson_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'chrimson' ),
		'description' => '',
		'required'    => false,
        	'install'     => false,
		'logo'        => chrimson_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $chrimson_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'chrimson' ),
		'description' => '',
		'required'    => false,
		'logo'        => chrimson_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $chrimson_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'chrimson' ),
		'description' => '',
		'required'    => false,
                'install'     => false,
		'logo'        => chrimson_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $chrimson_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'chrimson' ),
		'description' => '',
		'required'    => false,
        	'install'     => false,
		'logo'        => chrimson_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $chrimson_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'chrimson' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $chrimson_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'chrimson' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'revslider.png',
		'group'       => $chrimson_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'chrimson' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'chrimson' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $chrimson_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'chrimson' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'chrimson' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $chrimson_theme_required_plugins_groups['other'],
	),
	'gdpr-framework'         => array(
		'title'       => esc_html__( 'The GDPR Framework', 'chrimson' ),
		'description' => esc_html__( "Tools to help make your website GDPR-compliant. Fully documented, extendable and developer-friendly.", 'chrimson' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'gdpr-framework.png',
		'group'       => $chrimson_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'chrimson' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'chrimson' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $chrimson_theme_required_plugins_groups['other'],
	),
);

if ( CHRIMSON_THEME_FREE ) {
	unset( $chrimson_theme_required_plugins['js_composer'] );
	unset( $chrimson_theme_required_plugins['booked'] );
	unset( $chrimson_theme_required_plugins['quickcal'] );
	unset( $chrimson_theme_required_plugins['the-events-calendar'] );
	unset( $chrimson_theme_required_plugins['calculated-fields-form'] );
	unset( $chrimson_theme_required_plugins['essential-grid'] );
	unset( $chrimson_theme_required_plugins['revslider'] );
	unset( $chrimson_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $chrimson_theme_required_plugins['trx_updater'] );
	unset( $chrimson_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
chrimson_storage_set( 'required_plugins', $chrimson_theme_required_plugins );
