<?php
/**
 * The template to display single post
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

// Full post loading
$full_post_loading          = chrimson_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = chrimson_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = chrimson_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$chrimson_related_position   = chrimson_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$chrimson_posts_navigation   = chrimson_get_theme_option( 'posts_navigation' );
$chrimson_prev_post          = false;
$chrimson_prev_post_same_cat = (int)chrimson_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( chrimson_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	chrimson_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'chrimson_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $chrimson_posts_navigation ) {
		$chrimson_prev_post = get_previous_post( $chrimson_prev_post_same_cat );  // Get post from same category
		if ( ! $chrimson_prev_post && $chrimson_prev_post_same_cat ) {
			$chrimson_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $chrimson_prev_post ) {
			$chrimson_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $chrimson_prev_post ) ) {
		chrimson_sc_layouts_showed( 'featured', false );
		chrimson_sc_layouts_showed( 'title', false );
		chrimson_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $chrimson_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/content', 'single-' . chrimson_get_theme_option( 'single_style' ) ), 'single-' . chrimson_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $chrimson_related_position, 'inside' ) === 0 ) {
		$chrimson_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'chrimson_action_related_posts' );
		$chrimson_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $chrimson_related_content ) ) {
			$chrimson_related_position_inside = max( 0, min( 9, chrimson_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $chrimson_related_position_inside ) {
				$chrimson_related_position_inside = mt_rand( 1, 9 );
			}

			$chrimson_p_number         = 0;
			$chrimson_related_inserted = false;
			$chrimson_in_block         = false;
			$chrimson_content_start    = strpos( $chrimson_content, '<div class="post_content' );
			$chrimson_content_end      = strrpos( $chrimson_content, '</div>' );

			for ( $i = max( 0, $chrimson_content_start ); $i < min( strlen( $chrimson_content ) - 3, $chrimson_content_end ); $i++ ) {
				if ( $chrimson_content[ $i ] != '<' ) {
					continue;
				}
				if ( $chrimson_in_block ) {
					if ( strtolower( substr( $chrimson_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$chrimson_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $chrimson_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $chrimson_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$chrimson_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $chrimson_content[ $i + 1 ] && in_array( $chrimson_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$chrimson_p_number++;
					if ( $chrimson_related_position_inside == $chrimson_p_number ) {
						$chrimson_related_inserted = true;
						$chrimson_content = ( $i > 0 ? substr( $chrimson_content, 0, $i ) : '' )
											. $chrimson_related_content
											. substr( $chrimson_content, $i );
					}
				}
			}
			if ( ! $chrimson_related_inserted ) {
				if ( $chrimson_content_end > 0 ) {
					$chrimson_content = substr( $chrimson_content, 0, $chrimson_content_end ) . $chrimson_related_content . substr( $chrimson_content, $chrimson_content_end );
				} else {
					$chrimson_content .= $chrimson_related_content;
				}
			}
		}

		chrimson_show_layout( $chrimson_content );
	}

	// Comments
	do_action( 'chrimson_action_before_comments' );
	comments_template();
	do_action( 'chrimson_action_after_comments' );

	// Related posts
	if ( 'below_content' == $chrimson_related_position
		&& ( 'scroll' != $chrimson_posts_navigation || (int)chrimson_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)chrimson_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'chrimson_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $chrimson_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $chrimson_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $chrimson_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $chrimson_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'chrimson_action_nav_links_single_scroll_data', $chrimson_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
