<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

$chrimson_template = apply_filters( 'chrimson_filter_get_template_part', chrimson_blog_archive_get_template() );

if ( ! empty( $chrimson_template ) && 'index' != $chrimson_template ) {

	get_template_part( $chrimson_template );

} else {

	chrimson_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$chrimson_stickies   = is_home()
								|| ( in_array( chrimson_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) chrimson_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$chrimson_post_type  = chrimson_get_theme_option( 'post_type' );
		$chrimson_args       = array(
								'blog_style'     => chrimson_get_theme_option( 'blog_style' ),
								'post_type'      => $chrimson_post_type,
								'taxonomy'       => chrimson_get_post_type_taxonomy( $chrimson_post_type ),
								'parent_cat'     => chrimson_get_theme_option( 'parent_cat' ),
								'posts_per_page' => chrimson_get_theme_option( 'posts_per_page' ),
								'sticky'         => chrimson_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $chrimson_stickies )
															&& count( $chrimson_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		chrimson_blog_archive_start();

		do_action( 'chrimson_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'chrimson_action_before_page_author' );
			get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'chrimson_action_after_page_author' );
		}

		if ( chrimson_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'chrimson_action_before_page_filters' );
			chrimson_show_filters( $chrimson_args );
			do_action( 'chrimson_action_after_page_filters' );
		} else {
			do_action( 'chrimson_action_before_page_posts' );
			chrimson_show_posts( array_merge( $chrimson_args, array( 'cat' => $chrimson_args['parent_cat'] ) ) );
			do_action( 'chrimson_action_after_page_posts' );
		}

		do_action( 'chrimson_action_blog_archive_end' );

		chrimson_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'chrimson_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
