<?php
$chrimson_woocommerce_sc = chrimson_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $chrimson_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$chrimson_scheme = chrimson_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $chrimson_scheme ) && ! chrimson_is_inherit( $chrimson_scheme ) ) {
			echo ' scheme_' . esc_attr( $chrimson_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( chrimson_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( chrimson_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$chrimson_css      = '';
			$chrimson_bg_image = chrimson_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $chrimson_bg_image ) ) {
				$chrimson_css .= 'background-image: url(' . esc_url( chrimson_get_attachment_url( $chrimson_bg_image ) ) . ');';
			}
			if ( ! empty( $chrimson_css ) ) {
				echo ' style="' . esc_attr( $chrimson_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$chrimson_anchor_icon = chrimson_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$chrimson_anchor_text = chrimson_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $chrimson_anchor_icon ) || ! empty( $chrimson_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $chrimson_anchor_icon ) ? ' icon="' . esc_attr( $chrimson_anchor_icon ) . '"' : '' )
											. ( ! empty( $chrimson_anchor_text ) ? ' title="' . esc_attr( $chrimson_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( chrimson_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' chrimson-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$chrimson_css      = '';
				$chrimson_bg_mask  = chrimson_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$chrimson_bg_color_type = chrimson_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $chrimson_bg_color_type ) {
					$chrimson_bg_color = chrimson_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $chrimson_bg_color_type ) {
					$chrimson_bg_color = chrimson_get_scheme_color( 'bg_color', $chrimson_scheme );
				} else {
					$chrimson_bg_color = '';
				}
				if ( ! empty( $chrimson_bg_color ) && $chrimson_bg_mask > 0 ) {
					$chrimson_css .= 'background-color: ' . esc_attr(
						1 == $chrimson_bg_mask ? $chrimson_bg_color : chrimson_hex2rgba( $chrimson_bg_color, $chrimson_bg_mask )
					) . ';';
				}
				if ( ! empty( $chrimson_css ) ) {
					echo ' style="' . esc_attr( $chrimson_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$chrimson_caption     = chrimson_get_theme_option( 'front_page_woocommerce_caption' );
				$chrimson_description = chrimson_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $chrimson_caption ) || ! empty( $chrimson_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $chrimson_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $chrimson_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $chrimson_caption, 'chrimson_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $chrimson_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $chrimson_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $chrimson_description ), 'chrimson_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $chrimson_woocommerce_sc ) {
						$chrimson_woocommerce_sc_ids      = chrimson_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$chrimson_woocommerce_sc_per_page = count( explode( ',', $chrimson_woocommerce_sc_ids ) );
					} else {
						$chrimson_woocommerce_sc_per_page = max( 1, (int) chrimson_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$chrimson_woocommerce_sc_columns = max( 1, min( $chrimson_woocommerce_sc_per_page, (int) chrimson_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$chrimson_woocommerce_sc}"
										. ( 'products' == $chrimson_woocommerce_sc
												? ' ids="' . esc_attr( $chrimson_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $chrimson_woocommerce_sc
												? ' category="' . esc_attr( chrimson_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $chrimson_woocommerce_sc
												? ' orderby="' . esc_attr( chrimson_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( chrimson_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $chrimson_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $chrimson_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
