<?php
$chrimson_slider_sc = chrimson_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $chrimson_slider_sc ) && strpos( $chrimson_slider_sc, '[' ) !== false && strpos( $chrimson_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( chrimson_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$chrimson_anchor_icon = chrimson_get_theme_option( 'front_page_title_anchor_icon' );
		$chrimson_anchor_text = chrimson_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $chrimson_anchor_icon ) || ! empty( $chrimson_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $chrimson_anchor_icon ) ? ' icon="' . esc_attr( $chrimson_anchor_icon ) . '"' : '' )
									. ( ! empty( $chrimson_anchor_text ) ? ' title="' . esc_attr( $chrimson_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $chrimson_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$chrimson_scheme = chrimson_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $chrimson_scheme ) && ! chrimson_is_inherit( $chrimson_scheme ) ) {
			echo ' scheme_' . esc_attr( $chrimson_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( chrimson_get_theme_option( 'front_page_title_paddings' ) );
		if ( chrimson_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$chrimson_css      = '';
		$chrimson_bg_image = chrimson_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $chrimson_bg_image ) ) {
			$chrimson_css .= 'background-image: url(' . esc_url( chrimson_get_attachment_url( $chrimson_bg_image ) ) . ');';
		}
		if ( ! empty( $chrimson_css ) ) {
			echo ' style="' . esc_attr( $chrimson_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$chrimson_anchor_icon = chrimson_get_theme_option( 'front_page_title_anchor_icon' );
		$chrimson_anchor_text = chrimson_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $chrimson_anchor_icon ) || ! empty( $chrimson_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $chrimson_anchor_icon ) ? ' icon="' . esc_attr( $chrimson_anchor_icon ) . '"' : '' )
									. ( ! empty( $chrimson_anchor_text ) ? ' title="' . esc_attr( $chrimson_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( chrimson_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' chrimson-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$chrimson_css      = '';
			$chrimson_bg_mask  = chrimson_get_theme_option( 'front_page_title_bg_mask' );
			$chrimson_bg_color_type = chrimson_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $chrimson_bg_color_type ) {
				$chrimson_bg_color = chrimson_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $chrimson_bg_color_type ) {
				$chrimson_bg_color = chrimson_get_scheme_color( 'bg_color', $chrimson_scheme );
			} else {
				$chrimson_bg_color = '';
			}
			if ( ! empty( $chrimson_bg_color ) && $chrimson_bg_mask > 0 ) {
				$chrimson_css .= 'background-color: ' . esc_attr(
					1 == $chrimson_bg_mask ? $chrimson_bg_color : chrimson_hex2rgba( $chrimson_bg_color, $chrimson_bg_mask )
				) . ';';
			}
			if ( ! empty( $chrimson_css ) ) {
				echo ' style="' . esc_attr( $chrimson_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$chrimson_caption = chrimson_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $chrimson_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $chrimson_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $chrimson_caption, 'chrimson_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$chrimson_description = chrimson_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $chrimson_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $chrimson_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $chrimson_description ), 'chrimson_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( chrimson_get_theme_option( 'front_page_title_button1_link' ) != '' || chrimson_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						chrimson_show_layout( chrimson_customizer_partial_refresh_front_page_title_button1_link() );
						chrimson_show_layout( chrimson_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
