<div class="front_page_section front_page_section_about<?php
	$chrimson_scheme = chrimson_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $chrimson_scheme ) && ! chrimson_is_inherit( $chrimson_scheme ) ) {
		echo ' scheme_' . esc_attr( $chrimson_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( chrimson_get_theme_option( 'front_page_about_paddings' ) );
	if ( chrimson_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$chrimson_css      = '';
		$chrimson_bg_image = chrimson_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $chrimson_bg_image ) ) {
			$chrimson_css .= 'background-image: url(' . esc_url( chrimson_get_attachment_url( $chrimson_bg_image ) ) . ');';
		}
		if ( ! empty( $chrimson_css ) ) {
			echo ' style="' . esc_attr( $chrimson_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$chrimson_anchor_icon = chrimson_get_theme_option( 'front_page_about_anchor_icon' );
	$chrimson_anchor_text = chrimson_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $chrimson_anchor_icon ) || ! empty( $chrimson_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $chrimson_anchor_icon ) ? ' icon="' . esc_attr( $chrimson_anchor_icon ) . '"' : '' )
									. ( ! empty( $chrimson_anchor_text ) ? ' title="' . esc_attr( $chrimson_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( chrimson_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' chrimson-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$chrimson_css           = '';
			$chrimson_bg_mask       = chrimson_get_theme_option( 'front_page_about_bg_mask' );
			$chrimson_bg_color_type = chrimson_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $chrimson_bg_color_type ) {
				$chrimson_bg_color = chrimson_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $chrimson_bg_color_type ) {
				$chrimson_bg_color = chrimson_get_scheme_color( 'bg_color', $chrimson_scheme );
			} else {
				$chrimson_bg_color = '';
			}
			if ( ! empty( $chrimson_bg_color ) && $chrimson_bg_mask > 0 ) {
				$chrimson_css .= 'background-color: ' . esc_attr(
					1 == $chrimson_bg_mask ? $chrimson_bg_color : chrimson_hex2rgba( $chrimson_bg_color, $chrimson_bg_mask )
				) . ';';
			}
			if ( ! empty( $chrimson_css ) ) {
				echo ' style="' . esc_attr( $chrimson_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$chrimson_caption = chrimson_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $chrimson_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $chrimson_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $chrimson_caption, 'chrimson_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$chrimson_description = chrimson_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $chrimson_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $chrimson_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $chrimson_description ), 'chrimson_kses_content' ); ?></div>
				<?php
			}

			// Content
			$chrimson_content = chrimson_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $chrimson_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $chrimson_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$chrimson_page_content_mask = '%%CONTENT%%';
					if ( strpos( $chrimson_content, $chrimson_page_content_mask ) !== false ) {
						$chrimson_content = preg_replace(
							'/(\<p\>\s*)?' . $chrimson_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$chrimson_content
						);
					}
					chrimson_show_layout( $chrimson_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
