<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package CHRIMSON
 * @since CHRIMSON 1.0
 */

							do_action( 'chrimson_action_page_content_end_text' );
							
							// Widgets area below the content
							chrimson_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'chrimson_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'chrimson_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'chrimson_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'chrimson_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$chrimson_body_style = chrimson_get_theme_option( 'body_style' );
					$chrimson_widgets_name = chrimson_get_theme_option( 'widgets_below_page', 'hide' );
					$chrimson_show_widgets = ! chrimson_is_off( $chrimson_widgets_name ) && is_active_sidebar( $chrimson_widgets_name );
					$chrimson_show_related = chrimson_is_single() && chrimson_get_theme_option( 'related_position', 'below_content' ) == 'below_page';
					if ( $chrimson_show_widgets || $chrimson_show_related ) {
						if ( 'fullscreen' != $chrimson_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $chrimson_show_related ) {
							do_action( 'chrimson_action_related_posts' );
						}

						// Widgets area below page content
						if ( $chrimson_show_widgets ) {
							chrimson_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $chrimson_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'chrimson_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'chrimson_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! chrimson_is_singular( 'post' ) && ! chrimson_is_singular( 'attachment' ) ) || ! in_array ( chrimson_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="chrimson_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'chrimson_action_before_footer' );

				// Footer
				$chrimson_footer_type = chrimson_get_theme_option( 'footer_type' );
				if ( 'custom' == $chrimson_footer_type && ! chrimson_is_layouts_available() ) {
					$chrimson_footer_type = 'default';
				}
				get_template_part( apply_filters( 'chrimson_filter_get_template_part', "templates/footer-" . sanitize_file_name( $chrimson_footer_type ) ) );

				do_action( 'chrimson_action_after_footer' );

			}
			?>

			<?php do_action( 'chrimson_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'chrimson_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'chrimson_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>