<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (!class_exists('G5Plus_Auteur_Font_Icon')) {
    class G5Plus_Auteur_Font_Icon
    {
        private static $_instance;

        public static function getInstance()
        {
            if (self::$_instance == NULL) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        public function registerAssets()
        {
            $icon_font = array(
	            'font-awesome-5pro' => array(
		            'url' => G5Plus_Auteur()->helper()->getAssetUrl('assets/vendors/font-awesome-5.15.4/css/fontawesome.min.css'),
		            'ver' => '5.15.4'
	            ),
                'font-awesome' => array(
                    'url' => G5Plus_Auteur()->helper()->getAssetUrl('assets/vendors/font-awesome-5.15.4/css/fontawesome.min.css'),
                    'ver' => '5.15.4'
                )
            );
            return $icon_font;
        }

        public function registerConfig()
        {
            $config = array(
	            'fontawesome1' => array(
		            'label' => esc_html__('Font Awesome 5Pro','g5plus-auteur'),
		            'iconGroup' => json_decode('[{"id":"accessibility","title":"Accessibility","icons":["fab fa-accessible-icon","fas fa-american-sign-language-interpreting","far fa-american-sign-language-interpreting","fal fa-american-sign-language-interpreting","fas fa-assistive-listening-systems","far fa-assistive-listening-systems","fal fa-assistive-listening-systems","fas fa-audio-description","far fa-audio-description","fal fa-audio-description","fas fa-blind","far fa-blind","fal fa-blind","fas fa-braille","far fa-braille","fal fa-braille","fas fa-closed-captioning","far fa-closed-captioning","fal fa-closed-captioning","fas fa-deaf","far fa-deaf","fal fa-deaf","fas fa-dog-leashed","far fa-dog-leashed","fal fa-dog-leashed","fas fa-low-vision","far fa-low-vision","fal fa-low-vision","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-question-circle","far fa-question-circle","fal fa-question-circle","fas fa-sign-language","far fa-sign-language","fal fa-sign-language","fas fa-tty","far fa-tty","fal fa-tty","fas fa-universal-access","far fa-universal-access","fal fa-universal-access","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair"]},{"id":"alert","title":"Alert","icons":["fas fa-alarm-clock","far fa-alarm-clock","fal fa-alarm-clock","fas fa-alarm-exclamation","far fa-alarm-exclamation","fal fa-alarm-exclamation","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-exclamation","far fa-bell-exclamation","fal fa-bell-exclamation","fas fa-bell-on","far fa-bell-on","fal fa-bell-on","fas fa-bell-school-slash","far fa-bell-school-slash","fal fa-bell-school-slash","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-bells","far fa-bells","fal fa-bells","fas fa-calendar-exclamation","far fa-calendar-exclamation","fal fa-calendar-exclamation","fas fa-comment-alt-exclamation","far fa-comment-alt-exclamation","fal fa-comment-alt-exclamation","fas fa-comment-exclamation","far fa-comment-exclamation","fal fa-comment-exclamation","fas fa-engine-warning","far fa-engine-warning","fal fa-engine-warning","fas fa-exclamation","far fa-exclamation","fal fa-exclamation","fas fa-exclamation-circle","far fa-exclamation-circle","fal fa-exclamation-circle","fas fa-exclamation-square","far fa-exclamation-square","fal fa-exclamation-square","fas fa-exclamation-triangle","far fa-exclamation-triangle","fal fa-exclamation-triangle","fas fa-file-exclamation","far fa-file-exclamation","fal fa-file-exclamation","fas fa-lightbulb-exclamation","far fa-lightbulb-exclamation","fal fa-lightbulb-exclamation","fas fa-map-marker-exclamation","far fa-map-marker-exclamation","fal fa-map-marker-exclamation","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-radiation-alt","far fa-radiation-alt","fal fa-radiation-alt","fas fa-sensor","far fa-sensor","fal fa-sensor","fas fa-sensor-alert","far fa-sensor-alert","fal fa-sensor-alert","fas fa-sensor-fire","far fa-sensor-fire","fal fa-sensor-fire","fas fa-sensor-on","far fa-sensor-on","fal fa-sensor-on","fas fa-sensor-smoke","far fa-sensor-smoke","fal fa-sensor-smoke","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-star-exclamation","far fa-star-exclamation","fal fa-star-exclamation","fas fa-wind-warning","far fa-wind-warning","fal fa-wind-warning"]},{"id":"animals","title":"Animals","icons":["fas fa-alicorn","far fa-alicorn","fal fa-alicorn","fas fa-badger-honey","far fa-badger-honey","fal fa-badger-honey","fas fa-bat","far fa-bat","fal fa-bat","fas fa-cat","far fa-cat","fal fa-cat","fas fa-cat-space","far fa-cat-space","fal fa-cat-space","fas fa-cow","far fa-cow","fal fa-cow","fas fa-crow","far fa-crow","fal fa-crow","fas fa-deer","far fa-deer","fal fa-deer","fas fa-deer-rudolph","far fa-deer-rudolph","fal fa-deer-rudolph","fas fa-dog","far fa-dog","fal fa-dog","fas fa-dog-leashed","far fa-dog-leashed","fal fa-dog-leashed","fas fa-dove","far fa-dove","fal fa-dove","fas fa-dragon","far fa-dragon","fal fa-dragon","fas fa-duck","far fa-duck","fal fa-duck","fas fa-elephant","far fa-elephant","fal fa-elephant","fas fa-feather","far fa-feather","fal fa-feather","fas fa-feather-alt","far fa-feather-alt","fal fa-feather-alt","fas fa-fish","far fa-fish","fal fa-fish","fas fa-frog","far fa-frog","fal fa-frog","fas fa-hippo","far fa-hippo","fal fa-hippo","fas fa-horse","far fa-horse","fal fa-horse","fas fa-horse-head","far fa-horse-head","fal fa-horse-head","fal fa-horse-saddle","far fa-horse-saddle","fas fa-horse-saddle","fas fa-kiwi-bird","far fa-kiwi-bird","fal fa-kiwi-bird","fas fa-monkey","far fa-monkey","fal fa-monkey","fas fa-narwhal","far fa-narwhal","fal fa-narwhal","fas fa-otter","far fa-otter","fal fa-otter","fas fa-paw","far fa-paw","fal fa-paw","fas fa-paw-alt","far fa-paw-alt","fal fa-paw-alt","fas fa-paw-claws","far fa-paw-claws","fal fa-paw-claws","fas fa-pegasus","far fa-pegasus","fal fa-pegasus","fas fa-pig","far fa-pig","fal fa-pig","fas fa-rabbit","far fa-rabbit","fal fa-rabbit","fas fa-rabbit-fast","far fa-rabbit-fast","fal fa-rabbit-fast","fas fa-ram","far fa-ram","fal fa-ram","fas fa-sheep","far fa-sheep","fal fa-sheep","fal fa-skull-cow","far fa-skull-cow","fas fa-skull-cow","fas fa-snake","far fa-snake","fal fa-snake","fas fa-spider","far fa-spider","fal fa-spider","fas fa-spider-black-widow","far fa-spider-black-widow","fal fa-spider-black-widow","fas fa-squirrel","far fa-squirrel","fal fa-squirrel","fas fa-turtle","far fa-turtle","fal fa-turtle","fas fa-unicorn","far fa-unicorn","fal fa-unicorn","fas fa-whale","far fa-whale","fal fa-whale"]},{"id":"arrows","title":"Arrows","icons":["fas fa-angle-double-down","far fa-angle-double-down","fal fa-angle-double-down","fas fa-angle-double-left","far fa-angle-double-left","fal fa-angle-double-left","fas fa-angle-double-right","far fa-angle-double-right","fal fa-angle-double-right","fas fa-angle-double-up","far fa-angle-double-up","fal fa-angle-double-up","fas fa-angle-down","far fa-angle-down","fal fa-angle-down","fas fa-angle-left","far fa-angle-left","fal fa-angle-left","fas fa-angle-right","far fa-angle-right","fal fa-angle-right","fas fa-angle-up","far fa-angle-up","fal fa-angle-up","fas fa-arrow-alt-circle-down","far fa-arrow-alt-circle-down","fal fa-arrow-alt-circle-down","fas fa-arrow-alt-circle-left","far fa-arrow-alt-circle-left","fal fa-arrow-alt-circle-left","fas fa-arrow-alt-circle-right","far fa-arrow-alt-circle-right","fal fa-arrow-alt-circle-right","fas fa-arrow-alt-circle-up","far fa-arrow-alt-circle-up","fal fa-arrow-alt-circle-up","fas fa-arrow-alt-down","far fa-arrow-alt-down","fal fa-arrow-alt-down","fas fa-arrow-alt-from-bottom","far fa-arrow-alt-from-bottom","fal fa-arrow-alt-from-bottom","fas fa-arrow-alt-from-left","far fa-arrow-alt-from-left","fal fa-arrow-alt-from-left","fas fa-arrow-alt-from-right","far fa-arrow-alt-from-right","fal fa-arrow-alt-from-right","fas fa-arrow-alt-from-top","far fa-arrow-alt-from-top","fal fa-arrow-alt-from-top","fas fa-arrow-alt-left","far fa-arrow-alt-left","fal fa-arrow-alt-left","fas fa-arrow-alt-right","far fa-arrow-alt-right","fal fa-arrow-alt-right","fas fa-arrow-alt-square-down","far fa-arrow-alt-square-down","fal fa-arrow-alt-square-down","fas fa-arrow-alt-square-left","far fa-arrow-alt-square-left","fal fa-arrow-alt-square-left","fas fa-arrow-alt-square-right","far fa-arrow-alt-square-right","fal fa-arrow-alt-square-right","fas fa-arrow-alt-square-up","far fa-arrow-alt-square-up","fal fa-arrow-alt-square-up","fas fa-arrow-alt-to-bottom","far fa-arrow-alt-to-bottom","fal fa-arrow-alt-to-bottom","fas fa-arrow-alt-to-left","far fa-arrow-alt-to-left","fal fa-arrow-alt-to-left","fas fa-arrow-alt-to-right","far fa-arrow-alt-to-right","fal fa-arrow-alt-to-right","fas fa-arrow-alt-to-top","far fa-arrow-alt-to-top","fal fa-arrow-alt-to-top","fas fa-arrow-alt-up","far fa-arrow-alt-up","fal fa-arrow-alt-up","fas fa-arrow-circle-down","far fa-arrow-circle-down","fal fa-arrow-circle-down","fas fa-arrow-circle-left","far fa-arrow-circle-left","fal fa-arrow-circle-left","fas fa-arrow-circle-right","far fa-arrow-circle-right","fal fa-arrow-circle-right","fas fa-arrow-circle-up","far fa-arrow-circle-up","fal fa-arrow-circle-up","fas fa-arrow-down","far fa-arrow-down","fal fa-arrow-down","fas fa-arrow-from-bottom","far fa-arrow-from-bottom","fal fa-arrow-from-bottom","fas fa-arrow-from-left","far fa-arrow-from-left","fal fa-arrow-from-left","fas fa-arrow-from-right","far fa-arrow-from-right","fal fa-arrow-from-right","fas fa-arrow-from-top","far fa-arrow-from-top","fal fa-arrow-from-top","fas fa-arrow-left","far fa-arrow-left","fal fa-arrow-left","fas fa-arrow-right","far fa-arrow-right","fal fa-arrow-right","fas fa-arrow-square-down","far fa-arrow-square-down","fal fa-arrow-square-down","fas fa-arrow-square-left","far fa-arrow-square-left","fal fa-arrow-square-left","fas fa-arrow-square-right","far fa-arrow-square-right","fal fa-arrow-square-right","fas fa-arrow-square-up","far fa-arrow-square-up","fal fa-arrow-square-up","fas fa-arrow-to-bottom","far fa-arrow-to-bottom","fal fa-arrow-to-bottom","fas fa-arrow-to-left","far fa-arrow-to-left","fal fa-arrow-to-left","fas fa-arrow-to-right","far fa-arrow-to-right","fal fa-arrow-to-right","fas fa-arrow-to-top","far fa-arrow-to-top","fal fa-arrow-to-top","fas fa-arrow-up","far fa-arrow-up","fal fa-arrow-up","fas fa-arrows","far fa-arrows","fal fa-arrows","fas fa-arrows-alt","far fa-arrows-alt","fal fa-arrows-alt","fas fa-arrows-alt-h","far fa-arrows-alt-h","fal fa-arrows-alt-h","fas fa-arrows-alt-v","far fa-arrows-alt-v","fal fa-arrows-alt-v","fas fa-arrows-h","far fa-arrows-h","fal fa-arrows-h","fas fa-arrows-v","far fa-arrows-v","fal fa-arrows-v","fas fa-caret-circle-down","far fa-caret-circle-down","fal fa-caret-circle-down","fas fa-caret-circle-left","far fa-caret-circle-left","fal fa-caret-circle-left","fas fa-caret-circle-right","far fa-caret-circle-right","fal fa-caret-circle-right","fas fa-caret-circle-up","far fa-caret-circle-up","fal fa-caret-circle-up","fas fa-caret-down","far fa-caret-down","fal fa-caret-down","fas fa-caret-left","far fa-caret-left","fal fa-caret-left","fas fa-caret-right","far fa-caret-right","fal fa-caret-right","fas fa-caret-square-down","far fa-caret-square-down","fal fa-caret-square-down","fas fa-caret-square-left","far fa-caret-square-left","fal fa-caret-square-left","fas fa-caret-square-right","far fa-caret-square-right","fal fa-caret-square-right","fas fa-caret-square-up","far fa-caret-square-up","fal fa-caret-square-up","fas fa-caret-up","far fa-caret-up","fal fa-caret-up","fas fa-cart-arrow-down","far fa-cart-arrow-down","fal fa-cart-arrow-down","fas fa-chart-line","far fa-chart-line","fal fa-chart-line","fas fa-chevron-circle-down","far fa-chevron-circle-down","fal fa-chevron-circle-down","fas fa-chevron-circle-left","far fa-chevron-circle-left","fal fa-chevron-circle-left","fas fa-chevron-circle-right","far fa-chevron-circle-right","fal fa-chevron-circle-right","fas fa-chevron-circle-up","far fa-chevron-circle-up","fal fa-chevron-circle-up","fas fa-chevron-double-down","far fa-chevron-double-down","fal fa-chevron-double-down","fas fa-chevron-double-left","far fa-chevron-double-left","fal fa-chevron-double-left","fas fa-chevron-double-right","far fa-chevron-double-right","fal fa-chevron-double-right","fas fa-chevron-double-up","far fa-chevron-double-up","fal fa-chevron-double-up","fas fa-chevron-down","far fa-chevron-down","fal fa-chevron-down","fas fa-chevron-left","far fa-chevron-left","fal fa-chevron-left","fas fa-chevron-right","far fa-chevron-right","fal fa-chevron-right","fas fa-chevron-square-down","far fa-chevron-square-down","fal fa-chevron-square-down","fas fa-chevron-square-left","far fa-chevron-square-left","fal fa-chevron-square-left","fas fa-chevron-square-right","far fa-chevron-square-right","fal fa-chevron-square-right","fas fa-chevron-square-up","far fa-chevron-square-up","fal fa-chevron-square-up","fas fa-chevron-up","far fa-chevron-up","fal fa-chevron-up","fas fa-cloud-download","far fa-cloud-download","fal fa-cloud-download","fas fa-cloud-download-alt","far fa-cloud-download-alt","fal fa-cloud-download-alt","fas fa-cloud-upload","far fa-cloud-upload","fal fa-cloud-upload","fas fa-cloud-upload-alt","far fa-cloud-upload-alt","fal fa-cloud-upload-alt","fas fa-compress-alt","far fa-compress-alt","fal fa-compress-alt","fas fa-compress-arrows-alt","far fa-compress-arrows-alt","fal fa-compress-arrows-alt","fas fa-download","far fa-download","fal fa-download","fas fa-exchange","far fa-exchange","fal fa-exchange","fas fa-exchange-alt","far fa-exchange-alt","fal fa-exchange-alt","fas fa-expand-alt","far fa-expand-alt","fal fa-expand-alt","fas fa-expand-arrows","far fa-expand-arrows","fal fa-expand-arrows","fas fa-expand-arrows-alt","far fa-expand-arrows-alt","fal fa-expand-arrows-alt","fas fa-external-link","far fa-external-link","fal fa-external-link","fas fa-external-link-alt","far fa-external-link-alt","fal fa-external-link-alt","fas fa-external-link-square","far fa-external-link-square","fal fa-external-link-square","fas fa-external-link-square-alt","far fa-external-link-square-alt","fal fa-external-link-square-alt","fas fa-hand-point-down","far fa-hand-point-down","fal fa-hand-point-down","fas fa-hand-point-left","far fa-hand-point-left","fal fa-hand-point-left","fas fa-hand-point-right","far fa-hand-point-right","fal fa-hand-point-right","fas fa-hand-point-up","far fa-hand-point-up","fal fa-hand-point-up","fas fa-hand-pointer","far fa-hand-pointer","fal fa-hand-pointer","fas fa-history","far fa-history","fal fa-history","fas fa-inbox-in","far fa-inbox-in","fal fa-inbox-in","fas fa-inbox-out","far fa-inbox-out","fal fa-inbox-out","fas fa-level-down","far fa-level-down","fal fa-level-down","fas fa-level-down-alt","far fa-level-down-alt","fal fa-level-down-alt","fas fa-level-up","far fa-level-up","fal fa-level-up","fas fa-level-up-alt","far fa-level-up-alt","fal fa-level-up-alt","fas fa-location-arrow","far fa-location-arrow","fal fa-location-arrow","fas fa-long-arrow-alt-down","far fa-long-arrow-alt-down","fal fa-long-arrow-alt-down","fas fa-long-arrow-alt-left","far fa-long-arrow-alt-left","fal fa-long-arrow-alt-left","fas fa-long-arrow-alt-right","far fa-long-arrow-alt-right","fal fa-long-arrow-alt-right","fas fa-long-arrow-alt-up","far fa-long-arrow-alt-up","fal fa-long-arrow-alt-up","fas fa-long-arrow-down","far fa-long-arrow-down","fal fa-long-arrow-down","fas fa-long-arrow-left","far fa-long-arrow-left","fal fa-long-arrow-left","fas fa-long-arrow-right","far fa-long-arrow-right","fal fa-long-arrow-right","fas fa-long-arrow-up","far fa-long-arrow-up","fal fa-long-arrow-up","fas fa-mouse-pointer","far fa-mouse-pointer","fal fa-mouse-pointer","fas fa-play","far fa-play","fal fa-play","fas fa-random","far fa-random","fal fa-random","fas fa-recycle","far fa-recycle","fal fa-recycle","fas fa-redo","far fa-redo","fal fa-redo","fas fa-redo-alt","far fa-redo-alt","fal fa-redo-alt","fas fa-repeat","far fa-repeat","fal fa-repeat","fas fa-repeat-1","far fa-repeat-1","fal fa-repeat-1","fas fa-repeat-1-alt","far fa-repeat-1-alt","fal fa-repeat-1-alt","fas fa-repeat-alt","far fa-repeat-alt","fal fa-repeat-alt","fas fa-reply","far fa-reply","fal fa-reply","fas fa-reply-all","far fa-reply-all","fal fa-reply-all","fas fa-retweet","far fa-retweet","fal fa-retweet","fas fa-retweet-alt","far fa-retweet-alt","fal fa-retweet-alt","fas fa-share","far fa-share","fal fa-share","fas fa-share-all","far fa-share-all","fal fa-share-all","fas fa-share-square","far fa-share-square","fal fa-share-square","fas fa-sign-in","far fa-sign-in","fal fa-sign-in","fas fa-sign-in-alt","far fa-sign-in-alt","fal fa-sign-in-alt","fas fa-sign-out","far fa-sign-out","fal fa-sign-out","fas fa-sign-out-alt","far fa-sign-out-alt","fal fa-sign-out-alt","fas fa-sort","far fa-sort","fal fa-sort","fas fa-sort-alpha-down","far fa-sort-alpha-down","fal fa-sort-alpha-down","fas fa-sort-alpha-down-alt","far fa-sort-alpha-down-alt","fal fa-sort-alpha-down-alt","fas fa-sort-alpha-up","far fa-sort-alpha-up","fal fa-sort-alpha-up","fas fa-sort-alpha-up-alt","far fa-sort-alpha-up-alt","fal fa-sort-alpha-up-alt","fas fa-sort-alt","far fa-sort-alt","fal fa-sort-alt","fas fa-sort-amount-down","far fa-sort-amount-down","fal fa-sort-amount-down","fas fa-sort-amount-down-alt","far fa-sort-amount-down-alt","fal fa-sort-amount-down-alt","fas fa-sort-amount-up","far fa-sort-amount-up","fal fa-sort-amount-up","fas fa-sort-amount-up-alt","far fa-sort-amount-up-alt","fal fa-sort-amount-up-alt","fas fa-sort-down","far fa-sort-down","fal fa-sort-down","fas fa-sort-numeric-down","far fa-sort-numeric-down","fal fa-sort-numeric-down","fas fa-sort-numeric-down-alt","far fa-sort-numeric-down-alt","fal fa-sort-numeric-down-alt","fas fa-sort-numeric-up","far fa-sort-numeric-up","fal fa-sort-numeric-up","fas fa-sort-numeric-up-alt","far fa-sort-numeric-up-alt","fal fa-sort-numeric-up-alt","fas fa-sort-shapes-down","far fa-sort-shapes-down","fal fa-sort-shapes-down","fas fa-sort-shapes-down-alt","far fa-sort-shapes-down-alt","fal fa-sort-shapes-down-alt","fas fa-sort-shapes-up","far fa-sort-shapes-up","fal fa-sort-shapes-up","fas fa-sort-shapes-up-alt","far fa-sort-shapes-up-alt","fal fa-sort-shapes-up-alt","fas fa-sort-size-down","far fa-sort-size-down","fal fa-sort-size-down","fas fa-sort-size-down-alt","far fa-sort-size-down-alt","fal fa-sort-size-down-alt","fas fa-sort-size-up","far fa-sort-size-up","fal fa-sort-size-up","fas fa-sort-size-up-alt","far fa-sort-size-up-alt","fal fa-sort-size-up-alt","fas fa-sort-up","far fa-sort-up","fal fa-sort-up","fas fa-sync","far fa-sync","fal fa-sync","fas fa-sync-alt","far fa-sync-alt","fal fa-sync-alt","fas fa-text-height","far fa-text-height","fal fa-text-height","fas fa-text-width","far fa-text-width","fal fa-text-width","fas fa-triangle","far fa-triangle","fal fa-triangle","fas fa-undo","far fa-undo","fal fa-undo","fas fa-undo-alt","far fa-undo-alt","fal fa-undo-alt","fas fa-upload","far fa-upload","fal fa-upload"]},{"id":"audio-video","title":"Audio & Video","icons":["fas fa-album","far fa-album","fal fa-album","fas fa-album-collection","far fa-album-collection","fal fa-album-collection","fal fa-amp-guitar","far fa-amp-guitar","fas fa-amp-guitar","fas fa-audio-description","far fa-audio-description","fal fa-audio-description","fas fa-backward","far fa-backward","fal fa-backward","fas fa-betamax","far fa-betamax","fal fa-betamax","fas fa-boombox","far fa-boombox","fal fa-boombox","fas fa-broadcast-tower","far fa-broadcast-tower","fal fa-broadcast-tower","fas fa-camcorder","far fa-camcorder","fal fa-camcorder","fas fa-camera-home","far fa-camera-home","fal fa-camera-home","fas fa-camera-movie","far fa-camera-movie","fal fa-camera-movie","fas fa-camera-polaroid","far fa-camera-polaroid","fal fa-camera-polaroid","fas fa-circle","far fa-circle","fal fa-circle","fas fa-closed-captioning","far fa-closed-captioning","fal fa-closed-captioning","fas fa-cloud-music","far fa-cloud-music","fal fa-cloud-music","fas fa-compress","far fa-compress","fal fa-compress","fas fa-compress-alt","far fa-compress-alt","fal fa-compress-alt","fas fa-compress-arrows-alt","far fa-compress-arrows-alt","fal fa-compress-arrows-alt","fas fa-compress-wide","far fa-compress-wide","fal fa-compress-wide","fas fa-computer-speaker","far fa-computer-speaker","fal fa-computer-speaker","fas fa-drone","far fa-drone","fal fa-drone","fas fa-drone-alt","far fa-drone-alt","fal fa-drone-alt","fas fa-eject","far fa-eject","fal fa-eject","fas fa-expand","far fa-expand","fal fa-expand","fas fa-expand-alt","far fa-expand-alt","fal fa-expand-alt","fas fa-expand-arrows","far fa-expand-arrows","fal fa-expand-arrows","fas fa-expand-arrows-alt","far fa-expand-arrows-alt","fal fa-expand-arrows-alt","fas fa-expand-wide","far fa-expand-wide","fal fa-expand-wide","fas fa-fast-backward","far fa-fast-backward","fal fa-fast-backward","fas fa-fast-forward","far fa-fast-forward","fal fa-fast-forward","fas fa-file-audio","far fa-file-audio","fal fa-file-audio","fas fa-file-video","far fa-file-video","fal fa-file-video","fas fa-film","far fa-film","fal fa-film","fas fa-film-alt","far fa-film-alt","fal fa-film-alt","fas fa-film-canister","far fa-film-canister","fal fa-film-canister","fas fa-forward","far fa-forward","fal fa-forward","fas fa-head-side-headphones","far fa-head-side-headphones","fal fa-head-side-headphones","fas fa-headphones","far fa-headphones","fal fa-headphones","fas fa-image-polaroid","far fa-image-polaroid","fal fa-image-polaroid","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-alt","far fa-microphone-alt","fal fa-microphone-alt","fas fa-microphone-alt-slash","far fa-microphone-alt-slash","fal fa-microphone-alt-slash","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-microphone-stand","far fa-microphone-stand","fal fa-microphone-stand","fas fa-mp3-player","far fa-mp3-player","fal fa-mp3-player","fas fa-music","far fa-music","fal fa-music","fas fa-pause","far fa-pause","fal fa-pause","fas fa-pause-circle","far fa-pause-circle","fal fa-pause-circle","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-photo-video","far fa-photo-video","fal fa-photo-video","fas fa-play","far fa-play","fal fa-play","fas fa-play-circle","far fa-play-circle","fal fa-play-circle","fas fa-podcast","far fa-podcast","fal fa-podcast","fas fa-projector","far fa-projector","fal fa-projector","fas fa-random","far fa-random","fal fa-random","fas fa-rectangle-landscape","far fa-rectangle-landscape","fal fa-rectangle-landscape","fas fa-rectangle-portrait","far fa-rectangle-portrait","fal fa-rectangle-portrait","fas fa-rectangle-wide","far fa-rectangle-wide","fal fa-rectangle-wide","fas fa-redo","far fa-redo","fal fa-redo","fas fa-redo-alt","far fa-redo-alt","fal fa-redo-alt","fas fa-repeat","far fa-repeat","fal fa-repeat","fas fa-repeat-1","far fa-repeat-1","fal fa-repeat-1","fas fa-repeat-1-alt","far fa-repeat-1-alt","fal fa-repeat-1-alt","fas fa-repeat-alt","far fa-repeat-alt","fal fa-repeat-alt","fas fa-rss","far fa-rss","fal fa-rss","fas fa-rss-square","far fa-rss-square","fal fa-rss-square","fas fa-scrubber","far fa-scrubber","fal fa-scrubber","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-speaker","far fa-speaker","fal fa-speaker","fas fa-speakers","far fa-speakers","fal fa-speakers","fas fa-step-backward","far fa-step-backward","fal fa-step-backward","fas fa-step-forward","far fa-step-forward","fal fa-step-forward","fas fa-stop","far fa-stop","fal fa-stop","fas fa-stop-circle","far fa-stop-circle","fal fa-stop-circle","fas fa-sync","far fa-sync","fal fa-sync","fas fa-sync-alt","far fa-sync-alt","fal fa-sync-alt","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-alt","far fa-tv-alt","fal fa-tv-alt","fas fa-undo","far fa-undo","fal fa-undo","fas fa-undo-alt","far fa-undo-alt","fal fa-undo-alt","fas fa-vhs","far fa-vhs","fal fa-vhs","fas fa-video","far fa-video","fal fa-video","fas fa-volume","far fa-volume","fal fa-volume","fas fa-volume-down","far fa-volume-down","fal fa-volume-down","fas fa-volume-mute","far fa-volume-mute","fal fa-volume-mute","fas fa-volume-off","far fa-volume-off","fal fa-volume-off","fas fa-volume-slash","far fa-volume-slash","fal fa-volume-slash","fas fa-volume-up","far fa-volume-up","fal fa-volume-up","fas fa-waveform","far fa-waveform","fal fa-waveform","fas fa-waveform-path","far fa-waveform-path","fal fa-waveform-path","fas fa-webcam","far fa-webcam","fal fa-webcam","fas fa-webcam-slash","far fa-webcam-slash","fal fa-webcam-slash","fab fa-youtube"]},{"id":"automotive","title":"Automotive","icons":["fas fa-air-freshener","far fa-air-freshener","fal fa-air-freshener","fas fa-ambulance","far fa-ambulance","fal fa-ambulance","fas fa-bus","far fa-bus","fal fa-bus","fas fa-bus-alt","far fa-bus-alt","fal fa-bus-alt","fas fa-car","far fa-car","fal fa-car","fas fa-car-alt","far fa-car-alt","fal fa-car-alt","fas fa-car-battery","far fa-car-battery","fal fa-car-battery","fas fa-car-building","far fa-car-building","fal fa-car-building","fas fa-car-bump","far fa-car-bump","fal fa-car-bump","fas fa-car-bus","far fa-car-bus","fal fa-car-bus","fas fa-car-crash","far fa-car-crash","fal fa-car-crash","fas fa-car-garage","far fa-car-garage","fal fa-car-garage","fas fa-car-mechanic","far fa-car-mechanic","fal fa-car-mechanic","fas fa-car-side","far fa-car-side","fal fa-car-side","fas fa-car-tilt","far fa-car-tilt","fal fa-car-tilt","fas fa-car-wash","far fa-car-wash","fal fa-car-wash","fas fa-caravan","far fa-caravan","fal fa-caravan","fas fa-caravan-alt","far fa-caravan-alt","fal fa-caravan-alt","fas fa-cars","far fa-cars","fal fa-cars","fas fa-charging-station","far fa-charging-station","fal fa-charging-station","fas fa-engine-warning","far fa-engine-warning","fal fa-engine-warning","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-garage","far fa-garage","fal fa-garage","fas fa-garage-car","far fa-garage-car","fal fa-garage-car","fas fa-garage-open","far fa-garage-open","fal fa-garage-open","fas fa-gas-pump","far fa-gas-pump","fal fa-gas-pump","fas fa-gas-pump-slash","far fa-gas-pump-slash","fal fa-gas-pump-slash","fas fa-motorcycle","far fa-motorcycle","fal fa-motorcycle","fas fa-oil-can","far fa-oil-can","fal fa-oil-can","fas fa-oil-temp","far fa-oil-temp","fal fa-oil-temp","fas fa-rv","far fa-rv","fal fa-rv","fas fa-shuttle-van","far fa-shuttle-van","fal fa-shuttle-van","fas fa-steering-wheel","far fa-steering-wheel","fal fa-steering-wheel","fas fa-tachometer","far fa-tachometer","fal fa-tachometer","fas fa-tachometer-alt","far fa-tachometer-alt","fal fa-tachometer-alt","fas fa-tachometer-alt-average","far fa-tachometer-alt-average","fal fa-tachometer-alt-average","fas fa-tachometer-alt-fast","far fa-tachometer-alt-fast","fal fa-tachometer-alt-fast","fas fa-tachometer-alt-fastest","far fa-tachometer-alt-fastest","fal fa-tachometer-alt-fastest","fas fa-tachometer-alt-slow","far fa-tachometer-alt-slow","fal fa-tachometer-alt-slow","fas fa-tachometer-alt-slowest","far fa-tachometer-alt-slowest","fal fa-tachometer-alt-slowest","fas fa-tachometer-average","far fa-tachometer-average","fal fa-tachometer-average","fas fa-tachometer-fast","far fa-tachometer-fast","fal fa-tachometer-fast","fas fa-tachometer-fastest","far fa-tachometer-fastest","fal fa-tachometer-fastest","fas fa-tachometer-slow","far fa-tachometer-slow","fal fa-tachometer-slow","fas fa-tachometer-slowest","far fa-tachometer-slowest","fal fa-tachometer-slowest","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-tire","far fa-tire","fal fa-tire","fas fa-tire-flat","far fa-tire-flat","fal fa-tire-flat","fas fa-tire-pressure-warning","far fa-tire-pressure-warning","fal fa-tire-pressure-warning","fas fa-tire-rugged","far fa-tire-rugged","fal fa-tire-rugged","fas fa-trailer","far fa-trailer","fal fa-trailer","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-monster","far fa-truck-monster","fal fa-truck-monster","fas fa-truck-pickup","far fa-truck-pickup","fal fa-truck-pickup","fal fa-wagon-covered","far fa-wagon-covered","fas fa-wagon-covered"]},{"id":"autumn","title":"Autumn","icons":["fas fa-acorn","far fa-acorn","fal fa-acorn","fas fa-apple-alt","far fa-apple-alt","fal fa-apple-alt","fas fa-apple-crate","far fa-apple-crate","fal fa-apple-crate","fas fa-axe","far fa-axe","fal fa-axe","fas fa-campfire","far fa-campfire","fal fa-campfire","fas fa-campground","far fa-campground","fal fa-campground","fas fa-cloud-sun","far fa-cloud-sun","fal fa-cloud-sun","fas fa-coffee-togo","far fa-coffee-togo","fal fa-coffee-togo","fas fa-corn","far fa-corn","fal fa-corn","fas fa-drumstick","far fa-drumstick","fal fa-drumstick","fas fa-drumstick-bite","far fa-drumstick-bite","fal fa-drumstick-bite","fas fa-football-ball","far fa-football-ball","fal fa-football-ball","fas fa-hiking","far fa-hiking","fal fa-hiking","fas fa-kite","far fa-kite","fal fa-kite","fas fa-leaf-maple","far fa-leaf-maple","fal fa-leaf-maple","fas fa-leaf-oak","far fa-leaf-oak","fal fa-leaf-oak","fas fa-mountain","far fa-mountain","fal fa-mountain","fas fa-mountains","far fa-mountains","fal fa-mountains","fas fa-mug-tea","far fa-mug-tea","fal fa-mug-tea","fas fa-pie","far fa-pie","fal fa-pie","fas fa-pumpkin","far fa-pumpkin","fal fa-pumpkin","fas fa-shovel","far fa-shovel","fal fa-shovel","fas fa-squirrel","far fa-squirrel","fal fa-squirrel","fas fa-tractor","far fa-tractor","fal fa-tractor","fas fa-tree","far fa-tree","fal fa-tree","fas fa-tree-alt","far fa-tree-alt","fal fa-tree-alt","fas fa-trees","far fa-trees","fal fa-trees","fas fa-turkey","far fa-turkey","fal fa-turkey","fas fa-wheat","far fa-wheat","fal fa-wheat","fas fa-wind","far fa-wind","fal fa-wind","fas fa-wine-bottle","far fa-wine-bottle","fal fa-wine-bottle"]},{"id":"beverage","title":"Beverage","icons":["fas fa-beer","far fa-beer","fal fa-beer","fas fa-blender","far fa-blender","fal fa-blender","fas fa-burger-soda","far fa-burger-soda","fal fa-burger-soda","fas fa-cocktail","far fa-cocktail","fal fa-cocktail","fas fa-coffee","far fa-coffee","fal fa-coffee","fas fa-coffee-pot","far fa-coffee-pot","fal fa-coffee-pot","fas fa-coffee-togo","far fa-coffee-togo","fal fa-coffee-togo","fas fa-flask","far fa-flask","fal fa-flask","fas fa-flask-poison","far fa-flask-poison","fal fa-flask-poison","fas fa-flask-potion","far fa-flask-potion","fal fa-flask-potion","fas fa-glass","far fa-glass","fal fa-glass","fas fa-glass-champagne","far fa-glass-champagne","fal fa-glass-champagne","fas fa-glass-cheers","far fa-glass-cheers","fal fa-glass-cheers","fas fa-glass-citrus","far fa-glass-citrus","fal fa-glass-citrus","fas fa-glass-martini","far fa-glass-martini","fal fa-glass-martini","fas fa-glass-martini-alt","far fa-glass-martini-alt","fal fa-glass-martini-alt","fas fa-glass-whiskey","far fa-glass-whiskey","fal fa-glass-whiskey","fas fa-glass-whiskey-rocks","far fa-glass-whiskey-rocks","fal fa-glass-whiskey-rocks","fal fa-jug","far fa-jug","fas fa-jug","fas fa-mug","far fa-mug","fal fa-mug","fas fa-mug-hot","far fa-mug-hot","fal fa-mug-hot","fas fa-mug-marshmallows","far fa-mug-marshmallows","fal fa-mug-marshmallows","fas fa-mug-tea","far fa-mug-tea","fal fa-mug-tea","fas fa-wine-bottle","far fa-wine-bottle","fal fa-wine-bottle","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass","fas fa-wine-glass-alt","far fa-wine-glass-alt","fal fa-wine-glass-alt"]},{"id":"buildings","title":"Buildings","icons":["fas fa-archway","far fa-archway","fal fa-archway","fas fa-building","far fa-building","fal fa-building","fas fa-campground","far fa-campground","fal fa-campground","fas fa-car-building","far fa-car-building","fal fa-car-building","fas fa-chimney","far fa-chimney","fal fa-chimney","fas fa-church","far fa-church","fal fa-church","fas fa-city","far fa-city","fal fa-city","fas fa-clinic-medical","far fa-clinic-medical","fal fa-clinic-medical","fas fa-container-storage","far fa-container-storage","fal fa-container-storage","fas fa-dungeon","far fa-dungeon","fal fa-dungeon","fas fa-farm","far fa-farm","fal fa-farm","fas fa-garage","far fa-garage","fal fa-garage","fas fa-garage-car","far fa-garage-car","fal fa-garage-car","fas fa-garage-open","far fa-garage-open","fal fa-garage-open","fas fa-gopuram","far fa-gopuram","fal fa-gopuram","fas fa-home","far fa-home","fal fa-home","fas fa-home-alt","far fa-home-alt","fal fa-home-alt","fas fa-home-lg","far fa-home-lg","fal fa-home-lg","fas fa-home-lg-alt","far fa-home-lg-alt","fal fa-home-lg-alt","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-hospital-alt","far fa-hospital-alt","fal fa-hospital-alt","fas fa-hospital-user","far fa-hospital-user","fal fa-hospital-user","fas fa-hospitals","far fa-hospitals","fal fa-hospitals","fas fa-hotel","far fa-hotel","fal fa-hotel","fas fa-house","far fa-house","fal fa-house","fas fa-house-damage","far fa-house-damage","fal fa-house-damage","fas fa-house-day","far fa-house-day","fal fa-house-day","fas fa-house-flood","far fa-house-flood","fal fa-house-flood","fas fa-house-night","far fa-house-night","fal fa-house-night","fas fa-igloo","far fa-igloo","fal fa-igloo","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-alt","far fa-industry-alt","fal fa-industry-alt","fas fa-kaaba","far fa-kaaba","fal fa-kaaba","fas fa-landmark","far fa-landmark","fal fa-landmark","fas fa-landmark-alt","far fa-landmark-alt","fal fa-landmark-alt","fas fa-monument","far fa-monument","fal fa-monument","fas fa-mosque","far fa-mosque","fal fa-mosque","fas fa-place-of-worship","far fa-place-of-worship","fal fa-place-of-worship","fas fa-school","far fa-school","fal fa-school","fas fa-store","far fa-store","fal fa-store","fas fa-store-alt","far fa-store-alt","fal fa-store-alt","fas fa-synagogue","far fa-synagogue","fal fa-synagogue","fas fa-torii-gate","far fa-torii-gate","fal fa-torii-gate","fas fa-university","far fa-university","fal fa-university","fas fa-vihara","far fa-vihara","fal fa-vihara","fas fa-warehouse","far fa-warehouse","fal fa-warehouse","fas fa-warehouse-alt","far fa-warehouse-alt","fal fa-warehouse-alt"]},{"id":"business","title":"Business","icons":["fas fa-address-book","far fa-address-book","fal fa-address-book","fas fa-address-card","far fa-address-card","fal fa-address-card","fas fa-archive","far fa-archive","fal fa-archive","fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-badge-dollar","far fa-badge-dollar","fal fa-badge-dollar","fas fa-badge-percent","far fa-badge-percent","fal fa-badge-percent","fas fa-balance-scale","far fa-balance-scale","fal fa-balance-scale","fas fa-balance-scale-left","far fa-balance-scale-left","fal fa-balance-scale-left","fas fa-balance-scale-right","far fa-balance-scale-right","fal fa-balance-scale-right","fas fa-birthday-cake","far fa-birthday-cake","fal fa-birthday-cake","fas fa-book","far fa-book","fal fa-book","fas fa-briefcase","far fa-briefcase","fal fa-briefcase","fas fa-building","far fa-building","fal fa-building","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-bullseye","far fa-bullseye","fal fa-bullseye","fas fa-business-time","far fa-business-time","fal fa-business-time","fas fa-cabinet-filing","far fa-cabinet-filing","fal fa-cabinet-filing","fas fa-calculator","far fa-calculator","fal fa-calculator","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-calendar-alt","far fa-calendar-alt","fal fa-calendar-alt","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-chart-area","far fa-chart-area","fal fa-chart-area","fas fa-chart-bar","far fa-chart-bar","fal fa-chart-bar","fas fa-chart-line","far fa-chart-line","fal fa-chart-line","fas fa-chart-line-down","far fa-chart-line-down","fal fa-chart-line-down","fas fa-chart-network","far fa-chart-network","fal fa-chart-network","fas fa-chart-pie","far fa-chart-pie","fal fa-chart-pie","fas fa-chart-pie-alt","far fa-chart-pie-alt","fal fa-chart-pie-alt","fas fa-chart-scatter","far fa-chart-scatter","fal fa-chart-scatter","fas fa-city","far fa-city","fal fa-city","fas fa-clipboard","far fa-clipboard","fal fa-clipboard","fas fa-coffee","far fa-coffee","fal fa-coffee","fas fa-coffee-pot","far fa-coffee-pot","fal fa-coffee-pot","fas fa-columns","far fa-columns","fal fa-columns","fas fa-compass","far fa-compass","fal fa-compass","fas fa-computer-classic","far fa-computer-classic","fal fa-computer-classic","fas fa-copy","far fa-copy","fal fa-copy","fas fa-copyright","far fa-copyright","fal fa-copyright","fas fa-cut","far fa-cut","fal fa-cut","fas fa-edit","far fa-edit","fal fa-edit","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-open","far fa-envelope-open","fal fa-envelope-open","fas fa-envelope-square","far fa-envelope-square","fal fa-envelope-square","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-fax","far fa-fax","fal fa-fax","fas fa-file","far fa-file","fal fa-file","fas fa-file-alt","far fa-file-alt","fal fa-file-alt","fas fa-file-chart-line","far fa-file-chart-line","fal fa-file-chart-line","fas fa-file-chart-pie","far fa-file-chart-pie","fal fa-file-chart-pie","fas fa-file-spreadsheet","far fa-file-spreadsheet","fal fa-file-spreadsheet","fas fa-file-user","far fa-file-user","fal fa-file-user","fas fa-folder","far fa-folder","fal fa-folder","fal fa-folder-download","far fa-folder-download","fas fa-folder-download","fas fa-folder-minus","far fa-folder-minus","fal fa-folder-minus","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-folder-plus","far fa-folder-plus","fal fa-folder-plus","fas fa-folder-times","far fa-folder-times","fal fa-folder-times","fas fa-folder-tree","far fa-folder-tree","fal fa-folder-tree","fal fa-folder-upload","far fa-folder-upload","fas fa-folder-upload","fas fa-folders","far fa-folders","fal fa-folders","fas fa-glasses","far fa-glasses","fal fa-glasses","fas fa-globe","far fa-globe","fal fa-globe","fas fa-highlighter","far fa-highlighter","fal fa-highlighter","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-alt","far fa-industry-alt","fal fa-industry-alt","fas fa-keynote","far fa-keynote","fal fa-keynote","fas fa-lamp-desk","far fa-lamp-desk","fal fa-lamp-desk","fas fa-landmark","far fa-landmark","fal fa-landmark","fal fa-laptop-house","far fa-laptop-house","fas fa-laptop-house","fas fa-marker","far fa-marker","fal fa-marker","fas fa-mind-share","far fa-mind-share","fal fa-mind-share","fas fa-money-check-edit","far fa-money-check-edit","fal fa-money-check-edit","fas fa-money-check-edit-alt","far fa-money-check-edit-alt","fal fa-money-check-edit-alt","fas fa-paperclip","far fa-paperclip","fal fa-paperclip","fas fa-paste","far fa-paste","fal fa-paste","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-alt","far fa-pen-alt","fal fa-pen-alt","fas fa-pen-fancy","far fa-pen-fancy","fal fa-pen-fancy","fas fa-pen-nib","far fa-pen-nib","fal fa-pen-nib","fas fa-pen-square","far fa-pen-square","fal fa-pen-square","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-alt","far fa-pencil-alt","fal fa-pencil-alt","fas fa-percent","far fa-percent","fal fa-percent","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-alt","far fa-phone-alt","fal fa-phone-alt","fas fa-phone-office","far fa-phone-office","fal fa-phone-office","fas fa-phone-slash","far fa-phone-slash","fal fa-phone-slash","fas fa-phone-square","far fa-phone-square","fal fa-phone-square","fas fa-phone-square-alt","far fa-phone-square-alt","fal fa-phone-square-alt","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-podium","far fa-podium","fal fa-podium","fas fa-presentation","far fa-presentation","fal fa-presentation","fas fa-print","far fa-print","fal fa-print","fas fa-print-slash","far fa-print-slash","fal fa-print-slash","fas fa-project-diagram","far fa-project-diagram","fal fa-project-diagram","fas fa-projector","far fa-projector","fal fa-projector","fas fa-registered","far fa-registered","fal fa-registered","fas fa-router","far fa-router","fal fa-router","fas fa-save","far fa-save","fal fa-save","fas fa-scanner-image","far fa-scanner-image","fal fa-scanner-image","fas fa-shredder","far fa-shredder","fal fa-shredder","fas fa-sitemap","far fa-sitemap","fal fa-sitemap","fas fa-socks","far fa-socks","fal fa-socks","fas fa-sticky-note","far fa-sticky-note","fal fa-sticky-note","fas fa-stream","far fa-stream","fal fa-stream","fas fa-table","far fa-table","fal fa-table","fas fa-tag","far fa-tag","fal fa-tag","fas fa-tags","far fa-tags","fal fa-tags","fas fa-tasks","far fa-tasks","fal fa-tasks","fas fa-tasks-alt","far fa-tasks-alt","fal fa-tasks-alt","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack","fas fa-trademark","far fa-trademark","fal fa-trademark","fas fa-user-chart","far fa-user-chart","fal fa-user-chart","fas fa-wallet","far fa-wallet","fal fa-wallet"]},{"id":"camping","title":"Camping","icons":["fas fa-acorn","far fa-acorn","fal fa-acorn","fas fa-axe","far fa-axe","fal fa-axe","fas fa-backpack","far fa-backpack","fal fa-backpack","fas fa-biking-mountain","far fa-biking-mountain","fal fa-biking-mountain","fas fa-binoculars","far fa-binoculars","fal fa-binoculars","fas fa-boot","far fa-boot","fal fa-boot","fas fa-campfire","far fa-campfire","fal fa-campfire","fas fa-campground","far fa-campground","fal fa-campground","fas fa-caravan","far fa-caravan","fal fa-caravan","fas fa-caravan-alt","far fa-caravan-alt","fal fa-caravan-alt","fas fa-cauldron","far fa-cauldron","fal fa-cauldron","fas fa-compass","far fa-compass","fal fa-compass","fas fa-faucet","far fa-faucet","fal fa-faucet","fas fa-faucet-drip","far fa-faucet-drip","fal fa-faucet-drip","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-alt","far fa-fire-alt","fal fa-fire-alt","fas fa-fire-smoke","far fa-fire-smoke","fal fa-fire-smoke","fas fa-first-aid","far fa-first-aid","fal fa-first-aid","fas fa-flashlight","far fa-flashlight","fal fa-flashlight","fas fa-frog","far fa-frog","fal fa-frog","fas fa-hiking","far fa-hiking","fal fa-hiking","fas fa-map","far fa-map","fal fa-map","fas fa-map-marked","far fa-map-marked","fal fa-map-marked","fas fa-map-marked-alt","far fa-map-marked-alt","fal fa-map-marked-alt","fas fa-map-signs","far fa-map-signs","fal fa-map-signs","fas fa-mountain","far fa-mountain","fal fa-mountain","fas fa-mountains","far fa-mountains","fal fa-mountains","fas fa-route","far fa-route","fal fa-route","fas fa-rv","far fa-rv","fal fa-rv","fas fa-shish-kebab","far fa-shish-kebab","fal fa-shish-kebab","fas fa-shovel","far fa-shovel","fal fa-shovel","fas fa-squirrel","far fa-squirrel","fal fa-squirrel","fas fa-sunrise","far fa-sunrise","fal fa-sunrise","fas fa-sunset","far fa-sunset","fal fa-sunset","fas fa-toilet-paper","far fa-toilet-paper","fal fa-toilet-paper","fas fa-toilet-paper-alt","far fa-toilet-paper-alt","fal fa-toilet-paper-alt","fas fa-trailer","far fa-trailer","fal fa-trailer","fas fa-tree","far fa-tree","fal fa-tree","fas fa-tree-alt","far fa-tree-alt","fal fa-tree-alt","fas fa-tree-large","far fa-tree-large","fal fa-tree-large","fas fa-trees","far fa-trees","fal fa-trees"]},{"id":"charity","title":"Charity","icons":["fas fa-book-heart","far fa-book-heart","fal fa-book-heart","fas fa-box-heart","far fa-box-heart","fal fa-box-heart","fas fa-box-usd","far fa-box-usd","fal fa-box-usd","fas fa-dollar-sign","far fa-dollar-sign","fal fa-dollar-sign","fas fa-donate","far fa-donate","fal fa-donate","fas fa-dove","far fa-dove","fal fa-dove","fas fa-gift","far fa-gift","fal fa-gift","fas fa-globe","far fa-globe","fal fa-globe","fas fa-hand-heart","far fa-hand-heart","fal fa-hand-heart","fas fa-hand-holding-heart","far fa-hand-holding-heart","fal fa-hand-holding-heart","fas fa-hand-holding-seedling","far fa-hand-holding-seedling","fal fa-hand-holding-seedling","fas fa-hand-holding-usd","far fa-hand-holding-usd","fal fa-hand-holding-usd","fas fa-hand-holding-water","far fa-hand-holding-water","fal fa-hand-holding-water","fas fa-hands-heart","far fa-hands-heart","fal fa-hands-heart","fas fa-hands-helping","far fa-hands-helping","fal fa-hands-helping","fas fa-hands-usd","far fa-hands-usd","fal fa-hands-usd","fas fa-handshake","far fa-handshake","fal fa-handshake","fas fa-handshake-alt","far fa-handshake-alt","fal fa-handshake-alt","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-circle","far fa-heart-circle","fal fa-heart-circle","fas fa-heart-square","far fa-heart-square","fal fa-heart-square","fas fa-home-heart","far fa-home-heart","fal fa-home-heart","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-leaf-heart","far fa-leaf-heart","fal fa-leaf-heart","fas fa-money-check-edit","far fa-money-check-edit","fal fa-money-check-edit","fas fa-money-check-edit-alt","far fa-money-check-edit-alt","fal fa-money-check-edit-alt","fas fa-parachute-box","far fa-parachute-box","fal fa-parachute-box","fas fa-piggy-bank","far fa-piggy-bank","fal fa-piggy-bank","fas fa-ribbon","far fa-ribbon","fal fa-ribbon","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-usd-circle","far fa-usd-circle","fal fa-usd-circle","fas fa-usd-square","far fa-usd-square","fal fa-usd-square"]},{"id":"chat","title":"Chat","icons":["fas fa-comment","far fa-comment","fal fa-comment","fas fa-comment-alt","far fa-comment-alt","fal fa-comment-alt","fas fa-comment-alt-check","far fa-comment-alt-check","fal fa-comment-alt-check","fas fa-comment-alt-dots","far fa-comment-alt-dots","fal fa-comment-alt-dots","fas fa-comment-alt-edit","far fa-comment-alt-edit","fal fa-comment-alt-edit","fas fa-comment-alt-exclamation","far fa-comment-alt-exclamation","fal fa-comment-alt-exclamation","fas fa-comment-alt-lines","far fa-comment-alt-lines","fal fa-comment-alt-lines","fas fa-comment-alt-medical","far fa-comment-alt-medical","fal fa-comment-alt-medical","fas fa-comment-alt-minus","far fa-comment-alt-minus","fal fa-comment-alt-minus","fas fa-comment-alt-plus","far fa-comment-alt-plus","fal fa-comment-alt-plus","fas fa-comment-alt-slash","far fa-comment-alt-slash","fal fa-comment-alt-slash","fas fa-comment-alt-smile","far fa-comment-alt-smile","fal fa-comment-alt-smile","fas fa-comment-alt-times","far fa-comment-alt-times","fal fa-comment-alt-times","fas fa-comment-check","far fa-comment-check","fal fa-comment-check","fas fa-comment-dots","far fa-comment-dots","fal fa-comment-dots","fas fa-comment-edit","far fa-comment-edit","fal fa-comment-edit","fas fa-comment-exclamation","far fa-comment-exclamation","fal fa-comment-exclamation","fas fa-comment-lines","far fa-comment-lines","fal fa-comment-lines","fas fa-comment-medical","far fa-comment-medical","fal fa-comment-medical","fas fa-comment-minus","far fa-comment-minus","fal fa-comment-minus","fas fa-comment-music","far fa-comment-music","fal fa-comment-music","fas fa-comment-plus","far fa-comment-plus","fal fa-comment-plus","fas fa-comment-slash","far fa-comment-slash","fal fa-comment-slash","fas fa-comment-smile","far fa-comment-smile","fal fa-comment-smile","fas fa-comment-times","far fa-comment-times","fal fa-comment-times","fas fa-comments","far fa-comments","fal fa-comments","fas fa-comments-alt","far fa-comments-alt","fal fa-comments-alt","fas fa-frown","far fa-frown","fal fa-frown","fas fa-icons","far fa-icons","fal fa-icons","fas fa-icons-alt","far fa-icons-alt","fal fa-icons-alt","fas fa-meh","far fa-meh","fal fa-meh","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-alt","far fa-phone-alt","fal fa-phone-alt","fas fa-phone-plus","far fa-phone-plus","fal fa-phone-plus","fas fa-phone-slash","far fa-phone-slash","fal fa-phone-slash","fas fa-poo","far fa-poo","fal fa-poo","fas fa-quote-left","far fa-quote-left","fal fa-quote-left","fas fa-quote-right","far fa-quote-right","fal fa-quote-right","fas fa-smile","far fa-smile","fal fa-smile","fas fa-smile-plus","far fa-smile-plus","fal fa-smile-plus","fas fa-sms","far fa-sms","fal fa-sms","fas fa-video","far fa-video","fal fa-video","fas fa-video-plus","far fa-video-plus","fal fa-video-plus","fas fa-video-slash","far fa-video-slash","fal fa-video-slash"]},{"id":"chess","title":"Chess","icons":["fas fa-chess","far fa-chess","fal fa-chess","fas fa-chess-bishop","far fa-chess-bishop","fal fa-chess-bishop","fas fa-chess-bishop-alt","far fa-chess-bishop-alt","fal fa-chess-bishop-alt","fas fa-chess-board","far fa-chess-board","fal fa-chess-board","fas fa-chess-clock","far fa-chess-clock","fal fa-chess-clock","fas fa-chess-clock-alt","far fa-chess-clock-alt","fal fa-chess-clock-alt","fas fa-chess-king","far fa-chess-king","fal fa-chess-king","fas fa-chess-king-alt","far fa-chess-king-alt","fal fa-chess-king-alt","fas fa-chess-knight","far fa-chess-knight","fal fa-chess-knight","fas fa-chess-knight-alt","far fa-chess-knight-alt","fal fa-chess-knight-alt","fas fa-chess-pawn","far fa-chess-pawn","fal fa-chess-pawn","fas fa-chess-pawn-alt","far fa-chess-pawn-alt","fal fa-chess-pawn-alt","fas fa-chess-queen","far fa-chess-queen","fal fa-chess-queen","fas fa-chess-queen-alt","far fa-chess-queen-alt","fal fa-chess-queen-alt","fas fa-chess-rook","far fa-chess-rook","fal fa-chess-rook","fas fa-chess-rook-alt","far fa-chess-rook-alt","fal fa-chess-rook-alt","fas fa-game-board","far fa-game-board","fal fa-game-board","fas fa-game-board-alt","far fa-game-board-alt","fal fa-game-board-alt","fas fa-square-full","far fa-square-full","fal fa-square-full"]},{"id":"childhood","title":"Childhood","icons":["fas fa-apple-alt","far fa-apple-alt","fal fa-apple-alt","fas fa-baby","far fa-baby","fal fa-baby","fas fa-baby-carriage","far fa-baby-carriage","fal fa-baby-carriage","fas fa-backpack","far fa-backpack","fal fa-backpack","fas fa-baseball","far fa-baseball","fal fa-baseball","fas fa-basketball-hoop","far fa-basketball-hoop","fal fa-basketball-hoop","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bell-school","far fa-bell-school","fal fa-bell-school","fas fa-bell-school-slash","far fa-bell-school-slash","fal fa-bell-school-slash","fas fa-biking","far fa-biking","fal fa-biking","fas fa-birthday-cake","far fa-birthday-cake","fal fa-birthday-cake","fas fa-cookie","far fa-cookie","fal fa-cookie","fas fa-cookie-bite","far fa-cookie-bite","fal fa-cookie-bite","fas fa-duck","far fa-duck","fal fa-duck","fas fa-flashlight","far fa-flashlight","fal fa-flashlight","fas fa-game-console-handheld","far fa-game-console-handheld","fal fa-game-console-handheld","fas fa-gamepad","far fa-gamepad","fal fa-gamepad","fas fa-gamepad-alt","far fa-gamepad-alt","fal fa-gamepad-alt","fas fa-globe-snow","far fa-globe-snow","fal fa-globe-snow","fas fa-ice-cream","far fa-ice-cream","fal fa-ice-cream","fas fa-mitten","far fa-mitten","fal fa-mitten","fas fa-robot","far fa-robot","fal fa-robot","fas fa-school","far fa-school","fal fa-school","fas fa-shapes","far fa-shapes","fal fa-shapes","fas fa-snowman","far fa-snowman","fal fa-snowman"]},{"id":"clothing","title":"Clothing","icons":["fas fa-boot","far fa-boot","fal fa-boot","fas fa-graduation-cap","far fa-graduation-cap","fal fa-graduation-cap","fal fa-hat-cowboy","far fa-hat-cowboy","fas fa-hat-cowboy","fal fa-hat-cowboy-side","far fa-hat-cowboy-side","fas fa-hat-cowboy-side","fas fa-hat-santa","far fa-hat-santa","fal fa-hat-santa","fas fa-hat-winter","far fa-hat-winter","fal fa-hat-winter","fas fa-hat-witch","far fa-hat-witch","fal fa-hat-witch","fas fa-hat-wizard","far fa-hat-wizard","fal fa-hat-wizard","fas fa-hood-cloak","far fa-hood-cloak","fal fa-hood-cloak","fas fa-ice-skate","far fa-ice-skate","fal fa-ice-skate","fas fa-mitten","far fa-mitten","fal fa-mitten","fas fa-scarf","far fa-scarf","fal fa-scarf","fas fa-shoe-prints","far fa-shoe-prints","fal fa-shoe-prints","fas fa-socks","far fa-socks","fal fa-socks","fas fa-stocking","far fa-stocking","fal fa-stocking","fas fa-tshirt","far fa-tshirt","fal fa-tshirt","fas fa-user-tie","far fa-user-tie","fal fa-user-tie"]},{"id":"code","title":"Code","icons":["fas fa-archive","far fa-archive","fal fa-archive","fas fa-barcode","far fa-barcode","fal fa-barcode","fas fa-bath","far fa-bath","fal fa-bath","fas fa-brackets","far fa-brackets","fal fa-brackets","fas fa-brackets-curly","far fa-brackets-curly","fal fa-brackets-curly","fas fa-browser","far fa-browser","fal fa-browser","fas fa-bug","far fa-bug","fal fa-bug","fas fa-code","far fa-code","fal fa-code","fas fa-code-branch","far fa-code-branch","fal fa-code-branch","fas fa-code-commit","far fa-code-commit","fal fa-code-commit","fas fa-code-merge","far fa-code-merge","fal fa-code-merge","fas fa-coffee","far fa-coffee","fal fa-coffee","fas fa-file","far fa-file","fal fa-file","fas fa-file-alt","far fa-file-alt","fal fa-file-alt","fas fa-file-code","far fa-file-code","fal fa-file-code","fas fa-filter","far fa-filter","fal fa-filter","fas fa-fire-extinguisher","far fa-fire-extinguisher","fal fa-fire-extinguisher","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-keyboard","far fa-keyboard","fal fa-keyboard","fas fa-laptop-code","far fa-laptop-code","fal fa-laptop-code","fas fa-microchip","far fa-microchip","fal fa-microchip","fas fa-phone-laptop","far fa-phone-laptop","fal fa-phone-laptop","fas fa-project-diagram","far fa-project-diagram","fal fa-project-diagram","fas fa-qrcode","far fa-qrcode","fal fa-qrcode","fas fa-shield","far fa-shield","fal fa-shield","fas fa-shield-alt","far fa-shield-alt","fal fa-shield-alt","fas fa-shield-check","far fa-shield-check","fal fa-shield-check","fas fa-sitemap","far fa-sitemap","fal fa-sitemap","fas fa-stream","far fa-stream","fal fa-stream","fas fa-terminal","far fa-terminal","fal fa-terminal","fas fa-user-secret","far fa-user-secret","fal fa-user-secret","fas fa-window","far fa-window","fal fa-window","fas fa-window-alt","far fa-window-alt","fal fa-window-alt","fas fa-window-close","far fa-window-close","fal fa-window-close","fas fa-window-maximize","far fa-window-maximize","fal fa-window-maximize","fas fa-window-minimize","far fa-window-minimize","fal fa-window-minimize","fas fa-window-restore","far fa-window-restore","fal fa-window-restore"]},{"id":"communication","title":"Communication","icons":["fas fa-address-book","far fa-address-book","fal fa-address-book","fas fa-address-card","far fa-address-card","fal fa-address-card","fas fa-american-sign-language-interpreting","far fa-american-sign-language-interpreting","fal fa-american-sign-language-interpreting","fas fa-assistive-listening-systems","far fa-assistive-listening-systems","fal fa-assistive-listening-systems","fas fa-at","far fa-at","fal fa-at","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-exclamation","far fa-bell-exclamation","fal fa-bell-exclamation","fas fa-bell-plus","far fa-bell-plus","fal fa-bell-plus","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fab fa-bluetooth","fab fa-bluetooth-b","fas fa-broadcast-tower","far fa-broadcast-tower","fal fa-broadcast-tower","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-chalkboard","far fa-chalkboard","fal fa-chalkboard","fas fa-comment","far fa-comment","fal fa-comment","fas fa-comment-alt","far fa-comment-alt","fal fa-comment-alt","fas fa-comments","far fa-comments","fal fa-comments","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-open","far fa-envelope-open","fal fa-envelope-open","fas fa-envelope-square","far fa-envelope-square","fal fa-envelope-square","fas fa-fax","far fa-fax","fal fa-fax","fas fa-inbox","far fa-inbox","fal fa-inbox","fas fa-inbox-in","far fa-inbox-in","fal fa-inbox-in","fas fa-inbox-out","far fa-inbox-out","fal fa-inbox-out","fas fa-language","far fa-language","fal fa-language","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-alt","far fa-microphone-alt","fal fa-microphone-alt","fas fa-microphone-alt-slash","far fa-microphone-alt-slash","fal fa-microphone-alt-slash","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-mobile","far fa-mobile","fal fa-mobile","fas fa-mobile-alt","far fa-mobile-alt","fal fa-mobile-alt","fas fa-mobile-android","far fa-mobile-android","fal fa-mobile-android","fas fa-mobile-android-alt","far fa-mobile-android-alt","fal fa-mobile-android-alt","fas fa-paper-plane","far fa-paper-plane","fal fa-paper-plane","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-alt","far fa-phone-alt","fal fa-phone-alt","fas fa-phone-slash","far fa-phone-slash","fal fa-phone-slash","fas fa-phone-square","far fa-phone-square","fal fa-phone-square","fas fa-phone-square-alt","far fa-phone-square-alt","fal fa-phone-square-alt","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-rss","far fa-rss","fal fa-rss","fas fa-rss-square","far fa-rss-square","fal fa-rss-square","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-tty","far fa-tty","fal fa-tty","fas fa-voicemail","far fa-voicemail","fal fa-voicemail","fas fa-walkie-talkie","far fa-walkie-talkie","fal fa-walkie-talkie","fas fa-webcam","far fa-webcam","fal fa-webcam","fas fa-webcam-slash","far fa-webcam-slash","fal fa-webcam-slash","fas fa-wifi","far fa-wifi","fal fa-wifi"]},{"id":"computers","title":"Computers","icons":["fas fa-brackets","far fa-brackets","fal fa-brackets","fas fa-brackets-curly","far fa-brackets-curly","fal fa-brackets-curly","fas fa-compact-disc","far fa-compact-disc","fal fa-compact-disc","fas fa-computer-classic","far fa-computer-classic","fal fa-computer-classic","fas fa-computer-speaker","far fa-computer-speaker","fal fa-computer-speaker","fas fa-database","far fa-database","fal fa-database","fas fa-desktop","far fa-desktop","fal fa-desktop","fas fa-desktop-alt","far fa-desktop-alt","fal fa-desktop-alt","fas fa-disc-drive","far fa-disc-drive","fal fa-disc-drive","fas fa-download","far fa-download","fal fa-download","fas fa-ethernet","far fa-ethernet","fal fa-ethernet","fas fa-hdd","far fa-hdd","fal fa-hdd","fas fa-headphones","far fa-headphones","fal fa-headphones","fas fa-keyboard","far fa-keyboard","fal fa-keyboard","fas fa-laptop","far fa-laptop","fal fa-laptop","fal fa-laptop-house","far fa-laptop-house","fas fa-laptop-house","fas fa-memory","far fa-memory","fal fa-memory","fas fa-microchip","far fa-microchip","fal fa-microchip","fas fa-mobile","far fa-mobile","fal fa-mobile","fas fa-mobile-alt","far fa-mobile-alt","fal fa-mobile-alt","fas fa-mobile-android","far fa-mobile-android","fal fa-mobile-android","fas fa-mobile-android-alt","far fa-mobile-android-alt","fal fa-mobile-android-alt","fas fa-mouse","far fa-mouse","fal fa-mouse","fas fa-mouse-alt","far fa-mouse-alt","fal fa-mouse-alt","fas fa-mp3-player","far fa-mp3-player","fal fa-mp3-player","fas fa-phone-laptop","far fa-phone-laptop","fal fa-phone-laptop","fas fa-plug","far fa-plug","fal fa-plug","fas fa-power-off","far fa-power-off","fal fa-power-off","fas fa-print","far fa-print","fal fa-print","fas fa-router","far fa-router","fal fa-router","fas fa-satellite","far fa-satellite","fal fa-satellite","fas fa-satellite-dish","far fa-satellite-dish","fal fa-satellite-dish","fas fa-save","far fa-save","fal fa-save","fas fa-scanner-image","far fa-scanner-image","fal fa-scanner-image","fas fa-sd-card","far fa-sd-card","fal fa-sd-card","fas fa-server","far fa-server","fal fa-server","fas fa-sim-card","far fa-sim-card","fal fa-sim-card","fas fa-speaker","far fa-speaker","fal fa-speaker","fas fa-speakers","far fa-speakers","fal fa-speakers","fas fa-stream","far fa-stream","fal fa-stream","fas fa-tablet","far fa-tablet","fal fa-tablet","fas fa-tablet-alt","far fa-tablet-alt","fal fa-tablet-alt","fas fa-tablet-android","far fa-tablet-android","fal fa-tablet-android","fas fa-tablet-android-alt","far fa-tablet-android-alt","fal fa-tablet-android-alt","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-music","far fa-tv-music","fal fa-tv-music","fas fa-tv-retro","far fa-tv-retro","fal fa-tv-retro","fas fa-upload","far fa-upload","fal fa-upload","fas fa-usb-drive","far fa-usb-drive","fal fa-usb-drive","fas fa-watch-calculator","far fa-watch-calculator","fal fa-watch-calculator","fas fa-webcam","far fa-webcam","fal fa-webcam","fas fa-webcam-slash","far fa-webcam-slash","fal fa-webcam-slash"]},{"id":"construction","title":"Construction","icons":["fas fa-axe","far fa-axe","fal fa-axe","fas fa-brush","far fa-brush","fal fa-brush","fas fa-construction","far fa-construction","fal fa-construction","fas fa-digging","far fa-digging","fal fa-digging","fas fa-drafting-compass","far fa-drafting-compass","fal fa-drafting-compass","fas fa-dumpster","far fa-dumpster","fal fa-dumpster","fas fa-forklift","far fa-forklift","fal fa-forklift","fas fa-hammer","far fa-hammer","fal fa-hammer","fas fa-hard-hat","far fa-hard-hat","fal fa-hard-hat","fas fa-paint-roller","far fa-paint-roller","fal fa-paint-roller","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-alt","far fa-pencil-alt","fal fa-pencil-alt","fas fa-pencil-ruler","far fa-pencil-ruler","fal fa-pencil-ruler","fas fa-ruler","far fa-ruler","fal fa-ruler","fas fa-ruler-combined","far fa-ruler-combined","fal fa-ruler-combined","fas fa-ruler-horizontal","far fa-ruler-horizontal","fal fa-ruler-horizontal","fas fa-ruler-triangle","far fa-ruler-triangle","fal fa-ruler-triangle","fas fa-ruler-vertical","far fa-ruler-vertical","fal fa-ruler-vertical","fas fa-screwdriver","far fa-screwdriver","fal fa-screwdriver","fas fa-shovel","far fa-shovel","fal fa-shovel","fas fa-toolbox","far fa-toolbox","fal fa-toolbox","fas fa-tools","far fa-tools","fal fa-tools","fas fa-traffic-cone","far fa-traffic-cone","fal fa-traffic-cone","fas fa-truck-container","far fa-truck-container","fal fa-truck-container","fas fa-truck-pickup","far fa-truck-pickup","fal fa-truck-pickup","fas fa-user-hard-hat","far fa-user-hard-hat","fal fa-user-hard-hat","fas fa-wrench","far fa-wrench","fal fa-wrench"]},{"id":"currency","title":"Currency","icons":["fab fa-bitcoin","fab fa-btc","fas fa-coin","far fa-coin","fal fa-coin","fas fa-dollar-sign","far fa-dollar-sign","fal fa-dollar-sign","fab fa-ethereum","fas fa-euro-sign","far fa-euro-sign","fal fa-euro-sign","fab fa-gg","fab fa-gg-circle","fas fa-hryvnia","far fa-hryvnia","fal fa-hryvnia","fas fa-lira-sign","far fa-lira-sign","fal fa-lira-sign","fas fa-money-bill","far fa-money-bill","fal fa-money-bill","fas fa-money-bill-alt","far fa-money-bill-alt","fal fa-money-bill-alt","fas fa-money-bill-wave","far fa-money-bill-wave","fal fa-money-bill-wave","fas fa-money-bill-wave-alt","far fa-money-bill-wave-alt","fal fa-money-bill-wave-alt","fas fa-money-check","far fa-money-check","fal fa-money-check","fas fa-money-check-alt","far fa-money-check-alt","fal fa-money-check-alt","fas fa-pound-sign","far fa-pound-sign","fal fa-pound-sign","fas fa-ruble-sign","far fa-ruble-sign","fal fa-ruble-sign","fas fa-rupee-sign","far fa-rupee-sign","fal fa-rupee-sign","fas fa-sack","far fa-sack","fal fa-sack","fas fa-sack-dollar","far fa-sack-dollar","fal fa-sack-dollar","fas fa-shekel-sign","far fa-shekel-sign","fal fa-shekel-sign","fas fa-tenge","far fa-tenge","fal fa-tenge","fas fa-usd-circle","far fa-usd-circle","fal fa-usd-circle","fas fa-usd-square","far fa-usd-square","fal fa-usd-square","fas fa-won-sign","far fa-won-sign","fal fa-won-sign","fas fa-yen-sign","far fa-yen-sign","fal fa-yen-sign"]},{"id":"date-time","title":"Date & Time","icons":["fas fa-alarm-clock","far fa-alarm-clock","fal fa-alarm-clock","fas fa-alarm-exclamation","far fa-alarm-exclamation","fal fa-alarm-exclamation","fas fa-alarm-plus","far fa-alarm-plus","fal fa-alarm-plus","fas fa-alarm-snooze","far fa-alarm-snooze","fal fa-alarm-snooze","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-exclamation","far fa-bell-exclamation","fal fa-bell-exclamation","fas fa-bell-plus","far fa-bell-plus","fal fa-bell-plus","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-calendar-alt","far fa-calendar-alt","fal fa-calendar-alt","fas fa-calendar-check","far fa-calendar-check","fal fa-calendar-check","fas fa-calendar-edit","far fa-calendar-edit","fal fa-calendar-edit","fas fa-calendar-exclamation","far fa-calendar-exclamation","fal fa-calendar-exclamation","fas fa-calendar-minus","far fa-calendar-minus","fal fa-calendar-minus","fas fa-calendar-plus","far fa-calendar-plus","fal fa-calendar-plus","fas fa-calendar-times","far fa-calendar-times","fal fa-calendar-times","fas fa-clock","far fa-clock","fal fa-clock","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-hourglass","far fa-hourglass","fal fa-hourglass","fas fa-hourglass-end","far fa-hourglass-end","fal fa-hourglass-end","fas fa-hourglass-half","far fa-hourglass-half","fal fa-hourglass-half","fas fa-hourglass-start","far fa-hourglass-start","fal fa-hourglass-start","fas fa-house-day","far fa-house-day","fal fa-house-day","fas fa-house-night","far fa-house-night","fal fa-house-night","fas fa-snooze","far fa-snooze","fal fa-snooze","fas fa-stopwatch","far fa-stopwatch","fal fa-stopwatch","fas fa-watch","far fa-watch","fal fa-watch","fas fa-watch-calculator","far fa-watch-calculator","fal fa-watch-calculator"]},{"id":"design","title":"Design","icons":["fas fa-adjust","far fa-adjust","fal fa-adjust","fas fa-bezier-curve","far fa-bezier-curve","fal fa-bezier-curve","fas fa-bring-forward","far fa-bring-forward","fal fa-bring-forward","fas fa-bring-front","far fa-bring-front","fal fa-bring-front","fas fa-brush","far fa-brush","fal fa-brush","fas fa-camera-polaroid","far fa-camera-polaroid","fal fa-camera-polaroid","fas fa-clone","far fa-clone","fal fa-clone","fas fa-copy","far fa-copy","fal fa-copy","fas fa-crop","far fa-crop","fal fa-crop","fas fa-crop-alt","far fa-crop-alt","fal fa-crop-alt","fas fa-crosshairs","far fa-crosshairs","fal fa-crosshairs","fas fa-cut","far fa-cut","fal fa-cut","fas fa-drafting-compass","far fa-drafting-compass","fal fa-drafting-compass","fas fa-draw-circle","far fa-draw-circle","fal fa-draw-circle","fas fa-draw-polygon","far fa-draw-polygon","fal fa-draw-polygon","fas fa-draw-square","far fa-draw-square","fal fa-draw-square","fas fa-edit","far fa-edit","fal fa-edit","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-fill","far fa-fill","fal fa-fill","fas fa-fill-drip","far fa-fill-drip","fal fa-fill-drip","fas fa-highlighter","far fa-highlighter","fal fa-highlighter","fas fa-icons","far fa-icons","fal fa-icons","fas fa-icons-alt","far fa-icons-alt","fal fa-icons-alt","fas fa-image-polaroid","far fa-image-polaroid","fal fa-image-polaroid","fal fa-lasso","far fa-lasso","fas fa-lasso","fas fa-layer-group","far fa-layer-group","fal fa-layer-group","fas fa-layer-minus","far fa-layer-minus","fal fa-layer-minus","fas fa-layer-plus","far fa-layer-plus","fal fa-layer-plus","fas fa-magic","far fa-magic","fal fa-magic","fas fa-marker","far fa-marker","fal fa-marker","fas fa-object-group","far fa-object-group","fal fa-object-group","fas fa-object-ungroup","far fa-object-ungroup","fal fa-object-ungroup","fas fa-paint-brush","far fa-paint-brush","fal fa-paint-brush","fas fa-paint-brush-alt","far fa-paint-brush-alt","fal fa-paint-brush-alt","fas fa-paint-roller","far fa-paint-roller","fal fa-paint-roller","fas fa-palette","far fa-palette","fal fa-palette","fas fa-paste","far fa-paste","fal fa-paste","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-alt","far fa-pen-alt","fal fa-pen-alt","fas fa-pen-fancy","far fa-pen-fancy","fal fa-pen-fancy","fas fa-pen-nib","far fa-pen-nib","fal fa-pen-nib","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-alt","far fa-pencil-alt","fal fa-pencil-alt","fas fa-pencil-ruler","far fa-pencil-ruler","fal fa-pencil-ruler","fas fa-ruler-combined","far fa-ruler-combined","fal fa-ruler-combined","fas fa-ruler-horizontal","far fa-ruler-horizontal","fal fa-ruler-horizontal","fas fa-ruler-vertical","far fa-ruler-vertical","fal fa-ruler-vertical","fas fa-save","far fa-save","fal fa-save","fas fa-scanner-image","far fa-scanner-image","fal fa-scanner-image","fas fa-send-back","far fa-send-back","fal fa-send-back","fas fa-send-backward","far fa-send-backward","fal fa-send-backward","fas fa-splotch","far fa-splotch","fal fa-splotch","fas fa-spray-can","far fa-spray-can","fal fa-spray-can","fas fa-stamp","far fa-stamp","fal fa-stamp","fas fa-swatchbook","far fa-swatchbook","fal fa-swatchbook","fas fa-tint","far fa-tint","fal fa-tint","fas fa-tint-slash","far fa-tint-slash","fal fa-tint-slash","fas fa-vector-square","far fa-vector-square","fal fa-vector-square"]},{"id":"editors","title":"Editors","icons":["fas fa-align-center","far fa-align-center","fal fa-align-center","fas fa-align-justify","far fa-align-justify","fal fa-align-justify","fas fa-align-left","far fa-align-left","fal fa-align-left","fas fa-align-right","far fa-align-right","fal fa-align-right","fas fa-align-slash","far fa-align-slash","fal fa-align-slash","fas fa-bold","far fa-bold","fal fa-bold","fas fa-border-all","far fa-border-all","fal fa-border-all","fas fa-border-bottom","far fa-border-bottom","fal fa-border-bottom","fas fa-border-center-h","far fa-border-center-h","fal fa-border-center-h","fas fa-border-center-v","far fa-border-center-v","fal fa-border-center-v","fas fa-border-inner","far fa-border-inner","fal fa-border-inner","fas fa-border-left","far fa-border-left","fal fa-border-left","fas fa-border-none","far fa-border-none","fal fa-border-none","fas fa-border-outer","far fa-border-outer","fal fa-border-outer","fas fa-border-right","far fa-border-right","fal fa-border-right","fas fa-border-style","far fa-border-style","fal fa-border-style","fas fa-border-style-alt","far fa-border-style-alt","fal fa-border-style-alt","fas fa-border-top","far fa-border-top","fal fa-border-top","fas fa-bring-forward","far fa-bring-forward","fal fa-bring-forward","fas fa-bring-front","far fa-bring-front","fal fa-bring-front","fas fa-clipboard","far fa-clipboard","fal fa-clipboard","fas fa-clone","far fa-clone","fal fa-clone","fas fa-columns","far fa-columns","fal fa-columns","fas fa-copy","far fa-copy","fal fa-copy","fas fa-cut","far fa-cut","fal fa-cut","fas fa-edit","far fa-edit","fal fa-edit","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-file","far fa-file","fal fa-file","fas fa-file-alt","far fa-file-alt","fal fa-file-alt","fas fa-font","far fa-font","fal fa-font","fas fa-font-case","far fa-font-case","fal fa-font-case","fas fa-glasses","far fa-glasses","fal fa-glasses","fas fa-h1","far fa-h1","fal fa-h1","fas fa-h2","far fa-h2","fal fa-h2","fas fa-h3","far fa-h3","fal fa-h3","fas fa-h4","far fa-h4","fal fa-h4","fas fa-heading","far fa-heading","fal fa-heading","fas fa-highlighter","far fa-highlighter","fal fa-highlighter","fas fa-horizontal-rule","far fa-horizontal-rule","fal fa-horizontal-rule","fas fa-i-cursor","far fa-i-cursor","fal fa-i-cursor","fas fa-icons","far fa-icons","fal fa-icons","fas fa-icons-alt","far fa-icons-alt","fal fa-icons-alt","fas fa-indent","far fa-indent","fal fa-indent","fas fa-italic","far fa-italic","fal fa-italic","fas fa-kerning","far fa-kerning","fal fa-kerning","fas fa-line-columns","far fa-line-columns","fal fa-line-columns","fas fa-link","far fa-link","fal fa-link","fas fa-list","far fa-list","fal fa-list","fas fa-list-alt","far fa-list-alt","fal fa-list-alt","fas fa-list-ol","far fa-list-ol","fal fa-list-ol","fas fa-list-ul","far fa-list-ul","fal fa-list-ul","fas fa-marker","far fa-marker","fal fa-marker","fas fa-outdent","far fa-outdent","fal fa-outdent","fas fa-overline","far fa-overline","fal fa-overline","fas fa-page-break","far fa-page-break","fal fa-page-break","fas fa-paper-plane","far fa-paper-plane","fal fa-paper-plane","fas fa-paperclip","far fa-paperclip","fal fa-paperclip","fas fa-paragraph","far fa-paragraph","fal fa-paragraph","fas fa-paragraph-rtl","far fa-paragraph-rtl","fal fa-paragraph-rtl","fas fa-paste","far fa-paste","fal fa-paste","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-alt","far fa-pen-alt","fal fa-pen-alt","fas fa-pen-fancy","far fa-pen-fancy","fal fa-pen-fancy","fas fa-pen-nib","far fa-pen-nib","fal fa-pen-nib","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-alt","far fa-pencil-alt","fal fa-pencil-alt","fas fa-print","far fa-print","fal fa-print","fas fa-quote-left","far fa-quote-left","fal fa-quote-left","fas fa-quote-right","far fa-quote-right","fal fa-quote-right","fas fa-redo","far fa-redo","fal fa-redo","fas fa-redo-alt","far fa-redo-alt","fal fa-redo-alt","fas fa-remove-format","far fa-remove-format","fal fa-remove-format","fas fa-reply","far fa-reply","fal fa-reply","fas fa-reply-all","far fa-reply-all","fal fa-reply-all","fas fa-screwdriver","far fa-screwdriver","fal fa-screwdriver","fas fa-send-back","far fa-send-back","fal fa-send-back","fas fa-send-backward","far fa-send-backward","fal fa-send-backward","fas fa-share","far fa-share","fal fa-share","fas fa-share-all","far fa-share-all","fal fa-share-all","fas fa-spell-check","far fa-spell-check","fal fa-spell-check","fas fa-strikethrough","far fa-strikethrough","fal fa-strikethrough","fas fa-subscript","far fa-subscript","fal fa-subscript","fas fa-superscript","far fa-superscript","fal fa-superscript","fas fa-sync","far fa-sync","fal fa-sync","fas fa-sync-alt","far fa-sync-alt","fal fa-sync-alt","fas fa-table","far fa-table","fal fa-table","fas fa-tasks","far fa-tasks","fal fa-tasks","fas fa-tasks-alt","far fa-tasks-alt","fal fa-tasks-alt","fas fa-text","far fa-text","fal fa-text","fas fa-text-height","far fa-text-height","fal fa-text-height","fas fa-text-size","far fa-text-size","fal fa-text-size","fas fa-text-width","far fa-text-width","fal fa-text-width","fas fa-th","far fa-th","fal fa-th","fas fa-th-large","far fa-th-large","fal fa-th-large","fas fa-th-list","far fa-th-list","fal fa-th-list","fas fa-tools","far fa-tools","fal fa-tools","fas fa-trash","far fa-trash","fal fa-trash","fas fa-trash-alt","far fa-trash-alt","fal fa-trash-alt","fas fa-trash-restore","far fa-trash-restore","fal fa-trash-restore","fas fa-trash-restore-alt","far fa-trash-restore-alt","fal fa-trash-restore-alt","fas fa-typewriter","far fa-typewriter","fal fa-typewriter","fas fa-underline","far fa-underline","fal fa-underline","fas fa-undo","far fa-undo","fal fa-undo","fas fa-undo-alt","far fa-undo-alt","fal fa-undo-alt","fas fa-unlink","far fa-unlink","fal fa-unlink","fas fa-wrench","far fa-wrench","fal fa-wrench"]},{"id":"education","title":"Education","icons":["fas fa-apple-alt","far fa-apple-alt","fal fa-apple-alt","fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-alt","far fa-atom-alt","fal fa-atom-alt","fas fa-award","far fa-award","fal fa-award","fas fa-backpack","far fa-backpack","fal fa-backpack","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-school","far fa-bell-school","fal fa-bell-school","fas fa-bell-school-slash","far fa-bell-school-slash","fal fa-bell-school-slash","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-book-alt","far fa-book-alt","fal fa-book-alt","fas fa-book-open","far fa-book-open","fal fa-book-open","fas fa-book-reader","far fa-book-reader","fal fa-book-reader","fas fa-books","far fa-books","fal fa-books","fas fa-bus-school","far fa-bus-school","fal fa-bus-school","fas fa-chalkboard","far fa-chalkboard","fal fa-chalkboard","fas fa-chalkboard-teacher","far fa-chalkboard-teacher","fal fa-chalkboard-teacher","fas fa-diploma","far fa-diploma","fal fa-diploma","fas fa-file-certificate","far fa-file-certificate","fal fa-file-certificate","fas fa-glasses-alt","far fa-glasses-alt","fal fa-glasses-alt","fas fa-globe-stand","far fa-globe-stand","fal fa-globe-stand","fas fa-graduation-cap","far fa-graduation-cap","fal fa-graduation-cap","fas fa-laptop-code","far fa-laptop-code","fal fa-laptop-code","fas fa-microscope","far fa-microscope","fal fa-microscope","fas fa-music","far fa-music","fal fa-music","fas fa-pencil-paintbrush","far fa-pencil-paintbrush","fal fa-pencil-paintbrush","fas fa-ruler-triangle","far fa-ruler-triangle","fal fa-ruler-triangle","fas fa-school","far fa-school","fal fa-school","fas fa-shapes","far fa-shapes","fal fa-shapes","fas fa-theater-masks","far fa-theater-masks","fal fa-theater-masks","fas fa-user-graduate","far fa-user-graduate","fal fa-user-graduate","fas fa-users-class","far fa-users-class","fal fa-users-class"]},{"id":"emoji","title":"Emoji","icons":["fas fa-angry","far fa-angry","fal fa-angry","fas fa-dizzy","far fa-dizzy","fal fa-dizzy","fas fa-flushed","far fa-flushed","fal fa-flushed","fas fa-frown","far fa-frown","fal fa-frown","fas fa-frown-open","far fa-frown-open","fal fa-frown-open","fas fa-grimace","far fa-grimace","fal fa-grimace","fas fa-grin","far fa-grin","fal fa-grin","fas fa-grin-alt","far fa-grin-alt","fal fa-grin-alt","fas fa-grin-beam","far fa-grin-beam","fal fa-grin-beam","fas fa-grin-beam-sweat","far fa-grin-beam-sweat","fal fa-grin-beam-sweat","fas fa-grin-hearts","far fa-grin-hearts","fal fa-grin-hearts","fas fa-grin-squint","far fa-grin-squint","fal fa-grin-squint","fas fa-grin-squint-tears","far fa-grin-squint-tears","fal fa-grin-squint-tears","fas fa-grin-stars","far fa-grin-stars","fal fa-grin-stars","fas fa-grin-tears","far fa-grin-tears","fal fa-grin-tears","fas fa-grin-tongue","far fa-grin-tongue","fal fa-grin-tongue","fas fa-grin-tongue-squint","far fa-grin-tongue-squint","fal fa-grin-tongue-squint","fas fa-grin-tongue-wink","far fa-grin-tongue-wink","fal fa-grin-tongue-wink","fas fa-grin-wink","far fa-grin-wink","fal fa-grin-wink","fas fa-kiss","far fa-kiss","fal fa-kiss","fas fa-kiss-beam","far fa-kiss-beam","fal fa-kiss-beam","fas fa-kiss-wink-heart","far fa-kiss-wink-heart","fal fa-kiss-wink-heart","fas fa-laugh","far fa-laugh","fal fa-laugh","fas fa-laugh-beam","far fa-laugh-beam","fal fa-laugh-beam","fas fa-laugh-squint","far fa-laugh-squint","fal fa-laugh-squint","fas fa-laugh-wink","far fa-laugh-wink","fal fa-laugh-wink","fas fa-meh","far fa-meh","fal fa-meh","fas fa-meh-blank","far fa-meh-blank","fal fa-meh-blank","fas fa-meh-rolling-eyes","far fa-meh-rolling-eyes","fal fa-meh-rolling-eyes","fas fa-sad-cry","far fa-sad-cry","fal fa-sad-cry","fas fa-sad-tear","far fa-sad-tear","fal fa-sad-tear","fas fa-smile","far fa-smile","fal fa-smile","fas fa-smile-beam","far fa-smile-beam","fal fa-smile-beam","fas fa-smile-wink","far fa-smile-wink","fal fa-smile-wink","fas fa-surprise","far fa-surprise","fal fa-surprise","fas fa-tired","far fa-tired","fal fa-tired"]},{"id":"energy","title":"Energy","icons":["fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-alt","far fa-atom-alt","fal fa-atom-alt","fas fa-battery-bolt","far fa-battery-bolt","fal fa-battery-bolt","fas fa-battery-empty","far fa-battery-empty","fal fa-battery-empty","fas fa-battery-full","far fa-battery-full","fal fa-battery-full","fas fa-battery-half","far fa-battery-half","fal fa-battery-half","fas fa-battery-quarter","far fa-battery-quarter","fal fa-battery-quarter","fas fa-battery-slash","far fa-battery-slash","fal fa-battery-slash","fas fa-battery-three-quarters","far fa-battery-three-quarters","fal fa-battery-three-quarters","fas fa-broadcast-tower","far fa-broadcast-tower","fal fa-broadcast-tower","fas fa-burn","far fa-burn","fal fa-burn","fas fa-burrito","far fa-burrito","fal fa-burrito","fas fa-charging-station","far fa-charging-station","fal fa-charging-station","fas fa-fan","far fa-fan","fal fa-fan","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-alt","far fa-fire-alt","fal fa-fire-alt","fas fa-gas-pump","far fa-gas-pump","fal fa-gas-pump","fas fa-gas-pump-slash","far fa-gas-pump-slash","fal fa-gas-pump-slash","fas fa-heat","far fa-heat","fal fa-heat","fas fa-house-day","far fa-house-day","fal fa-house-day","fas fa-house-night","far fa-house-night","fal fa-house-night","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-alt","far fa-industry-alt","fal fa-industry-alt","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-outlet","far fa-outlet","fal fa-outlet","fas fa-plug","far fa-plug","fal fa-plug","fas fa-poop","far fa-poop","fal fa-poop","fas fa-power-off","far fa-power-off","fal fa-power-off","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-radiation-alt","far fa-radiation-alt","fal fa-radiation-alt","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-solar-panel","far fa-solar-panel","fal fa-solar-panel","fas fa-sun","far fa-sun","fal fa-sun","fas fa-water","far fa-water","fal fa-water","fas fa-wind","far fa-wind","fal fa-wind","fas fa-wind-turbine","far fa-wind-turbine","fal fa-wind-turbine"]},{"id":"files","title":"Files","icons":["fas fa-archive","far fa-archive","fal fa-archive","fas fa-clone","far fa-clone","fal fa-clone","fas fa-copy","far fa-copy","fal fa-copy","fas fa-cut","far fa-cut","fal fa-cut","fas fa-file","far fa-file","fal fa-file","fas fa-file-alt","far fa-file-alt","fal fa-file-alt","fas fa-file-archive","far fa-file-archive","fal fa-file-archive","fas fa-file-audio","far fa-file-audio","fal fa-file-audio","fas fa-file-check","far fa-file-check","fal fa-file-check","fas fa-file-code","far fa-file-code","fal fa-file-code","fas fa-file-edit","far fa-file-edit","fal fa-file-edit","fas fa-file-excel","far fa-file-excel","fal fa-file-excel","fas fa-file-exclamation","far fa-file-exclamation","fal fa-file-exclamation","fas fa-file-image","far fa-file-image","fal fa-file-image","fas fa-file-minus","far fa-file-minus","fal fa-file-minus","fas fa-file-music","far fa-file-music","fal fa-file-music","fas fa-file-pdf","far fa-file-pdf","fal fa-file-pdf","fas fa-file-plus","far fa-file-plus","fal fa-file-plus","fas fa-file-powerpoint","far fa-file-powerpoint","fal fa-file-powerpoint","fas fa-file-search","far fa-file-search","fal fa-file-search","fas fa-file-times","far fa-file-times","fal fa-file-times","fas fa-file-video","far fa-file-video","fal fa-file-video","fas fa-file-word","far fa-file-word","fal fa-file-word","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-paste","far fa-paste","fal fa-paste","fas fa-photo-video","far fa-photo-video","fal fa-photo-video","fas fa-save","far fa-save","fal fa-save","fas fa-sticky-note","far fa-sticky-note","fal fa-sticky-note"]},{"id":"finance","title":"Finance","icons":["fas fa-analytics","far fa-analytics","fal fa-analytics","fas fa-badge-dollar","far fa-badge-dollar","fal fa-badge-dollar","fas fa-badge-percent","far fa-badge-percent","fal fa-badge-percent","fas fa-balance-scale","far fa-balance-scale","fal fa-balance-scale","fas fa-balance-scale-left","far fa-balance-scale-left","fal fa-balance-scale-left","fas fa-balance-scale-right","far fa-balance-scale-right","fal fa-balance-scale-right","fas fa-book","far fa-book","fal fa-book","fas fa-cash-register","far fa-cash-register","fal fa-cash-register","fas fa-chart-line","far fa-chart-line","fal fa-chart-line","fas fa-chart-line-down","far fa-chart-line-down","fal fa-chart-line-down","fas fa-chart-pie","far fa-chart-pie","fal fa-chart-pie","fas fa-chart-pie-alt","far fa-chart-pie-alt","fal fa-chart-pie-alt","fas fa-coin","far fa-coin","fal fa-coin","fas fa-coins","far fa-coins","fal fa-coins","fas fa-comment-alt-dollar","far fa-comment-alt-dollar","fal fa-comment-alt-dollar","fas fa-comment-dollar","far fa-comment-dollar","fal fa-comment-dollar","fas fa-comments-alt-dollar","far fa-comments-alt-dollar","fal fa-comments-alt-dollar","fas fa-comments-dollar","far fa-comments-dollar","fal fa-comments-dollar","fas fa-credit-card","far fa-credit-card","fal fa-credit-card","fas fa-credit-card-blank","far fa-credit-card-blank","fal fa-credit-card-blank","fas fa-credit-card-front","far fa-credit-card-front","fal fa-credit-card-front","fas fa-donate","far fa-donate","fal fa-donate","fas fa-file-chart-line","far fa-file-chart-line","fal fa-file-chart-line","fas fa-file-chart-pie","far fa-file-chart-pie","fal fa-file-chart-pie","fas fa-file-invoice","far fa-file-invoice","fal fa-file-invoice","fas fa-file-invoice-dollar","far fa-file-invoice-dollar","fal fa-file-invoice-dollar","fas fa-hand-holding-usd","far fa-hand-holding-usd","fal fa-hand-holding-usd","fas fa-hands-usd","far fa-hands-usd","fal fa-hands-usd","fas fa-landmark","far fa-landmark","fal fa-landmark","fas fa-money-bill","far fa-money-bill","fal fa-money-bill","fas fa-money-bill-alt","far fa-money-bill-alt","fal fa-money-bill-alt","fas fa-money-bill-wave","far fa-money-bill-wave","fal fa-money-bill-wave","fas fa-money-bill-wave-alt","far fa-money-bill-wave-alt","fal fa-money-bill-wave-alt","fas fa-money-check","far fa-money-check","fal fa-money-check","fas fa-money-check-alt","far fa-money-check-alt","fal fa-money-check-alt","fas fa-percentage","far fa-percentage","fal fa-percentage","fas fa-piggy-bank","far fa-piggy-bank","fal fa-piggy-bank","fas fa-receipt","far fa-receipt","fal fa-receipt","fas fa-sack","far fa-sack","fal fa-sack","fas fa-sack-dollar","far fa-sack-dollar","fal fa-sack-dollar","fas fa-stamp","far fa-stamp","fal fa-stamp","fas fa-tally","far fa-tally","fal fa-tally","fas fa-treasure-chest","far fa-treasure-chest","fal fa-treasure-chest","fas fa-wallet","far fa-wallet","fal fa-wallet"]},{"id":"fitness","title":"Fitness","icons":["fas fa-bicycle","far fa-bicycle","fal fa-bicycle","fas fa-biking","far fa-biking","fal fa-biking","fas fa-biking-mountain","far fa-biking-mountain","fal fa-biking-mountain","fas fa-book-heart","far fa-book-heart","fal fa-book-heart","fas fa-burn","far fa-burn","fal fa-burn","fas fa-fire-alt","far fa-fire-alt","fal fa-fire-alt","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-rate","far fa-heart-rate","fal fa-heart-rate","fas fa-heartbeat","far fa-heartbeat","fal fa-heartbeat","fas fa-hiking","far fa-hiking","fal fa-hiking","fas fa-monitor-heart-rate","far fa-monitor-heart-rate","fal fa-monitor-heart-rate","fas fa-running","far fa-running","fal fa-running","fas fa-shoe-prints","far fa-shoe-prints","fal fa-shoe-prints","fas fa-skating","far fa-skating","fal fa-skating","fas fa-ski-jump","far fa-ski-jump","fal fa-ski-jump","fas fa-skiing","far fa-skiing","fal fa-skiing","fas fa-skiing-nordic","far fa-skiing-nordic","fal fa-skiing-nordic","fas fa-snowboarding","far fa-snowboarding","fal fa-snowboarding","fas fa-spa","far fa-spa","fal fa-spa","fas fa-swimmer","far fa-swimmer","fal fa-swimmer","fas fa-walking","far fa-walking","fal fa-walking","fas fa-watch-fitness","far fa-watch-fitness","fal fa-watch-fitness"]},{"id":"food","title":"Food","icons":["fas fa-apple-alt","far fa-apple-alt","fal fa-apple-alt","fas fa-apple-crate","far fa-apple-crate","fal fa-apple-crate","fas fa-bacon","far fa-bacon","fal fa-bacon","fas fa-bone","far fa-bone","fal fa-bone","fas fa-bread-loaf","far fa-bread-loaf","fal fa-bread-loaf","fas fa-bread-slice","far fa-bread-slice","fal fa-bread-slice","fas fa-burger-soda","far fa-burger-soda","fal fa-burger-soda","fas fa-burrito","far fa-burrito","fal fa-burrito","fas fa-candy-cane","far fa-candy-cane","fal fa-candy-cane","fas fa-candy-corn","far fa-candy-corn","fal fa-candy-corn","fas fa-carrot","far fa-carrot","fal fa-carrot","fas fa-cheese","far fa-cheese","fal fa-cheese","fas fa-cheese-swiss","far fa-cheese-swiss","fal fa-cheese-swiss","fas fa-cheeseburger","far fa-cheeseburger","fal fa-cheeseburger","fas fa-cloud-meatball","far fa-cloud-meatball","fal fa-cloud-meatball","fas fa-cookie","far fa-cookie","fal fa-cookie","fas fa-corn","far fa-corn","fal fa-corn","fas fa-croissant","far fa-croissant","fal fa-croissant","fas fa-drumstick","far fa-drumstick","fal fa-drumstick","fas fa-drumstick-bite","far fa-drumstick-bite","fal fa-drumstick-bite","fas fa-egg","far fa-egg","fal fa-egg","fas fa-egg-fried","far fa-egg-fried","fal fa-egg-fried","fas fa-fish","far fa-fish","fal fa-fish","fas fa-fish-cooked","far fa-fish-cooked","fal fa-fish-cooked","fas fa-french-fries","far fa-french-fries","fal fa-french-fries","fas fa-gingerbread-man","far fa-gingerbread-man","fal fa-gingerbread-man","fas fa-hamburger","far fa-hamburger","fal fa-hamburger","fas fa-hat-chef","far fa-hat-chef","fal fa-hat-chef","fas fa-hotdog","far fa-hotdog","fal fa-hotdog","fas fa-ice-cream","far fa-ice-cream","fal fa-ice-cream","fas fa-lemon","far fa-lemon","fal fa-lemon","fas fa-meat","far fa-meat","fal fa-meat","fas fa-pepper-hot","far fa-pepper-hot","fal fa-pepper-hot","fas fa-pie","far fa-pie","fal fa-pie","fas fa-pizza","far fa-pizza","fal fa-pizza","fas fa-pizza-slice","far fa-pizza-slice","fal fa-pizza-slice","fas fa-popcorn","far fa-popcorn","fal fa-popcorn","fas fa-pumpkin","far fa-pumpkin","fal fa-pumpkin","fas fa-salad","far fa-salad","fal fa-salad","fas fa-sandwich","far fa-sandwich","fal fa-sandwich","fas fa-sausage","far fa-sausage","fal fa-sausage","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-shish-kebab","far fa-shish-kebab","fal fa-shish-kebab","fas fa-soup","far fa-soup","fal fa-soup","fas fa-steak","far fa-steak","fal fa-steak","fas fa-stroopwafel","far fa-stroopwafel","fal fa-stroopwafel","fas fa-taco","far fa-taco","fal fa-taco","fas fa-turkey","far fa-turkey","fal fa-turkey","fas fa-wheat","far fa-wheat","fal fa-wheat"]},{"id":"fruit-vegetable","title":"Fruits & Vegetables","icons":["fas fa-apple-alt","far fa-apple-alt","fal fa-apple-alt","fas fa-apple-crate","far fa-apple-crate","fal fa-apple-crate","fas fa-carrot","far fa-carrot","fal fa-carrot","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-lemon","far fa-lemon","fal fa-lemon","fas fa-pepper-hot","far fa-pepper-hot","fal fa-pepper-hot","fas fa-pumpkin","far fa-pumpkin","fal fa-pumpkin","fas fa-salad","far fa-salad","fal fa-salad","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-wheat","far fa-wheat","fal fa-wheat"]},{"id":"games","title":"Games","icons":["fas fa-alien-monster","far fa-alien-monster","fal fa-alien-monster","fas fa-chess","far fa-chess","fal fa-chess","fas fa-chess-bishop","far fa-chess-bishop","fal fa-chess-bishop","fas fa-chess-bishop-alt","far fa-chess-bishop-alt","fal fa-chess-bishop-alt","fas fa-chess-board","far fa-chess-board","fal fa-chess-board","fas fa-chess-clock","far fa-chess-clock","fal fa-chess-clock","fas fa-chess-clock-alt","far fa-chess-clock-alt","fal fa-chess-clock-alt","fas fa-chess-king","far fa-chess-king","fal fa-chess-king","fas fa-chess-king-alt","far fa-chess-king-alt","fal fa-chess-king-alt","fas fa-chess-knight","far fa-chess-knight","fal fa-chess-knight","fas fa-chess-knight-alt","far fa-chess-knight-alt","fal fa-chess-knight-alt","fas fa-chess-pawn","far fa-chess-pawn","fal fa-chess-pawn","fas fa-chess-pawn-alt","far fa-chess-pawn-alt","fal fa-chess-pawn-alt","fas fa-chess-queen","far fa-chess-queen","fal fa-chess-queen","fas fa-chess-queen-alt","far fa-chess-queen-alt","fal fa-chess-queen-alt","fas fa-chess-rook","far fa-chess-rook","fal fa-chess-rook","fas fa-chess-rook-alt","far fa-chess-rook-alt","fal fa-chess-rook-alt","fas fa-club","far fa-club","fal fa-club","fas fa-diamond","far fa-diamond","fal fa-diamond","fas fa-dice","far fa-dice","fal fa-dice","fas fa-dice-d10","far fa-dice-d10","fal fa-dice-d10","fas fa-dice-d12","far fa-dice-d12","fal fa-dice-d12","fas fa-dice-d20","far fa-dice-d20","fal fa-dice-d20","fas fa-dice-d4","far fa-dice-d4","fal fa-dice-d4","fas fa-dice-d6","far fa-dice-d6","fal fa-dice-d6","fas fa-dice-d8","far fa-dice-d8","fal fa-dice-d8","fas fa-dice-five","far fa-dice-five","fal fa-dice-five","fas fa-dice-four","far fa-dice-four","fal fa-dice-four","fas fa-dice-one","far fa-dice-one","fal fa-dice-one","fas fa-dice-six","far fa-dice-six","fal fa-dice-six","fas fa-dice-three","far fa-dice-three","fal fa-dice-three","fas fa-dice-two","far fa-dice-two","fal fa-dice-two","fas fa-dreidel","far fa-dreidel","fal fa-dreidel","fas fa-game-console-handheld","far fa-game-console-handheld","fal fa-game-console-handheld","fas fa-gamepad","far fa-gamepad","fal fa-gamepad","fas fa-gamepad-alt","far fa-gamepad-alt","fal fa-gamepad-alt","fas fa-ghost","far fa-ghost","fal fa-ghost","fas fa-headset","far fa-headset","fal fa-headset","fas fa-heart","far fa-heart","fal fa-heart","fas fa-joystick","far fa-joystick","fal fa-joystick","fab fa-playstation","fas fa-puzzle-piece","far fa-puzzle-piece","fal fa-puzzle-piece","fas fa-spade","far fa-spade","fal fa-spade","fab fa-steam","fab fa-steam-square","fab fa-steam-symbol","fab fa-twitch","fab fa-xbox"]},{"id":"gaming-tabletop","title":"Tabletop Gaming","icons":["fab fa-acquisitions-incorporated","fas fa-axe-battle","far fa-axe-battle","fal fa-axe-battle","fas fa-book-dead","far fa-book-dead","fal fa-book-dead","fas fa-book-spells","far fa-book-spells","fal fa-book-spells","fas fa-bow-arrow","far fa-bow-arrow","fal fa-bow-arrow","fas fa-campfire","far fa-campfire","fal fa-campfire","fab fa-critical-role","fab fa-d-and-d","fab fa-d-and-d-beyond","fas fa-dagger","far fa-dagger","fal fa-dagger","fas fa-dice-d10","far fa-dice-d10","fal fa-dice-d10","fas fa-dice-d12","far fa-dice-d12","fal fa-dice-d12","fas fa-dice-d20","far fa-dice-d20","fal fa-dice-d20","fas fa-dice-d4","far fa-dice-d4","fal fa-dice-d4","fas fa-dice-d6","far fa-dice-d6","fal fa-dice-d6","fas fa-dice-d8","far fa-dice-d8","fal fa-dice-d8","fas fa-dragon","far fa-dragon","fal fa-dragon","fas fa-dungeon","far fa-dungeon","fal fa-dungeon","fas fa-eye-evil","far fa-eye-evil","fal fa-eye-evil","fab fa-fantasy-flight-games","fas fa-fist-raised","far fa-fist-raised","fal fa-fist-raised","fas fa-flame","far fa-flame","fal fa-flame","fas fa-flask-potion","far fa-flask-potion","fal fa-flask-potion","fas fa-game-board","far fa-game-board","fal fa-game-board","fas fa-game-board-alt","far fa-game-board-alt","fal fa-game-board-alt","fas fa-hammer-war","far fa-hammer-war","fal fa-hammer-war","fas fa-hand-holding-magic","far fa-hand-holding-magic","fal fa-hand-holding-magic","fas fa-hat-wizard","far fa-hat-wizard","fal fa-hat-wizard","fas fa-helmet-battle","far fa-helmet-battle","fal fa-helmet-battle","fas fa-hood-cloak","far fa-hood-cloak","fal fa-hood-cloak","fas fa-mace","far fa-mace","fal fa-mace","fas fa-mandolin","far fa-mandolin","fal fa-mandolin","fas fa-paw-claws","far fa-paw-claws","fal fa-paw-claws","fab fa-penny-arcade","fas fa-ring","far fa-ring","fal fa-ring","fas fa-scroll","far fa-scroll","fal fa-scroll","fas fa-scroll-old","far fa-scroll-old","fal fa-scroll-old","fas fa-scythe","far fa-scythe","fal fa-scythe","fas fa-shield-cross","far fa-shield-cross","fal fa-shield-cross","fas fa-sickle","far fa-sickle","fal fa-sickle","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-staff","far fa-staff","fal fa-staff","fas fa-sword","far fa-sword","fal fa-sword","fas fa-swords","far fa-swords","fal fa-swords","fas fa-treasure-chest","far fa-treasure-chest","fal fa-treasure-chest","fas fa-wand","far fa-wand","fal fa-wand","fas fa-wand-magic","far fa-wand-magic","fal fa-wand-magic","fab fa-wizards-of-the-coast"]},{"id":"gender","title":"Genders","icons":["fas fa-genderless","far fa-genderless","fal fa-genderless","fas fa-mars","far fa-mars","fal fa-mars","fas fa-mars-double","far fa-mars-double","fal fa-mars-double","fas fa-mars-stroke","far fa-mars-stroke","fal fa-mars-stroke","fas fa-mars-stroke-h","far fa-mars-stroke-h","fal fa-mars-stroke-h","fas fa-mars-stroke-v","far fa-mars-stroke-v","fal fa-mars-stroke-v","fas fa-mercury","far fa-mercury","fal fa-mercury","fas fa-neuter","far fa-neuter","fal fa-neuter","fas fa-transgender","far fa-transgender","fal fa-transgender","fas fa-transgender-alt","far fa-transgender-alt","fal fa-transgender-alt","fas fa-venus","far fa-venus","fal fa-venus","fas fa-venus-double","far fa-venus-double","fal fa-venus-double","fas fa-venus-mars","far fa-venus-mars","fal fa-venus-mars"]},{"id":"halloween","title":"Halloween","icons":["fas fa-bat","far fa-bat","fal fa-bat","fas fa-book-dead","far fa-book-dead","fal fa-book-dead","fas fa-book-spells","far fa-book-spells","fal fa-book-spells","fas fa-broom","far fa-broom","fal fa-broom","fas fa-candle-holder","far fa-candle-holder","fal fa-candle-holder","fas fa-candy-corn","far fa-candy-corn","fal fa-candy-corn","fas fa-cat","far fa-cat","fal fa-cat","fas fa-cauldron","far fa-cauldron","fal fa-cauldron","fas fa-claw-marks","far fa-claw-marks","fal fa-claw-marks","fas fa-cloud-moon","far fa-cloud-moon","fal fa-cloud-moon","fas fa-coffin","far fa-coffin","fal fa-coffin","fas fa-crow","far fa-crow","fal fa-crow","fas fa-flask-poison","far fa-flask-poison","fal fa-flask-poison","fas fa-flask-potion","far fa-flask-potion","fal fa-flask-potion","fas fa-ghost","far fa-ghost","fal fa-ghost","fas fa-hat-witch","far fa-hat-witch","fal fa-hat-witch","fas fa-hat-wizard","far fa-hat-wizard","fal fa-hat-wizard","fas fa-hockey-mask","far fa-hockey-mask","fal fa-hockey-mask","fas fa-jack-o-lantern","far fa-jack-o-lantern","fal fa-jack-o-lantern","fas fa-key-skeleton","far fa-key-skeleton","fal fa-key-skeleton","fas fa-knife-kitchen","far fa-knife-kitchen","fal fa-knife-kitchen","fas fa-mask","far fa-mask","fal fa-mask","fas fa-scarecrow","far fa-scarecrow","fal fa-scarecrow","fas fa-scythe","far fa-scythe","fal fa-scythe","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-spider","far fa-spider","fal fa-spider","fas fa-spider-black-widow","far fa-spider-black-widow","fal fa-spider-black-widow","fas fa-spider-web","far fa-spider-web","fal fa-spider-web","fas fa-toilet-paper","far fa-toilet-paper","fal fa-toilet-paper","fas fa-toilet-paper-alt","far fa-toilet-paper-alt","fal fa-toilet-paper-alt","fas fa-tombstone","far fa-tombstone","fal fa-tombstone","fas fa-tombstone-alt","far fa-tombstone-alt","fal fa-tombstone-alt","fas fa-wand","far fa-wand","fal fa-wand","fas fa-wand-magic","far fa-wand-magic","fal fa-wand-magic"]},{"id":"hands","title":"Hands","icons":["fas fa-allergies","far fa-allergies","fal fa-allergies","fas fa-fist-raised","far fa-fist-raised","fal fa-fist-raised","fas fa-hand-heart","far fa-hand-heart","fal fa-hand-heart","fas fa-hand-holding","far fa-hand-holding","fal fa-hand-holding","fas fa-hand-holding-box","far fa-hand-holding-box","fal fa-hand-holding-box","fas fa-hand-holding-heart","far fa-hand-holding-heart","fal fa-hand-holding-heart","fas fa-hand-holding-magic","far fa-hand-holding-magic","fal fa-hand-holding-magic","fal fa-hand-holding-medical","far fa-hand-holding-medical","fas fa-hand-holding-medical","fas fa-hand-holding-seedling","far fa-hand-holding-seedling","fal fa-hand-holding-seedling","fas fa-hand-holding-usd","far fa-hand-holding-usd","fal fa-hand-holding-usd","fas fa-hand-holding-water","far fa-hand-holding-water","fal fa-hand-holding-water","fas fa-hand-lizard","far fa-hand-lizard","fal fa-hand-lizard","fas fa-hand-middle-finger","far fa-hand-middle-finger","fal fa-hand-middle-finger","fas fa-hand-paper","far fa-hand-paper","fal fa-hand-paper","fas fa-hand-peace","far fa-hand-peace","fal fa-hand-peace","fas fa-hand-point-down","far fa-hand-point-down","fal fa-hand-point-down","fas fa-hand-point-left","far fa-hand-point-left","fal fa-hand-point-left","fas fa-hand-point-right","far fa-hand-point-right","fal fa-hand-point-right","fas fa-hand-point-up","far fa-hand-point-up","fal fa-hand-point-up","fas fa-hand-pointer","far fa-hand-pointer","fal fa-hand-pointer","fas fa-hand-receiving","far fa-hand-receiving","fal fa-hand-receiving","fas fa-hand-rock","far fa-hand-rock","fal fa-hand-rock","fas fa-hand-scissors","far fa-hand-scissors","fal fa-hand-scissors","fal fa-hand-sparkles","far fa-hand-sparkles","fas fa-hand-sparkles","fas fa-hand-spock","far fa-hand-spock","fal fa-hand-spock","fas fa-hands","far fa-hands","fal fa-hands","fas fa-hands-heart","far fa-hands-heart","fal fa-hands-heart","fas fa-hands-helping","far fa-hands-helping","fal fa-hands-helping","fas fa-hands-usd","far fa-hands-usd","fal fa-hands-usd","fal fa-hands-wash","far fa-hands-wash","fas fa-hands-wash","fas fa-handshake","far fa-handshake","fal fa-handshake","fas fa-handshake-alt","far fa-handshake-alt","fal fa-handshake-alt","fal fa-handshake-alt-slash","far fa-handshake-alt-slash","fas fa-handshake-alt-slash","fal fa-handshake-slash","far fa-handshake-slash","fas fa-handshake-slash","fas fa-praying-hands","far fa-praying-hands","fal fa-praying-hands","fas fa-thumbs-down","far fa-thumbs-down","fal fa-thumbs-down","fas fa-thumbs-up","far fa-thumbs-up","fal fa-thumbs-up"]},{"id":"health","title":"Health","icons":["fab fa-accessible-icon","fas fa-ambulance","far fa-ambulance","fal fa-ambulance","fas fa-h-square","far fa-h-square","fal fa-h-square","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heartbeat","far fa-heartbeat","fal fa-heartbeat","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-medkit","far fa-medkit","fal fa-medkit","fas fa-plus-square","far fa-plus-square","fal fa-plus-square","fas fa-prescription","far fa-prescription","fal fa-prescription","fas fa-stethoscope","far fa-stethoscope","fal fa-stethoscope","fas fa-user-md","far fa-user-md","fal fa-user-md","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair"]},{"id":"holiday","title":"Holiday","icons":["fas fa-angel","far fa-angel","fal fa-angel","fas fa-bells","far fa-bells","fal fa-bells","fas fa-candy-cane","far fa-candy-cane","fal fa-candy-cane","fas fa-carrot","far fa-carrot","fal fa-carrot","fas fa-cookie-bite","far fa-cookie-bite","fal fa-cookie-bite","fas fa-deer","far fa-deer","fal fa-deer","fas fa-deer-rudolph","far fa-deer-rudolph","fal fa-deer-rudolph","fas fa-dreidel","far fa-dreidel","fal fa-dreidel","fas fa-fireplace","far fa-fireplace","fal fa-fireplace","fas fa-gift","far fa-gift","fal fa-gift","fas fa-gifts","far fa-gifts","fal fa-gifts","fas fa-gingerbread-man","far fa-gingerbread-man","fal fa-gingerbread-man","fas fa-glass-champagne","far fa-glass-champagne","fal fa-glass-champagne","fas fa-glass-cheers","far fa-glass-cheers","fal fa-glass-cheers","fas fa-hat-santa","far fa-hat-santa","fal fa-hat-santa","fas fa-holly-berry","far fa-holly-berry","fal fa-holly-berry","fas fa-lights-holiday","far fa-lights-holiday","fal fa-lights-holiday","fas fa-mistletoe","far fa-mistletoe","fal fa-mistletoe","fas fa-mug-hot","far fa-mug-hot","fal fa-mug-hot","fas fa-narwhal","far fa-narwhal","fal fa-narwhal","fas fa-ornament","far fa-ornament","fal fa-ornament","fas fa-rv","far fa-rv","fal fa-rv","fas fa-sleigh","far fa-sleigh","fal fa-sleigh","fas fa-snowman","far fa-snowman","fal fa-snowman","fas fa-star-christmas","far fa-star-christmas","fal fa-star-christmas","fas fa-stocking","far fa-stocking","fal fa-stocking","fas fa-tree-christmas","far fa-tree-christmas","fal fa-tree-christmas","fas fa-tree-decorated","far fa-tree-decorated","fal fa-tree-decorated","fas fa-turkey","far fa-turkey","fal fa-turkey","fas fa-wreath","far fa-wreath","fal fa-wreath"]},{"id":"hotel","title":"Hotel","icons":["fas fa-air-conditioner","far fa-air-conditioner","fal fa-air-conditioner","fas fa-alarm-clock","far fa-alarm-clock","fal fa-alarm-clock","fas fa-alarm-snooze","far fa-alarm-snooze","fal fa-alarm-snooze","fas fa-baby-carriage","far fa-baby-carriage","fal fa-baby-carriage","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bed","far fa-bed","fal fa-bed","fas fa-bed-bunk","far fa-bed-bunk","fal fa-bed-bunk","fas fa-bed-empty","far fa-bed-empty","fal fa-bed-empty","fas fa-briefcase","far fa-briefcase","fal fa-briefcase","fas fa-car","far fa-car","fal fa-car","fas fa-car-building","far fa-car-building","fal fa-car-building","fas fa-car-bus","far fa-car-bus","fal fa-car-bus","fas fa-car-garage","far fa-car-garage","fal fa-car-garage","fas fa-cocktail","far fa-cocktail","fal fa-cocktail","fas fa-coffee","far fa-coffee","fal fa-coffee","fas fa-concierge-bell","far fa-concierge-bell","fal fa-concierge-bell","fas fa-dice","far fa-dice","fal fa-dice","fas fa-dice-five","far fa-dice-five","fal fa-dice-five","fas fa-door-closed","far fa-door-closed","fal fa-door-closed","fas fa-door-open","far fa-door-open","fal fa-door-open","fas fa-dryer","far fa-dryer","fal fa-dryer","fas fa-dryer-alt","far fa-dryer-alt","fal fa-dryer-alt","fas fa-dumbbell","far fa-dumbbell","fal fa-dumbbell","fas fa-fan-table","far fa-fan-table","fal fa-fan-table","fas fa-fireplace","far fa-fireplace","fal fa-fireplace","fas fa-glass-martini","far fa-glass-martini","fal fa-glass-martini","fas fa-glass-martini-alt","far fa-glass-martini-alt","fal fa-glass-martini-alt","fas fa-heat","far fa-heat","fal fa-heat","fas fa-hot-tub","far fa-hot-tub","fal fa-hot-tub","fas fa-hotel","far fa-hotel","fal fa-hotel","fas fa-infinity","far fa-infinity","fal fa-infinity","fas fa-key","far fa-key","fal fa-key","fas fa-lamp-desk","far fa-lamp-desk","fal fa-lamp-desk","fas fa-luggage-cart","far fa-luggage-cart","fal fa-luggage-cart","fas fa-microwave","far fa-microwave","fal fa-microwave","fas fa-outlet","far fa-outlet","fal fa-outlet","fas fa-oven","far fa-oven","fal fa-oven","fas fa-paw-alt","far fa-paw-alt","fal fa-paw-alt","fas fa-refrigerator","far fa-refrigerator","fal fa-refrigerator","fas fa-shower","far fa-shower","fal fa-shower","fas fa-shuttle-van","far fa-shuttle-van","fal fa-shuttle-van","fas fa-smoking","far fa-smoking","fal fa-smoking","fas fa-smoking-ban","far fa-smoking-ban","fal fa-smoking-ban","fas fa-snooze","far fa-snooze","fal fa-snooze","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-spa","far fa-spa","fal fa-spa","fas fa-suitcase","far fa-suitcase","fal fa-suitcase","fas fa-suitcase-rolling","far fa-suitcase-rolling","fal fa-suitcase-rolling","fas fa-swimmer","far fa-swimmer","fal fa-swimmer","fas fa-swimming-pool","far fa-swimming-pool","fal fa-swimming-pool","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-alt","far fa-tv-alt","fal fa-tv-alt","fas fa-tv-retro","far fa-tv-retro","fal fa-tv-retro","fas fa-umbrella-beach","far fa-umbrella-beach","fal fa-umbrella-beach","fas fa-utensils","far fa-utensils","fal fa-utensils","fas fa-utensils-alt","far fa-utensils-alt","fal fa-utensils-alt","fas fa-vacuum","far fa-vacuum","fal fa-vacuum","fas fa-washer","far fa-washer","fal fa-washer","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wifi-slash","far fa-wifi-slash","fal fa-wifi-slash"]},{"id":"household","title":"Household","icons":["fas fa-air-conditioner","far fa-air-conditioner","fal fa-air-conditioner","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bed","far fa-bed","fal fa-bed","fas fa-bed-alt","far fa-bed-alt","fal fa-bed-alt","fas fa-bed-bunk","far fa-bed-bunk","fal fa-bed-bunk","fas fa-bed-empty","far fa-bed-empty","fal fa-bed-empty","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-on","far fa-bell-on","fal fa-bell-on","fas fa-blanket","far fa-blanket","fal fa-blanket","fas fa-blender","far fa-blender","fal fa-blender","fas fa-blinds","far fa-blinds","fal fa-blinds","fas fa-blinds-open","far fa-blinds-open","fal fa-blinds-open","fas fa-blinds-raised","far fa-blinds-raised","fal fa-blinds-raised","fas fa-books","far fa-books","fal fa-books","fal fa-box-tissue","far fa-box-tissue","fas fa-box-tissue","fas fa-camera-home","far fa-camera-home","fal fa-camera-home","fas fa-cctv","far fa-cctv","fal fa-cctv","fas fa-chair","far fa-chair","fal fa-chair","fas fa-chair-office","far fa-chair-office","fal fa-chair-office","fas fa-coffee","far fa-coffee","fal fa-coffee","fas fa-coffee-pot","far fa-coffee-pot","fal fa-coffee-pot","fas fa-couch","far fa-couch","fal fa-couch","fas fa-door-closed","far fa-door-closed","fal fa-door-closed","fas fa-door-open","far fa-door-open","fal fa-door-open","fas fa-dryer","far fa-dryer","fal fa-dryer","fas fa-dryer-alt","far fa-dryer-alt","fal fa-dryer-alt","fas fa-dungeon","far fa-dungeon","fal fa-dungeon","fas fa-fan","far fa-fan","fal fa-fan","fas fa-fan-table","far fa-fan-table","fal fa-fan-table","fas fa-faucet","far fa-faucet","fal fa-faucet","fas fa-faucet-drip","far fa-faucet-drip","fal fa-faucet-drip","fas fa-fireplace","far fa-fireplace","fal fa-fireplace","fas fa-flashlight","far fa-flashlight","fal fa-flashlight","fas fa-garage","far fa-garage","fal fa-garage","fas fa-garage-car","far fa-garage-car","fal fa-garage-car","fas fa-garage-open","far fa-garage-open","fal fa-garage-open","fas fa-heat","far fa-heat","fal fa-heat","fas fa-house","far fa-house","fal fa-house","fas fa-house-day","far fa-house-day","fal fa-house-day","fas fa-house-leave","far fa-house-leave","fal fa-house-leave","fas fa-house-night","far fa-house-night","fal fa-house-night","fas fa-house-return","far fa-house-return","fal fa-house-return","fas fa-house-signal","far fa-house-signal","fal fa-house-signal","fal fa-house-user","far fa-house-user","fas fa-house-user","fas fa-lamp","far fa-lamp","fal fa-lamp","fas fa-lamp-desk","far fa-lamp-desk","fal fa-lamp-desk","fas fa-lamp-floor","far fa-lamp-floor","fal fa-lamp-floor","fal fa-laptop-house","far fa-laptop-house","fas fa-laptop-house","fas fa-light-ceiling","far fa-light-ceiling","fal fa-light-ceiling","fas fa-light-switch","far fa-light-switch","fal fa-light-switch","fas fa-light-switch-off","far fa-light-switch-off","fal fa-light-switch-off","fas fa-light-switch-on","far fa-light-switch-on","fal fa-light-switch-on","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-lightbulb-on","far fa-lightbulb-on","fal fa-lightbulb-on","fas fa-loveseat","far fa-loveseat","fal fa-loveseat","fas fa-mailbox","far fa-mailbox","fal fa-mailbox","fas fa-microwave","far fa-microwave","fal fa-microwave","fas fa-outlet","far fa-outlet","fal fa-outlet","fas fa-oven","far fa-oven","fal fa-oven","fas fa-plug","far fa-plug","fal fa-plug","fal fa-pump-soap","far fa-pump-soap","fas fa-pump-soap","fas fa-refrigerator","far fa-refrigerator","fal fa-refrigerator","fas fa-sensor","far fa-sensor","fal fa-sensor","fas fa-sensor-alert","far fa-sensor-alert","fal fa-sensor-alert","fas fa-sensor-fire","far fa-sensor-fire","fal fa-sensor-fire","fas fa-sensor-on","far fa-sensor-on","fal fa-sensor-on","fas fa-sensor-smoke","far fa-sensor-smoke","fal fa-sensor-smoke","fas fa-shower","far fa-shower","fal fa-shower","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fal fa-sink","far fa-sink","fas fa-sink","fas fa-siren","far fa-siren","fal fa-siren","fas fa-siren-on","far fa-siren-on","fal fa-siren-on","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fal fa-soap","far fa-soap","fas fa-soap","fas fa-sort-circle","far fa-sort-circle","fal fa-sort-circle","fas fa-sort-circle-down","far fa-sort-circle-down","fal fa-sort-circle-down","fas fa-sort-circle-up","far fa-sort-circle-up","fal fa-sort-circle-up","fas fa-speaker","far fa-speaker","fal fa-speaker","fas fa-speakers","far fa-speakers","fal fa-speakers","fas fa-sprinkler","far fa-sprinkler","fal fa-sprinkler","fas fa-temperature-down","far fa-temperature-down","fal fa-temperature-down","fas fa-temperature-up","far fa-temperature-up","fal fa-temperature-up","fas fa-toilet-paper","far fa-toilet-paper","fal fa-toilet-paper","fas fa-toilet-paper-alt","far fa-toilet-paper-alt","fal fa-toilet-paper-alt","fal fa-toilet-paper-slash","far fa-toilet-paper-slash","fas fa-toilet-paper-slash","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-alt","far fa-tv-alt","fal fa-tv-alt","fas fa-tv-retro","far fa-tv-retro","fal fa-tv-retro","fas fa-vacuum","far fa-vacuum","fal fa-vacuum","fas fa-vacuum-robot","far fa-vacuum-robot","fal fa-vacuum-robot","fas fa-washer","far fa-washer","fal fa-washer","fas fa-webcam","far fa-webcam","fal fa-webcam","fas fa-window-frame","far fa-window-frame","fal fa-window-frame","fas fa-window-frame-open","far fa-window-frame-open","fal fa-window-frame-open"]},{"id":"images","title":"Images","icons":["fas fa-adjust","far fa-adjust","fal fa-adjust","fas fa-bolt","far fa-bolt","fal fa-bolt","fas fa-camera","far fa-camera","fal fa-camera","fas fa-camera-alt","far fa-camera-alt","fal fa-camera-alt","fas fa-camera-polaroid","far fa-camera-polaroid","fal fa-camera-polaroid","fas fa-camera-retro","far fa-camera-retro","fal fa-camera-retro","fas fa-chalkboard","far fa-chalkboard","fal fa-chalkboard","fas fa-clone","far fa-clone","fal fa-clone","fas fa-compress","far fa-compress","fal fa-compress","fas fa-compress-arrows-alt","far fa-compress-arrows-alt","fal fa-compress-arrows-alt","fas fa-compress-wide","far fa-compress-wide","fal fa-compress-wide","fas fa-expand","far fa-expand","fal fa-expand","fas fa-expand-wide","far fa-expand-wide","fal fa-expand-wide","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-file-image","far fa-file-image","fal fa-file-image","fas fa-film","far fa-film","fal fa-film","fas fa-film-alt","far fa-film-alt","fal fa-film-alt","fas fa-film-canister","far fa-film-canister","fal fa-film-canister","fas fa-id-badge","far fa-id-badge","fal fa-id-badge","fas fa-id-card","far fa-id-card","fal fa-id-card","fas fa-image","far fa-image","fal fa-image","fas fa-image-polaroid","far fa-image-polaroid","fal fa-image-polaroid","fas fa-images","far fa-images","fal fa-images","fas fa-photo-video","far fa-photo-video","fal fa-photo-video","fas fa-portrait","far fa-portrait","fal fa-portrait","fas fa-rectangle-landscape","far fa-rectangle-landscape","fal fa-rectangle-landscape","fas fa-rectangle-portrait","far fa-rectangle-portrait","fal fa-rectangle-portrait","fas fa-rectangle-wide","far fa-rectangle-wide","fal fa-rectangle-wide","fas fa-sliders-h","far fa-sliders-h","fal fa-sliders-h","fas fa-sliders-h-square","far fa-sliders-h-square","fal fa-sliders-h-square","fas fa-sliders-v","far fa-sliders-v","fal fa-sliders-v","fas fa-sliders-v-square","far fa-sliders-v-square","fal fa-sliders-v-square","fas fa-tint","far fa-tint","fal fa-tint","fab fa-unsplash"]},{"id":"interfaces","title":"Interfaces","icons":["fas fa-alarm-clock","far fa-alarm-clock","fal fa-alarm-clock","fas fa-award","far fa-award","fal fa-award","fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-ban","far fa-ban","fal fa-ban","fas fa-barcode","far fa-barcode","fal fa-barcode","fas fa-bars","far fa-bars","fal fa-bars","fas fa-beer","far fa-beer","fal fa-beer","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-blog","far fa-blog","fal fa-blog","fas fa-bug","far fa-bug","fal fa-bug","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-bullseye","far fa-bullseye","fal fa-bullseye","fas fa-calculator","far fa-calculator","fal fa-calculator","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-calendar-alt","far fa-calendar-alt","fal fa-calendar-alt","fas fa-calendar-check","far fa-calendar-check","fal fa-calendar-check","fas fa-calendar-edit","far fa-calendar-edit","fal fa-calendar-edit","fas fa-calendar-exclamation","far fa-calendar-exclamation","fal fa-calendar-exclamation","fas fa-calendar-minus","far fa-calendar-minus","fal fa-calendar-minus","fas fa-calendar-plus","far fa-calendar-plus","fal fa-calendar-plus","fas fa-calendar-times","far fa-calendar-times","fal fa-calendar-times","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-check","far fa-check","fal fa-check","fas fa-check-circle","far fa-check-circle","fal fa-check-circle","fas fa-check-double","far fa-check-double","fal fa-check-double","fas fa-check-square","far fa-check-square","fal fa-check-square","fas fa-circle","far fa-circle","fal fa-circle","fas fa-clipboard","far fa-clipboard","fal fa-clipboard","fas fa-clone","far fa-clone","fal fa-clone","fas fa-cloud","far fa-cloud","fal fa-cloud","fas fa-cloud-download","far fa-cloud-download","fal fa-cloud-download","fas fa-cloud-download-alt","far fa-cloud-download-alt","fal fa-cloud-download-alt","fas fa-cloud-upload","far fa-cloud-upload","fal fa-cloud-upload","fas fa-cloud-upload-alt","far fa-cloud-upload-alt","fal fa-cloud-upload-alt","fas fa-coffee","far fa-coffee","fal fa-coffee","fas fa-cog","far fa-cog","fal fa-cog","fas fa-cogs","far fa-cogs","fal fa-cogs","fas fa-copy","far fa-copy","fal fa-copy","fas fa-cut","far fa-cut","fal fa-cut","fas fa-database","far fa-database","fal fa-database","fas fa-dot-circle","far fa-dot-circle","fal fa-dot-circle","fas fa-download","far fa-download","fal fa-download","fas fa-edit","far fa-edit","fal fa-edit","fas fa-ellipsis-h","far fa-ellipsis-h","fal fa-ellipsis-h","fas fa-ellipsis-h-alt","far fa-ellipsis-h-alt","fal fa-ellipsis-h-alt","fas fa-ellipsis-v","far fa-ellipsis-v","fal fa-ellipsis-v","fas fa-ellipsis-v-alt","far fa-ellipsis-v-alt","fal fa-ellipsis-v-alt","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-open","far fa-envelope-open","fal fa-envelope-open","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-exclamation","far fa-exclamation","fal fa-exclamation","fas fa-exclamation-circle","far fa-exclamation-circle","fal fa-exclamation-circle","fas fa-exclamation-square","far fa-exclamation-square","fal fa-exclamation-square","fas fa-exclamation-triangle","far fa-exclamation-triangle","fal fa-exclamation-triangle","fas fa-external-link","far fa-external-link","fal fa-external-link","fas fa-external-link-alt","far fa-external-link-alt","fal fa-external-link-alt","fas fa-external-link-square","far fa-external-link-square","fal fa-external-link-square","fas fa-external-link-square-alt","far fa-external-link-square-alt","fal fa-external-link-square-alt","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-file","far fa-file","fal fa-file","fas fa-file-alt","far fa-file-alt","fal fa-file-alt","fas fa-file-download","far fa-file-download","fal fa-file-download","fas fa-file-export","far fa-file-export","fal fa-file-export","fas fa-file-import","far fa-file-import","fal fa-file-import","fas fa-file-search","far fa-file-search","fal fa-file-search","fas fa-file-upload","far fa-file-upload","fal fa-file-upload","fas fa-filter","far fa-filter","fal fa-filter","fas fa-fingerprint","far fa-fingerprint","fal fa-fingerprint","fas fa-flag","far fa-flag","fal fa-flag","fas fa-flag-checkered","far fa-flag-checkered","fal fa-flag-checkered","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-frown","far fa-frown","fal fa-frown","fas fa-glasses","far fa-glasses","fal fa-glasses","fas fa-grip-horizontal","far fa-grip-horizontal","fal fa-grip-horizontal","fas fa-grip-lines","far fa-grip-lines","fal fa-grip-lines","fas fa-grip-lines-vertical","far fa-grip-lines-vertical","fal fa-grip-lines-vertical","fas fa-grip-vertical","far fa-grip-vertical","fal fa-grip-vertical","fas fa-hashtag","far fa-hashtag","fal fa-hashtag","fas fa-heart","far fa-heart","fal fa-heart","fas fa-history","far fa-history","fal fa-history","fas fa-home","far fa-home","fal fa-home","fas fa-i-cursor","far fa-i-cursor","fal fa-i-cursor","fas fa-info","far fa-info","fal fa-info","fas fa-info-circle","far fa-info-circle","fal fa-info-circle","fas fa-info-square","far fa-info-square","fal fa-info-square","fas fa-language","far fa-language","fal fa-language","fal fa-lasso","far fa-lasso","fas fa-lasso","fas fa-magic","far fa-magic","fal fa-magic","fas fa-marker","far fa-marker","fal fa-marker","fas fa-medal","far fa-medal","fal fa-medal","fas fa-meh","far fa-meh","fal fa-meh","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-alt","far fa-microphone-alt","fal fa-microphone-alt","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-minus","far fa-minus","fal fa-minus","fas fa-minus-circle","far fa-minus-circle","fal fa-minus-circle","fas fa-minus-hexagon","far fa-minus-hexagon","fal fa-minus-hexagon","fas fa-minus-octagon","far fa-minus-octagon","fal fa-minus-octagon","fas fa-minus-square","far fa-minus-square","fal fa-minus-square","fas fa-paste","far fa-paste","fal fa-paste","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-alt","far fa-pen-alt","fal fa-pen-alt","fas fa-pen-fancy","far fa-pen-fancy","fal fa-pen-fancy","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-alt","far fa-pencil-alt","fal fa-pencil-alt","fas fa-plus","far fa-plus","fal fa-plus","fas fa-plus-circle","far fa-plus-circle","fal fa-plus-circle","fas fa-plus-hexagon","far fa-plus-hexagon","fal fa-plus-hexagon","fas fa-plus-octagon","far fa-plus-octagon","fal fa-plus-octagon","fas fa-plus-square","far fa-plus-square","fal fa-plus-square","fas fa-poo","far fa-poo","fal fa-poo","fas fa-qrcode","far fa-qrcode","fal fa-qrcode","fas fa-question","far fa-question","fal fa-question","fas fa-question-circle","far fa-question-circle","fal fa-question-circle","fas fa-question-square","far fa-question-square","fal fa-question-square","fas fa-quote-left","far fa-quote-left","fal fa-quote-left","fas fa-quote-right","far fa-quote-right","fal fa-quote-right","fas fa-redo","far fa-redo","fal fa-redo","fas fa-redo-alt","far fa-redo-alt","fal fa-redo-alt","fas fa-reply","far fa-reply","fal fa-reply","fas fa-reply-all","far fa-reply-all","fal fa-reply-all","fas fa-rss","far fa-rss","fal fa-rss","fas fa-rss-square","far fa-rss-square","fal fa-rss-square","fas fa-save","far fa-save","fal fa-save","fas fa-screwdriver","far fa-screwdriver","fal fa-screwdriver","fas fa-search","far fa-search","fal fa-search","fas fa-search-minus","far fa-search-minus","fal fa-search-minus","fas fa-search-plus","far fa-search-plus","fal fa-search-plus","fas fa-share","far fa-share","fal fa-share","fas fa-share-all","far fa-share-all","fal fa-share-all","fas fa-share-alt","far fa-share-alt","fal fa-share-alt","fas fa-share-alt-square","far fa-share-alt-square","fal fa-share-alt-square","fas fa-share-square","far fa-share-square","fal fa-share-square","fas fa-shield","far fa-shield","fal fa-shield","fas fa-shield-alt","far fa-shield-alt","fal fa-shield-alt","fas fa-sign-in","far fa-sign-in","fal fa-sign-in","fas fa-sign-in-alt","far fa-sign-in-alt","fal fa-sign-in-alt","fas fa-sign-out","far fa-sign-out","fal fa-sign-out","fas fa-sign-out-alt","far fa-sign-out-alt","fal fa-sign-out-alt","fas fa-signal","far fa-signal","fal fa-signal","fas fa-signal-1","far fa-signal-1","fal fa-signal-1","fas fa-signal-2","far fa-signal-2","fal fa-signal-2","fas fa-signal-3","far fa-signal-3","fal fa-signal-3","fas fa-signal-4","far fa-signal-4","fal fa-signal-4","fas fa-signal-alt","far fa-signal-alt","fal fa-signal-alt","fas fa-signal-alt-1","far fa-signal-alt-1","fal fa-signal-alt-1","fas fa-signal-alt-2","far fa-signal-alt-2","fal fa-signal-alt-2","fas fa-signal-alt-3","far fa-signal-alt-3","fal fa-signal-alt-3","fas fa-signal-alt-slash","far fa-signal-alt-slash","fal fa-signal-alt-slash","fas fa-signal-slash","far fa-signal-slash","fal fa-signal-slash","fas fa-sitemap","far fa-sitemap","fal fa-sitemap","fas fa-sliders-h","far fa-sliders-h","fal fa-sliders-h","fas fa-sliders-h-square","far fa-sliders-h-square","fal fa-sliders-h-square","fas fa-sliders-v","far fa-sliders-v","fal fa-sliders-v","fas fa-sliders-v-square","far fa-sliders-v-square","fal fa-sliders-v-square","fas fa-smile","far fa-smile","fal fa-smile","fas fa-sort","far fa-sort","fal fa-sort","fas fa-sort-alpha-down","far fa-sort-alpha-down","fal fa-sort-alpha-down","fas fa-sort-alpha-down-alt","far fa-sort-alpha-down-alt","fal fa-sort-alpha-down-alt","fas fa-sort-alpha-up","far fa-sort-alpha-up","fal fa-sort-alpha-up","fas fa-sort-alpha-up-alt","far fa-sort-alpha-up-alt","fal fa-sort-alpha-up-alt","fas fa-sort-alt","far fa-sort-alt","fal fa-sort-alt","fas fa-sort-amount-down","far fa-sort-amount-down","fal fa-sort-amount-down","fas fa-sort-amount-down-alt","far fa-sort-amount-down-alt","fal fa-sort-amount-down-alt","fas fa-sort-amount-up","far fa-sort-amount-up","fal fa-sort-amount-up","fas fa-sort-amount-up-alt","far fa-sort-amount-up-alt","fal fa-sort-amount-up-alt","fas fa-sort-down","far fa-sort-down","fal fa-sort-down","fas fa-sort-numeric-down","far fa-sort-numeric-down","fal fa-sort-numeric-down","fas fa-sort-numeric-down-alt","far fa-sort-numeric-down-alt","fal fa-sort-numeric-down-alt","fas fa-sort-numeric-up","far fa-sort-numeric-up","fal fa-sort-numeric-up","fas fa-sort-numeric-up-alt","far fa-sort-numeric-up-alt","fal fa-sort-numeric-up-alt","fas fa-sort-up","far fa-sort-up","fal fa-sort-up","fas fa-star","far fa-star","fal fa-star","fas fa-star-exclamation","far fa-star-exclamation","fal fa-star-exclamation","fas fa-star-half","far fa-star-half","fal fa-star-half","fas fa-sync","far fa-sync","fal fa-sync","fas fa-sync-alt","far fa-sync-alt","fal fa-sync-alt","fas fa-thumbs-down","far fa-thumbs-down","fal fa-thumbs-down","fas fa-thumbs-up","far fa-thumbs-up","fal fa-thumbs-up","fas fa-times","far fa-times","fal fa-times","fas fa-times-circle","far fa-times-circle","fal fa-times-circle","fas fa-times-hexagon","far fa-times-hexagon","fal fa-times-hexagon","fas fa-times-octagon","far fa-times-octagon","fal fa-times-octagon","fas fa-times-square","far fa-times-square","fal fa-times-square","fas fa-toggle-off","far fa-toggle-off","fal fa-toggle-off","fas fa-toggle-on","far fa-toggle-on","fal fa-toggle-on","fas fa-tools","far fa-tools","fal fa-tools","fas fa-trash","far fa-trash","fal fa-trash","fas fa-trash-alt","far fa-trash-alt","fal fa-trash-alt","fas fa-trash-restore","far fa-trash-restore","fal fa-trash-restore","fas fa-trash-restore-alt","far fa-trash-restore-alt","fal fa-trash-restore-alt","fas fa-trash-undo","far fa-trash-undo","fal fa-trash-undo","fas fa-trash-undo-alt","far fa-trash-undo-alt","fal fa-trash-undo-alt","fas fa-trophy","far fa-trophy","fal fa-trophy","fas fa-trophy-alt","far fa-trophy-alt","fal fa-trophy-alt","fas fa-undo","far fa-undo","fal fa-undo","fas fa-undo-alt","far fa-undo-alt","fal fa-undo-alt","fas fa-upload","far fa-upload","fal fa-upload","fas fa-user","far fa-user","fal fa-user","fas fa-user-alt","far fa-user-alt","fal fa-user-alt","fas fa-user-circle","far fa-user-circle","fal fa-user-circle","fas fa-volume","far fa-volume","fal fa-volume","fas fa-volume-down","far fa-volume-down","fal fa-volume-down","fas fa-volume-mute","far fa-volume-mute","fal fa-volume-mute","fas fa-volume-off","far fa-volume-off","fal fa-volume-off","fas fa-volume-slash","far fa-volume-slash","fal fa-volume-slash","fas fa-volume-up","far fa-volume-up","fal fa-volume-up","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wifi-1","far fa-wifi-1","fal fa-wifi-1","fas fa-wifi-2","far fa-wifi-2","fal fa-wifi-2","fas fa-wifi-slash","far fa-wifi-slash","fal fa-wifi-slash","fas fa-wrench","far fa-wrench","fal fa-wrench"]},{"id":"logistics","title":"Logistics","icons":["fas fa-barcode-alt","far fa-barcode-alt","fal fa-barcode-alt","fas fa-barcode-read","far fa-barcode-read","fal fa-barcode-read","fas fa-barcode-scan","far fa-barcode-scan","fal fa-barcode-scan","fas fa-box","far fa-box","fal fa-box","fas fa-box-check","far fa-box-check","fal fa-box-check","fas fa-boxes","far fa-boxes","fal fa-boxes","fas fa-clipboard-check","far fa-clipboard-check","fal fa-clipboard-check","fas fa-clipboard-list","far fa-clipboard-list","fal fa-clipboard-list","fas fa-conveyor-belt","far fa-conveyor-belt","fal fa-conveyor-belt","fas fa-conveyor-belt-alt","far fa-conveyor-belt-alt","fal fa-conveyor-belt-alt","fas fa-dolly","far fa-dolly","fal fa-dolly","fas fa-dolly-empty","far fa-dolly-empty","fal fa-dolly-empty","fas fa-dolly-flatbed","far fa-dolly-flatbed","fal fa-dolly-flatbed","fas fa-dolly-flatbed-alt","far fa-dolly-flatbed-alt","fal fa-dolly-flatbed-alt","fas fa-dolly-flatbed-empty","far fa-dolly-flatbed-empty","fal fa-dolly-flatbed-empty","fas fa-forklift","far fa-forklift","fal fa-forklift","fas fa-hand-holding-box","far fa-hand-holding-box","fal fa-hand-holding-box","fas fa-hand-receiving","far fa-hand-receiving","fal fa-hand-receiving","fas fa-hard-hat","far fa-hard-hat","fal fa-hard-hat","fas fa-inventory","far fa-inventory","fal fa-inventory","fas fa-pallet","far fa-pallet","fal fa-pallet","fas fa-pallet-alt","far fa-pallet-alt","fal fa-pallet-alt","fas fa-scanner","far fa-scanner","fal fa-scanner","fas fa-scanner-keyboard","far fa-scanner-keyboard","fal fa-scanner-keyboard","fas fa-scanner-touchscreen","far fa-scanner-touchscreen","fal fa-scanner-touchscreen","fas fa-shipping-fast","far fa-shipping-fast","fal fa-shipping-fast","fas fa-shipping-timed","far fa-shipping-timed","fal fa-shipping-timed","fas fa-tablet-rugged","far fa-tablet-rugged","fal fa-tablet-rugged","fas fa-truck","far fa-truck","fal fa-truck","fas fa-user-hard-hat","far fa-user-hard-hat","fal fa-user-hard-hat","fas fa-warehouse","far fa-warehouse","fal fa-warehouse","fas fa-warehouse-alt","far fa-warehouse-alt","fal fa-warehouse-alt"]},{"id":"maps","title":"Maps","icons":["fas fa-ambulance","far fa-ambulance","fal fa-ambulance","fas fa-anchor","far fa-anchor","fal fa-anchor","fas fa-bags-shopping","far fa-bags-shopping","fal fa-bags-shopping","fas fa-balance-scale","far fa-balance-scale","fal fa-balance-scale","fas fa-balance-scale-left","far fa-balance-scale-left","fal fa-balance-scale-left","fas fa-balance-scale-right","far fa-balance-scale-right","fal fa-balance-scale-right","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bed","far fa-bed","fal fa-bed","fas fa-beer","far fa-beer","fal fa-beer","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-bicycle","far fa-bicycle","fal fa-bicycle","fas fa-binoculars","far fa-binoculars","fal fa-binoculars","fas fa-birthday-cake","far fa-birthday-cake","fal fa-birthday-cake","fas fa-blind","far fa-blind","fal fa-blind","fas fa-bomb","far fa-bomb","fal fa-bomb","fas fa-book","far fa-book","fal fa-book","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fas fa-briefcase","far fa-briefcase","fal fa-briefcase","fas fa-building","far fa-building","fal fa-building","fas fa-car","far fa-car","fal fa-car","fas fa-cctv","far fa-cctv","fal fa-cctv","fas fa-coffee","far fa-coffee","fal fa-coffee","fas fa-compass-slash","far fa-compass-slash","fal fa-compass-slash","fas fa-crosshairs","far fa-crosshairs","fal fa-crosshairs","fas fa-directions","far fa-directions","fal fa-directions","fas fa-do-not-enter","far fa-do-not-enter","fal fa-do-not-enter","fas fa-dollar-sign","far fa-dollar-sign","fal fa-dollar-sign","fas fa-draw-circle","far fa-draw-circle","fal fa-draw-circle","fas fa-draw-polygon","far fa-draw-polygon","fal fa-draw-polygon","fas fa-draw-square","far fa-draw-square","fal fa-draw-square","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-fighter-jet","far fa-fighter-jet","fal fa-fighter-jet","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-alt","far fa-fire-alt","fal fa-fire-alt","fas fa-fire-extinguisher","far fa-fire-extinguisher","fal fa-fire-extinguisher","fas fa-flag","far fa-flag","fal fa-flag","fas fa-flag-checkered","far fa-flag-checkered","fal fa-flag-checkered","fas fa-flask","far fa-flask","fal fa-flask","fas fa-gamepad","far fa-gamepad","fal fa-gamepad","fas fa-gavel","far fa-gavel","fal fa-gavel","fas fa-gift","far fa-gift","fal fa-gift","fas fa-glass-martini","far fa-glass-martini","fal fa-glass-martini","fas fa-globe","far fa-globe","fal fa-globe","fas fa-graduation-cap","far fa-graduation-cap","fal fa-graduation-cap","fas fa-h-square","far fa-h-square","fal fa-h-square","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heartbeat","far fa-heartbeat","fal fa-heartbeat","fas fa-helicopter","far fa-helicopter","fal fa-helicopter","fas fa-home","far fa-home","fal fa-home","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-image","far fa-image","fal fa-image","fas fa-images","far fa-images","fal fa-images","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-alt","far fa-industry-alt","fal fa-industry-alt","fas fa-info","far fa-info","fal fa-info","fas fa-info-circle","far fa-info-circle","fal fa-info-circle","fas fa-info-square","far fa-info-square","fal fa-info-square","fas fa-key","far fa-key","fal fa-key","fas fa-landmark","far fa-landmark","fal fa-landmark","fas fa-layer-group","far fa-layer-group","fal fa-layer-group","fas fa-layer-minus","far fa-layer-minus","fal fa-layer-minus","fas fa-layer-plus","far fa-layer-plus","fal fa-layer-plus","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-lemon","far fa-lemon","fal fa-lemon","fas fa-life-ring","far fa-life-ring","fal fa-life-ring","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-location","far fa-location","fal fa-location","fas fa-location-arrow","far fa-location-arrow","fal fa-location-arrow","fas fa-location-circle","far fa-location-circle","fal fa-location-circle","fas fa-location-slash","far fa-location-slash","fal fa-location-slash","fas fa-low-vision","far fa-low-vision","fal fa-low-vision","fas fa-magnet","far fa-magnet","fal fa-magnet","fas fa-male","far fa-male","fal fa-male","fas fa-map","far fa-map","fal fa-map","fas fa-map-marker","far fa-map-marker","fal fa-map-marker","fas fa-map-marker-alt","far fa-map-marker-alt","fal fa-map-marker-alt","fas fa-map-marker-alt-slash","far fa-map-marker-alt-slash","fal fa-map-marker-alt-slash","fas fa-map-marker-check","far fa-map-marker-check","fal fa-map-marker-check","fas fa-map-marker-edit","far fa-map-marker-edit","fal fa-map-marker-edit","fas fa-map-marker-exclamation","far fa-map-marker-exclamation","fal fa-map-marker-exclamation","fas fa-map-marker-minus","far fa-map-marker-minus","fal fa-map-marker-minus","fas fa-map-marker-plus","far fa-map-marker-plus","fal fa-map-marker-plus","fas fa-map-marker-question","far fa-map-marker-question","fal fa-map-marker-question","fas fa-map-marker-slash","far fa-map-marker-slash","fal fa-map-marker-slash","fas fa-map-marker-smile","far fa-map-marker-smile","fal fa-map-marker-smile","fas fa-map-marker-times","far fa-map-marker-times","fal fa-map-marker-times","fas fa-map-pin","far fa-map-pin","fal fa-map-pin","fas fa-map-signs","far fa-map-signs","fal fa-map-signs","fas fa-medkit","far fa-medkit","fal fa-medkit","fas fa-money-bill","far fa-money-bill","fal fa-money-bill","fas fa-money-bill-alt","far fa-money-bill-alt","fal fa-money-bill-alt","fas fa-motorcycle","far fa-motorcycle","fal fa-motorcycle","fas fa-music","far fa-music","fal fa-music","fas fa-newspaper","far fa-newspaper","fal fa-newspaper","fas fa-parking","far fa-parking","fal fa-parking","fas fa-parking-circle","far fa-parking-circle","fal fa-parking-circle","fas fa-parking-circle-slash","far fa-parking-circle-slash","fal fa-parking-circle-slash","fas fa-parking-slash","far fa-parking-slash","fal fa-parking-slash","fas fa-paw","far fa-paw","fal fa-paw","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-alt","far fa-phone-alt","fal fa-phone-alt","fas fa-phone-square","far fa-phone-square","fal fa-phone-square","fas fa-phone-square-alt","far fa-phone-square-alt","fal fa-phone-square-alt","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-plane","far fa-plane","fal fa-plane","fas fa-plane-alt","far fa-plane-alt","fal fa-plane-alt","fas fa-plug","far fa-plug","fal fa-plug","fas fa-plus","far fa-plus","fal fa-plus","fas fa-plus-square","far fa-plus-square","fal fa-plus-square","fas fa-print","far fa-print","fal fa-print","fas fa-recycle","far fa-recycle","fal fa-recycle","fas fa-restroom","far fa-restroom","fal fa-restroom","fas fa-road","far fa-road","fal fa-road","fas fa-rocket","far fa-rocket","fal fa-rocket","fas fa-route","far fa-route","fal fa-route","fas fa-route-highway","far fa-route-highway","fal fa-route-highway","fas fa-route-interstate","far fa-route-interstate","fal fa-route-interstate","fas fa-search","far fa-search","fal fa-search","fas fa-search-minus","far fa-search-minus","fal fa-search-minus","fas fa-search-plus","far fa-search-plus","fal fa-search-plus","fas fa-ship","far fa-ship","fal fa-ship","fas fa-shoe-prints","far fa-shoe-prints","fal fa-shoe-prints","fas fa-shopping-bag","far fa-shopping-bag","fal fa-shopping-bag","fas fa-shopping-basket","far fa-shopping-basket","fal fa-shopping-basket","fas fa-shopping-cart","far fa-shopping-cart","fal fa-shopping-cart","fas fa-shower","far fa-shower","fal fa-shower","fal fa-skull-cow","far fa-skull-cow","fas fa-skull-cow","fas fa-snowplow","far fa-snowplow","fal fa-snowplow","fas fa-street-view","far fa-street-view","fal fa-street-view","fas fa-subway","far fa-subway","fal fa-subway","fas fa-suitcase","far fa-suitcase","fal fa-suitcase","fas fa-tag","far fa-tag","fal fa-tag","fas fa-tags","far fa-tags","fal fa-tags","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack","fas fa-ticket","far fa-ticket","fal fa-ticket","fas fa-ticket-alt","far fa-ticket-alt","fal fa-ticket-alt","fas fa-tint","far fa-tint","fal fa-tint","fas fa-traffic-cone","far fa-traffic-cone","fal fa-traffic-cone","fas fa-traffic-light","far fa-traffic-light","fal fa-traffic-light","fas fa-traffic-light-go","far fa-traffic-light-go","fal fa-traffic-light-go","fas fa-traffic-light-slow","far fa-traffic-light-slow","fal fa-traffic-light-slow","fas fa-traffic-light-stop","far fa-traffic-light-stop","fal fa-traffic-light-stop","fas fa-train","far fa-train","fal fa-train","fas fa-tram","far fa-tram","fal fa-tram","fas fa-tree","far fa-tree","fal fa-tree","fas fa-tree-alt","far fa-tree-alt","fal fa-tree-alt","fas fa-trophy","far fa-trophy","fal fa-trophy","fas fa-trophy-alt","far fa-trophy-alt","fal fa-trophy-alt","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-plow","far fa-truck-plow","fal fa-truck-plow","fas fa-tty","far fa-tty","fal fa-tty","fas fa-umbrella","far fa-umbrella","fal fa-umbrella","fas fa-university","far fa-university","fal fa-university","fas fa-usd-circle","far fa-usd-circle","fal fa-usd-circle","fas fa-usd-square","far fa-usd-square","fal fa-usd-square","fas fa-utensil-fork","far fa-utensil-fork","fal fa-utensil-fork","fas fa-utensil-knife","far fa-utensil-knife","fal fa-utensil-knife","fas fa-utensil-spoon","far fa-utensil-spoon","fal fa-utensil-spoon","fas fa-utensils","far fa-utensils","fal fa-utensils","fas fa-utensils-alt","far fa-utensils-alt","fal fa-utensils-alt","fas fa-vest","fal fa-vest","far fa-vest","fas fa-vest-patches","fal fa-vest-patches","far fa-vest-patches","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass","fas fa-wrench","far fa-wrench","fal fa-wrench"]},{"id":"maritime","title":"Maritime","icons":["fas fa-anchor","far fa-anchor","fal fa-anchor","fas fa-binoculars","far fa-binoculars","fal fa-binoculars","fas fa-compass","far fa-compass","fal fa-compass","fas fa-compass-slash","far fa-compass-slash","fal fa-compass-slash","fas fa-container-storage","far fa-container-storage","fal fa-container-storage","fas fa-dharmachakra","far fa-dharmachakra","fal fa-dharmachakra","fas fa-duck","far fa-duck","fal fa-duck","fas fa-frog","far fa-frog","fal fa-frog","fas fa-island-tropical","far fa-island-tropical","fal fa-island-tropical","fas fa-raindrops","far fa-raindrops","fal fa-raindrops","fas fa-ship","far fa-ship","fal fa-ship","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-stars","far fa-stars","fal fa-stars","fas fa-swimmer","far fa-swimmer","fal fa-swimmer","fas fa-treasure-chest","far fa-treasure-chest","fal fa-treasure-chest","fas fa-turtle","far fa-turtle","fal fa-turtle","fas fa-walkie-talkie","far fa-walkie-talkie","fal fa-walkie-talkie","fas fa-water","far fa-water","fal fa-water","fas fa-water-lower","far fa-water-lower","fal fa-water-lower","fas fa-water-rise","far fa-water-rise","fal fa-water-rise","fas fa-whale","far fa-whale","fal fa-whale","fas fa-wind","far fa-wind","fal fa-wind","fas fa-wind-warning","far fa-wind-warning","fal fa-wind-warning"]},{"id":"marketing","title":"Marketing","icons":["fas fa-ad","far fa-ad","fal fa-ad","fas fa-analytics","far fa-analytics","fal fa-analytics","fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-badge-dollar","far fa-badge-dollar","fal fa-badge-dollar","fas fa-badge-percent","far fa-badge-percent","fal fa-badge-percent","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-bullseye","far fa-bullseye","fal fa-bullseye","fas fa-bullseye-arrow","far fa-bullseye-arrow","fal fa-bullseye-arrow","fas fa-bullseye-pointer","far fa-bullseye-pointer","fal fa-bullseye-pointer","fas fa-comment-alt-dollar","far fa-comment-alt-dollar","fal fa-comment-alt-dollar","fas fa-comment-dollar","far fa-comment-dollar","fal fa-comment-dollar","fas fa-comments-alt-dollar","far fa-comments-alt-dollar","fal fa-comments-alt-dollar","fas fa-comments-dollar","far fa-comments-dollar","fal fa-comments-dollar","fas fa-envelope-open-dollar","far fa-envelope-open-dollar","fal fa-envelope-open-dollar","fas fa-envelope-open-text","far fa-envelope-open-text","fal fa-envelope-open-text","fas fa-funnel-dollar","far fa-funnel-dollar","fal fa-funnel-dollar","fas fa-gift-card","far fa-gift-card","fal fa-gift-card","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-lightbulb-dollar","far fa-lightbulb-dollar","fal fa-lightbulb-dollar","fas fa-lightbulb-exclamation","far fa-lightbulb-exclamation","fal fa-lightbulb-exclamation","fas fa-lightbulb-on","far fa-lightbulb-on","fal fa-lightbulb-on","fas fa-lightbulb-slash","far fa-lightbulb-slash","fal fa-lightbulb-slash","fas fa-mail-bulk","far fa-mail-bulk","fal fa-mail-bulk","fas fa-megaphone","far fa-megaphone","fal fa-megaphone","fas fa-poll","far fa-poll","fal fa-poll","fas fa-poll-h","far fa-poll-h","fal fa-poll-h","fas fa-search-dollar","far fa-search-dollar","fal fa-search-dollar","fas fa-search-location","far fa-search-location","fal fa-search-location","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-user-crown","far fa-user-crown","fal fa-user-crown","fas fa-users-crown","far fa-users-crown","fal fa-users-crown"]},{"id":"mathematics","title":"Mathematics","icons":["fas fa-abacus","far fa-abacus","fal fa-abacus","fas fa-calculator","far fa-calculator","fal fa-calculator","fas fa-calculator-alt","far fa-calculator-alt","fal fa-calculator-alt","fas fa-divide","far fa-divide","fal fa-divide","fas fa-empty-set","far fa-empty-set","fal fa-empty-set","fas fa-equals","far fa-equals","fal fa-equals","fas fa-function","far fa-function","fal fa-function","fas fa-greater-than","far fa-greater-than","fal fa-greater-than","fas fa-greater-than-equal","far fa-greater-than-equal","fal fa-greater-than-equal","fas fa-infinity","far fa-infinity","fal fa-infinity","fas fa-integral","far fa-integral","fal fa-integral","fas fa-intersection","far fa-intersection","fal fa-intersection","fas fa-lambda","far fa-lambda","fal fa-lambda","fas fa-less-than","far fa-less-than","fal fa-less-than","fas fa-less-than-equal","far fa-less-than-equal","fal fa-less-than-equal","fas fa-minus","far fa-minus","fal fa-minus","fas fa-not-equal","far fa-not-equal","fal fa-not-equal","fas fa-omega","far fa-omega","fal fa-omega","fas fa-percentage","far fa-percentage","fal fa-percentage","fas fa-pi","far fa-pi","fal fa-pi","fas fa-plus","far fa-plus","fal fa-plus","fas fa-sigma","far fa-sigma","fal fa-sigma","fas fa-square-root","far fa-square-root","fal fa-square-root","fas fa-square-root-alt","far fa-square-root-alt","fal fa-square-root-alt","fas fa-subscript","far fa-subscript","fal fa-subscript","fas fa-superscript","far fa-superscript","fal fa-superscript","fas fa-tally","far fa-tally","fal fa-tally","fas fa-theta","far fa-theta","fal fa-theta","fas fa-tilde","far fa-tilde","fal fa-tilde","fas fa-times","far fa-times","fal fa-times","fas fa-union","far fa-union","fal fa-union","fas fa-value-absolute","far fa-value-absolute","fal fa-value-absolute","fas fa-watch-calculator","far fa-watch-calculator","fal fa-watch-calculator","fas fa-wave-sine","far fa-wave-sine","fal fa-wave-sine","fal fa-wave-square","far fa-wave-square","fas fa-wave-square","fas fa-wave-triangle","far fa-wave-triangle","fal fa-wave-triangle"]},{"id":"medical","title":"Medical","icons":["fas fa-allergies","far fa-allergies","fal fa-allergies","fas fa-ambulance","far fa-ambulance","fal fa-ambulance","fal fa-bacteria","far fa-bacteria","fas fa-bacteria","fal fa-bacterium","far fa-bacterium","fas fa-bacterium","fas fa-band-aid","far fa-band-aid","fal fa-band-aid","fas fa-biohazard","far fa-biohazard","fal fa-biohazard","fas fa-bone","far fa-bone","fal fa-bone","fas fa-bone-break","far fa-bone-break","fal fa-bone-break","fas fa-bong","far fa-bong","fal fa-bong","fas fa-book-medical","far fa-book-medical","fal fa-book-medical","fas fa-book-user","far fa-book-user","fal fa-book-user","fas fa-books-medical","far fa-books-medical","fal fa-books-medical","fas fa-brain","far fa-brain","fal fa-brain","fas fa-briefcase-medical","far fa-briefcase-medical","fal fa-briefcase-medical","fas fa-burn","far fa-burn","fal fa-burn","fas fa-cannabis","far fa-cannabis","fal fa-cannabis","fas fa-capsules","far fa-capsules","fal fa-capsules","fas fa-clinic-medical","far fa-clinic-medical","fal fa-clinic-medical","fas fa-clipboard-prescription","far fa-clipboard-prescription","fal fa-clipboard-prescription","fas fa-clipboard-user","far fa-clipboard-user","fal fa-clipboard-user","fas fa-comment-alt-medical","far fa-comment-alt-medical","fal fa-comment-alt-medical","fas fa-comment-medical","far fa-comment-medical","fal fa-comment-medical","fas fa-crutch","far fa-crutch","fal fa-crutch","fas fa-crutches","far fa-crutches","fal fa-crutches","fas fa-diagnoses","far fa-diagnoses","fal fa-diagnoses","fas fa-disease","far fa-disease","fal fa-disease","fas fa-dna","far fa-dna","fal fa-dna","fas fa-ear","far fa-ear","fal fa-ear","fas fa-file-medical","far fa-file-medical","fal fa-file-medical","fas fa-file-medical-alt","far fa-file-medical-alt","fal fa-file-medical-alt","fas fa-file-prescription","far fa-file-prescription","fal fa-file-prescription","fas fa-files-medical","far fa-files-medical","fal fa-files-medical","fas fa-first-aid","far fa-first-aid","fal fa-first-aid","fal fa-hand-holding-medical","far fa-hand-holding-medical","fas fa-hand-holding-medical","fas fa-head-side-brain","far fa-head-side-brain","fal fa-head-side-brain","fal fa-head-side-cough","far fa-head-side-cough","fas fa-head-side-cough","fal fa-head-side-cough-slash","far fa-head-side-cough-slash","fas fa-head-side-cough-slash","fal fa-head-side-mask","far fa-head-side-mask","fas fa-head-side-mask","fas fa-head-side-medical","far fa-head-side-medical","fal fa-head-side-medical","fal fa-head-side-virus","far fa-head-side-virus","fas fa-head-side-virus","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-rate","far fa-heart-rate","fal fa-heart-rate","fas fa-heartbeat","far fa-heartbeat","fal fa-heartbeat","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-hospital-alt","far fa-hospital-alt","fal fa-hospital-alt","fas fa-hospital-symbol","far fa-hospital-symbol","fal fa-hospital-symbol","fas fa-hospital-user","far fa-hospital-user","fal fa-hospital-user","fas fa-hospitals","far fa-hospitals","fal fa-hospitals","fas fa-id-card-alt","far fa-id-card-alt","fal fa-id-card-alt","fas fa-inhaler","far fa-inhaler","fal fa-inhaler","fas fa-joint","far fa-joint","fal fa-joint","fas fa-kidneys","far fa-kidneys","fal fa-kidneys","fas fa-laptop-medical","far fa-laptop-medical","fal fa-laptop-medical","fas fa-lips","far fa-lips","fal fa-lips","fas fa-lungs","far fa-lungs","fal fa-lungs","fal fa-lungs-virus","far fa-lungs-virus","fas fa-lungs-virus","fas fa-microscope","far fa-microscope","fal fa-microscope","fas fa-monitor-heart-rate","far fa-monitor-heart-rate","fal fa-monitor-heart-rate","fas fa-mortar-pestle","far fa-mortar-pestle","fal fa-mortar-pestle","fas fa-notes-medical","far fa-notes-medical","fal fa-notes-medical","fas fa-pager","far fa-pager","fal fa-pager","fas fa-pills","far fa-pills","fal fa-pills","fas fa-plus","far fa-plus","fal fa-plus","fas fa-poop","far fa-poop","fal fa-poop","fas fa-prescription","far fa-prescription","fal fa-prescription","fas fa-prescription-bottle","far fa-prescription-bottle","fal fa-prescription-bottle","fas fa-prescription-bottle-alt","far fa-prescription-bottle-alt","fal fa-prescription-bottle-alt","fas fa-procedures","far fa-procedures","fal fa-procedures","fal fa-pump-medical","far fa-pump-medical","fas fa-pump-medical","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-radiation-alt","far fa-radiation-alt","fal fa-radiation-alt","fas fa-scalpel","far fa-scalpel","fal fa-scalpel","fas fa-scalpel-path","far fa-scalpel-path","fal fa-scalpel-path","fal fa-shield-virus","far fa-shield-virus","fas fa-shield-virus","fas fa-skeleton","far fa-skeleton","fal fa-skeleton","fas fa-smoking","far fa-smoking","fal fa-smoking","fas fa-smoking-ban","far fa-smoking-ban","fal fa-smoking-ban","fas fa-star-of-life","far fa-star-of-life","fal fa-star-of-life","fas fa-stethoscope","far fa-stethoscope","fal fa-stethoscope","fas fa-stomach","far fa-stomach","fal fa-stomach","fas fa-stretcher","far fa-stretcher","fal fa-stretcher","fas fa-syringe","far fa-syringe","fal fa-syringe","fas fa-tablets","far fa-tablets","fal fa-tablets","fas fa-teeth","far fa-teeth","fal fa-teeth","fas fa-teeth-open","far fa-teeth-open","fal fa-teeth-open","fas fa-thermometer","far fa-thermometer","fal fa-thermometer","fas fa-tooth","far fa-tooth","fal fa-tooth","fas fa-toothbrush","far fa-toothbrush","fal fa-toothbrush","fas fa-user-md","far fa-user-md","fal fa-user-md","fas fa-user-md-chat","far fa-user-md-chat","fal fa-user-md-chat","fas fa-user-nurse","far fa-user-nurse","fal fa-user-nurse","fas fa-users-medical","far fa-users-medical","fal fa-users-medical","fas fa-vial","far fa-vial","fal fa-vial","fas fa-vials","far fa-vials","fal fa-vials","fal fa-virus","far fa-virus","fas fa-virus","fal fa-virus-slash","far fa-virus-slash","fas fa-virus-slash","fal fa-viruses","far fa-viruses","fas fa-viruses","fas fa-walker","far fa-walker","fal fa-walker","fas fa-watch-fitness","far fa-watch-fitness","fal fa-watch-fitness","fas fa-weight","far fa-weight","fal fa-weight","fas fa-x-ray","far fa-x-ray","fal fa-x-ray"]},{"id":"moving","title":"Moving","icons":["fas fa-archive","far fa-archive","fal fa-archive","fas fa-blanket","far fa-blanket","fal fa-blanket","fas fa-box-alt","far fa-box-alt","fal fa-box-alt","fas fa-box-fragile","far fa-box-fragile","fal fa-box-fragile","fas fa-box-full","far fa-box-full","fal fa-box-full","fas fa-box-open","far fa-box-open","fal fa-box-open","fas fa-box-up","far fa-box-up","fal fa-box-up","fas fa-boxes-alt","far fa-boxes-alt","fal fa-boxes-alt","fas fa-caravan","far fa-caravan","fal fa-caravan","fas fa-caravan-alt","far fa-caravan-alt","fal fa-caravan-alt","fas fa-container-storage","far fa-container-storage","fal fa-container-storage","fas fa-couch","far fa-couch","fal fa-couch","fas fa-dolly","far fa-dolly","fal fa-dolly","fas fa-dolly-empty","far fa-dolly-empty","fal fa-dolly-empty","fas fa-fragile","far fa-fragile","fal fa-fragile","fas fa-house-leave","far fa-house-leave","fal fa-house-leave","fas fa-house-return","far fa-house-return","fal fa-house-return","fas fa-lamp","far fa-lamp","fal fa-lamp","fas fa-loveseat","far fa-loveseat","fal fa-loveseat","fas fa-people-carry","far fa-people-carry","fal fa-people-carry","fas fa-person-carry","far fa-person-carry","fal fa-person-carry","fas fa-person-dolly","far fa-person-dolly","fal fa-person-dolly","fas fa-person-dolly-empty","far fa-person-dolly-empty","fal fa-person-dolly-empty","fas fa-ramp-loading","far fa-ramp-loading","fal fa-ramp-loading","fas fa-route","far fa-route","fal fa-route","fas fa-sign","far fa-sign","fal fa-sign","fas fa-suitcase","far fa-suitcase","fal fa-suitcase","fas fa-tape","far fa-tape","fal fa-tape","fas fa-trailer","far fa-trailer","fal fa-trailer","fas fa-truck-container","far fa-truck-container","fal fa-truck-container","fas fa-truck-couch","far fa-truck-couch","fal fa-truck-couch","fas fa-truck-loading","far fa-truck-loading","fal fa-truck-loading","fas fa-truck-moving","far fa-truck-moving","fal fa-truck-moving","fas fa-truck-ramp","far fa-truck-ramp","fal fa-truck-ramp","fas fa-vacuum","far fa-vacuum","fal fa-vacuum","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass"]},{"id":"music","title":"Music","icons":["fas fa-album","far fa-album","fal fa-album","fas fa-album-collection","far fa-album-collection","fal fa-album-collection","fal fa-amp-guitar","far fa-amp-guitar","fas fa-amp-guitar","fas fa-banjo","far fa-banjo","fal fa-banjo","fas fa-bells","far fa-bells","fal fa-bells","fas fa-boombox","far fa-boombox","fal fa-boombox","fas fa-cassette-tape","far fa-cassette-tape","fal fa-cassette-tape","fas fa-clarinet","far fa-clarinet","fal fa-clarinet","fas fa-cloud-music","far fa-cloud-music","fal fa-cloud-music","fas fa-comment-alt-music","far fa-comment-alt-music","fal fa-comment-alt-music","fas fa-comment-music","far fa-comment-music","fal fa-comment-music","fas fa-compact-disc","far fa-compact-disc","fal fa-compact-disc","fas fa-computer-speaker","far fa-computer-speaker","fal fa-computer-speaker","fas fa-cowbell","far fa-cowbell","fal fa-cowbell","fas fa-cowbell-more","far fa-cowbell-more","fal fa-cowbell-more","fas fa-drum","far fa-drum","fal fa-drum","fas fa-drum-steelpan","far fa-drum-steelpan","fal fa-drum-steelpan","fas fa-ear","far fa-ear","fal fa-ear","fas fa-file-audio","far fa-file-audio","fal fa-file-audio","fas fa-file-music","far fa-file-music","fal fa-file-music","fas fa-flute","far fa-flute","fal fa-flute","fas fa-gramophone","far fa-gramophone","fal fa-gramophone","fas fa-guitar","far fa-guitar","fal fa-guitar","fas fa-guitar-electric","far fa-guitar-electric","fal fa-guitar-electric","fas fa-guitars","far fa-guitars","fal fa-guitars","fas fa-head-side-headphones","far fa-head-side-headphones","fal fa-head-side-headphones","fas fa-headphones","far fa-headphones","fal fa-headphones","fas fa-headphones-alt","far fa-headphones-alt","fal fa-headphones-alt","fas fa-kazoo","far fa-kazoo","fal fa-kazoo","fas fa-list-music","far fa-list-music","fal fa-list-music","fas fa-mandolin","far fa-mandolin","fal fa-mandolin","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-alt","far fa-microphone-alt","fal fa-microphone-alt","fas fa-microphone-alt-slash","far fa-microphone-alt-slash","fal fa-microphone-alt-slash","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-microphone-stand","far fa-microphone-stand","fal fa-microphone-stand","fas fa-mp3-player","far fa-mp3-player","fal fa-mp3-player","fas fa-music","far fa-music","fal fa-music","fas fa-music-alt","far fa-music-alt","fal fa-music-alt","fas fa-music-alt-slash","far fa-music-alt-slash","fal fa-music-alt-slash","fas fa-music-slash","far fa-music-slash","fal fa-music-slash","fab fa-napster","fas fa-piano","far fa-piano","fal fa-piano","fas fa-piano-keyboard","far fa-piano-keyboard","fal fa-piano-keyboard","fas fa-play","far fa-play","fal fa-play","fas fa-radio","far fa-radio","fal fa-radio","fas fa-radio-alt","far fa-radio-alt","fal fa-radio-alt","fas fa-record-vinyl","far fa-record-vinyl","fal fa-record-vinyl","fas fa-sax-hot","far fa-sax-hot","fal fa-sax-hot","fas fa-saxophone","far fa-saxophone","fal fa-saxophone","fas fa-sliders-h","far fa-sliders-h","fal fa-sliders-h","fas fa-sliders-h-square","far fa-sliders-h-square","fal fa-sliders-h-square","fas fa-sliders-v","far fa-sliders-v","fal fa-sliders-v","fas fa-sliders-v-square","far fa-sliders-v-square","fal fa-sliders-v-square","fab fa-soundcloud","fas fa-speaker","far fa-speaker","fal fa-speaker","fas fa-speakers","far fa-speakers","fal fa-speakers","fab fa-spotify","fas fa-triangle-music","far fa-triangle-music","fal fa-triangle-music","fas fa-trumpet","far fa-trumpet","fal fa-trumpet","fas fa-turntable","far fa-turntable","fal fa-turntable","fas fa-tv-music","far fa-tv-music","fal fa-tv-music","fas fa-user-music","far fa-user-music","fal fa-user-music","fas fa-violin","far fa-violin","fal fa-violin","fas fa-volume","far fa-volume","fal fa-volume","fas fa-volume-down","far fa-volume-down","fal fa-volume-down","fas fa-volume-mute","far fa-volume-mute","fal fa-volume-mute","fas fa-volume-off","far fa-volume-off","fal fa-volume-off","fas fa-volume-slash","far fa-volume-slash","fal fa-volume-slash","fas fa-volume-up","far fa-volume-up","fal fa-volume-up","fas fa-waveform","far fa-waveform","fal fa-waveform","fas fa-waveform-path","far fa-waveform-path","fal fa-waveform-path","fas fa-whistle","far fa-whistle","fal fa-whistle"]},{"id":"objects","title":"Objects","icons":["fas fa-alarm-clock","far fa-alarm-clock","fal fa-alarm-clock","fas fa-ambulance","far fa-ambulance","fal fa-ambulance","fas fa-anchor","far fa-anchor","fal fa-anchor","fas fa-archive","far fa-archive","fal fa-archive","fas fa-award","far fa-award","fal fa-award","fas fa-axe-battle","far fa-axe-battle","fal fa-axe-battle","fas fa-baby-carriage","far fa-baby-carriage","fal fa-baby-carriage","fas fa-balance-scale","far fa-balance-scale","fal fa-balance-scale","fas fa-balance-scale-left","far fa-balance-scale-left","fal fa-balance-scale-left","fas fa-balance-scale-right","far fa-balance-scale-right","fal fa-balance-scale-right","fas fa-ball-pile","far fa-ball-pile","fal fa-ball-pile","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bed","far fa-bed","fal fa-bed","fas fa-beer","far fa-beer","fal fa-beer","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bells","far fa-bells","fal fa-bells","fas fa-bicycle","far fa-bicycle","fal fa-bicycle","fas fa-binoculars","far fa-binoculars","fal fa-binoculars","fas fa-birthday-cake","far fa-birthday-cake","fal fa-birthday-cake","fas fa-blender","far fa-blender","fal fa-blender","fas fa-bomb","far fa-bomb","fal fa-bomb","fas fa-book","far fa-book","fal fa-book","fas fa-book-dead","far fa-book-dead","fal fa-book-dead","fas fa-book-spells","far fa-book-spells","fal fa-book-spells","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fas fa-boot","far fa-boot","fal fa-boot","fas fa-bow-arrow","far fa-bow-arrow","fal fa-bow-arrow","fas fa-briefcase","far fa-briefcase","fal fa-briefcase","fas fa-broadcast-tower","far fa-broadcast-tower","fal fa-broadcast-tower","fas fa-bug","far fa-bug","fal fa-bug","fas fa-building","far fa-building","fal fa-building","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-bullseye","far fa-bullseye","fal fa-bullseye","fas fa-bus","far fa-bus","fal fa-bus","fas fa-calculator","far fa-calculator","fal fa-calculator","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-calendar-alt","far fa-calendar-alt","fal fa-calendar-alt","fas fa-camera","far fa-camera","fal fa-camera","fas fa-camera-alt","far fa-camera-alt","fal fa-camera-alt","fas fa-camera-retro","far fa-camera-retro","fal fa-camera-retro","fas fa-candy-cane","far fa-candy-cane","fal fa-candy-cane","fas fa-car","far fa-car","fal fa-car","fas fa-carrot","far fa-carrot","fal fa-carrot","fas fa-chimney","far fa-chimney","fal fa-chimney","fas fa-church","far fa-church","fal fa-church","fas fa-clipboard","far fa-clipboard","fal fa-clipboard","fas fa-cloud","far fa-cloud","fal fa-cloud","fas fa-coffee","far fa-coffee","fal fa-coffee","fas fa-cog","far fa-cog","fal fa-cog","fas fa-cogs","far fa-cogs","fal fa-cogs","fas fa-compass","far fa-compass","fal fa-compass","fas fa-cookie","far fa-cookie","fal fa-cookie","fas fa-cookie-bite","far fa-cookie-bite","fal fa-cookie-bite","fas fa-copy","far fa-copy","fal fa-copy","fas fa-cube","far fa-cube","fal fa-cube","fas fa-cubes","far fa-cubes","fal fa-cubes","fas fa-cut","far fa-cut","fal fa-cut","fas fa-dagger","far fa-dagger","fal fa-dagger","fas fa-dice","far fa-dice","fal fa-dice","fas fa-dice-d10","far fa-dice-d10","fal fa-dice-d10","fas fa-dice-d12","far fa-dice-d12","fal fa-dice-d12","fas fa-dice-d20","far fa-dice-d20","fal fa-dice-d20","fas fa-dice-d4","far fa-dice-d4","fal fa-dice-d4","fas fa-dice-d6","far fa-dice-d6","fal fa-dice-d6","fas fa-dice-d8","far fa-dice-d8","fal fa-dice-d8","fas fa-dice-five","far fa-dice-five","fal fa-dice-five","fas fa-dice-four","far fa-dice-four","fal fa-dice-four","fas fa-dice-one","far fa-dice-one","fal fa-dice-one","fas fa-dice-six","far fa-dice-six","fal fa-dice-six","fas fa-dice-three","far fa-dice-three","fal fa-dice-three","fas fa-dice-two","far fa-dice-two","fal fa-dice-two","fas fa-digital-tachograph","far fa-digital-tachograph","fal fa-digital-tachograph","fas fa-door-closed","far fa-door-closed","fal fa-door-closed","fas fa-door-open","far fa-door-open","fal fa-door-open","fas fa-dreidel","far fa-dreidel","fal fa-dreidel","fas fa-drum","far fa-drum","fal fa-drum","fas fa-drum-steelpan","far fa-drum-steelpan","fal fa-drum-steelpan","fas fa-ear-muffs","far fa-ear-muffs","fal fa-ear-muffs","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-open","far fa-envelope-open","fal fa-envelope-open","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-fax","far fa-fax","fal fa-fax","fas fa-feather","far fa-feather","fal fa-feather","fas fa-feather-alt","far fa-feather-alt","fal fa-feather-alt","fas fa-fighter-jet","far fa-fighter-jet","fal fa-fighter-jet","fas fa-file","far fa-file","fal fa-file","fas fa-file-alt","far fa-file-alt","fal fa-file-alt","fas fa-file-prescription","far fa-file-prescription","fal fa-file-prescription","fas fa-film","far fa-film","fal fa-film","fas fa-film-alt","far fa-film-alt","fal fa-film-alt","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-alt","far fa-fire-alt","fal fa-fire-alt","fas fa-fire-extinguisher","far fa-fire-extinguisher","fal fa-fire-extinguisher","fas fa-fireplace","far fa-fireplace","fal fa-fireplace","fas fa-flag","far fa-flag","fal fa-flag","fas fa-flag-checkered","far fa-flag-checkered","fal fa-flag-checkered","fas fa-flask","far fa-flask","fal fa-flask","fas fa-flask-potion","far fa-flask-potion","fal fa-flask-potion","fas fa-futbol","far fa-futbol","fal fa-futbol","fas fa-gamepad","far fa-gamepad","fal fa-gamepad","fas fa-gavel","far fa-gavel","fal fa-gavel","fas fa-gem","far fa-gem","fal fa-gem","fas fa-gift","far fa-gift","fal fa-gift","fas fa-gifts","far fa-gifts","fal fa-gifts","fas fa-gingerbread-man","far fa-gingerbread-man","fal fa-gingerbread-man","fas fa-glass-champagne","far fa-glass-champagne","fal fa-glass-champagne","fas fa-glass-cheers","far fa-glass-cheers","fal fa-glass-cheers","fas fa-glass-martini","far fa-glass-martini","fal fa-glass-martini","fas fa-glass-whiskey","far fa-glass-whiskey","fal fa-glass-whiskey","fas fa-glass-whiskey-rocks","far fa-glass-whiskey-rocks","fal fa-glass-whiskey-rocks","fas fa-glasses","far fa-glasses","fal fa-glasses","fas fa-globe","far fa-globe","fal fa-globe","fas fa-globe-snow","far fa-globe-snow","fal fa-globe-snow","fas fa-graduation-cap","far fa-graduation-cap","fal fa-graduation-cap","fas fa-guitar","far fa-guitar","fal fa-guitar","fas fa-hammer-war","far fa-hammer-war","fal fa-hammer-war","fas fa-hat-santa","far fa-hat-santa","fal fa-hat-santa","fas fa-hat-winter","far fa-hat-winter","fal fa-hat-winter","fas fa-hat-wizard","far fa-hat-wizard","fal fa-hat-wizard","fas fa-hdd","far fa-hdd","fal fa-hdd","fas fa-headphones","far fa-headphones","fal fa-headphones","fas fa-headphones-alt","far fa-headphones-alt","fal fa-headphones-alt","fas fa-headset","far fa-headset","fal fa-headset","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-broken","far fa-heart-broken","fal fa-heart-broken","fas fa-helicopter","far fa-helicopter","fal fa-helicopter","fas fa-helmet-battle","far fa-helmet-battle","fal fa-helmet-battle","fas fa-highlighter","far fa-highlighter","fal fa-highlighter","fas fa-holly-berry","far fa-holly-berry","fal fa-holly-berry","fas fa-home","far fa-home","fal fa-home","fas fa-hood-cloak","far fa-hood-cloak","fal fa-hood-cloak","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-hourglass","far fa-hourglass","fal fa-hourglass","fas fa-ice-skate","far fa-ice-skate","fal fa-ice-skate","fas fa-igloo","far fa-igloo","fal fa-igloo","fas fa-image","far fa-image","fal fa-image","fas fa-images","far fa-images","fal fa-images","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-alt","far fa-industry-alt","fal fa-industry-alt","fas fa-jack-o-lantern","far fa-jack-o-lantern","fal fa-jack-o-lantern","fas fa-key","far fa-key","fal fa-key","fas fa-keyboard","far fa-keyboard","fal fa-keyboard","fas fa-laptop","far fa-laptop","fal fa-laptop","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-lemon","far fa-lemon","fal fa-lemon","fas fa-life-ring","far fa-life-ring","fal fa-life-ring","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-lights-holiday","far fa-lights-holiday","fal fa-lights-holiday","fas fa-lock","far fa-lock","fal fa-lock","fas fa-lock-alt","far fa-lock-alt","fal fa-lock-alt","fas fa-lock-open","far fa-lock-open","fal fa-lock-open","fas fa-lock-open-alt","far fa-lock-open-alt","fal fa-lock-open-alt","fas fa-mace","far fa-mace","fal fa-mace","fas fa-magic","far fa-magic","fal fa-magic","fas fa-magnet","far fa-magnet","fal fa-magnet","fas fa-mandolin","far fa-mandolin","fal fa-mandolin","fas fa-map","far fa-map","fal fa-map","fas fa-map-marker","far fa-map-marker","fal fa-map-marker","fas fa-map-marker-alt","far fa-map-marker-alt","fal fa-map-marker-alt","fas fa-map-pin","far fa-map-pin","fal fa-map-pin","fas fa-map-signs","far fa-map-signs","fal fa-map-signs","fas fa-marker","far fa-marker","fal fa-marker","fas fa-medal","far fa-medal","fal fa-medal","fas fa-medkit","far fa-medkit","fal fa-medkit","fas fa-memory","far fa-memory","fal fa-memory","fas fa-microchip","far fa-microchip","fal fa-microchip","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-alt","far fa-microphone-alt","fal fa-microphone-alt","fas fa-mitten","far fa-mitten","fal fa-mitten","fas fa-mobile","far fa-mobile","fal fa-mobile","fas fa-mobile-alt","far fa-mobile-alt","fal fa-mobile-alt","fas fa-mobile-android","far fa-mobile-android","fal fa-mobile-android","fas fa-mobile-android-alt","far fa-mobile-android-alt","fal fa-mobile-android-alt","fas fa-money-bill","far fa-money-bill","fal fa-money-bill","fas fa-money-bill-alt","far fa-money-bill-alt","fal fa-money-bill-alt","fas fa-money-check","far fa-money-check","fal fa-money-check","fas fa-money-check-alt","far fa-money-check-alt","fal fa-money-check-alt","fas fa-moon","far fa-moon","fal fa-moon","fas fa-motorcycle","far fa-motorcycle","fal fa-motorcycle","fas fa-mug-hot","far fa-mug-hot","fal fa-mug-hot","fas fa-mug-marshmallows","far fa-mug-marshmallows","fal fa-mug-marshmallows","fas fa-newspaper","far fa-newspaper","fal fa-newspaper","fas fa-ornament","far fa-ornament","fal fa-ornament","fas fa-paint-brush","far fa-paint-brush","fal fa-paint-brush","fas fa-paper-plane","far fa-paper-plane","fal fa-paper-plane","fas fa-paperclip","far fa-paperclip","fal fa-paperclip","fas fa-paste","far fa-paste","fal fa-paste","fas fa-paw","far fa-paw","fal fa-paw","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-alt","far fa-pen-alt","fal fa-pen-alt","fas fa-pen-fancy","far fa-pen-fancy","fal fa-pen-fancy","fas fa-pen-nib","far fa-pen-nib","fal fa-pen-nib","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-alt","far fa-pencil-alt","fal fa-pencil-alt","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-alt","far fa-phone-alt","fal fa-phone-alt","fas fa-plane","far fa-plane","fal fa-plane","fas fa-plane-alt","far fa-plane-alt","fal fa-plane-alt","fas fa-plug","far fa-plug","fal fa-plug","fas fa-print","far fa-print","fal fa-print","fas fa-puzzle-piece","far fa-puzzle-piece","fal fa-puzzle-piece","fas fa-ring","far fa-ring","fal fa-ring","fas fa-road","far fa-road","fal fa-road","fas fa-rocket","far fa-rocket","fal fa-rocket","fas fa-ruler-combined","far fa-ruler-combined","fal fa-ruler-combined","fas fa-ruler-horizontal","far fa-ruler-horizontal","fal fa-ruler-horizontal","fas fa-ruler-vertical","far fa-ruler-vertical","fal fa-ruler-vertical","fas fa-rv","far fa-rv","fal fa-rv","fas fa-satellite","far fa-satellite","fal fa-satellite","fas fa-satellite-dish","far fa-satellite-dish","fal fa-satellite-dish","fas fa-save","far fa-save","fal fa-save","fas fa-scarf","far fa-scarf","fal fa-scarf","fas fa-school","far fa-school","fal fa-school","fas fa-screwdriver","far fa-screwdriver","fal fa-screwdriver","fas fa-scroll","far fa-scroll","fal fa-scroll","fas fa-scroll-old","far fa-scroll-old","fal fa-scroll-old","fas fa-scythe","far fa-scythe","fal fa-scythe","fas fa-sd-card","far fa-sd-card","fal fa-sd-card","fas fa-search","far fa-search","fal fa-search","fas fa-shield","far fa-shield","fal fa-shield","fas fa-shield-alt","far fa-shield-alt","fal fa-shield-alt","fas fa-shield-cross","far fa-shield-cross","fal fa-shield-cross","fas fa-shopping-bag","far fa-shopping-bag","fal fa-shopping-bag","fas fa-shopping-basket","far fa-shopping-basket","fal fa-shopping-basket","fas fa-shopping-cart","far fa-shopping-cart","fal fa-shopping-cart","fas fa-shovel-snow","far fa-shovel-snow","fal fa-shovel-snow","fas fa-shower","far fa-shower","fal fa-shower","fas fa-sim-card","far fa-sim-card","fal fa-sim-card","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-sleigh","far fa-sleigh","fal fa-sleigh","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-snowmobile","far fa-snowmobile","fal fa-snowmobile","fas fa-snowplow","far fa-snowplow","fal fa-snowplow","fas fa-space-shuttle","far fa-space-shuttle","fal fa-space-shuttle","fas fa-staff","far fa-staff","fal fa-staff","fas fa-star","far fa-star","fal fa-star","fas fa-sticky-note","far fa-sticky-note","fal fa-sticky-note","fas fa-stocking","far fa-stocking","fal fa-stocking","fas fa-stopwatch","far fa-stopwatch","fal fa-stopwatch","fas fa-stroopwafel","far fa-stroopwafel","fal fa-stroopwafel","fas fa-subway","far fa-subway","fal fa-subway","fas fa-suitcase","far fa-suitcase","fal fa-suitcase","fas fa-sun","far fa-sun","fal fa-sun","fas fa-sword","far fa-sword","fal fa-sword","fas fa-swords","far fa-swords","fal fa-swords","fas fa-tablet","far fa-tablet","fal fa-tablet","fas fa-tablet-alt","far fa-tablet-alt","fal fa-tablet-alt","fas fa-tablet-android","far fa-tablet-android","fal fa-tablet-android","fas fa-tablet-android-alt","far fa-tablet-android-alt","fal fa-tablet-android-alt","fas fa-tachometer","far fa-tachometer","fal fa-tachometer","fas fa-tachometer-alt","far fa-tachometer-alt","fal fa-tachometer-alt","fas fa-tag","far fa-tag","fal fa-tag","fas fa-tags","far fa-tags","fal fa-tags","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack","fas fa-ticket","far fa-ticket","fal fa-ticket","fas fa-ticket-alt","far fa-ticket-alt","fal fa-ticket-alt","fas fa-toilet","far fa-toilet","fal fa-toilet","fas fa-toolbox","far fa-toolbox","fal fa-toolbox","fas fa-tools","far fa-tools","fal fa-tools","fas fa-train","far fa-train","fal fa-train","fas fa-tram","far fa-tram","fal fa-tram","fas fa-trash","far fa-trash","fal fa-trash","fas fa-trash-alt","far fa-trash-alt","fal fa-trash-alt","fas fa-treasure-chest","far fa-treasure-chest","fal fa-treasure-chest","fas fa-tree","far fa-tree","fal fa-tree","fas fa-tree-alt","far fa-tree-alt","fal fa-tree-alt","fas fa-tree-christmas","far fa-tree-christmas","fal fa-tree-christmas","fas fa-tree-decorated","far fa-tree-decorated","fal fa-tree-decorated","fas fa-tree-large","far fa-tree-large","fal fa-tree-large","fas fa-trophy","far fa-trophy","fal fa-trophy","fas fa-trophy-alt","far fa-trophy-alt","fal fa-trophy-alt","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-plow","far fa-truck-plow","fal fa-truck-plow","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-retro","far fa-tv-retro","fal fa-tv-retro","fas fa-umbrella","far fa-umbrella","fal fa-umbrella","fas fa-university","far fa-university","fal fa-university","fas fa-unlock","far fa-unlock","fal fa-unlock","fas fa-unlock-alt","far fa-unlock-alt","fal fa-unlock-alt","fas fa-utensil-fork","far fa-utensil-fork","fal fa-utensil-fork","fas fa-utensil-knife","far fa-utensil-knife","fal fa-utensil-knife","fas fa-utensil-spoon","far fa-utensil-spoon","fal fa-utensil-spoon","fas fa-utensils","far fa-utensils","fal fa-utensils","fas fa-utensils-alt","far fa-utensils-alt","fal fa-utensils-alt","fas fa-wallet","far fa-wallet","fal fa-wallet","fas fa-wand","far fa-wand","fal fa-wand","fas fa-wand-magic","far fa-wand-magic","fal fa-wand-magic","fas fa-watch","far fa-watch","fal fa-watch","fas fa-weight","far fa-weight","fal fa-weight","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass","fas fa-wreath","far fa-wreath","fal fa-wreath","fas fa-wrench","far fa-wrench","fal fa-wrench"]},{"id":"payments-shopping","title":"Payments & Shopping","icons":["fab fa-alipay","fab fa-amazon-pay","fab fa-apple-pay","fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-bags-shopping","far fa-bags-shopping","fal fa-bags-shopping","fas fa-bell","far fa-bell","fal fa-bell","fab fa-bitcoin","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fab fa-btc","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-camera","far fa-camera","fal fa-camera","fas fa-camera-alt","far fa-camera-alt","fal fa-camera-alt","fas fa-camera-retro","far fa-camera-retro","fal fa-camera-retro","fas fa-cart-arrow-down","far fa-cart-arrow-down","fal fa-cart-arrow-down","fas fa-cart-plus","far fa-cart-plus","fal fa-cart-plus","fab fa-cc-amazon-pay","fab fa-cc-amex","fab fa-cc-apple-pay","fab fa-cc-diners-club","fab fa-cc-discover","fab fa-cc-jcb","fab fa-cc-mastercard","fab fa-cc-paypal","fab fa-cc-stripe","fab fa-cc-visa","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-credit-card","far fa-credit-card","fal fa-credit-card","fas fa-credit-card-blank","far fa-credit-card-blank","fal fa-credit-card-blank","fas fa-credit-card-front","far fa-credit-card-front","fal fa-credit-card-front","fab fa-ethereum","fas fa-gem","far fa-gem","fal fa-gem","fas fa-gift","far fa-gift","fal fa-gift","fab fa-google-pay","fab fa-google-wallet","fas fa-handshake","far fa-handshake","fal fa-handshake","fas fa-heart","far fa-heart","fal fa-heart","fas fa-key","far fa-key","fal fa-key","fas fa-money-check","far fa-money-check","fal fa-money-check","fas fa-money-check-alt","far fa-money-check-alt","fal fa-money-check-alt","fas fa-money-check-edit","far fa-money-check-edit","fal fa-money-check-edit","fas fa-money-check-edit-alt","far fa-money-check-edit-alt","fal fa-money-check-edit-alt","fab fa-paypal","fas fa-receipt","far fa-receipt","fal fa-receipt","fas fa-shopping-bag","far fa-shopping-bag","fal fa-shopping-bag","fas fa-shopping-basket","far fa-shopping-basket","fal fa-shopping-basket","fas fa-shopping-cart","far fa-shopping-cart","fal fa-shopping-cart","fas fa-star","far fa-star","fal fa-star","fas fa-star-exclamation","far fa-star-exclamation","fal fa-star-exclamation","fab fa-stripe","fab fa-stripe-s","fas fa-tag","far fa-tag","fal fa-tag","fas fa-tags","far fa-tags","fal fa-tags","fas fa-thumbs-down","far fa-thumbs-down","fal fa-thumbs-down","fas fa-thumbs-up","far fa-thumbs-up","fal fa-thumbs-up","fas fa-trophy","far fa-trophy","fal fa-trophy","fas fa-trophy-alt","far fa-trophy-alt","fal fa-trophy-alt"]},{"id":"pharmacy","title":"Pharmacy","icons":["fas fa-band-aid","far fa-band-aid","fal fa-band-aid","fas fa-book-medical","far fa-book-medical","fal fa-book-medical","fas fa-cannabis","far fa-cannabis","fal fa-cannabis","fas fa-capsules","far fa-capsules","fal fa-capsules","fas fa-cauldron","far fa-cauldron","fal fa-cauldron","fas fa-clinic-medical","far fa-clinic-medical","fal fa-clinic-medical","fas fa-clipboard-prescription","far fa-clipboard-prescription","fal fa-clipboard-prescription","fas fa-disease","far fa-disease","fal fa-disease","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-file-medical","far fa-file-medical","fal fa-file-medical","fas fa-file-prescription","far fa-file-prescription","fal fa-file-prescription","fas fa-files-medical","far fa-files-medical","fal fa-files-medical","fas fa-first-aid","far fa-first-aid","fal fa-first-aid","fas fa-flask","far fa-flask","fal fa-flask","fas fa-flask-potion","far fa-flask-potion","fal fa-flask-potion","fas fa-history","far fa-history","fal fa-history","fas fa-inhaler","far fa-inhaler","fal fa-inhaler","fas fa-joint","far fa-joint","fal fa-joint","fas fa-laptop-medical","far fa-laptop-medical","fal fa-laptop-medical","fas fa-mortar-pestle","far fa-mortar-pestle","fal fa-mortar-pestle","fas fa-notes-medical","far fa-notes-medical","fal fa-notes-medical","fas fa-pills","far fa-pills","fal fa-pills","fas fa-prescription","far fa-prescription","fal fa-prescription","fas fa-prescription-bottle","far fa-prescription-bottle","fal fa-prescription-bottle","fas fa-prescription-bottle-alt","far fa-prescription-bottle-alt","fal fa-prescription-bottle-alt","fas fa-receipt","far fa-receipt","fal fa-receipt","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-syringe","far fa-syringe","fal fa-syringe","fas fa-tablets","far fa-tablets","fal fa-tablets","fas fa-thermometer","far fa-thermometer","fal fa-thermometer","fas fa-vial","far fa-vial","fal fa-vial","fas fa-vials","far fa-vials","fal fa-vials"]},{"id":"political","title":"Political","icons":["fas fa-award","far fa-award","fal fa-award","fas fa-balance-scale","far fa-balance-scale","fal fa-balance-scale","fas fa-balance-scale-left","far fa-balance-scale-left","fal fa-balance-scale-left","fas fa-balance-scale-right","far fa-balance-scale-right","fal fa-balance-scale-right","fas fa-ballot","far fa-ballot","fal fa-ballot","fas fa-ballot-check","far fa-ballot-check","fal fa-ballot-check","fas fa-booth-curtain","far fa-booth-curtain","fal fa-booth-curtain","fas fa-box-ballot","far fa-box-ballot","fal fa-box-ballot","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-calendar-star","far fa-calendar-star","fal fa-calendar-star","fas fa-check-double","far fa-check-double","fal fa-check-double","fas fa-clipboard-list-check","far fa-clipboard-list-check","fal fa-clipboard-list-check","fas fa-democrat","far fa-democrat","fal fa-democrat","fas fa-donate","far fa-donate","fal fa-donate","fas fa-dove","far fa-dove","fal fa-dove","fas fa-fist-raised","far fa-fist-raised","fal fa-fist-raised","fas fa-flag-alt","far fa-flag-alt","fal fa-flag-alt","fas fa-flag-usa","far fa-flag-usa","fal fa-flag-usa","fas fa-handshake","far fa-handshake","fal fa-handshake","fas fa-landmark-alt","far fa-landmark-alt","fal fa-landmark-alt","fas fa-person-booth","far fa-person-booth","fal fa-person-booth","fas fa-person-sign","far fa-person-sign","fal fa-person-sign","fas fa-piggy-bank","far fa-piggy-bank","fal fa-piggy-bank","fas fa-podium","far fa-podium","fal fa-podium","fas fa-podium-star","far fa-podium-star","fal fa-podium-star","fas fa-poll-people","far fa-poll-people","fal fa-poll-people","fas fa-republican","far fa-republican","fal fa-republican","fas fa-tally","far fa-tally","fal fa-tally","fas fa-vote-nay","far fa-vote-nay","fal fa-vote-nay","fas fa-vote-yea","far fa-vote-yea","fal fa-vote-yea"]},{"id":"religion","title":"Religion","icons":["fas fa-ankh","far fa-ankh","fal fa-ankh","fas fa-atom","far fa-atom","fal fa-atom","fas fa-bahai","far fa-bahai","fal fa-bahai","fas fa-bible","far fa-bible","fal fa-bible","fas fa-church","far fa-church","fal fa-church","fas fa-cross","far fa-cross","fal fa-cross","fas fa-dharmachakra","far fa-dharmachakra","fal fa-dharmachakra","fas fa-dove","far fa-dove","fal fa-dove","fas fa-gopuram","far fa-gopuram","fal fa-gopuram","fas fa-hamsa","far fa-hamsa","fal fa-hamsa","fas fa-hanukiah","far fa-hanukiah","fal fa-hanukiah","fas fa-jedi","far fa-jedi","fal fa-jedi","fas fa-journal-whills","far fa-journal-whills","fal fa-journal-whills","fas fa-kaaba","far fa-kaaba","fal fa-kaaba","fas fa-khanda","far fa-khanda","fal fa-khanda","fas fa-menorah","far fa-menorah","fal fa-menorah","fas fa-mosque","far fa-mosque","fal fa-mosque","fas fa-om","far fa-om","fal fa-om","fas fa-pastafarianism","far fa-pastafarianism","fal fa-pastafarianism","fas fa-peace","far fa-peace","fal fa-peace","fas fa-place-of-worship","far fa-place-of-worship","fal fa-place-of-worship","fas fa-pray","far fa-pray","fal fa-pray","fas fa-praying-hands","far fa-praying-hands","fal fa-praying-hands","fas fa-quran","far fa-quran","fal fa-quran","fas fa-star-and-crescent","far fa-star-and-crescent","fal fa-star-and-crescent","fas fa-star-of-david","far fa-star-of-david","fal fa-star-of-david","fas fa-synagogue","far fa-synagogue","fal fa-synagogue","fas fa-tanakh","far fa-tanakh","fal fa-tanakh","fas fa-torah","far fa-torah","fal fa-torah","fas fa-torii-gate","far fa-torii-gate","fal fa-torii-gate","fas fa-vihara","far fa-vihara","fal fa-vihara","fas fa-yin-yang","far fa-yin-yang","fal fa-yin-yang"]},{"id":"science","title":"Science","icons":["fas fa-analytics","far fa-analytics","fal fa-analytics","fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-alt","far fa-atom-alt","fal fa-atom-alt","fas fa-biohazard","far fa-biohazard","fal fa-biohazard","fas fa-book-spells","far fa-book-spells","fal fa-book-spells","fas fa-brain","far fa-brain","fal fa-brain","fas fa-burn","far fa-burn","fal fa-burn","fas fa-capsules","far fa-capsules","fal fa-capsules","fas fa-cauldron","far fa-cauldron","fal fa-cauldron","fas fa-chart-network","far fa-chart-network","fal fa-chart-network","fas fa-chart-scatter","far fa-chart-scatter","fal fa-chart-scatter","fas fa-clipboard-check","far fa-clipboard-check","fal fa-clipboard-check","fas fa-disease","far fa-disease","fal fa-disease","fas fa-dna","far fa-dna","fal fa-dna","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-filter","far fa-filter","fal fa-filter","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-alt","far fa-fire-alt","fal fa-fire-alt","fas fa-flask","far fa-flask","fal fa-flask","fas fa-flask-poison","far fa-flask-poison","fal fa-flask-poison","fas fa-flask-potion","far fa-flask-potion","fal fa-flask-potion","fas fa-frog","far fa-frog","fal fa-frog","fas fa-head-side-brain","far fa-head-side-brain","fal fa-head-side-brain","fas fa-key-skeleton","far fa-key-skeleton","fal fa-key-skeleton","fas fa-kite","far fa-kite","fal fa-kite","fas fa-magnet","far fa-magnet","fal fa-magnet","fas fa-microscope","far fa-microscope","fal fa-microscope","fas fa-mortar-pestle","far fa-mortar-pestle","fal fa-mortar-pestle","fas fa-pills","far fa-pills","fal fa-pills","fas fa-prescription-bottle","far fa-prescription-bottle","fal fa-prescription-bottle","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-radiation-alt","far fa-radiation-alt","fal fa-radiation-alt","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-syringe","far fa-syringe","fal fa-syringe","fas fa-tablets","far fa-tablets","fal fa-tablets","fas fa-tally","far fa-tally","fal fa-tally","fas fa-temperature-high","far fa-temperature-high","fal fa-temperature-high","fas fa-temperature-low","far fa-temperature-low","fal fa-temperature-low","fas fa-vial","far fa-vial","fal fa-vial","fas fa-vials","far fa-vials","fal fa-vials"]},{"id":"science-fiction","title":"Science Fiction","icons":["fas fa-alien","far fa-alien","fal fa-alien","fas fa-alien-monster","far fa-alien-monster","fal fa-alien-monster","fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-alt","far fa-atom-alt","fal fa-atom-alt","fas fa-cat-space","far fa-cat-space","fal fa-cat-space","fas fa-comet","far fa-comet","fal fa-comet","fas fa-drone","far fa-drone","fal fa-drone","fas fa-drone-alt","far fa-drone-alt","fal fa-drone-alt","fas fa-eclipse","far fa-eclipse","fal fa-eclipse","fas fa-eclipse-alt","far fa-eclipse-alt","fal fa-eclipse-alt","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fab fa-galactic-republic","fab fa-galactic-senate","fas fa-galaxy","far fa-galaxy","fal fa-galaxy","fas fa-globe","far fa-globe","fal fa-globe","fas fa-hand-spock","far fa-hand-spock","fal fa-hand-spock","fas fa-jedi","far fa-jedi","fal fa-jedi","fab fa-jedi-order","fas fa-journal-whills","far fa-journal-whills","fal fa-journal-whills","fas fa-meteor","far fa-meteor","fal fa-meteor","fas fa-moon","far fa-moon","fal fa-moon","fas fa-moon-stars","far fa-moon-stars","fal fa-moon-stars","fab fa-old-republic","fas fa-planet-moon","far fa-planet-moon","fal fa-planet-moon","fas fa-planet-ringed","far fa-planet-ringed","fal fa-planet-ringed","fas fa-police-box","far fa-police-box","fal fa-police-box","fas fa-portal-enter","far fa-portal-enter","fal fa-portal-enter","fas fa-portal-exit","far fa-portal-exit","fal fa-portal-exit","fas fa-radar","far fa-radar","fal fa-radar","fas fa-raygun","far fa-raygun","fal fa-raygun","fas fa-robot","far fa-robot","fal fa-robot","fas fa-rocket","far fa-rocket","fal fa-rocket","fas fa-rocket-launch","far fa-rocket-launch","fal fa-rocket-launch","fas fa-satellite","far fa-satellite","fal fa-satellite","fas fa-satellite-dish","far fa-satellite-dish","fal fa-satellite-dish","fas fa-solar-system","far fa-solar-system","fal fa-solar-system","fas fa-space-shuttle","far fa-space-shuttle","fal fa-space-shuttle","fas fa-space-station-moon","far fa-space-station-moon","fal fa-space-station-moon","fas fa-space-station-moon-alt","far fa-space-station-moon-alt","fal fa-space-station-moon-alt","fas fa-star-shooting","far fa-star-shooting","fal fa-star-shooting","fas fa-starfighter","far fa-starfighter","fal fa-starfighter","fas fa-starfighter-alt","far fa-starfighter-alt","fal fa-starfighter-alt","fas fa-stars","far fa-stars","fal fa-stars","fas fa-starship","far fa-starship","fal fa-starship","fas fa-starship-freighter","far fa-starship-freighter","fal fa-starship-freighter","fas fa-sword-laser","far fa-sword-laser","fal fa-sword-laser","fas fa-sword-laser-alt","far fa-sword-laser-alt","fal fa-sword-laser-alt","fas fa-swords-laser","far fa-swords-laser","fal fa-swords-laser","fas fa-telescope","far fa-telescope","fal fa-telescope","fas fa-transporter","far fa-transporter","fal fa-transporter","fas fa-transporter-1","far fa-transporter-1","fal fa-transporter-1","fas fa-transporter-2","far fa-transporter-2","fal fa-transporter-2","fas fa-transporter-3","far fa-transporter-3","fal fa-transporter-3","fas fa-transporter-empty","far fa-transporter-empty","fal fa-transporter-empty","fas fa-ufo","far fa-ufo","fal fa-ufo","fas fa-ufo-beam","far fa-ufo-beam","fal fa-ufo-beam","fas fa-user-alien","far fa-user-alien","fal fa-user-alien","fas fa-user-astronaut","far fa-user-astronaut","fal fa-user-astronaut","fas fa-user-robot","far fa-user-robot","fal fa-user-robot","fas fa-user-visor","far fa-user-visor","fal fa-user-visor","fas fa-watch-calculator","far fa-watch-calculator","fal fa-watch-calculator"]},{"id":"security","title":"Security","icons":["fal fa-badge-sheriff","far fa-badge-sheriff","fas fa-badge-sheriff","fas fa-ban","far fa-ban","fal fa-ban","fas fa-bug","far fa-bug","fal fa-bug","fas fa-cctv","far fa-cctv","fal fa-cctv","fas fa-debug","far fa-debug","fal fa-debug","fas fa-do-not-enter","far fa-do-not-enter","fal fa-do-not-enter","fas fa-door-closed","far fa-door-closed","fal fa-door-closed","fas fa-door-open","far fa-door-open","fal fa-door-open","fas fa-dungeon","far fa-dungeon","fal fa-dungeon","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-file-certificate","far fa-file-certificate","fal fa-file-certificate","fas fa-file-contract","far fa-file-contract","fal fa-file-contract","fas fa-file-signature","far fa-file-signature","fal fa-file-signature","fas fa-fingerprint","far fa-fingerprint","fal fa-fingerprint","fas fa-id-badge","far fa-id-badge","fal fa-id-badge","fas fa-id-card","far fa-id-card","fal fa-id-card","fas fa-id-card-alt","far fa-id-card-alt","fal fa-id-card-alt","fas fa-key","far fa-key","fal fa-key","fas fa-key-skeleton","far fa-key-skeleton","fal fa-key-skeleton","fas fa-lock","far fa-lock","fal fa-lock","fas fa-lock-alt","far fa-lock-alt","fal fa-lock-alt","fas fa-lock-open","far fa-lock-open","fal fa-lock-open","fas fa-lock-open-alt","far fa-lock-open-alt","fal fa-lock-open-alt","fas fa-mask","far fa-mask","fal fa-mask","fas fa-passport","far fa-passport","fal fa-passport","fas fa-shield","far fa-shield","fal fa-shield","fas fa-shield-alt","far fa-shield-alt","fal fa-shield-alt","fas fa-shield-check","far fa-shield-check","fal fa-shield-check","fas fa-siren","far fa-siren","fal fa-siren","fas fa-siren-on","far fa-siren-on","fal fa-siren-on","fas fa-unlock","far fa-unlock","fal fa-unlock","fas fa-unlock-alt","far fa-unlock-alt","fal fa-unlock-alt","fas fa-usb-drive","far fa-usb-drive","fal fa-usb-drive","fas fa-user-lock","far fa-user-lock","fal fa-user-lock","fas fa-user-secret","far fa-user-secret","fal fa-user-secret","fas fa-user-shield","far fa-user-shield","fal fa-user-shield","fal fa-user-unlock","far fa-user-unlock","fas fa-user-unlock","fas fa-whistle","far fa-whistle","fal fa-whistle"]},{"id":"shapes","title":"Shapes","icons":["fas fa-badge","far fa-badge","fal fa-badge","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-circle","far fa-circle","fal fa-circle","fas fa-cloud","far fa-cloud","fal fa-cloud","fas fa-club","far fa-club","fal fa-club","fas fa-comment","far fa-comment","fal fa-comment","fas fa-diamond","far fa-diamond","fal fa-diamond","fas fa-file","far fa-file","fal fa-file","fas fa-folder","far fa-folder","fal fa-folder","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-broken","far fa-heart-broken","fal fa-heart-broken","fas fa-hexagon","far fa-hexagon","fal fa-hexagon","fas fa-map-marker","far fa-map-marker","fal fa-map-marker","fas fa-octagon","far fa-octagon","fal fa-octagon","fas fa-play","far fa-play","fal fa-play","fas fa-rectangle-landscape","far fa-rectangle-landscape","fal fa-rectangle-landscape","fas fa-rectangle-portrait","far fa-rectangle-portrait","fal fa-rectangle-portrait","fas fa-rectangle-wide","far fa-rectangle-wide","fal fa-rectangle-wide","fas fa-shapes","far fa-shapes","fal fa-shapes","fas fa-shield","far fa-shield","fal fa-shield","fas fa-spade","far fa-spade","fal fa-spade","fas fa-square","far fa-square","fal fa-square","fas fa-star","far fa-star","fal fa-star","fas fa-ticket","far fa-ticket","fal fa-ticket","fas fa-triangle","far fa-triangle","fal fa-triangle"]},{"id":"shopping","title":"Shopping","icons":["fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-badge-dollar","far fa-badge-dollar","fal fa-badge-dollar","fas fa-badge-percent","far fa-badge-percent","fal fa-badge-percent","fas fa-bags-shopping","far fa-bags-shopping","fal fa-bags-shopping","fas fa-barcode","far fa-barcode","fal fa-barcode","fas fa-barcode-alt","far fa-barcode-alt","fal fa-barcode-alt","fas fa-barcode-read","far fa-barcode-read","fal fa-barcode-read","fas fa-barcode-scan","far fa-barcode-scan","fal fa-barcode-scan","fas fa-booth-curtain","far fa-booth-curtain","fal fa-booth-curtain","fas fa-box-full","far fa-box-full","fal fa-box-full","fas fa-cart-arrow-down","far fa-cart-arrow-down","fal fa-cart-arrow-down","fas fa-cart-plus","far fa-cart-plus","fal fa-cart-plus","fas fa-cash-register","far fa-cash-register","fal fa-cash-register","fas fa-gift","far fa-gift","fal fa-gift","fas fa-gift-card","far fa-gift-card","fal fa-gift-card","fas fa-gifts","far fa-gifts","fal fa-gifts","fas fa-hand-holding-box","far fa-hand-holding-box","fal fa-hand-holding-box","fas fa-person-booth","far fa-person-booth","fal fa-person-booth","fas fa-receipt","far fa-receipt","fal fa-receipt","fas fa-shipping-fast","far fa-shipping-fast","fal fa-shipping-fast","fas fa-shipping-timed","far fa-shipping-timed","fal fa-shipping-timed","fas fa-shopping-bag","far fa-shopping-bag","fal fa-shopping-bag","fas fa-shopping-basket","far fa-shopping-basket","fal fa-shopping-basket","fas fa-shopping-cart","far fa-shopping-cart","fal fa-shopping-cart","fas fa-store","far fa-store","fal fa-store","fas fa-store-alt","far fa-store-alt","fal fa-store-alt","fal fa-store-alt-slash","far fa-store-alt-slash","fas fa-store-alt-slash","fal fa-store-slash","far fa-store-slash","fas fa-store-slash","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-container","far fa-truck-container","fal fa-truck-container","fas fa-tshirt","far fa-tshirt","fal fa-tshirt"]},{"id":"social","title":"Social","icons":["fas fa-bags-shopping","far fa-bags-shopping","fal fa-bags-shopping","fas fa-bell","far fa-bell","fal fa-bell","fas fa-birthday-cake","far fa-birthday-cake","fal fa-birthday-cake","fas fa-camera","far fa-camera","fal fa-camera","fas fa-comment","far fa-comment","fal fa-comment","fas fa-comment-alt","far fa-comment-alt","fal fa-comment-alt","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-hashtag","far fa-hashtag","fal fa-hashtag","fas fa-heart","far fa-heart","fal fa-heart","fas fa-icons","far fa-icons","fal fa-icons","fas fa-icons-alt","far fa-icons-alt","fal fa-icons-alt","fas fa-image","far fa-image","fal fa-image","fas fa-images","far fa-images","fal fa-images","fas fa-map-marker","far fa-map-marker","fal fa-map-marker","fas fa-map-marker-alt","far fa-map-marker-alt","fal fa-map-marker-alt","fas fa-photo-video","far fa-photo-video","fal fa-photo-video","fas fa-poll","far fa-poll","fal fa-poll","fas fa-poll-h","far fa-poll-h","fal fa-poll-h","fas fa-retweet","far fa-retweet","fal fa-retweet","fas fa-retweet-alt","far fa-retweet-alt","fal fa-retweet-alt","fas fa-share","far fa-share","fal fa-share","fas fa-share-alt","far fa-share-alt","fal fa-share-alt","fas fa-share-square","far fa-share-square","fal fa-share-square","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-star","far fa-star","fal fa-star","fas fa-thumbs-down","far fa-thumbs-down","fal fa-thumbs-down","fas fa-thumbs-up","far fa-thumbs-up","fal fa-thumbs-up","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack","fas fa-user","far fa-user","fal fa-user","fas fa-user-circle","far fa-user-circle","fal fa-user-circle","fas fa-user-crown","far fa-user-crown","fal fa-user-crown","fas fa-user-friends","far fa-user-friends","fal fa-user-friends","fas fa-user-plus","far fa-user-plus","fal fa-user-plus","fas fa-users","far fa-users","fal fa-users","fas fa-users-crown","far fa-users-crown","fal fa-users-crown","fas fa-video","far fa-video","fal fa-video"]},{"id":"spinners","title":"Spinners","icons":["fas fa-asterisk","far fa-asterisk","fal fa-asterisk","fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-alt","far fa-atom-alt","fal fa-atom-alt","fas fa-badge","far fa-badge","fal fa-badge","fas fa-bahai","far fa-bahai","fal fa-bahai","fas fa-bullseye-arrow","far fa-bullseye-arrow","fal fa-bullseye-arrow","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-circle-notch","far fa-circle-notch","fal fa-circle-notch","fas fa-cog","far fa-cog","fal fa-cog","fas fa-compact-disc","far fa-compact-disc","fal fa-compact-disc","fas fa-compass","far fa-compass","fal fa-compass","fas fa-crosshairs","far fa-crosshairs","fal fa-crosshairs","fas fa-dharmachakra","far fa-dharmachakra","fal fa-dharmachakra","fas fa-eclipse-alt","far fa-eclipse-alt","fal fa-eclipse-alt","fas fa-fan","far fa-fan","fal fa-fan","fas fa-hurricane","far fa-hurricane","fal fa-hurricane","fas fa-life-ring","far fa-life-ring","fal fa-life-ring","fas fa-palette","far fa-palette","fal fa-palette","fas fa-ring","far fa-ring","fal fa-ring","fas fa-slash","far fa-slash","fal fa-slash","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-spider-web","far fa-spider-web","fal fa-spider-web","fas fa-spinner","far fa-spinner","fal fa-spinner","fas fa-spinner-third","far fa-spinner-third","fal fa-spinner-third","fas fa-star-christmas","far fa-star-christmas","fal fa-star-christmas","fas fa-steering-wheel","far fa-steering-wheel","fal fa-steering-wheel","fas fa-stroopwafel","far fa-stroopwafel","fal fa-stroopwafel","fas fa-sun","far fa-sun","fal fa-sun","fas fa-sync","far fa-sync","fal fa-sync","fas fa-sync-alt","far fa-sync-alt","fal fa-sync-alt","fas fa-tire","far fa-tire","fal fa-tire","fas fa-tire-rugged","far fa-tire-rugged","fal fa-tire-rugged","fas fa-wreath","far fa-wreath","fal fa-wreath","fas fa-yin-yang","far fa-yin-yang","fal fa-yin-yang"]},{"id":"sports","title":"Sports","icons":["fas fa-baseball","far fa-baseball","fal fa-baseball","fas fa-baseball-ball","far fa-baseball-ball","fal fa-baseball-ball","fas fa-basketball-ball","far fa-basketball-ball","fal fa-basketball-ball","fas fa-basketball-hoop","far fa-basketball-hoop","fal fa-basketball-hoop","fas fa-biking","far fa-biking","fal fa-biking","fas fa-biking-mountain","far fa-biking-mountain","fal fa-biking-mountain","fas fa-bowling-ball","far fa-bowling-ball","fal fa-bowling-ball","fas fa-bowling-pins","far fa-bowling-pins","fal fa-bowling-pins","fas fa-boxing-glove","far fa-boxing-glove","fal fa-boxing-glove","fas fa-cricket","far fa-cricket","fal fa-cricket","fas fa-curling","far fa-curling","fal fa-curling","fas fa-dumbbell","far fa-dumbbell","fal fa-dumbbell","fas fa-field-hockey","far fa-field-hockey","fal fa-field-hockey","fas fa-football-ball","far fa-football-ball","fal fa-football-ball","fas fa-football-helmet","far fa-football-helmet","fal fa-football-helmet","fas fa-futbol","far fa-futbol","fal fa-futbol","fas fa-golf-ball","far fa-golf-ball","fal fa-golf-ball","fas fa-golf-club","far fa-golf-club","fal fa-golf-club","fas fa-hockey-mask","far fa-hockey-mask","fal fa-hockey-mask","fas fa-hockey-puck","far fa-hockey-puck","fal fa-hockey-puck","fas fa-hockey-sticks","far fa-hockey-sticks","fal fa-hockey-sticks","fas fa-ice-skate","far fa-ice-skate","fal fa-ice-skate","fas fa-luchador","far fa-luchador","fal fa-luchador","fas fa-pennant","far fa-pennant","fal fa-pennant","fas fa-quidditch","far fa-quidditch","fal fa-quidditch","fas fa-racquet","far fa-racquet","fal fa-racquet","fas fa-running","far fa-running","fal fa-running","fas fa-shuttlecock","far fa-shuttlecock","fal fa-shuttlecock","fas fa-skating","far fa-skating","fal fa-skating","fas fa-ski-jump","far fa-ski-jump","fal fa-ski-jump","fas fa-skiing","far fa-skiing","fal fa-skiing","fas fa-skiing-nordic","far fa-skiing-nordic","fal fa-skiing-nordic","fas fa-sledding","far fa-sledding","fal fa-sledding","fas fa-snowboarding","far fa-snowboarding","fal fa-snowboarding","fas fa-swimmer","far fa-swimmer","fal fa-swimmer","fas fa-table-tennis","far fa-table-tennis","fal fa-table-tennis","fas fa-tennis-ball","far fa-tennis-ball","fal fa-tennis-ball","fas fa-volleyball-ball","far fa-volleyball-ball","fal fa-volleyball-ball","fas fa-whistle","far fa-whistle","fal fa-whistle"]},{"id":"spring","title":"Spring","icons":["fas fa-allergies","far fa-allergies","fal fa-allergies","fas fa-broom","far fa-broom","fal fa-broom","fas fa-cloud-rainbow","far fa-cloud-rainbow","fal fa-cloud-rainbow","fas fa-cloud-sun","far fa-cloud-sun","fal fa-cloud-sun","fas fa-cloud-sun-rain","far fa-cloud-sun-rain","fal fa-cloud-sun-rain","fas fa-flower","far fa-flower","fal fa-flower","fas fa-flower-daffodil","far fa-flower-daffodil","fal fa-flower-daffodil","fas fa-flower-tulip","far fa-flower-tulip","fal fa-flower-tulip","fas fa-frog","far fa-frog","fal fa-frog","fas fa-hand-holding-seedling","far fa-hand-holding-seedling","fal fa-hand-holding-seedling","fas fa-rabbit","far fa-rabbit","fal fa-rabbit","fas fa-rabbit-fast","far fa-rabbit-fast","fal fa-rabbit-fast","fas fa-rainbow","far fa-rainbow","fal fa-rainbow","fas fa-raindrops","far fa-raindrops","fal fa-raindrops","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-shovel","far fa-shovel","fal fa-shovel","fas fa-sunglasses","far fa-sunglasses","fal fa-sunglasses","fas fa-thunderstorm","far fa-thunderstorm","fal fa-thunderstorm","fas fa-tree-alt","far fa-tree-alt","fal fa-tree-alt","fas fa-umbrella","far fa-umbrella","fal fa-umbrella"]},{"id":"status","title":"Status","icons":["fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-ban","far fa-ban","fal fa-ban","fas fa-battery-bolt","far fa-battery-bolt","fal fa-battery-bolt","fas fa-battery-empty","far fa-battery-empty","fal fa-battery-empty","fas fa-battery-full","far fa-battery-full","fal fa-battery-full","fas fa-battery-half","far fa-battery-half","fal fa-battery-half","fas fa-battery-quarter","far fa-battery-quarter","fal fa-battery-quarter","fas fa-battery-slash","far fa-battery-slash","fal fa-battery-slash","fas fa-battery-three-quarters","far fa-battery-three-quarters","fal fa-battery-three-quarters","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-school","far fa-bell-school","fal fa-bell-school","fas fa-bell-school-slash","far fa-bell-school-slash","fal fa-bell-school-slash","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-bells","far fa-bells","fal fa-bells","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-calendar-alt","far fa-calendar-alt","fal fa-calendar-alt","fas fa-calendar-check","far fa-calendar-check","fal fa-calendar-check","fas fa-calendar-day","far fa-calendar-day","fal fa-calendar-day","fas fa-calendar-edit","far fa-calendar-edit","fal fa-calendar-edit","fas fa-calendar-exclamation","far fa-calendar-exclamation","fal fa-calendar-exclamation","fas fa-calendar-minus","far fa-calendar-minus","fal fa-calendar-minus","fas fa-calendar-plus","far fa-calendar-plus","fal fa-calendar-plus","fas fa-calendar-star","far fa-calendar-star","fal fa-calendar-star","fas fa-calendar-times","far fa-calendar-times","fal fa-calendar-times","fas fa-calendar-week","far fa-calendar-week","fal fa-calendar-week","fas fa-cart-arrow-down","far fa-cart-arrow-down","fal fa-cart-arrow-down","fas fa-cart-plus","far fa-cart-plus","fal fa-cart-plus","fas fa-comment","far fa-comment","fal fa-comment","fas fa-comment-alt","far fa-comment-alt","fal fa-comment-alt","fas fa-comment-alt-slash","far fa-comment-alt-slash","fal fa-comment-alt-slash","fas fa-comment-slash","far fa-comment-slash","fal fa-comment-slash","fas fa-compass","far fa-compass","fal fa-compass","fas fa-compass-slash","far fa-compass-slash","fal fa-compass-slash","fas fa-door-closed","far fa-door-closed","fal fa-door-closed","fas fa-door-open","far fa-door-open","fal fa-door-open","fas fa-exclamation","far fa-exclamation","fal fa-exclamation","fas fa-exclamation-circle","far fa-exclamation-circle","fal fa-exclamation-circle","fas fa-exclamation-square","far fa-exclamation-square","fal fa-exclamation-square","fas fa-exclamation-triangle","far fa-exclamation-triangle","fal fa-exclamation-triangle","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-file","far fa-file","fal fa-file","fas fa-file-alt","far fa-file-alt","fal fa-file-alt","fas fa-file-check","far fa-file-check","fal fa-file-check","fas fa-file-edit","far fa-file-edit","fal fa-file-edit","fas fa-file-exclamation","far fa-file-exclamation","fal fa-file-exclamation","fas fa-file-minus","far fa-file-minus","fal fa-file-minus","fas fa-file-plus","far fa-file-plus","fal fa-file-plus","fas fa-file-times","far fa-file-times","fal fa-file-times","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-gas-pump","far fa-gas-pump","fal fa-gas-pump","fas fa-gas-pump-slash","far fa-gas-pump-slash","fal fa-gas-pump-slash","fas fa-info","far fa-info","fal fa-info","fas fa-info-circle","far fa-info-circle","fal fa-info-circle","fas fa-info-square","far fa-info-square","fal fa-info-square","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-lightbulb-slash","far fa-lightbulb-slash","fal fa-lightbulb-slash","fas fa-location","far fa-location","fal fa-location","fas fa-location-slash","far fa-location-slash","fal fa-location-slash","fas fa-lock","far fa-lock","fal fa-lock","fas fa-lock-alt","far fa-lock-alt","fal fa-lock-alt","fas fa-lock-open","far fa-lock-open","fal fa-lock-open","fas fa-lock-open-alt","far fa-lock-open-alt","fal fa-lock-open-alt","fas fa-map-marker","far fa-map-marker","fal fa-map-marker","fas fa-map-marker-alt","far fa-map-marker-alt","fal fa-map-marker-alt","fas fa-map-marker-alt-slash","far fa-map-marker-alt-slash","fal fa-map-marker-alt-slash","fas fa-map-marker-slash","far fa-map-marker-slash","fal fa-map-marker-slash","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-alt","far fa-microphone-alt","fal fa-microphone-alt","fas fa-microphone-alt-slash","far fa-microphone-alt-slash","fal fa-microphone-alt-slash","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-minus","far fa-minus","fal fa-minus","fas fa-minus-circle","far fa-minus-circle","fal fa-minus-circle","fas fa-minus-hexagon","far fa-minus-hexagon","fal fa-minus-hexagon","fas fa-minus-octagon","far fa-minus-octagon","fal fa-minus-octagon","fas fa-minus-square","far fa-minus-square","fal fa-minus-square","fas fa-parking","far fa-parking","fal fa-parking","fas fa-parking-circle","far fa-parking-circle","fal fa-parking-circle","fas fa-parking-circle-slash","far fa-parking-circle-slash","fal fa-parking-circle-slash","fas fa-parking-slash","far fa-parking-slash","fal fa-parking-slash","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-alt","far fa-phone-alt","fal fa-phone-alt","fas fa-phone-slash","far fa-phone-slash","fal fa-phone-slash","fas fa-plus","far fa-plus","fal fa-plus","fas fa-plus-circle","far fa-plus-circle","fal fa-plus-circle","fas fa-plus-hexagon","far fa-plus-hexagon","fal fa-plus-hexagon","fas fa-plus-octagon","far fa-plus-octagon","fal fa-plus-octagon","fas fa-plus-square","far fa-plus-square","fal fa-plus-square","fas fa-print","far fa-print","fal fa-print","fas fa-print-slash","far fa-print-slash","fal fa-print-slash","fas fa-question","far fa-question","fal fa-question","fas fa-question-circle","far fa-question-circle","fal fa-question-circle","fas fa-question-square","far fa-question-square","fal fa-question-square","fas fa-shield","far fa-shield","fal fa-shield","fas fa-shield-alt","far fa-shield-alt","fal fa-shield-alt","fas fa-shield-check","far fa-shield-check","fal fa-shield-check","fas fa-shopping-cart","far fa-shopping-cart","fal fa-shopping-cart","fas fa-sign-in","far fa-sign-in","fal fa-sign-in","fas fa-sign-in-alt","far fa-sign-in-alt","fal fa-sign-in-alt","fas fa-sign-out","far fa-sign-out","fal fa-sign-out","fas fa-sign-out-alt","far fa-sign-out-alt","fal fa-sign-out-alt","fas fa-signal","far fa-signal","fal fa-signal","fas fa-signal-1","far fa-signal-1","fal fa-signal-1","fas fa-signal-2","far fa-signal-2","fal fa-signal-2","fas fa-signal-3","far fa-signal-3","fal fa-signal-3","fas fa-signal-4","far fa-signal-4","fal fa-signal-4","fas fa-signal-alt","far fa-signal-alt","fal fa-signal-alt","fas fa-signal-alt-1","far fa-signal-alt-1","fal fa-signal-alt-1","fas fa-signal-alt-2","far fa-signal-alt-2","fal fa-signal-alt-2","fas fa-signal-alt-3","far fa-signal-alt-3","fal fa-signal-alt-3","fas fa-signal-alt-slash","far fa-signal-alt-slash","fal fa-signal-alt-slash","fas fa-signal-slash","far fa-signal-slash","fal fa-signal-slash","fas fa-smoking-ban","far fa-smoking-ban","fal fa-smoking-ban","fas fa-star","far fa-star","fal fa-star","fas fa-star-half","far fa-star-half","fal fa-star-half","fas fa-star-half-alt","far fa-star-half-alt","fal fa-star-half-alt","fas fa-stream","far fa-stream","fal fa-stream","fas fa-thermometer-empty","far fa-thermometer-empty","fal fa-thermometer-empty","fas fa-thermometer-full","far fa-thermometer-full","fal fa-thermometer-full","fas fa-thermometer-half","far fa-thermometer-half","fal fa-thermometer-half","fas fa-thermometer-quarter","far fa-thermometer-quarter","fal fa-thermometer-quarter","fas fa-thermometer-three-quarters","far fa-thermometer-three-quarters","fal fa-thermometer-three-quarters","fas fa-thumbs-down","far fa-thumbs-down","fal fa-thumbs-down","fas fa-thumbs-up","far fa-thumbs-up","fal fa-thumbs-up","fas fa-tint","far fa-tint","fal fa-tint","fas fa-tint-slash","far fa-tint-slash","fal fa-tint-slash","fas fa-toggle-off","far fa-toggle-off","fal fa-toggle-off","fas fa-toggle-on","far fa-toggle-on","fal fa-toggle-on","fas fa-unlock","far fa-unlock","fal fa-unlock","fas fa-unlock-alt","far fa-unlock-alt","fal fa-unlock-alt","fas fa-user","far fa-user","fal fa-user","fas fa-user-alt","far fa-user-alt","fal fa-user-alt","fas fa-user-alt-slash","far fa-user-alt-slash","fal fa-user-alt-slash","fas fa-user-slash","far fa-user-slash","fal fa-user-slash","fas fa-video","far fa-video","fal fa-video","fas fa-video-slash","far fa-video-slash","fal fa-video-slash","fas fa-volume","far fa-volume","fal fa-volume","fas fa-volume-down","far fa-volume-down","fal fa-volume-down","fas fa-volume-mute","far fa-volume-mute","fal fa-volume-mute","fas fa-volume-off","far fa-volume-off","fal fa-volume-off","fas fa-volume-slash","far fa-volume-slash","fal fa-volume-slash","fas fa-volume-up","far fa-volume-up","fal fa-volume-up","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wifi-1","far fa-wifi-1","fal fa-wifi-1","fas fa-wifi-2","far fa-wifi-2","fal fa-wifi-2","fas fa-wifi-slash","far fa-wifi-slash","fal fa-wifi-slash"]},{"id":"summer","title":"Summer","icons":["fas fa-anchor","far fa-anchor","fal fa-anchor","fas fa-biking","far fa-biking","fal fa-biking","fas fa-biking-mountain","far fa-biking-mountain","fal fa-biking-mountain","fas fa-fish","far fa-fish","fal fa-fish","fas fa-glass","far fa-glass","fal fa-glass","fas fa-glass-citrus","far fa-glass-citrus","fal fa-glass-citrus","fas fa-hotdog","far fa-hotdog","fal fa-hotdog","fas fa-ice-cream","far fa-ice-cream","fal fa-ice-cream","fas fa-island-tropical","far fa-island-tropical","fal fa-island-tropical","fas fa-kite","far fa-kite","fal fa-kite","fas fa-lemon","far fa-lemon","fal fa-lemon","fas fa-shish-kebab","far fa-shish-kebab","fal fa-shish-kebab","fas fa-sun","far fa-sun","fal fa-sun","fas fa-sunglasses","far fa-sunglasses","fal fa-sunglasses","fas fa-swimmer","far fa-swimmer","fal fa-swimmer","fas fa-swimming-pool","far fa-swimming-pool","fal fa-swimming-pool","fas fa-temperature-hot","far fa-temperature-hot","fal fa-temperature-hot","fas fa-tree-palm","far fa-tree-palm","fal fa-tree-palm","fas fa-umbrella-beach","far fa-umbrella-beach","fal fa-umbrella-beach","fas fa-volleyball-ball","far fa-volleyball-ball","fal fa-volleyball-ball","fas fa-water","far fa-water","fal fa-water"]},{"id":"toggle","title":"Toggle","icons":["fas fa-bullseye","far fa-bullseye","fal fa-bullseye","fas fa-bullseye-arrow","far fa-bullseye-arrow","fal fa-bullseye-arrow","fas fa-check-circle","far fa-check-circle","fal fa-check-circle","fas fa-circle","far fa-circle","fal fa-circle","fas fa-dot-circle","far fa-dot-circle","fal fa-dot-circle","fas fa-location","far fa-location","fal fa-location","fas fa-location-slash","far fa-location-slash","fal fa-location-slash","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-star","far fa-star","fal fa-star","fas fa-star-half","far fa-star-half","fal fa-star-half","fas fa-star-half-alt","far fa-star-half-alt","fal fa-star-half-alt","fas fa-toggle-off","far fa-toggle-off","fal fa-toggle-off","fas fa-toggle-on","far fa-toggle-on","fal fa-toggle-on","fas fa-volume","far fa-volume","fal fa-volume","fas fa-volume-slash","far fa-volume-slash","fal fa-volume-slash","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wifi-slash","far fa-wifi-slash","fal fa-wifi-slash"]},{"id":"travel","title":"Travel","icons":["fas fa-archway","far fa-archway","fal fa-archway","fas fa-atlas","far fa-atlas","fal fa-atlas","fas fa-bed","far fa-bed","fal fa-bed","fas fa-bus","far fa-bus","fal fa-bus","fas fa-bus-alt","far fa-bus-alt","fal fa-bus-alt","fal fa-cactus","far fa-cactus","fas fa-cactus","fas fa-car-bus","far fa-car-bus","fal fa-car-bus","fas fa-caravan","far fa-caravan","fal fa-caravan","fas fa-caravan-alt","far fa-caravan-alt","fal fa-caravan-alt","fas fa-cars","far fa-cars","fal fa-cars","fas fa-cocktail","far fa-cocktail","fal fa-cocktail","fas fa-concierge-bell","far fa-concierge-bell","fal fa-concierge-bell","fas fa-dumbbell","far fa-dumbbell","fal fa-dumbbell","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-glass-martini","far fa-glass-martini","fal fa-glass-martini","fas fa-glass-martini-alt","far fa-glass-martini-alt","fal fa-glass-martini-alt","fas fa-globe-africa","far fa-globe-africa","fal fa-globe-africa","fas fa-globe-americas","far fa-globe-americas","fal fa-globe-americas","fas fa-globe-asia","far fa-globe-asia","fal fa-globe-asia","fas fa-globe-europe","far fa-globe-europe","fal fa-globe-europe","fal fa-horse-saddle","far fa-horse-saddle","fas fa-horse-saddle","fas fa-hot-tub","far fa-hot-tub","fal fa-hot-tub","fas fa-hotel","far fa-hotel","fal fa-hotel","fas fa-island-tropical","far fa-island-tropical","fal fa-island-tropical","fas fa-luggage-cart","far fa-luggage-cart","fal fa-luggage-cart","fas fa-map","far fa-map","fal fa-map","fas fa-map-marked","far fa-map-marked","fal fa-map-marked","fas fa-map-marked-alt","far fa-map-marked-alt","fal fa-map-marked-alt","fas fa-monument","far fa-monument","fal fa-monument","fas fa-passport","far fa-passport","fal fa-passport","fas fa-phone-rotary","far fa-phone-rotary","fal fa-phone-rotary","fas fa-plane","far fa-plane","fal fa-plane","fas fa-plane-arrival","far fa-plane-arrival","fal fa-plane-arrival","fas fa-plane-departure","far fa-plane-departure","fal fa-plane-departure","fas fa-rings-wedding","far fa-rings-wedding","fal fa-rings-wedding","fas fa-rv","far fa-rv","fal fa-rv","fas fa-shuttle-van","far fa-shuttle-van","fal fa-shuttle-van","fas fa-spa","far fa-spa","fal fa-spa","fas fa-suitcase","far fa-suitcase","fal fa-suitcase","fas fa-suitcase-rolling","far fa-suitcase-rolling","fal fa-suitcase-rolling","fas fa-swimmer","far fa-swimmer","fal fa-swimmer","fas fa-swimming-pool","far fa-swimming-pool","fal fa-swimming-pool","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-tram","far fa-tram","fal fa-tram","fas fa-tree-palm","far fa-tree-palm","fal fa-tree-palm","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-alt","far fa-tv-alt","fal fa-tv-alt","fas fa-umbrella-beach","far fa-umbrella-beach","fal fa-umbrella-beach","fal fa-wagon-covered","far fa-wagon-covered","fas fa-wagon-covered","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass","fas fa-wine-glass-alt","far fa-wine-glass-alt","fal fa-wine-glass-alt"]},{"id":"users-people","title":"Users & People","icons":["fab fa-accessible-icon","fas fa-address-book","far fa-address-book","fal fa-address-book","fas fa-address-card","far fa-address-card","fal fa-address-card","fas fa-angel","far fa-angel","fal fa-angel","fas fa-baby","far fa-baby","fal fa-baby","fas fa-bed","far fa-bed","fal fa-bed","fas fa-biking","far fa-biking","fal fa-biking","fas fa-biking-mountain","far fa-biking-mountain","fal fa-biking-mountain","fas fa-blind","far fa-blind","fal fa-blind","fas fa-chalkboard-teacher","far fa-chalkboard-teacher","fal fa-chalkboard-teacher","fas fa-child","far fa-child","fal fa-child","fas fa-digging","far fa-digging","fal fa-digging","fas fa-female","far fa-female","fal fa-female","fas fa-file-user","far fa-file-user","fal fa-file-user","fas fa-frown","far fa-frown","fal fa-frown","fas fa-head-side","far fa-head-side","fal fa-head-side","fas fa-head-vr","far fa-head-vr","fal fa-head-vr","fas fa-hiking","far fa-hiking","fal fa-hiking","fas fa-id-badge","far fa-id-badge","fal fa-id-badge","fas fa-id-card","far fa-id-card","fal fa-id-card","fas fa-id-card-alt","far fa-id-card-alt","fal fa-id-card-alt","fas fa-male","far fa-male","fal fa-male","fas fa-meh","far fa-meh","fal fa-meh","fal fa-people-arrows","far fa-people-arrows","fas fa-people-arrows","fas fa-people-carry","far fa-people-carry","fal fa-people-carry","fas fa-person-booth","far fa-person-booth","fal fa-person-booth","fas fa-person-carry","far fa-person-carry","fal fa-person-carry","fas fa-person-dolly","far fa-person-dolly","fal fa-person-dolly","fas fa-person-dolly-empty","far fa-person-dolly-empty","fal fa-person-dolly-empty","fas fa-person-sign","far fa-person-sign","fal fa-person-sign","fas fa-poll-people","far fa-poll-people","fal fa-poll-people","fas fa-poo","far fa-poo","fal fa-poo","fas fa-portrait","far fa-portrait","fal fa-portrait","fas fa-power-off","far fa-power-off","fal fa-power-off","fas fa-pray","far fa-pray","fal fa-pray","fas fa-restroom","far fa-restroom","fal fa-restroom","fas fa-running","far fa-running","fal fa-running","fas fa-skating","far fa-skating","fal fa-skating","fas fa-ski-jump","far fa-ski-jump","fal fa-ski-jump","fas fa-ski-lift","far fa-ski-lift","fal fa-ski-lift","fas fa-skiing","far fa-skiing","fal fa-skiing","fas fa-skiing-nordic","far fa-skiing-nordic","fal fa-skiing-nordic","fas fa-sledding","far fa-sledding","fal fa-sledding","fas fa-smile","far fa-smile","fal fa-smile","fas fa-snowboarding","far fa-snowboarding","fal fa-snowboarding","fas fa-snowmobile","far fa-snowmobile","fal fa-snowmobile","fas fa-street-view","far fa-street-view","fal fa-street-view","fas fa-swimmer","far fa-swimmer","fal fa-swimmer","fas fa-user","far fa-user","fal fa-user","fas fa-user-alt","far fa-user-alt","fal fa-user-alt","fas fa-user-alt-slash","far fa-user-alt-slash","fal fa-user-alt-slash","fas fa-user-astronaut","far fa-user-astronaut","fal fa-user-astronaut","fas fa-user-chart","far fa-user-chart","fal fa-user-chart","fas fa-user-check","far fa-user-check","fal fa-user-check","fas fa-user-circle","far fa-user-circle","fal fa-user-circle","fas fa-user-clock","far fa-user-clock","fal fa-user-clock","fas fa-user-cog","far fa-user-cog","fal fa-user-cog","fal fa-user-cowboy","far fa-user-cowboy","fas fa-user-cowboy","fas fa-user-crown","far fa-user-crown","fal fa-user-crown","fas fa-user-edit","far fa-user-edit","fal fa-user-edit","fas fa-user-friends","far fa-user-friends","fal fa-user-friends","fas fa-user-graduate","far fa-user-graduate","fal fa-user-graduate","fas fa-user-hard-hat","far fa-user-hard-hat","fal fa-user-hard-hat","fas fa-user-headset","far fa-user-headset","fal fa-user-headset","fas fa-user-injured","far fa-user-injured","fal fa-user-injured","fas fa-user-lock","far fa-user-lock","fal fa-user-lock","fas fa-user-md","far fa-user-md","fal fa-user-md","fas fa-user-md-chat","far fa-user-md-chat","fal fa-user-md-chat","fas fa-user-minus","far fa-user-minus","fal fa-user-minus","fas fa-user-music","far fa-user-music","fal fa-user-music","fas fa-user-ninja","far fa-user-ninja","fal fa-user-ninja","fas fa-user-nurse","far fa-user-nurse","fal fa-user-nurse","fas fa-user-plus","far fa-user-plus","fal fa-user-plus","fas fa-user-secret","far fa-user-secret","fal fa-user-secret","fas fa-user-shield","far fa-user-shield","fal fa-user-shield","fas fa-user-slash","far fa-user-slash","fal fa-user-slash","fas fa-user-tag","far fa-user-tag","fal fa-user-tag","fas fa-user-tie","far fa-user-tie","fal fa-user-tie","fas fa-user-times","far fa-user-times","fal fa-user-times","fal fa-user-unlock","far fa-user-unlock","fas fa-user-unlock","fas fa-users","far fa-users","fal fa-users","fas fa-users-class","far fa-users-class","fal fa-users-class","fas fa-users-cog","far fa-users-cog","fal fa-users-cog","fas fa-users-crown","far fa-users-crown","fal fa-users-crown","fas fa-users-medical","far fa-users-medical","fal fa-users-medical","fal fa-users-slash","far fa-users-slash","fas fa-users-slash","fas fa-walking","far fa-walking","fal fa-walking","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair"]},{"id":"vehicles","title":"Vehicles","icons":["fab fa-accessible-icon","fas fa-ambulance","far fa-ambulance","fal fa-ambulance","fas fa-baby-carriage","far fa-baby-carriage","fal fa-baby-carriage","fas fa-bicycle","far fa-bicycle","fal fa-bicycle","fas fa-bus","far fa-bus","fal fa-bus","fas fa-bus-alt","far fa-bus-alt","fal fa-bus-alt","fas fa-car","far fa-car","fal fa-car","fas fa-car-alt","far fa-car-alt","fal fa-car-alt","fas fa-car-building","far fa-car-building","fal fa-car-building","fas fa-car-bump","far fa-car-bump","fal fa-car-bump","fas fa-car-bus","far fa-car-bus","fal fa-car-bus","fas fa-car-crash","far fa-car-crash","fal fa-car-crash","fas fa-car-side","far fa-car-side","fal fa-car-side","fas fa-car-tilt","far fa-car-tilt","fal fa-car-tilt","fas fa-cars","far fa-cars","fal fa-cars","fas fa-drone","far fa-drone","fal fa-drone","fas fa-drone-alt","far fa-drone-alt","fal fa-drone-alt","fas fa-fighter-jet","far fa-fighter-jet","fal fa-fighter-jet","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-helicopter","far fa-helicopter","fal fa-helicopter","fas fa-horse","far fa-horse","fal fa-horse","fal fa-horse-saddle","far fa-horse-saddle","fas fa-horse-saddle","fas fa-motorcycle","far fa-motorcycle","fal fa-motorcycle","fas fa-paper-plane","far fa-paper-plane","fal fa-paper-plane","fas fa-pegasus","far fa-pegasus","fal fa-pegasus","fas fa-plane","far fa-plane","fal fa-plane","fas fa-plane-alt","far fa-plane-alt","fal fa-plane-alt","fas fa-rocket","far fa-rocket","fal fa-rocket","fas fa-rocket-launch","far fa-rocket-launch","fal fa-rocket-launch","fas fa-rv","far fa-rv","fal fa-rv","fas fa-ship","far fa-ship","fal fa-ship","fas fa-shopping-cart","far fa-shopping-cart","fal fa-shopping-cart","fas fa-shuttle-van","far fa-shuttle-van","fal fa-shuttle-van","fas fa-ski-lift","far fa-ski-lift","fal fa-ski-lift","fas fa-sleigh","far fa-sleigh","fal fa-sleigh","fas fa-snowmobile","far fa-snowmobile","fal fa-snowmobile","fas fa-snowplow","far fa-snowplow","fal fa-snowplow","fas fa-space-shuttle","far fa-space-shuttle","fal fa-space-shuttle","fas fa-starfighter","far fa-starfighter","fal fa-starfighter","fas fa-starfighter-alt","far fa-starfighter-alt","fal fa-starfighter-alt","fas fa-starship","far fa-starship","fal fa-starship","fas fa-starship-freighter","far fa-starship-freighter","fal fa-starship-freighter","fas fa-subway","far fa-subway","fal fa-subway","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-tractor","far fa-tractor","fal fa-tractor","fas fa-train","far fa-train","fal fa-train","fas fa-tram","far fa-tram","fal fa-tram","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-monster","far fa-truck-monster","fal fa-truck-monster","fas fa-truck-pickup","far fa-truck-pickup","fal fa-truck-pickup","fas fa-truck-plow","far fa-truck-plow","fal fa-truck-plow","fas fa-ufo","far fa-ufo","fal fa-ufo","fas fa-ufo-beam","far fa-ufo-beam","fal fa-ufo-beam","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair"]},{"id":"weather","title":"Weather","icons":["fas fa-bolt","far fa-bolt","fal fa-bolt","fas fa-cloud","far fa-cloud","fal fa-cloud","fas fa-cloud-drizzle","far fa-cloud-drizzle","fal fa-cloud-drizzle","fas fa-cloud-hail","far fa-cloud-hail","fal fa-cloud-hail","fas fa-cloud-hail-mixed","far fa-cloud-hail-mixed","fal fa-cloud-hail-mixed","fas fa-cloud-meatball","far fa-cloud-meatball","fal fa-cloud-meatball","fas fa-cloud-moon","far fa-cloud-moon","fal fa-cloud-moon","fas fa-cloud-moon-rain","far fa-cloud-moon-rain","fal fa-cloud-moon-rain","fas fa-cloud-rain","far fa-cloud-rain","fal fa-cloud-rain","fas fa-cloud-rainbow","far fa-cloud-rainbow","fal fa-cloud-rainbow","fas fa-cloud-showers","far fa-cloud-showers","fal fa-cloud-showers","fas fa-cloud-showers-heavy","far fa-cloud-showers-heavy","fal fa-cloud-showers-heavy","fas fa-cloud-sleet","far fa-cloud-sleet","fal fa-cloud-sleet","fas fa-cloud-snow","far fa-cloud-snow","fal fa-cloud-snow","fas fa-cloud-sun","far fa-cloud-sun","fal fa-cloud-sun","fas fa-cloud-sun-rain","far fa-cloud-sun-rain","fal fa-cloud-sun-rain","fas fa-clouds","far fa-clouds","fal fa-clouds","fas fa-clouds-moon","far fa-clouds-moon","fal fa-clouds-moon","fas fa-clouds-sun","far fa-clouds-sun","fal fa-clouds-sun","fas fa-dewpoint","far fa-dewpoint","fal fa-dewpoint","fas fa-eclipse","far fa-eclipse","fal fa-eclipse","fas fa-eclipse-alt","far fa-eclipse-alt","fal fa-eclipse-alt","fas fa-fire-smoke","far fa-fire-smoke","fal fa-fire-smoke","fas fa-fog","far fa-fog","fal fa-fog","fas fa-heat","far fa-heat","fal fa-heat","fas fa-house-flood","far fa-house-flood","fal fa-house-flood","fas fa-humidity","far fa-humidity","fal fa-humidity","fas fa-hurricane","far fa-hurricane","fal fa-hurricane","fas fa-meteor","far fa-meteor","fal fa-meteor","fas fa-moon","far fa-moon","fal fa-moon","fas fa-moon-cloud","far fa-moon-cloud","fal fa-moon-cloud","fas fa-moon-stars","far fa-moon-stars","fal fa-moon-stars","fas fa-poo-storm","far fa-poo-storm","fal fa-poo-storm","fas fa-rainbow","far fa-rainbow","fal fa-rainbow","fas fa-raindrops","far fa-raindrops","fal fa-raindrops","fas fa-smog","far fa-smog","fal fa-smog","fas fa-smoke","far fa-smoke","fal fa-smoke","fas fa-snow-blowing","far fa-snow-blowing","fal fa-snow-blowing","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-snowflakes","far fa-snowflakes","fal fa-snowflakes","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-stars","far fa-stars","fal fa-stars","fas fa-sun","far fa-sun","fal fa-sun","fas fa-sun-cloud","far fa-sun-cloud","fal fa-sun-cloud","fas fa-sun-dust","far fa-sun-dust","fal fa-sun-dust","fas fa-sun-haze","far fa-sun-haze","fal fa-sun-haze","fas fa-sunrise","far fa-sunrise","fal fa-sunrise","fas fa-sunset","far fa-sunset","fal fa-sunset","fas fa-temperature-down","far fa-temperature-down","fal fa-temperature-down","fas fa-temperature-frigid","far fa-temperature-frigid","fal fa-temperature-frigid","fas fa-temperature-high","far fa-temperature-high","fal fa-temperature-high","fas fa-temperature-hot","far fa-temperature-hot","fal fa-temperature-hot","fas fa-temperature-low","far fa-temperature-low","fal fa-temperature-low","fas fa-temperature-up","far fa-temperature-up","fal fa-temperature-up","fas fa-thunderstorm","far fa-thunderstorm","fal fa-thunderstorm","fas fa-thunderstorm-moon","far fa-thunderstorm-moon","fal fa-thunderstorm-moon","fas fa-thunderstorm-sun","far fa-thunderstorm-sun","fal fa-thunderstorm-sun","fas fa-tornado","far fa-tornado","fal fa-tornado","fas fa-umbrella","far fa-umbrella","fal fa-umbrella","fas fa-volcano","far fa-volcano","fal fa-volcano","fas fa-water","far fa-water","fal fa-water","fas fa-water-lower","far fa-water-lower","fal fa-water-lower","fas fa-water-rise","far fa-water-rise","fal fa-water-rise","fas fa-wind","far fa-wind","fal fa-wind","fas fa-wind-warning","far fa-wind-warning","fal fa-wind-warning","fas fa-windsock","far fa-windsock","fal fa-windsock"]},{"id":"winter","title":"Winter","icons":["fas fa-ball-pile","far fa-ball-pile","fal fa-ball-pile","fas fa-boot","far fa-boot","fal fa-boot","fas fa-chimney","far fa-chimney","fal fa-chimney","fas fa-ear-muffs","far fa-ear-muffs","fal fa-ear-muffs","fas fa-frosty-head","far fa-frosty-head","fal fa-frosty-head","fas fa-glass-whiskey","far fa-glass-whiskey","fal fa-glass-whiskey","fas fa-glass-whiskey-rocks","far fa-glass-whiskey-rocks","fal fa-glass-whiskey-rocks","fas fa-globe-snow","far fa-globe-snow","fal fa-globe-snow","fas fa-hat-winter","far fa-hat-winter","fal fa-hat-winter","fas fa-ice-skate","far fa-ice-skate","fal fa-ice-skate","fas fa-icicles","far fa-icicles","fal fa-icicles","fas fa-igloo","far fa-igloo","fal fa-igloo","fas fa-mitten","far fa-mitten","fal fa-mitten","fas fa-mug-marshmallows","far fa-mug-marshmallows","fal fa-mug-marshmallows","fas fa-mug-tea","far fa-mug-tea","fal fa-mug-tea","fas fa-scarf","far fa-scarf","fal fa-scarf","fas fa-shovel-snow","far fa-shovel-snow","fal fa-shovel-snow","fas fa-skating","far fa-skating","fal fa-skating","fas fa-ski-jump","far fa-ski-jump","fal fa-ski-jump","fas fa-ski-lift","far fa-ski-lift","fal fa-ski-lift","fas fa-skiing","far fa-skiing","fal fa-skiing","fas fa-skiing-nordic","far fa-skiing-nordic","fal fa-skiing-nordic","fas fa-sledding","far fa-sledding","fal fa-sledding","fas fa-snowboarding","far fa-snowboarding","fal fa-snowboarding","fas fa-snowflakes","far fa-snowflakes","fal fa-snowflakes","fas fa-snowmobile","far fa-snowmobile","fal fa-snowmobile","fas fa-snowplow","far fa-snowplow","fal fa-snowplow","fas fa-temperature-frigid","far fa-temperature-frigid","fal fa-temperature-frigid","fas fa-tram","far fa-tram","fal fa-tram","fas fa-tree-large","far fa-tree-large","fal fa-tree-large","fas fa-truck-plow","far fa-truck-plow","fal fa-truck-plow"]},{"id":"writing","title":"Writing","icons":["fas fa-archive","far fa-archive","fal fa-archive","fas fa-blog","far fa-blog","fal fa-blog","fas fa-book","far fa-book","fal fa-book","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fas fa-edit","far fa-edit","fal fa-edit","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-open","far fa-envelope-open","fal fa-envelope-open","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-file","far fa-file","fal fa-file","fas fa-file-alt","far fa-file-alt","fal fa-file-alt","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-keyboard","far fa-keyboard","fal fa-keyboard","fas fa-newspaper","far fa-newspaper","fal fa-newspaper","fas fa-paper-plane","far fa-paper-plane","fal fa-paper-plane","fas fa-paperclip","far fa-paperclip","fal fa-paperclip","fas fa-paragraph","far fa-paragraph","fal fa-paragraph","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-alt","far fa-pen-alt","fal fa-pen-alt","fas fa-pen-square","far fa-pen-square","fal fa-pen-square","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-alt","far fa-pencil-alt","fal fa-pencil-alt","fas fa-quote-left","far fa-quote-left","fal fa-quote-left","fas fa-quote-right","far fa-quote-right","fal fa-quote-right","fas fa-sticky-note","far fa-sticky-note","fal fa-sticky-note","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack"]},{"id":"other","title":"Other","icons":["fas fa-backspace","far fa-backspace","fal fa-backspace","fas fa-blender-phone","far fa-blender-phone","fal fa-blender-phone","fas fa-coffin-cross","far fa-coffin-cross","fal fa-coffin-cross","fas fa-crown","far fa-crown","fal fa-crown","fas fa-dumpster-fire","far fa-dumpster-fire","fal fa-dumpster-fire","fas fa-file-csv","far fa-file-csv","fal fa-file-csv","fas fa-font-awesome-logo-full","far fa-font-awesome-logo-full","fal fa-font-awesome-logo-full","fas fa-line-height","far fa-line-height","fal fa-line-height","fas fa-network-wired","far fa-network-wired","fal fa-network-wired","fal fa-plane-slash","far fa-plane-slash","fas fa-plane-slash","fas fa-print-search","far fa-print-search","fal fa-print-search","fas fa-signature","far fa-signature","fal fa-signature","fas fa-skull","far fa-skull","fal fa-skull","fal fa-stopwatch-20","far fa-stopwatch-20","fas fa-stopwatch-20","fas fa-vr-cardboard","far fa-vr-cardboard","fal fa-vr-cardboard","fas fa-weight-hanging","far fa-weight-hanging","fal fa-weight-hanging"]},{"id":"brands","title":"Brands","icons":["fab fa-accessible-icon","fab fa-youtube","fab fa-bluetooth","fab fa-bluetooth-b","fab fa-bitcoin","fab fa-btc","fab fa-ethereum","fab fa-gg","fab fa-gg-circle","fab fa-playstation","fab fa-steam","fab fa-steam-square","fab fa-steam-symbol","fab fa-twitch","fab fa-xbox","fab fa-acquisitions-incorporated","fab fa-critical-role","fab fa-d-and-d","fab fa-d-and-d-beyond","fab fa-fantasy-flight-games","fab fa-penny-arcade","fab fa-wizards-of-the-coast","fab fa-unsplash","fab fa-napster","fab fa-soundcloud","fab fa-spotify","fab fa-alipay","fab fa-amazon-pay","fab fa-apple-pay","fab fa-cc-amazon-pay","fab fa-cc-amex","fab fa-cc-apple-pay","fab fa-cc-diners-club","fab fa-cc-discover","fab fa-cc-jcb","fab fa-cc-mastercard","fab fa-cc-paypal","fab fa-cc-stripe","fab fa-cc-visa","fab fa-google-pay","fab fa-google-wallet","fab fa-paypal","fab fa-stripe","fab fa-stripe-s","fab fa-galactic-republic","fab fa-galactic-senate","fab fa-jedi-order","fab fa-old-republic","fab fa-500px","fab fa-accusoft","fab fa-adn","fab fa-adversal","fab fa-affiliatetheme","fab fa-airbnb","fab fa-algolia","fab fa-amazon","fab fa-amilia","fab fa-android","fab fa-angellist","fab fa-angrycreative","fab fa-angular","fab fa-app-store","fab fa-app-store-ios","fab fa-apper","fab fa-apple","fab fa-artstation","fab fa-asymmetrik","fab fa-atlassian","fab fa-audible","fab fa-autoprefixer","fab fa-avianex","fab fa-aviato","fab fa-aws","fab fa-bandcamp","fab fa-battle-net","fab fa-behance","fab fa-behance-square","fab fa-bimobject","fab fa-bitbucket","fab fa-bity","fab fa-black-tie","fab fa-blackberry","fab fa-blogger","fab fa-blogger-b","fab fa-bootstrap","fab fa-buffer","fab fa-buromobelexperte","fab fa-buy-n-large","fab fa-buysellads","fab fa-canadian-maple-leaf","fab fa-centercode","fab fa-centos","fab fa-chrome","fab fa-chromecast","fab fa-cloudflare","fab fa-cloudscale","fab fa-cloudsmith","fab fa-cloudversify","fab fa-codepen","fab fa-codiepie","fab fa-confluence","fab fa-connectdevelop","fab fa-contao","fab fa-cotton-bureau","fab fa-cpanel","fab fa-creative-commons","fab fa-creative-commons-by","fab fa-creative-commons-nc","fab fa-creative-commons-nc-eu","fab fa-creative-commons-nc-jp","fab fa-creative-commons-nd","fab fa-creative-commons-pd","fab fa-creative-commons-pd-alt","fab fa-creative-commons-remix","fab fa-creative-commons-sa","fab fa-creative-commons-sampling","fab fa-creative-commons-sampling-plus","fab fa-creative-commons-share","fab fa-creative-commons-zero","fab fa-css3","fab fa-css3-alt","fab fa-cuttlefish","fab fa-dailymotion","fab fa-dashcube","fab fa-deezer","fab fa-delicious","fab fa-deploydog","fab fa-deskpro","fab fa-dev","fab fa-deviantart","fab fa-dhl","fab fa-diaspora","fab fa-digg","fab fa-digital-ocean","fab fa-discord","fab fa-discourse","fab fa-dochub","fab fa-docker","fab fa-draft2digital","fab fa-dribbble","fab fa-dribbble-square","fab fa-dropbox","fab fa-drupal","fab fa-dyalog","fab fa-earlybirds","fab fa-ebay","fab fa-edge","fab fa-edge-legacy","fab fa-elementor","fab fa-ello","fab fa-ember","fab fa-empire","fab fa-envira","fab fa-erlang","fab fa-etsy","fab fa-evernote","fab fa-expeditedssl","fab fa-facebook","fab fa-facebook-f","fab fa-facebook-messenger","fab fa-facebook-square","fab fa-fedex","fab fa-fedora","fab fa-figma","fab fa-firefox","fab fa-firefox-browser","fab fa-first-order","fab fa-first-order-alt","fab fa-firstdraft","fab fa-flickr","fab fa-flipboard","fab fa-fly","fab fa-font-awesome","fab fa-font-awesome-alt","fab fa-font-awesome-flag","fab fa-font-awesome-logo-full","fab fa-fonticons","fab fa-fonticons-fi","fab fa-fort-awesome","fab fa-fort-awesome-alt","fab fa-forumbee","fab fa-foursquare","fab fa-free-code-camp","fab fa-freebsd","fab fa-fulcrum","fab fa-get-pocket","fab fa-git","fab fa-git-alt","fab fa-git-square","fab fa-github","fab fa-github-alt","fab fa-github-square","fab fa-gitkraken","fab fa-gitlab","fab fa-gitter","fab fa-glide","fab fa-glide-g","fab fa-gofore","fab fa-goodreads","fab fa-goodreads-g","fab fa-google","fab fa-google-drive","fab fa-google-play","fab fa-google-plus","fab fa-google-plus-g","fab fa-google-plus-square","fab fa-gratipay","fab fa-grav","fab fa-gripfire","fab fa-grunt","fab fa-guilded","fab fa-gulp","fab fa-hacker-news","fab fa-hacker-news-square","fab fa-hackerrank","fab fa-hips","fab fa-hire-a-helper","fab fa-hive","fab fa-hooli","fab fa-hornbill","fab fa-hotjar","fab fa-houzz","fab fa-html5","fab fa-hubspot","fab fa-ideal","fab fa-imdb","fab fa-innosoft","fab fa-instagram","fab fa-instagram-square","fab fa-instalod","fab fa-intercom","fab fa-internet-explorer","fab fa-invision","fab fa-ioxhost","fab fa-itch-io","fab fa-itunes","fab fa-itunes-note","fab fa-java","fab fa-jenkins","fab fa-jira","fab fa-joget","fab fa-joomla","fab fa-js","fab fa-js-square","fab fa-jsfiddle","fab fa-kaggle","fab fa-keybase","fab fa-keycdn","fab fa-kickstarter","fab fa-kickstarter-k","fab fa-korvue","fab fa-laravel","fab fa-lastfm","fab fa-lastfm-square","fab fa-leanpub","fab fa-less","fab fa-line","fab fa-linkedin","fab fa-linkedin-in","fab fa-linode","fab fa-linux","fab fa-lyft","fab fa-magento","fab fa-mailchimp","fab fa-mandalorian","fab fa-markdown","fab fa-mastodon","fab fa-maxcdn","fab fa-mdb","fab fa-medapps","fab fa-medium","fab fa-medium-m","fab fa-medrt","fab fa-meetup","fab fa-megaport","fab fa-mendeley","fab fa-microblog","fab fa-microsoft","fab fa-mix","fab fa-mixcloud","fab fa-mixer","fab fa-mizuni","fab fa-modx","fab fa-monero","fab fa-neos","fab fa-nimblr","fab fa-node","fab fa-node-js","fab fa-npm","fab fa-ns8","fab fa-nutritionix","fab fa-octopus-deploy","fab fa-odnoklassniki","fab fa-odnoklassniki-square","fab fa-opencart","fab fa-openid","fab fa-opera","fab fa-optin-monster","fab fa-orcid","fab fa-osi","fab fa-page4","fab fa-pagelines","fab fa-palfed","fab fa-patreon","fab fa-perbyte","fab fa-periscope","fab fa-phabricator","fab fa-phoenix-framework","fab fa-phoenix-squadron","fab fa-php","fab fa-pied-piper","fab fa-pied-piper-alt","fab fa-pied-piper-hat","fab fa-pied-piper-pp","fab fa-pied-piper-square","fab fa-pinterest","fab fa-pinterest-p","fab fa-pinterest-square","fab fa-product-hunt","fab fa-pushed","fab fa-python","fab fa-qq","fab fa-quinscape","fab fa-quora","fab fa-r-project","fab fa-raspberry-pi","fab fa-ravelry","fab fa-react","fab fa-reacteurope","fab fa-readme","fab fa-rebel","fab fa-red-river","fab fa-reddit","fab fa-reddit-alien","fab fa-reddit-square","fab fa-redhat","fab fa-renren","fab fa-replyd","fab fa-researchgate","fab fa-resolving","fab fa-rev","fab fa-rocketchat","fab fa-rockrms","fab fa-rust","fab fa-safari","fab fa-salesforce","fab fa-sass","fab fa-schlix","fab fa-scribd","fab fa-searchengin","fab fa-sellcast","fab fa-sellsy","fab fa-servicestack","fab fa-shirtsinbulk","fab fa-shopify","fab fa-shopware","fab fa-simplybuilt","fab fa-sistrix","fab fa-sith","fab fa-sketch","fab fa-skyatlas","fab fa-skype","fab fa-slack","fab fa-slack-hash","fab fa-slideshare","fab fa-snapchat","fab fa-snapchat-ghost","fab fa-snapchat-square","fab fa-sourcetree","fab fa-speakap","fab fa-speaker-deck","fab fa-squarespace","fab fa-stack-exchange","fab fa-stack-overflow","fab fa-stackpath","fab fa-staylinked","fab fa-sticker-mule","fab fa-strava","fab fa-studiovinari","fab fa-stumbleupon","fab fa-stumbleupon-circle","fab fa-superpowers","fab fa-supple","fab fa-suse","fab fa-swift","fab fa-symfony","fab fa-teamspeak","fab fa-telegram","fab fa-telegram-plane","fab fa-tencent-weibo","fab fa-the-red-yeti","fab fa-themeco","fab fa-themeisle","fab fa-think-peaks","fab fa-tiktok","fab fa-trade-federation","fab fa-trello","fab fa-tumblr","fab fa-tumblr-square","fab fa-twitter","fab fa-twitter-square","fab fa-typo3","fab fa-uber","fab fa-ubuntu","fab fa-uikit","fab fa-umbraco","fab fa-uncharted","fab fa-uniregistry","fab fa-unity","fab fa-untappd","fab fa-ups","fab fa-usb","fab fa-usps","fab fa-ussunnah","fab fa-vaadin","fab fa-viacoin","fab fa-viadeo","fab fa-viadeo-square","fab fa-viber","fab fa-vimeo","fab fa-vimeo-square","fab fa-vimeo-v","fab fa-vine","fab fa-vk","fab fa-vnv","fab fa-vuejs","fab fa-watchman-monitoring","fab fa-waze","fab fa-weebly","fab fa-weibo","fab fa-weixin","fab fa-whatsapp","fab fa-whatsapp-square","fab fa-whmcs","fab fa-wikipedia-w","fab fa-windows","fab fa-wix","fab fa-wodu","fab fa-wolf-pack-battalion","fab fa-wordpress","fab fa-wordpress-simple","fab fa-wpbeginner","fab fa-wpexplorer","fab fa-wpforms","fab fa-wpressr","fab fa-xing","fab fa-xing-square","fab fa-y-combinator","fab fa-yahoo","fab fa-yammer","fab fa-yandex","fab fa-yandex-international","fab fa-yarn","fab fa-yelp","fab fa-yoast","fab fa-youtube-square","fab fa-zhihu"]}]', true)
	            ),
                'fontawesome' => array(
                    'label' => esc_html__('Font Awesome','g5plus-auteur'),
                    'iconGroup' => json_decode('[{"id":"film-video","title":"Film + Video","icons":["fas fa-360-degrees","far fa-360-degrees","fal fa-360-degrees","fas fa-airplay","far fa-airplay","fal fa-airplay","fas fa-album-collection","far fa-album-collection","fal fa-album-collection","fas fa-amp-guitar","far fa-amp-guitar","fal fa-amp-guitar","fas fa-audio-description","far fa-audio-description","fal fa-audio-description","fas fa-audio-description-slash","far fa-audio-description-slash","fal fa-audio-description-slash","fas fa-camcorder","far fa-camcorder","fal fa-camcorder","fas fa-camera-cctv","far fa-camera-cctv","fal fa-camera-cctv","fas fa-camera-movie","far fa-camera-movie","fal fa-camera-movie","fas fa-camera-polaroid","far fa-camera-polaroid","fal fa-camera-polaroid","fas fa-camera-security","far fa-camera-security","fal fa-camera-security","fas fa-camera-web","far fa-camera-web","fal fa-camera-web","fas fa-camera-web-slash","far fa-camera-web-slash","fal fa-camera-web-slash","fas fa-cassette-betamax","far fa-cassette-betamax","fal fa-cassette-betamax","fas fa-cassette-vhs","far fa-cassette-vhs","fal fa-cassette-vhs","fas fa-circle","far fa-circle","fal fa-circle","fas fa-circle-microphone","far fa-circle-microphone","fal fa-circle-microphone","fas fa-circle-microphone-lines","far fa-circle-microphone-lines","fal fa-circle-microphone-lines","fas fa-circle-video","far fa-circle-video","fal fa-circle-video","fas fa-circle-waveform-lines","far fa-circle-waveform-lines","fal fa-circle-waveform-lines","fas fa-clapperboard","far fa-clapperboard","fal fa-clapperboard","fas fa-clapperboard-play","far fa-clapperboard-play","fal fa-clapperboard-play","fas fa-closed-captioning","far fa-closed-captioning","fal fa-closed-captioning","fas fa-cloud-music","far fa-cloud-music","fal fa-cloud-music","fas fa-compact-disc","far fa-compact-disc","fal fa-compact-disc","fas fa-computer-speaker","far fa-computer-speaker","fal fa-computer-speaker","fas fa-dial","far fa-dial","fal fa-dial","fas fa-dial-high","far fa-dial-high","fal fa-dial-high","fas fa-dial-low","far fa-dial-low","fal fa-dial-low","fas fa-dial-max","far fa-dial-max","fal fa-dial-max","fas fa-dial-med","far fa-dial-med","fal fa-dial-med","fas fa-dial-med-low","far fa-dial-med-low","fal fa-dial-med-low","fas fa-dial-min","far fa-dial-min","fal fa-dial-min","fas fa-dial-off","far fa-dial-off","fal fa-dial-off","fas fa-disc-drive","far fa-disc-drive","fal fa-disc-drive","fas fa-drone","far fa-drone","fal fa-drone","fas fa-drone-front","far fa-drone-front","fal fa-drone-front","fas fa-face-viewfinder","far fa-face-viewfinder","fal fa-face-viewfinder","fas fa-file-audio","far fa-file-audio","fal fa-file-audio","fas fa-file-mov","far fa-file-mov","fal fa-file-mov","fas fa-file-mp4","far fa-file-mp4","fal fa-file-mp4","fas fa-file-video","far fa-file-video","fal fa-file-video","fas fa-film","far fa-film","fal fa-film","fas fa-film-canister","far fa-film-canister","fal fa-film-canister","fas fa-film-simple","far fa-film-simple","fal fa-film-simple","fas fa-film-slash","far fa-film-slash","fal fa-film-slash","fas fa-frame","far fa-frame","fal fa-frame","fas fa-gif","far fa-gif","fal fa-gif","fas fa-head-side-headphones","far fa-head-side-headphones","fal fa-head-side-headphones","fas fa-headphones","far fa-headphones","fal fa-headphones","fas fa-high-definition","far fa-high-definition","fal fa-high-definition","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-lines","far fa-microphone-lines","fal fa-microphone-lines","fas fa-microphone-lines-slash","far fa-microphone-lines-slash","fal fa-microphone-lines-slash","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-microphone-stand","far fa-microphone-stand","fal fa-microphone-stand","fas fa-photo-film","far fa-photo-film","fal fa-photo-film","fas fa-photo-film-music","far fa-photo-film-music","fal fa-photo-film-music","fas fa-podcast","far fa-podcast","fal fa-podcast","fas fa-projector","far fa-projector","fal fa-projector","fas fa-screencast","far fa-screencast","fal fa-screencast","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-signal-stream-slash","far fa-signal-stream-slash","fal fa-signal-stream-slash","fas fa-speaker","far fa-speaker","fal fa-speaker","fas fa-speakers","far fa-speakers","fal fa-speakers","fas fa-square-rss","far fa-square-rss","fal fa-square-rss","fas fa-standard-definition","far fa-standard-definition","fal fa-standard-definition","fas fa-star-sharp","far fa-star-sharp","fal fa-star-sharp","fas fa-star-sharp-half","far fa-star-sharp-half","fal fa-star-sharp-half","fas fa-star-sharp-half-stroke","far fa-star-sharp-half-stroke","fal fa-star-sharp-half-stroke","fas fa-subtitles","far fa-subtitles","fal fa-subtitles","fas fa-subtitles-slash","far fa-subtitles-slash","fal fa-subtitles-slash","fas fa-ticket","far fa-ticket","fal fa-ticket","fas fa-tickets","far fa-tickets","fal fa-tickets","fas fa-tickets-simple","far fa-tickets-simple","fal fa-tickets-simple","fas fa-tower-broadcast","far fa-tower-broadcast","fal fa-tower-broadcast","fas fa-tower-cell","far fa-tower-cell","fal fa-tower-cell","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-retro","far fa-tv-retro","fal fa-tv-retro","fas fa-video","far fa-video","fal fa-video","fas fa-video-arrow-down-left","far fa-video-arrow-down-left","fal fa-video-arrow-down-left","fas fa-video-arrow-up-right","far fa-video-arrow-up-right","fal fa-video-arrow-up-right","fas fa-video-plus","far fa-video-plus","fal fa-video-plus","fas fa-video-slash","far fa-video-slash","fal fa-video-slash","fas fa-waveform","far fa-waveform","fal fa-waveform","fas fa-waveform-lines","far fa-waveform-lines","fal fa-waveform-lines","fab fa-youtube"]},{"id":"hands","title":"Hands","icons":["fas fa-hand","far fa-hand","fal fa-hand","fas fa-hand-back-fist","far fa-hand-back-fist","fal fa-hand-back-fist","fas fa-hand-back-point-down","far fa-hand-back-point-down","fal fa-hand-back-point-down","fas fa-hand-back-point-left","far fa-hand-back-point-left","fal fa-hand-back-point-left","fas fa-hand-back-point-ribbon","far fa-hand-back-point-ribbon","fal fa-hand-back-point-ribbon","fas fa-hand-back-point-right","far fa-hand-back-point-right","fal fa-hand-back-point-right","fas fa-hand-back-point-up","far fa-hand-back-point-up","fal fa-hand-back-point-up","fas fa-hand-dots","far fa-hand-dots","fal fa-hand-dots","fas fa-hand-fingers-crossed","far fa-hand-fingers-crossed","fal fa-hand-fingers-crossed","fas fa-hand-fist","far fa-hand-fist","fal fa-hand-fist","fas fa-hand-heart","far fa-hand-heart","fal fa-hand-heart","fas fa-hand-holding","far fa-hand-holding","fal fa-hand-holding","fas fa-hand-holding-box","far fa-hand-holding-box","fal fa-hand-holding-box","fas fa-hand-holding-circle-dollar","far fa-hand-holding-circle-dollar","fal fa-hand-holding-circle-dollar","fas fa-hand-holding-dollar","far fa-hand-holding-dollar","fal fa-hand-holding-dollar","fas fa-hand-holding-droplet","far fa-hand-holding-droplet","fal fa-hand-holding-droplet","fas fa-hand-holding-hand","far fa-hand-holding-hand","fal fa-hand-holding-hand","fas fa-hand-holding-heart","far fa-hand-holding-heart","fal fa-hand-holding-heart","fas fa-hand-holding-magic","far fa-hand-holding-magic","fal fa-hand-holding-magic","fas fa-hand-holding-medical","far fa-hand-holding-medical","fal fa-hand-holding-medical","fas fa-hand-holding-seedling","far fa-hand-holding-seedling","fal fa-hand-holding-seedling","fas fa-hand-holding-skull","far fa-hand-holding-skull","fal fa-hand-holding-skull","fas fa-hand-horns","far fa-hand-horns","fal fa-hand-horns","fas fa-hand-lizard","far fa-hand-lizard","fal fa-hand-lizard","fas fa-hand-love","far fa-hand-love","fal fa-hand-love","fas fa-hand-middle-finger","far fa-hand-middle-finger","fal fa-hand-middle-finger","fas fa-hand-peace","far fa-hand-peace","fal fa-hand-peace","fas fa-hand-point-down","far fa-hand-point-down","fal fa-hand-point-down","fas fa-hand-point-left","far fa-hand-point-left","fal fa-hand-point-left","fas fa-hand-point-ribbon","far fa-hand-point-ribbon","fal fa-hand-point-ribbon","fas fa-hand-point-right","far fa-hand-point-right","fal fa-hand-point-right","fas fa-hand-point-up","far fa-hand-point-up","fal fa-hand-point-up","fas fa-hand-pointer","far fa-hand-pointer","fal fa-hand-pointer","fas fa-hand-scissors","far fa-hand-scissors","fal fa-hand-scissors","fas fa-hand-sparkles","far fa-hand-sparkles","fal fa-hand-sparkles","fas fa-hand-spock","far fa-hand-spock","fal fa-hand-spock","fas fa-hand-wave","far fa-hand-wave","fal fa-hand-wave","fas fa-hands-bound","far fa-hands-bound","fal fa-hands-bound","fas fa-hands-bubbles","far fa-hands-bubbles","fal fa-hands-bubbles","fas fa-hands-clapping","far fa-hands-clapping","fal fa-hands-clapping","fas fa-hands-holding","far fa-hands-holding","fal fa-hands-holding","fas fa-hands-holding-child","far fa-hands-holding-child","fal fa-hands-holding-child","fas fa-hands-holding-circle","far fa-hands-holding-circle","fal fa-hands-holding-circle","fas fa-hands-holding-diamond","far fa-hands-holding-diamond","fal fa-hands-holding-diamond","fas fa-hands-holding-dollar","far fa-hands-holding-dollar","fal fa-hands-holding-dollar","fas fa-hands-holding-heart","far fa-hands-holding-heart","fal fa-hands-holding-heart","fas fa-hands-praying","far fa-hands-praying","fal fa-hands-praying","fas fa-handshake","far fa-handshake","fal fa-handshake","fas fa-handshake-angle","far fa-handshake-angle","fal fa-handshake-angle","fas fa-handshake-simple","far fa-handshake-simple","fal fa-handshake-simple","fas fa-handshake-simple-slash","far fa-handshake-simple-slash","fal fa-handshake-simple-slash","fas fa-handshake-slash","far fa-handshake-slash","fal fa-handshake-slash","fas fa-thumbs-down","far fa-thumbs-down","fal fa-thumbs-down","fas fa-thumbs-up","far fa-thumbs-up","fal fa-thumbs-up"]},{"id":"communication","title":"Communication","icons":["fas fa-address-book","far fa-address-book","fal fa-address-book","fas fa-address-card","far fa-address-card","fal fa-address-card","fas fa-at","far fa-at","fal fa-at","fas fa-blender-phone","far fa-blender-phone","fal fa-blender-phone","fab fa-bluetooth-b","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-circle-envelope","far fa-circle-envelope","fal fa-circle-envelope","fas fa-circle-phone","far fa-circle-phone","fal fa-circle-phone","fas fa-circle-phone-flip","far fa-circle-phone-flip","fal fa-circle-phone-flip","fas fa-circle-phone-hangup","far fa-circle-phone-hangup","fal fa-circle-phone-hangup","fas fa-circle-wifi","far fa-circle-wifi","fal fa-circle-wifi","fas fa-circle-wifi-circle-wifi","far fa-circle-wifi-circle-wifi","fal fa-circle-wifi-circle-wifi","fas fa-comment","far fa-comment","fal fa-comment","fas fa-comment-arrow-down","far fa-comment-arrow-down","fal fa-comment-arrow-down","fas fa-comment-arrow-up","far fa-comment-arrow-up","fal fa-comment-arrow-up","fas fa-comment-arrow-up-right","far fa-comment-arrow-up-right","fal fa-comment-arrow-up-right","fas fa-comment-captions","far fa-comment-captions","fal fa-comment-captions","fas fa-comment-check","far fa-comment-check","fal fa-comment-check","fas fa-comment-code","far fa-comment-code","fal fa-comment-code","fas fa-comment-dots","far fa-comment-dots","fal fa-comment-dots","fas fa-comment-exclamation","far fa-comment-exclamation","fal fa-comment-exclamation","fas fa-comment-heart","far fa-comment-heart","fal fa-comment-heart","fas fa-comment-image","far fa-comment-image","fal fa-comment-image","fas fa-comment-lines","far fa-comment-lines","fal fa-comment-lines","fas fa-comment-medical","far fa-comment-medical","fal fa-comment-medical","fas fa-comment-middle","far fa-comment-middle","fal fa-comment-middle","fas fa-comment-middle-top","far fa-comment-middle-top","fal fa-comment-middle-top","fas fa-comment-minus","far fa-comment-minus","fal fa-comment-minus","fas fa-comment-music","far fa-comment-music","fal fa-comment-music","fas fa-comment-pen","far fa-comment-pen","fal fa-comment-pen","fas fa-comment-plus","far fa-comment-plus","fal fa-comment-plus","fas fa-comment-question","far fa-comment-question","fal fa-comment-question","fas fa-comment-quote","far fa-comment-quote","fal fa-comment-quote","fas fa-comment-slash","far fa-comment-slash","fal fa-comment-slash","fas fa-comment-smile","far fa-comment-smile","fal fa-comment-smile","fas fa-comment-sms","far fa-comment-sms","fal fa-comment-sms","fas fa-comment-text","far fa-comment-text","fal fa-comment-text","fas fa-comment-xmark","far fa-comment-xmark","fal fa-comment-xmark","fas fa-comments","far fa-comments","fal fa-comments","fas fa-comments-question","far fa-comments-question","fal fa-comments-question","fas fa-comments-question-check","far fa-comments-question-check","fal fa-comments-question-check","fas fa-crystal-ball","far fa-crystal-ball","fal fa-crystal-ball","fas fa-ear-listen","far fa-ear-listen","fal fa-ear-listen","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-circle-check","far fa-envelope-circle-check","fal fa-envelope-circle-check","fas fa-envelope-dot","far fa-envelope-dot","fal fa-envelope-dot","fas fa-envelope-open","far fa-envelope-open","fal fa-envelope-open","fas fa-envelopes","far fa-envelopes","fal fa-envelopes","fas fa-face-awesome","far fa-face-awesome","fal fa-face-awesome","fas fa-face-frown","far fa-face-frown","fal fa-face-frown","fas fa-face-meh","far fa-face-meh","fal fa-face-meh","fas fa-face-smile","far fa-face-smile","fal fa-face-smile","fas fa-face-smile-plus","far fa-face-smile-plus","fal fa-face-smile-plus","fas fa-fax","far fa-fax","fal fa-fax","fas fa-globe-wifi","far fa-globe-wifi","fal fa-globe-wifi","fas fa-hands-asl-interpreting","far fa-hands-asl-interpreting","fal fa-hands-asl-interpreting","fas fa-hundred-points","far fa-hundred-points","fal fa-hundred-points","fas fa-icons","far fa-icons","fal fa-icons","fas fa-inbox","far fa-inbox","fal fa-inbox","fas fa-inbox-in","far fa-inbox-in","fal fa-inbox-in","fas fa-inbox-out","far fa-inbox-out","fal fa-inbox-out","fas fa-language","far fa-language","fal fa-language","fas fa-lightbulb-message","far fa-lightbulb-message","fal fa-lightbulb-message","fas fa-mailbox","far fa-mailbox","fal fa-mailbox","fas fa-mailbox-flag-up","far fa-mailbox-flag-up","fal fa-mailbox-flag-up","fas fa-message","far fa-message","fal fa-message","fas fa-message-arrow-down","far fa-message-arrow-down","fal fa-message-arrow-down","fas fa-message-arrow-up","far fa-message-arrow-up","fal fa-message-arrow-up","fas fa-message-arrow-up-right","far fa-message-arrow-up-right","fal fa-message-arrow-up-right","fas fa-message-bot","far fa-message-bot","fal fa-message-bot","fas fa-message-check","far fa-message-check","fal fa-message-check","fas fa-message-code","far fa-message-code","fal fa-message-code","fas fa-message-dots","far fa-message-dots","fal fa-message-dots","fas fa-message-exclamation","far fa-message-exclamation","fal fa-message-exclamation","fas fa-message-heart","far fa-message-heart","fal fa-message-heart","fas fa-message-image","far fa-message-image","fal fa-message-image","fas fa-message-lines","far fa-message-lines","fal fa-message-lines","fas fa-message-medical","far fa-message-medical","fal fa-message-medical","fas fa-message-middle","far fa-message-middle","fal fa-message-middle","fas fa-message-middle-top","far fa-message-middle-top","fal fa-message-middle-top","fas fa-message-minus","far fa-message-minus","fal fa-message-minus","fas fa-message-pen","far fa-message-pen","fal fa-message-pen","fas fa-message-plus","far fa-message-plus","fal fa-message-plus","fas fa-message-question","far fa-message-question","fal fa-message-question","fas fa-message-quote","far fa-message-quote","fal fa-message-quote","fas fa-message-slash","far fa-message-slash","fal fa-message-slash","fas fa-message-smile","far fa-message-smile","fal fa-message-smile","fas fa-message-sms","far fa-message-sms","fal fa-message-sms","fas fa-message-text","far fa-message-text","fal fa-message-text","fas fa-message-xmark","far fa-message-xmark","fal fa-message-xmark","fas fa-messages","far fa-messages","fal fa-messages","fas fa-messages-question","far fa-messages-question","fal fa-messages-question","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-lines","far fa-microphone-lines","fal fa-microphone-lines","fas fa-microphone-lines-slash","far fa-microphone-lines-slash","fal fa-microphone-lines-slash","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-mobile","far fa-mobile","fal fa-mobile","fas fa-mobile-button","far fa-mobile-button","fal fa-mobile-button","fas fa-mobile-notch","far fa-mobile-notch","fal fa-mobile-notch","fas fa-mobile-retro","far fa-mobile-retro","fal fa-mobile-retro","fas fa-mobile-screen","far fa-mobile-screen","fal fa-mobile-screen","fas fa-mobile-screen-button","far fa-mobile-screen-button","fal fa-mobile-screen-button","fas fa-paper-plane","far fa-paper-plane","fal fa-paper-plane","fas fa-paper-plane-top","far fa-paper-plane-top","fal fa-paper-plane-top","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-arrow-down-left","far fa-phone-arrow-down-left","fal fa-phone-arrow-down-left","fas fa-phone-arrow-right","far fa-phone-arrow-right","fal fa-phone-arrow-right","fas fa-phone-arrow-up-right","far fa-phone-arrow-up-right","fal fa-phone-arrow-up-right","fas fa-phone-flip","far fa-phone-flip","fal fa-phone-flip","fas fa-phone-hangup","far fa-phone-hangup","fal fa-phone-hangup","fas fa-phone-intercom","far fa-phone-intercom","fal fa-phone-intercom","fas fa-phone-missed","far fa-phone-missed","fal fa-phone-missed","fas fa-phone-plus","far fa-phone-plus","fal fa-phone-plus","fas fa-phone-slash","far fa-phone-slash","fal fa-phone-slash","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-phone-xmark","far fa-phone-xmark","fal fa-phone-xmark","fas fa-poo","far fa-poo","fal fa-poo","fas fa-quote-left","far fa-quote-left","fal fa-quote-left","fas fa-quote-right","far fa-quote-right","fal fa-quote-right","fas fa-right-left-large","far fa-right-left-large","fal fa-right-left-large","fas fa-square-envelope","far fa-square-envelope","fal fa-square-envelope","fas fa-square-phone","far fa-square-phone","fal fa-square-phone","fas fa-square-phone-flip","far fa-square-phone-flip","fal fa-square-phone-flip","fas fa-square-phone-hangup","far fa-square-phone-hangup","fal fa-square-phone-hangup","fas fa-square-quote","far fa-square-quote","fal fa-square-quote","fas fa-square-rss","far fa-square-rss","fal fa-square-rss","fas fa-subtitles","far fa-subtitles","fal fa-subtitles","fas fa-subtitles-slash","far fa-subtitles-slash","fal fa-subtitles-slash","fas fa-symbols","far fa-symbols","fal fa-symbols","fas fa-thought-bubble","far fa-thought-bubble","fal fa-thought-bubble","fas fa-tower-cell","far fa-tower-cell","fal fa-tower-cell","fas fa-tty","far fa-tty","fal fa-tty","fas fa-tty-answer","far fa-tty-answer","fal fa-tty-answer","fas fa-video","far fa-video","fal fa-video","fas fa-video-plus","far fa-video-plus","fal fa-video-plus","fas fa-video-slash","far fa-video-slash","fal fa-video-slash","fas fa-voicemail","far fa-voicemail","fal fa-voicemail","fas fa-walkie-talkie","far fa-walkie-talkie","fal fa-walkie-talkie"]},{"id":"buildings","title":"Buildings","icons":["fas fa-apartment","far fa-apartment","fal fa-apartment","fas fa-archway","far fa-archway","fal fa-archway","fas fa-arrow-right-to-city","far fa-arrow-right-to-city","fal fa-arrow-right-to-city","fas fa-bridge-suspension","far fa-bridge-suspension","fal fa-bridge-suspension","fas fa-building","far fa-building","fal fa-building","fas fa-building-circle-arrow-right","far fa-building-circle-arrow-right","fal fa-building-circle-arrow-right","fas fa-building-circle-check","far fa-building-circle-check","fal fa-building-circle-check","fas fa-building-circle-exclamation","far fa-building-circle-exclamation","fal fa-building-circle-exclamation","fas fa-building-circle-xmark","far fa-building-circle-xmark","fal fa-building-circle-xmark","fas fa-building-columns","far fa-building-columns","fal fa-building-columns","fas fa-building-flag","far fa-building-flag","fal fa-building-flag","fas fa-building-lock","far fa-building-lock","fal fa-building-lock","fas fa-building-magnifying-glass","far fa-building-magnifying-glass","fal fa-building-magnifying-glass","fas fa-building-memo","far fa-building-memo","fal fa-building-memo","fas fa-building-ngo","far fa-building-ngo","fal fa-building-ngo","fas fa-building-shield","far fa-building-shield","fal fa-building-shield","fas fa-building-un","far fa-building-un","fal fa-building-un","fas fa-building-user","far fa-building-user","fal fa-building-user","fas fa-building-wheat","far fa-building-wheat","fal fa-building-wheat","fas fa-buildings","far fa-buildings","fal fa-buildings","fas fa-cabin","far fa-cabin","fal fa-cabin","fas fa-campground","far fa-campground","fal fa-campground","fas fa-car-building","far fa-car-building","fal fa-car-building","fas fa-castle","far fa-castle","fal fa-castle","fas fa-chimney","far fa-chimney","fal fa-chimney","fas fa-church","far fa-church","fal fa-church","fas fa-city","far fa-city","fal fa-city","fas fa-container-storage","far fa-container-storage","fal fa-container-storage","fas fa-dungeon","far fa-dungeon","fal fa-dungeon","fas fa-farm","far fa-farm","fal fa-farm","fas fa-fence","far fa-fence","fal fa-fence","fas fa-ferris-wheel","far fa-ferris-wheel","fal fa-ferris-wheel","fas fa-fort","far fa-fort","fal fa-fort","fas fa-garage","far fa-garage","fal fa-garage","fas fa-garage-car","far fa-garage-car","fal fa-garage-car","fas fa-garage-open","far fa-garage-open","fal fa-garage-open","fas fa-gopuram","far fa-gopuram","fal fa-gopuram","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-hospital-user","far fa-hospital-user","fal fa-hospital-user","fas fa-hospitals","far fa-hospitals","fal fa-hospitals","fas fa-hotel","far fa-hotel","fal fa-hotel","fas fa-house","far fa-house","fal fa-house","fas fa-house-blank","far fa-house-blank","fal fa-house-blank","fas fa-house-building","far fa-house-building","fal fa-house-building","fas fa-house-chimney","far fa-house-chimney","fal fa-house-chimney","fas fa-house-chimney-blank","far fa-house-chimney-blank","fal fa-house-chimney-blank","fas fa-house-chimney-crack","far fa-house-chimney-crack","fal fa-house-chimney-crack","fas fa-house-chimney-medical","far fa-house-chimney-medical","fal fa-house-chimney-medical","fas fa-house-chimney-window","far fa-house-chimney-window","fal fa-house-chimney-window","fas fa-house-circle-check","far fa-house-circle-check","fal fa-house-circle-check","fas fa-house-circle-exclamation","far fa-house-circle-exclamation","fal fa-house-circle-exclamation","fas fa-house-circle-xmark","far fa-house-circle-xmark","fal fa-house-circle-xmark","fas fa-house-crack","far fa-house-crack","fal fa-house-crack","fas fa-house-day","far fa-house-day","fal fa-house-day","fas fa-house-fire","far fa-house-fire","fal fa-house-fire","fas fa-house-flag","far fa-house-flag","fal fa-house-flag","fas fa-house-lock","far fa-house-lock","fal fa-house-lock","fas fa-house-medical","far fa-house-medical","fal fa-house-medical","fas fa-house-medical-circle-check","far fa-house-medical-circle-check","fal fa-house-medical-circle-check","fas fa-house-medical-circle-exclamation","far fa-house-medical-circle-exclamation","fal fa-house-medical-circle-exclamation","fas fa-house-medical-circle-xmark","far fa-house-medical-circle-xmark","fal fa-house-medical-circle-xmark","fas fa-house-medical-flag","far fa-house-medical-flag","fal fa-house-medical-flag","fas fa-house-night","far fa-house-night","fal fa-house-night","fas fa-house-tree","far fa-house-tree","fal fa-house-tree","fas fa-house-turret","far fa-house-turret","fal fa-house-turret","fas fa-house-water","far fa-house-water","fal fa-house-water","fas fa-house-window","far fa-house-window","fal fa-house-window","fas fa-igloo","far fa-igloo","fal fa-igloo","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-windows","far fa-industry-windows","fal fa-industry-windows","fas fa-kaaba","far fa-kaaba","fal fa-kaaba","fas fa-landmark","far fa-landmark","fal fa-landmark","fas fa-landmark-dome","far fa-landmark-dome","fal fa-landmark-dome","fas fa-landmark-flag","far fa-landmark-flag","fal fa-landmark-flag","fas fa-landmark-magnifying-glass","far fa-landmark-magnifying-glass","fal fa-landmark-magnifying-glass","fas fa-lighthouse","far fa-lighthouse","fal fa-lighthouse","fas fa-monument","far fa-monument","fal fa-monument","fas fa-mosque","far fa-mosque","fal fa-mosque","fas fa-mountain-city","far fa-mountain-city","fal fa-mountain-city","fas fa-oil-well","far fa-oil-well","fal fa-oil-well","fas fa-place-of-worship","far fa-place-of-worship","fal fa-place-of-worship","fas fa-roller-coaster","far fa-roller-coaster","fal fa-roller-coaster","fas fa-school","far fa-school","fal fa-school","fas fa-school-circle-check","far fa-school-circle-check","fal fa-school-circle-check","fas fa-school-circle-exclamation","far fa-school-circle-exclamation","fal fa-school-circle-exclamation","fas fa-school-circle-xmark","far fa-school-circle-xmark","fal fa-school-circle-xmark","fas fa-school-flag","far fa-school-flag","fal fa-school-flag","fas fa-school-lock","far fa-school-lock","fal fa-school-lock","fas fa-shop","far fa-shop","fal fa-shop","fas fa-shop-lock","far fa-shop-lock","fal fa-shop-lock","fas fa-store","far fa-store","fal fa-store","fas fa-store-lock","far fa-store-lock","fal fa-store-lock","fas fa-synagogue","far fa-synagogue","fal fa-synagogue","fas fa-tent","far fa-tent","fal fa-tent","fas fa-tent-arrow-down-to-line","far fa-tent-arrow-down-to-line","fal fa-tent-arrow-down-to-line","fas fa-tent-arrow-left-right","far fa-tent-arrow-left-right","fal fa-tent-arrow-left-right","fas fa-tent-arrow-turn-left","far fa-tent-arrow-turn-left","fal fa-tent-arrow-turn-left","fas fa-tent-arrows-down","far fa-tent-arrows-down","fal fa-tent-arrows-down","fas fa-tent-double-peak","far fa-tent-double-peak","fal fa-tent-double-peak","fas fa-tents","far fa-tents","fal fa-tents","fas fa-toilet-portable","far fa-toilet-portable","fal fa-toilet-portable","fas fa-toilets-portable","far fa-toilets-portable","fal fa-toilets-portable","fas fa-torii-gate","far fa-torii-gate","fal fa-torii-gate","fas fa-tower-observation","far fa-tower-observation","fal fa-tower-observation","fas fa-tree-city","far fa-tree-city","fal fa-tree-city","fas fa-vihara","far fa-vihara","fal fa-vihara","fas fa-warehouse","far fa-warehouse","fal fa-warehouse","fas fa-warehouse-full","far fa-warehouse-full","fal fa-warehouse-full"]},{"id":"transportation","title":"Transportation","icons":["fab fa-accessible-icon","fas fa-baby-carriage","far fa-baby-carriage","fal fa-baby-carriage","fas fa-bicycle","far fa-bicycle","fal fa-bicycle","fas fa-bridge-suspension","far fa-bridge-suspension","fal fa-bridge-suspension","fas fa-bulldozer","far fa-bulldozer","fal fa-bulldozer","fas fa-bus","far fa-bus","fal fa-bus","fas fa-bus-simple","far fa-bus-simple","fal fa-bus-simple","fas fa-cable-car","far fa-cable-car","fal fa-cable-car","fas fa-car","far fa-car","fal fa-car","fas fa-car-bolt","far fa-car-bolt","fal fa-car-bolt","fas fa-car-building","far fa-car-building","fal fa-car-building","fas fa-car-bump","far fa-car-bump","fal fa-car-bump","fas fa-car-burst","far fa-car-burst","fal fa-car-burst","fas fa-car-bus","far fa-car-bus","fal fa-car-bus","fas fa-car-circle-bolt","far fa-car-circle-bolt","fal fa-car-circle-bolt","fas fa-car-rear","far fa-car-rear","fal fa-car-rear","fas fa-car-side","far fa-car-side","fal fa-car-side","fas fa-car-side-bolt","far fa-car-side-bolt","fal fa-car-side-bolt","fas fa-car-tilt","far fa-car-tilt","fal fa-car-tilt","fas fa-car-tunnel","far fa-car-tunnel","fal fa-car-tunnel","fas fa-cars","far fa-cars","fal fa-cars","fas fa-cart-shopping","far fa-cart-shopping","fal fa-cart-shopping","fas fa-drone","far fa-drone","fal fa-drone","fas fa-drone-front","far fa-drone-front","fal fa-drone-front","fas fa-excavator","far fa-excavator","fal fa-excavator","fas fa-ferry","far fa-ferry","fal fa-ferry","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-helicopter","far fa-helicopter","fal fa-helicopter","fas fa-horse","far fa-horse","fal fa-horse","fas fa-horse-saddle","far fa-horse-saddle","fal fa-horse-saddle","fas fa-jet-fighter","far fa-jet-fighter","fal fa-jet-fighter","fas fa-jet-fighter-up","far fa-jet-fighter-up","fal fa-jet-fighter-up","fas fa-moped","far fa-moped","fal fa-moped","fas fa-motorcycle","far fa-motorcycle","fal fa-motorcycle","fas fa-mound","far fa-mound","fal fa-mound","fas fa-paper-plane","far fa-paper-plane","fal fa-paper-plane","fas fa-pegasus","far fa-pegasus","fal fa-pegasus","fas fa-person-ski-lift","far fa-person-ski-lift","fal fa-person-ski-lift","fas fa-person-snowmobiling","far fa-person-snowmobiling","fal fa-person-snowmobiling","fas fa-plane","far fa-plane","fal fa-plane","fas fa-plane-engines","far fa-plane-engines","fal fa-plane-engines","fas fa-plane-prop","far fa-plane-prop","fal fa-plane-prop","fas fa-plane-slash","far fa-plane-slash","fal fa-plane-slash","fas fa-plane-tail","far fa-plane-tail","fal fa-plane-tail","fas fa-plane-up","far fa-plane-up","fal fa-plane-up","fas fa-road","far fa-road","fal fa-road","fas fa-road-barrier","far fa-road-barrier","fal fa-road-barrier","fas fa-road-spikes","far fa-road-spikes","fal fa-road-spikes","fas fa-robot-astromech","far fa-robot-astromech","fal fa-robot-astromech","fas fa-rocket","far fa-rocket","fal fa-rocket","fas fa-rocket-launch","far fa-rocket-launch","fal fa-rocket-launch","fas fa-rv","far fa-rv","fal fa-rv","fas fa-sailboat","far fa-sailboat","fal fa-sailboat","fas fa-seat-airline","far fa-seat-airline","fal fa-seat-airline","fas fa-ship","far fa-ship","fal fa-ship","fas fa-shuttle-space","far fa-shuttle-space","fal fa-shuttle-space","fas fa-sleigh","far fa-sleigh","fal fa-sleigh","fas fa-snowplow","far fa-snowplow","fal fa-snowplow","fas fa-starfighter","far fa-starfighter","fal fa-starfighter","fas fa-starfighter-twin-ion-engine","far fa-starfighter-twin-ion-engine","fal fa-starfighter-twin-ion-engine","fas fa-starfighter-twin-ion-engine-advanced","far fa-starfighter-twin-ion-engine-advanced","fal fa-starfighter-twin-ion-engine-advanced","fas fa-starship","far fa-starship","fal fa-starship","fas fa-starship-freighter","far fa-starship-freighter","fal fa-starship-freighter","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-taxi-bus","far fa-taxi-bus","fal fa-taxi-bus","fas fa-tower-control","far fa-tower-control","fal fa-tower-control","fas fa-tractor","far fa-tractor","fal fa-tractor","fas fa-train","far fa-train","fal fa-train","fas fa-train-subway","far fa-train-subway","fal fa-train-subway","fas fa-train-subway-tunnel","far fa-train-subway-tunnel","fal fa-train-subway-tunnel","fas fa-train-track","far fa-train-track","fal fa-train-track","fas fa-train-tram","far fa-train-tram","fal fa-train-tram","fas fa-train-tunnel","far fa-train-tunnel","fal fa-train-tunnel","fas fa-tricycle","far fa-tricycle","fal fa-tricycle","fas fa-tricycle-adult","far fa-tricycle-adult","fal fa-tricycle-adult","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-arrow-right","far fa-truck-arrow-right","fal fa-truck-arrow-right","fas fa-truck-bolt","far fa-truck-bolt","fal fa-truck-bolt","fas fa-truck-container-empty","far fa-truck-container-empty","fal fa-truck-container-empty","fas fa-truck-droplet","far fa-truck-droplet","fal fa-truck-droplet","fas fa-truck-field","far fa-truck-field","fal fa-truck-field","fas fa-truck-field-un","far fa-truck-field-un","fal fa-truck-field-un","fas fa-truck-fire","far fa-truck-fire","fal fa-truck-fire","fas fa-truck-flatbed","far fa-truck-flatbed","fal fa-truck-flatbed","fas fa-truck-front","far fa-truck-front","fal fa-truck-front","fas fa-truck-ladder","far fa-truck-ladder","fal fa-truck-ladder","fas fa-truck-medical","far fa-truck-medical","fal fa-truck-medical","fas fa-truck-monster","far fa-truck-monster","fal fa-truck-monster","fas fa-truck-pickup","far fa-truck-pickup","fal fa-truck-pickup","fas fa-truck-plane","far fa-truck-plane","fal fa-truck-plane","fas fa-truck-plow","far fa-truck-plow","fal fa-truck-plow","fas fa-truck-tow","far fa-truck-tow","fal fa-truck-tow","fas fa-truck-utensils","far fa-truck-utensils","fal fa-truck-utensils","fas fa-ufo","far fa-ufo","fal fa-ufo","fas fa-ufo-beam","far fa-ufo-beam","fal fa-ufo-beam","fas fa-van-shuttle","far fa-van-shuttle","fal fa-van-shuttle","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wheelchair-move","far fa-wheelchair-move","fal fa-wheelchair-move"]},{"id":"punctuation-symbols","title":"Punctuation + Symbols","icons":["fas fa-accent-grave","far fa-accent-grave","fal fa-accent-grave","fas fa-alt","far fa-alt","fal fa-alt","fas fa-ampersand","far fa-ampersand","fal fa-ampersand","fas fa-apostrophe","far fa-apostrophe","fal fa-apostrophe","fas fa-asterisk","far fa-asterisk","fal fa-asterisk","fas fa-at","far fa-at","fal fa-at","fas fa-bracket-curly","far fa-bracket-curly","fal fa-bracket-curly","fas fa-bracket-curly-right","far fa-bracket-curly-right","fal fa-bracket-curly-right","fas fa-bracket-round","far fa-bracket-round","fal fa-bracket-round","fas fa-bracket-round-right","far fa-bracket-round-right","fal fa-bracket-round-right","fas fa-bracket-square","far fa-bracket-square","fal fa-bracket-square","fas fa-bracket-square-right","far fa-bracket-square-right","fal fa-bracket-square-right","fas fa-brackets-round","far fa-brackets-round","fal fa-brackets-round","fas fa-check","far fa-check","fal fa-check","fas fa-check-double","far fa-check-double","fal fa-check-double","fas fa-circle-ampersand","far fa-circle-ampersand","fal fa-circle-ampersand","fas fa-circle-exclamation","far fa-circle-exclamation","fal fa-circle-exclamation","fas fa-circle-question","far fa-circle-question","fal fa-circle-question","fas fa-colon","far fa-colon","fal fa-colon","fas fa-comma","far fa-comma","fal fa-comma","fas fa-corner","far fa-corner","fal fa-corner","fas fa-dash","far fa-dash","fal fa-dash","fas fa-ditto","far fa-ditto","fal fa-ditto","fas fa-equals","far fa-equals","fal fa-equals","fas fa-exclamation","far fa-exclamation","fal fa-exclamation","fas fa-greater-than","far fa-greater-than","fal fa-greater-than","fas fa-hashtag","far fa-hashtag","fal fa-hashtag","fas fa-horizontal-rule","far fa-horizontal-rule","fal fa-horizontal-rule","fas fa-hyphen","far fa-hyphen","fal fa-hyphen","fas fa-interrobang","far fa-interrobang","fal fa-interrobang","fas fa-less-than","far fa-less-than","fal fa-less-than","fas fa-minus","far fa-minus","fal fa-minus","fas fa-option","far fa-option","fal fa-option","fas fa-percent","far fa-percent","fal fa-percent","fas fa-period","far fa-period","fal fa-period","fas fa-pipe","far fa-pipe","fal fa-pipe","fas fa-plus","far fa-plus","fal fa-plus","fas fa-question","far fa-question","fal fa-question","fas fa-quote-left","far fa-quote-left","fal fa-quote-left","fas fa-quote-right","far fa-quote-right","fal fa-quote-right","fas fa-quotes","far fa-quotes","fal fa-quotes","fas fa-section","far fa-section","fal fa-section","fas fa-semicolon","far fa-semicolon","fal fa-semicolon","fas fa-slash-back","far fa-slash-back","fal fa-slash-back","fas fa-slash-forward","far fa-slash-forward","fal fa-slash-forward","fas fa-square-ampersand","far fa-square-ampersand","fal fa-square-ampersand","fas fa-square-question","far fa-square-question","fal fa-square-question","fas fa-square-quote","far fa-square-quote","fal fa-square-quote","fas fa-tick","far fa-tick","fal fa-tick","fas fa-tilde","far fa-tilde","fal fa-tilde"]},{"id":"alphabet","title":"Alphabet","icons":["fas fa-a","far fa-a","fal fa-a","fas fa-address-card","far fa-address-card","fal fa-address-card","fas fa-b","far fa-b","fal fa-b","fas fa-c","far fa-c","fal fa-c","fas fa-circle-a","far fa-circle-a","fal fa-circle-a","fas fa-circle-b","far fa-circle-b","fal fa-circle-b","fas fa-circle-c","far fa-circle-c","fal fa-circle-c","fas fa-circle-d","far fa-circle-d","fal fa-circle-d","fas fa-circle-e","far fa-circle-e","fal fa-circle-e","fas fa-circle-f","far fa-circle-f","fal fa-circle-f","fas fa-circle-g","far fa-circle-g","fal fa-circle-g","fas fa-circle-h","far fa-circle-h","fal fa-circle-h","fas fa-circle-i","far fa-circle-i","fal fa-circle-i","fas fa-circle-j","far fa-circle-j","fal fa-circle-j","fas fa-circle-k","far fa-circle-k","fal fa-circle-k","fas fa-circle-l","far fa-circle-l","fal fa-circle-l","fas fa-circle-m","far fa-circle-m","fal fa-circle-m","fas fa-circle-n","far fa-circle-n","fal fa-circle-n","fas fa-circle-o","far fa-circle-o","fal fa-circle-o","fas fa-circle-p","far fa-circle-p","fal fa-circle-p","fas fa-circle-q","far fa-circle-q","fal fa-circle-q","fas fa-circle-r","far fa-circle-r","fal fa-circle-r","fas fa-circle-s","far fa-circle-s","fal fa-circle-s","fas fa-circle-t","far fa-circle-t","fal fa-circle-t","fas fa-circle-u","far fa-circle-u","fal fa-circle-u","fas fa-circle-v","far fa-circle-v","fal fa-circle-v","fas fa-circle-w","far fa-circle-w","fal fa-circle-w","fas fa-circle-x","far fa-circle-x","fal fa-circle-x","fas fa-circle-y","far fa-circle-y","fal fa-circle-y","fas fa-circle-z","far fa-circle-z","fal fa-circle-z","fas fa-d","far fa-d","fal fa-d","fas fa-e","far fa-e","fal fa-e","fas fa-f","far fa-f","fal fa-f","fas fa-g","far fa-g","fal fa-g","fas fa-h","far fa-h","fal fa-h","fas fa-i","far fa-i","fal fa-i","fas fa-j","far fa-j","fal fa-j","fas fa-k","far fa-k","fal fa-k","fas fa-l","far fa-l","fal fa-l","fas fa-m","far fa-m","fal fa-m","fas fa-n","far fa-n","fal fa-n","fas fa-o","far fa-o","fal fa-o","fas fa-p","far fa-p","fal fa-p","fas fa-q","far fa-q","fal fa-q","fas fa-r","far fa-r","fal fa-r","fas fa-s","far fa-s","fal fa-s","fas fa-square-a","far fa-square-a","fal fa-square-a","fas fa-square-b","far fa-square-b","fal fa-square-b","fas fa-square-c","far fa-square-c","fal fa-square-c","fas fa-square-d","far fa-square-d","fal fa-square-d","fas fa-square-e","far fa-square-e","fal fa-square-e","fas fa-square-f","far fa-square-f","fal fa-square-f","fas fa-square-g","far fa-square-g","fal fa-square-g","fas fa-square-h","far fa-square-h","fal fa-square-h","fas fa-square-i","far fa-square-i","fal fa-square-i","fas fa-square-j","far fa-square-j","fal fa-square-j","fas fa-square-k","far fa-square-k","fal fa-square-k","fas fa-square-l","far fa-square-l","fal fa-square-l","fas fa-square-m","far fa-square-m","fal fa-square-m","fas fa-square-n","far fa-square-n","fal fa-square-n","fas fa-square-o","far fa-square-o","fal fa-square-o","fas fa-square-p","far fa-square-p","fal fa-square-p","fas fa-square-q","far fa-square-q","fal fa-square-q","fas fa-square-r","far fa-square-r","fal fa-square-r","fas fa-square-s","far fa-square-s","fal fa-square-s","fas fa-square-t","far fa-square-t","fal fa-square-t","fas fa-square-u","far fa-square-u","fal fa-square-u","fas fa-square-v","far fa-square-v","fal fa-square-v","fas fa-square-w","far fa-square-w","fal fa-square-w","fas fa-square-x","far fa-square-x","fal fa-square-x","fas fa-square-y","far fa-square-y","fal fa-square-y","fas fa-square-z","far fa-square-z","fal fa-square-z","fas fa-t","far fa-t","fal fa-t","fas fa-u","far fa-u","fal fa-u","fas fa-v","far fa-v","fal fa-v","fas fa-w","far fa-w","fal fa-w","fas fa-x","far fa-x","fal fa-x","fas fa-y","far fa-y","fal fa-y","fas fa-z","far fa-z","fal fa-z"]},{"id":"numbers","title":"Numbers","icons":["fas fa-0","far fa-0","fal fa-0","fas fa-00","far fa-00","fal fa-00","fas fa-1","far fa-1","fal fa-1","fas fa-2","far fa-2","fal fa-2","fas fa-3","far fa-3","fal fa-3","fas fa-4","far fa-4","fal fa-4","fas fa-5","far fa-5","fal fa-5","fas fa-6","far fa-6","fal fa-6","fas fa-7","far fa-7","fal fa-7","fas fa-8","far fa-8","fal fa-8","fas fa-9","far fa-9","fal fa-9","fas fa-circle-0","far fa-circle-0","fal fa-circle-0","fas fa-circle-1","far fa-circle-1","fal fa-circle-1","fas fa-circle-2","far fa-circle-2","fal fa-circle-2","fas fa-circle-3","far fa-circle-3","fal fa-circle-3","fas fa-circle-4","far fa-circle-4","fal fa-circle-4","fas fa-circle-5","far fa-circle-5","fal fa-circle-5","fas fa-circle-6","far fa-circle-6","fal fa-circle-6","fas fa-circle-7","far fa-circle-7","fal fa-circle-7","fas fa-circle-8","far fa-circle-8","fal fa-circle-8","fas fa-circle-9","far fa-circle-9","fal fa-circle-9","fas fa-hundred-points","far fa-hundred-points","fal fa-hundred-points","fas fa-square-0","far fa-square-0","fal fa-square-0","fas fa-square-1","far fa-square-1","fal fa-square-1","fas fa-square-2","far fa-square-2","fal fa-square-2","fas fa-square-3","far fa-square-3","fal fa-square-3","fas fa-square-4","far fa-square-4","fal fa-square-4","fas fa-square-5","far fa-square-5","fal fa-square-5","fas fa-square-6","far fa-square-6","fal fa-square-6","fas fa-square-7","far fa-square-7","fal fa-square-7","fas fa-square-8","far fa-square-8","fal fa-square-8","fas fa-square-9","far fa-square-9","fal fa-square-9"]},{"id":"time","title":"Time","icons":["fas fa-alarm-clock","far fa-alarm-clock","fal fa-alarm-clock","fas fa-alarm-exclamation","far fa-alarm-exclamation","fal fa-alarm-exclamation","fas fa-alarm-plus","far fa-alarm-plus","fal fa-alarm-plus","fas fa-alarm-snooze","far fa-alarm-snooze","fal fa-alarm-snooze","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-exclamation","far fa-bell-exclamation","fal fa-bell-exclamation","fas fa-bell-plus","far fa-bell-plus","fal fa-bell-plus","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-calendar-arrow-down","far fa-calendar-arrow-down","fal fa-calendar-arrow-down","fas fa-calendar-arrow-up","far fa-calendar-arrow-up","fal fa-calendar-arrow-up","fas fa-calendar-check","far fa-calendar-check","fal fa-calendar-check","fas fa-calendar-circle-exclamation","far fa-calendar-circle-exclamation","fal fa-calendar-circle-exclamation","fas fa-calendar-circle-minus","far fa-calendar-circle-minus","fal fa-calendar-circle-minus","fas fa-calendar-circle-plus","far fa-calendar-circle-plus","fal fa-calendar-circle-plus","fas fa-calendar-circle-user","far fa-calendar-circle-user","fal fa-calendar-circle-user","fas fa-calendar-clock","far fa-calendar-clock","fal fa-calendar-clock","fas fa-calendar-day","far fa-calendar-day","fal fa-calendar-day","fas fa-calendar-days","far fa-calendar-days","fal fa-calendar-days","fas fa-calendar-exclamation","far fa-calendar-exclamation","fal fa-calendar-exclamation","fas fa-calendar-heart","far fa-calendar-heart","fal fa-calendar-heart","fas fa-calendar-image","far fa-calendar-image","fal fa-calendar-image","fas fa-calendar-lines","far fa-calendar-lines","fal fa-calendar-lines","fas fa-calendar-lines-pen","far fa-calendar-lines-pen","fal fa-calendar-lines-pen","fas fa-calendar-minus","far fa-calendar-minus","fal fa-calendar-minus","fas fa-calendar-pen","far fa-calendar-pen","fal fa-calendar-pen","fas fa-calendar-plus","far fa-calendar-plus","fal fa-calendar-plus","fas fa-calendar-range","far fa-calendar-range","fal fa-calendar-range","fas fa-calendar-star","far fa-calendar-star","fal fa-calendar-star","fas fa-calendar-users","far fa-calendar-users","fal fa-calendar-users","fas fa-calendar-week","far fa-calendar-week","fal fa-calendar-week","fas fa-calendar-xmark","far fa-calendar-xmark","fal fa-calendar-xmark","fas fa-calendars","far fa-calendars","fal fa-calendars","fas fa-circle-calendar","far fa-circle-calendar","fal fa-circle-calendar","fas fa-clock","far fa-clock","fal fa-clock","fas fa-clock-desk","far fa-clock-desk","fal fa-clock-desk","fas fa-clock-eight","far fa-clock-eight","fal fa-clock-eight","fas fa-clock-eight-thirty","far fa-clock-eight-thirty","fal fa-clock-eight-thirty","fas fa-clock-eleven","far fa-clock-eleven","fal fa-clock-eleven","fas fa-clock-eleven-thirty","far fa-clock-eleven-thirty","fal fa-clock-eleven-thirty","fas fa-clock-five","far fa-clock-five","fal fa-clock-five","fas fa-clock-five-thirty","far fa-clock-five-thirty","fal fa-clock-five-thirty","fas fa-clock-four-thirty","far fa-clock-four-thirty","fal fa-clock-four-thirty","fas fa-clock-nine","far fa-clock-nine","fal fa-clock-nine","fas fa-clock-nine-thirty","far fa-clock-nine-thirty","fal fa-clock-nine-thirty","fas fa-clock-one","far fa-clock-one","fal fa-clock-one","fas fa-clock-one-thirty","far fa-clock-one-thirty","fal fa-clock-one-thirty","fas fa-clock-seven","far fa-clock-seven","fal fa-clock-seven","fas fa-clock-seven-thirty","far fa-clock-seven-thirty","fal fa-clock-seven-thirty","fas fa-clock-six","far fa-clock-six","fal fa-clock-six","fas fa-clock-six-thirty","far fa-clock-six-thirty","fal fa-clock-six-thirty","fas fa-clock-ten","far fa-clock-ten","fal fa-clock-ten","fas fa-clock-ten-thirty","far fa-clock-ten-thirty","fal fa-clock-ten-thirty","fas fa-clock-three","far fa-clock-three","fal fa-clock-three","fas fa-clock-three-thirty","far fa-clock-three-thirty","fal fa-clock-three-thirty","fas fa-clock-twelve","far fa-clock-twelve","fal fa-clock-twelve","fas fa-clock-twelve-thirty","far fa-clock-twelve-thirty","fal fa-clock-twelve-thirty","fas fa-clock-two","far fa-clock-two","fal fa-clock-two","fas fa-clock-two-thirty","far fa-clock-two-thirty","fal fa-clock-two-thirty","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-hourglass","far fa-hourglass","fal fa-hourglass","fas fa-hourglass-clock","far fa-hourglass-clock","fal fa-hourglass-clock","fas fa-hourglass-end","far fa-hourglass-end","fal fa-hourglass-end","fas fa-hourglass-half","far fa-hourglass-half","fal fa-hourglass-half","fas fa-hourglass-start","far fa-hourglass-start","fal fa-hourglass-start","fas fa-house-day","far fa-house-day","fal fa-house-day","fas fa-house-night","far fa-house-night","fal fa-house-night","fas fa-reply-clock","far fa-reply-clock","fal fa-reply-clock","fas fa-snooze","far fa-snooze","fal fa-snooze","fas fa-stopwatch","far fa-stopwatch","fal fa-stopwatch","fas fa-stopwatch-20","far fa-stopwatch-20","fal fa-stopwatch-20","fas fa-timer","far fa-timer","fal fa-timer","fas fa-trash-can-clock","far fa-trash-can-clock","fal fa-trash-can-clock","fas fa-trash-clock","far fa-trash-clock","fal fa-trash-clock","fas fa-watch","far fa-watch","fal fa-watch","fas fa-watch-apple","far fa-watch-apple","fal fa-watch-apple","fas fa-watch-calculator","far fa-watch-calculator","fal fa-watch-calculator","fas fa-watch-smart","far fa-watch-smart","fal fa-watch-smart"]},{"id":"construction","title":"Construction","icons":["fas fa-angle","far fa-angle","fal fa-angle","fas fa-angle-90","far fa-angle-90","fal fa-angle-90","fas fa-arrow-up-from-ground-water","far fa-arrow-up-from-ground-water","fal fa-arrow-up-from-ground-water","fas fa-axe","far fa-axe","fal fa-axe","fas fa-block","far fa-block","fal fa-block","fas fa-block-brick","far fa-block-brick","fal fa-block-brick","fas fa-bore-hole","far fa-bore-hole","fal fa-bore-hole","fas fa-brush","far fa-brush","fal fa-brush","fas fa-bucket","far fa-bucket","fal fa-bucket","fas fa-bulldozer","far fa-bulldozer","fal fa-bulldozer","fas fa-compass-drafting","far fa-compass-drafting","fal fa-compass-drafting","fas fa-dumpster","far fa-dumpster","fal fa-dumpster","fas fa-dumpster-fire","far fa-dumpster-fire","fal fa-dumpster-fire","fas fa-excavator","far fa-excavator","fal fa-excavator","fas fa-forklift","far fa-forklift","fal fa-forklift","fas fa-frame","far fa-frame","fal fa-frame","fas fa-grate","far fa-grate","fal fa-grate","fas fa-grate-droplet","far fa-grate-droplet","fal fa-grate-droplet","fas fa-hammer","far fa-hammer","fal fa-hammer","fas fa-hammer-brush","far fa-hammer-brush","fal fa-hammer-brush","fas fa-hammer-crash","far fa-hammer-crash","fal fa-hammer-crash","fas fa-helmet-safety","far fa-helmet-safety","fal fa-helmet-safety","fas fa-hose","far fa-hose","fal fa-hose","fas fa-hose-reel","far fa-hose-reel","fal fa-hose-reel","fas fa-mound","far fa-mound","fal fa-mound","fas fa-paint-roller","far fa-paint-roller","fal fa-paint-roller","fas fa-pen-ruler","far fa-pen-ruler","fal fa-pen-ruler","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-person-digging","far fa-person-digging","fal fa-person-digging","fas fa-reel","far fa-reel","fal fa-reel","fas fa-ruler","far fa-ruler","fal fa-ruler","fas fa-ruler-combined","far fa-ruler-combined","fal fa-ruler-combined","fas fa-ruler-horizontal","far fa-ruler-horizontal","fal fa-ruler-horizontal","fas fa-ruler-triangle","far fa-ruler-triangle","fal fa-ruler-triangle","fas fa-ruler-vertical","far fa-ruler-vertical","fal fa-ruler-vertical","fas fa-screwdriver","far fa-screwdriver","fal fa-screwdriver","fas fa-screwdriver-wrench","far fa-screwdriver-wrench","fal fa-screwdriver-wrench","fas fa-sheet-plastic","far fa-sheet-plastic","fal fa-sheet-plastic","fas fa-shovel","far fa-shovel","fal fa-shovel","fas fa-shovel-snow","far fa-shovel-snow","fal fa-shovel-snow","fas fa-sign-posts-wrench","far fa-sign-posts-wrench","fal fa-sign-posts-wrench","fas fa-tarp","far fa-tarp","fal fa-tarp","fas fa-tarp-droplet","far fa-tarp-droplet","fal fa-tarp-droplet","fas fa-toilet-portable","far fa-toilet-portable","fal fa-toilet-portable","fas fa-toilets-portable","far fa-toilets-portable","fal fa-toilets-portable","fas fa-toolbox","far fa-toolbox","fal fa-toolbox","fas fa-traffic-cone","far fa-traffic-cone","fal fa-traffic-cone","fas fa-triangle-person-digging","far fa-triangle-person-digging","fal fa-triangle-person-digging","fas fa-trowel","far fa-trowel","fal fa-trowel","fas fa-trowel-bricks","far fa-trowel-bricks","fal fa-trowel-bricks","fas fa-truck-container","far fa-truck-container","fal fa-truck-container","fas fa-truck-ladder","far fa-truck-ladder","fal fa-truck-ladder","fas fa-truck-pickup","far fa-truck-pickup","fal fa-truck-pickup","fas fa-user-helmet-safety","far fa-user-helmet-safety","fal fa-user-helmet-safety","fas fa-wrench","far fa-wrench","fal fa-wrench","fas fa-wrench-simple","far fa-wrench-simple","fal fa-wrench-simple"]},{"id":"arrows","title":"Arrows","icons":["fas fa-angle-down","far fa-angle-down","fal fa-angle-down","fas fa-angle-left","far fa-angle-left","fal fa-angle-left","fas fa-angle-right","far fa-angle-right","fal fa-angle-right","fas fa-angle-up","far fa-angle-up","fal fa-angle-up","fas fa-angles-down","far fa-angles-down","fal fa-angles-down","fas fa-angles-left","far fa-angles-left","fal fa-angles-left","fas fa-angles-right","far fa-angles-right","fal fa-angles-right","fas fa-angles-up","far fa-angles-up","fal fa-angles-up","fas fa-angles-up-down","far fa-angles-up-down","fal fa-angles-up-down","fas fa-arrow-down","far fa-arrow-down","fal fa-arrow-down","fas fa-arrow-down-1-9","far fa-arrow-down-1-9","fal fa-arrow-down-1-9","fas fa-arrow-down-9-1","far fa-arrow-down-9-1","fal fa-arrow-down-9-1","fas fa-arrow-down-a-z","far fa-arrow-down-a-z","fal fa-arrow-down-a-z","fas fa-arrow-down-arrow-up","far fa-arrow-down-arrow-up","fal fa-arrow-down-arrow-up","fas fa-arrow-down-big-small","far fa-arrow-down-big-small","fal fa-arrow-down-big-small","fas fa-arrow-down-from-arc","far fa-arrow-down-from-arc","fal fa-arrow-down-from-arc","fas fa-arrow-down-from-bracket","far fa-arrow-down-from-bracket","fal fa-arrow-down-from-bracket","fas fa-arrow-down-from-dotted-line","far fa-arrow-down-from-dotted-line","fal fa-arrow-down-from-dotted-line","fas fa-arrow-down-from-line","far fa-arrow-down-from-line","fal fa-arrow-down-from-line","fas fa-arrow-down-left","far fa-arrow-down-left","fal fa-arrow-down-left","fas fa-arrow-down-left-and-arrow-up-right-to-center","far fa-arrow-down-left-and-arrow-up-right-to-center","fal fa-arrow-down-left-and-arrow-up-right-to-center","fas fa-arrow-down-long","far fa-arrow-down-long","fal fa-arrow-down-long","fas fa-arrow-down-right","far fa-arrow-down-right","fal fa-arrow-down-right","fas fa-arrow-down-short-wide","far fa-arrow-down-short-wide","fal fa-arrow-down-short-wide","fas fa-arrow-down-small-big","far fa-arrow-down-small-big","fal fa-arrow-down-small-big","fas fa-arrow-down-square-triangle","far fa-arrow-down-square-triangle","fal fa-arrow-down-square-triangle","fas fa-arrow-down-to-arc","far fa-arrow-down-to-arc","fal fa-arrow-down-to-arc","fas fa-arrow-down-to-bracket","far fa-arrow-down-to-bracket","fal fa-arrow-down-to-bracket","fas fa-arrow-down-to-dotted-line","far fa-arrow-down-to-dotted-line","fal fa-arrow-down-to-dotted-line","fas fa-arrow-down-to-line","far fa-arrow-down-to-line","fal fa-arrow-down-to-line","fas fa-arrow-down-to-square","far fa-arrow-down-to-square","fal fa-arrow-down-to-square","fas fa-arrow-down-triangle-square","far fa-arrow-down-triangle-square","fal fa-arrow-down-triangle-square","fas fa-arrow-down-up-across-line","far fa-arrow-down-up-across-line","fal fa-arrow-down-up-across-line","fas fa-arrow-down-up-lock","far fa-arrow-down-up-lock","fal fa-arrow-down-up-lock","fas fa-arrow-down-wide-short","far fa-arrow-down-wide-short","fal fa-arrow-down-wide-short","fas fa-arrow-down-z-a","far fa-arrow-down-z-a","fal fa-arrow-down-z-a","fas fa-arrow-left","far fa-arrow-left","fal fa-arrow-left","fas fa-arrow-left-from-arc","far fa-arrow-left-from-arc","fal fa-arrow-left-from-arc","fas fa-arrow-left-from-bracket","far fa-arrow-left-from-bracket","fal fa-arrow-left-from-bracket","fas fa-arrow-left-from-line","far fa-arrow-left-from-line","fal fa-arrow-left-from-line","fas fa-arrow-left-long","far fa-arrow-left-long","fal fa-arrow-left-long","fas fa-arrow-left-long-to-line","far fa-arrow-left-long-to-line","fal fa-arrow-left-long-to-line","fas fa-arrow-left-to-arc","far fa-arrow-left-to-arc","fal fa-arrow-left-to-arc","fas fa-arrow-left-to-bracket","far fa-arrow-left-to-bracket","fal fa-arrow-left-to-bracket","fas fa-arrow-left-to-line","far fa-arrow-left-to-line","fal fa-arrow-left-to-line","fas fa-arrow-pointer","far fa-arrow-pointer","fal fa-arrow-pointer","fas fa-arrow-progress","far fa-arrow-progress","fal fa-arrow-progress","fas fa-arrow-right","far fa-arrow-right","fal fa-arrow-right","fas fa-arrow-right-arrow-left","far fa-arrow-right-arrow-left","fal fa-arrow-right-arrow-left","fas fa-arrow-right-from-arc","far fa-arrow-right-from-arc","fal fa-arrow-right-from-arc","fas fa-arrow-right-from-bracket","far fa-arrow-right-from-bracket","fal fa-arrow-right-from-bracket","fas fa-arrow-right-from-line","far fa-arrow-right-from-line","fal fa-arrow-right-from-line","fas fa-arrow-right-long","far fa-arrow-right-long","fal fa-arrow-right-long","fas fa-arrow-right-long-to-line","far fa-arrow-right-long-to-line","fal fa-arrow-right-long-to-line","fas fa-arrow-right-to-arc","far fa-arrow-right-to-arc","fal fa-arrow-right-to-arc","fas fa-arrow-right-to-bracket","far fa-arrow-right-to-bracket","fal fa-arrow-right-to-bracket","fas fa-arrow-right-to-line","far fa-arrow-right-to-line","fal fa-arrow-right-to-line","fas fa-arrow-rotate-left","far fa-arrow-rotate-left","fal fa-arrow-rotate-left","fas fa-arrow-rotate-right","far fa-arrow-rotate-right","fal fa-arrow-rotate-right","fas fa-arrow-trend-down","far fa-arrow-trend-down","fal fa-arrow-trend-down","fas fa-arrow-trend-up","far fa-arrow-trend-up","fal fa-arrow-trend-up","fas fa-arrow-turn-down","far fa-arrow-turn-down","fal fa-arrow-turn-down","fas fa-arrow-turn-down-left","far fa-arrow-turn-down-left","fal fa-arrow-turn-down-left","fas fa-arrow-turn-down-right","far fa-arrow-turn-down-right","fal fa-arrow-turn-down-right","fas fa-arrow-turn-left","far fa-arrow-turn-left","fal fa-arrow-turn-left","fas fa-arrow-turn-left-down","far fa-arrow-turn-left-down","fal fa-arrow-turn-left-down","fas fa-arrow-turn-left-up","far fa-arrow-turn-left-up","fal fa-arrow-turn-left-up","fas fa-arrow-turn-right","far fa-arrow-turn-right","fal fa-arrow-turn-right","fas fa-arrow-turn-up","far fa-arrow-turn-up","fal fa-arrow-turn-up","fas fa-arrow-up","far fa-arrow-up","fal fa-arrow-up","fas fa-arrow-up-1-9","far fa-arrow-up-1-9","fal fa-arrow-up-1-9","fas fa-arrow-up-9-1","far fa-arrow-up-9-1","fal fa-arrow-up-9-1","fas fa-arrow-up-a-z","far fa-arrow-up-a-z","fal fa-arrow-up-a-z","fas fa-arrow-up-arrow-down","far fa-arrow-up-arrow-down","fal fa-arrow-up-arrow-down","fas fa-arrow-up-big-small","far fa-arrow-up-big-small","fal fa-arrow-up-big-small","fas fa-arrow-up-from-arc","far fa-arrow-up-from-arc","fal fa-arrow-up-from-arc","fas fa-arrow-up-from-bracket","far fa-arrow-up-from-bracket","fal fa-arrow-up-from-bracket","fas fa-arrow-up-from-dotted-line","far fa-arrow-up-from-dotted-line","fal fa-arrow-up-from-dotted-line","fas fa-arrow-up-from-line","far fa-arrow-up-from-line","fal fa-arrow-up-from-line","fas fa-arrow-up-from-square","far fa-arrow-up-from-square","fal fa-arrow-up-from-square","fas fa-arrow-up-left","far fa-arrow-up-left","fal fa-arrow-up-left","fas fa-arrow-up-left-from-circle","far fa-arrow-up-left-from-circle","fal fa-arrow-up-left-from-circle","fas fa-arrow-up-long","far fa-arrow-up-long","fal fa-arrow-up-long","fas fa-arrow-up-right","far fa-arrow-up-right","fal fa-arrow-up-right","fas fa-arrow-up-right-and-arrow-down-left-from-center","far fa-arrow-up-right-and-arrow-down-left-from-center","fal fa-arrow-up-right-and-arrow-down-left-from-center","fas fa-arrow-up-right-dots","far fa-arrow-up-right-dots","fal fa-arrow-up-right-dots","fas fa-arrow-up-right-from-square","far fa-arrow-up-right-from-square","fal fa-arrow-up-right-from-square","fas fa-arrow-up-short-wide","far fa-arrow-up-short-wide","fal fa-arrow-up-short-wide","fas fa-arrow-up-small-big","far fa-arrow-up-small-big","fal fa-arrow-up-small-big","fas fa-arrow-up-square-triangle","far fa-arrow-up-square-triangle","fal fa-arrow-up-square-triangle","fas fa-arrow-up-to-arc","far fa-arrow-up-to-arc","fal fa-arrow-up-to-arc","fas fa-arrow-up-to-bracket","far fa-arrow-up-to-bracket","fal fa-arrow-up-to-bracket","fas fa-arrow-up-to-dotted-line","far fa-arrow-up-to-dotted-line","fal fa-arrow-up-to-dotted-line","fas fa-arrow-up-to-line","far fa-arrow-up-to-line","fal fa-arrow-up-to-line","fas fa-arrow-up-triangle-square","far fa-arrow-up-triangle-square","fal fa-arrow-up-triangle-square","fas fa-arrow-up-wide-short","far fa-arrow-up-wide-short","fal fa-arrow-up-wide-short","fas fa-arrow-up-z-a","far fa-arrow-up-z-a","fal fa-arrow-up-z-a","fas fa-arrows-cross","far fa-arrows-cross","fal fa-arrows-cross","fas fa-arrows-down-to-line","far fa-arrows-down-to-line","fal fa-arrows-down-to-line","fas fa-arrows-from-dotted-line","far fa-arrows-from-dotted-line","fal fa-arrows-from-dotted-line","fas fa-arrows-from-line","far fa-arrows-from-line","fal fa-arrows-from-line","fas fa-arrows-left-right","far fa-arrows-left-right","fal fa-arrows-left-right","fas fa-arrows-left-right-to-line","far fa-arrows-left-right-to-line","fal fa-arrows-left-right-to-line","fas fa-arrows-maximize","far fa-arrows-maximize","fal fa-arrows-maximize","fas fa-arrows-minimize","far fa-arrows-minimize","fal fa-arrows-minimize","fas fa-arrows-repeat","far fa-arrows-repeat","fal fa-arrows-repeat","fas fa-arrows-repeat-1","far fa-arrows-repeat-1","fal fa-arrows-repeat-1","fas fa-arrows-retweet","far fa-arrows-retweet","fal fa-arrows-retweet","fas fa-arrows-rotate","far fa-arrows-rotate","fal fa-arrows-rotate","fas fa-arrows-rotate-reverse","far fa-arrows-rotate-reverse","fal fa-arrows-rotate-reverse","fas fa-arrows-spin","far fa-arrows-spin","fal fa-arrows-spin","fas fa-arrows-split-up-and-left","far fa-arrows-split-up-and-left","fal fa-arrows-split-up-and-left","fas fa-arrows-to-circle","far fa-arrows-to-circle","fal fa-arrows-to-circle","fas fa-arrows-to-dot","far fa-arrows-to-dot","fal fa-arrows-to-dot","fas fa-arrows-to-dotted-line","far fa-arrows-to-dotted-line","fal fa-arrows-to-dotted-line","fas fa-arrows-to-eye","far fa-arrows-to-eye","fal fa-arrows-to-eye","fas fa-arrows-to-line","far fa-arrows-to-line","fal fa-arrows-to-line","fas fa-arrows-turn-right","far fa-arrows-turn-right","fal fa-arrows-turn-right","fas fa-arrows-turn-to-dots","far fa-arrows-turn-to-dots","fal fa-arrows-turn-to-dots","fas fa-arrows-up-down","far fa-arrows-up-down","fal fa-arrows-up-down","fas fa-arrows-up-down-left-right","far fa-arrows-up-down-left-right","fal fa-arrows-up-down-left-right","fas fa-arrows-up-to-line","far fa-arrows-up-to-line","fal fa-arrows-up-to-line","fas fa-caret-down","far fa-caret-down","fal fa-caret-down","fas fa-caret-left","far fa-caret-left","fal fa-caret-left","fas fa-caret-right","far fa-caret-right","fal fa-caret-right","fas fa-caret-up","far fa-caret-up","fal fa-caret-up","fas fa-chevron-down","far fa-chevron-down","fal fa-chevron-down","fas fa-chevron-left","far fa-chevron-left","fal fa-chevron-left","fas fa-chevron-right","far fa-chevron-right","fal fa-chevron-right","fas fa-chevron-up","far fa-chevron-up","fal fa-chevron-up","fas fa-chevrons-down","far fa-chevrons-down","fal fa-chevrons-down","fas fa-chevrons-left","far fa-chevrons-left","fal fa-chevrons-left","fas fa-chevrons-right","far fa-chevrons-right","fal fa-chevrons-right","fas fa-chevrons-up","far fa-chevrons-up","fal fa-chevrons-up","fas fa-circle-arrow-down","far fa-circle-arrow-down","fal fa-circle-arrow-down","fas fa-circle-arrow-down-left","far fa-circle-arrow-down-left","fal fa-circle-arrow-down-left","fas fa-circle-arrow-down-right","far fa-circle-arrow-down-right","fal fa-circle-arrow-down-right","fas fa-circle-arrow-left","far fa-circle-arrow-left","fal fa-circle-arrow-left","fas fa-circle-arrow-right","far fa-circle-arrow-right","fal fa-circle-arrow-right","fas fa-circle-arrow-up","far fa-circle-arrow-up","fal fa-circle-arrow-up","fas fa-circle-arrow-up-left","far fa-circle-arrow-up-left","fal fa-circle-arrow-up-left","fas fa-circle-arrow-up-right","far fa-circle-arrow-up-right","fal fa-circle-arrow-up-right","fas fa-circle-caret-down","far fa-circle-caret-down","fal fa-circle-caret-down","fas fa-circle-caret-left","far fa-circle-caret-left","fal fa-circle-caret-left","fas fa-circle-caret-right","far fa-circle-caret-right","fal fa-circle-caret-right","fas fa-circle-caret-up","far fa-circle-caret-up","fal fa-circle-caret-up","fas fa-circle-chevron-down","far fa-circle-chevron-down","fal fa-circle-chevron-down","fas fa-circle-chevron-left","far fa-circle-chevron-left","fal fa-circle-chevron-left","fas fa-circle-chevron-right","far fa-circle-chevron-right","fal fa-circle-chevron-right","fas fa-circle-chevron-up","far fa-circle-chevron-up","fal fa-circle-chevron-up","fas fa-circle-down","far fa-circle-down","fal fa-circle-down","fas fa-circle-down-left","far fa-circle-down-left","fal fa-circle-down-left","fas fa-circle-down-right","far fa-circle-down-right","fal fa-circle-down-right","fas fa-circle-left","far fa-circle-left","fal fa-circle-left","fas fa-circle-right","far fa-circle-right","fal fa-circle-right","fas fa-circle-up","far fa-circle-up","fal fa-circle-up","fas fa-circle-up-left","far fa-circle-up-left","fal fa-circle-up-left","fas fa-circle-up-right","far fa-circle-up-right","fal fa-circle-up-right","fas fa-clock-rotate-left","far fa-clock-rotate-left","fal fa-clock-rotate-left","fas fa-cloud-arrow-down","far fa-cloud-arrow-down","fal fa-cloud-arrow-down","fas fa-cloud-arrow-up","far fa-cloud-arrow-up","fal fa-cloud-arrow-up","fas fa-down","far fa-down","fal fa-down","fas fa-down-from-bracket","far fa-down-from-bracket","fal fa-down-from-bracket","fas fa-down-from-dotted-line","far fa-down-from-dotted-line","fal fa-down-from-dotted-line","fas fa-down-from-line","far fa-down-from-line","fal fa-down-from-line","fas fa-down-left","far fa-down-left","fal fa-down-left","fas fa-down-left-and-up-right-to-center","far fa-down-left-and-up-right-to-center","fal fa-down-left-and-up-right-to-center","fas fa-down-long","far fa-down-long","fal fa-down-long","fas fa-down-right","far fa-down-right","fal fa-down-right","fas fa-down-to-bracket","far fa-down-to-bracket","fal fa-down-to-bracket","fas fa-down-to-dotted-line","far fa-down-to-dotted-line","fal fa-down-to-dotted-line","fas fa-down-to-line","far fa-down-to-line","fal fa-down-to-line","fas fa-download","far fa-download","fal fa-download","fas fa-inbox-in","far fa-inbox-in","fal fa-inbox-in","fas fa-inbox-out","far fa-inbox-out","fal fa-inbox-out","fas fa-left","far fa-left","fal fa-left","fas fa-left-from-bracket","far fa-left-from-bracket","fal fa-left-from-bracket","fas fa-left-from-line","far fa-left-from-line","fal fa-left-from-line","fas fa-left-long","far fa-left-long","fal fa-left-long","fas fa-left-long-to-line","far fa-left-long-to-line","fal fa-left-long-to-line","fas fa-left-right","far fa-left-right","fal fa-left-right","fas fa-left-to-bracket","far fa-left-to-bracket","fal fa-left-to-bracket","fas fa-left-to-line","far fa-left-to-line","fal fa-left-to-line","fas fa-location-arrow","far fa-location-arrow","fal fa-location-arrow","fas fa-location-arrow-up","far fa-location-arrow-up","fal fa-location-arrow-up","fas fa-magnifying-glass-arrows-rotate","far fa-magnifying-glass-arrows-rotate","fal fa-magnifying-glass-arrows-rotate","fas fa-maximize","far fa-maximize","fal fa-maximize","fas fa-merge","far fa-merge","fal fa-merge","fas fa-recycle","far fa-recycle","fal fa-recycle","fas fa-repeat","far fa-repeat","fal fa-repeat","fas fa-repeat-1","far fa-repeat-1","fal fa-repeat-1","fas fa-reply","far fa-reply","fal fa-reply","fas fa-reply-all","far fa-reply-all","fal fa-reply-all","fas fa-retweet","far fa-retweet","fal fa-retweet","fas fa-right","far fa-right","fal fa-right","fas fa-right-from-bracket","far fa-right-from-bracket","fal fa-right-from-bracket","fas fa-right-from-line","far fa-right-from-line","fal fa-right-from-line","fas fa-right-left","far fa-right-left","fal fa-right-left","fas fa-right-left-large","far fa-right-left-large","fal fa-right-left-large","fas fa-right-long","far fa-right-long","fal fa-right-long","fas fa-right-long-to-line","far fa-right-long-to-line","fal fa-right-long-to-line","fas fa-right-to-bracket","far fa-right-to-bracket","fal fa-right-to-bracket","fas fa-right-to-line","far fa-right-to-line","fal fa-right-to-line","fas fa-rotate","far fa-rotate","fal fa-rotate","fas fa-rotate-left","far fa-rotate-left","fal fa-rotate-left","fas fa-rotate-reverse","far fa-rotate-reverse","fal fa-rotate-reverse","fas fa-rotate-right","far fa-rotate-right","fal fa-rotate-right","fas fa-share","far fa-share","fal fa-share","fas fa-share-all","far fa-share-all","fal fa-share-all","fas fa-share-from-square","far fa-share-from-square","fal fa-share-from-square","fas fa-shuffle","far fa-shuffle","fal fa-shuffle","fas fa-sort","far fa-sort","fal fa-sort","fas fa-sort-down","far fa-sort-down","fal fa-sort-down","fas fa-sort-up","far fa-sort-up","fal fa-sort-up","fas fa-split","far fa-split","fal fa-split","fas fa-square-arrow-down","far fa-square-arrow-down","fal fa-square-arrow-down","fas fa-square-arrow-down-left","far fa-square-arrow-down-left","fal fa-square-arrow-down-left","fas fa-square-arrow-down-right","far fa-square-arrow-down-right","fal fa-square-arrow-down-right","fas fa-square-arrow-left","far fa-square-arrow-left","fal fa-square-arrow-left","fas fa-square-arrow-right","far fa-square-arrow-right","fal fa-square-arrow-right","fas fa-square-arrow-up","far fa-square-arrow-up","fal fa-square-arrow-up","fas fa-square-arrow-up-left","far fa-square-arrow-up-left","fal fa-square-arrow-up-left","fas fa-square-arrow-up-right","far fa-square-arrow-up-right","fal fa-square-arrow-up-right","fas fa-square-caret-down","far fa-square-caret-down","fal fa-square-caret-down","fas fa-square-caret-left","far fa-square-caret-left","fal fa-square-caret-left","fas fa-square-caret-right","far fa-square-caret-right","fal fa-square-caret-right","fas fa-square-caret-up","far fa-square-caret-up","fal fa-square-caret-up","fas fa-square-chevron-down","far fa-square-chevron-down","fal fa-square-chevron-down","fas fa-square-chevron-left","far fa-square-chevron-left","fal fa-square-chevron-left","fas fa-square-chevron-right","far fa-square-chevron-right","fal fa-square-chevron-right","fas fa-square-chevron-up","far fa-square-chevron-up","fal fa-square-chevron-up","fas fa-square-down","far fa-square-down","fal fa-square-down","fas fa-square-down-left","far fa-square-down-left","fal fa-square-down-left","fas fa-square-down-right","far fa-square-down-right","fal fa-square-down-right","fas fa-square-left","far fa-square-left","fal fa-square-left","fas fa-square-right","far fa-square-right","fal fa-square-right","fas fa-square-up","far fa-square-up","fal fa-square-up","fas fa-square-up-left","far fa-square-up-left","fal fa-square-up-left","fas fa-square-up-right","far fa-square-up-right","fal fa-square-up-right","fas fa-swap","far fa-swap","fal fa-swap","fas fa-swap-arrows","far fa-swap-arrows","fal fa-swap-arrows","fas fa-turn-down","far fa-turn-down","fal fa-turn-down","fas fa-turn-down-left","far fa-turn-down-left","fal fa-turn-down-left","fas fa-turn-down-right","far fa-turn-down-right","fal fa-turn-down-right","fas fa-turn-left","far fa-turn-left","fal fa-turn-left","fas fa-turn-left-down","far fa-turn-left-down","fal fa-turn-left-down","fas fa-turn-left-up","far fa-turn-left-up","fal fa-turn-left-up","fas fa-turn-right","far fa-turn-right","fal fa-turn-right","fas fa-turn-up","far fa-turn-up","fal fa-turn-up","fas fa-up","far fa-up","fal fa-up","fas fa-up-down","far fa-up-down","fal fa-up-down","fas fa-up-down-left-right","far fa-up-down-left-right","fal fa-up-down-left-right","fas fa-up-from-bracket","far fa-up-from-bracket","fal fa-up-from-bracket","fas fa-up-from-dotted-line","far fa-up-from-dotted-line","fal fa-up-from-dotted-line","fas fa-up-from-line","far fa-up-from-line","fal fa-up-from-line","fas fa-up-left","far fa-up-left","fal fa-up-left","fas fa-up-long","far fa-up-long","fal fa-up-long","fas fa-up-right","far fa-up-right","fal fa-up-right","fas fa-up-right-and-down-left-from-center","far fa-up-right-and-down-left-from-center","fal fa-up-right-and-down-left-from-center","fas fa-up-right-from-square","far fa-up-right-from-square","fal fa-up-right-from-square","fas fa-up-to-bracket","far fa-up-to-bracket","fal fa-up-to-bracket","fas fa-up-to-dotted-line","far fa-up-to-dotted-line","fal fa-up-to-dotted-line","fas fa-up-to-line","far fa-up-to-line","fal fa-up-to-line","fas fa-upload","far fa-upload","fal fa-upload"]},{"id":"music-audio","title":"Music + Audio","icons":["fas fa-airplay","far fa-airplay","fal fa-airplay","fas fa-album","far fa-album","fal fa-album","fas fa-album-circle-plus","far fa-album-circle-plus","fal fa-album-circle-plus","fas fa-album-circle-user","far fa-album-circle-user","fal fa-album-circle-user","fas fa-album-collection","far fa-album-collection","fal fa-album-collection","fas fa-album-collection-circle-plus","far fa-album-collection-circle-plus","fal fa-album-collection-circle-plus","fas fa-album-collection-circle-user","far fa-album-collection-circle-user","fal fa-album-collection-circle-user","fas fa-amp-guitar","far fa-amp-guitar","fal fa-amp-guitar","fas fa-banjo","far fa-banjo","fal fa-banjo","fas fa-bells","far fa-bells","fal fa-bells","fas fa-boombox","far fa-boombox","fal fa-boombox","fas fa-cassette-tape","far fa-cassette-tape","fal fa-cassette-tape","fas fa-circle-microphone","far fa-circle-microphone","fal fa-circle-microphone","fas fa-circle-microphone-lines","far fa-circle-microphone-lines","fal fa-circle-microphone-lines","fas fa-clarinet","far fa-clarinet","fal fa-clarinet","fas fa-cloud-music","far fa-cloud-music","fal fa-cloud-music","fas fa-comment-music","far fa-comment-music","fal fa-comment-music","fas fa-compact-disc","far fa-compact-disc","fal fa-compact-disc","fas fa-computer-speaker","far fa-computer-speaker","fal fa-computer-speaker","fas fa-cowbell","far fa-cowbell","fal fa-cowbell","fas fa-cowbell-circle-plus","far fa-cowbell-circle-plus","fal fa-cowbell-circle-plus","fas fa-dial","far fa-dial","fal fa-dial","fas fa-dial-high","far fa-dial-high","fal fa-dial-high","fas fa-dial-low","far fa-dial-low","fal fa-dial-low","fas fa-dial-max","far fa-dial-max","fal fa-dial-max","fas fa-dial-med","far fa-dial-med","fal fa-dial-med","fas fa-dial-med-low","far fa-dial-med-low","fal fa-dial-med-low","fas fa-dial-min","far fa-dial-min","fal fa-dial-min","fas fa-dial-off","far fa-dial-off","fal fa-dial-off","fas fa-disc-drive","far fa-disc-drive","fal fa-disc-drive","fas fa-drum","far fa-drum","fal fa-drum","fas fa-drum-steelpan","far fa-drum-steelpan","fal fa-drum-steelpan","fas fa-ear","far fa-ear","fal fa-ear","fas fa-file-audio","far fa-file-audio","fal fa-file-audio","fas fa-file-mp3","far fa-file-mp3","fal fa-file-mp3","fas fa-file-music","far fa-file-music","fal fa-file-music","fas fa-flute","far fa-flute","fal fa-flute","fas fa-folder-music","far fa-folder-music","fal fa-folder-music","fas fa-gramophone","far fa-gramophone","fal fa-gramophone","fas fa-guitar","far fa-guitar","fal fa-guitar","fas fa-guitar-electric","far fa-guitar-electric","fal fa-guitar-electric","fas fa-guitars","far fa-guitars","fal fa-guitars","fas fa-hand-horns","far fa-hand-horns","fal fa-hand-horns","fas fa-head-side-headphones","far fa-head-side-headphones","fal fa-head-side-headphones","fas fa-headphones","far fa-headphones","fal fa-headphones","fas fa-headphones-simple","far fa-headphones-simple","fal fa-headphones-simple","fas fa-kazoo","far fa-kazoo","fal fa-kazoo","fas fa-list-music","far fa-list-music","fal fa-list-music","fas fa-magnifying-glass-music","far fa-magnifying-glass-music","fal fa-magnifying-glass-music","fas fa-magnifying-glass-play","far fa-magnifying-glass-play","fal fa-magnifying-glass-play","fas fa-magnifying-glass-waveform","far fa-magnifying-glass-waveform","fal fa-magnifying-glass-waveform","fas fa-mandolin","far fa-mandolin","fal fa-mandolin","fas fa-message-music","far fa-message-music","fal fa-message-music","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-lines","far fa-microphone-lines","fal fa-microphone-lines","fas fa-microphone-lines-slash","far fa-microphone-lines-slash","fal fa-microphone-lines-slash","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-microphone-stand","far fa-microphone-stand","fal fa-microphone-stand","fas fa-mp3-player","far fa-mp3-player","fal fa-mp3-player","fas fa-music","far fa-music","fal fa-music","fas fa-music-magnifying-glass","far fa-music-magnifying-glass","fal fa-music-magnifying-glass","fas fa-music-note","far fa-music-note","fal fa-music-note","fas fa-music-note-slash","far fa-music-note-slash","fal fa-music-note-slash","fas fa-music-slash","far fa-music-slash","fal fa-music-slash","fab fa-napster","fas fa-photo-film-music","far fa-photo-film-music","fal fa-photo-film-music","fas fa-piano","far fa-piano","fal fa-piano","fas fa-piano-keyboard","far fa-piano-keyboard","fal fa-piano-keyboard","fas fa-radio","far fa-radio","fal fa-radio","fas fa-radio-tuner","far fa-radio-tuner","fal fa-radio-tuner","fas fa-record-vinyl","far fa-record-vinyl","fal fa-record-vinyl","fas fa-saxophone","far fa-saxophone","fal fa-saxophone","fas fa-saxophone-fire","far fa-saxophone-fire","fal fa-saxophone-fire","fas fa-screencast","far fa-screencast","fal fa-screencast","fas fa-sliders","far fa-sliders","fal fa-sliders","fas fa-sliders-up","far fa-sliders-up","fal fa-sliders-up","fab fa-soundcloud","fas fa-speaker","far fa-speaker","fal fa-speaker","fas fa-speakers","far fa-speakers","fal fa-speakers","fab fa-spotify","fas fa-square-sliders","far fa-square-sliders","fal fa-square-sliders","fas fa-square-sliders-vertical","far fa-square-sliders-vertical","fal fa-square-sliders-vertical","fas fa-triangle-instrument","far fa-triangle-instrument","fal fa-triangle-instrument","fas fa-trumpet","far fa-trumpet","fal fa-trumpet","fas fa-turntable","far fa-turntable","fal fa-turntable","fas fa-tv-music","far fa-tv-music","fal fa-tv-music","fas fa-user-music","far fa-user-music","fal fa-user-music","fas fa-violin","far fa-violin","fal fa-violin","fas fa-volume","far fa-volume","fal fa-volume","fas fa-volume-high","far fa-volume-high","fal fa-volume-high","fas fa-volume-low","far fa-volume-low","fal fa-volume-low","fas fa-volume-off","far fa-volume-off","fal fa-volume-off","fas fa-volume-slash","far fa-volume-slash","fal fa-volume-slash","fas fa-volume-xmark","far fa-volume-xmark","fal fa-volume-xmark","fas fa-wave-sine","far fa-wave-sine","fal fa-wave-sine","fas fa-wave-square","far fa-wave-square","fal fa-wave-square","fas fa-wave-triangle","far fa-wave-triangle","fal fa-wave-triangle","fas fa-waveform","far fa-waveform","fal fa-waveform","fas fa-waveform-lines","far fa-waveform-lines","fal fa-waveform-lines","fas fa-waves-sine","far fa-waves-sine","fal fa-waves-sine","fas fa-whistle","far fa-whistle","fal fa-whistle"]},{"id":"maritime","title":"Maritime","icons":["fas fa-anchor","far fa-anchor","fal fa-anchor","fas fa-anchor-circle-check","far fa-anchor-circle-check","fal fa-anchor-circle-check","fas fa-anchor-circle-exclamation","far fa-anchor-circle-exclamation","fal fa-anchor-circle-exclamation","fas fa-anchor-circle-xmark","far fa-anchor-circle-xmark","fal fa-anchor-circle-xmark","fas fa-anchor-lock","far fa-anchor-lock","fal fa-anchor-lock","fas fa-bridge-suspension","far fa-bridge-suspension","fal fa-bridge-suspension","fas fa-buoy","far fa-buoy","fal fa-buoy","fas fa-buoy-mooring","far fa-buoy-mooring","fal fa-buoy-mooring","fas fa-crab","far fa-crab","fal fa-crab","fas fa-dolphin","far fa-dolphin","fal fa-dolphin","fas fa-duck","far fa-duck","fal fa-duck","fas fa-ferry","far fa-ferry","fal fa-ferry","fas fa-fish","far fa-fish","fal fa-fish","fas fa-fish-bones","far fa-fish-bones","fal fa-fish-bones","fas fa-fish-cooked","far fa-fish-cooked","fal fa-fish-cooked","fas fa-fish-fins","far fa-fish-fins","fal fa-fish-fins","fas fa-fishing-rod","far fa-fishing-rod","fal fa-fishing-rod","fas fa-lighthouse","far fa-lighthouse","fal fa-lighthouse","fas fa-lobster","far fa-lobster","fal fa-lobster","fas fa-narwhal","far fa-narwhal","fal fa-narwhal","fas fa-otter","far fa-otter","fal fa-otter","fas fa-person-swimming","far fa-person-swimming","fal fa-person-swimming","fas fa-sailboat","far fa-sailboat","fal fa-sailboat","fas fa-ship","far fa-ship","fal fa-ship","fas fa-shrimp","far fa-shrimp","fal fa-shrimp","fas fa-squid","far fa-squid","fal fa-squid","fas fa-water","far fa-water","fal fa-water","fas fa-water-arrow-down","far fa-water-arrow-down","fal fa-water-arrow-down","fas fa-water-arrow-up","far fa-water-arrow-up","fal fa-water-arrow-up","fas fa-wave","far fa-wave","fal fa-wave","fas fa-whale","far fa-whale","fal fa-whale"]},{"id":"editing","title":"Editing","icons":["fas fa-arrows-rotate","far fa-arrows-rotate","fal fa-arrows-rotate","fas fa-arrows-rotate-reverse","far fa-arrows-rotate-reverse","fal fa-arrows-rotate-reverse","fas fa-bandage","far fa-bandage","fal fa-bandage","fas fa-bars","far fa-bars","fal fa-bars","fas fa-bars-filter","far fa-bars-filter","fal fa-bars-filter","fas fa-bars-sort","far fa-bars-sort","fal fa-bars-sort","fas fa-brush","far fa-brush","fal fa-brush","fas fa-chart-simple","far fa-chart-simple","fal fa-chart-simple","fas fa-check","far fa-check","fal fa-check","fas fa-check-double","far fa-check-double","fal fa-check-double","fas fa-circle-check","far fa-circle-check","fal fa-circle-check","fas fa-circle-dashed","far fa-circle-dashed","fal fa-circle-dashed","fas fa-circle-ellipsis","far fa-circle-ellipsis","fal fa-circle-ellipsis","fas fa-circle-ellipsis-vertical","far fa-circle-ellipsis-vertical","fal fa-circle-ellipsis-vertical","fas fa-circle-half-stroke","far fa-circle-half-stroke","fal fa-circle-half-stroke","fas fa-circle-quarter-stroke","far fa-circle-quarter-stroke","fal fa-circle-quarter-stroke","fas fa-circle-three-quarters-stroke","far fa-circle-three-quarters-stroke","fal fa-circle-three-quarters-stroke","fas fa-circle-trash","far fa-circle-trash","fal fa-circle-trash","fas fa-command","far fa-command","fal fa-command","fas fa-crop","far fa-crop","fal fa-crop","fas fa-crop-simple","far fa-crop-simple","fal fa-crop-simple","fas fa-cube","far fa-cube","fal fa-cube","fas fa-dash","far fa-dash","fal fa-dash","fas fa-delete-left","far fa-delete-left","fal fa-delete-left","fas fa-delete-right","far fa-delete-right","fal fa-delete-right","fas fa-diagram-venn","far fa-diagram-venn","fal fa-diagram-venn","fas fa-dial","far fa-dial","fal fa-dial","fas fa-dial-high","far fa-dial-high","fal fa-dial-high","fas fa-dial-low","far fa-dial-low","fal fa-dial-low","fas fa-dial-max","far fa-dial-max","fal fa-dial-max","fas fa-dial-med","far fa-dial-med","fal fa-dial-med","fas fa-dial-med-low","far fa-dial-med-low","fal fa-dial-med-low","fas fa-dial-min","far fa-dial-min","fal fa-dial-min","fas fa-dial-off","far fa-dial-off","fal fa-dial-off","fas fa-distribute-spacing-horizontal","far fa-distribute-spacing-horizontal","fal fa-distribute-spacing-horizontal","fas fa-distribute-spacing-vertical","far fa-distribute-spacing-vertical","fal fa-distribute-spacing-vertical","fas fa-ellipsis","far fa-ellipsis","fal fa-ellipsis","fas fa-ellipsis-stroke","far fa-ellipsis-stroke","fal fa-ellipsis-stroke","fas fa-ellipsis-stroke-vertical","far fa-ellipsis-stroke-vertical","fal fa-ellipsis-stroke-vertical","fas fa-ellipsis-vertical","far fa-ellipsis-vertical","fal fa-ellipsis-vertical","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-eye-dropper-full","far fa-eye-dropper-full","fal fa-eye-dropper-full","fas fa-eye-dropper-half","far fa-eye-dropper-half","fal fa-eye-dropper-half","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-gallery-thumbnails","far fa-gallery-thumbnails","fal fa-gallery-thumbnails","fas fa-gear","far fa-gear","fal fa-gear","fas fa-grid","far fa-grid","fal fa-grid","fas fa-grid-2","far fa-grid-2","fal fa-grid-2","fas fa-grid-2-plus","far fa-grid-2-plus","fal fa-grid-2-plus","fas fa-grid-4","far fa-grid-4","fal fa-grid-4","fas fa-grid-5","far fa-grid-5","fal fa-grid-5","fas fa-grid-dividers","far fa-grid-dividers","fal fa-grid-dividers","fas fa-grid-horizontal","far fa-grid-horizontal","fal fa-grid-horizontal","fas fa-grid-round","far fa-grid-round","fal fa-grid-round","fas fa-grid-round-2","far fa-grid-round-2","fal fa-grid-round-2","fas fa-grid-round-2-plus","far fa-grid-round-2-plus","fal fa-grid-round-2-plus","fas fa-grid-round-4","far fa-grid-round-4","fal fa-grid-round-4","fas fa-grid-round-5","far fa-grid-round-5","fal fa-grid-round-5","fas fa-grip","far fa-grip","fal fa-grip","fas fa-grip-dots","far fa-grip-dots","fal fa-grip-dots","fas fa-grip-dots-vertical","far fa-grip-dots-vertical","fal fa-grip-dots-vertical","fas fa-grip-lines","far fa-grip-lines","fal fa-grip-lines","fas fa-grip-lines-vertical","far fa-grip-lines-vertical","fal fa-grip-lines-vertical","fas fa-grip-vertical","far fa-grip-vertical","fal fa-grip-vertical","fas fa-hexagon-check","far fa-hexagon-check","fal fa-hexagon-check","fas fa-lasso","far fa-lasso","fal fa-lasso","fas fa-lasso-sparkles","far fa-lasso-sparkles","fal fa-lasso-sparkles","fas fa-link","far fa-link","fal fa-link","fas fa-link-simple","far fa-link-simple","fal fa-link-simple","fas fa-link-simple-slash","far fa-link-simple-slash","fal fa-link-simple-slash","fas fa-link-slash","far fa-link-slash","fal fa-link-slash","fas fa-minus","far fa-minus","fal fa-minus","fas fa-objects-align-bottom","far fa-objects-align-bottom","fal fa-objects-align-bottom","fas fa-objects-align-center-horizontal","far fa-objects-align-center-horizontal","fal fa-objects-align-center-horizontal","fas fa-objects-align-center-vertical","far fa-objects-align-center-vertical","fal fa-objects-align-center-vertical","fas fa-objects-align-left","far fa-objects-align-left","fal fa-objects-align-left","fas fa-objects-align-right","far fa-objects-align-right","fal fa-objects-align-right","fas fa-objects-align-top","far fa-objects-align-top","fal fa-objects-align-top","fas fa-objects-column","far fa-objects-column","fal fa-objects-column","fas fa-octagon-check","far fa-octagon-check","fal fa-octagon-check","fas fa-paintbrush","far fa-paintbrush","fal fa-paintbrush","fas fa-paintbrush-fine","far fa-paintbrush-fine","fal fa-paintbrush-fine","fas fa-paintbrush-pencil","far fa-paintbrush-pencil","fal fa-paintbrush-pencil","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-circle","far fa-pen-circle","fal fa-pen-circle","fas fa-pen-clip","far fa-pen-clip","fal fa-pen-clip","fas fa-pen-clip-slash","far fa-pen-clip-slash","fal fa-pen-clip-slash","fas fa-pen-fancy","far fa-pen-fancy","fal fa-pen-fancy","fas fa-pen-fancy-slash","far fa-pen-fancy-slash","fal fa-pen-fancy-slash","fas fa-pen-field","far fa-pen-field","fal fa-pen-field","fas fa-pen-line","far fa-pen-line","fal fa-pen-line","fas fa-pen-nib","far fa-pen-nib","fal fa-pen-nib","fas fa-pen-nib-slash","far fa-pen-nib-slash","fal fa-pen-nib-slash","fas fa-pen-paintbrush","far fa-pen-paintbrush","fal fa-pen-paintbrush","fas fa-pen-ruler","far fa-pen-ruler","fal fa-pen-ruler","fas fa-pen-slash","far fa-pen-slash","fal fa-pen-slash","fas fa-pen-swirl","far fa-pen-swirl","fal fa-pen-swirl","fas fa-pen-to-square","far fa-pen-to-square","fal fa-pen-to-square","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-mechanical","far fa-pencil-mechanical","fal fa-pencil-mechanical","fas fa-pencil-slash","far fa-pencil-slash","fal fa-pencil-slash","fas fa-plus","far fa-plus","fal fa-plus","fas fa-plus-large","far fa-plus-large","fal fa-plus-large","fas fa-rabbit-running","far fa-rabbit-running","fal fa-rabbit-running","fas fa-rectangles-mixed","far fa-rectangles-mixed","fal fa-rectangles-mixed","fas fa-rotate","far fa-rotate","fal fa-rotate","fas fa-rotate-reverse","far fa-rotate-reverse","fal fa-rotate-reverse","fas fa-scissors","far fa-scissors","fal fa-scissors","fas fa-scribble","far fa-scribble","fal fa-scribble","fas fa-signature","far fa-signature","fal fa-signature","fas fa-signature-lock","far fa-signature-lock","fal fa-signature-lock","fas fa-signature-slash","far fa-signature-slash","fal fa-signature-slash","fas fa-sliders","far fa-sliders","fal fa-sliders","fas fa-sliders-simple","far fa-sliders-simple","fal fa-sliders-simple","fas fa-sliders-up","far fa-sliders-up","fal fa-sliders-up","fas fa-square-check","far fa-square-check","fal fa-square-check","fas fa-square-dashed","far fa-square-dashed","fal fa-square-dashed","fas fa-square-dashed-circle-plus","far fa-square-dashed-circle-plus","fal fa-square-dashed-circle-plus","fas fa-square-ellipsis","far fa-square-ellipsis","fal fa-square-ellipsis","fas fa-square-ellipsis-vertical","far fa-square-ellipsis-vertical","fal fa-square-ellipsis-vertical","fas fa-square-pen","far fa-square-pen","fal fa-square-pen","fas fa-trash","far fa-trash","fal fa-trash","fas fa-trash-arrow-up","far fa-trash-arrow-up","fal fa-trash-arrow-up","fas fa-trash-can","far fa-trash-can","fal fa-trash-can","fas fa-trash-can-arrow-up","far fa-trash-can-arrow-up","fal fa-trash-can-arrow-up","fas fa-trash-can-check","far fa-trash-can-check","fal fa-trash-can-check","fas fa-trash-can-clock","far fa-trash-can-clock","fal fa-trash-can-clock","fas fa-trash-can-list","far fa-trash-can-list","fal fa-trash-can-list","fas fa-trash-can-plus","far fa-trash-can-plus","fal fa-trash-can-plus","fas fa-trash-can-slash","far fa-trash-can-slash","fal fa-trash-can-slash","fas fa-trash-can-undo","far fa-trash-can-undo","fal fa-trash-can-undo","fas fa-trash-can-xmark","far fa-trash-can-xmark","fal fa-trash-can-xmark","fas fa-trash-check","far fa-trash-check","fal fa-trash-check","fas fa-trash-clock","far fa-trash-clock","fal fa-trash-clock","fas fa-trash-list","far fa-trash-list","fal fa-trash-list","fas fa-trash-plus","far fa-trash-plus","fal fa-trash-plus","fas fa-trash-slash","far fa-trash-slash","fal fa-trash-slash","fas fa-trash-undo","far fa-trash-undo","fal fa-trash-undo","fas fa-trash-xmark","far fa-trash-xmark","fal fa-trash-xmark","fas fa-turtle","far fa-turtle","fal fa-turtle","fas fa-wand-magic","far fa-wand-magic","fal fa-wand-magic","fas fa-wand-magic-sparkles","far fa-wand-magic-sparkles","fal fa-wand-magic-sparkles","fas fa-xmark","far fa-xmark","fal fa-xmark","fas fa-xmark-large","far fa-xmark-large","fal fa-xmark-large"]},{"id":"logistics","title":"Logistics","icons":["fas fa-anchor","far fa-anchor","fal fa-anchor","fas fa-anchor-circle-check","far fa-anchor-circle-check","fal fa-anchor-circle-check","fas fa-anchor-circle-exclamation","far fa-anchor-circle-exclamation","fal fa-anchor-circle-exclamation","fas fa-anchor-circle-xmark","far fa-anchor-circle-xmark","fal fa-anchor-circle-xmark","fas fa-anchor-lock","far fa-anchor-lock","fal fa-anchor-lock","fas fa-barcode-read","far fa-barcode-read","fal fa-barcode-read","fas fa-barcode-scan","far fa-barcode-scan","fal fa-barcode-scan","fas fa-box","far fa-box","fal fa-box","fas fa-box-check","far fa-box-check","fal fa-box-check","fas fa-box-circle-check","far fa-box-circle-check","fal fa-box-circle-check","fas fa-boxes-packing","far fa-boxes-packing","fal fa-boxes-packing","fas fa-boxes-stacked","far fa-boxes-stacked","fal fa-boxes-stacked","fas fa-bridge","far fa-bridge","fal fa-bridge","fas fa-bridge-circle-check","far fa-bridge-circle-check","fal fa-bridge-circle-check","fas fa-bridge-circle-exclamation","far fa-bridge-circle-exclamation","fal fa-bridge-circle-exclamation","fas fa-bridge-circle-xmark","far fa-bridge-circle-xmark","fal fa-bridge-circle-xmark","fas fa-bridge-lock","far fa-bridge-lock","fal fa-bridge-lock","fas fa-bridge-water","far fa-bridge-water","fal fa-bridge-water","fas fa-bus","far fa-bus","fal fa-bus","fas fa-bus-simple","far fa-bus-simple","fal fa-bus-simple","fas fa-car","far fa-car","fal fa-car","fas fa-car-tunnel","far fa-car-tunnel","fal fa-car-tunnel","fas fa-cart-flatbed","far fa-cart-flatbed","fal fa-cart-flatbed","fas fa-cart-flatbed-boxes","far fa-cart-flatbed-boxes","fal fa-cart-flatbed-boxes","fas fa-cart-flatbed-empty","far fa-cart-flatbed-empty","fal fa-cart-flatbed-empty","fas fa-chart-kanban","far fa-chart-kanban","fal fa-chart-kanban","fas fa-chart-simple","far fa-chart-simple","fal fa-chart-simple","fas fa-chart-simple-horizontal","far fa-chart-simple-horizontal","fal fa-chart-simple-horizontal","fas fa-clipboard-check","far fa-clipboard-check","fal fa-clipboard-check","fas fa-clipboard-list","far fa-clipboard-list","fal fa-clipboard-list","fas fa-clipboard-question","far fa-clipboard-question","fal fa-clipboard-question","fas fa-conveyor-belt","far fa-conveyor-belt","fal fa-conveyor-belt","fas fa-conveyor-belt-arm","far fa-conveyor-belt-arm","fal fa-conveyor-belt-arm","fas fa-conveyor-belt-boxes","far fa-conveyor-belt-boxes","fal fa-conveyor-belt-boxes","fas fa-conveyor-belt-empty","far fa-conveyor-belt-empty","fal fa-conveyor-belt-empty","fas fa-crate-empty","far fa-crate-empty","fal fa-crate-empty","fas fa-dolly","far fa-dolly","fal fa-dolly","fas fa-dolly-empty","far fa-dolly-empty","fal fa-dolly-empty","fas fa-ferry","far fa-ferry","fal fa-ferry","fas fa-forklift","far fa-forklift","fal fa-forklift","fas fa-gas-pump","far fa-gas-pump","fal fa-gas-pump","fas fa-gas-pump-slash","far fa-gas-pump-slash","fal fa-gas-pump-slash","fas fa-gear-complex","far fa-gear-complex","fal fa-gear-complex","fas fa-gears","far fa-gears","fal fa-gears","fas fa-hand-holding-box","far fa-hand-holding-box","fal fa-hand-holding-box","fas fa-hands-holding-diamond","far fa-hands-holding-diamond","fal fa-hands-holding-diamond","fas fa-helicopter","far fa-helicopter","fal fa-helicopter","fas fa-helicopter-symbol","far fa-helicopter-symbol","fal fa-helicopter-symbol","fas fa-helmet-safety","far fa-helmet-safety","fal fa-helmet-safety","fas fa-jet-fighter-up","far fa-jet-fighter-up","fal fa-jet-fighter-up","fas fa-pallet","far fa-pallet","fal fa-pallet","fas fa-pallet-box","far fa-pallet-box","fal fa-pallet-box","fas fa-pallet-boxes","far fa-pallet-boxes","fal fa-pallet-boxes","fas fa-person-carry-box","far fa-person-carry-box","fal fa-person-carry-box","fas fa-person-dolly","far fa-person-dolly","fal fa-person-dolly","fas fa-person-dolly-empty","far fa-person-dolly-empty","fal fa-person-dolly-empty","fas fa-plane-circle-check","far fa-plane-circle-check","fal fa-plane-circle-check","fas fa-plane-circle-exclamation","far fa-plane-circle-exclamation","fal fa-plane-circle-exclamation","fas fa-plane-circle-xmark","far fa-plane-circle-xmark","fal fa-plane-circle-xmark","fas fa-plane-lock","far fa-plane-lock","fal fa-plane-lock","fas fa-rectangle-barcode","far fa-rectangle-barcode","fal fa-rectangle-barcode","fas fa-reel","far fa-reel","fal fa-reel","fas fa-road","far fa-road","fal fa-road","fas fa-road-barrier","far fa-road-barrier","fal fa-road-barrier","fas fa-road-bridge","far fa-road-bridge","fal fa-road-bridge","fas fa-road-circle-check","far fa-road-circle-check","fal fa-road-circle-check","fas fa-road-circle-exclamation","far fa-road-circle-exclamation","fal fa-road-circle-exclamation","fas fa-road-circle-xmark","far fa-road-circle-xmark","fal fa-road-circle-xmark","fas fa-road-lock","far fa-road-lock","fal fa-road-lock","fas fa-sailboat","far fa-sailboat","fal fa-sailboat","fas fa-scanner-gun","far fa-scanner-gun","fal fa-scanner-gun","fas fa-scanner-keyboard","far fa-scanner-keyboard","fal fa-scanner-keyboard","fas fa-scanner-touchscreen","far fa-scanner-touchscreen","fal fa-scanner-touchscreen","fas fa-shelves","far fa-shelves","fal fa-shelves","fas fa-shelves-empty","far fa-shelves-empty","fal fa-shelves-empty","fas fa-square-kanban","far fa-square-kanban","fal fa-square-kanban","fas fa-square-nfi","far fa-square-nfi","fal fa-square-nfi","fas fa-tablet-rugged","far fa-tablet-rugged","fal fa-tablet-rugged","fas fa-train","far fa-train","fal fa-train","fas fa-train-subway","far fa-train-subway","fal fa-train-subway","fas fa-train-subway-tunnel","far fa-train-subway-tunnel","fal fa-train-subway-tunnel","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-arrow-right","far fa-truck-arrow-right","fal fa-truck-arrow-right","fas fa-truck-clock","far fa-truck-clock","fal fa-truck-clock","fas fa-truck-container-empty","far fa-truck-container-empty","fal fa-truck-container-empty","fas fa-truck-fast","far fa-truck-fast","fal fa-truck-fast","fas fa-truck-field","far fa-truck-field","fal fa-truck-field","fas fa-truck-field-un","far fa-truck-field-un","fal fa-truck-field-un","fas fa-truck-flatbed","far fa-truck-flatbed","fal fa-truck-flatbed","fas fa-truck-front","far fa-truck-front","fal fa-truck-front","fas fa-truck-plane","far fa-truck-plane","fal fa-truck-plane","fas fa-user-helmet-safety","far fa-user-helmet-safety","fal fa-user-helmet-safety","fas fa-warehouse","far fa-warehouse","fal fa-warehouse","fas fa-warehouse-full","far fa-warehouse-full","fal fa-warehouse-full","fas fa-xmarks-lines","far fa-xmarks-lines","fal fa-xmarks-lines"]},{"id":"medical-health","title":"Medical + Health","icons":["fab fa-accessible-icon","fas fa-bacteria","far fa-bacteria","fal fa-bacteria","fas fa-bacterium","far fa-bacterium","fal fa-bacterium","fas fa-ban-smoking","far fa-ban-smoking","fal fa-ban-smoking","fas fa-bandage","far fa-bandage","fal fa-bandage","fas fa-bed-pulse","far fa-bed-pulse","fal fa-bed-pulse","fas fa-biohazard","far fa-biohazard","fal fa-biohazard","fas fa-bone","far fa-bone","fal fa-bone","fas fa-bone-break","far fa-bone-break","fal fa-bone-break","fas fa-bong","far fa-bong","fal fa-bong","fas fa-book-medical","far fa-book-medical","fal fa-book-medical","fas fa-book-user","far fa-book-user","fal fa-book-user","fas fa-books-medical","far fa-books-medical","fal fa-books-medical","fas fa-brain","far fa-brain","fal fa-brain","fas fa-briefcase-medical","far fa-briefcase-medical","fal fa-briefcase-medical","fas fa-cannabis","far fa-cannabis","fal fa-cannabis","fas fa-capsules","far fa-capsules","fal fa-capsules","fas fa-cauldron","far fa-cauldron","fal fa-cauldron","fas fa-circle-h","far fa-circle-h","fal fa-circle-h","fas fa-circle-radiation","far fa-circle-radiation","fal fa-circle-radiation","fas fa-clipboard-medical","far fa-clipboard-medical","fal fa-clipboard-medical","fas fa-clipboard-prescription","far fa-clipboard-prescription","fal fa-clipboard-prescription","fas fa-clipboard-user","far fa-clipboard-user","fal fa-clipboard-user","fas fa-clock-rotate-left","far fa-clock-rotate-left","fal fa-clock-rotate-left","fas fa-comment-medical","far fa-comment-medical","fal fa-comment-medical","fas fa-crutch","far fa-crutch","fal fa-crutch","fas fa-crutches","far fa-crutches","fal fa-crutches","fas fa-disease","far fa-disease","fal fa-disease","fas fa-display-medical","far fa-display-medical","fal fa-display-medical","fas fa-dna","far fa-dna","fal fa-dna","fas fa-droplet","far fa-droplet","fal fa-droplet","fas fa-droplet-percent","far fa-droplet-percent","fal fa-droplet-percent","fas fa-droplet-slash","far fa-droplet-slash","fal fa-droplet-slash","fas fa-ear","far fa-ear","fal fa-ear","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-eyes","far fa-eyes","fal fa-eyes","fas fa-face-head-bandage","far fa-face-head-bandage","fal fa-face-head-bandage","fas fa-face-mask","far fa-face-mask","fal fa-face-mask","fas fa-face-thermometer","far fa-face-thermometer","fal fa-face-thermometer","fas fa-face-vomit","far fa-face-vomit","fal fa-face-vomit","fas fa-file-medical","far fa-file-medical","fal fa-file-medical","fas fa-file-prescription","far fa-file-prescription","fal fa-file-prescription","fas fa-file-waveform","far fa-file-waveform","fal fa-file-waveform","fas fa-files-medical","far fa-files-medical","fal fa-files-medical","fas fa-fire-flame-simple","far fa-fire-flame-simple","fal fa-fire-flame-simple","fas fa-flask","far fa-flask","fal fa-flask","fas fa-flask-gear","far fa-flask-gear","fal fa-flask-gear","fas fa-flask-round-potion","far fa-flask-round-potion","fal fa-flask-round-potion","fas fa-flask-vial","far fa-flask-vial","fal fa-flask-vial","fas fa-folder-medical","far fa-folder-medical","fal fa-folder-medical","fas fa-hand-dots","far fa-hand-dots","fal fa-hand-dots","fas fa-hand-holding-droplet","far fa-hand-holding-droplet","fal fa-hand-holding-droplet","fas fa-hand-holding-medical","far fa-hand-holding-medical","fal fa-hand-holding-medical","fas fa-head-side-brain","far fa-head-side-brain","fal fa-head-side-brain","fas fa-head-side-cough","far fa-head-side-cough","fal fa-head-side-cough","fas fa-head-side-cough-slash","far fa-head-side-cough-slash","fal fa-head-side-cough-slash","fas fa-head-side-mask","far fa-head-side-mask","fal fa-head-side-mask","fas fa-head-side-medical","far fa-head-side-medical","fal fa-head-side-medical","fas fa-head-side-virus","far fa-head-side-virus","fal fa-head-side-virus","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-circle-bolt","far fa-heart-circle-bolt","fal fa-heart-circle-bolt","fas fa-heart-circle-check","far fa-heart-circle-check","fal fa-heart-circle-check","fas fa-heart-circle-exclamation","far fa-heart-circle-exclamation","fal fa-heart-circle-exclamation","fas fa-heart-circle-minus","far fa-heart-circle-minus","fal fa-heart-circle-minus","fas fa-heart-circle-plus","far fa-heart-circle-plus","fal fa-heart-circle-plus","fas fa-heart-circle-xmark","far fa-heart-circle-xmark","fal fa-heart-circle-xmark","fas fa-heart-pulse","far fa-heart-pulse","fal fa-heart-pulse","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-hospital-user","far fa-hospital-user","fal fa-hospital-user","fas fa-hospitals","far fa-hospitals","fal fa-hospitals","fas fa-house-chimney-medical","far fa-house-chimney-medical","fal fa-house-chimney-medical","fas fa-house-medical","far fa-house-medical","fal fa-house-medical","fas fa-house-medical-circle-check","far fa-house-medical-circle-check","fal fa-house-medical-circle-check","fas fa-house-medical-circle-exclamation","far fa-house-medical-circle-exclamation","fal fa-house-medical-circle-exclamation","fas fa-house-medical-circle-xmark","far fa-house-medical-circle-xmark","fal fa-house-medical-circle-xmark","fas fa-house-medical-flag","far fa-house-medical-flag","fal fa-house-medical-flag","fas fa-id-card-clip","far fa-id-card-clip","fal fa-id-card-clip","fas fa-inhaler","far fa-inhaler","fal fa-inhaler","fas fa-joint","far fa-joint","fal fa-joint","fas fa-kidneys","far fa-kidneys","fal fa-kidneys","fas fa-kit-medical","far fa-kit-medical","fal fa-kit-medical","fas fa-laptop-medical","far fa-laptop-medical","fal fa-laptop-medical","fas fa-lips","far fa-lips","fal fa-lips","fas fa-lungs","far fa-lungs","fal fa-lungs","fas fa-lungs-virus","far fa-lungs-virus","fal fa-lungs-virus","fas fa-mask-face","far fa-mask-face","fal fa-mask-face","fas fa-mask-ventilator","far fa-mask-ventilator","fal fa-mask-ventilator","fas fa-message-medical","far fa-message-medical","fal fa-message-medical","fas fa-microscope","far fa-microscope","fal fa-microscope","fas fa-monitor-waveform","far fa-monitor-waveform","fal fa-monitor-waveform","fas fa-mortar-pestle","far fa-mortar-pestle","fal fa-mortar-pestle","fas fa-nose","far fa-nose","fal fa-nose","fas fa-note-medical","far fa-note-medical","fal fa-note-medical","fas fa-notes-medical","far fa-notes-medical","fal fa-notes-medical","fas fa-pager","far fa-pager","fal fa-pager","fas fa-person-breastfeeding","far fa-person-breastfeeding","fal fa-person-breastfeeding","fas fa-person-cane","far fa-person-cane","fal fa-person-cane","fas fa-person-dots-from-line","far fa-person-dots-from-line","fal fa-person-dots-from-line","fas fa-person-half-dress","far fa-person-half-dress","fal fa-person-half-dress","fas fa-pills","far fa-pills","fal fa-pills","fas fa-plus","far fa-plus","fal fa-plus","fas fa-poop","far fa-poop","fal fa-poop","fas fa-prescription","far fa-prescription","fal fa-prescription","fas fa-prescription-bottle","far fa-prescription-bottle","fal fa-prescription-bottle","fas fa-prescription-bottle-medical","far fa-prescription-bottle-medical","fal fa-prescription-bottle-medical","fas fa-prescription-bottle-pill","far fa-prescription-bottle-pill","fal fa-prescription-bottle-pill","fas fa-pump-medical","far fa-pump-medical","fal fa-pump-medical","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-receipt","far fa-receipt","fal fa-receipt","fas fa-scalpel","far fa-scalpel","fal fa-scalpel","fas fa-scalpel-line-dashed","far fa-scalpel-line-dashed","fal fa-scalpel-line-dashed","fas fa-shield-virus","far fa-shield-virus","fal fa-shield-virus","fas fa-skeleton","far fa-skeleton","fal fa-skeleton","fas fa-skeleton-ribs","far fa-skeleton-ribs","fal fa-skeleton-ribs","fas fa-skull","far fa-skull","fal fa-skull","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-smoking","far fa-smoking","fal fa-smoking","fas fa-square-h","far fa-square-h","fal fa-square-h","fas fa-square-plus","far fa-square-plus","fal fa-square-plus","fas fa-square-virus","far fa-square-virus","fal fa-square-virus","fas fa-staff-snake","far fa-staff-snake","fal fa-staff-snake","fas fa-star-of-life","far fa-star-of-life","fal fa-star-of-life","fas fa-stethoscope","far fa-stethoscope","fal fa-stethoscope","fas fa-stomach","far fa-stomach","fal fa-stomach","fas fa-stretcher","far fa-stretcher","fal fa-stretcher","fas fa-suitcase-medical","far fa-suitcase-medical","fal fa-suitcase-medical","fas fa-syringe","far fa-syringe","fal fa-syringe","fas fa-tablets","far fa-tablets","fal fa-tablets","fas fa-teeth","far fa-teeth","fal fa-teeth","fas fa-teeth-open","far fa-teeth-open","fal fa-teeth-open","fas fa-thermometer","far fa-thermometer","fal fa-thermometer","fas fa-tooth","far fa-tooth","fal fa-tooth","fas fa-toothbrush","far fa-toothbrush","fal fa-toothbrush","fas fa-truck-droplet","far fa-truck-droplet","fal fa-truck-droplet","fas fa-truck-fire","far fa-truck-fire","fal fa-truck-fire","fas fa-truck-medical","far fa-truck-medical","fal fa-truck-medical","fas fa-user-doctor","far fa-user-doctor","fal fa-user-doctor","fas fa-user-doctor-hair","far fa-user-doctor-hair","fal fa-user-doctor-hair","fas fa-user-doctor-hair-long","far fa-user-doctor-hair-long","fal fa-user-doctor-hair-long","fas fa-user-doctor-message","far fa-user-doctor-message","fal fa-user-doctor-message","fas fa-user-nurse","far fa-user-nurse","fal fa-user-nurse","fas fa-user-nurse-hair","far fa-user-nurse-hair","fal fa-user-nurse-hair","fas fa-user-nurse-hair-long","far fa-user-nurse-hair-long","fal fa-user-nurse-hair-long","fas fa-users-medical","far fa-users-medical","fal fa-users-medical","fas fa-vial","far fa-vial","fal fa-vial","fas fa-vial-circle-check","far fa-vial-circle-check","fal fa-vial-circle-check","fas fa-vial-virus","far fa-vial-virus","fal fa-vial-virus","fas fa-vials","far fa-vials","fal fa-vials","fas fa-virus","far fa-virus","fal fa-virus","fas fa-virus-covid","far fa-virus-covid","fal fa-virus-covid","fas fa-virus-covid-slash","far fa-virus-covid-slash","fal fa-virus-covid-slash","fas fa-virus-slash","far fa-virus-slash","fal fa-virus-slash","fas fa-viruses","far fa-viruses","fal fa-viruses","fas fa-walker","far fa-walker","fal fa-walker","fas fa-watch-fitness","far fa-watch-fitness","fal fa-watch-fitness","fas fa-wave-pulse","far fa-wave-pulse","fal fa-wave-pulse","fas fa-weight-scale","far fa-weight-scale","fal fa-weight-scale","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wheelchair-move","far fa-wheelchair-move","fal fa-wheelchair-move","fas fa-x-ray","far fa-x-ray","fal fa-x-ray"]},{"id":"money","title":"Money","icons":["fas fa-austral-sign","far fa-austral-sign","fal fa-austral-sign","fas fa-badge-dollar","far fa-badge-dollar","fal fa-badge-dollar","fas fa-badge-percent","far fa-badge-percent","fal fa-badge-percent","fas fa-baht-sign","far fa-baht-sign","fal fa-baht-sign","fas fa-bangladeshi-taka-sign","far fa-bangladeshi-taka-sign","fal fa-bangladeshi-taka-sign","fab fa-bitcoin","fas fa-bitcoin-sign","far fa-bitcoin-sign","fal fa-bitcoin-sign","fas fa-brazilian-real-sign","far fa-brazilian-real-sign","fal fa-brazilian-real-sign","fab fa-btc","fas fa-cash-register","far fa-cash-register","fal fa-cash-register","fas fa-cedi-sign","far fa-cedi-sign","fal fa-cedi-sign","fas fa-cent-sign","far fa-cent-sign","fal fa-cent-sign","fas fa-chart-line","far fa-chart-line","fal fa-chart-line","fas fa-chart-line-down","far fa-chart-line-down","fal fa-chart-line-down","fas fa-chart-mixed","far fa-chart-mixed","fal fa-chart-mixed","fas fa-chart-mixed-up-circle-currency","far fa-chart-mixed-up-circle-currency","fal fa-chart-mixed-up-circle-currency","fas fa-chart-mixed-up-circle-dollar","far fa-chart-mixed-up-circle-dollar","fal fa-chart-mixed-up-circle-dollar","fas fa-chart-pie","far fa-chart-pie","fal fa-chart-pie","fas fa-chart-pie-simple","far fa-chart-pie-simple","fal fa-chart-pie-simple","fas fa-chart-pie-simple-circle-currency","far fa-chart-pie-simple-circle-currency","fal fa-chart-pie-simple-circle-currency","fas fa-chart-pie-simple-circle-dollar","far fa-chart-pie-simple-circle-dollar","fal fa-chart-pie-simple-circle-dollar","fas fa-chf-sign","far fa-chf-sign","fal fa-chf-sign","fas fa-circle-dollar","far fa-circle-dollar","fal fa-circle-dollar","fas fa-circle-dollar-to-slot","far fa-circle-dollar-to-slot","fal fa-circle-dollar-to-slot","fas fa-circle-euro","far fa-circle-euro","fal fa-circle-euro","fas fa-circle-sterling","far fa-circle-sterling","fal fa-circle-sterling","fas fa-circle-yen","far fa-circle-yen","fal fa-circle-yen","fas fa-coin","far fa-coin","fal fa-coin","fas fa-coin-blank","far fa-coin-blank","fal fa-coin-blank","fas fa-coin-front","far fa-coin-front","fal fa-coin-front","fas fa-coin-vertical","far fa-coin-vertical","fal fa-coin-vertical","fas fa-coins","far fa-coins","fal fa-coins","fas fa-colon-sign","far fa-colon-sign","fal fa-colon-sign","fas fa-comment-dollar","far fa-comment-dollar","fal fa-comment-dollar","fas fa-comments-dollar","far fa-comments-dollar","fal fa-comments-dollar","fas fa-credit-card","far fa-credit-card","fal fa-credit-card","fas fa-credit-card-blank","far fa-credit-card-blank","fal fa-credit-card-blank","fas fa-credit-card-front","far fa-credit-card-front","fal fa-credit-card-front","fas fa-cruzeiro-sign","far fa-cruzeiro-sign","fal fa-cruzeiro-sign","fas fa-display-chart-up","far fa-display-chart-up","fal fa-display-chart-up","fas fa-display-chart-up-circle-currency","far fa-display-chart-up-circle-currency","fal fa-display-chart-up-circle-currency","fas fa-display-chart-up-circle-dollar","far fa-display-chart-up-circle-dollar","fal fa-display-chart-up-circle-dollar","fas fa-dollar-sign","far fa-dollar-sign","fal fa-dollar-sign","fas fa-dong-sign","far fa-dong-sign","fal fa-dong-sign","fab fa-ethereum","fas fa-euro-sign","far fa-euro-sign","fal fa-euro-sign","fas fa-file-chart-column","far fa-file-chart-column","fal fa-file-chart-column","fas fa-file-chart-pie","far fa-file-chart-pie","fal fa-file-chart-pie","fas fa-file-invoice","far fa-file-invoice","fal fa-file-invoice","fas fa-file-invoice-dollar","far fa-file-invoice-dollar","fal fa-file-invoice-dollar","fas fa-florin-sign","far fa-florin-sign","fal fa-florin-sign","fas fa-franc-sign","far fa-franc-sign","fal fa-franc-sign","fab fa-gg","fab fa-gg-circle","fas fa-guarani-sign","far fa-guarani-sign","fal fa-guarani-sign","fas fa-hand-holding-circle-dollar","far fa-hand-holding-circle-dollar","fal fa-hand-holding-circle-dollar","fas fa-hand-holding-dollar","far fa-hand-holding-dollar","fal fa-hand-holding-dollar","fas fa-hands-holding-dollar","far fa-hands-holding-dollar","fal fa-hands-holding-dollar","fas fa-hryvnia-sign","far fa-hryvnia-sign","fal fa-hryvnia-sign","fas fa-indian-rupee-sign","far fa-indian-rupee-sign","fal fa-indian-rupee-sign","fas fa-kip-sign","far fa-kip-sign","fal fa-kip-sign","fas fa-landmark","far fa-landmark","fal fa-landmark","fas fa-lari-sign","far fa-lari-sign","fal fa-lari-sign","fas fa-lira-sign","far fa-lira-sign","fal fa-lira-sign","fas fa-litecoin-sign","far fa-litecoin-sign","fal fa-litecoin-sign","fas fa-manat-sign","far fa-manat-sign","fal fa-manat-sign","fas fa-message-dollar","far fa-message-dollar","fal fa-message-dollar","fas fa-messages-dollar","far fa-messages-dollar","fal fa-messages-dollar","fas fa-mill-sign","far fa-mill-sign","fal fa-mill-sign","fas fa-money-bill","far fa-money-bill","fal fa-money-bill","fas fa-money-bill-1","far fa-money-bill-1","fal fa-money-bill-1","fas fa-money-bill-1-wave","far fa-money-bill-1-wave","fal fa-money-bill-1-wave","fas fa-money-bill-simple","far fa-money-bill-simple","fal fa-money-bill-simple","fas fa-money-bill-simple-wave","far fa-money-bill-simple-wave","fal fa-money-bill-simple-wave","fas fa-money-bill-transfer","far fa-money-bill-transfer","fal fa-money-bill-transfer","fas fa-money-bill-trend-up","far fa-money-bill-trend-up","fal fa-money-bill-trend-up","fas fa-money-bill-wave","far fa-money-bill-wave","fal fa-money-bill-wave","fas fa-money-bill-wheat","far fa-money-bill-wheat","fal fa-money-bill-wheat","fas fa-money-bills","far fa-money-bills","fal fa-money-bills","fas fa-money-bills-simple","far fa-money-bills-simple","fal fa-money-bills-simple","fas fa-money-check","far fa-money-check","fal fa-money-check","fas fa-money-check-dollar","far fa-money-check-dollar","fal fa-money-check-dollar","fas fa-money-from-bracket","far fa-money-from-bracket","fal fa-money-from-bracket","fas fa-money-simple-from-bracket","far fa-money-simple-from-bracket","fal fa-money-simple-from-bracket","fas fa-naira-sign","far fa-naira-sign","fal fa-naira-sign","fas fa-percent","far fa-percent","fal fa-percent","fas fa-peseta-sign","far fa-peseta-sign","fal fa-peseta-sign","fas fa-peso-sign","far fa-peso-sign","fal fa-peso-sign","fas fa-piggy-bank","far fa-piggy-bank","fal fa-piggy-bank","fas fa-receipt","far fa-receipt","fal fa-receipt","fas fa-ruble-sign","far fa-ruble-sign","fal fa-ruble-sign","fas fa-rupee-sign","far fa-rupee-sign","fal fa-rupee-sign","fas fa-rupiah-sign","far fa-rupiah-sign","fal fa-rupiah-sign","fas fa-sack","far fa-sack","fal fa-sack","fas fa-sack-dollar","far fa-sack-dollar","fal fa-sack-dollar","fas fa-sack-xmark","far fa-sack-xmark","fal fa-sack-xmark","fas fa-scale-balanced","far fa-scale-balanced","fal fa-scale-balanced","fas fa-scale-unbalanced","far fa-scale-unbalanced","fal fa-scale-unbalanced","fas fa-scale-unbalanced-flip","far fa-scale-unbalanced-flip","fal fa-scale-unbalanced-flip","fas fa-shekel-sign","far fa-shekel-sign","fal fa-shekel-sign","fas fa-square-dollar","far fa-square-dollar","fal fa-square-dollar","fas fa-stamp","far fa-stamp","fal fa-stamp","fas fa-sterling-sign","far fa-sterling-sign","fal fa-sterling-sign","fas fa-tally","far fa-tally","fal fa-tally","fas fa-tenge-sign","far fa-tenge-sign","fal fa-tenge-sign","fas fa-treasure-chest","far fa-treasure-chest","fal fa-treasure-chest","fas fa-tugrik-sign","far fa-tugrik-sign","fal fa-tugrik-sign","fas fa-turkish-lira-sign","far fa-turkish-lira-sign","fal fa-turkish-lira-sign","fas fa-vault","far fa-vault","fal fa-vault","fas fa-wallet","far fa-wallet","fal fa-wallet","fas fa-won-sign","far fa-won-sign","fal fa-won-sign","fas fa-yen-sign","far fa-yen-sign","fal fa-yen-sign"]},{"id":"spinners","title":"Spinners","icons":["fas fa-arrow-rotate-left","far fa-arrow-rotate-left","fal fa-arrow-rotate-left","fas fa-arrow-rotate-right","far fa-arrow-rotate-right","fal fa-arrow-rotate-right","fas fa-arrows-rotate","far fa-arrows-rotate","fal fa-arrows-rotate","fas fa-arrows-rotate-reverse","far fa-arrows-rotate-reverse","fal fa-arrows-rotate-reverse","fas fa-arrows-spin","far fa-arrows-spin","fal fa-arrows-spin","fas fa-asterisk","far fa-asterisk","fal fa-asterisk","fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-simple","far fa-atom-simple","fal fa-atom-simple","fas fa-badge","far fa-badge","fal fa-badge","fas fa-bahai","far fa-bahai","fal fa-bahai","fas fa-bullseye-arrow","far fa-bullseye-arrow","fal fa-bullseye-arrow","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-circle-notch","far fa-circle-notch","fal fa-circle-notch","fas fa-compact-disc","far fa-compact-disc","fal fa-compact-disc","fas fa-compass","far fa-compass","fal fa-compass","fas fa-crosshairs","far fa-crosshairs","fal fa-crosshairs","fas fa-dharmachakra","far fa-dharmachakra","fal fa-dharmachakra","fas fa-fan","far fa-fan","fal fa-fan","fas fa-gear","far fa-gear","fal fa-gear","fas fa-hurricane","far fa-hurricane","fal fa-hurricane","fas fa-life-ring","far fa-life-ring","fal fa-life-ring","fas fa-loader","far fa-loader","fal fa-loader","fas fa-moon-over-sun","far fa-moon-over-sun","fal fa-moon-over-sun","fas fa-palette","far fa-palette","fal fa-palette","fas fa-ring","far fa-ring","fal fa-ring","fas fa-rotate","far fa-rotate","fal fa-rotate","fas fa-rotate-left","far fa-rotate-left","fal fa-rotate-left","fas fa-rotate-reverse","far fa-rotate-reverse","fal fa-rotate-reverse","fas fa-rotate-right","far fa-rotate-right","fal fa-rotate-right","fas fa-slash","far fa-slash","fal fa-slash","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-spider-web","far fa-spider-web","fal fa-spider-web","fas fa-spinner","far fa-spinner","fal fa-spinner","fas fa-spinner-scale","far fa-spinner-scale","fal fa-spinner-scale","fas fa-spinner-third","far fa-spinner-third","fal fa-spinner-third","fas fa-star-christmas","far fa-star-christmas","fal fa-star-christmas","fas fa-steering-wheel","far fa-steering-wheel","fal fa-steering-wheel","fas fa-stroopwafel","far fa-stroopwafel","fal fa-stroopwafel","fas fa-sun","far fa-sun","fal fa-sun","fas fa-tire","far fa-tire","fal fa-tire","fas fa-tire-rugged","far fa-tire-rugged","fal fa-tire-rugged","fas fa-wreath","far fa-wreath","fal fa-wreath","fas fa-yin-yang","far fa-yin-yang","fal fa-yin-yang"]},{"id":"science-fiction","title":"Science Fiction","icons":["fas fa-alien","far fa-alien","fal fa-alien","fas fa-alien-8bit","far fa-alien-8bit","fal fa-alien-8bit","fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-simple","far fa-atom-simple","fal fa-atom-simple","fas fa-book-journal-whills","far fa-book-journal-whills","fal fa-book-journal-whills","fas fa-cat-space","far fa-cat-space","fal fa-cat-space","fas fa-cloud-binary","far fa-cloud-binary","fal fa-cloud-binary","fas fa-drone","far fa-drone","fal fa-drone","fas fa-drone-front","far fa-drone-front","fal fa-drone-front","fas fa-explosion","far fa-explosion","fal fa-explosion","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fab fa-galactic-republic","fab fa-galactic-senate","fas fa-hand-spock","far fa-hand-spock","fal fa-hand-spock","fas fa-head-side-gear","far fa-head-side-gear","fal fa-head-side-gear","fas fa-jedi","far fa-jedi","fal fa-jedi","fab fa-jedi-order","fab fa-old-republic","fas fa-person-from-portal","far fa-person-from-portal","fal fa-person-from-portal","fas fa-person-to-portal","far fa-person-to-portal","fal fa-person-to-portal","fas fa-police-box","far fa-police-box","fal fa-police-box","fas fa-raygun","far fa-raygun","fal fa-raygun","fas fa-robot","far fa-robot","fal fa-robot","fas fa-robot-astromech","far fa-robot-astromech","fal fa-robot-astromech","fas fa-rocket","far fa-rocket","fal fa-rocket","fas fa-rocket-launch","far fa-rocket-launch","fal fa-rocket-launch","fab fa-space-awesome","fas fa-space-station-moon","far fa-space-station-moon","fal fa-space-station-moon","fas fa-space-station-moon-construction","far fa-space-station-moon-construction","fal fa-space-station-moon-construction","fas fa-starfighter","far fa-starfighter","fal fa-starfighter","fas fa-starfighter-twin-ion-engine","far fa-starfighter-twin-ion-engine","fal fa-starfighter-twin-ion-engine","fas fa-starfighter-twin-ion-engine-advanced","far fa-starfighter-twin-ion-engine-advanced","fal fa-starfighter-twin-ion-engine-advanced","fas fa-starship","far fa-starship","fal fa-starship","fas fa-starship-freighter","far fa-starship-freighter","fal fa-starship-freighter","fas fa-sword-laser","far fa-sword-laser","fal fa-sword-laser","fas fa-sword-laser-alt","far fa-sword-laser-alt","fal fa-sword-laser-alt","fas fa-swords-laser","far fa-swords-laser","fal fa-swords-laser","fas fa-transporter","far fa-transporter","fal fa-transporter","fas fa-transporter-1","far fa-transporter-1","fal fa-transporter-1","fas fa-transporter-2","far fa-transporter-2","fal fa-transporter-2","fas fa-transporter-3","far fa-transporter-3","fal fa-transporter-3","fas fa-transporter-4","far fa-transporter-4","fal fa-transporter-4","fas fa-transporter-5","far fa-transporter-5","fal fa-transporter-5","fas fa-transporter-6","far fa-transporter-6","fal fa-transporter-6","fas fa-transporter-7","far fa-transporter-7","fal fa-transporter-7","fas fa-transporter-empty","far fa-transporter-empty","fal fa-transporter-empty","fas fa-ufo","far fa-ufo","fal fa-ufo","fas fa-ufo-beam","far fa-ufo-beam","fal fa-ufo-beam","fas fa-user-alien","far fa-user-alien","fal fa-user-alien","fas fa-user-astronaut","far fa-user-astronaut","fal fa-user-astronaut","fas fa-user-bounty-hunter","far fa-user-bounty-hunter","fal fa-user-bounty-hunter","fas fa-user-hair-buns","far fa-user-hair-buns","fal fa-user-hair-buns","fas fa-user-robot","far fa-user-robot","fal fa-user-robot","fas fa-user-robot-xmarks","far fa-user-robot-xmarks","fal fa-user-robot-xmarks","fas fa-user-visor","far fa-user-visor","fal fa-user-visor","fas fa-watch-calculator","far fa-watch-calculator","fal fa-watch-calculator"]},{"id":"moving","title":"Moving","icons":["fas fa-blanket","far fa-blanket","fal fa-blanket","fas fa-box-archive","far fa-box-archive","fal fa-box-archive","fas fa-box-open","far fa-box-open","fal fa-box-open","fas fa-box-open-full","far fa-box-open-full","fal fa-box-open-full","fas fa-box-taped","far fa-box-taped","fal fa-box-taped","fas fa-boxes-packing","far fa-boxes-packing","fal fa-boxes-packing","fas fa-caravan","far fa-caravan","fal fa-caravan","fas fa-caravan-simple","far fa-caravan-simple","fal fa-caravan-simple","fas fa-container-storage","far fa-container-storage","fal fa-container-storage","fas fa-couch","far fa-couch","fal fa-couch","fas fa-dolly","far fa-dolly","fal fa-dolly","fas fa-dolly-empty","far fa-dolly-empty","fal fa-dolly-empty","fas fa-hammer-brush","far fa-hammer-brush","fal fa-hammer-brush","fas fa-house-chimney","far fa-house-chimney","fal fa-house-chimney","fas fa-house-person-leave","far fa-house-person-leave","fal fa-house-person-leave","fas fa-house-person-return","far fa-house-person-return","fal fa-house-person-return","fas fa-lamp","far fa-lamp","fal fa-lamp","fas fa-loveseat","far fa-loveseat","fal fa-loveseat","fas fa-people-carry-box","far fa-people-carry-box","fal fa-people-carry-box","fas fa-person-carry-box","far fa-person-carry-box","fal fa-person-carry-box","fas fa-person-dolly","far fa-person-dolly","fal fa-person-dolly","fas fa-person-dolly-empty","far fa-person-dolly-empty","fal fa-person-dolly-empty","fas fa-ramp-loading","far fa-ramp-loading","fal fa-ramp-loading","fas fa-route","far fa-route","fal fa-route","fas fa-sign-hanging","far fa-sign-hanging","fal fa-sign-hanging","fas fa-square-fragile","far fa-square-fragile","fal fa-square-fragile","fas fa-square-this-way-up","far fa-square-this-way-up","fal fa-square-this-way-up","fas fa-suitcase","far fa-suitcase","fal fa-suitcase","fas fa-tape","far fa-tape","fal fa-tape","fas fa-trailer","far fa-trailer","fal fa-trailer","fas fa-truck-container","far fa-truck-container","fal fa-truck-container","fas fa-truck-moving","far fa-truck-moving","fal fa-truck-moving","fas fa-truck-ramp","far fa-truck-ramp","fal fa-truck-ramp","fas fa-truck-ramp-box","far fa-truck-ramp-box","fal fa-truck-ramp-box","fas fa-truck-ramp-couch","far fa-truck-ramp-couch","fal fa-truck-ramp-couch","fas fa-vacuum","far fa-vacuum","fal fa-vacuum","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass","fas fa-wine-glass-crack","far fa-wine-glass-crack","fal fa-wine-glass-crack"]},{"id":"security","title":"Security","icons":["fas fa-badge-sheriff","far fa-badge-sheriff","fal fa-badge-sheriff","fas fa-ban","far fa-ban","fal fa-ban","fas fa-ban-bug","far fa-ban-bug","fal fa-ban-bug","fas fa-blanket-fire","far fa-blanket-fire","fal fa-blanket-fire","fas fa-block-brick-fire","far fa-block-brick-fire","fal fa-block-brick-fire","fas fa-book-section","far fa-book-section","fal fa-book-section","fas fa-bug","far fa-bug","fal fa-bug","fas fa-bug-slash","far fa-bug-slash","fal fa-bug-slash","fas fa-building-lock","far fa-building-lock","fal fa-building-lock","fas fa-building-shield","far fa-building-shield","fal fa-building-shield","fas fa-buoy-mooring","far fa-buoy-mooring","fal fa-buoy-mooring","fas fa-burst","far fa-burst","fal fa-burst","fas fa-camera-cctv","far fa-camera-cctv","fal fa-camera-cctv","fas fa-cannon","far fa-cannon","fal fa-cannon","fas fa-car-on","far fa-car-on","fal fa-car-on","fas fa-diamond-exclamation","far fa-diamond-exclamation","fal fa-diamond-exclamation","fas fa-do-not-enter","far fa-do-not-enter","fal fa-do-not-enter","fas fa-door-closed","far fa-door-closed","fal fa-door-closed","fas fa-door-open","far fa-door-open","fal fa-door-open","fas fa-dungeon","far fa-dungeon","fal fa-dungeon","fas fa-explosion","far fa-explosion","fal fa-explosion","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-face-viewfinder","far fa-face-viewfinder","fal fa-face-viewfinder","fas fa-file-certificate","far fa-file-certificate","fal fa-file-certificate","fas fa-file-contract","far fa-file-contract","fal fa-file-contract","fas fa-file-lock","far fa-file-lock","fal fa-file-lock","fas fa-file-shield","far fa-file-shield","fal fa-file-shield","fas fa-file-signature","far fa-file-signature","fal fa-file-signature","fas fa-fingerprint","far fa-fingerprint","fal fa-fingerprint","fas fa-gun","far fa-gun","fal fa-gun","fas fa-gun-slash","far fa-gun-slash","fal fa-gun-slash","fas fa-handcuffs","far fa-handcuffs","fal fa-handcuffs","fas fa-hands-bound","far fa-hands-bound","fal fa-hands-bound","fas fa-hands-holding-child","far fa-hands-holding-child","fal fa-hands-holding-child","fas fa-hands-holding-circle","far fa-hands-holding-circle","fal fa-hands-holding-circle","fas fa-house-fire","far fa-house-fire","fal fa-house-fire","fas fa-house-lock","far fa-house-lock","fal fa-house-lock","fas fa-id-badge","far fa-id-badge","fal fa-id-badge","fas fa-id-card","far fa-id-card","fal fa-id-card","fas fa-id-card-clip","far fa-id-card-clip","fal fa-id-card-clip","fas fa-key","far fa-key","fal fa-key","fas fa-key-skeleton","far fa-key-skeleton","fal fa-key-skeleton","fas fa-land-mine-on","far fa-land-mine-on","fal fa-land-mine-on","fas fa-light-emergency","far fa-light-emergency","fal fa-light-emergency","fas fa-light-emergency-on","far fa-light-emergency-on","fal fa-light-emergency-on","fas fa-lock","far fa-lock","fal fa-lock","fas fa-lock-keyhole","far fa-lock-keyhole","fal fa-lock-keyhole","fas fa-lock-keyhole-open","far fa-lock-keyhole-open","fal fa-lock-keyhole-open","fas fa-lock-open","far fa-lock-open","fal fa-lock-open","fas fa-mars-and-venus-burst","far fa-mars-and-venus-burst","fal fa-mars-and-venus-burst","fas fa-mask","far fa-mask","fal fa-mask","fas fa-octagon-exclamation","far fa-octagon-exclamation","fal fa-octagon-exclamation","fas fa-panel-ews","far fa-panel-ews","fal fa-panel-ews","fas fa-panel-fire","far fa-panel-fire","fal fa-panel-fire","fas fa-passport","far fa-passport","fal fa-passport","fas fa-people-pulling","far fa-people-pulling","fal fa-people-pulling","fas fa-people-robbery","far fa-people-robbery","fal fa-people-robbery","fas fa-person-burst","far fa-person-burst","fal fa-person-burst","fas fa-person-dress-burst","far fa-person-dress-burst","fal fa-person-dress-burst","fas fa-person-falling-burst","far fa-person-falling-burst","fal fa-person-falling-burst","fas fa-person-harassing","far fa-person-harassing","fal fa-person-harassing","fas fa-person-military-pointing","far fa-person-military-pointing","fal fa-person-military-pointing","fas fa-person-military-rifle","far fa-person-military-rifle","fal fa-person-military-rifle","fas fa-person-military-to-person","far fa-person-military-to-person","fal fa-person-military-to-person","fas fa-person-rifle","far fa-person-rifle","fal fa-person-rifle","fas fa-person-shelter","far fa-person-shelter","fal fa-person-shelter","fas fa-person-through-window","far fa-person-through-window","fal fa-person-through-window","fas fa-person-to-door","far fa-person-to-door","fal fa-person-to-door","fas fa-phone-intercom","far fa-phone-intercom","fal fa-phone-intercom","fas fa-road-spikes","far fa-road-spikes","fal fa-road-spikes","fas fa-shield","far fa-shield","fal fa-shield","fas fa-shield-cat","far fa-shield-cat","fal fa-shield-cat","fas fa-shield-check","far fa-shield-check","fal fa-shield-check","fas fa-shield-dog","far fa-shield-dog","fal fa-shield-dog","fas fa-shield-exclamation","far fa-shield-exclamation","fal fa-shield-exclamation","fas fa-shield-halved","far fa-shield-halved","fal fa-shield-halved","fas fa-shield-heart","far fa-shield-heart","fal fa-shield-heart","fas fa-shield-keyhole","far fa-shield-keyhole","fal fa-shield-keyhole","fas fa-shield-minus","far fa-shield-minus","fal fa-shield-minus","fas fa-shield-plus","far fa-shield-plus","fal fa-shield-plus","fas fa-shield-slash","far fa-shield-slash","fal fa-shield-slash","fas fa-shield-xmark","far fa-shield-xmark","fal fa-shield-xmark","fas fa-siren","far fa-siren","fal fa-siren","fas fa-siren-on","far fa-siren-on","fal fa-siren-on","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-sprinkler-ceiling","far fa-sprinkler-ceiling","fal fa-sprinkler-ceiling","fas fa-square-person-confined","far fa-square-person-confined","fal fa-square-person-confined","fas fa-tower-observation","far fa-tower-observation","fal fa-tower-observation","fas fa-unlock","far fa-unlock","fal fa-unlock","fas fa-unlock-keyhole","far fa-unlock-keyhole","fal fa-unlock-keyhole","fas fa-usb-drive","far fa-usb-drive","fal fa-usb-drive","fas fa-user-lock","far fa-user-lock","fal fa-user-lock","fas fa-user-police","far fa-user-police","fal fa-user-police","fas fa-user-police-tie","far fa-user-police-tie","fal fa-user-police-tie","fas fa-user-secret","far fa-user-secret","fal fa-user-secret","fas fa-user-shield","far fa-user-shield","fal fa-user-shield","fas fa-user-unlock","far fa-user-unlock","fal fa-user-unlock","fas fa-vault","far fa-vault","fal fa-vault","fas fa-whistle","far fa-whistle","fal fa-whistle"]},{"id":"accessibility","title":"Accessibility","icons":["fab fa-accessible-icon","fas fa-address-card","far fa-address-card","fal fa-address-card","fas fa-audio-description","far fa-audio-description","fal fa-audio-description","fas fa-audio-description-slash","far fa-audio-description-slash","fal fa-audio-description-slash","fas fa-braille","far fa-braille","fal fa-braille","fas fa-brightness","far fa-brightness","fal fa-brightness","fas fa-brightness-low","far fa-brightness-low","fal fa-brightness-low","fas fa-circle-info","far fa-circle-info","fal fa-circle-info","fas fa-circle-question","far fa-circle-question","fal fa-circle-question","fas fa-closed-captioning","far fa-closed-captioning","fal fa-closed-captioning","fas fa-closed-captioning-slash","far fa-closed-captioning-slash","fal fa-closed-captioning-slash","fas fa-comment-captions","far fa-comment-captions","fal fa-comment-captions","fas fa-dog-leashed","far fa-dog-leashed","fal fa-dog-leashed","fas fa-ear","far fa-ear","fal fa-ear","fas fa-ear-deaf","far fa-ear-deaf","fal fa-ear-deaf","fas fa-ear-listen","far fa-ear-listen","fal fa-ear-listen","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-low-vision","far fa-eye-low-vision","fal fa-eye-low-vision","fas fa-fingerprint","far fa-fingerprint","fal fa-fingerprint","fas fa-hands","far fa-hands","fal fa-hands","fas fa-hands-asl-interpreting","far fa-hands-asl-interpreting","fal fa-hands-asl-interpreting","fas fa-handshake-angle","far fa-handshake-angle","fal fa-handshake-angle","fas fa-head-side-heart","far fa-head-side-heart","fal fa-head-side-heart","fas fa-keyboard-brightness","far fa-keyboard-brightness","fal fa-keyboard-brightness","fas fa-keyboard-brightness-low","far fa-keyboard-brightness-low","fal fa-keyboard-brightness-low","fas fa-message-captions","far fa-message-captions","fal fa-message-captions","fas fa-person-cane","far fa-person-cane","fal fa-person-cane","fas fa-person-walking-with-cane","far fa-person-walking-with-cane","fal fa-person-walking-with-cane","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-question","far fa-question","fal fa-question","fas fa-square-info","far fa-square-info","fal fa-square-info","fas fa-square-question","far fa-square-question","fal fa-square-question","fas fa-tty","far fa-tty","fal fa-tty","fas fa-tty-answer","far fa-tty-answer","fal fa-tty-answer","fas fa-universal-access","far fa-universal-access","fal fa-universal-access","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wheelchair-move","far fa-wheelchair-move","fal fa-wheelchair-move"]},{"id":"business","title":"Business","icons":["fas fa-address-book","far fa-address-book","fal fa-address-book","fas fa-address-card","far fa-address-card","fal fa-address-card","fas fa-arrow-progress","far fa-arrow-progress","fal fa-arrow-progress","fas fa-arrows-spin","far fa-arrows-spin","fal fa-arrows-spin","fas fa-arrows-to-dot","far fa-arrows-to-dot","fal fa-arrows-to-dot","fas fa-arrows-to-eye","far fa-arrows-to-eye","fal fa-arrows-to-eye","fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-badge-dollar","far fa-badge-dollar","fal fa-badge-dollar","fas fa-badge-percent","far fa-badge-percent","fal fa-badge-percent","fas fa-bars-progress","far fa-bars-progress","fal fa-bars-progress","fas fa-bars-staggered","far fa-bars-staggered","fal fa-bars-staggered","fas fa-book","far fa-book","fal fa-book","fas fa-book-section","far fa-book-section","fal fa-book-section","fas fa-box-archive","far fa-box-archive","fal fa-box-archive","fas fa-boxes-packing","far fa-boxes-packing","fal fa-boxes-packing","fas fa-brain-arrow-curved-right","far fa-brain-arrow-curved-right","fal fa-brain-arrow-curved-right","fas fa-briefcase","far fa-briefcase","fal fa-briefcase","fas fa-briefcase-arrow-right","far fa-briefcase-arrow-right","fal fa-briefcase-arrow-right","fas fa-briefcase-blank","far fa-briefcase-blank","fal fa-briefcase-blank","fas fa-building","far fa-building","fal fa-building","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-bullseye","far fa-bullseye","fal fa-bullseye","fas fa-business-time","far fa-business-time","fal fa-business-time","fas fa-cabinet-filing","far fa-cabinet-filing","fal fa-cabinet-filing","fas fa-cake-candles","far fa-cake-candles","fal fa-cake-candles","fas fa-calculator","far fa-calculator","fal fa-calculator","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-calendar-days","far fa-calendar-days","fal fa-calendar-days","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-chart-kanban","far fa-chart-kanban","fal fa-chart-kanban","fas fa-chart-line","far fa-chart-line","fal fa-chart-line","fas fa-chart-line-down","far fa-chart-line-down","fal fa-chart-line-down","fas fa-chart-line-up","far fa-chart-line-up","fal fa-chart-line-up","fas fa-chart-line-up-down","far fa-chart-line-up-down","fal fa-chart-line-up-down","fas fa-chart-pie","far fa-chart-pie","fal fa-chart-pie","fas fa-chart-pie-simple","far fa-chart-pie-simple","fal fa-chart-pie-simple","fas fa-chart-pie-simple-circle-currency","far fa-chart-pie-simple-circle-currency","fal fa-chart-pie-simple-circle-currency","fas fa-chart-pie-simple-circle-dollar","far fa-chart-pie-simple-circle-dollar","fal fa-chart-pie-simple-circle-dollar","fas fa-chart-pyramid","far fa-chart-pyramid","fal fa-chart-pyramid","fas fa-chart-simple","far fa-chart-simple","fal fa-chart-simple","fas fa-chart-simple-horizontal","far fa-chart-simple-horizontal","fal fa-chart-simple-horizontal","fas fa-chart-tree-map","far fa-chart-tree-map","fal fa-chart-tree-map","fas fa-chart-user","far fa-chart-user","fal fa-chart-user","fas fa-city","far fa-city","fal fa-city","fas fa-clipboard","far fa-clipboard","fal fa-clipboard","fas fa-clipboard-question","far fa-clipboard-question","fal fa-clipboard-question","fas fa-cloud-word","far fa-cloud-word","fal fa-cloud-word","fas fa-coffee-pot","far fa-coffee-pot","fal fa-coffee-pot","fas fa-compass","far fa-compass","fal fa-compass","fas fa-computer-classic","far fa-computer-classic","fal fa-computer-classic","fas fa-copy","far fa-copy","fal fa-copy","fas fa-copyright","far fa-copyright","fal fa-copyright","fas fa-diagram-venn","far fa-diagram-venn","fal fa-diagram-venn","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-circle-check","far fa-envelope-circle-check","fal fa-envelope-circle-check","fas fa-envelope-dot","far fa-envelope-dot","fal fa-envelope-dot","fas fa-envelope-open","far fa-envelope-open","fal fa-envelope-open","fas fa-envelopes","far fa-envelopes","fal fa-envelopes","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-fax","far fa-fax","fal fa-fax","fas fa-file","far fa-file","fal fa-file","fas fa-file-chart-column","far fa-file-chart-column","fal fa-file-chart-column","fas fa-file-chart-pie","far fa-file-chart-pie","fal fa-file-chart-pie","fas fa-file-circle-info","far fa-file-circle-info","fal fa-file-circle-info","fas fa-file-circle-plus","far fa-file-circle-plus","fal fa-file-circle-plus","fas fa-file-lines","far fa-file-lines","fal fa-file-lines","fas fa-file-ppt","far fa-file-ppt","fal fa-file-ppt","fas fa-file-spreadsheet","far fa-file-spreadsheet","fal fa-file-spreadsheet","fas fa-file-user","far fa-file-user","fal fa-file-user","fas fa-file-xls","far fa-file-xls","fal fa-file-xls","fas fa-file-xml","far fa-file-xml","fal fa-file-xml","fas fa-floppy-disk","far fa-floppy-disk","fal fa-floppy-disk","fas fa-floppy-disk-circle-arrow-right","far fa-floppy-disk-circle-arrow-right","fal fa-floppy-disk-circle-arrow-right","fas fa-floppy-disk-circle-xmark","far fa-floppy-disk-circle-xmark","fal fa-floppy-disk-circle-xmark","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-arrow-down","far fa-folder-arrow-down","fal fa-folder-arrow-down","fas fa-folder-arrow-up","far fa-folder-arrow-up","fal fa-folder-arrow-up","fas fa-folder-check","far fa-folder-check","fal fa-folder-check","fas fa-folder-minus","far fa-folder-minus","fal fa-folder-minus","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-folder-plus","far fa-folder-plus","fal fa-folder-plus","fas fa-folder-tree","far fa-folder-tree","fal fa-folder-tree","fas fa-folder-xmark","far fa-folder-xmark","fal fa-folder-xmark","fas fa-folders","far fa-folders","fal fa-folders","fas fa-glasses","far fa-glasses","fal fa-glasses","fas fa-globe","far fa-globe","fal fa-globe","fas fa-highlighter","far fa-highlighter","fal fa-highlighter","fas fa-house-laptop","far fa-house-laptop","fal fa-house-laptop","fas fa-inbox-full","far fa-inbox-full","fal fa-inbox-full","fas fa-inboxes","far fa-inboxes","fal fa-inboxes","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-windows","far fa-industry-windows","fal fa-industry-windows","fas fa-keynote","far fa-keynote","fal fa-keynote","fas fa-lamp-desk","far fa-lamp-desk","fal fa-lamp-desk","fas fa-landmark","far fa-landmark","fal fa-landmark","fas fa-laptop-binary","far fa-laptop-binary","fal fa-laptop-binary","fas fa-laptop-file","far fa-laptop-file","fal fa-laptop-file","fas fa-list-check","far fa-list-check","fal fa-list-check","fas fa-list-dropdown","far fa-list-dropdown","fal fa-list-dropdown","fas fa-list-radio","far fa-list-radio","fal fa-list-radio","fas fa-list-timeline","far fa-list-timeline","fal fa-list-timeline","fas fa-list-tree","far fa-list-tree","fal fa-list-tree","fas fa-magnifying-glass-arrow-right","far fa-magnifying-glass-arrow-right","fal fa-magnifying-glass-arrow-right","fas fa-magnifying-glass-chart","far fa-magnifying-glass-chart","fal fa-magnifying-glass-chart","fas fa-marker","far fa-marker","fal fa-marker","fas fa-money-check-dollar-pen","far fa-money-check-dollar-pen","fal fa-money-check-dollar-pen","fas fa-money-check-pen","far fa-money-check-pen","fal fa-money-check-pen","fas fa-mug-saucer","far fa-mug-saucer","fal fa-mug-saucer","fas fa-network-wired","far fa-network-wired","fal fa-network-wired","fas fa-note-sticky","far fa-note-sticky","fal fa-note-sticky","fas fa-notebook","far fa-notebook","fal fa-notebook","fas fa-paperclip","far fa-paperclip","fal fa-paperclip","fas fa-paperclip-vertical","far fa-paperclip-vertical","fal fa-paperclip-vertical","fas fa-paste","far fa-paste","fal fa-paste","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-clip","far fa-pen-clip","fal fa-pen-clip","fas fa-pen-fancy","far fa-pen-fancy","fal fa-pen-fancy","fas fa-pen-nib","far fa-pen-nib","fal fa-pen-nib","fas fa-pen-nib-slash","far fa-pen-nib-slash","fal fa-pen-nib-slash","fas fa-pen-to-square","far fa-pen-to-square","fal fa-pen-to-square","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-percent","far fa-percent","fal fa-percent","fas fa-person-chalkboard","far fa-person-chalkboard","fal fa-person-chalkboard","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-flip","far fa-phone-flip","fal fa-phone-flip","fas fa-phone-intercom","far fa-phone-intercom","fal fa-phone-intercom","fas fa-phone-office","far fa-phone-office","fal fa-phone-office","fas fa-phone-slash","far fa-phone-slash","fal fa-phone-slash","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-podium","far fa-podium","fal fa-podium","fas fa-presentation-screen","far fa-presentation-screen","fal fa-presentation-screen","fas fa-print","far fa-print","fal fa-print","fas fa-print-magnifying-glass","far fa-print-magnifying-glass","fal fa-print-magnifying-glass","fas fa-print-slash","far fa-print-slash","fal fa-print-slash","fas fa-projector","far fa-projector","fal fa-projector","fas fa-rectangle-pro","far fa-rectangle-pro","fal fa-rectangle-pro","fas fa-registered","far fa-registered","fal fa-registered","fas fa-router","far fa-router","fal fa-router","fas fa-scale-balanced","far fa-scale-balanced","fal fa-scale-balanced","fas fa-scale-unbalanced","far fa-scale-unbalanced","fal fa-scale-unbalanced","fas fa-scale-unbalanced-flip","far fa-scale-unbalanced-flip","fal fa-scale-unbalanced-flip","fas fa-scanner-image","far fa-scanner-image","fal fa-scanner-image","fas fa-scissors","far fa-scissors","fal fa-scissors","fas fa-shredder","far fa-shredder","fal fa-shredder","fas fa-signature","far fa-signature","fal fa-signature","fas fa-signature-lock","far fa-signature-lock","fal fa-signature-lock","fas fa-signature-slash","far fa-signature-slash","fal fa-signature-slash","fas fa-sitemap","far fa-sitemap","fal fa-sitemap","fas fa-slot-machine","far fa-slot-machine","fal fa-slot-machine","fas fa-socks","far fa-socks","fal fa-socks","fas fa-square-envelope","far fa-square-envelope","fal fa-square-envelope","fas fa-square-kanban","far fa-square-kanban","fal fa-square-kanban","fas fa-square-pen","far fa-square-pen","fal fa-square-pen","fas fa-square-phone","far fa-square-phone","fal fa-square-phone","fas fa-square-phone-flip","far fa-square-phone-flip","fal fa-square-phone-flip","fas fa-square-poll-horizontal","far fa-square-poll-horizontal","fal fa-square-poll-horizontal","fas fa-square-poll-vertical","far fa-square-poll-vertical","fal fa-square-poll-vertical","fas fa-stapler","far fa-stapler","fal fa-stapler","fas fa-table","far fa-table","fal fa-table","fas fa-table-columns","far fa-table-columns","fal fa-table-columns","fas fa-table-layout","far fa-table-layout","fal fa-table-layout","fas fa-table-pivot","far fa-table-pivot","fal fa-table-pivot","fas fa-table-rows","far fa-table-rows","fal fa-table-rows","fas fa-table-tree","far fa-table-tree","fal fa-table-tree","fas fa-tag","far fa-tag","fal fa-tag","fas fa-tags","far fa-tags","fal fa-tags","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack","fas fa-thumbtack-slash","far fa-thumbtack-slash","fal fa-thumbtack-slash","fas fa-timeline","far fa-timeline","fal fa-timeline","fas fa-timeline-arrow","far fa-timeline-arrow","fal fa-timeline-arrow","fas fa-trademark","far fa-trademark","fal fa-trademark","fas fa-user-hair-mullet","far fa-user-hair-mullet","fal fa-user-hair-mullet","fas fa-user-tie-hair","far fa-user-tie-hair","fal fa-user-tie-hair","fas fa-user-tie-hair-long","far fa-user-tie-hair-long","fal fa-user-tie-hair-long","fas fa-vault","far fa-vault","fal fa-vault","fas fa-wallet","far fa-wallet","fal fa-wallet"]},{"id":"sports-fitness","title":"Sports + Fitness","icons":["fas fa-award-simple","far fa-award-simple","fal fa-award-simple","fas fa-badminton","far fa-badminton","fal fa-badminton","fas fa-baseball","far fa-baseball","fal fa-baseball","fas fa-baseball-bat-ball","far fa-baseball-bat-ball","fal fa-baseball-bat-ball","fas fa-basketball","far fa-basketball","fal fa-basketball","fas fa-basketball-hoop","far fa-basketball-hoop","fal fa-basketball-hoop","fas fa-bicycle","far fa-bicycle","fal fa-bicycle","fas fa-book-heart","far fa-book-heart","fal fa-book-heart","fas fa-bowling-ball","far fa-bowling-ball","fal fa-bowling-ball","fas fa-bowling-ball-pin","far fa-bowling-ball-pin","fal fa-bowling-ball-pin","fas fa-bowling-pins","far fa-bowling-pins","fal fa-bowling-pins","fas fa-boxing-glove","far fa-boxing-glove","fal fa-boxing-glove","fas fa-broom-ball","far fa-broom-ball","fal fa-broom-ball","fas fa-court-sport","far fa-court-sport","fal fa-court-sport","fas fa-cricket-bat-ball","far fa-cricket-bat-ball","fal fa-cricket-bat-ball","fas fa-curling-stone","far fa-curling-stone","fal fa-curling-stone","fas fa-dumbbell","far fa-dumbbell","fal fa-dumbbell","fas fa-field-hockey-stick-ball","far fa-field-hockey-stick-ball","fal fa-field-hockey-stick-ball","fas fa-fire-flame-curved","far fa-fire-flame-curved","fal fa-fire-flame-curved","fas fa-fire-flame-simple","far fa-fire-flame-simple","fal fa-fire-flame-simple","fas fa-fishing-rod","far fa-fishing-rod","fal fa-fishing-rod","fas fa-flag-pennant","far fa-flag-pennant","fal fa-flag-pennant","fas fa-flying-disc","far fa-flying-disc","fal fa-flying-disc","fas fa-football","far fa-football","fal fa-football","fas fa-football-helmet","far fa-football-helmet","fal fa-football-helmet","fas fa-futbol","far fa-futbol","fal fa-futbol","fas fa-goal-net","far fa-goal-net","fal fa-goal-net","fas fa-golf-ball-tee","far fa-golf-ball-tee","fal fa-golf-ball-tee","fas fa-golf-club","far fa-golf-club","fal fa-golf-club","fas fa-golf-flag-hole","far fa-golf-flag-hole","fal fa-golf-flag-hole","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-pulse","far fa-heart-pulse","fal fa-heart-pulse","fas fa-hockey-mask","far fa-hockey-mask","fal fa-hockey-mask","fas fa-hockey-puck","far fa-hockey-puck","fal fa-hockey-puck","fas fa-hockey-stick-puck","far fa-hockey-stick-puck","fal fa-hockey-stick-puck","fas fa-hockey-sticks","far fa-hockey-sticks","fal fa-hockey-sticks","fas fa-ice-skate","far fa-ice-skate","fal fa-ice-skate","fas fa-lacrosse-stick","far fa-lacrosse-stick","fal fa-lacrosse-stick","fas fa-lacrosse-stick-ball","far fa-lacrosse-stick-ball","fal fa-lacrosse-stick-ball","fas fa-luchador-mask","far fa-luchador-mask","fal fa-luchador-mask","fas fa-mask-snorkel","far fa-mask-snorkel","fal fa-mask-snorkel","fas fa-medal","far fa-medal","fal fa-medal","fas fa-monitor-waveform","far fa-monitor-waveform","fal fa-monitor-waveform","fas fa-mound","far fa-mound","fal fa-mound","fas fa-person-biking","far fa-person-biking","fal fa-person-biking","fas fa-person-biking-mountain","far fa-person-biking-mountain","fal fa-person-biking-mountain","fas fa-person-hiking","far fa-person-hiking","fal fa-person-hiking","fas fa-person-running","far fa-person-running","fal fa-person-running","fas fa-person-running-fast","far fa-person-running-fast","fal fa-person-running-fast","fas fa-person-skating","far fa-person-skating","fal fa-person-skating","fas fa-person-ski-jumping","far fa-person-ski-jumping","fal fa-person-ski-jumping","fas fa-person-skiing","far fa-person-skiing","fal fa-person-skiing","fas fa-person-skiing-nordic","far fa-person-skiing-nordic","fal fa-person-skiing-nordic","fas fa-person-sledding","far fa-person-sledding","fal fa-person-sledding","fas fa-person-snowboarding","far fa-person-snowboarding","fal fa-person-snowboarding","fas fa-person-swimming","far fa-person-swimming","fal fa-person-swimming","fas fa-person-walking","far fa-person-walking","fal fa-person-walking","fas fa-pickaxe","far fa-pickaxe","fal fa-pickaxe","fas fa-pickleball","far fa-pickleball","fal fa-pickleball","fas fa-racquet","far fa-racquet","fal fa-racquet","fas fa-ranking-star","far fa-ranking-star","fal fa-ranking-star","fas fa-rugby-ball","far fa-rugby-ball","fal fa-rugby-ball","fas fa-shirt-running","far fa-shirt-running","fal fa-shirt-running","fas fa-shoe-prints","far fa-shoe-prints","fal fa-shoe-prints","fas fa-shuttlecock","far fa-shuttlecock","fal fa-shuttlecock","fas fa-ski-boot","far fa-ski-boot","fal fa-ski-boot","fas fa-ski-boot-ski","far fa-ski-boot-ski","fal fa-ski-boot-ski","fas fa-spa","far fa-spa","fal fa-spa","fas fa-sportsball","far fa-sportsball","fal fa-sportsball","fas fa-stopwatch-20","far fa-stopwatch-20","fal fa-stopwatch-20","fas fa-table-tennis-paddle-ball","far fa-table-tennis-paddle-ball","fal fa-table-tennis-paddle-ball","fas fa-tennis-ball","far fa-tennis-ball","fal fa-tennis-ball","fas fa-uniform-martial-arts","far fa-uniform-martial-arts","fal fa-uniform-martial-arts","fas fa-volleyball","far fa-volleyball","fal fa-volleyball","fas fa-watch-apple","far fa-watch-apple","fal fa-watch-apple","fas fa-watch-fitness","far fa-watch-fitness","fal fa-watch-fitness","fas fa-wave-pulse","far fa-wave-pulse","fal fa-wave-pulse","fas fa-weight-hanging","far fa-weight-hanging","fal fa-weight-hanging","fas fa-whistle","far fa-whistle","fal fa-whistle","fas fa-wreath-laurel","far fa-wreath-laurel","fal fa-wreath-laurel"]},{"id":"mathematics","title":"Mathematics","icons":["fas fa-abacus","far fa-abacus","fal fa-abacus","fas fa-calculator","far fa-calculator","fal fa-calculator","fas fa-calculator-simple","far fa-calculator-simple","fal fa-calculator-simple","fas fa-circle-divide","far fa-circle-divide","fal fa-circle-divide","fas fa-circle-minus","far fa-circle-minus","fal fa-circle-minus","fas fa-circle-plus","far fa-circle-plus","fal fa-circle-plus","fas fa-circle-xmark","far fa-circle-xmark","fal fa-circle-xmark","fas fa-divide","far fa-divide","fal fa-divide","fas fa-empty-set","far fa-empty-set","fal fa-empty-set","fas fa-equals","far fa-equals","fal fa-equals","fas fa-function","far fa-function","fal fa-function","fas fa-greater-than","far fa-greater-than","fal fa-greater-than","fas fa-greater-than-equal","far fa-greater-than-equal","fal fa-greater-than-equal","fas fa-hexagon-divide","far fa-hexagon-divide","fal fa-hexagon-divide","fas fa-hexagon-minus","far fa-hexagon-minus","fal fa-hexagon-minus","fas fa-hexagon-plus","far fa-hexagon-plus","fal fa-hexagon-plus","fas fa-hexagon-xmark","far fa-hexagon-xmark","fal fa-hexagon-xmark","fas fa-infinity","far fa-infinity","fal fa-infinity","fas fa-integral","far fa-integral","fal fa-integral","fas fa-intersection","far fa-intersection","fal fa-intersection","fas fa-lambda","far fa-lambda","fal fa-lambda","fas fa-less-than","far fa-less-than","fal fa-less-than","fas fa-less-than-equal","far fa-less-than-equal","fal fa-less-than-equal","fas fa-minus","far fa-minus","fal fa-minus","fas fa-not-equal","far fa-not-equal","fal fa-not-equal","fas fa-octagon-divide","far fa-octagon-divide","fal fa-octagon-divide","fas fa-octagon-minus","far fa-octagon-minus","fal fa-octagon-minus","fas fa-octagon-plus","far fa-octagon-plus","fal fa-octagon-plus","fas fa-octagon-xmark","far fa-octagon-xmark","fal fa-octagon-xmark","fas fa-omega","far fa-omega","fal fa-omega","fas fa-percent","far fa-percent","fal fa-percent","fas fa-pi","far fa-pi","fal fa-pi","fas fa-plus","far fa-plus","fal fa-plus","fas fa-plus-minus","far fa-plus-minus","fal fa-plus-minus","fas fa-sigma","far fa-sigma","fal fa-sigma","fas fa-square-divide","far fa-square-divide","fal fa-square-divide","fas fa-square-minus","far fa-square-minus","fal fa-square-minus","fas fa-square-root","far fa-square-root","fal fa-square-root","fas fa-square-root-variable","far fa-square-root-variable","fal fa-square-root-variable","fas fa-square-xmark","far fa-square-xmark","fal fa-square-xmark","fas fa-subscript","far fa-subscript","fal fa-subscript","fas fa-superscript","far fa-superscript","fal fa-superscript","fas fa-tally","far fa-tally","fal fa-tally","fas fa-tally-1","far fa-tally-1","fal fa-tally-1","fas fa-tally-2","far fa-tally-2","fal fa-tally-2","fas fa-tally-3","far fa-tally-3","fal fa-tally-3","fas fa-tally-4","far fa-tally-4","fal fa-tally-4","fas fa-theta","far fa-theta","fal fa-theta","fas fa-tilde","far fa-tilde","fal fa-tilde","fas fa-union","far fa-union","fal fa-union","fas fa-value-absolute","far fa-value-absolute","fal fa-value-absolute","fas fa-watch-calculator","far fa-watch-calculator","fal fa-watch-calculator","fas fa-wave-sine","far fa-wave-sine","fal fa-wave-sine","fas fa-wave-square","far fa-wave-square","fal fa-wave-square","fas fa-wave-triangle","far fa-wave-triangle","fal fa-wave-triangle","fas fa-waves-sine","far fa-waves-sine","fal fa-waves-sine","fas fa-xmark","far fa-xmark","fal fa-xmark"]},{"id":"clothing-fashion","title":"Clothing + Fashion","icons":["fas fa-boot","far fa-boot","fal fa-boot","fas fa-boot-heeled","far fa-boot-heeled","fal fa-boot-heeled","fas fa-clothes-hanger","far fa-clothes-hanger","fal fa-clothes-hanger","fas fa-ear-muffs","far fa-ear-muffs","fal fa-ear-muffs","fas fa-glasses","far fa-glasses","fal fa-glasses","fas fa-glasses-round","far fa-glasses-round","fal fa-glasses-round","fas fa-graduation-cap","far fa-graduation-cap","fal fa-graduation-cap","fas fa-hat-beach","far fa-hat-beach","fal fa-hat-beach","fas fa-hat-cowboy","far fa-hat-cowboy","fal fa-hat-cowboy","fas fa-hat-cowboy-side","far fa-hat-cowboy-side","fal fa-hat-cowboy-side","fas fa-hat-santa","far fa-hat-santa","fal fa-hat-santa","fas fa-hat-winter","far fa-hat-winter","fal fa-hat-winter","fas fa-hat-witch","far fa-hat-witch","fal fa-hat-witch","fas fa-hat-wizard","far fa-hat-wizard","fal fa-hat-wizard","fas fa-hood-cloak","far fa-hood-cloak","fal fa-hood-cloak","fas fa-ice-skate","far fa-ice-skate","fal fa-ice-skate","fas fa-mitten","far fa-mitten","fal fa-mitten","fas fa-mustache","far fa-mustache","fal fa-mustache","fas fa-pipe-smoking","far fa-pipe-smoking","fal fa-pipe-smoking","fas fa-reel","far fa-reel","fal fa-reel","fas fa-scarf","far fa-scarf","fal fa-scarf","fas fa-shirt","far fa-shirt","fal fa-shirt","fas fa-shirt-long-sleeve","far fa-shirt-long-sleeve","fal fa-shirt-long-sleeve","fas fa-shirt-running","far fa-shirt-running","fal fa-shirt-running","fas fa-shirt-tank-top","far fa-shirt-tank-top","fal fa-shirt-tank-top","fas fa-shoe-prints","far fa-shoe-prints","fal fa-shoe-prints","fas fa-ski-boot","far fa-ski-boot","fal fa-ski-boot","fas fa-socks","far fa-socks","fal fa-socks","fas fa-stocking","far fa-stocking","fal fa-stocking","fas fa-sunglasses","far fa-sunglasses","fal fa-sunglasses","fas fa-uniform-martial-arts","far fa-uniform-martial-arts","fal fa-uniform-martial-arts","fas fa-user-tie","far fa-user-tie","fal fa-user-tie","fas fa-vest","far fa-vest","fal fa-vest","fas fa-vest-patches","far fa-vest-patches","fal fa-vest-patches"]},{"id":"text-formatting","title":"Text Formatting","icons":["fas fa-align-center","far fa-align-center","fal fa-align-center","fas fa-align-justify","far fa-align-justify","fal fa-align-justify","fas fa-align-left","far fa-align-left","fal fa-align-left","fas fa-align-right","far fa-align-right","fal fa-align-right","fas fa-align-slash","far fa-align-slash","fal fa-align-slash","fas fa-block-quote","far fa-block-quote","fal fa-block-quote","fas fa-bold","far fa-bold","fal fa-bold","fas fa-border-all","far fa-border-all","fal fa-border-all","fas fa-border-bottom","far fa-border-bottom","fal fa-border-bottom","fas fa-border-bottom-right","far fa-border-bottom-right","fal fa-border-bottom-right","fas fa-border-center-h","far fa-border-center-h","fal fa-border-center-h","fas fa-border-center-v","far fa-border-center-v","fal fa-border-center-v","fas fa-border-inner","far fa-border-inner","fal fa-border-inner","fas fa-border-left","far fa-border-left","fal fa-border-left","fas fa-border-none","far fa-border-none","fal fa-border-none","fas fa-border-outer","far fa-border-outer","fal fa-border-outer","fas fa-border-right","far fa-border-right","fal fa-border-right","fas fa-border-top","far fa-border-top","fal fa-border-top","fas fa-border-top-left","far fa-border-top-left","fal fa-border-top-left","fas fa-check","far fa-check","fal fa-check","fas fa-check-double","far fa-check-double","fal fa-check-double","fas fa-circle-check","far fa-circle-check","fal fa-circle-check","fas fa-columns-3","far fa-columns-3","fal fa-columns-3","fas fa-command","far fa-command","fal fa-command","fas fa-file-dashed-line","far fa-file-dashed-line","fal fa-file-dashed-line","fas fa-filter-circle-xmark","far fa-filter-circle-xmark","fal fa-filter-circle-xmark","fas fa-filter-list","far fa-filter-list","fal fa-filter-list","fas fa-filter-slash","far fa-filter-slash","fal fa-filter-slash","fas fa-filters","far fa-filters","fal fa-filters","fas fa-font","far fa-font","fal fa-font","fas fa-font-case","far fa-font-case","fal fa-font-case","fas fa-h1","far fa-h1","fal fa-h1","fas fa-h2","far fa-h2","fal fa-h2","fas fa-h3","far fa-h3","fal fa-h3","fas fa-h4","far fa-h4","fal fa-h4","fas fa-h5","far fa-h5","fal fa-h5","fas fa-h6","far fa-h6","fal fa-h6","fas fa-hashtag-lock","far fa-hashtag-lock","fal fa-hashtag-lock","fas fa-heading","far fa-heading","fal fa-heading","fas fa-highlighter","far fa-highlighter","fal fa-highlighter","fas fa-horizontal-rule","far fa-horizontal-rule","fal fa-horizontal-rule","fas fa-i-cursor","far fa-i-cursor","fal fa-i-cursor","fas fa-icons","far fa-icons","fal fa-icons","fas fa-indent","far fa-indent","fal fa-indent","fas fa-italic","far fa-italic","fal fa-italic","fas fa-kerning","far fa-kerning","fal fa-kerning","fas fa-line-columns","far fa-line-columns","fal fa-line-columns","fas fa-line-height","far fa-line-height","fal fa-line-height","fas fa-list","far fa-list","fal fa-list","fas fa-list-check","far fa-list-check","fal fa-list-check","fas fa-list-ol","far fa-list-ol","fal fa-list-ol","fas fa-list-ul","far fa-list-ul","fal fa-list-ul","fas fa-lock-a","far fa-lock-a","fal fa-lock-a","fas fa-lock-hashtag","far fa-lock-hashtag","fal fa-lock-hashtag","fas fa-outdent","far fa-outdent","fal fa-outdent","fas fa-overline","far fa-overline","fal fa-overline","fas fa-paragraph","far fa-paragraph","fal fa-paragraph","fas fa-paragraph-left","far fa-paragraph-left","fal fa-paragraph-left","fas fa-rectangle-list","far fa-rectangle-list","fal fa-rectangle-list","fas fa-spell-check","far fa-spell-check","fal fa-spell-check","fas fa-square-a-lock","far fa-square-a-lock","fal fa-square-a-lock","fas fa-square-check","far fa-square-check","fal fa-square-check","fas fa-square-list","far fa-square-list","fal fa-square-list","fas fa-strikethrough","far fa-strikethrough","fal fa-strikethrough","fas fa-subscript","far fa-subscript","fal fa-subscript","fas fa-superscript","far fa-superscript","fal fa-superscript","fas fa-symbols","far fa-symbols","fal fa-symbols","fas fa-table","far fa-table","fal fa-table","fas fa-table-cells","far fa-table-cells","fal fa-table-cells","fas fa-table-cells-column-lock","far fa-table-cells-column-lock","fal fa-table-cells-column-lock","fas fa-table-cells-column-unlock","far fa-table-cells-column-unlock","fal fa-table-cells-column-unlock","fas fa-table-cells-large","far fa-table-cells-large","fal fa-table-cells-large","fas fa-table-cells-lock","far fa-table-cells-lock","fal fa-table-cells-lock","fas fa-table-cells-row-lock","far fa-table-cells-row-lock","fal fa-table-cells-row-lock","fas fa-table-cells-row-unlock","far fa-table-cells-row-unlock","fal fa-table-cells-row-unlock","fas fa-table-cells-unlock","far fa-table-cells-unlock","fal fa-table-cells-unlock","fas fa-table-columns","far fa-table-columns","fal fa-table-columns","fas fa-table-layout","far fa-table-layout","fal fa-table-layout","fas fa-table-list","far fa-table-list","fal fa-table-list","fas fa-table-pivot","far fa-table-pivot","fal fa-table-pivot","fas fa-table-rows","far fa-table-rows","fal fa-table-rows","fas fa-text","far fa-text","fal fa-text","fas fa-text-height","far fa-text-height","fal fa-text-height","fas fa-text-size","far fa-text-size","fal fa-text-size","fas fa-text-slash","far fa-text-slash","fal fa-text-slash","fas fa-text-width","far fa-text-width","fal fa-text-width","fas fa-underline","far fa-underline","fal fa-underline"]},{"id":"emoji","title":"Emoji","icons":["fas fa-face-angry","far fa-face-angry","fal fa-face-angry","fas fa-face-angry-horns","far fa-face-angry-horns","fal fa-face-angry-horns","fas fa-face-anguished","far fa-face-anguished","fal fa-face-anguished","fas fa-face-anxious-sweat","far fa-face-anxious-sweat","fal fa-face-anxious-sweat","fas fa-face-astonished","far fa-face-astonished","fal fa-face-astonished","fas fa-face-awesome","far fa-face-awesome","fal fa-face-awesome","fas fa-face-beam-hand-over-mouth","far fa-face-beam-hand-over-mouth","fal fa-face-beam-hand-over-mouth","fas fa-face-clouds","far fa-face-clouds","fal fa-face-clouds","fas fa-face-confounded","far fa-face-confounded","fal fa-face-confounded","fas fa-face-confused","far fa-face-confused","fal fa-face-confused","fas fa-face-cowboy-hat","far fa-face-cowboy-hat","fal fa-face-cowboy-hat","fas fa-face-diagonal-mouth","far fa-face-diagonal-mouth","fal fa-face-diagonal-mouth","fas fa-face-disappointed","far fa-face-disappointed","fal fa-face-disappointed","fas fa-face-disguise","far fa-face-disguise","fal fa-face-disguise","fas fa-face-dizzy","far fa-face-dizzy","fal fa-face-dizzy","fas fa-face-dotted","far fa-face-dotted","fal fa-face-dotted","fas fa-face-downcast-sweat","far fa-face-downcast-sweat","fal fa-face-downcast-sweat","fas fa-face-drooling","far fa-face-drooling","fal fa-face-drooling","fas fa-face-exhaling","far fa-face-exhaling","fal fa-face-exhaling","fas fa-face-explode","far fa-face-explode","fal fa-face-explode","fas fa-face-expressionless","far fa-face-expressionless","fal fa-face-expressionless","fas fa-face-eyes-xmarks","far fa-face-eyes-xmarks","fal fa-face-eyes-xmarks","fas fa-face-fearful","far fa-face-fearful","fal fa-face-fearful","fas fa-face-flushed","far fa-face-flushed","fal fa-face-flushed","fas fa-face-frown","far fa-face-frown","fal fa-face-frown","fas fa-face-frown-open","far fa-face-frown-open","fal fa-face-frown-open","fas fa-face-frown-slight","far fa-face-frown-slight","fal fa-face-frown-slight","fas fa-face-glasses","far fa-face-glasses","fal fa-face-glasses","fas fa-face-grimace","far fa-face-grimace","fal fa-face-grimace","fas fa-face-grin","far fa-face-grin","fal fa-face-grin","fas fa-face-grin-beam","far fa-face-grin-beam","fal fa-face-grin-beam","fas fa-face-grin-beam-sweat","far fa-face-grin-beam-sweat","fal fa-face-grin-beam-sweat","fas fa-face-grin-hearts","far fa-face-grin-hearts","fal fa-face-grin-hearts","fas fa-face-grin-squint","far fa-face-grin-squint","fal fa-face-grin-squint","fas fa-face-grin-squint-tears","far fa-face-grin-squint-tears","fal fa-face-grin-squint-tears","fas fa-face-grin-stars","far fa-face-grin-stars","fal fa-face-grin-stars","fas fa-face-grin-tears","far fa-face-grin-tears","fal fa-face-grin-tears","fas fa-face-grin-tongue","far fa-face-grin-tongue","fal fa-face-grin-tongue","fas fa-face-grin-tongue-squint","far fa-face-grin-tongue-squint","fal fa-face-grin-tongue-squint","fas fa-face-grin-tongue-wink","far fa-face-grin-tongue-wink","fal fa-face-grin-tongue-wink","fas fa-face-grin-wide","far fa-face-grin-wide","fal fa-face-grin-wide","fas fa-face-grin-wink","far fa-face-grin-wink","fal fa-face-grin-wink","fas fa-face-hand-over-mouth","far fa-face-hand-over-mouth","fal fa-face-hand-over-mouth","fas fa-face-hand-peeking","far fa-face-hand-peeking","fal fa-face-hand-peeking","fas fa-face-hand-yawn","far fa-face-hand-yawn","fal fa-face-hand-yawn","fas fa-face-head-bandage","far fa-face-head-bandage","fal fa-face-head-bandage","fas fa-face-holding-back-tears","far fa-face-holding-back-tears","fal fa-face-holding-back-tears","fas fa-face-hushed","far fa-face-hushed","fal fa-face-hushed","fas fa-face-icicles","far fa-face-icicles","fal fa-face-icicles","fas fa-face-kiss","far fa-face-kiss","fal fa-face-kiss","fas fa-face-kiss-beam","far fa-face-kiss-beam","fal fa-face-kiss-beam","fas fa-face-kiss-closed-eyes","far fa-face-kiss-closed-eyes","fal fa-face-kiss-closed-eyes","fas fa-face-kiss-wink-heart","far fa-face-kiss-wink-heart","fal fa-face-kiss-wink-heart","fas fa-face-laugh","far fa-face-laugh","fal fa-face-laugh","fas fa-face-laugh-beam","far fa-face-laugh-beam","fal fa-face-laugh-beam","fas fa-face-laugh-squint","far fa-face-laugh-squint","fal fa-face-laugh-squint","fas fa-face-laugh-wink","far fa-face-laugh-wink","fal fa-face-laugh-wink","fas fa-face-lying","far fa-face-lying","fal fa-face-lying","fas fa-face-mask","far fa-face-mask","fal fa-face-mask","fas fa-face-meh","far fa-face-meh","fal fa-face-meh","fas fa-face-meh-blank","far fa-face-meh-blank","fal fa-face-meh-blank","fas fa-face-melting","far fa-face-melting","fal fa-face-melting","fas fa-face-monocle","far fa-face-monocle","fal fa-face-monocle","fas fa-face-nauseated","far fa-face-nauseated","fal fa-face-nauseated","fas fa-face-nose-steam","far fa-face-nose-steam","fal fa-face-nose-steam","fas fa-face-party","far fa-face-party","fal fa-face-party","fas fa-face-pensive","far fa-face-pensive","fal fa-face-pensive","fas fa-face-persevering","far fa-face-persevering","fal fa-face-persevering","fas fa-face-pleading","far fa-face-pleading","fal fa-face-pleading","fas fa-face-pouting","far fa-face-pouting","fal fa-face-pouting","fas fa-face-raised-eyebrow","far fa-face-raised-eyebrow","fal fa-face-raised-eyebrow","fas fa-face-relieved","far fa-face-relieved","fal fa-face-relieved","fas fa-face-rolling-eyes","far fa-face-rolling-eyes","fal fa-face-rolling-eyes","fas fa-face-sad-cry","far fa-face-sad-cry","fal fa-face-sad-cry","fas fa-face-sad-sweat","far fa-face-sad-sweat","fal fa-face-sad-sweat","fas fa-face-sad-tear","far fa-face-sad-tear","fal fa-face-sad-tear","fas fa-face-saluting","far fa-face-saluting","fal fa-face-saluting","fas fa-face-scream","far fa-face-scream","fal fa-face-scream","fas fa-face-shush","far fa-face-shush","fal fa-face-shush","fas fa-face-sleeping","far fa-face-sleeping","fal fa-face-sleeping","fas fa-face-sleepy","far fa-face-sleepy","fal fa-face-sleepy","fas fa-face-smile","far fa-face-smile","fal fa-face-smile","fas fa-face-smile-beam","far fa-face-smile-beam","fal fa-face-smile-beam","fas fa-face-smile-halo","far fa-face-smile-halo","fal fa-face-smile-halo","fas fa-face-smile-hearts","far fa-face-smile-hearts","fal fa-face-smile-hearts","fas fa-face-smile-horns","far fa-face-smile-horns","fal fa-face-smile-horns","fas fa-face-smile-relaxed","far fa-face-smile-relaxed","fal fa-face-smile-relaxed","fas fa-face-smile-tear","far fa-face-smile-tear","fal fa-face-smile-tear","fas fa-face-smile-tongue","far fa-face-smile-tongue","fal fa-face-smile-tongue","fas fa-face-smile-upside-down","far fa-face-smile-upside-down","fal fa-face-smile-upside-down","fas fa-face-smile-wink","far fa-face-smile-wink","fal fa-face-smile-wink","fas fa-face-smiling-hands","far fa-face-smiling-hands","fal fa-face-smiling-hands","fas fa-face-smirking","far fa-face-smirking","fal fa-face-smirking","fas fa-face-spiral-eyes","far fa-face-spiral-eyes","fal fa-face-spiral-eyes","fas fa-face-sunglasses","far fa-face-sunglasses","fal fa-face-sunglasses","fas fa-face-surprise","far fa-face-surprise","fal fa-face-surprise","fas fa-face-swear","far fa-face-swear","fal fa-face-swear","fas fa-face-thermometer","far fa-face-thermometer","fal fa-face-thermometer","fas fa-face-thinking","far fa-face-thinking","fal fa-face-thinking","fas fa-face-tired","far fa-face-tired","fal fa-face-tired","fas fa-face-tissue","far fa-face-tissue","fal fa-face-tissue","fas fa-face-tongue-money","far fa-face-tongue-money","fal fa-face-tongue-money","fas fa-face-tongue-sweat","far fa-face-tongue-sweat","fal fa-face-tongue-sweat","fas fa-face-unamused","far fa-face-unamused","fal fa-face-unamused","fas fa-face-vomit","far fa-face-vomit","fal fa-face-vomit","fas fa-face-weary","far fa-face-weary","fal fa-face-weary","fas fa-face-woozy","far fa-face-woozy","fal fa-face-woozy","fas fa-face-worried","far fa-face-worried","fal fa-face-worried","fas fa-face-zany","far fa-face-zany","fal fa-face-zany","fas fa-face-zipper","far fa-face-zipper","fal fa-face-zipper"]},{"id":"shopping","title":"Shopping","icons":["fab fa-alipay","fab fa-amazon-pay","fab fa-apple-pay","fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-badge-dollar","far fa-badge-dollar","fal fa-badge-dollar","fas fa-badge-percent","far fa-badge-percent","fal fa-badge-percent","fas fa-bag-shopping","far fa-bag-shopping","fal fa-bag-shopping","fas fa-bag-shopping-minus","far fa-bag-shopping-minus","fal fa-bag-shopping-minus","fas fa-bag-shopping-plus","far fa-bag-shopping-plus","fal fa-bag-shopping-plus","fas fa-bags-shopping","far fa-bags-shopping","fal fa-bags-shopping","fas fa-balloon","far fa-balloon","fal fa-balloon","fas fa-balloons","far fa-balloons","fal fa-balloons","fas fa-barcode","far fa-barcode","fal fa-barcode","fas fa-barcode-read","far fa-barcode-read","fal fa-barcode-read","fas fa-barcode-scan","far fa-barcode-scan","fal fa-barcode-scan","fas fa-basket-shopping","far fa-basket-shopping","fal fa-basket-shopping","fas fa-basket-shopping-minus","far fa-basket-shopping-minus","fal fa-basket-shopping-minus","fas fa-basket-shopping-plus","far fa-basket-shopping-plus","fal fa-basket-shopping-plus","fas fa-basket-shopping-simple","far fa-basket-shopping-simple","fal fa-basket-shopping-simple","fas fa-bell","far fa-bell","fal fa-bell","fab fa-bitcoin","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fas fa-booth-curtain","far fa-booth-curtain","fal fa-booth-curtain","fas fa-box-open-full","far fa-box-open-full","fal fa-box-open-full","fab fa-btc","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-caduceus","far fa-caduceus","fal fa-caduceus","fas fa-camera","far fa-camera","fal fa-camera","fas fa-camera-retro","far fa-camera-retro","fal fa-camera-retro","fas fa-cart-arrow-down","far fa-cart-arrow-down","fal fa-cart-arrow-down","fas fa-cart-arrow-up","far fa-cart-arrow-up","fal fa-cart-arrow-up","fas fa-cart-circle-arrow-down","far fa-cart-circle-arrow-down","fal fa-cart-circle-arrow-down","fas fa-cart-circle-arrow-up","far fa-cart-circle-arrow-up","fal fa-cart-circle-arrow-up","fas fa-cart-circle-check","far fa-cart-circle-check","fal fa-cart-circle-check","fas fa-cart-circle-exclamation","far fa-cart-circle-exclamation","fal fa-cart-circle-exclamation","fas fa-cart-circle-plus","far fa-cart-circle-plus","fal fa-cart-circle-plus","fas fa-cart-circle-xmark","far fa-cart-circle-xmark","fal fa-cart-circle-xmark","fas fa-cart-minus","far fa-cart-minus","fal fa-cart-minus","fas fa-cart-plus","far fa-cart-plus","fal fa-cart-plus","fas fa-cart-shopping","far fa-cart-shopping","fal fa-cart-shopping","fas fa-cart-shopping-fast","far fa-cart-shopping-fast","fal fa-cart-shopping-fast","fas fa-cart-xmark","far fa-cart-xmark","fal fa-cart-xmark","fas fa-cash-register","far fa-cash-register","fal fa-cash-register","fab fa-cc-amazon-pay","fab fa-cc-amex","fab fa-cc-apple-pay","fab fa-cc-diners-club","fab fa-cc-discover","fab fa-cc-jcb","fab fa-cc-mastercard","fab fa-cc-paypal","fab fa-cc-stripe","fab fa-cc-visa","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-credit-card","far fa-credit-card","fal fa-credit-card","fas fa-credit-card-blank","far fa-credit-card-blank","fal fa-credit-card-blank","fas fa-credit-card-front","far fa-credit-card-front","fal fa-credit-card-front","fab fa-ethereum","fas fa-gem","far fa-gem","fal fa-gem","fas fa-gift","far fa-gift","fal fa-gift","fas fa-gift-card","far fa-gift-card","fal fa-gift-card","fas fa-gifts","far fa-gifts","fal fa-gifts","fab fa-google-pay","fab fa-google-wallet","fas fa-hand-holding-box","far fa-hand-holding-box","fal fa-hand-holding-box","fas fa-handshake","far fa-handshake","fal fa-handshake","fas fa-heart","far fa-heart","fal fa-heart","fas fa-hexagon-image","far fa-hexagon-image","fal fa-hexagon-image","fas fa-hexagon-vertical-nft","far fa-hexagon-vertical-nft","fal fa-hexagon-vertical-nft","fas fa-hexagon-vertical-nft-slanted","far fa-hexagon-vertical-nft-slanted","fal fa-hexagon-vertical-nft-slanted","fas fa-key","far fa-key","fal fa-key","fas fa-mobile-signal","far fa-mobile-signal","fal fa-mobile-signal","fas fa-mobile-signal-out","far fa-mobile-signal-out","fal fa-mobile-signal-out","fas fa-money-check","far fa-money-check","fal fa-money-check","fas fa-money-check-dollar","far fa-money-check-dollar","fal fa-money-check-dollar","fas fa-money-check-dollar-pen","far fa-money-check-dollar-pen","fal fa-money-check-dollar-pen","fas fa-money-check-pen","far fa-money-check-pen","fal fa-money-check-pen","fas fa-moped","far fa-moped","fal fa-moped","fas fa-nfc","far fa-nfc","fal fa-nfc","fab fa-nfc-directional","fas fa-nfc-lock","far fa-nfc-lock","fal fa-nfc-lock","fas fa-nfc-magnifying-glass","far fa-nfc-magnifying-glass","fal fa-nfc-magnifying-glass","fas fa-nfc-pen","far fa-nfc-pen","fal fa-nfc-pen","fas fa-nfc-signal","far fa-nfc-signal","fal fa-nfc-signal","fas fa-nfc-slash","far fa-nfc-slash","fal fa-nfc-slash","fas fa-nfc-symbol","far fa-nfc-symbol","fal fa-nfc-symbol","fab fa-nfc-symbol","fas fa-nfc-trash","far fa-nfc-trash","fal fa-nfc-trash","fab fa-paypal","fas fa-person-booth","far fa-person-booth","fal fa-person-booth","fas fa-receipt","far fa-receipt","fal fa-receipt","fas fa-rectangle-barcode","far fa-rectangle-barcode","fal fa-rectangle-barcode","fas fa-shirt","far fa-shirt","fal fa-shirt","fas fa-shop","far fa-shop","fal fa-shop","fas fa-shop-lock","far fa-shop-lock","fal fa-shop-lock","fas fa-shop-slash","far fa-shop-slash","fal fa-shop-slash","fas fa-star","far fa-star","fal fa-star","fas fa-star-exclamation","far fa-star-exclamation","fal fa-star-exclamation","fas fa-store","far fa-store","fal fa-store","fas fa-store-lock","far fa-store-lock","fal fa-store-lock","fas fa-store-slash","far fa-store-slash","fal fa-store-slash","fab fa-stripe","fab fa-stripe-s","fas fa-tag","far fa-tag","fal fa-tag","fas fa-tags","far fa-tags","fal fa-tags","fas fa-thumbs-down","far fa-thumbs-down","fal fa-thumbs-down","fas fa-thumbs-up","far fa-thumbs-up","fal fa-thumbs-up","fas fa-trophy","far fa-trophy","fal fa-trophy","fas fa-trophy-star","far fa-trophy-star","fal fa-trophy-star","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-bolt","far fa-truck-bolt","fal fa-truck-bolt","fas fa-truck-clock","far fa-truck-clock","fal fa-truck-clock","fas fa-truck-container","far fa-truck-container","fal fa-truck-container","fas fa-truck-fast","far fa-truck-fast","fal fa-truck-fast"]},{"id":"toggle","title":"Toggle","icons":["fas fa-brightness","far fa-brightness","fal fa-brightness","fas fa-brightness-low","far fa-brightness-low","fal fa-brightness-low","fas fa-bullseye","far fa-bullseye","fal fa-bullseye","fas fa-bullseye-arrow","far fa-bullseye-arrow","fal fa-bullseye-arrow","fas fa-circle","far fa-circle","fal fa-circle","fas fa-circle-check","far fa-circle-check","fal fa-circle-check","fas fa-circle-dot","far fa-circle-dot","fal fa-circle-dot","fas fa-dial","far fa-dial","fal fa-dial","fas fa-dial-high","far fa-dial-high","fal fa-dial-high","fas fa-dial-low","far fa-dial-low","fal fa-dial-low","fas fa-dial-max","far fa-dial-max","fal fa-dial-max","fas fa-dial-med","far fa-dial-med","fal fa-dial-med","fas fa-dial-med-low","far fa-dial-med-low","fal fa-dial-med-low","fas fa-dial-min","far fa-dial-min","fal fa-dial-min","fas fa-dial-off","far fa-dial-off","fal fa-dial-off","fas fa-keyboard-brightness","far fa-keyboard-brightness","fal fa-keyboard-brightness","fas fa-keyboard-brightness-low","far fa-keyboard-brightness-low","fal fa-keyboard-brightness-low","fas fa-location-crosshairs","far fa-location-crosshairs","fal fa-location-crosshairs","fas fa-location-crosshairs-slash","far fa-location-crosshairs-slash","fal fa-location-crosshairs-slash","fas fa-microphone","far fa-microphone","fal fa-microphone","fas fa-microphone-slash","far fa-microphone-slash","fal fa-microphone-slash","fas fa-plane-up","far fa-plane-up","fal fa-plane-up","fas fa-plane-up-slash","far fa-plane-up-slash","fal fa-plane-up-slash","fas fa-signal","far fa-signal","fal fa-signal","fas fa-signal-bars","far fa-signal-bars","fal fa-signal-bars","fas fa-signal-bars-fair","far fa-signal-bars-fair","fal fa-signal-bars-fair","fas fa-signal-bars-good","far fa-signal-bars-good","fal fa-signal-bars-good","fas fa-signal-bars-slash","far fa-signal-bars-slash","fal fa-signal-bars-slash","fas fa-signal-bars-weak","far fa-signal-bars-weak","fal fa-signal-bars-weak","fas fa-signal-fair","far fa-signal-fair","fal fa-signal-fair","fas fa-signal-good","far fa-signal-good","fal fa-signal-good","fas fa-signal-slash","far fa-signal-slash","fal fa-signal-slash","fas fa-signal-strong","far fa-signal-strong","fal fa-signal-strong","fas fa-signal-weak","far fa-signal-weak","fal fa-signal-weak","fas fa-slider","far fa-slider","fal fa-slider","fas fa-sliders-simple","far fa-sliders-simple","fal fa-sliders-simple","fas fa-star","far fa-star","fal fa-star","fas fa-star-half","far fa-star-half","fal fa-star-half","fas fa-star-half-stroke","far fa-star-half-stroke","fal fa-star-half-stroke","fas fa-toggle-large-off","far fa-toggle-large-off","fal fa-toggle-large-off","fas fa-toggle-large-on","far fa-toggle-large-on","fal fa-toggle-large-on","fas fa-toggle-off","far fa-toggle-off","fal fa-toggle-off","fas fa-toggle-on","far fa-toggle-on","fal fa-toggle-on","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wifi-exclamation","far fa-wifi-exclamation","fal fa-wifi-exclamation","fas fa-wifi-fair","far fa-wifi-fair","fal fa-wifi-fair","fas fa-wifi-slash","far fa-wifi-slash","fal fa-wifi-slash","fas fa-wifi-weak","far fa-wifi-weak","fal fa-wifi-weak"]},{"id":"media-playback","title":"Media Playback","icons":["fas fa-arrow-rotate-left","far fa-arrow-rotate-left","fal fa-arrow-rotate-left","fas fa-arrow-rotate-right","far fa-arrow-rotate-right","fal fa-arrow-rotate-right","fas fa-arrows-maximize","far fa-arrows-maximize","fal fa-arrows-maximize","fas fa-arrows-repeat","far fa-arrows-repeat","fal fa-arrows-repeat","fas fa-arrows-repeat-1","far fa-arrows-repeat-1","fal fa-arrows-repeat-1","fas fa-arrows-rotate","far fa-arrows-rotate","fal fa-arrows-rotate","fas fa-arrows-rotate-reverse","far fa-arrows-rotate-reverse","fal fa-arrows-rotate-reverse","fas fa-backward","far fa-backward","fal fa-backward","fas fa-backward-fast","far fa-backward-fast","fal fa-backward-fast","fas fa-backward-step","far fa-backward-step","fal fa-backward-step","fas fa-circle-pause","far fa-circle-pause","fal fa-circle-pause","fas fa-circle-play","far fa-circle-play","fal fa-circle-play","fas fa-circle-stop","far fa-circle-stop","fal fa-circle-stop","fas fa-compress","far fa-compress","fal fa-compress","fas fa-compress-wide","far fa-compress-wide","fal fa-compress-wide","fas fa-down-left-and-up-right-to-center","far fa-down-left-and-up-right-to-center","fal fa-down-left-and-up-right-to-center","fas fa-eject","far fa-eject","fal fa-eject","fas fa-expand","far fa-expand","fal fa-expand","fas fa-expand-wide","far fa-expand-wide","fal fa-expand-wide","fas fa-forward","far fa-forward","fal fa-forward","fas fa-forward-fast","far fa-forward-fast","fal fa-forward-fast","fas fa-forward-step","far fa-forward-step","fal fa-forward-step","fas fa-hand","far fa-hand","fal fa-hand","fas fa-maximize","far fa-maximize","fal fa-maximize","fas fa-minimize","far fa-minimize","fal fa-minimize","fas fa-music","far fa-music","fal fa-music","fas fa-pause","far fa-pause","fal fa-pause","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-play","far fa-play","fal fa-play","fas fa-play-pause","far fa-play-pause","fal fa-play-pause","fas fa-plus-minus","far fa-plus-minus","fal fa-plus-minus","fas fa-repeat","far fa-repeat","fal fa-repeat","fas fa-repeat-1","far fa-repeat-1","fal fa-repeat-1","fas fa-rotate","far fa-rotate","fal fa-rotate","fas fa-rotate-left","far fa-rotate-left","fal fa-rotate-left","fas fa-rotate-reverse","far fa-rotate-reverse","fal fa-rotate-reverse","fas fa-rotate-right","far fa-rotate-right","fal fa-rotate-right","fas fa-rss","far fa-rss","fal fa-rss","fas fa-scrubber","far fa-scrubber","fal fa-scrubber","fas fa-shuffle","far fa-shuffle","fal fa-shuffle","fas fa-sliders","far fa-sliders","fal fa-sliders","fas fa-sliders-up","far fa-sliders-up","fal fa-sliders-up","fas fa-stop","far fa-stop","fal fa-stop","fas fa-subtitles","far fa-subtitles","fal fa-subtitles","fas fa-subtitles-slash","far fa-subtitles-slash","fal fa-subtitles-slash","fas fa-up-right-and-down-left-from-center","far fa-up-right-and-down-left-from-center","fal fa-up-right-and-down-left-from-center","fas fa-volume","far fa-volume","fal fa-volume","fas fa-volume-high","far fa-volume-high","fal fa-volume-high","fas fa-volume-low","far fa-volume-low","fal fa-volume-low","fas fa-volume-off","far fa-volume-off","fal fa-volume-off","fas fa-volume-slash","far fa-volume-slash","fal fa-volume-slash","fas fa-volume-xmark","far fa-volume-xmark","fal fa-volume-xmark"]},{"id":"holidays","title":"Holidays","icons":["fas fa-angel","far fa-angel","fal fa-angel","fas fa-bells","far fa-bells","fal fa-bells","fas fa-calendar-heart","far fa-calendar-heart","fal fa-calendar-heart","fas fa-candy-cane","far fa-candy-cane","fal fa-candy-cane","fas fa-carrot","far fa-carrot","fal fa-carrot","fas fa-champagne-glass","far fa-champagne-glass","fal fa-champagne-glass","fas fa-champagne-glasses","far fa-champagne-glasses","fal fa-champagne-glasses","fas fa-chestnut","far fa-chestnut","fal fa-chestnut","fas fa-cookie-bite","far fa-cookie-bite","fal fa-cookie-bite","fas fa-cupcake","far fa-cupcake","fal fa-cupcake","fas fa-deer","far fa-deer","fal fa-deer","fas fa-deer-rudolph","far fa-deer-rudolph","fal fa-deer-rudolph","fas fa-dreidel","far fa-dreidel","fal fa-dreidel","fas fa-face-grin-hearts","far fa-face-grin-hearts","fal fa-face-grin-hearts","fas fa-face-kiss-wink-heart","far fa-face-kiss-wink-heart","fal fa-face-kiss-wink-heart","fas fa-fireplace","far fa-fireplace","fal fa-fireplace","fas fa-gift","far fa-gift","fal fa-gift","fas fa-gifts","far fa-gifts","fal fa-gifts","fas fa-gingerbread-man","far fa-gingerbread-man","fal fa-gingerbread-man","fas fa-hat-santa","far fa-hat-santa","fal fa-hat-santa","fas fa-head-side-heart","far fa-head-side-heart","fal fa-head-side-heart","fas fa-heart","far fa-heart","fal fa-heart","fas fa-holly-berry","far fa-holly-berry","fal fa-holly-berry","fas fa-jack-o-lantern","far fa-jack-o-lantern","fal fa-jack-o-lantern","fas fa-lights-holiday","far fa-lights-holiday","fal fa-lights-holiday","fas fa-menorah","far fa-menorah","fal fa-menorah","fas fa-mistletoe","far fa-mistletoe","fal fa-mistletoe","fas fa-mug-hot","far fa-mug-hot","fal fa-mug-hot","fas fa-narwhal","far fa-narwhal","fal fa-narwhal","fas fa-ornament","far fa-ornament","fal fa-ornament","fas fa-party-bell","far fa-party-bell","fal fa-party-bell","fas fa-party-horn","far fa-party-horn","fal fa-party-horn","fas fa-pinata","far fa-pinata","fal fa-pinata","fas fa-ring-diamond","far fa-ring-diamond","fal fa-ring-diamond","fas fa-rings-wedding","far fa-rings-wedding","fal fa-rings-wedding","fas fa-rv","far fa-rv","fal fa-rv","fas fa-sleigh","far fa-sleigh","fal fa-sleigh","fas fa-snowman","far fa-snowman","fal fa-snowman","fas fa-snowman-head","far fa-snowman-head","fal fa-snowman-head","fas fa-star-christmas","far fa-star-christmas","fal fa-star-christmas","fas fa-stocking","far fa-stocking","fal fa-stocking","fas fa-tree-christmas","far fa-tree-christmas","fal fa-tree-christmas","fas fa-tree-decorated","far fa-tree-decorated","fal fa-tree-decorated","fas fa-turkey","far fa-turkey","fal fa-turkey","fas fa-wreath","far fa-wreath","fal fa-wreath"]},{"id":"childhood","title":"Childhood","icons":["fas fa-apple-whole","far fa-apple-whole","fal fa-apple-whole","fas fa-baby","far fa-baby","fal fa-baby","fas fa-baby-carriage","far fa-baby-carriage","fal fa-baby-carriage","fas fa-backpack","far fa-backpack","fal fa-backpack","fas fa-ball-pile","far fa-ball-pile","fal fa-ball-pile","fas fa-balloon","far fa-balloon","fal fa-balloon","fas fa-balloons","far fa-balloons","fal fa-balloons","fas fa-baseball-bat-ball","far fa-baseball-bat-ball","fal fa-baseball-bat-ball","fas fa-basketball-hoop","far fa-basketball-hoop","fal fa-basketball-hoop","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bell-school","far fa-bell-school","fal fa-bell-school","fas fa-bell-school-slash","far fa-bell-school-slash","fal fa-bell-school-slash","fas fa-block","far fa-block","fal fa-block","fas fa-block-question","far fa-block-question","fal fa-block-question","fas fa-bottle-baby","far fa-bottle-baby","fal fa-bottle-baby","fas fa-bowl-soft-serve","far fa-bowl-soft-serve","fal fa-bowl-soft-serve","fas fa-bucket","far fa-bucket","fal fa-bucket","fas fa-cake-candles","far fa-cake-candles","fal fa-cake-candles","fas fa-cake-slice","far fa-cake-slice","fal fa-cake-slice","fas fa-candy","far fa-candy","fal fa-candy","fas fa-candy-bar","far fa-candy-bar","fal fa-candy-bar","fas fa-child","far fa-child","fal fa-child","fas fa-child-dress","far fa-child-dress","fal fa-child-dress","fas fa-child-reaching","far fa-child-reaching","fal fa-child-reaching","fas fa-children","far fa-children","fal fa-children","fas fa-cookie","far fa-cookie","fal fa-cookie","fas fa-cookie-bite","far fa-cookie-bite","fal fa-cookie-bite","fas fa-court-sport","far fa-court-sport","fal fa-court-sport","fas fa-cubes-stacked","far fa-cubes-stacked","fal fa-cubes-stacked","fas fa-cupcake","far fa-cupcake","fal fa-cupcake","fas fa-duck","far fa-duck","fal fa-duck","fas fa-family","far fa-family","fal fa-family","fas fa-family-dress","far fa-family-dress","fal fa-family-dress","fas fa-family-pants","far fa-family-pants","fal fa-family-pants","fas fa-ferris-wheel","far fa-ferris-wheel","fal fa-ferris-wheel","fas fa-flashlight","far fa-flashlight","fal fa-flashlight","fas fa-game-console-handheld","far fa-game-console-handheld","fal fa-game-console-handheld","fas fa-gamepad","far fa-gamepad","fal fa-gamepad","fas fa-gamepad-modern","far fa-gamepad-modern","fal fa-gamepad-modern","fas fa-globe-snow","far fa-globe-snow","fal fa-globe-snow","fas fa-gun-squirt","far fa-gun-squirt","fal fa-gun-squirt","fas fa-hands-holding-child","far fa-hands-holding-child","fal fa-hands-holding-child","fas fa-ice-cream","far fa-ice-cream","fal fa-ice-cream","fas fa-lollipop","far fa-lollipop","fal fa-lollipop","fas fa-mitten","far fa-mitten","fal fa-mitten","fas fa-person-biking","far fa-person-biking","fal fa-person-biking","fas fa-person-breastfeeding","far fa-person-breastfeeding","fal fa-person-breastfeeding","fas fa-person-sledding","far fa-person-sledding","fal fa-person-sledding","fas fa-pinata","far fa-pinata","fal fa-pinata","fas fa-pool-8-ball","far fa-pool-8-ball","fal fa-pool-8-ball","fas fa-popsicle","far fa-popsicle","fal fa-popsicle","fas fa-pretzel","far fa-pretzel","fal fa-pretzel","fas fa-puzzle","far fa-puzzle","fal fa-puzzle","fas fa-puzzle-piece","far fa-puzzle-piece","fal fa-puzzle-piece","fas fa-robot","far fa-robot","fal fa-robot","fas fa-roller-coaster","far fa-roller-coaster","fal fa-roller-coaster","fas fa-school","far fa-school","fal fa-school","fas fa-shapes","far fa-shapes","fal fa-shapes","fas fa-snowman","far fa-snowman","fal fa-snowman","fas fa-snowman-head","far fa-snowman-head","fal fa-snowman-head","fas fa-soft-serve","far fa-soft-serve","fal fa-soft-serve","fas fa-teddy-bear","far fa-teddy-bear","fal fa-teddy-bear","fas fa-thought-bubble","far fa-thought-bubble","fal fa-thought-bubble","fas fa-tricycle","far fa-tricycle","fal fa-tricycle"]},{"id":"photos-images","title":"Photos + Images","icons":["fas fa-360-degrees","far fa-360-degrees","fal fa-360-degrees","fas fa-aperture","far fa-aperture","fal fa-aperture","fas fa-bolt","far fa-bolt","fal fa-bolt","fas fa-bolt-auto","far fa-bolt-auto","fal fa-bolt-auto","fas fa-bolt-lightning","far fa-bolt-lightning","fal fa-bolt-lightning","fas fa-bolt-slash","far fa-bolt-slash","fal fa-bolt-slash","fas fa-camera","far fa-camera","fal fa-camera","fas fa-camera-polaroid","far fa-camera-polaroid","fal fa-camera-polaroid","fas fa-camera-retro","far fa-camera-retro","fal fa-camera-retro","fas fa-camera-rotate","far fa-camera-rotate","fal fa-camera-rotate","fas fa-camera-slash","far fa-camera-slash","fal fa-camera-slash","fas fa-camera-viewfinder","far fa-camera-viewfinder","fal fa-camera-viewfinder","fas fa-chalkboard","far fa-chalkboard","fal fa-chalkboard","fas fa-circle-camera","far fa-circle-camera","fal fa-circle-camera","fas fa-circle-half-stroke","far fa-circle-half-stroke","fal fa-circle-half-stroke","fas fa-clone","far fa-clone","fal fa-clone","fas fa-comment-image","far fa-comment-image","fal fa-comment-image","fas fa-droplet","far fa-droplet","fal fa-droplet","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-face-viewfinder","far fa-face-viewfinder","fal fa-face-viewfinder","fas fa-file-image","far fa-file-image","fal fa-file-image","fas fa-file-jpg","far fa-file-jpg","fal fa-file-jpg","fas fa-file-png","far fa-file-png","fal fa-file-png","fas fa-film","far fa-film","fal fa-film","fas fa-film-canister","far fa-film-canister","fal fa-film-canister","fas fa-film-simple","far fa-film-simple","fal fa-film-simple","fas fa-film-slash","far fa-film-slash","fal fa-film-slash","fas fa-films","far fa-films","fal fa-films","fas fa-folder-image","far fa-folder-image","fal fa-folder-image","fas fa-gif","far fa-gif","fal fa-gif","fas fa-hexagon-image","far fa-hexagon-image","fal fa-hexagon-image","fas fa-high-definition","far fa-high-definition","fal fa-high-definition","fas fa-id-badge","far fa-id-badge","fal fa-id-badge","fas fa-id-card","far fa-id-card","fal fa-id-card","fas fa-image","far fa-image","fal fa-image","fas fa-image-landscape","far fa-image-landscape","fal fa-image-landscape","fas fa-image-polaroid","far fa-image-polaroid","fal fa-image-polaroid","fas fa-image-polaroid-user","far fa-image-polaroid-user","fal fa-image-polaroid-user","fas fa-image-portrait","far fa-image-portrait","fal fa-image-portrait","fas fa-image-slash","far fa-image-slash","fal fa-image-slash","fas fa-image-user","far fa-image-user","fal fa-image-user","fas fa-images","far fa-images","fal fa-images","fas fa-images-user","far fa-images-user","fal fa-images-user","fas fa-message-image","far fa-message-image","fal fa-message-image","fas fa-minimize","far fa-minimize","fal fa-minimize","fas fa-panorama","far fa-panorama","fal fa-panorama","fas fa-photo-film","far fa-photo-film","fal fa-photo-film","fas fa-photo-film-music","far fa-photo-film-music","fal fa-photo-film-music","fas fa-rectangle-history","far fa-rectangle-history","fal fa-rectangle-history","fas fa-rectangle-history-circle-plus","far fa-rectangle-history-circle-plus","fal fa-rectangle-history-circle-plus","fas fa-rectangle-history-circle-user","far fa-rectangle-history-circle-user","fal fa-rectangle-history-circle-user","fas fa-rectangle-vertical-history","far fa-rectangle-vertical-history","fal fa-rectangle-vertical-history","fas fa-sliders","far fa-sliders","fal fa-sliders","fas fa-sliders-up","far fa-sliders-up","fal fa-sliders-up","fas fa-square-sliders","far fa-square-sliders","fal fa-square-sliders","fas fa-square-sliders-vertical","far fa-square-sliders-vertical","fal fa-square-sliders-vertical","fas fa-standard-definition","far fa-standard-definition","fal fa-standard-definition","fab fa-unsplash"]},{"id":"weather","title":"Weather","icons":["fas fa-bolt","far fa-bolt","fal fa-bolt","fas fa-bolt-lightning","far fa-bolt-lightning","fal fa-bolt-lightning","fas fa-cloud","far fa-cloud","fal fa-cloud","fas fa-cloud-bolt","far fa-cloud-bolt","fal fa-cloud-bolt","fas fa-cloud-bolt-moon","far fa-cloud-bolt-moon","fal fa-cloud-bolt-moon","fas fa-cloud-bolt-sun","far fa-cloud-bolt-sun","fal fa-cloud-bolt-sun","fas fa-cloud-drizzle","far fa-cloud-drizzle","fal fa-cloud-drizzle","fas fa-cloud-fog","far fa-cloud-fog","fal fa-cloud-fog","fas fa-cloud-hail","far fa-cloud-hail","fal fa-cloud-hail","fas fa-cloud-hail-mixed","far fa-cloud-hail-mixed","fal fa-cloud-hail-mixed","fas fa-cloud-meatball","far fa-cloud-meatball","fal fa-cloud-meatball","fas fa-cloud-moon","far fa-cloud-moon","fal fa-cloud-moon","fas fa-cloud-moon-rain","far fa-cloud-moon-rain","fal fa-cloud-moon-rain","fas fa-cloud-rain","far fa-cloud-rain","fal fa-cloud-rain","fas fa-cloud-rainbow","far fa-cloud-rainbow","fal fa-cloud-rainbow","fas fa-cloud-showers","far fa-cloud-showers","fal fa-cloud-showers","fas fa-cloud-showers-heavy","far fa-cloud-showers-heavy","fal fa-cloud-showers-heavy","fas fa-cloud-showers-water","far fa-cloud-showers-water","fal fa-cloud-showers-water","fas fa-cloud-sleet","far fa-cloud-sleet","fal fa-cloud-sleet","fas fa-cloud-snow","far fa-cloud-snow","fal fa-cloud-snow","fas fa-cloud-sun","far fa-cloud-sun","fal fa-cloud-sun","fas fa-cloud-sun-rain","far fa-cloud-sun-rain","fal fa-cloud-sun-rain","fas fa-clouds","far fa-clouds","fal fa-clouds","fas fa-clouds-moon","far fa-clouds-moon","fal fa-clouds-moon","fas fa-clouds-sun","far fa-clouds-sun","fal fa-clouds-sun","fas fa-droplet-degree","far fa-droplet-degree","fal fa-droplet-degree","fas fa-droplet-percent","far fa-droplet-percent","fal fa-droplet-percent","fas fa-eclipse","far fa-eclipse","fal fa-eclipse","fas fa-fire-smoke","far fa-fire-smoke","fal fa-fire-smoke","fas fa-heat","far fa-heat","fal fa-heat","fas fa-house-tsunami","far fa-house-tsunami","fal fa-house-tsunami","fas fa-house-water","far fa-house-water","fal fa-house-water","fas fa-hurricane","far fa-hurricane","fal fa-hurricane","fas fa-icicles","far fa-icicles","fal fa-icicles","fas fa-meteor","far fa-meteor","fal fa-meteor","fas fa-moon","far fa-moon","fal fa-moon","fas fa-moon-cloud","far fa-moon-cloud","fal fa-moon-cloud","fas fa-moon-over-sun","far fa-moon-over-sun","fal fa-moon-over-sun","fas fa-moon-stars","far fa-moon-stars","fal fa-moon-stars","fas fa-poo-storm","far fa-poo-storm","fal fa-poo-storm","fas fa-rainbow","far fa-rainbow","fal fa-rainbow","fas fa-raindrops","far fa-raindrops","fal fa-raindrops","fas fa-smog","far fa-smog","fal fa-smog","fas fa-smoke","far fa-smoke","fal fa-smoke","fas fa-snow-blowing","far fa-snow-blowing","fal fa-snow-blowing","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-snowflake-droplets","far fa-snowflake-droplets","fal fa-snowflake-droplets","fas fa-snowflakes","far fa-snowflakes","fal fa-snowflakes","fas fa-sparkle","far fa-sparkle","fal fa-sparkle","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-stars","far fa-stars","fal fa-stars","fas fa-sun","far fa-sun","fal fa-sun","fas fa-sun-bright","far fa-sun-bright","fal fa-sun-bright","fas fa-sun-cloud","far fa-sun-cloud","fal fa-sun-cloud","fas fa-sun-dust","far fa-sun-dust","fal fa-sun-dust","fas fa-sun-haze","far fa-sun-haze","fal fa-sun-haze","fas fa-sun-plant-wilt","far fa-sun-plant-wilt","fal fa-sun-plant-wilt","fas fa-sunrise","far fa-sunrise","fal fa-sunrise","fas fa-sunset","far fa-sunset","fal fa-sunset","fas fa-temperature-arrow-down","far fa-temperature-arrow-down","fal fa-temperature-arrow-down","fas fa-temperature-arrow-up","far fa-temperature-arrow-up","fal fa-temperature-arrow-up","fas fa-temperature-empty","far fa-temperature-empty","fal fa-temperature-empty","fas fa-temperature-full","far fa-temperature-full","fal fa-temperature-full","fas fa-temperature-half","far fa-temperature-half","fal fa-temperature-half","fas fa-temperature-high","far fa-temperature-high","fal fa-temperature-high","fas fa-temperature-list","far fa-temperature-list","fal fa-temperature-list","fas fa-temperature-low","far fa-temperature-low","fal fa-temperature-low","fas fa-temperature-quarter","far fa-temperature-quarter","fal fa-temperature-quarter","fas fa-temperature-snow","far fa-temperature-snow","fal fa-temperature-snow","fas fa-temperature-sun","far fa-temperature-sun","fal fa-temperature-sun","fas fa-temperature-three-quarters","far fa-temperature-three-quarters","fal fa-temperature-three-quarters","fas fa-tornado","far fa-tornado","fal fa-tornado","fas fa-umbrella","far fa-umbrella","fal fa-umbrella","fas fa-umbrella-simple","far fa-umbrella-simple","fal fa-umbrella-simple","fas fa-volcano","far fa-volcano","fal fa-volcano","fas fa-water","far fa-water","fal fa-water","fas fa-water-arrow-down","far fa-water-arrow-down","fal fa-water-arrow-down","fas fa-water-arrow-up","far fa-water-arrow-up","fal fa-water-arrow-up","fas fa-wave","far fa-wave","fal fa-wave","fas fa-wind","far fa-wind","fal fa-wind","fas fa-wind-warning","far fa-wind-warning","fal fa-wind-warning","fas fa-windsock","far fa-windsock","fal fa-windsock"]},{"id":"design","title":"Design","icons":["fas fa-angle","far fa-angle","fal fa-angle","fas fa-angle-90","far fa-angle-90","fal fa-angle-90","fas fa-ball-pile","far fa-ball-pile","fal fa-ball-pile","fas fa-bezier-curve","far fa-bezier-curve","fal fa-bezier-curve","fas fa-book-font","far fa-book-font","fal fa-book-font","fas fa-bring-forward","far fa-bring-forward","fal fa-bring-forward","fas fa-bring-front","far fa-bring-front","fal fa-bring-front","fas fa-broom-wide","far fa-broom-wide","fal fa-broom-wide","fas fa-brush","far fa-brush","fal fa-brush","fas fa-camera-polaroid","far fa-camera-polaroid","fal fa-camera-polaroid","fas fa-circle-dashed","far fa-circle-dashed","fal fa-circle-dashed","fas fa-circle-half-stroke","far fa-circle-half-stroke","fal fa-circle-half-stroke","fas fa-circle-nodes","far fa-circle-nodes","fal fa-circle-nodes","fas fa-circle-quarter-stroke","far fa-circle-quarter-stroke","fal fa-circle-quarter-stroke","fas fa-circle-three-quarters-stroke","far fa-circle-three-quarters-stroke","fal fa-circle-three-quarters-stroke","fas fa-circles-overlap","far fa-circles-overlap","fal fa-circles-overlap","fas fa-clone","far fa-clone","fal fa-clone","fas fa-columns-3","far fa-columns-3","fal fa-columns-3","fas fa-compass-drafting","far fa-compass-drafting","fal fa-compass-drafting","fas fa-copy","far fa-copy","fal fa-copy","fas fa-crop","far fa-crop","fal fa-crop","fas fa-crop-simple","far fa-crop-simple","fal fa-crop-simple","fas fa-crosshairs","far fa-crosshairs","fal fa-crosshairs","fas fa-crosshairs-simple","far fa-crosshairs-simple","fal fa-crosshairs-simple","fas fa-cube","far fa-cube","fal fa-cube","fas fa-cubes","far fa-cubes","fal fa-cubes","fas fa-diamonds-4","far fa-diamonds-4","fal fa-diamonds-4","fas fa-distribute-spacing-horizontal","far fa-distribute-spacing-horizontal","fal fa-distribute-spacing-horizontal","fas fa-distribute-spacing-vertical","far fa-distribute-spacing-vertical","fal fa-distribute-spacing-vertical","fas fa-draw-circle","far fa-draw-circle","fal fa-draw-circle","fas fa-draw-polygon","far fa-draw-polygon","fal fa-draw-polygon","fas fa-draw-square","far fa-draw-square","fal fa-draw-square","fas fa-droplet","far fa-droplet","fal fa-droplet","fas fa-droplet-slash","far fa-droplet-slash","fal fa-droplet-slash","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-eye-dropper-full","far fa-eye-dropper-full","fal fa-eye-dropper-full","fas fa-eye-dropper-half","far fa-eye-dropper-half","fal fa-eye-dropper-half","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-file-eps","far fa-file-eps","fal fa-file-eps","fas fa-file-gif","far fa-file-gif","fal fa-file-gif","fas fa-file-svg","far fa-file-svg","fal fa-file-svg","fas fa-file-vector","far fa-file-vector","fal fa-file-vector","fas fa-fill","far fa-fill","fal fa-fill","fas fa-fill-drip","far fa-fill-drip","fal fa-fill-drip","fas fa-floppy-disk","far fa-floppy-disk","fal fa-floppy-disk","fas fa-font-awesome","far fa-font-awesome","fal fa-font-awesome","fab fa-font-awesome","fas fa-frame","far fa-frame","fal fa-frame","fas fa-gallery-thumbnails","far fa-gallery-thumbnails","fal fa-gallery-thumbnails","fas fa-grid","far fa-grid","fal fa-grid","fas fa-grid-2","far fa-grid-2","fal fa-grid-2","fas fa-grid-2-plus","far fa-grid-2-plus","fal fa-grid-2-plus","fas fa-grid-4","far fa-grid-4","fal fa-grid-4","fas fa-grid-5","far fa-grid-5","fal fa-grid-5","fas fa-grid-dividers","far fa-grid-dividers","fal fa-grid-dividers","fas fa-grid-round","far fa-grid-round","fal fa-grid-round","fas fa-grid-round-2","far fa-grid-round-2","fal fa-grid-round-2","fas fa-grid-round-2-plus","far fa-grid-round-2-plus","fal fa-grid-round-2-plus","fas fa-grid-round-4","far fa-grid-round-4","fal fa-grid-round-4","fas fa-grid-round-5","far fa-grid-round-5","fal fa-grid-round-5","fas fa-hammer-brush","far fa-hammer-brush","fal fa-hammer-brush","fas fa-highlighter","far fa-highlighter","fal fa-highlighter","fas fa-highlighter-line","far fa-highlighter-line","fal fa-highlighter-line","fas fa-icons","far fa-icons","fal fa-icons","fas fa-image-polaroid","far fa-image-polaroid","fal fa-image-polaroid","fas fa-lasso","far fa-lasso","fal fa-lasso","fas fa-lasso-sparkles","far fa-lasso-sparkles","fal fa-lasso-sparkles","fas fa-layer-group","far fa-layer-group","fal fa-layer-group","fas fa-layer-minus","far fa-layer-minus","fal fa-layer-minus","fas fa-layer-plus","far fa-layer-plus","fal fa-layer-plus","fas fa-lines-leaning","far fa-lines-leaning","fal fa-lines-leaning","fas fa-marker","far fa-marker","fal fa-marker","fas fa-notebook","far fa-notebook","fal fa-notebook","fas fa-object-exclude","far fa-object-exclude","fal fa-object-exclude","fas fa-object-group","far fa-object-group","fal fa-object-group","fas fa-object-intersect","far fa-object-intersect","fal fa-object-intersect","fas fa-object-subtract","far fa-object-subtract","fal fa-object-subtract","fas fa-object-ungroup","far fa-object-ungroup","fal fa-object-ungroup","fas fa-object-union","far fa-object-union","fal fa-object-union","fas fa-objects-align-bottom","far fa-objects-align-bottom","fal fa-objects-align-bottom","fas fa-objects-align-center-horizontal","far fa-objects-align-center-horizontal","fal fa-objects-align-center-horizontal","fas fa-objects-align-center-vertical","far fa-objects-align-center-vertical","fal fa-objects-align-center-vertical","fas fa-objects-align-left","far fa-objects-align-left","fal fa-objects-align-left","fas fa-objects-align-right","far fa-objects-align-right","fal fa-objects-align-right","fas fa-objects-align-top","far fa-objects-align-top","fal fa-objects-align-top","fas fa-objects-column","far fa-objects-column","fal fa-objects-column","fas fa-paint-roller","far fa-paint-roller","fal fa-paint-roller","fas fa-paintbrush","far fa-paintbrush","fal fa-paintbrush","fas fa-paintbrush-fine","far fa-paintbrush-fine","fal fa-paintbrush-fine","fas fa-paintbrush-pencil","far fa-paintbrush-pencil","fal fa-paintbrush-pencil","fas fa-palette","far fa-palette","fal fa-palette","fas fa-paste","far fa-paste","fal fa-paste","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-circle","far fa-pen-circle","fal fa-pen-circle","fas fa-pen-clip","far fa-pen-clip","fal fa-pen-clip","fas fa-pen-fancy","far fa-pen-fancy","fal fa-pen-fancy","fas fa-pen-nib","far fa-pen-nib","fal fa-pen-nib","fas fa-pen-nib-slash","far fa-pen-nib-slash","fal fa-pen-nib-slash","fas fa-pen-ruler","far fa-pen-ruler","fal fa-pen-ruler","fas fa-pen-to-square","far fa-pen-to-square","fal fa-pen-to-square","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-mechanical","far fa-pencil-mechanical","fal fa-pencil-mechanical","fas fa-rectangle-pro","far fa-rectangle-pro","fal fa-rectangle-pro","fas fa-rectangles-mixed","far fa-rectangles-mixed","fal fa-rectangles-mixed","fas fa-reflect-both","far fa-reflect-both","fal fa-reflect-both","fas fa-reflect-horizontal","far fa-reflect-horizontal","fal fa-reflect-horizontal","fas fa-reflect-vertical","far fa-reflect-vertical","fal fa-reflect-vertical","fas fa-ruler-combined","far fa-ruler-combined","fal fa-ruler-combined","fas fa-ruler-horizontal","far fa-ruler-horizontal","fal fa-ruler-horizontal","fas fa-ruler-vertical","far fa-ruler-vertical","fal fa-ruler-vertical","fas fa-scanner-image","far fa-scanner-image","fal fa-scanner-image","fas fa-scissors","far fa-scissors","fal fa-scissors","fas fa-scribble","far fa-scribble","fal fa-scribble","fas fa-send-back","far fa-send-back","fal fa-send-back","fas fa-send-backward","far fa-send-backward","fal fa-send-backward","fas fa-sparkle","far fa-sparkle","fal fa-sparkle","fas fa-splotch","far fa-splotch","fal fa-splotch","fas fa-spray-can","far fa-spray-can","fal fa-spray-can","fas fa-square-dashed","far fa-square-dashed","fal fa-square-dashed","fas fa-square-dashed-circle-plus","far fa-square-dashed-circle-plus","fal fa-square-dashed-circle-plus","fas fa-stamp","far fa-stamp","fal fa-stamp","fas fa-stapler","far fa-stapler","fal fa-stapler","fas fa-swatchbook","far fa-swatchbook","fal fa-swatchbook","fas fa-symbols","far fa-symbols","fal fa-symbols","fas fa-vector-circle","far fa-vector-circle","fal fa-vector-circle","fas fa-vector-polygon","far fa-vector-polygon","fal fa-vector-polygon","fas fa-vector-square","far fa-vector-square","fal fa-vector-square","fas fa-wand-magic","far fa-wand-magic","fal fa-wand-magic","fas fa-wand-magic-sparkles","far fa-wand-magic-sparkles","fal fa-wand-magic-sparkles","fas fa-web-awesome","far fa-web-awesome","fal fa-web-awesome","fab fa-web-awesome","fas fa-wrench-simple","far fa-wrench-simple","fal fa-wrench-simple"]},{"id":"connectivity","title":"Connectivity","icons":["fas fa-bluetooth","far fa-bluetooth","fal fa-bluetooth","fab fa-bluetooth","fas fa-circle-nodes","far fa-circle-nodes","fal fa-circle-nodes","fas fa-circle-wifi","far fa-circle-wifi","fal fa-circle-wifi","fas fa-circle-wifi-circle-wifi","far fa-circle-wifi-circle-wifi","fal fa-circle-wifi-circle-wifi","fas fa-cloud","far fa-cloud","fal fa-cloud","fas fa-cloud-arrow-down","far fa-cloud-arrow-down","fal fa-cloud-arrow-down","fas fa-cloud-arrow-up","far fa-cloud-arrow-up","fal fa-cloud-arrow-up","fas fa-cloud-check","far fa-cloud-check","fal fa-cloud-check","fas fa-cloud-exclamation","far fa-cloud-exclamation","fal fa-cloud-exclamation","fas fa-cloud-minus","far fa-cloud-minus","fal fa-cloud-minus","fas fa-cloud-plus","far fa-cloud-plus","fal fa-cloud-plus","fas fa-cloud-question","far fa-cloud-question","fal fa-cloud-question","fas fa-cloud-slash","far fa-cloud-slash","fal fa-cloud-slash","fas fa-cloud-xmark","far fa-cloud-xmark","fal fa-cloud-xmark","fas fa-ethernet","far fa-ethernet","fal fa-ethernet","fas fa-globe","far fa-globe","fal fa-globe","fas fa-globe-pointer","far fa-globe-pointer","fal fa-globe-pointer","fas fa-globe-wifi","far fa-globe-wifi","fal fa-globe-wifi","fas fa-house-signal","far fa-house-signal","fal fa-house-signal","fas fa-link-horizontal","far fa-link-horizontal","fal fa-link-horizontal","fas fa-link-horizontal-slash","far fa-link-horizontal-slash","fal fa-link-horizontal-slash","fas fa-mobile-signal","far fa-mobile-signal","fal fa-mobile-signal","fas fa-mobile-signal-out","far fa-mobile-signal-out","fal fa-mobile-signal-out","fas fa-nfc-signal","far fa-nfc-signal","fal fa-nfc-signal","fas fa-rss","far fa-rss","fal fa-rss","fas fa-satellite-dish","far fa-satellite-dish","fal fa-satellite-dish","fas fa-signal","far fa-signal","fal fa-signal","fas fa-signal-bars","far fa-signal-bars","fal fa-signal-bars","fas fa-signal-bars-fair","far fa-signal-bars-fair","fal fa-signal-bars-fair","fas fa-signal-bars-good","far fa-signal-bars-good","fal fa-signal-bars-good","fas fa-signal-bars-slash","far fa-signal-bars-slash","fal fa-signal-bars-slash","fas fa-signal-bars-weak","far fa-signal-bars-weak","fal fa-signal-bars-weak","fas fa-signal-fair","far fa-signal-fair","fal fa-signal-fair","fas fa-signal-good","far fa-signal-good","fal fa-signal-good","fas fa-signal-slash","far fa-signal-slash","fal fa-signal-slash","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-signal-stream-slash","far fa-signal-stream-slash","fal fa-signal-stream-slash","fas fa-signal-strong","far fa-signal-strong","fal fa-signal-strong","fas fa-signal-weak","far fa-signal-weak","fal fa-signal-weak","fas fa-tower-broadcast","far fa-tower-broadcast","fal fa-tower-broadcast","fas fa-tower-cell","far fa-tower-cell","fal fa-tower-cell","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wifi-exclamation","far fa-wifi-exclamation","fal fa-wifi-exclamation","fas fa-wifi-fair","far fa-wifi-fair","fal fa-wifi-fair","fas fa-wifi-weak","far fa-wifi-weak","fal fa-wifi-weak"]},{"id":"gaming","title":"Gaming","icons":["fas fa-alien-8bit","far fa-alien-8bit","fal fa-alien-8bit","fas fa-axe-battle","far fa-axe-battle","fal fa-axe-battle","fas fa-block","far fa-block","fal fa-block","fas fa-block-brick","far fa-block-brick","fal fa-block-brick","fas fa-block-question","far fa-block-question","fal fa-block-question","fas fa-book-skull","far fa-book-skull","fal fa-book-skull","fas fa-book-sparkles","far fa-book-sparkles","fal fa-book-sparkles","fas fa-bow-arrow","far fa-bow-arrow","fal fa-bow-arrow","fas fa-campfire","far fa-campfire","fal fa-campfire","fas fa-card-club","far fa-card-club","fal fa-card-club","fas fa-card-diamond","far fa-card-diamond","fal fa-card-diamond","fas fa-card-heart","far fa-card-heart","fal fa-card-heart","fas fa-card-spade","far fa-card-spade","fal fa-card-spade","fas fa-cards","far fa-cards","fal fa-cards","fas fa-cards-blank","far fa-cards-blank","fal fa-cards-blank","fas fa-chess","far fa-chess","fal fa-chess","fas fa-chess-bishop","far fa-chess-bishop","fal fa-chess-bishop","fas fa-chess-bishop-piece","far fa-chess-bishop-piece","fal fa-chess-bishop-piece","fas fa-chess-board","far fa-chess-board","fal fa-chess-board","fas fa-chess-clock","far fa-chess-clock","fal fa-chess-clock","fas fa-chess-clock-flip","far fa-chess-clock-flip","fal fa-chess-clock-flip","fas fa-chess-king","far fa-chess-king","fal fa-chess-king","fas fa-chess-king-piece","far fa-chess-king-piece","fal fa-chess-king-piece","fas fa-chess-knight","far fa-chess-knight","fal fa-chess-knight","fas fa-chess-knight-piece","far fa-chess-knight-piece","fal fa-chess-knight-piece","fas fa-chess-pawn","far fa-chess-pawn","fal fa-chess-pawn","fas fa-chess-pawn-piece","far fa-chess-pawn-piece","fal fa-chess-pawn-piece","fas fa-chess-queen","far fa-chess-queen","fal fa-chess-queen","fas fa-chess-queen-piece","far fa-chess-queen-piece","fal fa-chess-queen-piece","fas fa-chess-rook","far fa-chess-rook","fal fa-chess-rook","fas fa-chess-rook-piece","far fa-chess-rook-piece","fal fa-chess-rook-piece","fas fa-club","far fa-club","fal fa-club","fab fa-critical-role","fas fa-crystal-ball","far fa-crystal-ball","fal fa-crystal-ball","fab fa-d-and-d","fab fa-d-and-d-beyond","fas fa-dagger","far fa-dagger","fal fa-dagger","fas fa-diamond","far fa-diamond","fal fa-diamond","fas fa-dice","far fa-dice","fal fa-dice","fas fa-dice-d10","far fa-dice-d10","fal fa-dice-d10","fas fa-dice-d12","far fa-dice-d12","fal fa-dice-d12","fas fa-dice-d20","far fa-dice-d20","fal fa-dice-d20","fas fa-dice-d4","far fa-dice-d4","fal fa-dice-d4","fas fa-dice-d6","far fa-dice-d6","fal fa-dice-d6","fas fa-dice-d8","far fa-dice-d8","fal fa-dice-d8","fas fa-dice-five","far fa-dice-five","fal fa-dice-five","fas fa-dice-four","far fa-dice-four","fal fa-dice-four","fas fa-dice-one","far fa-dice-one","fal fa-dice-one","fas fa-dice-six","far fa-dice-six","fal fa-dice-six","fas fa-dice-three","far fa-dice-three","fal fa-dice-three","fas fa-dice-two","far fa-dice-two","fal fa-dice-two","fas fa-dragon","far fa-dragon","fal fa-dragon","fas fa-dreidel","far fa-dreidel","fal fa-dreidel","fas fa-dungeon","far fa-dungeon","fal fa-dungeon","fas fa-eye-evil","far fa-eye-evil","fal fa-eye-evil","fab fa-fantasy-flight-games","fas fa-fire-flame","far fa-fire-flame","fal fa-fire-flame","fas fa-flask-round-potion","far fa-flask-round-potion","fal fa-flask-round-potion","fas fa-game-board","far fa-game-board","fal fa-game-board","fas fa-game-board-simple","far fa-game-board-simple","fal fa-game-board-simple","fas fa-game-console-handheld","far fa-game-console-handheld","fal fa-game-console-handheld","fas fa-game-console-handheld-crank","far fa-game-console-handheld-crank","fal fa-game-console-handheld-crank","fas fa-gamepad","far fa-gamepad","fal fa-gamepad","fas fa-gamepad-modern","far fa-gamepad-modern","fal fa-gamepad-modern","fas fa-ghost","far fa-ghost","fal fa-ghost","fas fa-hammer-war","far fa-hammer-war","fal fa-hammer-war","fas fa-hand-fist","far fa-hand-fist","fal fa-hand-fist","fas fa-hand-holding-magic","far fa-hand-holding-magic","fal fa-hand-holding-magic","fas fa-hat-wizard","far fa-hat-wizard","fal fa-hat-wizard","fas fa-headset","far fa-headset","fal fa-headset","fas fa-heart","far fa-heart","fal fa-heart","fas fa-helmet-battle","far fa-helmet-battle","fal fa-helmet-battle","fas fa-hood-cloak","far fa-hood-cloak","fal fa-hood-cloak","fas fa-joystick","far fa-joystick","fal fa-joystick","fas fa-mace","far fa-mace","fal fa-mace","fas fa-mandolin","far fa-mandolin","fal fa-mandolin","fas fa-mushroom","far fa-mushroom","fal fa-mushroom","fas fa-nesting-dolls","far fa-nesting-dolls","fal fa-nesting-dolls","fas fa-paw-claws","far fa-paw-claws","fal fa-paw-claws","fas fa-person-dress-fairy","far fa-person-dress-fairy","fal fa-person-dress-fairy","fas fa-person-fairy","far fa-person-fairy","fal fa-person-fairy","fas fa-person-pinball","far fa-person-pinball","fal fa-person-pinball","fas fa-pickaxe","far fa-pickaxe","fal fa-pickaxe","fas fa-pinata","far fa-pinata","fal fa-pinata","fas fa-pinball","far fa-pinball","fal fa-pinball","fab fa-playstation","fas fa-pool-8-ball","far fa-pool-8-ball","fal fa-pool-8-ball","fas fa-puzzle","far fa-puzzle","fal fa-puzzle","fas fa-puzzle-piece","far fa-puzzle-piece","fal fa-puzzle-piece","fas fa-puzzle-piece-simple","far fa-puzzle-piece-simple","fal fa-puzzle-piece-simple","fas fa-ring","far fa-ring","fal fa-ring","fas fa-scroll","far fa-scroll","fal fa-scroll","fas fa-scroll-old","far fa-scroll-old","fal fa-scroll-old","fas fa-scythe","far fa-scythe","fal fa-scythe","fas fa-shield-cross","far fa-shield-cross","fal fa-shield-cross","fas fa-shield-halved","far fa-shield-halved","fal fa-shield-halved","fas fa-shield-quartered","far fa-shield-quartered","fal fa-shield-quartered","fas fa-sickle","far fa-sickle","fal fa-sickle","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-slot-machine","far fa-slot-machine","fal fa-slot-machine","fas fa-spade","far fa-spade","fal fa-spade","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-square-full","far fa-square-full","fal fa-square-full","fab fa-square-steam","fas fa-staff","far fa-staff","fal fa-staff","fab fa-steam","fab fa-steam-symbol","fas fa-sword","far fa-sword","fal fa-sword","fas fa-swords","far fa-swords","fal fa-swords","fas fa-teddy-bear","far fa-teddy-bear","fal fa-teddy-bear","fas fa-treasure-chest","far fa-treasure-chest","fal fa-treasure-chest","fab fa-twitch","fas fa-vr-cardboard","far fa-vr-cardboard","fal fa-vr-cardboard","fas fa-wand","far fa-wand","fal fa-wand","fas fa-wand-sparkles","far fa-wand-sparkles","fal fa-wand-sparkles","fab fa-wizards-of-the-coast","fas fa-wreath-laurel","far fa-wreath-laurel","fal fa-wreath-laurel","fab fa-xbox"]},{"id":"social","title":"Social","icons":["fas fa-arrows-retweet","far fa-arrows-retweet","fal fa-arrows-retweet","fas fa-bags-shopping","far fa-bags-shopping","fal fa-bags-shopping","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bird","far fa-bird","fal fa-bird","fab fa-bluesky","fas fa-cake-candles","far fa-cake-candles","fal fa-cake-candles","fas fa-camera","far fa-camera","fal fa-camera","fas fa-circle-envelope","far fa-circle-envelope","fal fa-circle-envelope","fas fa-circle-user","far fa-circle-user","fal fa-circle-user","fas fa-comment","far fa-comment","fal fa-comment","fas fa-envelope","far fa-envelope","fal fa-envelope","fab fa-facebook","fas fa-hashtag","far fa-hashtag","fal fa-hashtag","fas fa-heart","far fa-heart","fal fa-heart","fas fa-icons","far fa-icons","fal fa-icons","fas fa-image","far fa-image","fal fa-image","fas fa-images","far fa-images","fal fa-images","fas fa-location-dot","far fa-location-dot","fal fa-location-dot","fas fa-location-pin","far fa-location-pin","fal fa-location-pin","fas fa-message","far fa-message","fal fa-message","fas fa-paper-plane-top","far fa-paper-plane-top","fal fa-paper-plane-top","fas fa-photo-film","far fa-photo-film","fal fa-photo-film","fas fa-photo-film-music","far fa-photo-film-music","fal fa-photo-film-music","fas fa-retweet","far fa-retweet","fal fa-retweet","fas fa-share","far fa-share","fal fa-share","fas fa-share-from-square","far fa-share-from-square","fal fa-share-from-square","fas fa-share-nodes","far fa-share-nodes","fal fa-share-nodes","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-square-poll-horizontal","far fa-square-poll-horizontal","fal fa-square-poll-horizontal","fas fa-square-poll-vertical","far fa-square-poll-vertical","fal fa-square-poll-vertical","fas fa-square-share-nodes","far fa-square-share-nodes","fal fa-square-share-nodes","fas fa-star","far fa-star","fal fa-star","fas fa-symbols","far fa-symbols","fal fa-symbols","fas fa-thumbs-down","far fa-thumbs-down","fal fa-thumbs-down","fas fa-thumbs-up","far fa-thumbs-up","fal fa-thumbs-up","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack","fas fa-thumbtack-slash","far fa-thumbtack-slash","fal fa-thumbtack-slash","fas fa-user","far fa-user","fal fa-user","fas fa-user-crown","far fa-user-crown","fal fa-user-crown","fas fa-user-group","far fa-user-group","fal fa-user-group","fas fa-user-group-crown","far fa-user-group-crown","fal fa-user-group-crown","fas fa-user-group-simple","far fa-user-group-simple","fal fa-user-group-simple","fas fa-user-plus","far fa-user-plus","fal fa-user-plus","fas fa-users","far fa-users","fal fa-users","fas fa-video","far fa-video","fal fa-video"]},{"id":"education","title":"Education","icons":["fas fa-apple-whole","far fa-apple-whole","fal fa-apple-whole","fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-simple","far fa-atom-simple","fal fa-atom-simple","fas fa-award","far fa-award","fal fa-award","fas fa-backpack","far fa-backpack","fal fa-backpack","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-ring","far fa-bell-ring","fal fa-bell-ring","fas fa-bell-school","far fa-bell-school","fal fa-bell-school","fas fa-bell-school-slash","far fa-bell-school-slash","fal fa-bell-school-slash","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-book-blank","far fa-book-blank","fal fa-book-blank","fas fa-book-copy","far fa-book-copy","fal fa-book-copy","fas fa-book-open","far fa-book-open","fal fa-book-open","fas fa-book-open-cover","far fa-book-open-cover","fal fa-book-open-cover","fas fa-book-open-reader","far fa-book-open-reader","fal fa-book-open-reader","fas fa-books","far fa-books","fal fa-books","fas fa-bus-school","far fa-bus-school","fal fa-bus-school","fas fa-chalkboard","far fa-chalkboard","fal fa-chalkboard","fas fa-chalkboard-user","far fa-chalkboard-user","fal fa-chalkboard-user","fas fa-diploma","far fa-diploma","fal fa-diploma","fas fa-file-certificate","far fa-file-certificate","fal fa-file-certificate","fas fa-glasses-round","far fa-glasses-round","fal fa-glasses-round","fas fa-globe-stand","far fa-globe-stand","fal fa-globe-stand","fas fa-graduation-cap","far fa-graduation-cap","fal fa-graduation-cap","fas fa-laptop-code","far fa-laptop-code","fal fa-laptop-code","fas fa-laptop-file","far fa-laptop-file","fal fa-laptop-file","fas fa-masks-theater","far fa-masks-theater","fal fa-masks-theater","fas fa-microscope","far fa-microscope","fal fa-microscope","fas fa-music","far fa-music","fal fa-music","fas fa-pen-paintbrush","far fa-pen-paintbrush","fal fa-pen-paintbrush","fas fa-person-chalkboard","far fa-person-chalkboard","fal fa-person-chalkboard","fas fa-ruler-triangle","far fa-ruler-triangle","fal fa-ruler-triangle","fas fa-school","far fa-school","fal fa-school","fas fa-school-circle-check","far fa-school-circle-check","fal fa-school-circle-check","fas fa-school-circle-exclamation","far fa-school-circle-exclamation","fal fa-school-circle-exclamation","fas fa-school-circle-xmark","far fa-school-circle-xmark","fal fa-school-circle-xmark","fas fa-school-flag","far fa-school-flag","fal fa-school-flag","fas fa-school-lock","far fa-school-lock","fal fa-school-lock","fas fa-screen-users","far fa-screen-users","fal fa-screen-users","fas fa-shapes","far fa-shapes","fal fa-shapes","fas fa-thought-bubble","far fa-thought-bubble","fal fa-thought-bubble","fas fa-user-graduate","far fa-user-graduate","fal fa-user-graduate"]},{"id":"devices-hardware","title":"Devices + Hardware","icons":["fas fa-album","far fa-album","fal fa-album","fas fa-album-circle-plus","far fa-album-circle-plus","fal fa-album-circle-plus","fas fa-album-circle-user","far fa-album-circle-user","fal fa-album-circle-user","fas fa-blender-phone","far fa-blender-phone","fal fa-blender-phone","fas fa-camera","far fa-camera","fal fa-camera","fas fa-camera-retro","far fa-camera-retro","fal fa-camera-retro","fas fa-camera-web","far fa-camera-web","fal fa-camera-web","fas fa-camera-web-slash","far fa-camera-web-slash","fal fa-camera-web-slash","fas fa-car-battery","far fa-car-battery","fal fa-car-battery","fas fa-compact-disc","far fa-compact-disc","fal fa-compact-disc","fas fa-computer","far fa-computer","fal fa-computer","fas fa-computer-classic","far fa-computer-classic","fal fa-computer-classic","fas fa-computer-mouse","far fa-computer-mouse","fal fa-computer-mouse","fas fa-computer-mouse-scrollwheel","far fa-computer-mouse-scrollwheel","fal fa-computer-mouse-scrollwheel","fas fa-computer-speaker","far fa-computer-speaker","fal fa-computer-speaker","fas fa-database","far fa-database","fal fa-database","fas fa-desktop","far fa-desktop","fal fa-desktop","fas fa-desktop-arrow-down","far fa-desktop-arrow-down","fal fa-desktop-arrow-down","fas fa-disc-drive","far fa-disc-drive","fal fa-disc-drive","fas fa-display","far fa-display","fal fa-display","fas fa-display-arrow-down","far fa-display-arrow-down","fal fa-display-arrow-down","fas fa-display-code","far fa-display-code","fal fa-display-code","fas fa-display-medical","far fa-display-medical","fal fa-display-medical","fas fa-display-slash","far fa-display-slash","fal fa-display-slash","fas fa-download","far fa-download","fal fa-download","fas fa-engine","far fa-engine","fal fa-engine","fas fa-ethernet","far fa-ethernet","fal fa-ethernet","fas fa-fax","far fa-fax","fal fa-fax","fas fa-flashlight","far fa-flashlight","fal fa-flashlight","fas fa-floppy-disk","far fa-floppy-disk","fal fa-floppy-disk","fas fa-floppy-disk-pen","far fa-floppy-disk-pen","fal fa-floppy-disk-pen","fas fa-floppy-disks","far fa-floppy-disks","fal fa-floppy-disks","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-game-console-handheld","far fa-game-console-handheld","fal fa-game-console-handheld","fas fa-game-console-handheld-crank","far fa-game-console-handheld-crank","fal fa-game-console-handheld-crank","fas fa-gamepad","far fa-gamepad","fal fa-gamepad","fas fa-gamepad-modern","far fa-gamepad-modern","fal fa-gamepad-modern","fas fa-hard-drive","far fa-hard-drive","fal fa-hard-drive","fas fa-headphones","far fa-headphones","fal fa-headphones","fas fa-house-laptop","far fa-house-laptop","fal fa-house-laptop","fas fa-keyboard","far fa-keyboard","fal fa-keyboard","fas fa-keyboard-down","far fa-keyboard-down","fal fa-keyboard-down","fas fa-keyboard-left","far fa-keyboard-left","fal fa-keyboard-left","fas fa-laptop","far fa-laptop","fal fa-laptop","fas fa-laptop-arrow-down","far fa-laptop-arrow-down","fal fa-laptop-arrow-down","fas fa-laptop-binary","far fa-laptop-binary","fal fa-laptop-binary","fas fa-laptop-file","far fa-laptop-file","fal fa-laptop-file","fas fa-laptop-mobile","far fa-laptop-mobile","fal fa-laptop-mobile","fas fa-laptop-slash","far fa-laptop-slash","fal fa-laptop-slash","fas fa-memory","far fa-memory","fal fa-memory","fas fa-meter","far fa-meter","fal fa-meter","fas fa-microchip","far fa-microchip","fal fa-microchip","fas fa-microchip-ai","far fa-microchip-ai","fal fa-microchip-ai","fas fa-mobile","far fa-mobile","fal fa-mobile","fas fa-mobile-button","far fa-mobile-button","fal fa-mobile-button","fas fa-mobile-notch","far fa-mobile-notch","fal fa-mobile-notch","fas fa-mobile-retro","far fa-mobile-retro","fal fa-mobile-retro","fas fa-mobile-screen","far fa-mobile-screen","fal fa-mobile-screen","fas fa-mobile-screen-button","far fa-mobile-screen-button","fal fa-mobile-screen-button","fas fa-mobile-signal","far fa-mobile-signal","fal fa-mobile-signal","fas fa-mobile-signal-out","far fa-mobile-signal-out","fal fa-mobile-signal-out","fas fa-mp3-player","far fa-mp3-player","fal fa-mp3-player","fas fa-phone-office","far fa-phone-office","fal fa-phone-office","fas fa-plug","far fa-plug","fal fa-plug","fas fa-power-off","far fa-power-off","fal fa-power-off","fas fa-print","far fa-print","fal fa-print","fas fa-projector","far fa-projector","fal fa-projector","fas fa-router","far fa-router","fal fa-router","fas fa-satellite","far fa-satellite","fal fa-satellite","fas fa-satellite-dish","far fa-satellite-dish","fal fa-satellite-dish","fas fa-scanner-image","far fa-scanner-image","fal fa-scanner-image","fas fa-sd-card","far fa-sd-card","fal fa-sd-card","fas fa-sd-cards","far fa-sd-cards","fal fa-sd-cards","fas fa-server","far fa-server","fal fa-server","fas fa-shredder","far fa-shredder","fal fa-shredder","fas fa-sim-card","far fa-sim-card","fal fa-sim-card","fas fa-sim-cards","far fa-sim-cards","fal fa-sim-cards","fas fa-speaker","far fa-speaker","fal fa-speaker","fas fa-speakers","far fa-speakers","fal fa-speakers","fas fa-tablet","far fa-tablet","fal fa-tablet","fas fa-tablet-button","far fa-tablet-button","fal fa-tablet-button","fas fa-tablet-screen","far fa-tablet-screen","fal fa-tablet-screen","fas fa-tablet-screen-button","far fa-tablet-screen-button","fal fa-tablet-screen-button","fas fa-tachograph-digital","far fa-tachograph-digital","fal fa-tachograph-digital","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-music","far fa-tv-music","fal fa-tv-music","fas fa-tv-retro","far fa-tv-retro","fal fa-tv-retro","fas fa-typewriter","far fa-typewriter","fal fa-typewriter","fas fa-upload","far fa-upload","fal fa-upload","fas fa-usb-drive","far fa-usb-drive","fal fa-usb-drive","fas fa-walkie-talkie","far fa-walkie-talkie","fal fa-walkie-talkie","fas fa-watch-calculator","far fa-watch-calculator","fal fa-watch-calculator"]},{"id":"files","title":"Files","icons":["fas fa-box-archive","far fa-box-archive","fal fa-box-archive","fas fa-clone","far fa-clone","fal fa-clone","fas fa-copy","far fa-copy","fal fa-copy","fas fa-file","far fa-file","fal fa-file","fas fa-file-arrow-down","far fa-file-arrow-down","fal fa-file-arrow-down","fas fa-file-arrow-up","far fa-file-arrow-up","fal fa-file-arrow-up","fas fa-file-audio","far fa-file-audio","fal fa-file-audio","fas fa-file-binary","far fa-file-binary","fal fa-file-binary","fas fa-file-cad","far fa-file-cad","fal fa-file-cad","fas fa-file-check","far fa-file-check","fal fa-file-check","fas fa-file-circle-check","far fa-file-circle-check","fal fa-file-circle-check","fas fa-file-circle-exclamation","far fa-file-circle-exclamation","fal fa-file-circle-exclamation","fas fa-file-circle-info","far fa-file-circle-info","fal fa-file-circle-info","fas fa-file-circle-minus","far fa-file-circle-minus","fal fa-file-circle-minus","fas fa-file-circle-plus","far fa-file-circle-plus","fal fa-file-circle-plus","fas fa-file-circle-question","far fa-file-circle-question","fal fa-file-circle-question","fas fa-file-circle-xmark","far fa-file-circle-xmark","fal fa-file-circle-xmark","fas fa-file-code","far fa-file-code","fal fa-file-code","fas fa-file-csv","far fa-file-csv","fal fa-file-csv","fas fa-file-doc","far fa-file-doc","fal fa-file-doc","fas fa-file-eps","far fa-file-eps","fal fa-file-eps","fas fa-file-excel","far fa-file-excel","fal fa-file-excel","fas fa-file-exclamation","far fa-file-exclamation","fal fa-file-exclamation","fas fa-file-export","far fa-file-export","fal fa-file-export","fas fa-file-gif","far fa-file-gif","fal fa-file-gif","fas fa-file-heart","far fa-file-heart","fal fa-file-heart","fas fa-file-image","far fa-file-image","fal fa-file-image","fas fa-file-import","far fa-file-import","fal fa-file-import","fas fa-file-jpg","far fa-file-jpg","fal fa-file-jpg","fas fa-file-lines","far fa-file-lines","fal fa-file-lines","fas fa-file-lock","far fa-file-lock","fal fa-file-lock","fas fa-file-magnifying-glass","far fa-file-magnifying-glass","fal fa-file-magnifying-glass","fas fa-file-minus","far fa-file-minus","fal fa-file-minus","fas fa-file-mov","far fa-file-mov","fal fa-file-mov","fas fa-file-mp3","far fa-file-mp3","fal fa-file-mp3","fas fa-file-mp4","far fa-file-mp4","fal fa-file-mp4","fas fa-file-music","far fa-file-music","fal fa-file-music","fas fa-file-pdf","far fa-file-pdf","fal fa-file-pdf","fas fa-file-pen","far fa-file-pen","fal fa-file-pen","fas fa-file-plus","far fa-file-plus","fal fa-file-plus","fas fa-file-plus-minus","far fa-file-plus-minus","fal fa-file-plus-minus","fas fa-file-png","far fa-file-png","fal fa-file-png","fas fa-file-powerpoint","far fa-file-powerpoint","fal fa-file-powerpoint","fas fa-file-ppt","far fa-file-ppt","fal fa-file-ppt","fas fa-file-shield","far fa-file-shield","fal fa-file-shield","fas fa-file-slash","far fa-file-slash","fal fa-file-slash","fas fa-file-svg","far fa-file-svg","fal fa-file-svg","fas fa-file-vector","far fa-file-vector","fal fa-file-vector","fas fa-file-video","far fa-file-video","fal fa-file-video","fas fa-file-word","far fa-file-word","fal fa-file-word","fas fa-file-xls","far fa-file-xls","fal fa-file-xls","fas fa-file-xmark","far fa-file-xmark","fal fa-file-xmark","fas fa-file-xml","far fa-file-xml","fal fa-file-xml","fas fa-file-zip","far fa-file-zip","fal fa-file-zip","fas fa-file-zipper","far fa-file-zipper","fal fa-file-zipper","fas fa-files","far fa-files","fal fa-files","fas fa-floppy-disk","far fa-floppy-disk","fal fa-floppy-disk","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-bookmark","far fa-folder-bookmark","fal fa-folder-bookmark","fas fa-folder-check","far fa-folder-check","fal fa-folder-check","fas fa-folder-closed","far fa-folder-closed","fal fa-folder-closed","fas fa-folder-gear","far fa-folder-gear","fal fa-folder-gear","fas fa-folder-grid","far fa-folder-grid","fal fa-folder-grid","fas fa-folder-heart","far fa-folder-heart","fal fa-folder-heart","fas fa-folder-image","far fa-folder-image","fal fa-folder-image","fas fa-folder-magnifying-glass","far fa-folder-magnifying-glass","fal fa-folder-magnifying-glass","fas fa-folder-medical","far fa-folder-medical","fal fa-folder-medical","fas fa-folder-music","far fa-folder-music","fal fa-folder-music","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-folder-user","far fa-folder-user","fal fa-folder-user","fas fa-folder-xmark","far fa-folder-xmark","fal fa-folder-xmark","fas fa-folders","far fa-folders","fal fa-folders","fas fa-memo","far fa-memo","fal fa-memo","fas fa-memo-circle-check","far fa-memo-circle-check","fal fa-memo-circle-check","fas fa-memo-circle-info","far fa-memo-circle-info","fal fa-memo-circle-info","fas fa-memo-pad","far fa-memo-pad","fal fa-memo-pad","fas fa-note-sticky","far fa-note-sticky","fal fa-note-sticky","fas fa-page","far fa-page","fal fa-page","fas fa-page-caret-down","far fa-page-caret-down","fal fa-page-caret-down","fas fa-page-caret-up","far fa-page-caret-up","fal fa-page-caret-up","fas fa-paste","far fa-paste","fal fa-paste","fas fa-photo-film","far fa-photo-film","fal fa-photo-film","fas fa-scissors","far fa-scissors","fal fa-scissors"]},{"id":"food-beverage","title":"Food + Beverage","icons":["fas fa-apple-whole","far fa-apple-whole","fal fa-apple-whole","fas fa-bacon","far fa-bacon","fal fa-bacon","fas fa-bagel","far fa-bagel","fal fa-bagel","fas fa-baguette","far fa-baguette","fal fa-baguette","fas fa-beer-mug","far fa-beer-mug","fal fa-beer-mug","fas fa-beer-mug-empty","far fa-beer-mug-empty","fal fa-beer-mug-empty","fas fa-blender","far fa-blender","fal fa-blender","fas fa-bone","far fa-bone","fal fa-bone","fas fa-bottle-baby","far fa-bottle-baby","fal fa-bottle-baby","fas fa-bottle-droplet","far fa-bottle-droplet","fal fa-bottle-droplet","fas fa-bottle-water","far fa-bottle-water","fal fa-bottle-water","fas fa-bowl-chopsticks","far fa-bowl-chopsticks","fal fa-bowl-chopsticks","fas fa-bowl-chopsticks-noodles","far fa-bowl-chopsticks-noodles","fal fa-bowl-chopsticks-noodles","fas fa-bowl-food","far fa-bowl-food","fal fa-bowl-food","fas fa-bowl-hot","far fa-bowl-hot","fal fa-bowl-hot","fas fa-bowl-rice","far fa-bowl-rice","fal fa-bowl-rice","fas fa-bowl-scoop","far fa-bowl-scoop","fal fa-bowl-scoop","fas fa-bowl-scoops","far fa-bowl-scoops","fal fa-bowl-scoops","fas fa-bowl-soft-serve","far fa-bowl-soft-serve","fal fa-bowl-soft-serve","fas fa-bowl-spoon","far fa-bowl-spoon","fal fa-bowl-spoon","fas fa-bread-loaf","far fa-bread-loaf","fal fa-bread-loaf","fas fa-bread-slice","far fa-bread-slice","fal fa-bread-slice","fas fa-bread-slice-butter","far fa-bread-slice-butter","fal fa-bread-slice-butter","fas fa-burger","far fa-burger","fal fa-burger","fas fa-burger-cheese","far fa-burger-cheese","fal fa-burger-cheese","fas fa-burger-fries","far fa-burger-fries","fal fa-burger-fries","fas fa-burger-glass","far fa-burger-glass","fal fa-burger-glass","fas fa-burger-lettuce","far fa-burger-lettuce","fal fa-burger-lettuce","fas fa-burger-soda","far fa-burger-soda","fal fa-burger-soda","fas fa-burrito","far fa-burrito","fal fa-burrito","fas fa-butter","far fa-butter","fal fa-butter","fas fa-cake-candles","far fa-cake-candles","fal fa-cake-candles","fas fa-cake-slice","far fa-cake-slice","fal fa-cake-slice","fas fa-can-food","far fa-can-food","fal fa-can-food","fas fa-candy","far fa-candy","fal fa-candy","fas fa-candy-bar","far fa-candy-bar","fal fa-candy-bar","fas fa-candy-cane","far fa-candy-cane","fal fa-candy-cane","fas fa-candy-corn","far fa-candy-corn","fal fa-candy-corn","fas fa-carrot","far fa-carrot","fal fa-carrot","fas fa-champagne-glass","far fa-champagne-glass","fal fa-champagne-glass","fas fa-champagne-glasses","far fa-champagne-glasses","fal fa-champagne-glasses","fas fa-cheese","far fa-cheese","fal fa-cheese","fas fa-cheese-swiss","far fa-cheese-swiss","fal fa-cheese-swiss","fas fa-chopsticks","far fa-chopsticks","fal fa-chopsticks","fas fa-circle-gf","far fa-circle-gf","fal fa-circle-gf","fas fa-cloud-meatball","far fa-cloud-meatball","fal fa-cloud-meatball","fas fa-coffee-bean","far fa-coffee-bean","fal fa-coffee-bean","fas fa-coffee-beans","far fa-coffee-beans","fal fa-coffee-beans","fas fa-coffee-pot","far fa-coffee-pot","fal fa-coffee-pot","fas fa-cookie","far fa-cookie","fal fa-cookie","fas fa-corn","far fa-corn","fal fa-corn","fas fa-crab","far fa-crab","fal fa-crab","fas fa-crate-apple","far fa-crate-apple","fal fa-crate-apple","fas fa-croissant","far fa-croissant","fal fa-croissant","fas fa-cubes-stacked","far fa-cubes-stacked","fal fa-cubes-stacked","fas fa-cup-straw","far fa-cup-straw","fal fa-cup-straw","fas fa-cup-straw-swoosh","far fa-cup-straw-swoosh","fal fa-cup-straw-swoosh","fas fa-cup-togo","far fa-cup-togo","fal fa-cup-togo","fas fa-cupcake","far fa-cupcake","fal fa-cupcake","fas fa-custard","far fa-custard","fal fa-custard","fas fa-donut","far fa-donut","fal fa-donut","fas fa-drumstick","far fa-drumstick","fal fa-drumstick","fas fa-drumstick-bite","far fa-drumstick-bite","fal fa-drumstick-bite","fas fa-egg","far fa-egg","fal fa-egg","fas fa-egg-fried","far fa-egg-fried","fal fa-egg-fried","fas fa-falafel","far fa-falafel","fal fa-falafel","fas fa-fish","far fa-fish","fal fa-fish","fas fa-fish-bones","far fa-fish-bones","fal fa-fish-bones","fas fa-fish-cooked","far fa-fish-cooked","fal fa-fish-cooked","fas fa-fish-fins","far fa-fish-fins","fal fa-fish-fins","fas fa-flask","far fa-flask","fal fa-flask","fas fa-flask-round-poison","far fa-flask-round-poison","fal fa-flask-round-poison","fas fa-flask-round-potion","far fa-flask-round-potion","fal fa-flask-round-potion","fas fa-flatbread","far fa-flatbread","fal fa-flatbread","fas fa-flatbread-stuffed","far fa-flatbread-stuffed","fal fa-flatbread-stuffed","fas fa-fondue-pot","far fa-fondue-pot","fal fa-fondue-pot","fas fa-french-fries","far fa-french-fries","fal fa-french-fries","fas fa-gingerbread-man","far fa-gingerbread-man","fal fa-gingerbread-man","fas fa-glass","far fa-glass","fal fa-glass","fas fa-glass-citrus","far fa-glass-citrus","fal fa-glass-citrus","fas fa-glass-empty","far fa-glass-empty","fal fa-glass-empty","fas fa-glass-half","far fa-glass-half","fal fa-glass-half","fas fa-glass-water","far fa-glass-water","fal fa-glass-water","fas fa-glass-water-droplet","far fa-glass-water-droplet","fal fa-glass-water-droplet","fas fa-hat-chef","far fa-hat-chef","fal fa-hat-chef","fas fa-honey-pot","far fa-honey-pot","fal fa-honey-pot","fas fa-hotdog","far fa-hotdog","fal fa-hotdog","fas fa-ice-cream","far fa-ice-cream","fal fa-ice-cream","fas fa-jar","far fa-jar","fal fa-jar","fas fa-jar-wheat","far fa-jar-wheat","fal fa-jar-wheat","fas fa-jug","far fa-jug","fal fa-jug","fas fa-jug-bottle","far fa-jug-bottle","fal fa-jug-bottle","fas fa-lemon","far fa-lemon","fal fa-lemon","fas fa-lobster","far fa-lobster","fal fa-lobster","fas fa-lollipop","far fa-lollipop","fal fa-lollipop","fas fa-martini-glass","far fa-martini-glass","fal fa-martini-glass","fas fa-martini-glass-citrus","far fa-martini-glass-citrus","fal fa-martini-glass-citrus","fas fa-martini-glass-empty","far fa-martini-glass-empty","fal fa-martini-glass-empty","fas fa-meat","far fa-meat","fal fa-meat","fas fa-mug","far fa-mug","fal fa-mug","fas fa-mug-hot","far fa-mug-hot","fal fa-mug-hot","fas fa-mug-marshmallows","far fa-mug-marshmallows","fal fa-mug-marshmallows","fas fa-mug-saucer","far fa-mug-saucer","fal fa-mug-saucer","fas fa-mug-tea","far fa-mug-tea","fal fa-mug-tea","fas fa-mug-tea-saucer","far fa-mug-tea-saucer","fal fa-mug-tea-saucer","fas fa-pan-food","far fa-pan-food","fal fa-pan-food","fas fa-pan-frying","far fa-pan-frying","fal fa-pan-frying","fas fa-pancakes","far fa-pancakes","fal fa-pancakes","fas fa-pepper-hot","far fa-pepper-hot","fal fa-pepper-hot","fas fa-pie","far fa-pie","fal fa-pie","fas fa-pizza","far fa-pizza","fal fa-pizza","fas fa-pizza-slice","far fa-pizza-slice","fal fa-pizza-slice","fas fa-plate-wheat","far fa-plate-wheat","fal fa-plate-wheat","fas fa-popcorn","far fa-popcorn","fal fa-popcorn","fas fa-popsicle","far fa-popsicle","fal fa-popsicle","fas fa-pot-food","far fa-pot-food","fal fa-pot-food","fas fa-pretzel","far fa-pretzel","fal fa-pretzel","fas fa-pumpkin","far fa-pumpkin","fal fa-pumpkin","fas fa-salad","far fa-salad","fal fa-salad","fas fa-salt-shaker","far fa-salt-shaker","fal fa-salt-shaker","fas fa-sandwich","far fa-sandwich","fal fa-sandwich","fas fa-sausage","far fa-sausage","fal fa-sausage","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-shish-kebab","far fa-shish-kebab","fal fa-shish-kebab","fas fa-shrimp","far fa-shrimp","fal fa-shrimp","fas fa-soft-serve","far fa-soft-serve","fal fa-soft-serve","fas fa-squid","far fa-squid","fal fa-squid","fas fa-steak","far fa-steak","fal fa-steak","fas fa-stroopwafel","far fa-stroopwafel","fal fa-stroopwafel","fas fa-sushi","far fa-sushi","fal fa-sushi","fas fa-sushi-roll","far fa-sushi-roll","fal fa-sushi-roll","fas fa-taco","far fa-taco","fal fa-taco","fas fa-tamale","far fa-tamale","fal fa-tamale","fas fa-truck-utensils","far fa-truck-utensils","fal fa-truck-utensils","fas fa-turkey","far fa-turkey","fal fa-turkey","fas fa-user-chef","far fa-user-chef","fal fa-user-chef","fas fa-waffle","far fa-waffle","fal fa-waffle","fas fa-wheat","far fa-wheat","fal fa-wheat","fas fa-wheat-awn","far fa-wheat-awn","fal fa-wheat-awn","fas fa-wheat-awn-circle-exclamation","far fa-wheat-awn-circle-exclamation","fal fa-wheat-awn-circle-exclamation","fas fa-wheat-awn-slash","far fa-wheat-awn-slash","fal fa-wheat-awn-slash","fas fa-wheat-slash","far fa-wheat-slash","fal fa-wheat-slash","fas fa-whiskey-glass","far fa-whiskey-glass","fal fa-whiskey-glass","fas fa-whiskey-glass-ice","far fa-whiskey-glass-ice","fal fa-whiskey-glass-ice","fas fa-wine-bottle","far fa-wine-bottle","fal fa-wine-bottle","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass","fas fa-wine-glass-empty","far fa-wine-glass-empty","fal fa-wine-glass-empty"]},{"id":"users-people","title":"Users + People","icons":["fab fa-accessible-icon","fas fa-address-book","far fa-address-book","fal fa-address-book","fas fa-address-card","far fa-address-card","fal fa-address-card","fas fa-angel","far fa-angel","fal fa-angel","fas fa-arrows-down-to-people","far fa-arrows-down-to-people","fal fa-arrows-down-to-people","fas fa-baby","far fa-baby","fal fa-baby","fas fa-bed","far fa-bed","fal fa-bed","fas fa-book-user","far fa-book-user","fal fa-book-user","fas fa-chalkboard-user","far fa-chalkboard-user","fal fa-chalkboard-user","fas fa-chart-user","far fa-chart-user","fal fa-chart-user","fas fa-child","far fa-child","fal fa-child","fas fa-child-dress","far fa-child-dress","fal fa-child-dress","fas fa-child-reaching","far fa-child-reaching","fal fa-child-reaching","fas fa-children","far fa-children","fal fa-children","fas fa-circle-user","far fa-circle-user","fal fa-circle-user","fas fa-clipboard-user","far fa-clipboard-user","fal fa-clipboard-user","fas fa-elevator","far fa-elevator","fal fa-elevator","fas fa-face-frown","far fa-face-frown","fal fa-face-frown","fas fa-face-meh","far fa-face-meh","fal fa-face-meh","fas fa-face-smile","far fa-face-smile","fal fa-face-smile","fas fa-family","far fa-family","fal fa-family","fas fa-family-dress","far fa-family-dress","fal fa-family-dress","fas fa-family-pants","far fa-family-pants","fal fa-family-pants","fas fa-file-user","far fa-file-user","fal fa-file-user","fas fa-folder-user","far fa-folder-user","fal fa-folder-user","fas fa-head-side","far fa-head-side","fal fa-head-side","fas fa-head-side-brain","far fa-head-side-brain","fal fa-head-side-brain","fas fa-head-side-cough","far fa-head-side-cough","fal fa-head-side-cough","fas fa-head-side-cough-slash","far fa-head-side-cough-slash","fal fa-head-side-cough-slash","fas fa-head-side-gear","far fa-head-side-gear","fal fa-head-side-gear","fas fa-head-side-goggles","far fa-head-side-goggles","fal fa-head-side-goggles","fas fa-head-side-headphones","far fa-head-side-headphones","fal fa-head-side-headphones","fas fa-head-side-heart","far fa-head-side-heart","fal fa-head-side-heart","fas fa-head-side-mask","far fa-head-side-mask","fal fa-head-side-mask","fas fa-head-side-medical","far fa-head-side-medical","fal fa-head-side-medical","fas fa-head-side-virus","far fa-head-side-virus","fal fa-head-side-virus","fas fa-hospital-user","far fa-hospital-user","fal fa-hospital-user","fas fa-hot-tub-person","far fa-hot-tub-person","fal fa-hot-tub-person","fas fa-house-chimney-user","far fa-house-chimney-user","fal fa-house-chimney-user","fas fa-house-person-leave","far fa-house-person-leave","fal fa-house-person-leave","fas fa-house-person-return","far fa-house-person-return","fal fa-house-person-return","fas fa-house-user","far fa-house-user","fal fa-house-user","fas fa-id-badge","far fa-id-badge","fal fa-id-badge","fas fa-id-card","far fa-id-card","fal fa-id-card","fas fa-id-card-clip","far fa-id-card-clip","fal fa-id-card-clip","fas fa-image-polaroid-user","far fa-image-polaroid-user","fal fa-image-polaroid-user","fas fa-image-portrait","far fa-image-portrait","fal fa-image-portrait","fas fa-image-user","far fa-image-user","fal fa-image-user","fas fa-images-user","far fa-images-user","fal fa-images-user","fas fa-mars-and-venus-burst","far fa-mars-and-venus-burst","fal fa-mars-and-venus-burst","fas fa-people","far fa-people","fal fa-people","fas fa-people-arrows","far fa-people-arrows","fal fa-people-arrows","fas fa-people-carry-box","far fa-people-carry-box","fal fa-people-carry-box","fas fa-people-dress","far fa-people-dress","fal fa-people-dress","fas fa-people-dress-simple","far fa-people-dress-simple","fal fa-people-dress-simple","fas fa-people-group","far fa-people-group","fal fa-people-group","fas fa-people-line","far fa-people-line","fal fa-people-line","fas fa-people-pants","far fa-people-pants","fal fa-people-pants","fas fa-people-pants-simple","far fa-people-pants-simple","fal fa-people-pants-simple","fas fa-people-pulling","far fa-people-pulling","fal fa-people-pulling","fas fa-people-robbery","far fa-people-robbery","fal fa-people-robbery","fas fa-people-roof","far fa-people-roof","fal fa-people-roof","fas fa-people-simple","far fa-people-simple","fal fa-people-simple","fas fa-person","far fa-person","fal fa-person","fas fa-person-arrow-down-to-line","far fa-person-arrow-down-to-line","fal fa-person-arrow-down-to-line","fas fa-person-arrow-up-from-line","far fa-person-arrow-up-from-line","fal fa-person-arrow-up-from-line","fas fa-person-biking","far fa-person-biking","fal fa-person-biking","fas fa-person-biking-mountain","far fa-person-biking-mountain","fal fa-person-biking-mountain","fas fa-person-booth","far fa-person-booth","fal fa-person-booth","fas fa-person-breastfeeding","far fa-person-breastfeeding","fal fa-person-breastfeeding","fas fa-person-burst","far fa-person-burst","fal fa-person-burst","fas fa-person-cane","far fa-person-cane","fal fa-person-cane","fas fa-person-carry-box","far fa-person-carry-box","fal fa-person-carry-box","fas fa-person-chalkboard","far fa-person-chalkboard","fal fa-person-chalkboard","fas fa-person-circle-check","far fa-person-circle-check","fal fa-person-circle-check","fas fa-person-circle-exclamation","far fa-person-circle-exclamation","fal fa-person-circle-exclamation","fas fa-person-circle-minus","far fa-person-circle-minus","fal fa-person-circle-minus","fas fa-person-circle-plus","far fa-person-circle-plus","fal fa-person-circle-plus","fas fa-person-circle-question","far fa-person-circle-question","fal fa-person-circle-question","fas fa-person-circle-xmark","far fa-person-circle-xmark","fal fa-person-circle-xmark","fas fa-person-digging","far fa-person-digging","fal fa-person-digging","fas fa-person-dolly","far fa-person-dolly","fal fa-person-dolly","fas fa-person-dolly-empty","far fa-person-dolly-empty","fal fa-person-dolly-empty","fas fa-person-dots-from-line","far fa-person-dots-from-line","fal fa-person-dots-from-line","fas fa-person-dress","far fa-person-dress","fal fa-person-dress","fas fa-person-dress-burst","far fa-person-dress-burst","fal fa-person-dress-burst","fas fa-person-dress-fairy","far fa-person-dress-fairy","fal fa-person-dress-fairy","fas fa-person-dress-simple","far fa-person-dress-simple","fal fa-person-dress-simple","fas fa-person-drowning","far fa-person-drowning","fal fa-person-drowning","fas fa-person-fairy","far fa-person-fairy","fal fa-person-fairy","fas fa-person-falling","far fa-person-falling","fal fa-person-falling","fas fa-person-falling-burst","far fa-person-falling-burst","fal fa-person-falling-burst","fas fa-person-from-portal","far fa-person-from-portal","fal fa-person-from-portal","fas fa-person-half-dress","far fa-person-half-dress","fal fa-person-half-dress","fas fa-person-harassing","far fa-person-harassing","fal fa-person-harassing","fas fa-person-hiking","far fa-person-hiking","fal fa-person-hiking","fas fa-person-military-pointing","far fa-person-military-pointing","fal fa-person-military-pointing","fas fa-person-military-rifle","far fa-person-military-rifle","fal fa-person-military-rifle","fas fa-person-military-to-person","far fa-person-military-to-person","fal fa-person-military-to-person","fas fa-person-pinball","far fa-person-pinball","fal fa-person-pinball","fas fa-person-praying","far fa-person-praying","fal fa-person-praying","fas fa-person-pregnant","far fa-person-pregnant","fal fa-person-pregnant","fas fa-person-rays","far fa-person-rays","fal fa-person-rays","fas fa-person-rifle","far fa-person-rifle","fal fa-person-rifle","fas fa-person-running","far fa-person-running","fal fa-person-running","fas fa-person-running-fast","far fa-person-running-fast","fal fa-person-running-fast","fas fa-person-seat","far fa-person-seat","fal fa-person-seat","fas fa-person-seat-reclined","far fa-person-seat-reclined","fal fa-person-seat-reclined","fas fa-person-shelter","far fa-person-shelter","fal fa-person-shelter","fas fa-person-sign","far fa-person-sign","fal fa-person-sign","fas fa-person-simple","far fa-person-simple","fal fa-person-simple","fas fa-person-skating","far fa-person-skating","fal fa-person-skating","fas fa-person-ski-jumping","far fa-person-ski-jumping","fal fa-person-ski-jumping","fas fa-person-ski-lift","far fa-person-ski-lift","fal fa-person-ski-lift","fas fa-person-skiing","far fa-person-skiing","fal fa-person-skiing","fas fa-person-skiing-nordic","far fa-person-skiing-nordic","fal fa-person-skiing-nordic","fas fa-person-sledding","far fa-person-sledding","fal fa-person-sledding","fas fa-person-snowboarding","far fa-person-snowboarding","fal fa-person-snowboarding","fas fa-person-snowmobiling","far fa-person-snowmobiling","fal fa-person-snowmobiling","fas fa-person-swimming","far fa-person-swimming","fal fa-person-swimming","fas fa-person-through-window","far fa-person-through-window","fal fa-person-through-window","fas fa-person-to-door","far fa-person-to-door","fal fa-person-to-door","fas fa-person-to-portal","far fa-person-to-portal","fal fa-person-to-portal","fas fa-person-walking","far fa-person-walking","fal fa-person-walking","fas fa-person-walking-arrow-loop-left","far fa-person-walking-arrow-loop-left","fal fa-person-walking-arrow-loop-left","fas fa-person-walking-arrow-right","far fa-person-walking-arrow-right","fal fa-person-walking-arrow-right","fas fa-person-walking-dashed-line-arrow-right","far fa-person-walking-dashed-line-arrow-right","fal fa-person-walking-dashed-line-arrow-right","fas fa-person-walking-luggage","far fa-person-walking-luggage","fal fa-person-walking-luggage","fas fa-person-walking-with-cane","far fa-person-walking-with-cane","fal fa-person-walking-with-cane","fas fa-poll-people","far fa-poll-people","fal fa-poll-people","fas fa-poo","far fa-poo","fal fa-poo","fas fa-restroom","far fa-restroom","fal fa-restroom","fas fa-restroom-simple","far fa-restroom-simple","fal fa-restroom-simple","fas fa-screen-users","far fa-screen-users","fal fa-screen-users","fas fa-skull","far fa-skull","fal fa-skull","fas fa-square-person-confined","far fa-square-person-confined","fal fa-square-person-confined","fas fa-square-user","far fa-square-user","fal fa-square-user","fas fa-street-view","far fa-street-view","fal fa-street-view","fas fa-user","far fa-user","fal fa-user","fas fa-user-alien","far fa-user-alien","fal fa-user-alien","fas fa-user-astronaut","far fa-user-astronaut","fal fa-user-astronaut","fas fa-user-beard-bolt","far fa-user-beard-bolt","fal fa-user-beard-bolt","fas fa-user-bounty-hunter","far fa-user-bounty-hunter","fal fa-user-bounty-hunter","fas fa-user-check","far fa-user-check","fal fa-user-check","fas fa-user-chef","far fa-user-chef","fal fa-user-chef","fas fa-user-clock","far fa-user-clock","fal fa-user-clock","fas fa-user-cowboy","far fa-user-cowboy","fal fa-user-cowboy","fas fa-user-crown","far fa-user-crown","fal fa-user-crown","fas fa-user-doctor","far fa-user-doctor","fal fa-user-doctor","fas fa-user-doctor-hair","far fa-user-doctor-hair","fal fa-user-doctor-hair","fas fa-user-doctor-hair-long","far fa-user-doctor-hair-long","fal fa-user-doctor-hair-long","fas fa-user-doctor-message","far fa-user-doctor-message","fal fa-user-doctor-message","fas fa-user-gear","far fa-user-gear","fal fa-user-gear","fas fa-user-graduate","far fa-user-graduate","fal fa-user-graduate","fas fa-user-group","far fa-user-group","fal fa-user-group","fas fa-user-group-crown","far fa-user-group-crown","fal fa-user-group-crown","fas fa-user-group-simple","far fa-user-group-simple","fal fa-user-group-simple","fas fa-user-hair","far fa-user-hair","fal fa-user-hair","fas fa-user-hair-buns","far fa-user-hair-buns","fal fa-user-hair-buns","fas fa-user-hair-long","far fa-user-hair-long","fal fa-user-hair-long","fas fa-user-hair-mullet","far fa-user-hair-mullet","fal fa-user-hair-mullet","fas fa-user-headset","far fa-user-headset","fal fa-user-headset","fas fa-user-helmet-safety","far fa-user-helmet-safety","fal fa-user-helmet-safety","fas fa-user-hoodie","far fa-user-hoodie","fal fa-user-hoodie","fas fa-user-injured","far fa-user-injured","fal fa-user-injured","fas fa-user-large","far fa-user-large","fal fa-user-large","fas fa-user-large-slash","far fa-user-large-slash","fal fa-user-large-slash","fas fa-user-lock","far fa-user-lock","fal fa-user-lock","fas fa-user-magnifying-glass","far fa-user-magnifying-glass","fal fa-user-magnifying-glass","fas fa-user-minus","far fa-user-minus","fal fa-user-minus","fas fa-user-music","far fa-user-music","fal fa-user-music","fas fa-user-ninja","far fa-user-ninja","fal fa-user-ninja","fas fa-user-nurse","far fa-user-nurse","fal fa-user-nurse","fas fa-user-nurse-hair","far fa-user-nurse-hair","fal fa-user-nurse-hair","fas fa-user-nurse-hair-long","far fa-user-nurse-hair-long","fal fa-user-nurse-hair-long","fas fa-user-pen","far fa-user-pen","fal fa-user-pen","fas fa-user-pilot","far fa-user-pilot","fal fa-user-pilot","fas fa-user-pilot-tie","far fa-user-pilot-tie","fal fa-user-pilot-tie","fas fa-user-plus","far fa-user-plus","fal fa-user-plus","fas fa-user-police","far fa-user-police","fal fa-user-police","fas fa-user-police-tie","far fa-user-police-tie","fal fa-user-police-tie","fas fa-user-robot","far fa-user-robot","fal fa-user-robot","fas fa-user-robot-xmarks","far fa-user-robot-xmarks","fal fa-user-robot-xmarks","fas fa-user-secret","far fa-user-secret","fal fa-user-secret","fas fa-user-shakespeare","far fa-user-shakespeare","fal fa-user-shakespeare","fas fa-user-shield","far fa-user-shield","fal fa-user-shield","fas fa-user-slash","far fa-user-slash","fal fa-user-slash","fas fa-user-tag","far fa-user-tag","fal fa-user-tag","fas fa-user-tie","far fa-user-tie","fal fa-user-tie","fas fa-user-tie-hair","far fa-user-tie-hair","fal fa-user-tie-hair","fas fa-user-tie-hair-long","far fa-user-tie-hair-long","fal fa-user-tie-hair-long","fas fa-user-unlock","far fa-user-unlock","fal fa-user-unlock","fas fa-user-visor","far fa-user-visor","fal fa-user-visor","fas fa-user-vneck","far fa-user-vneck","fal fa-user-vneck","fas fa-user-vneck-hair","far fa-user-vneck-hair","fal fa-user-vneck-hair","fas fa-user-vneck-hair-long","far fa-user-vneck-hair-long","fal fa-user-vneck-hair-long","fas fa-user-xmark","far fa-user-xmark","fal fa-user-xmark","fas fa-users","far fa-users","fal fa-users","fas fa-users-between-lines","far fa-users-between-lines","fal fa-users-between-lines","fas fa-users-gear","far fa-users-gear","fal fa-users-gear","fas fa-users-line","far fa-users-line","fal fa-users-line","fas fa-users-medical","far fa-users-medical","fal fa-users-medical","fas fa-users-rays","far fa-users-rays","fal fa-users-rays","fas fa-users-rectangle","far fa-users-rectangle","fal fa-users-rectangle","fas fa-users-slash","far fa-users-slash","fal fa-users-slash","fas fa-users-viewfinder","far fa-users-viewfinder","fal fa-users-viewfinder","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wheelchair-move","far fa-wheelchair-move","fal fa-wheelchair-move"]},{"id":"nature","title":"Nature","icons":["fas fa-acorn","far fa-acorn","fal fa-acorn","fas fa-bag-seedling","far fa-bag-seedling","fal fa-bag-seedling","fas fa-bench-tree","far fa-bench-tree","fal fa-bench-tree","fas fa-binoculars","far fa-binoculars","fal fa-binoculars","fas fa-bug","far fa-bug","fal fa-bug","fas fa-bugs","far fa-bugs","fal fa-bugs","fas fa-cactus","far fa-cactus","fal fa-cactus","fas fa-cannabis","far fa-cannabis","fal fa-cannabis","fas fa-chestnut","far fa-chestnut","fal fa-chestnut","fas fa-cloud-sun","far fa-cloud-sun","fal fa-cloud-sun","fas fa-clover","far fa-clover","fal fa-clover","fas fa-feather","far fa-feather","fal fa-feather","fas fa-feather-pointed","far fa-feather-pointed","fal fa-feather-pointed","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-smoke","far fa-fire-smoke","fal fa-fire-smoke","fas fa-flower","far fa-flower","fal fa-flower","fas fa-flower-daffodil","far fa-flower-daffodil","fal fa-flower-daffodil","fas fa-flower-tulip","far fa-flower-tulip","fal fa-flower-tulip","fas fa-frog","far fa-frog","fal fa-frog","fas fa-house-tree","far fa-house-tree","fal fa-house-tree","fas fa-icicles","far fa-icicles","fal fa-icicles","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-leaf-maple","far fa-leaf-maple","fal fa-leaf-maple","fas fa-leaf-oak","far fa-leaf-oak","fal fa-leaf-oak","fas fa-locust","far fa-locust","fal fa-locust","fas fa-mosquito","far fa-mosquito","fal fa-mosquito","fas fa-mound","far fa-mound","fal fa-mound","fas fa-mountain","far fa-mountain","fal fa-mountain","fas fa-mountain-city","far fa-mountain-city","fal fa-mountain-city","fas fa-mountain-sun","far fa-mountain-sun","fal fa-mountain-sun","fas fa-mountains","far fa-mountains","fal fa-mountains","fas fa-mushroom","far fa-mushroom","fal fa-mushroom","fas fa-person-hiking","far fa-person-hiking","fal fa-person-hiking","fas fa-plant-wilt","far fa-plant-wilt","fal fa-plant-wilt","fas fa-pompebled","far fa-pompebled","fal fa-pompebled","fas fa-raindrops","far fa-raindrops","fal fa-raindrops","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-sign-post","far fa-sign-post","fal fa-sign-post","fas fa-signs-post","far fa-signs-post","fal fa-signs-post","fas fa-spider","far fa-spider","fal fa-spider","fas fa-spider-black-widow","far fa-spider-black-widow","fal fa-spider-black-widow","fas fa-spider-web","far fa-spider-web","fal fa-spider-web","fas fa-tree","far fa-tree","fal fa-tree","fas fa-tree-deciduous","far fa-tree-deciduous","fal fa-tree-deciduous","fas fa-tree-large","far fa-tree-large","fal fa-tree-large","fas fa-tree-palm","far fa-tree-palm","fal fa-tree-palm","fas fa-trees","far fa-trees","fal fa-trees","fas fa-trillium","far fa-trillium","fal fa-trillium","fas fa-volcano","far fa-volcano","fal fa-volcano","fas fa-water","far fa-water","fal fa-water","fas fa-wave","far fa-wave","fal fa-wave","fas fa-wind","far fa-wind","fal fa-wind","fas fa-worm","far fa-worm","fal fa-worm"]},{"id":"coding","title":"Coding","icons":["fas fa-ban-bug","far fa-ban-bug","fal fa-ban-bug","fas fa-barcode","far fa-barcode","fal fa-barcode","fas fa-bars","far fa-bars","fal fa-bars","fas fa-bars-filter","far fa-bars-filter","fal fa-bars-filter","fas fa-bars-sort","far fa-bars-sort","fal fa-bars-sort","fas fa-bars-staggered","far fa-bars-staggered","fal fa-bars-staggered","fas fa-bath","far fa-bath","fal fa-bath","fas fa-binary","far fa-binary","fal fa-binary","fas fa-binary-circle-check","far fa-binary-circle-check","fal fa-binary-circle-check","fas fa-binary-lock","far fa-binary-lock","fal fa-binary-lock","fas fa-binary-slash","far fa-binary-slash","fal fa-binary-slash","fas fa-box-archive","far fa-box-archive","fal fa-box-archive","fas fa-bracket-curly","far fa-bracket-curly","fal fa-bracket-curly","fas fa-bracket-curly-right","far fa-bracket-curly-right","fal fa-bracket-curly-right","fas fa-bracket-round","far fa-bracket-round","fal fa-bracket-round","fas fa-bracket-round-right","far fa-bracket-round-right","fal fa-bracket-round-right","fas fa-bracket-square","far fa-bracket-square","fal fa-bracket-square","fas fa-bracket-square-right","far fa-bracket-square-right","fal fa-bracket-square-right","fas fa-brackets-curly","far fa-brackets-curly","fal fa-brackets-curly","fas fa-brackets-round","far fa-brackets-round","fal fa-brackets-round","fas fa-brackets-square","far fa-brackets-square","fal fa-brackets-square","fas fa-brain-circuit","far fa-brain-circuit","fal fa-brain-circuit","fas fa-browser","far fa-browser","fal fa-browser","fas fa-browsers","far fa-browsers","fal fa-browsers","fas fa-bug","far fa-bug","fal fa-bug","fas fa-bug-slash","far fa-bug-slash","fal fa-bug-slash","fas fa-circle-nodes","far fa-circle-nodes","fal fa-circle-nodes","fas fa-cloud-binary","far fa-cloud-binary","fal fa-cloud-binary","fas fa-code","far fa-code","fal fa-code","fas fa-code-branch","far fa-code-branch","fal fa-code-branch","fas fa-code-commit","far fa-code-commit","fal fa-code-commit","fas fa-code-compare","far fa-code-compare","fal fa-code-compare","fas fa-code-fork","far fa-code-fork","fal fa-code-fork","fas fa-code-merge","far fa-code-merge","fal fa-code-merge","fas fa-code-pull-request","far fa-code-pull-request","fal fa-code-pull-request","fas fa-code-pull-request-closed","far fa-code-pull-request-closed","fal fa-code-pull-request-closed","fas fa-code-pull-request-draft","far fa-code-pull-request-draft","fal fa-code-pull-request-draft","fas fa-code-simple","far fa-code-simple","fal fa-code-simple","fas fa-cube","far fa-cube","fal fa-cube","fas fa-cubes","far fa-cubes","fal fa-cubes","fas fa-diagram-project","far fa-diagram-project","fal fa-diagram-project","fas fa-file","far fa-file","fal fa-file","fas fa-file-code","far fa-file-code","fal fa-file-code","fas fa-file-lines","far fa-file-lines","fal fa-file-lines","fas fa-file-xml","far fa-file-xml","fal fa-file-xml","fas fa-filter","far fa-filter","fal fa-filter","fas fa-fire-extinguisher","far fa-fire-extinguisher","fal fa-fire-extinguisher","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-font-awesome","far fa-font-awesome","fal fa-font-awesome","fab fa-font-awesome","fas fa-gear","far fa-gear","fal fa-gear","fas fa-gear-code","far fa-gear-code","fal fa-gear-code","fas fa-gear-complex","far fa-gear-complex","fal fa-gear-complex","fas fa-gear-complex-code","far fa-gear-complex-code","fal fa-gear-complex-code","fas fa-gears","far fa-gears","fal fa-gears","fas fa-head-side-gear","far fa-head-side-gear","fal fa-head-side-gear","fas fa-key-skeleton-left-right","far fa-key-skeleton-left-right","fal fa-key-skeleton-left-right","fas fa-keyboard","far fa-keyboard","fal fa-keyboard","fas fa-laptop-binary","far fa-laptop-binary","fal fa-laptop-binary","fas fa-laptop-code","far fa-laptop-code","fal fa-laptop-code","fas fa-laptop-mobile","far fa-laptop-mobile","fal fa-laptop-mobile","fas fa-merge","far fa-merge","fal fa-merge","fas fa-microchip","far fa-microchip","fal fa-microchip","fas fa-mug-saucer","far fa-mug-saucer","fal fa-mug-saucer","fas fa-network-wired","far fa-network-wired","fal fa-network-wired","fas fa-notdef","far fa-notdef","fal fa-notdef","fas fa-octagon-exclamation","far fa-octagon-exclamation","fal fa-octagon-exclamation","fas fa-qrcode","far fa-qrcode","fal fa-qrcode","fas fa-rectangle-code","far fa-rectangle-code","fal fa-rectangle-code","fas fa-rectangle-terminal","far fa-rectangle-terminal","fal fa-rectangle-terminal","fas fa-rectangle-xmark","far fa-rectangle-xmark","fal fa-rectangle-xmark","fas fa-shield","far fa-shield","fal fa-shield","fas fa-shield-check","far fa-shield-check","fal fa-shield-check","fas fa-shield-halved","far fa-shield-halved","fal fa-shield-halved","fas fa-sidebar","far fa-sidebar","fal fa-sidebar","fas fa-sidebar-flip","far fa-sidebar-flip","fal fa-sidebar-flip","fas fa-sitemap","far fa-sitemap","fal fa-sitemap","fas fa-split","far fa-split","fal fa-split","fas fa-square-code","far fa-square-code","fal fa-square-code","fas fa-square-terminal","far fa-square-terminal","fal fa-square-terminal","fas fa-terminal","far fa-terminal","fal fa-terminal","fas fa-user-secret","far fa-user-secret","fal fa-user-secret","fas fa-web-awesome","far fa-web-awesome","fal fa-web-awesome","fab fa-web-awesome","fas fa-webhook","far fa-webhook","fal fa-webhook","fas fa-window","far fa-window","fal fa-window","fas fa-window-flip","far fa-window-flip","fal fa-window-flip","fas fa-window-maximize","far fa-window-maximize","fal fa-window-maximize","fas fa-window-minimize","far fa-window-minimize","fal fa-window-minimize","fas fa-window-restore","far fa-window-restore","fal fa-window-restore","fas fa-wrench-simple","far fa-wrench-simple","fal fa-wrench-simple"]},{"id":"astronomy","title":"Astronomy","icons":["fas fa-alien","far fa-alien","fal fa-alien","fas fa-binoculars","far fa-binoculars","fal fa-binoculars","fas fa-cat-space","far fa-cat-space","fal fa-cat-space","fas fa-comet","far fa-comet","fal fa-comet","fas fa-eclipse","far fa-eclipse","fal fa-eclipse","fas fa-galaxy","far fa-galaxy","fal fa-galaxy","fas fa-globe","far fa-globe","fal fa-globe","fas fa-meteor","far fa-meteor","fal fa-meteor","fas fa-moon","far fa-moon","fal fa-moon","fas fa-moon-over-sun","far fa-moon-over-sun","fal fa-moon-over-sun","fas fa-moon-stars","far fa-moon-stars","fal fa-moon-stars","fas fa-planet-moon","far fa-planet-moon","fal fa-planet-moon","fas fa-planet-ringed","far fa-planet-ringed","fal fa-planet-ringed","fas fa-radar","far fa-radar","fal fa-radar","fas fa-satellite","far fa-satellite","fal fa-satellite","fas fa-satellite-dish","far fa-satellite-dish","fal fa-satellite-dish","fas fa-shuttle-space","far fa-shuttle-space","fal fa-shuttle-space","fas fa-solar-system","far fa-solar-system","fal fa-solar-system","fas fa-star-shooting","far fa-star-shooting","fal fa-star-shooting","fas fa-stars","far fa-stars","fal fa-stars","fas fa-telescope","far fa-telescope","fal fa-telescope","fas fa-ufo","far fa-ufo","fal fa-ufo","fas fa-ufo-beam","far fa-ufo-beam","fal fa-ufo-beam","fas fa-user-alien","far fa-user-alien","fal fa-user-alien","fas fa-user-astronaut","far fa-user-astronaut","fal fa-user-astronaut"]},{"id":"marketing","title":"Marketing","icons":["fas fa-arrows-spin","far fa-arrows-spin","fal fa-arrows-spin","fas fa-arrows-to-dot","far fa-arrows-to-dot","fal fa-arrows-to-dot","fas fa-arrows-to-eye","far fa-arrows-to-eye","fal fa-arrows-to-eye","fas fa-badge","far fa-badge","fal fa-badge","fas fa-badge-check","far fa-badge-check","fal fa-badge-check","fas fa-badge-dollar","far fa-badge-dollar","fal fa-badge-dollar","fas fa-badge-percent","far fa-badge-percent","fal fa-badge-percent","fas fa-billboard","far fa-billboard","fal fa-billboard","fas fa-block-question","far fa-block-question","fal fa-block-question","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-bullseye","far fa-bullseye","fal fa-bullseye","fas fa-bullseye-arrow","far fa-bullseye-arrow","fal fa-bullseye-arrow","fas fa-bullseye-pointer","far fa-bullseye-pointer","fal fa-bullseye-pointer","fas fa-chart-mixed","far fa-chart-mixed","fal fa-chart-mixed","fas fa-chart-mixed-up-circle-currency","far fa-chart-mixed-up-circle-currency","fal fa-chart-mixed-up-circle-currency","fas fa-chart-mixed-up-circle-dollar","far fa-chart-mixed-up-circle-dollar","fal fa-chart-mixed-up-circle-dollar","fas fa-chart-simple","far fa-chart-simple","fal fa-chart-simple","fas fa-chart-simple-horizontal","far fa-chart-simple-horizontal","fal fa-chart-simple-horizontal","fas fa-comment-dollar","far fa-comment-dollar","fal fa-comment-dollar","fas fa-comments-dollar","far fa-comments-dollar","fal fa-comments-dollar","fas fa-display-chart-up","far fa-display-chart-up","fal fa-display-chart-up","fas fa-display-chart-up-circle-currency","far fa-display-chart-up-circle-currency","fal fa-display-chart-up-circle-currency","fas fa-display-chart-up-circle-dollar","far fa-display-chart-up-circle-dollar","fal fa-display-chart-up-circle-dollar","fas fa-envelope-open-dollar","far fa-envelope-open-dollar","fal fa-envelope-open-dollar","fas fa-envelope-open-text","far fa-envelope-open-text","fal fa-envelope-open-text","fas fa-envelopes-bulk","far fa-envelopes-bulk","fal fa-envelopes-bulk","fas fa-filter-circle-dollar","far fa-filter-circle-dollar","fal fa-filter-circle-dollar","fas fa-gift-card","far fa-gift-card","fal fa-gift-card","fas fa-globe-pointer","far fa-globe-pointer","fal fa-globe-pointer","fas fa-group-arrows-rotate","far fa-group-arrows-rotate","fal fa-group-arrows-rotate","fas fa-hundred-points","far fa-hundred-points","fal fa-hundred-points","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-lightbulb-cfl","far fa-lightbulb-cfl","fal fa-lightbulb-cfl","fas fa-lightbulb-cfl-on","far fa-lightbulb-cfl-on","fal fa-lightbulb-cfl-on","fas fa-lightbulb-dollar","far fa-lightbulb-dollar","fal fa-lightbulb-dollar","fas fa-lightbulb-exclamation","far fa-lightbulb-exclamation","fal fa-lightbulb-exclamation","fas fa-lightbulb-gear","far fa-lightbulb-gear","fal fa-lightbulb-gear","fas fa-lightbulb-on","far fa-lightbulb-on","fal fa-lightbulb-on","fas fa-lightbulb-slash","far fa-lightbulb-slash","fal fa-lightbulb-slash","fas fa-magnifying-glass-arrow-right","far fa-magnifying-glass-arrow-right","fal fa-magnifying-glass-arrow-right","fas fa-magnifying-glass-chart","far fa-magnifying-glass-chart","fal fa-magnifying-glass-chart","fas fa-magnifying-glass-dollar","far fa-magnifying-glass-dollar","fal fa-magnifying-glass-dollar","fas fa-magnifying-glass-location","far fa-magnifying-glass-location","fal fa-magnifying-glass-location","fas fa-megaphone","far fa-megaphone","fal fa-megaphone","fas fa-message-dollar","far fa-message-dollar","fal fa-message-dollar","fas fa-messages-dollar","far fa-messages-dollar","fal fa-messages-dollar","fas fa-people-group","far fa-people-group","fal fa-people-group","fas fa-person-rays","far fa-person-rays","fal fa-person-rays","fas fa-ranking-star","far fa-ranking-star","fal fa-ranking-star","fas fa-rectangle-ad","far fa-rectangle-ad","fal fa-rectangle-ad","fas fa-rectangle-pro","far fa-rectangle-pro","fal fa-rectangle-pro","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-signal-stream-slash","far fa-signal-stream-slash","fal fa-signal-stream-slash","fas fa-sparkle","far fa-sparkle","fal fa-sparkle","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-square-poll-horizontal","far fa-square-poll-horizontal","fal fa-square-poll-horizontal","fas fa-square-poll-vertical","far fa-square-poll-vertical","fal fa-square-poll-vertical","fas fa-timeline","far fa-timeline","fal fa-timeline","fas fa-timeline-arrow","far fa-timeline-arrow","fal fa-timeline-arrow","fas fa-user-crown","far fa-user-crown","fal fa-user-crown","fas fa-user-group-crown","far fa-user-group-crown","fal fa-user-group-crown"]},{"id":"maps","title":"Maps","icons":["fas fa-anchor","far fa-anchor","fal fa-anchor","fas fa-arrow-turn-left","far fa-arrow-turn-left","fal fa-arrow-turn-left","fas fa-arrow-turn-left-down","far fa-arrow-turn-left-down","fal fa-arrow-turn-left-down","fas fa-arrow-turn-left-up","far fa-arrow-turn-left-up","fal fa-arrow-turn-left-up","fas fa-arrow-turn-right","far fa-arrow-turn-right","fal fa-arrow-turn-right","fas fa-bag-shopping","far fa-bag-shopping","fal fa-bag-shopping","fas fa-bags-shopping","far fa-bags-shopping","fal fa-bags-shopping","fas fa-ban-parking","far fa-ban-parking","fal fa-ban-parking","fas fa-basket-shopping","far fa-basket-shopping","fal fa-basket-shopping","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bed","far fa-bed","fal fa-bed","fas fa-beer-mug-empty","far fa-beer-mug-empty","fal fa-beer-mug-empty","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-bicycle","far fa-bicycle","fal fa-bicycle","fas fa-binoculars","far fa-binoculars","fal fa-binoculars","fas fa-bomb","far fa-bomb","fal fa-bomb","fas fa-book","far fa-book","fal fa-book","fas fa-book-atlas","far fa-book-atlas","fal fa-book-atlas","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fas fa-bridge","far fa-bridge","fal fa-bridge","fas fa-bridge-suspension","far fa-bridge-suspension","fal fa-bridge-suspension","fas fa-bridge-water","far fa-bridge-water","fal fa-bridge-water","fas fa-briefcase","far fa-briefcase","fal fa-briefcase","fas fa-building","far fa-building","fal fa-building","fas fa-building-columns","far fa-building-columns","fal fa-building-columns","fas fa-cake-candles","far fa-cake-candles","fal fa-cake-candles","fas fa-camera-cctv","far fa-camera-cctv","fal fa-camera-cctv","fas fa-cannon","far fa-cannon","fal fa-cannon","fas fa-car","far fa-car","fal fa-car","fas fa-cart-shopping","far fa-cart-shopping","fal fa-cart-shopping","fas fa-circle-dollar","far fa-circle-dollar","fal fa-circle-dollar","fas fa-circle-info","far fa-circle-info","fal fa-circle-info","fas fa-circle-location-arrow","far fa-circle-location-arrow","fal fa-circle-location-arrow","fas fa-circle-parking","far fa-circle-parking","fal fa-circle-parking","fas fa-compass-slash","far fa-compass-slash","fal fa-compass-slash","fas fa-court-sport","far fa-court-sport","fal fa-court-sport","fas fa-crosshairs","far fa-crosshairs","fal fa-crosshairs","fas fa-crosshairs-simple","far fa-crosshairs-simple","fal fa-crosshairs-simple","fas fa-diamond-turn-right","far fa-diamond-turn-right","fal fa-diamond-turn-right","fas fa-do-not-enter","far fa-do-not-enter","fal fa-do-not-enter","fas fa-dollar-sign","far fa-dollar-sign","fal fa-dollar-sign","fas fa-draw-circle","far fa-draw-circle","fal fa-draw-circle","fas fa-draw-polygon","far fa-draw-polygon","fal fa-draw-polygon","fas fa-draw-square","far fa-draw-square","fal fa-draw-square","fas fa-droplet","far fa-droplet","fal fa-droplet","fas fa-excavator","far fa-excavator","fal fa-excavator","fas fa-eye","far fa-eye","fal fa-eye","fas fa-eye-low-vision","far fa-eye-low-vision","fal fa-eye-low-vision","fas fa-eye-slash","far fa-eye-slash","fal fa-eye-slash","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-extinguisher","far fa-fire-extinguisher","fal fa-fire-extinguisher","fas fa-fire-flame-curved","far fa-fire-flame-curved","fal fa-fire-flame-curved","fas fa-flag","far fa-flag","fal fa-flag","fas fa-flag-checkered","far fa-flag-checkered","fal fa-flag-checkered","fas fa-flask","far fa-flask","fal fa-flask","fas fa-fork","far fa-fork","fal fa-fork","fas fa-fork-knife","far fa-fork-knife","fal fa-fork-knife","fas fa-gamepad","far fa-gamepad","fal fa-gamepad","fas fa-gavel","far fa-gavel","fal fa-gavel","fas fa-gift","far fa-gift","fal fa-gift","fas fa-globe","far fa-globe","fal fa-globe","fas fa-graduation-cap","far fa-graduation-cap","fal fa-graduation-cap","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-pulse","far fa-heart-pulse","fal fa-heart-pulse","fas fa-helicopter","far fa-helicopter","fal fa-helicopter","fas fa-helicopter-symbol","far fa-helicopter-symbol","fal fa-helicopter-symbol","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-house","far fa-house","fal fa-house","fas fa-image","far fa-image","fal fa-image","fas fa-images","far fa-images","fal fa-images","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-windows","far fa-industry-windows","fal fa-industry-windows","fas fa-info","far fa-info","fal fa-info","fas fa-jet-fighter","far fa-jet-fighter","fal fa-jet-fighter","fas fa-key","far fa-key","fal fa-key","fas fa-knife","far fa-knife","fal fa-knife","fas fa-landmark","far fa-landmark","fal fa-landmark","fas fa-landmark-flag","far fa-landmark-flag","fal fa-landmark-flag","fas fa-layer-group","far fa-layer-group","fal fa-layer-group","fas fa-layer-minus","far fa-layer-minus","fal fa-layer-minus","fas fa-layer-plus","far fa-layer-plus","fal fa-layer-plus","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-lemon","far fa-lemon","fal fa-lemon","fas fa-life-ring","far fa-life-ring","fal fa-life-ring","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-lighthouse","far fa-lighthouse","fal fa-lighthouse","fas fa-location-arrow","far fa-location-arrow","fal fa-location-arrow","fas fa-location-arrow-up","far fa-location-arrow-up","fal fa-location-arrow-up","fas fa-location-check","far fa-location-check","fal fa-location-check","fas fa-location-crosshairs","far fa-location-crosshairs","fal fa-location-crosshairs","fas fa-location-crosshairs-slash","far fa-location-crosshairs-slash","fal fa-location-crosshairs-slash","fas fa-location-dot","far fa-location-dot","fal fa-location-dot","fas fa-location-dot-slash","far fa-location-dot-slash","fal fa-location-dot-slash","fas fa-location-exclamation","far fa-location-exclamation","fal fa-location-exclamation","fas fa-location-minus","far fa-location-minus","fal fa-location-minus","fas fa-location-pen","far fa-location-pen","fal fa-location-pen","fas fa-location-pin","far fa-location-pin","fal fa-location-pin","fas fa-location-pin-lock","far fa-location-pin-lock","fal fa-location-pin-lock","fas fa-location-pin-slash","far fa-location-pin-slash","fal fa-location-pin-slash","fas fa-location-plus","far fa-location-plus","fal fa-location-plus","fas fa-location-question","far fa-location-question","fal fa-location-question","fas fa-location-smile","far fa-location-smile","fal fa-location-smile","fas fa-location-xmark","far fa-location-xmark","fal fa-location-xmark","fas fa-magnet","far fa-magnet","fal fa-magnet","fas fa-magnifying-glass","far fa-magnifying-glass","fal fa-magnifying-glass","fas fa-magnifying-glass-location","far fa-magnifying-glass-location","fal fa-magnifying-glass-location","fas fa-magnifying-glass-minus","far fa-magnifying-glass-minus","fal fa-magnifying-glass-minus","fas fa-magnifying-glass-plus","far fa-magnifying-glass-plus","fal fa-magnifying-glass-plus","fas fa-map","far fa-map","fal fa-map","fas fa-map-pin","far fa-map-pin","fal fa-map-pin","fas fa-martini-glass-empty","far fa-martini-glass-empty","fal fa-martini-glass-empty","fas fa-money-bill","far fa-money-bill","fal fa-money-bill","fas fa-money-bill-1","far fa-money-bill-1","fal fa-money-bill-1","fas fa-monument","far fa-monument","fal fa-monument","fas fa-motorcycle","far fa-motorcycle","fal fa-motorcycle","fas fa-mountain-sun","far fa-mountain-sun","fal fa-mountain-sun","fas fa-mug-saucer","far fa-mug-saucer","fal fa-mug-saucer","fas fa-music","far fa-music","fal fa-music","fas fa-newspaper","far fa-newspaper","fal fa-newspaper","fas fa-paw","far fa-paw","fal fa-paw","fas fa-person","far fa-person","fal fa-person","fas fa-person-walking-with-cane","far fa-person-walking-with-cane","fal fa-person-walking-with-cane","fas fa-phone","far fa-phone","fal fa-phone","fas fa-phone-flip","far fa-phone-flip","fal fa-phone-flip","fas fa-phone-volume","far fa-phone-volume","fal fa-phone-volume","fas fa-plane","far fa-plane","fal fa-plane","fas fa-plane-engines","far fa-plane-engines","fal fa-plane-engines","fas fa-plug","far fa-plug","fal fa-plug","fas fa-plus","far fa-plus","fal fa-plus","fas fa-print","far fa-print","fal fa-print","fas fa-recycle","far fa-recycle","fal fa-recycle","fas fa-restroom","far fa-restroom","fal fa-restroom","fas fa-road","far fa-road","fal fa-road","fas fa-rocket","far fa-rocket","fal fa-rocket","fas fa-route","far fa-route","fal fa-route","fas fa-route-highway","far fa-route-highway","fal fa-route-highway","fas fa-route-interstate","far fa-route-interstate","fal fa-route-interstate","fas fa-scale-balanced","far fa-scale-balanced","fal fa-scale-balanced","fas fa-scale-unbalanced","far fa-scale-unbalanced","fal fa-scale-unbalanced","fas fa-scale-unbalanced-flip","far fa-scale-unbalanced-flip","fal fa-scale-unbalanced-flip","fas fa-ship","far fa-ship","fal fa-ship","fas fa-shoe-prints","far fa-shoe-prints","fal fa-shoe-prints","fas fa-shower","far fa-shower","fal fa-shower","fas fa-sign-post","far fa-sign-post","fal fa-sign-post","fas fa-sign-posts","far fa-sign-posts","fal fa-sign-posts","fas fa-sign-posts-wrench","far fa-sign-posts-wrench","fal fa-sign-posts-wrench","fas fa-signs-post","far fa-signs-post","fal fa-signs-post","fas fa-skull-cow","far fa-skull-cow","fal fa-skull-cow","fas fa-snowplow","far fa-snowplow","fal fa-snowplow","fas fa-spoon","far fa-spoon","fal fa-spoon","fas fa-square-dollar","far fa-square-dollar","fal fa-square-dollar","fas fa-square-h","far fa-square-h","fal fa-square-h","fas fa-square-info","far fa-square-info","fal fa-square-info","fas fa-square-parking","far fa-square-parking","fal fa-square-parking","fas fa-square-parking-slash","far fa-square-parking-slash","fal fa-square-parking-slash","fas fa-square-phone","far fa-square-phone","fal fa-square-phone","fas fa-square-phone-flip","far fa-square-phone-flip","fal fa-square-phone-flip","fas fa-square-plus","far fa-square-plus","fal fa-square-plus","fas fa-street-view","far fa-street-view","fal fa-street-view","fas fa-suitcase","far fa-suitcase","fal fa-suitcase","fas fa-suitcase-medical","far fa-suitcase-medical","fal fa-suitcase-medical","fas fa-swap","far fa-swap","fal fa-swap","fas fa-swap-arrows","far fa-swap-arrows","fal fa-swap-arrows","fas fa-tag","far fa-tag","fal fa-tag","fas fa-tags","far fa-tags","fal fa-tags","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack","fas fa-thumbtack-slash","far fa-thumbtack-slash","fal fa-thumbtack-slash","fas fa-ticket","far fa-ticket","fal fa-ticket","fas fa-ticket-simple","far fa-ticket-simple","fal fa-ticket-simple","fas fa-tickets","far fa-tickets","fal fa-tickets","fas fa-tickets-simple","far fa-tickets-simple","fal fa-tickets-simple","fas fa-traffic-cone","far fa-traffic-cone","fal fa-traffic-cone","fas fa-traffic-light","far fa-traffic-light","fal fa-traffic-light","fas fa-traffic-light-go","far fa-traffic-light-go","fal fa-traffic-light-go","fas fa-traffic-light-slow","far fa-traffic-light-slow","fal fa-traffic-light-slow","fas fa-traffic-light-stop","far fa-traffic-light-stop","fal fa-traffic-light-stop","fas fa-train","far fa-train","fal fa-train","fas fa-train-subway","far fa-train-subway","fal fa-train-subway","fas fa-train-track","far fa-train-track","fal fa-train-track","fas fa-train-tram","far fa-train-tram","fal fa-train-tram","fas fa-tree","far fa-tree","fal fa-tree","fas fa-tree-deciduous","far fa-tree-deciduous","fal fa-tree-deciduous","fas fa-trophy","far fa-trophy","fal fa-trophy","fas fa-trophy-star","far fa-trophy-star","fal fa-trophy-star","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-fire","far fa-truck-fire","fal fa-truck-fire","fas fa-truck-medical","far fa-truck-medical","fal fa-truck-medical","fas fa-truck-plow","far fa-truck-plow","fal fa-truck-plow","fas fa-tty","far fa-tty","fal fa-tty","fas fa-turn-left","far fa-turn-left","fal fa-turn-left","fas fa-turn-left-down","far fa-turn-left-down","fal fa-turn-left-down","fas fa-turn-left-up","far fa-turn-left-up","fal fa-turn-left-up","fas fa-turn-right","far fa-turn-right","fal fa-turn-right","fas fa-umbrella","far fa-umbrella","fal fa-umbrella","fas fa-utensils","far fa-utensils","fal fa-utensils","fas fa-vest","far fa-vest","fal fa-vest","fas fa-vest-patches","far fa-vest-patches","fal fa-vest-patches","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wheelchair-move","far fa-wheelchair-move","fal fa-wheelchair-move","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass","fas fa-wrench","far fa-wrench","fal fa-wrench"]},{"id":"religion","title":"Religion","icons":["fas fa-ankh","far fa-ankh","fal fa-ankh","fas fa-atom","far fa-atom","fal fa-atom","fas fa-bahai","far fa-bahai","fal fa-bahai","fas fa-book-bible","far fa-book-bible","fal fa-book-bible","fas fa-book-journal-whills","far fa-book-journal-whills","fal fa-book-journal-whills","fas fa-book-quran","far fa-book-quran","fal fa-book-quran","fas fa-book-tanakh","far fa-book-tanakh","fal fa-book-tanakh","fas fa-church","far fa-church","fal fa-church","fas fa-coffin-cross","far fa-coffin-cross","fal fa-coffin-cross","fas fa-cross","far fa-cross","fal fa-cross","fas fa-dharmachakra","far fa-dharmachakra","fal fa-dharmachakra","fas fa-dove","far fa-dove","fal fa-dove","fas fa-gopuram","far fa-gopuram","fal fa-gopuram","fas fa-hamsa","far fa-hamsa","fal fa-hamsa","fas fa-hands-praying","far fa-hands-praying","fal fa-hands-praying","fas fa-hanukiah","far fa-hanukiah","fal fa-hanukiah","fas fa-jedi","far fa-jedi","fal fa-jedi","fas fa-kaaba","far fa-kaaba","fal fa-kaaba","fas fa-khanda","far fa-khanda","fal fa-khanda","fas fa-menorah","far fa-menorah","fal fa-menorah","fas fa-mosque","far fa-mosque","fal fa-mosque","fas fa-om","far fa-om","fal fa-om","fas fa-peace","far fa-peace","fal fa-peace","fas fa-person-praying","far fa-person-praying","fal fa-person-praying","fas fa-place-of-worship","far fa-place-of-worship","fal fa-place-of-worship","fas fa-scroll-torah","far fa-scroll-torah","fal fa-scroll-torah","fas fa-spaghetti-monster-flying","far fa-spaghetti-monster-flying","fal fa-spaghetti-monster-flying","fas fa-star-and-crescent","far fa-star-and-crescent","fal fa-star-and-crescent","fas fa-star-of-david","far fa-star-of-david","fal fa-star-of-david","fas fa-synagogue","far fa-synagogue","fal fa-synagogue","fas fa-tombstone","far fa-tombstone","fal fa-tombstone","fas fa-tombstone-blank","far fa-tombstone-blank","fal fa-tombstone-blank","fas fa-torii-gate","far fa-torii-gate","fal fa-torii-gate","fas fa-user-beard-bolt","far fa-user-beard-bolt","fal fa-user-beard-bolt","fas fa-vihara","far fa-vihara","fal fa-vihara","fas fa-yin-yang","far fa-yin-yang","fal fa-yin-yang"]},{"id":"political","title":"Political","icons":["fas fa-award","far fa-award","fal fa-award","fas fa-ballot","far fa-ballot","fal fa-ballot","fas fa-ballot-check","far fa-ballot-check","fal fa-ballot-check","fas fa-booth-curtain","far fa-booth-curtain","fal fa-booth-curtain","fas fa-box-ballot","far fa-box-ballot","fal fa-box-ballot","fas fa-building-flag","far fa-building-flag","fal fa-building-flag","fas fa-bullhorn","far fa-bullhorn","fal fa-bullhorn","fas fa-calendar-star","far fa-calendar-star","fal fa-calendar-star","fas fa-check-double","far fa-check-double","fal fa-check-double","fas fa-check-to-slot","far fa-check-to-slot","fal fa-check-to-slot","fas fa-circle-dollar-to-slot","far fa-circle-dollar-to-slot","fal fa-circle-dollar-to-slot","fas fa-clipboard-list-check","far fa-clipboard-list-check","fal fa-clipboard-list-check","fas fa-democrat","far fa-democrat","fal fa-democrat","fas fa-dove","far fa-dove","fal fa-dove","fas fa-dumpster-fire","far fa-dumpster-fire","fal fa-dumpster-fire","fas fa-flag-swallowtail","far fa-flag-swallowtail","fal fa-flag-swallowtail","fas fa-flag-usa","far fa-flag-usa","fal fa-flag-usa","fas fa-hand-fist","far fa-hand-fist","fal fa-hand-fist","fas fa-handshake","far fa-handshake","fal fa-handshake","fas fa-landmark-dome","far fa-landmark-dome","fal fa-landmark-dome","fas fa-landmark-flag","far fa-landmark-flag","fal fa-landmark-flag","fas fa-person-booth","far fa-person-booth","fal fa-person-booth","fas fa-person-sign","far fa-person-sign","fal fa-person-sign","fas fa-piggy-bank","far fa-piggy-bank","fal fa-piggy-bank","fas fa-podium","far fa-podium","fal fa-podium","fas fa-podium-star","far fa-podium-star","fal fa-podium-star","fas fa-poll-people","far fa-poll-people","fal fa-poll-people","fas fa-republican","far fa-republican","fal fa-republican","fas fa-scale-balanced","far fa-scale-balanced","fal fa-scale-balanced","fas fa-scale-unbalanced","far fa-scale-unbalanced","fal fa-scale-unbalanced","fas fa-scale-unbalanced-flip","far fa-scale-unbalanced-flip","fal fa-scale-unbalanced-flip","fas fa-tally","far fa-tally","fal fa-tally","fas fa-xmark-to-slot","far fa-xmark-to-slot","fal fa-xmark-to-slot"]},{"id":"charts-diagrams","title":"Charts + Diagrams","icons":["fas fa-bars-progress","far fa-bars-progress","fal fa-bars-progress","fas fa-chart-area","far fa-chart-area","fal fa-chart-area","fas fa-chart-bar","far fa-chart-bar","fal fa-chart-bar","fas fa-chart-bullet","far fa-chart-bullet","fal fa-chart-bullet","fas fa-chart-candlestick","far fa-chart-candlestick","fal fa-chart-candlestick","fas fa-chart-column","far fa-chart-column","fal fa-chart-column","fas fa-chart-gantt","far fa-chart-gantt","fal fa-chart-gantt","fas fa-chart-kanban","far fa-chart-kanban","fal fa-chart-kanban","fas fa-chart-line","far fa-chart-line","fal fa-chart-line","fas fa-chart-line-down","far fa-chart-line-down","fal fa-chart-line-down","fas fa-chart-line-up","far fa-chart-line-up","fal fa-chart-line-up","fas fa-chart-line-up-down","far fa-chart-line-up-down","fal fa-chart-line-up-down","fas fa-chart-mixed","far fa-chart-mixed","fal fa-chart-mixed","fas fa-chart-mixed-up-circle-currency","far fa-chart-mixed-up-circle-currency","fal fa-chart-mixed-up-circle-currency","fas fa-chart-mixed-up-circle-dollar","far fa-chart-mixed-up-circle-dollar","fal fa-chart-mixed-up-circle-dollar","fas fa-chart-network","far fa-chart-network","fal fa-chart-network","fas fa-chart-pie","far fa-chart-pie","fal fa-chart-pie","fas fa-chart-pie-simple","far fa-chart-pie-simple","fal fa-chart-pie-simple","fas fa-chart-pie-simple-circle-currency","far fa-chart-pie-simple-circle-currency","fal fa-chart-pie-simple-circle-currency","fas fa-chart-pie-simple-circle-dollar","far fa-chart-pie-simple-circle-dollar","fal fa-chart-pie-simple-circle-dollar","fas fa-chart-pyramid","far fa-chart-pyramid","fal fa-chart-pyramid","fas fa-chart-radar","far fa-chart-radar","fal fa-chart-radar","fas fa-chart-scatter","far fa-chart-scatter","fal fa-chart-scatter","fas fa-chart-scatter-3d","far fa-chart-scatter-3d","fal fa-chart-scatter-3d","fas fa-chart-scatter-bubble","far fa-chart-scatter-bubble","fal fa-chart-scatter-bubble","fas fa-chart-simple","far fa-chart-simple","fal fa-chart-simple","fas fa-chart-simple-horizontal","far fa-chart-simple-horizontal","fal fa-chart-simple-horizontal","fas fa-chart-tree-map","far fa-chart-tree-map","fal fa-chart-tree-map","fas fa-chart-user","far fa-chart-user","fal fa-chart-user","fas fa-chart-waterfall","far fa-chart-waterfall","fal fa-chart-waterfall","fas fa-circle-half-stroke","far fa-circle-half-stroke","fal fa-circle-half-stroke","fas fa-circle-quarter-stroke","far fa-circle-quarter-stroke","fal fa-circle-quarter-stroke","fas fa-circle-three-quarters-stroke","far fa-circle-three-quarters-stroke","fal fa-circle-three-quarters-stroke","fas fa-diagram-cells","far fa-diagram-cells","fal fa-diagram-cells","fas fa-diagram-lean-canvas","far fa-diagram-lean-canvas","fal fa-diagram-lean-canvas","fas fa-diagram-nested","far fa-diagram-nested","fal fa-diagram-nested","fas fa-diagram-next","far fa-diagram-next","fal fa-diagram-next","fas fa-diagram-predecessor","far fa-diagram-predecessor","fal fa-diagram-predecessor","fas fa-diagram-previous","far fa-diagram-previous","fal fa-diagram-previous","fas fa-diagram-project","far fa-diagram-project","fal fa-diagram-project","fas fa-diagram-sankey","far fa-diagram-sankey","fal fa-diagram-sankey","fas fa-diagram-subtask","far fa-diagram-subtask","fal fa-diagram-subtask","fas fa-diagram-successor","far fa-diagram-successor","fal fa-diagram-successor","fas fa-diagram-venn","far fa-diagram-venn","fal fa-diagram-venn","fas fa-display-chart-up","far fa-display-chart-up","fal fa-display-chart-up","fas fa-display-chart-up-circle-currency","far fa-display-chart-up-circle-currency","fal fa-display-chart-up-circle-currency","fas fa-display-chart-up-circle-dollar","far fa-display-chart-up-circle-dollar","fal fa-display-chart-up-circle-dollar","fas fa-file-chart-column","far fa-file-chart-column","fal fa-file-chart-column","fas fa-file-chart-pie","far fa-file-chart-pie","fal fa-file-chart-pie","fas fa-square-kanban","far fa-square-kanban","fal fa-square-kanban","fas fa-square-poll-horizontal","far fa-square-poll-horizontal","fal fa-square-poll-horizontal","fas fa-square-poll-vertical","far fa-square-poll-vertical","fal fa-square-poll-vertical"]},{"id":"charity","title":"Charity","icons":["fas fa-book-heart","far fa-book-heart","fal fa-book-heart","fas fa-box-dollar","far fa-box-dollar","fal fa-box-dollar","fas fa-box-heart","far fa-box-heart","fal fa-box-heart","fas fa-circle-dollar","far fa-circle-dollar","fal fa-circle-dollar","fas fa-circle-dollar-to-slot","far fa-circle-dollar-to-slot","fal fa-circle-dollar-to-slot","fas fa-circle-heart","far fa-circle-heart","fal fa-circle-heart","fas fa-dollar-sign","far fa-dollar-sign","fal fa-dollar-sign","fas fa-dove","far fa-dove","fal fa-dove","fas fa-gift","far fa-gift","fal fa-gift","fas fa-globe","far fa-globe","fal fa-globe","fas fa-hand-heart","far fa-hand-heart","fal fa-hand-heart","fas fa-hand-holding-circle-dollar","far fa-hand-holding-circle-dollar","fal fa-hand-holding-circle-dollar","fas fa-hand-holding-dollar","far fa-hand-holding-dollar","fal fa-hand-holding-dollar","fas fa-hand-holding-droplet","far fa-hand-holding-droplet","fal fa-hand-holding-droplet","fas fa-hand-holding-hand","far fa-hand-holding-hand","fal fa-hand-holding-hand","fas fa-hand-holding-heart","far fa-hand-holding-heart","fal fa-hand-holding-heart","fas fa-hand-holding-seedling","far fa-hand-holding-seedling","fal fa-hand-holding-seedling","fas fa-hands-holding-child","far fa-hands-holding-child","fal fa-hands-holding-child","fas fa-hands-holding-circle","far fa-hands-holding-circle","fal fa-hands-holding-circle","fas fa-hands-holding-dollar","far fa-hands-holding-dollar","fal fa-hands-holding-dollar","fas fa-hands-holding-heart","far fa-hands-holding-heart","fal fa-hands-holding-heart","fas fa-handshake","far fa-handshake","fal fa-handshake","fas fa-handshake-angle","far fa-handshake-angle","fal fa-handshake-angle","fas fa-handshake-simple","far fa-handshake-simple","fal fa-handshake-simple","fas fa-heart","far fa-heart","fal fa-heart","fas fa-house-chimney-heart","far fa-house-chimney-heart","fal fa-house-chimney-heart","fas fa-house-heart","far fa-house-heart","fal fa-house-heart","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-leaf-heart","far fa-leaf-heart","fal fa-leaf-heart","fas fa-money-check-dollar-pen","far fa-money-check-dollar-pen","fal fa-money-check-dollar-pen","fas fa-money-check-pen","far fa-money-check-pen","fal fa-money-check-pen","fas fa-parachute-box","far fa-parachute-box","fal fa-parachute-box","fas fa-piggy-bank","far fa-piggy-bank","fal fa-piggy-bank","fas fa-ribbon","far fa-ribbon","fal fa-ribbon","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-square-dollar","far fa-square-dollar","fal fa-square-dollar","fas fa-square-heart","far fa-square-heart","fal fa-square-heart"]},{"id":"halloween","title":"Halloween","icons":["fas fa-bat","far fa-bat","fal fa-bat","fas fa-book-skull","far fa-book-skull","fal fa-book-skull","fas fa-book-sparkles","far fa-book-sparkles","fal fa-book-sparkles","fas fa-broom","far fa-broom","fal fa-broom","fas fa-candle-holder","far fa-candle-holder","fal fa-candle-holder","fas fa-candy","far fa-candy","fal fa-candy","fas fa-candy-corn","far fa-candy-corn","fal fa-candy-corn","fas fa-cat","far fa-cat","fal fa-cat","fas fa-cauldron","far fa-cauldron","fal fa-cauldron","fas fa-claw-marks","far fa-claw-marks","fal fa-claw-marks","fas fa-cloud-moon","far fa-cloud-moon","fal fa-cloud-moon","fas fa-coffin","far fa-coffin","fal fa-coffin","fas fa-coffin-cross","far fa-coffin-cross","fal fa-coffin-cross","fas fa-crow","far fa-crow","fal fa-crow","fas fa-flask-round-poison","far fa-flask-round-poison","fal fa-flask-round-poison","fas fa-flask-round-potion","far fa-flask-round-potion","fal fa-flask-round-potion","fas fa-ghost","far fa-ghost","fal fa-ghost","fas fa-hat-witch","far fa-hat-witch","fal fa-hat-witch","fas fa-hat-wizard","far fa-hat-wizard","fal fa-hat-wizard","fas fa-hockey-mask","far fa-hockey-mask","fal fa-hockey-mask","fas fa-jack-o-lantern","far fa-jack-o-lantern","fal fa-jack-o-lantern","fas fa-key-skeleton","far fa-key-skeleton","fal fa-key-skeleton","fas fa-knife-kitchen","far fa-knife-kitchen","fal fa-knife-kitchen","fas fa-lollipop","far fa-lollipop","fal fa-lollipop","fas fa-mask","far fa-mask","fal fa-mask","fas fa-mustache","far fa-mustache","fal fa-mustache","fas fa-scarecrow","far fa-scarecrow","fal fa-scarecrow","fas fa-scythe","far fa-scythe","fal fa-scythe","fas fa-skull","far fa-skull","fal fa-skull","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-sparkles","far fa-sparkles","fal fa-sparkles","fas fa-spider","far fa-spider","fal fa-spider","fas fa-spider-black-widow","far fa-spider-black-widow","fal fa-spider-black-widow","fas fa-spider-web","far fa-spider-web","fal fa-spider-web","fas fa-toilet-paper","far fa-toilet-paper","fal fa-toilet-paper","fas fa-toilet-paper-blank","far fa-toilet-paper-blank","fal fa-toilet-paper-blank","fas fa-tombstone","far fa-tombstone","fal fa-tombstone","fas fa-tombstone-blank","far fa-tombstone-blank","fal fa-tombstone-blank","fas fa-wand","far fa-wand","fal fa-wand","fas fa-wand-sparkles","far fa-wand-sparkles","fal fa-wand-sparkles"]},{"id":"shapes","title":"Shapes","icons":["fas fa-badge","far fa-badge","fal fa-badge","fas fa-ball-pile","far fa-ball-pile","fal fa-ball-pile","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fas fa-burst","far fa-burst","fal fa-burst","fas fa-calendar","far fa-calendar","fal fa-calendar","fas fa-certificate","far fa-certificate","fal fa-certificate","fas fa-circle","far fa-circle","fal fa-circle","fas fa-circle-bolt","far fa-circle-bolt","fal fa-circle-bolt","fas fa-circle-dashed","far fa-circle-dashed","fal fa-circle-dashed","fas fa-circle-half","far fa-circle-half","fal fa-circle-half","fas fa-circle-half-stroke","far fa-circle-half-stroke","fal fa-circle-half-stroke","fas fa-circle-heart","far fa-circle-heart","fal fa-circle-heart","fas fa-circle-quarter","far fa-circle-quarter","fal fa-circle-quarter","fas fa-circle-quarter-stroke","far fa-circle-quarter-stroke","fal fa-circle-quarter-stroke","fas fa-circle-quarters","far fa-circle-quarters","fal fa-circle-quarters","fas fa-circle-small","far fa-circle-small","fal fa-circle-small","fas fa-circle-star","far fa-circle-star","fal fa-circle-star","fas fa-circle-three-quarters","far fa-circle-three-quarters","fal fa-circle-three-quarters","fas fa-circle-three-quarters-stroke","far fa-circle-three-quarters-stroke","fal fa-circle-three-quarters-stroke","fas fa-circles-overlap","far fa-circles-overlap","fal fa-circles-overlap","fas fa-cloud","far fa-cloud","fal fa-cloud","fas fa-clover","far fa-clover","fal fa-clover","fas fa-club","far fa-club","fal fa-club","fas fa-comment","far fa-comment","fal fa-comment","fas fa-crown","far fa-crown","fal fa-crown","fas fa-cubes-stacked","far fa-cubes-stacked","fal fa-cubes-stacked","fas fa-diamond","far fa-diamond","fal fa-diamond","fas fa-diamond-half","far fa-diamond-half","fal fa-diamond-half","fas fa-diamond-half-stroke","far fa-diamond-half-stroke","fal fa-diamond-half-stroke","fas fa-diamonds-4","far fa-diamonds-4","fal fa-diamonds-4","fas fa-file","far fa-file","fal fa-file","fas fa-folder","far fa-folder","fal fa-folder","fas fa-heart","far fa-heart","fal fa-heart","fas fa-heart-crack","far fa-heart-crack","fal fa-heart-crack","fas fa-heart-half","far fa-heart-half","fal fa-heart-half","fas fa-heart-half-stroke","far fa-heart-half-stroke","fal fa-heart-half-stroke","fas fa-hexagon","far fa-hexagon","fal fa-hexagon","fas fa-lines-leaning","far fa-lines-leaning","fal fa-lines-leaning","fas fa-location-pin","far fa-location-pin","fal fa-location-pin","fas fa-octagon","far fa-octagon","fal fa-octagon","fas fa-play","far fa-play","fal fa-play","fas fa-rectangle","far fa-rectangle","fal fa-rectangle","fas fa-rectangle-vertical","far fa-rectangle-vertical","fal fa-rectangle-vertical","fas fa-rectangle-wide","far fa-rectangle-wide","fal fa-rectangle-wide","fas fa-rhombus","far fa-rhombus","fal fa-rhombus","fas fa-seal","far fa-seal","fal fa-seal","fas fa-shapes","far fa-shapes","fal fa-shapes","fas fa-shield","far fa-shield","fal fa-shield","fas fa-spade","far fa-spade","fal fa-spade","fas fa-sparkle","far fa-sparkle","fal fa-sparkle","fas fa-square","far fa-square","fal fa-square","fas fa-square-bolt","far fa-square-bolt","fal fa-square-bolt","fas fa-square-dashed","far fa-square-dashed","fal fa-square-dashed","fas fa-square-dashed-circle-plus","far fa-square-dashed-circle-plus","fal fa-square-dashed-circle-plus","fas fa-square-quarters","far fa-square-quarters","fal fa-square-quarters","fas fa-square-ring","far fa-square-ring","fal fa-square-ring","fas fa-square-small","far fa-square-small","fal fa-square-small","fas fa-square-star","far fa-square-star","fal fa-square-star","fas fa-star","far fa-star","fal fa-star","fas fa-star-sharp","far fa-star-sharp","fal fa-star-sharp","fas fa-star-sharp-half","far fa-star-sharp-half","fal fa-star-sharp-half","fas fa-star-sharp-half-stroke","far fa-star-sharp-half-stroke","fal fa-star-sharp-half-stroke","fas fa-ticket-simple","far fa-ticket-simple","fal fa-ticket-simple","fas fa-triangle","far fa-triangle","fal fa-triangle"]},{"id":"travel-hotel","title":"Travel + Hotel","icons":["fas fa-air-conditioner","far fa-air-conditioner","fal fa-air-conditioner","fas fa-alarm-clock","far fa-alarm-clock","fal fa-alarm-clock","fas fa-alarm-snooze","far fa-alarm-snooze","fal fa-alarm-snooze","fas fa-archway","far fa-archway","fal fa-archway","fas fa-baby-carriage","far fa-baby-carriage","fal fa-baby-carriage","fas fa-ban-smoking","far fa-ban-smoking","fal fa-ban-smoking","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bed","far fa-bed","fal fa-bed","fas fa-bed-bunk","far fa-bed-bunk","fal fa-bed-bunk","fas fa-bed-empty","far fa-bed-empty","fal fa-bed-empty","fas fa-bell-concierge","far fa-bell-concierge","fal fa-bell-concierge","fas fa-book-atlas","far fa-book-atlas","fal fa-book-atlas","fas fa-briefcase","far fa-briefcase","fal fa-briefcase","fas fa-bus","far fa-bus","fal fa-bus","fas fa-bus-simple","far fa-bus-simple","fal fa-bus-simple","fas fa-cable-car","far fa-cable-car","fal fa-cable-car","fas fa-cactus","far fa-cactus","fal fa-cactus","fas fa-car","far fa-car","fal fa-car","fas fa-car-building","far fa-car-building","fal fa-car-building","fas fa-car-bus","far fa-car-bus","fal fa-car-bus","fas fa-car-garage","far fa-car-garage","fal fa-car-garage","fas fa-caravan","far fa-caravan","fal fa-caravan","fas fa-caravan-simple","far fa-caravan-simple","fal fa-caravan-simple","fas fa-cars","far fa-cars","fal fa-cars","fas fa-cart-flatbed-suitcase","far fa-cart-flatbed-suitcase","fal fa-cart-flatbed-suitcase","fas fa-circle-gf","far fa-circle-gf","fal fa-circle-gf","fas fa-dice","far fa-dice","fal fa-dice","fas fa-dice-five","far fa-dice-five","fal fa-dice-five","fas fa-door-closed","far fa-door-closed","fal fa-door-closed","fas fa-door-open","far fa-door-open","fal fa-door-open","fas fa-dryer","far fa-dryer","fal fa-dryer","fas fa-dryer-heat","far fa-dryer-heat","fal fa-dryer-heat","fas fa-dumbbell","far fa-dumbbell","fal fa-dumbbell","fas fa-earth-africa","far fa-earth-africa","fal fa-earth-africa","fas fa-earth-americas","far fa-earth-americas","fal fa-earth-americas","fas fa-earth-asia","far fa-earth-asia","fal fa-earth-asia","fas fa-earth-europe","far fa-earth-europe","fal fa-earth-europe","fas fa-earth-oceania","far fa-earth-oceania","fal fa-earth-oceania","fas fa-elevator","far fa-elevator","fal fa-elevator","fas fa-escalator","far fa-escalator","fal fa-escalator","fas fa-fan-table","far fa-fan-table","fal fa-fan-table","fas fa-fireplace","far fa-fireplace","fal fa-fireplace","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-fork-knife","far fa-fork-knife","fal fa-fork-knife","fas fa-hat-beach","far fa-hat-beach","fal fa-hat-beach","fas fa-heat","far fa-heat","fal fa-heat","fas fa-horse-saddle","far fa-horse-saddle","fal fa-horse-saddle","fas fa-hot-tub-person","far fa-hot-tub-person","fal fa-hot-tub-person","fas fa-hotel","far fa-hotel","fal fa-hotel","fas fa-infinity","far fa-infinity","fal fa-infinity","fas fa-island-tropical","far fa-island-tropical","fal fa-island-tropical","fas fa-key","far fa-key","fal fa-key","fas fa-kitchen-set","far fa-kitchen-set","fal fa-kitchen-set","fas fa-lamp-desk","far fa-lamp-desk","fal fa-lamp-desk","fas fa-map","far fa-map","fal fa-map","fas fa-map-location","far fa-map-location","fal fa-map-location","fas fa-map-location-dot","far fa-map-location-dot","fal fa-map-location-dot","fas fa-martini-glass","far fa-martini-glass","fal fa-martini-glass","fas fa-martini-glass-citrus","far fa-martini-glass-citrus","fal fa-martini-glass-citrus","fas fa-martini-glass-empty","far fa-martini-glass-empty","fal fa-martini-glass-empty","fas fa-microwave","far fa-microwave","fal fa-microwave","fas fa-monument","far fa-monument","fal fa-monument","fas fa-moped","far fa-moped","fal fa-moped","fas fa-mountain-city","far fa-mountain-city","fal fa-mountain-city","fas fa-mug-saucer","far fa-mug-saucer","fal fa-mug-saucer","fas fa-outlet","far fa-outlet","fal fa-outlet","fas fa-oven","far fa-oven","fal fa-oven","fas fa-passport","far fa-passport","fal fa-passport","fas fa-paw-simple","far fa-paw-simple","fal fa-paw-simple","fas fa-person-seat","far fa-person-seat","fal fa-person-seat","fas fa-person-seat-reclined","far fa-person-seat-reclined","fal fa-person-seat-reclined","fas fa-person-swimming","far fa-person-swimming","fal fa-person-swimming","fas fa-person-walking-luggage","far fa-person-walking-luggage","fal fa-person-walking-luggage","fas fa-phone-rotary","far fa-phone-rotary","fal fa-phone-rotary","fas fa-pineapple","far fa-pineapple","fal fa-pineapple","fas fa-plane","far fa-plane","fal fa-plane","fas fa-plane-arrival","far fa-plane-arrival","fal fa-plane-arrival","fas fa-plane-circle-check","far fa-plane-circle-check","fal fa-plane-circle-check","fas fa-plane-circle-exclamation","far fa-plane-circle-exclamation","fal fa-plane-circle-exclamation","fas fa-plane-circle-xmark","far fa-plane-circle-xmark","fal fa-plane-circle-xmark","fas fa-plane-departure","far fa-plane-departure","fal fa-plane-departure","fas fa-plane-lock","far fa-plane-lock","fal fa-plane-lock","fas fa-plane-prop","far fa-plane-prop","fal fa-plane-prop","fas fa-plane-slash","far fa-plane-slash","fal fa-plane-slash","fas fa-plane-tail","far fa-plane-tail","fal fa-plane-tail","fas fa-plane-up","far fa-plane-up","fal fa-plane-up","fas fa-plane-up-slash","far fa-plane-up-slash","fal fa-plane-up-slash","fas fa-plate-utensils","far fa-plate-utensils","fal fa-plate-utensils","fas fa-refrigerator","far fa-refrigerator","fal fa-refrigerator","fas fa-restroom-simple","far fa-restroom-simple","fal fa-restroom-simple","fas fa-ring-diamond","far fa-ring-diamond","fal fa-ring-diamond","fas fa-rings-wedding","far fa-rings-wedding","fal fa-rings-wedding","fas fa-rv","far fa-rv","fal fa-rv","fas fa-seat-airline","far fa-seat-airline","fal fa-seat-airline","fas fa-shower","far fa-shower","fal fa-shower","fas fa-slot-machine","far fa-slot-machine","fal fa-slot-machine","fas fa-smoking","far fa-smoking","fal fa-smoking","fas fa-snooze","far fa-snooze","fal fa-snooze","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-spa","far fa-spa","fal fa-spa","fas fa-stairs","far fa-stairs","fal fa-stairs","fas fa-suitcase","far fa-suitcase","fal fa-suitcase","fas fa-suitcase-rolling","far fa-suitcase-rolling","fal fa-suitcase-rolling","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-taxi-bus","far fa-taxi-bus","fal fa-taxi-bus","fas fa-ticket-airline","far fa-ticket-airline","fal fa-ticket-airline","fas fa-ticket-perforated","far fa-ticket-perforated","fal fa-ticket-perforated","fas fa-tickets-airline","far fa-tickets-airline","fal fa-tickets-airline","fas fa-tickets-perforated","far fa-tickets-perforated","fal fa-tickets-perforated","fas fa-toilet","far fa-toilet","fal fa-toilet","fas fa-toilet-paper","far fa-toilet-paper","fal fa-toilet-paper","fas fa-toilet-paper-blank-under","far fa-toilet-paper-blank-under","fal fa-toilet-paper-blank-under","fas fa-toilet-paper-check","far fa-toilet-paper-check","fal fa-toilet-paper-check","fas fa-toilet-paper-under","far fa-toilet-paper-under","fal fa-toilet-paper-under","fas fa-toilet-paper-under-slash","far fa-toilet-paper-under-slash","fal fa-toilet-paper-under-slash","fas fa-toilet-paper-xmark","far fa-toilet-paper-xmark","fal fa-toilet-paper-xmark","fas fa-tower-control","far fa-tower-control","fal fa-tower-control","fas fa-train-subway-tunnel","far fa-train-subway-tunnel","fal fa-train-subway-tunnel","fas fa-train-tram","far fa-train-tram","fal fa-train-tram","fas fa-tree-city","far fa-tree-city","fal fa-tree-city","fas fa-tree-palm","far fa-tree-palm","fal fa-tree-palm","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-retro","far fa-tv-retro","fal fa-tv-retro","fas fa-umbrella-beach","far fa-umbrella-beach","fal fa-umbrella-beach","fas fa-user-chef","far fa-user-chef","fal fa-user-chef","fas fa-user-pilot","far fa-user-pilot","fal fa-user-pilot","fas fa-user-pilot-tie","far fa-user-pilot-tie","fal fa-user-pilot-tie","fas fa-utensils","far fa-utensils","fal fa-utensils","fas fa-vacuum","far fa-vacuum","fal fa-vacuum","fas fa-van-shuttle","far fa-van-shuttle","fal fa-van-shuttle","fas fa-wagon-covered","far fa-wagon-covered","fal fa-wagon-covered","fas fa-washing-machine","far fa-washing-machine","fal fa-washing-machine","fas fa-water-ladder","far fa-water-ladder","fal fa-water-ladder","fas fa-wheelchair","far fa-wheelchair","fal fa-wheelchair","fas fa-wheelchair-move","far fa-wheelchair-move","fal fa-wheelchair-move","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wifi-slash","far fa-wifi-slash","fal fa-wifi-slash","fas fa-wine-glass","far fa-wine-glass","fal fa-wine-glass","fas fa-wine-glass-empty","far fa-wine-glass-empty","fal fa-wine-glass-empty"]},{"id":"alert","title":"Alert","icons":["fas fa-alarm-clock","far fa-alarm-clock","fal fa-alarm-clock","fas fa-alarm-exclamation","far fa-alarm-exclamation","fal fa-alarm-exclamation","fas fa-battery-exclamation","far fa-battery-exclamation","fal fa-battery-exclamation","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-exclamation","far fa-bell-exclamation","fal fa-bell-exclamation","fas fa-bell-on","far fa-bell-on","fal fa-bell-on","fas fa-bell-ring","far fa-bell-ring","fal fa-bell-ring","fas fa-bell-school-slash","far fa-bell-school-slash","fal fa-bell-school-slash","fas fa-bell-slash","far fa-bell-slash","fal fa-bell-slash","fas fa-bells","far fa-bells","fal fa-bells","fas fa-calendar-exclamation","far fa-calendar-exclamation","fal fa-calendar-exclamation","fas fa-circle-exclamation","far fa-circle-exclamation","fal fa-circle-exclamation","fas fa-circle-exclamation-check","far fa-circle-exclamation-check","fal fa-circle-exclamation-check","fas fa-circle-quarters","far fa-circle-quarters","fal fa-circle-quarters","fas fa-circle-radiation","far fa-circle-radiation","fal fa-circle-radiation","fas fa-circle-wifi","far fa-circle-wifi","fal fa-circle-wifi","fas fa-circle-wifi-circle-wifi","far fa-circle-wifi-circle-wifi","fal fa-circle-wifi-circle-wifi","fas fa-cloud-exclamation","far fa-cloud-exclamation","fal fa-cloud-exclamation","fas fa-cloud-question","far fa-cloud-question","fal fa-cloud-question","fas fa-comment-exclamation","far fa-comment-exclamation","fal fa-comment-exclamation","fas fa-diamond-exclamation","far fa-diamond-exclamation","fal fa-diamond-exclamation","fas fa-engine-warning","far fa-engine-warning","fal fa-engine-warning","fas fa-exclamation","far fa-exclamation","fal fa-exclamation","fas fa-file-exclamation","far fa-file-exclamation","fal fa-file-exclamation","fas fa-hexagon-exclamation","far fa-hexagon-exclamation","fal fa-hexagon-exclamation","fas fa-light-emergency","far fa-light-emergency","fal fa-light-emergency","fas fa-light-emergency-on","far fa-light-emergency-on","fal fa-light-emergency-on","fas fa-lightbulb-exclamation","far fa-lightbulb-exclamation","fal fa-lightbulb-exclamation","fas fa-lightbulb-exclamation-on","far fa-lightbulb-exclamation-on","fal fa-lightbulb-exclamation-on","fas fa-location-exclamation","far fa-location-exclamation","fal fa-location-exclamation","fas fa-message-exclamation","far fa-message-exclamation","fal fa-message-exclamation","fas fa-octagon-exclamation","far fa-octagon-exclamation","fal fa-octagon-exclamation","fas fa-party-bell","far fa-party-bell","fal fa-party-bell","fas fa-party-horn","far fa-party-horn","fal fa-party-horn","fas fa-question","far fa-question","fal fa-question","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-rotate-exclamation","far fa-rotate-exclamation","fal fa-rotate-exclamation","fas fa-seal-exclamation","far fa-seal-exclamation","fal fa-seal-exclamation","fas fa-seal-question","far fa-seal-question","fal fa-seal-question","fas fa-sensor","far fa-sensor","fal fa-sensor","fas fa-sensor-cloud","far fa-sensor-cloud","fal fa-sensor-cloud","fas fa-sensor-fire","far fa-sensor-fire","fal fa-sensor-fire","fas fa-sensor-on","far fa-sensor-on","fal fa-sensor-on","fas fa-sensor-triangle-exclamation","far fa-sensor-triangle-exclamation","fal fa-sensor-triangle-exclamation","fas fa-shield-exclamation","far fa-shield-exclamation","fal fa-shield-exclamation","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-square-exclamation","far fa-square-exclamation","fal fa-square-exclamation","fas fa-star-exclamation","far fa-star-exclamation","fal fa-star-exclamation","fas fa-triangle-exclamation","far fa-triangle-exclamation","fal fa-triangle-exclamation","fas fa-wifi-exclamation","far fa-wifi-exclamation","fal fa-wifi-exclamation","fas fa-wind-warning","far fa-wind-warning","fal fa-wind-warning"]},{"id":"fruits-vegetables","title":"Fruits + Vegetables","icons":["fas fa-apple-core","far fa-apple-core","fal fa-apple-core","fas fa-apple-whole","far fa-apple-whole","fal fa-apple-whole","fas fa-avocado","far fa-avocado","fal fa-avocado","fas fa-banana","far fa-banana","fal fa-banana","fas fa-blueberries","far fa-blueberries","fal fa-blueberries","fas fa-broccoli","far fa-broccoli","fal fa-broccoli","fas fa-carrot","far fa-carrot","fal fa-carrot","fas fa-cherries","far fa-cherries","fal fa-cherries","fas fa-chestnut","far fa-chestnut","fal fa-chestnut","fas fa-citrus","far fa-citrus","fal fa-citrus","fas fa-citrus-slice","far fa-citrus-slice","fal fa-citrus-slice","fas fa-coconut","far fa-coconut","fal fa-coconut","fas fa-crate-apple","far fa-crate-apple","fal fa-crate-apple","fas fa-crate-empty","far fa-crate-empty","fal fa-crate-empty","fas fa-cucumber","far fa-cucumber","fal fa-cucumber","fas fa-eggplant","far fa-eggplant","fal fa-eggplant","fas fa-garlic","far fa-garlic","fal fa-garlic","fas fa-grapes","far fa-grapes","fal fa-grapes","fas fa-kiwi-fruit","far fa-kiwi-fruit","fal fa-kiwi-fruit","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-leafy-green","far fa-leafy-green","fal fa-leafy-green","fas fa-lemon","far fa-lemon","fal fa-lemon","fas fa-mango","far fa-mango","fal fa-mango","fas fa-melon","far fa-melon","fal fa-melon","fas fa-melon-slice","far fa-melon-slice","fal fa-melon-slice","fas fa-mushroom","far fa-mushroom","fal fa-mushroom","fas fa-olive","far fa-olive","fal fa-olive","fas fa-olive-branch","far fa-olive-branch","fal fa-olive-branch","fas fa-onion","far fa-onion","fal fa-onion","fas fa-peach","far fa-peach","fal fa-peach","fas fa-peanut","far fa-peanut","fal fa-peanut","fas fa-peanuts","far fa-peanuts","fal fa-peanuts","fas fa-peapod","far fa-peapod","fal fa-peapod","fas fa-pear","far fa-pear","fal fa-pear","fas fa-pepper","far fa-pepper","fal fa-pepper","fas fa-pepper-hot","far fa-pepper-hot","fal fa-pepper-hot","fas fa-pineapple","far fa-pineapple","fal fa-pineapple","fas fa-potato","far fa-potato","fal fa-potato","fas fa-pumpkin","far fa-pumpkin","fal fa-pumpkin","fas fa-salad","far fa-salad","fal fa-salad","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-strawberry","far fa-strawberry","fal fa-strawberry","fas fa-tomato","far fa-tomato","fal fa-tomato","fas fa-watermelon-slice","far fa-watermelon-slice","fal fa-watermelon-slice","fas fa-wheat","far fa-wheat","fal fa-wheat"]},{"id":"writing","title":"Writing","icons":["fas fa-blog","far fa-blog","fal fa-blog","fas fa-book","far fa-book","fal fa-book","fas fa-book-arrow-right","far fa-book-arrow-right","fal fa-book-arrow-right","fas fa-book-arrow-up","far fa-book-arrow-up","fal fa-book-arrow-up","fas fa-book-bookmark","far fa-book-bookmark","fal fa-book-bookmark","fas fa-book-circle-arrow-right","far fa-book-circle-arrow-right","fal fa-book-circle-arrow-right","fas fa-book-circle-arrow-up","far fa-book-circle-arrow-up","fal fa-book-circle-arrow-up","fas fa-book-copy","far fa-book-copy","fal fa-book-copy","fas fa-book-font","far fa-book-font","fal fa-book-font","fas fa-book-open-cover","far fa-book-open-cover","fal fa-book-open-cover","fas fa-bookmark","far fa-bookmark","fal fa-bookmark","fas fa-bookmark-slash","far fa-bookmark-slash","fal fa-bookmark-slash","fas fa-box-archive","far fa-box-archive","fal fa-box-archive","fas fa-circle-book-open","far fa-circle-book-open","fal fa-circle-book-open","fas fa-circle-bookmark","far fa-circle-bookmark","fal fa-circle-bookmark","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-open","far fa-envelope-open","fal fa-envelope-open","fas fa-eraser","far fa-eraser","fal fa-eraser","fas fa-file","far fa-file","fal fa-file","fas fa-file-lines","far fa-file-lines","fal fa-file-lines","fas fa-folder","far fa-folder","fal fa-folder","fas fa-folder-open","far fa-folder-open","fal fa-folder-open","fas fa-highlighter-line","far fa-highlighter-line","fal fa-highlighter-line","fas fa-input-numeric","far fa-input-numeric","fal fa-input-numeric","fas fa-input-pipe","far fa-input-pipe","fal fa-input-pipe","fas fa-input-text","far fa-input-text","fal fa-input-text","fas fa-keyboard","far fa-keyboard","fal fa-keyboard","fas fa-memo","far fa-memo","fal fa-memo","fas fa-memo-circle-check","far fa-memo-circle-check","fal fa-memo-circle-check","fas fa-memo-circle-info","far fa-memo-circle-info","fal fa-memo-circle-info","fas fa-memo-pad","far fa-memo-pad","fal fa-memo-pad","fas fa-newspaper","far fa-newspaper","fal fa-newspaper","fas fa-notdef","far fa-notdef","fal fa-notdef","fas fa-note","far fa-note","fal fa-note","fas fa-note-sticky","far fa-note-sticky","fal fa-note-sticky","fas fa-notebook","far fa-notebook","fal fa-notebook","fas fa-notes","far fa-notes","fal fa-notes","fas fa-paper-plane","far fa-paper-plane","fal fa-paper-plane","fas fa-paperclip","far fa-paperclip","fal fa-paperclip","fas fa-paperclip-vertical","far fa-paperclip-vertical","fal fa-paperclip-vertical","fas fa-paragraph","far fa-paragraph","fal fa-paragraph","fas fa-pen","far fa-pen","fal fa-pen","fas fa-pen-circle","far fa-pen-circle","fal fa-pen-circle","fas fa-pen-clip","far fa-pen-clip","fal fa-pen-clip","fas fa-pen-clip-slash","far fa-pen-clip-slash","fal fa-pen-clip-slash","fas fa-pen-fancy-slash","far fa-pen-fancy-slash","fal fa-pen-fancy-slash","fas fa-pen-field","far fa-pen-field","fal fa-pen-field","fas fa-pen-line","far fa-pen-line","fal fa-pen-line","fas fa-pen-slash","far fa-pen-slash","fal fa-pen-slash","fas fa-pen-swirl","far fa-pen-swirl","fal fa-pen-swirl","fas fa-pen-to-square","far fa-pen-to-square","fal fa-pen-to-square","fas fa-pencil","far fa-pencil","fal fa-pencil","fas fa-pencil-mechanical","far fa-pencil-mechanical","fal fa-pencil-mechanical","fas fa-pencil-slash","far fa-pencil-slash","fal fa-pencil-slash","fas fa-quote-left","far fa-quote-left","fal fa-quote-left","fas fa-quote-right","far fa-quote-right","fal fa-quote-right","fas fa-quotes","far fa-quotes","fal fa-quotes","fas fa-signature","far fa-signature","fal fa-signature","fas fa-square-pen","far fa-square-pen","fal fa-square-pen","fas fa-square-quote","far fa-square-quote","fal fa-square-quote","fas fa-thumbtack","far fa-thumbtack","fal fa-thumbtack","fas fa-thumbtack-slash","far fa-thumbtack-slash","fal fa-thumbtack-slash","fas fa-typewriter","far fa-typewriter","fal fa-typewriter"]},{"id":"energy","title":"Energy","icons":["fas fa-arrow-up-from-ground-water","far fa-arrow-up-from-ground-water","fal fa-arrow-up-from-ground-water","fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-simple","far fa-atom-simple","fal fa-atom-simple","fas fa-battery-bolt","far fa-battery-bolt","fal fa-battery-bolt","fas fa-battery-empty","far fa-battery-empty","fal fa-battery-empty","fas fa-battery-exclamation","far fa-battery-exclamation","fal fa-battery-exclamation","fas fa-battery-full","far fa-battery-full","fal fa-battery-full","fas fa-battery-half","far fa-battery-half","fal fa-battery-half","fas fa-battery-low","far fa-battery-low","fal fa-battery-low","fas fa-battery-quarter","far fa-battery-quarter","fal fa-battery-quarter","fas fa-battery-slash","far fa-battery-slash","fal fa-battery-slash","fas fa-battery-three-quarters","far fa-battery-three-quarters","fal fa-battery-three-quarters","fas fa-bolt","far fa-bolt","fal fa-bolt","fas fa-burrito","far fa-burrito","fal fa-burrito","fas fa-car-battery","far fa-car-battery","fal fa-car-battery","fas fa-car-bolt","far fa-car-bolt","fal fa-car-bolt","fas fa-car-circle-bolt","far fa-car-circle-bolt","fal fa-car-circle-bolt","fas fa-car-side-bolt","far fa-car-side-bolt","fal fa-car-side-bolt","fas fa-charging-station","far fa-charging-station","fal fa-charging-station","fas fa-circle-radiation","far fa-circle-radiation","fal fa-circle-radiation","fas fa-explosion","far fa-explosion","fal fa-explosion","fas fa-fan","far fa-fan","fal fa-fan","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-flame-curved","far fa-fire-flame-curved","fal fa-fire-flame-curved","fas fa-fire-flame-simple","far fa-fire-flame-simple","fal fa-fire-flame-simple","fas fa-gas-pump","far fa-gas-pump","fal fa-gas-pump","fas fa-gas-pump-slash","far fa-gas-pump-slash","fal fa-gas-pump-slash","fas fa-grate","far fa-grate","fal fa-grate","fas fa-grate-droplet","far fa-grate-droplet","fal fa-grate-droplet","fas fa-heat","far fa-heat","fal fa-heat","fas fa-house-day","far fa-house-day","fal fa-house-day","fas fa-house-night","far fa-house-night","fal fa-house-night","fas fa-industry","far fa-industry","fal fa-industry","fas fa-industry-windows","far fa-industry-windows","fal fa-industry-windows","fas fa-lamp-street","far fa-lamp-street","fal fa-lamp-street","fas fa-leaf","far fa-leaf","fal fa-leaf","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-lightbulb-cfl","far fa-lightbulb-cfl","fal fa-lightbulb-cfl","fas fa-manhole","far fa-manhole","fal fa-manhole","fas fa-meter","far fa-meter","fal fa-meter","fas fa-meter-bolt","far fa-meter-bolt","fal fa-meter-bolt","fas fa-meter-droplet","far fa-meter-droplet","fal fa-meter-droplet","fas fa-meter-fire","far fa-meter-fire","fal fa-meter-fire","fas fa-oil-well","far fa-oil-well","fal fa-oil-well","fas fa-outlet","far fa-outlet","fal fa-outlet","fas fa-pedestal","far fa-pedestal","fal fa-pedestal","fas fa-pipe-circle-check","far fa-pipe-circle-check","fal fa-pipe-circle-check","fas fa-pipe-collar","far fa-pipe-collar","fal fa-pipe-collar","fas fa-pipe-section","far fa-pipe-section","fal fa-pipe-section","fas fa-pipe-valve","far fa-pipe-valve","fal fa-pipe-valve","fas fa-plug","far fa-plug","fal fa-plug","fas fa-plug-circle-bolt","far fa-plug-circle-bolt","fal fa-plug-circle-bolt","fas fa-plug-circle-check","far fa-plug-circle-check","fal fa-plug-circle-check","fas fa-plug-circle-exclamation","far fa-plug-circle-exclamation","fal fa-plug-circle-exclamation","fas fa-plug-circle-minus","far fa-plug-circle-minus","fal fa-plug-circle-minus","fas fa-plug-circle-plus","far fa-plug-circle-plus","fal fa-plug-circle-plus","fas fa-plug-circle-xmark","far fa-plug-circle-xmark","fal fa-plug-circle-xmark","fas fa-poop","far fa-poop","fal fa-poop","fas fa-power-off","far fa-power-off","fal fa-power-off","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-solar-panel","far fa-solar-panel","fal fa-solar-panel","fas fa-sun","far fa-sun","fal fa-sun","fas fa-tower-broadcast","far fa-tower-broadcast","fal fa-tower-broadcast","fas fa-transformer-bolt","far fa-transformer-bolt","fal fa-transformer-bolt","fas fa-truck-bolt","far fa-truck-bolt","fal fa-truck-bolt","fas fa-utility-pole","far fa-utility-pole","fal fa-utility-pole","fas fa-utility-pole-double","far fa-utility-pole-double","fal fa-utility-pole-double","fas fa-vent-damper","far fa-vent-damper","fal fa-vent-damper","fas fa-water","far fa-water","fal fa-water","fas fa-wind","far fa-wind","fal fa-wind","fas fa-wind-turbine","far fa-wind-turbine","fal fa-wind-turbine"]},{"id":"science","title":"Science","icons":["fas fa-atom","far fa-atom","fal fa-atom","fas fa-atom-simple","far fa-atom-simple","fal fa-atom-simple","fas fa-biohazard","far fa-biohazard","fal fa-biohazard","fas fa-book-sparkles","far fa-book-sparkles","fal fa-book-sparkles","fas fa-brain","far fa-brain","fal fa-brain","fas fa-buoy-mooring","far fa-buoy-mooring","fal fa-buoy-mooring","fas fa-capsules","far fa-capsules","fal fa-capsules","fas fa-cauldron","far fa-cauldron","fal fa-cauldron","fas fa-chart-mixed","far fa-chart-mixed","fal fa-chart-mixed","fas fa-chart-network","far fa-chart-network","fal fa-chart-network","fas fa-chart-scatter","far fa-chart-scatter","fal fa-chart-scatter","fas fa-circle-radiation","far fa-circle-radiation","fal fa-circle-radiation","fas fa-clipboard-check","far fa-clipboard-check","fal fa-clipboard-check","fas fa-disease","far fa-disease","fal fa-disease","fas fa-dna","far fa-dna","fal fa-dna","fas fa-eye-dropper","far fa-eye-dropper","fal fa-eye-dropper","fas fa-filter","far fa-filter","fal fa-filter","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-flame-curved","far fa-fire-flame-curved","fal fa-fire-flame-curved","fas fa-fire-flame-simple","far fa-fire-flame-simple","fal fa-fire-flame-simple","fas fa-flask","far fa-flask","fal fa-flask","fas fa-flask-gear","far fa-flask-gear","fal fa-flask-gear","fas fa-flask-round-poison","far fa-flask-round-poison","fal fa-flask-round-poison","fas fa-flask-round-potion","far fa-flask-round-potion","fal fa-flask-round-potion","fas fa-flask-vial","far fa-flask-vial","fal fa-flask-vial","fas fa-frog","far fa-frog","fal fa-frog","fas fa-head-side-brain","far fa-head-side-brain","fal fa-head-side-brain","fas fa-key-skeleton","far fa-key-skeleton","fal fa-key-skeleton","fas fa-kite","far fa-kite","fal fa-kite","fas fa-magnet","far fa-magnet","fal fa-magnet","fas fa-microscope","far fa-microscope","fal fa-microscope","fas fa-mortar-pestle","far fa-mortar-pestle","fal fa-mortar-pestle","fas fa-pills","far fa-pills","fal fa-pills","fas fa-prescription-bottle","far fa-prescription-bottle","fal fa-prescription-bottle","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-square-virus","far fa-square-virus","fal fa-square-virus","fas fa-syringe","far fa-syringe","fal fa-syringe","fas fa-tablets","far fa-tablets","fal fa-tablets","fas fa-tally","far fa-tally","fal fa-tally","fas fa-temperature-high","far fa-temperature-high","fal fa-temperature-high","fas fa-temperature-low","far fa-temperature-low","fal fa-temperature-low","fas fa-vial","far fa-vial","fal fa-vial","fas fa-vial-circle-check","far fa-vial-circle-check","fal fa-vial-circle-check","fas fa-vial-virus","far fa-vial-virus","fal fa-vial-virus","fas fa-vials","far fa-vials","fal fa-vials"]},{"id":"household","title":"Household","icons":["fas fa-air-conditioner","far fa-air-conditioner","fal fa-air-conditioner","fas fa-arrow-up-from-water-pump","far fa-arrow-up-from-water-pump","fal fa-arrow-up-from-water-pump","fas fa-bag-seedling","far fa-bag-seedling","fal fa-bag-seedling","fas fa-bath","far fa-bath","fal fa-bath","fas fa-bed","far fa-bed","fal fa-bed","fas fa-bed-bunk","far fa-bed-bunk","fal fa-bed-bunk","fas fa-bed-empty","far fa-bed-empty","fal fa-bed-empty","fas fa-bed-front","far fa-bed-front","fal fa-bed-front","fas fa-bell","far fa-bell","fal fa-bell","fas fa-bell-on","far fa-bell-on","fal fa-bell-on","fas fa-bell-ring","far fa-bell-ring","fal fa-bell-ring","fas fa-bin-bottles","far fa-bin-bottles","fal fa-bin-bottles","fas fa-bin-bottles-recycle","far fa-bin-bottles-recycle","fal fa-bin-bottles-recycle","fas fa-bin-recycle","far fa-bin-recycle","fal fa-bin-recycle","fas fa-blanket","far fa-blanket","fal fa-blanket","fas fa-blanket-fire","far fa-blanket-fire","fal fa-blanket-fire","fas fa-blender","far fa-blender","fal fa-blender","fas fa-blinds","far fa-blinds","fal fa-blinds","fas fa-blinds-open","far fa-blinds-open","fal fa-blinds-open","fas fa-blinds-raised","far fa-blinds-raised","fal fa-blinds-raised","fas fa-block-brick","far fa-block-brick","fal fa-block-brick","fas fa-block-brick-fire","far fa-block-brick-fire","fal fa-block-brick-fire","fas fa-books","far fa-books","fal fa-books","fas fa-bowl-spoon","far fa-bowl-spoon","fal fa-bowl-spoon","fas fa-box-tissue","far fa-box-tissue","fal fa-box-tissue","fas fa-broom-wide","far fa-broom-wide","fal fa-broom-wide","fas fa-camera-cctv","far fa-camera-cctv","fal fa-camera-cctv","fas fa-camera-security","far fa-camera-security","fal fa-camera-security","fas fa-camera-web","far fa-camera-web","fal fa-camera-web","fas fa-chair","far fa-chair","fal fa-chair","fas fa-chair-office","far fa-chair-office","fal fa-chair-office","fas fa-chopsticks","far fa-chopsticks","fal fa-chopsticks","fas fa-circle-sort","far fa-circle-sort","fal fa-circle-sort","fas fa-circle-sort-down","far fa-circle-sort-down","fal fa-circle-sort-down","fas fa-circle-sort-up","far fa-circle-sort-up","fal fa-circle-sort-up","fas fa-clock-desk","far fa-clock-desk","fal fa-clock-desk","fas fa-clothes-hanger","far fa-clothes-hanger","fal fa-clothes-hanger","fas fa-coffee-pot","far fa-coffee-pot","fal fa-coffee-pot","fas fa-computer","far fa-computer","fal fa-computer","fas fa-couch","far fa-couch","fal fa-couch","fas fa-door-closed","far fa-door-closed","fal fa-door-closed","fas fa-door-open","far fa-door-open","fal fa-door-open","fas fa-dryer","far fa-dryer","fal fa-dryer","fas fa-dryer-heat","far fa-dryer-heat","fal fa-dryer-heat","fas fa-dungeon","far fa-dungeon","fal fa-dungeon","fas fa-fan","far fa-fan","fal fa-fan","fas fa-fan-table","far fa-fan-table","fal fa-fan-table","fas fa-faucet","far fa-faucet","fal fa-faucet","fas fa-faucet-drip","far fa-faucet-drip","fal fa-faucet-drip","fas fa-fire-burner","far fa-fire-burner","fal fa-fire-burner","fas fa-fire-hydrant","far fa-fire-hydrant","fal fa-fire-hydrant","fas fa-fireplace","far fa-fireplace","fal fa-fireplace","fas fa-flashlight","far fa-flashlight","fal fa-flashlight","fas fa-fork","far fa-fork","fal fa-fork","fas fa-fork-knife","far fa-fork-knife","fal fa-fork-knife","fas fa-garage","far fa-garage","fal fa-garage","fas fa-garage-car","far fa-garage-car","fal fa-garage-car","fas fa-garage-open","far fa-garage-open","fal fa-garage-open","fas fa-grill","far fa-grill","fal fa-grill","fas fa-grill-fire","far fa-grill-fire","fal fa-grill-fire","fas fa-grill-hot","far fa-grill-hot","fal fa-grill-hot","fas fa-hammer-brush","far fa-hammer-brush","fal fa-hammer-brush","fas fa-heat","far fa-heat","fal fa-heat","fas fa-hose","far fa-hose","fal fa-hose","fas fa-hose-reel","far fa-hose-reel","fal fa-hose-reel","fas fa-house-chimney-heart","far fa-house-chimney-heart","fal fa-house-chimney-heart","fas fa-house-chimney-user","far fa-house-chimney-user","fal fa-house-chimney-user","fas fa-house-chimney-window","far fa-house-chimney-window","fal fa-house-chimney-window","fas fa-house-day","far fa-house-day","fal fa-house-day","fas fa-house-fire","far fa-house-fire","fal fa-house-fire","fas fa-house-heart","far fa-house-heart","fal fa-house-heart","fas fa-house-laptop","far fa-house-laptop","fal fa-house-laptop","fas fa-house-lock","far fa-house-lock","fal fa-house-lock","fas fa-house-night","far fa-house-night","fal fa-house-night","fas fa-house-person-leave","far fa-house-person-leave","fal fa-house-person-leave","fas fa-house-person-return","far fa-house-person-return","fal fa-house-person-return","fas fa-house-signal","far fa-house-signal","fal fa-house-signal","fas fa-house-user","far fa-house-user","fal fa-house-user","fas fa-jar","far fa-jar","fal fa-jar","fas fa-jar-wheat","far fa-jar-wheat","fal fa-jar-wheat","fas fa-jug-bottle","far fa-jug-bottle","fal fa-jug-bottle","fas fa-jug-detergent","far fa-jug-detergent","fal fa-jug-detergent","fas fa-kitchen-set","far fa-kitchen-set","fal fa-kitchen-set","fas fa-knife","far fa-knife","fal fa-knife","fas fa-knife-kitchen","far fa-knife-kitchen","fal fa-knife-kitchen","fas fa-lamp","far fa-lamp","fal fa-lamp","fas fa-lamp-desk","far fa-lamp-desk","fal fa-lamp-desk","fas fa-lamp-floor","far fa-lamp-floor","fal fa-lamp-floor","fas fa-light-ceiling","far fa-light-ceiling","fal fa-light-ceiling","fas fa-light-switch","far fa-light-switch","fal fa-light-switch","fas fa-light-switch-off","far fa-light-switch-off","fal fa-light-switch-off","fas fa-light-switch-on","far fa-light-switch-on","fal fa-light-switch-on","fas fa-lightbulb","far fa-lightbulb","fal fa-lightbulb","fas fa-lightbulb-cfl","far fa-lightbulb-cfl","fal fa-lightbulb-cfl","fas fa-lightbulb-cfl-on","far fa-lightbulb-cfl-on","fal fa-lightbulb-cfl-on","fas fa-lightbulb-on","far fa-lightbulb-on","fal fa-lightbulb-on","fas fa-loveseat","far fa-loveseat","fal fa-loveseat","fas fa-mailbox","far fa-mailbox","fal fa-mailbox","fas fa-mailbox-flag-up","far fa-mailbox-flag-up","fal fa-mailbox-flag-up","fas fa-mattress-pillow","far fa-mattress-pillow","fal fa-mattress-pillow","fas fa-microwave","far fa-microwave","fal fa-microwave","fas fa-mouse-field","far fa-mouse-field","fal fa-mouse-field","fas fa-mug-saucer","far fa-mug-saucer","fal fa-mug-saucer","fas fa-outlet","far fa-outlet","fal fa-outlet","fas fa-oven","far fa-oven","fal fa-oven","fas fa-pan-frying","far fa-pan-frying","fal fa-pan-frying","fas fa-people-roof","far fa-people-roof","fal fa-people-roof","fas fa-person-to-door","far fa-person-to-door","fal fa-person-to-door","fas fa-phone-intercom","far fa-phone-intercom","fal fa-phone-intercom","fas fa-plate-utensils","far fa-plate-utensils","fal fa-plate-utensils","fas fa-plug","far fa-plug","fal fa-plug","fas fa-pump","far fa-pump","fal fa-pump","fas fa-pump-soap","far fa-pump-soap","fal fa-pump-soap","fas fa-refrigerator","far fa-refrigerator","fal fa-refrigerator","fas fa-rug","far fa-rug","fal fa-rug","fas fa-sensor","far fa-sensor","fal fa-sensor","fas fa-sensor-cloud","far fa-sensor-cloud","fal fa-sensor-cloud","fas fa-sensor-fire","far fa-sensor-fire","fal fa-sensor-fire","fas fa-sensor-on","far fa-sensor-on","fal fa-sensor-on","fas fa-sensor-triangle-exclamation","far fa-sensor-triangle-exclamation","fal fa-sensor-triangle-exclamation","fas fa-sheet-plastic","far fa-sheet-plastic","fal fa-sheet-plastic","fas fa-shower","far fa-shower","fal fa-shower","fas fa-shower-down","far fa-shower-down","fal fa-shower-down","fas fa-shutters","far fa-shutters","fal fa-shutters","fas fa-signal-stream","far fa-signal-stream","fal fa-signal-stream","fas fa-sink","far fa-sink","fal fa-sink","fas fa-siren","far fa-siren","fal fa-siren","fas fa-siren-on","far fa-siren-on","fal fa-siren-on","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-soap","far fa-soap","fal fa-soap","fas fa-speaker","far fa-speaker","fal fa-speaker","fas fa-speakers","far fa-speakers","fal fa-speakers","fas fa-spoon","far fa-spoon","fal fa-spoon","fas fa-sprinkler","far fa-sprinkler","fal fa-sprinkler","fas fa-sprinkler-ceiling","far fa-sprinkler-ceiling","fal fa-sprinkler-ceiling","fas fa-square-ring","far fa-square-ring","fal fa-square-ring","fas fa-stairs","far fa-stairs","fal fa-stairs","fas fa-tank-water","far fa-tank-water","fal fa-tank-water","fas fa-temperature-arrow-down","far fa-temperature-arrow-down","fal fa-temperature-arrow-down","fas fa-temperature-arrow-up","far fa-temperature-arrow-up","fal fa-temperature-arrow-up","fas fa-toilet","far fa-toilet","fal fa-toilet","fas fa-toilet-paper","far fa-toilet-paper","fal fa-toilet-paper","fas fa-toilet-paper-blank","far fa-toilet-paper-blank","fal fa-toilet-paper-blank","fas fa-toilet-paper-blank-under","far fa-toilet-paper-blank-under","fal fa-toilet-paper-blank-under","fas fa-toilet-paper-slash","far fa-toilet-paper-slash","fal fa-toilet-paper-slash","fas fa-toilet-paper-under","far fa-toilet-paper-under","fal fa-toilet-paper-under","fas fa-toilet-paper-under-slash","far fa-toilet-paper-under-slash","fal fa-toilet-paper-under-slash","fas fa-toilet-paper-xmark","far fa-toilet-paper-xmark","fal fa-toilet-paper-xmark","fas fa-tv","far fa-tv","fal fa-tv","fas fa-tv-retro","far fa-tv-retro","fal fa-tv-retro","fas fa-utensils","far fa-utensils","fal fa-utensils","fas fa-utensils-slash","far fa-utensils-slash","fal fa-utensils-slash","fas fa-vacuum","far fa-vacuum","fal fa-vacuum","fas fa-vacuum-robot","far fa-vacuum-robot","fal fa-vacuum-robot","fas fa-vent-damper","far fa-vent-damper","fal fa-vent-damper","fas fa-washing-machine","far fa-washing-machine","fal fa-washing-machine","fas fa-window-frame","far fa-window-frame","fal fa-window-frame","fas fa-window-frame-open","far fa-window-frame-open","fal fa-window-frame-open"]},{"id":"camping","title":"Camping","icons":["fas fa-acorn","far fa-acorn","fal fa-acorn","fas fa-axe","far fa-axe","fal fa-axe","fas fa-backpack","far fa-backpack","fal fa-backpack","fas fa-bench-tree","far fa-bench-tree","fal fa-bench-tree","fas fa-binoculars","far fa-binoculars","fal fa-binoculars","fas fa-boot","far fa-boot","fal fa-boot","fas fa-bottle-water","far fa-bottle-water","fal fa-bottle-water","fas fa-bucket","far fa-bucket","fal fa-bucket","fas fa-cabin","far fa-cabin","fal fa-cabin","fas fa-campfire","far fa-campfire","fal fa-campfire","fas fa-campground","far fa-campground","fal fa-campground","fas fa-caravan","far fa-caravan","fal fa-caravan","fas fa-caravan-simple","far fa-caravan-simple","fal fa-caravan-simple","fas fa-cauldron","far fa-cauldron","fal fa-cauldron","fas fa-compass","far fa-compass","fal fa-compass","fas fa-faucet","far fa-faucet","fal fa-faucet","fas fa-faucet-drip","far fa-faucet-drip","fal fa-faucet-drip","fas fa-fire","far fa-fire","fal fa-fire","fas fa-fire-burner","far fa-fire-burner","fal fa-fire-burner","fas fa-fire-flame-curved","far fa-fire-flame-curved","fal fa-fire-flame-curved","fas fa-fire-smoke","far fa-fire-smoke","fal fa-fire-smoke","fas fa-fishing-rod","far fa-fishing-rod","fal fa-fishing-rod","fas fa-flashlight","far fa-flashlight","fal fa-flashlight","fas fa-frog","far fa-frog","fal fa-frog","fas fa-grill","far fa-grill","fal fa-grill","fas fa-grill-fire","far fa-grill-fire","fal fa-grill-fire","fas fa-grill-hot","far fa-grill-hot","fal fa-grill-hot","fas fa-kit-medical","far fa-kit-medical","fal fa-kit-medical","fas fa-map","far fa-map","fal fa-map","fas fa-map-location","far fa-map-location","fal fa-map-location","fas fa-map-location-dot","far fa-map-location-dot","fal fa-map-location-dot","fas fa-mattress-pillow","far fa-mattress-pillow","fal fa-mattress-pillow","fas fa-mosquito","far fa-mosquito","fal fa-mosquito","fas fa-mosquito-net","far fa-mosquito-net","fal fa-mosquito-net","fas fa-mountain","far fa-mountain","fal fa-mountain","fas fa-mountain-sun","far fa-mountain-sun","fal fa-mountain-sun","fas fa-mountains","far fa-mountains","fal fa-mountains","fas fa-people-roof","far fa-people-roof","fal fa-people-roof","fas fa-person-biking-mountain","far fa-person-biking-mountain","fal fa-person-biking-mountain","fas fa-person-hiking","far fa-person-hiking","fal fa-person-hiking","fas fa-person-shelter","far fa-person-shelter","fal fa-person-shelter","fas fa-pickaxe","far fa-pickaxe","fal fa-pickaxe","fas fa-route","far fa-route","fal fa-route","fas fa-rv","far fa-rv","fal fa-rv","fas fa-shish-kebab","far fa-shish-kebab","fal fa-shish-kebab","fas fa-shovel","far fa-shovel","fal fa-shovel","fas fa-sign-post","far fa-sign-post","fal fa-sign-post","fas fa-signs-post","far fa-signs-post","fal fa-signs-post","fas fa-squirrel","far fa-squirrel","fal fa-squirrel","fas fa-sunrise","far fa-sunrise","fal fa-sunrise","fas fa-sunset","far fa-sunset","fal fa-sunset","fas fa-table-picnic","far fa-table-picnic","fal fa-table-picnic","fas fa-tarp","far fa-tarp","fal fa-tarp","fas fa-tarp-droplet","far fa-tarp-droplet","fal fa-tarp-droplet","fas fa-teddy-bear","far fa-teddy-bear","fal fa-teddy-bear","fas fa-tent","far fa-tent","fal fa-tent","fas fa-tent-arrow-down-to-line","far fa-tent-arrow-down-to-line","fal fa-tent-arrow-down-to-line","fas fa-tent-arrow-left-right","far fa-tent-arrow-left-right","fal fa-tent-arrow-left-right","fas fa-tent-arrow-turn-left","far fa-tent-arrow-turn-left","fal fa-tent-arrow-turn-left","fas fa-tent-arrows-down","far fa-tent-arrows-down","fal fa-tent-arrows-down","fas fa-tent-double-peak","far fa-tent-double-peak","fal fa-tent-double-peak","fas fa-tents","far fa-tents","fal fa-tents","fas fa-toilet-paper","far fa-toilet-paper","fal fa-toilet-paper","fas fa-toilet-paper-blank","far fa-toilet-paper-blank","fal fa-toilet-paper-blank","fas fa-trailer","far fa-trailer","fal fa-trailer","fas fa-tree","far fa-tree","fal fa-tree","fas fa-tree-deciduous","far fa-tree-deciduous","fal fa-tree-deciduous","fas fa-tree-large","far fa-tree-large","fal fa-tree-large","fas fa-trees","far fa-trees","fal fa-trees"]},{"id":"automotive","title":"Automotive","icons":["fas fa-brake-warning","far fa-brake-warning","fal fa-brake-warning","fas fa-bus","far fa-bus","fal fa-bus","fas fa-bus-simple","far fa-bus-simple","fal fa-bus-simple","fas fa-car","far fa-car","fal fa-car","fas fa-car-battery","far fa-car-battery","fal fa-car-battery","fas fa-car-bolt","far fa-car-bolt","fal fa-car-bolt","fas fa-car-building","far fa-car-building","fal fa-car-building","fas fa-car-bump","far fa-car-bump","fal fa-car-bump","fas fa-car-burst","far fa-car-burst","fal fa-car-burst","fas fa-car-bus","far fa-car-bus","fal fa-car-bus","fas fa-car-circle-bolt","far fa-car-circle-bolt","fal fa-car-circle-bolt","fas fa-car-garage","far fa-car-garage","fal fa-car-garage","fas fa-car-mirrors","far fa-car-mirrors","fal fa-car-mirrors","fas fa-car-on","far fa-car-on","fal fa-car-on","fas fa-car-rear","far fa-car-rear","fal fa-car-rear","fas fa-car-side","far fa-car-side","fal fa-car-side","fas fa-car-side-bolt","far fa-car-side-bolt","fal fa-car-side-bolt","fas fa-car-tilt","far fa-car-tilt","fal fa-car-tilt","fas fa-car-tunnel","far fa-car-tunnel","fal fa-car-tunnel","fas fa-car-wash","far fa-car-wash","fal fa-car-wash","fas fa-car-wrench","far fa-car-wrench","fal fa-car-wrench","fas fa-caravan","far fa-caravan","fal fa-caravan","fas fa-caravan-simple","far fa-caravan-simple","fal fa-caravan-simple","fas fa-cars","far fa-cars","fal fa-cars","fas fa-charging-station","far fa-charging-station","fal fa-charging-station","fas fa-engine","far fa-engine","fal fa-engine","fas fa-engine-warning","far fa-engine-warning","fal fa-engine-warning","fas fa-flux-capacitor","far fa-flux-capacitor","fal fa-flux-capacitor","fas fa-garage","far fa-garage","fal fa-garage","fas fa-garage-car","far fa-garage-car","fal fa-garage-car","fas fa-garage-open","far fa-garage-open","fal fa-garage-open","fas fa-gas-pump","far fa-gas-pump","fal fa-gas-pump","fas fa-gas-pump-slash","far fa-gas-pump-slash","fal fa-gas-pump-slash","fas fa-gauge","far fa-gauge","fal fa-gauge","fas fa-gauge-circle-bolt","far fa-gauge-circle-bolt","fal fa-gauge-circle-bolt","fas fa-gauge-circle-minus","far fa-gauge-circle-minus","fal fa-gauge-circle-minus","fas fa-gauge-circle-plus","far fa-gauge-circle-plus","fal fa-gauge-circle-plus","fas fa-gauge-high","far fa-gauge-high","fal fa-gauge-high","fas fa-gauge-low","far fa-gauge-low","fal fa-gauge-low","fas fa-gauge-max","far fa-gauge-max","fal fa-gauge-max","fas fa-gauge-min","far fa-gauge-min","fal fa-gauge-min","fas fa-gauge-simple","far fa-gauge-simple","fal fa-gauge-simple","fas fa-gauge-simple-high","far fa-gauge-simple-high","fal fa-gauge-simple-high","fas fa-gauge-simple-low","far fa-gauge-simple-low","fal fa-gauge-simple-low","fas fa-gauge-simple-max","far fa-gauge-simple-max","fal fa-gauge-simple-max","fas fa-gauge-simple-min","far fa-gauge-simple-min","fal fa-gauge-simple-min","fas fa-moped","far fa-moped","fal fa-moped","fas fa-motorcycle","far fa-motorcycle","fal fa-motorcycle","fas fa-oil-can","far fa-oil-can","fal fa-oil-can","fas fa-oil-can-drip","far fa-oil-can-drip","fal fa-oil-can-drip","fas fa-oil-temperature","far fa-oil-temperature","fal fa-oil-temperature","fas fa-pump","far fa-pump","fal fa-pump","fas fa-rv","far fa-rv","fal fa-rv","fas fa-spray-can-sparkles","far fa-spray-can-sparkles","fal fa-spray-can-sparkles","fas fa-steering-wheel","far fa-steering-wheel","fal fa-steering-wheel","fas fa-tank-water","far fa-tank-water","fal fa-tank-water","fas fa-taxi","far fa-taxi","fal fa-taxi","fas fa-tire","far fa-tire","fal fa-tire","fas fa-tire-flat","far fa-tire-flat","fal fa-tire-flat","fas fa-tire-pressure-warning","far fa-tire-pressure-warning","fal fa-tire-pressure-warning","fas fa-tire-rugged","far fa-tire-rugged","fal fa-tire-rugged","fas fa-trailer","far fa-trailer","fal fa-trailer","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-bolt","far fa-truck-bolt","fal fa-truck-bolt","fas fa-truck-field","far fa-truck-field","fal fa-truck-field","fas fa-truck-field-un","far fa-truck-field-un","fal fa-truck-field-un","fas fa-truck-medical","far fa-truck-medical","fal fa-truck-medical","fas fa-truck-monster","far fa-truck-monster","fal fa-truck-monster","fas fa-truck-pickup","far fa-truck-pickup","fal fa-truck-pickup","fas fa-van-shuttle","far fa-van-shuttle","fal fa-van-shuttle","fas fa-wagon-covered","far fa-wagon-covered","fal fa-wagon-covered"]},{"id":"animals","title":"Animals","icons":["fas fa-alicorn","far fa-alicorn","fal fa-alicorn","fas fa-ant","far fa-ant","fal fa-ant","fas fa-badger-honey","far fa-badger-honey","fal fa-badger-honey","fas fa-bat","far fa-bat","fal fa-bat","fas fa-bee","far fa-bee","fal fa-bee","fas fa-bird","far fa-bird","fal fa-bird","fas fa-bugs","far fa-bugs","fal fa-bugs","fas fa-cat","far fa-cat","fal fa-cat","fas fa-cat-space","far fa-cat-space","fal fa-cat-space","fas fa-cow","far fa-cow","fal fa-cow","fas fa-crab","far fa-crab","fal fa-crab","fas fa-crow","far fa-crow","fal fa-crow","fas fa-deer","far fa-deer","fal fa-deer","fas fa-deer-rudolph","far fa-deer-rudolph","fal fa-deer-rudolph","fas fa-dinosaur","far fa-dinosaur","fal fa-dinosaur","fas fa-dog","far fa-dog","fal fa-dog","fas fa-dog-leashed","far fa-dog-leashed","fal fa-dog-leashed","fas fa-dolphin","far fa-dolphin","fal fa-dolphin","fas fa-dove","far fa-dove","fal fa-dove","fas fa-dragon","far fa-dragon","fal fa-dragon","fas fa-duck","far fa-duck","fal fa-duck","fas fa-elephant","far fa-elephant","fal fa-elephant","fas fa-feather","far fa-feather","fal fa-feather","fas fa-feather-pointed","far fa-feather-pointed","fal fa-feather-pointed","fas fa-fish","far fa-fish","fal fa-fish","fas fa-fish-bones","far fa-fish-bones","fal fa-fish-bones","fas fa-fish-fins","far fa-fish-fins","fal fa-fish-fins","fas fa-frog","far fa-frog","fal fa-frog","fas fa-hippo","far fa-hippo","fal fa-hippo","fas fa-horse","far fa-horse","fal fa-horse","fas fa-horse-head","far fa-horse-head","fal fa-horse-head","fas fa-horse-saddle","far fa-horse-saddle","fal fa-horse-saddle","fas fa-hydra","far fa-hydra","fal fa-hydra","fas fa-kiwi-bird","far fa-kiwi-bird","fal fa-kiwi-bird","fas fa-lobster","far fa-lobster","fal fa-lobster","fas fa-locust","far fa-locust","fal fa-locust","fas fa-monkey","far fa-monkey","fal fa-monkey","fas fa-mosquito","far fa-mosquito","fal fa-mosquito","fas fa-mouse-field","far fa-mouse-field","fal fa-mouse-field","fas fa-narwhal","far fa-narwhal","fal fa-narwhal","fas fa-octopus","far fa-octopus","fal fa-octopus","fas fa-otter","far fa-otter","fal fa-otter","fas fa-paw","far fa-paw","fal fa-paw","fas fa-paw-claws","far fa-paw-claws","fal fa-paw-claws","fas fa-paw-simple","far fa-paw-simple","fal fa-paw-simple","fas fa-pegasus","far fa-pegasus","fal fa-pegasus","fas fa-pig","far fa-pig","fal fa-pig","fas fa-rabbit","far fa-rabbit","fal fa-rabbit","fas fa-rabbit-running","far fa-rabbit-running","fal fa-rabbit-running","fas fa-raccoon","far fa-raccoon","fal fa-raccoon","fas fa-ram","far fa-ram","fal fa-ram","fas fa-sheep","far fa-sheep","fal fa-sheep","fas fa-shield-cat","far fa-shield-cat","fal fa-shield-cat","fas fa-shield-dog","far fa-shield-dog","fal fa-shield-dog","fas fa-shrimp","far fa-shrimp","fal fa-shrimp","fas fa-skull-cow","far fa-skull-cow","fal fa-skull-cow","fas fa-snake","far fa-snake","fal fa-snake","fas fa-spider","far fa-spider","fal fa-spider","fas fa-spider-black-widow","far fa-spider-black-widow","fal fa-spider-black-widow","fas fa-squid","far fa-squid","fal fa-squid","fas fa-squirrel","far fa-squirrel","fal fa-squirrel","fas fa-t-rex","far fa-t-rex","fal fa-t-rex","fas fa-teddy-bear","far fa-teddy-bear","fal fa-teddy-bear","fas fa-turtle","far fa-turtle","fal fa-turtle","fas fa-unicorn","far fa-unicorn","fal fa-unicorn","fas fa-whale","far fa-whale","fal fa-whale","fas fa-worm","far fa-worm","fal fa-worm"]},{"id":"disaster","title":"Disaster + Crisis","icons":["fas fa-biohazard","far fa-biohazard","fal fa-biohazard","fas fa-bugs","far fa-bugs","fal fa-bugs","fas fa-burst","far fa-burst","fal fa-burst","fas fa-child-combatant","far fa-child-combatant","fal fa-child-combatant","fas fa-circle-radiation","far fa-circle-radiation","fal fa-circle-radiation","fas fa-cloud-bolt","far fa-cloud-bolt","fal fa-cloud-bolt","fas fa-cloud-showers-heavy","far fa-cloud-showers-heavy","fal fa-cloud-showers-heavy","fas fa-cloud-showers-water","far fa-cloud-showers-water","fal fa-cloud-showers-water","fas fa-heat","far fa-heat","fal fa-heat","fas fa-helmet-un","far fa-helmet-un","fal fa-helmet-un","fas fa-hill-avalanche","far fa-hill-avalanche","fal fa-hill-avalanche","fas fa-hill-rockslide","far fa-hill-rockslide","fal fa-hill-rockslide","fas fa-house-chimney-crack","far fa-house-chimney-crack","fal fa-house-chimney-crack","fas fa-house-crack","far fa-house-crack","fal fa-house-crack","fas fa-house-fire","far fa-house-fire","fal fa-house-fire","fas fa-house-flood-water","far fa-house-flood-water","fal fa-house-flood-water","fas fa-house-flood-water-circle-arrow-right","far fa-house-flood-water-circle-arrow-right","fal fa-house-flood-water-circle-arrow-right","fas fa-house-tsunami","far fa-house-tsunami","fal fa-house-tsunami","fas fa-house-water","far fa-house-water","fal fa-house-water","fas fa-hurricane","far fa-hurricane","fal fa-hurricane","fas fa-locust","far fa-locust","fal fa-locust","fas fa-mosquito","far fa-mosquito","fal fa-mosquito","fas fa-person-drowning","far fa-person-drowning","fal fa-person-drowning","fas fa-person-rifle","far fa-person-rifle","fal fa-person-rifle","fas fa-person-walking-arrow-loop-left","far fa-person-walking-arrow-loop-left","fal fa-person-walking-arrow-loop-left","fas fa-person-walking-arrow-right","far fa-person-walking-arrow-right","fal fa-person-walking-arrow-right","fas fa-person-walking-dashed-line-arrow-right","far fa-person-walking-dashed-line-arrow-right","fal fa-person-walking-dashed-line-arrow-right","fas fa-plant-wilt","far fa-plant-wilt","fal fa-plant-wilt","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-sun-plant-wilt","far fa-sun-plant-wilt","fal fa-sun-plant-wilt","fas fa-temperature-arrow-down","far fa-temperature-arrow-down","fal fa-temperature-arrow-down","fas fa-temperature-arrow-up","far fa-temperature-arrow-up","fal fa-temperature-arrow-up","fas fa-tornado","far fa-tornado","fal fa-tornado","fas fa-volcano","far fa-volcano","fal fa-volcano","fas fa-wheat-awn-circle-exclamation","far fa-wheat-awn-circle-exclamation","fal fa-wheat-awn-circle-exclamation","fas fa-wind","far fa-wind","fal fa-wind","fas fa-wind-warning","far fa-wind-warning","fal fa-wind-warning","fas fa-worm","far fa-worm","fal fa-worm","fas fa-xmarks-lines","far fa-xmarks-lines","fal fa-xmarks-lines"]},{"id":"humanitarian","title":"Humanitarian","icons":["fas fa-anchor","far fa-anchor","fal fa-anchor","fas fa-anchor-circle-check","far fa-anchor-circle-check","fal fa-anchor-circle-check","fas fa-anchor-circle-exclamation","far fa-anchor-circle-exclamation","fal fa-anchor-circle-exclamation","fas fa-anchor-circle-xmark","far fa-anchor-circle-xmark","fal fa-anchor-circle-xmark","fas fa-anchor-lock","far fa-anchor-lock","fal fa-anchor-lock","fas fa-arrow-down-up-across-line","far fa-arrow-down-up-across-line","fal fa-arrow-down-up-across-line","fas fa-arrow-down-up-lock","far fa-arrow-down-up-lock","fal fa-arrow-down-up-lock","fas fa-arrow-right-to-city","far fa-arrow-right-to-city","fal fa-arrow-right-to-city","fas fa-arrow-up-from-ground-water","far fa-arrow-up-from-ground-water","fal fa-arrow-up-from-ground-water","fas fa-arrow-up-from-water-pump","far fa-arrow-up-from-water-pump","fal fa-arrow-up-from-water-pump","fas fa-arrow-up-right-dots","far fa-arrow-up-right-dots","fal fa-arrow-up-right-dots","fas fa-arrow-up-right-from-square","far fa-arrow-up-right-from-square","fal fa-arrow-up-right-from-square","fas fa-arrows-down-to-line","far fa-arrows-down-to-line","fal fa-arrows-down-to-line","fas fa-arrows-down-to-people","far fa-arrows-down-to-people","fal fa-arrows-down-to-people","fas fa-arrows-left-right-to-line","far fa-arrows-left-right-to-line","fal fa-arrows-left-right-to-line","fas fa-arrows-spin","far fa-arrows-spin","fal fa-arrows-spin","fas fa-arrows-split-up-and-left","far fa-arrows-split-up-and-left","fal fa-arrows-split-up-and-left","fas fa-arrows-to-circle","far fa-arrows-to-circle","fal fa-arrows-to-circle","fas fa-arrows-to-dot","far fa-arrows-to-dot","fal fa-arrows-to-dot","fas fa-arrows-to-eye","far fa-arrows-to-eye","fal fa-arrows-to-eye","fas fa-arrows-turn-right","far fa-arrows-turn-right","fal fa-arrows-turn-right","fas fa-arrows-turn-to-dots","far fa-arrows-turn-to-dots","fal fa-arrows-turn-to-dots","fas fa-arrows-up-to-line","far fa-arrows-up-to-line","fal fa-arrows-up-to-line","fas fa-baby","far fa-baby","fal fa-baby","fas fa-bacterium","far fa-bacterium","fal fa-bacterium","fas fa-ban","far fa-ban","fal fa-ban","fas fa-bed","far fa-bed","fal fa-bed","fas fa-biohazard","far fa-biohazard","fal fa-biohazard","fas fa-book-bookmark","far fa-book-bookmark","fal fa-book-bookmark","fas fa-bore-hole","far fa-bore-hole","fal fa-bore-hole","fas fa-bottle-droplet","far fa-bottle-droplet","fal fa-bottle-droplet","fas fa-bottle-water","far fa-bottle-water","fal fa-bottle-water","fas fa-bowl-food","far fa-bowl-food","fal fa-bowl-food","fas fa-bowl-rice","far fa-bowl-rice","fal fa-bowl-rice","fas fa-boxes-packing","far fa-boxes-packing","fal fa-boxes-packing","fas fa-bridge","far fa-bridge","fal fa-bridge","fas fa-bridge-circle-check","far fa-bridge-circle-check","fal fa-bridge-circle-check","fas fa-bridge-circle-exclamation","far fa-bridge-circle-exclamation","fal fa-bridge-circle-exclamation","fas fa-bridge-circle-xmark","far fa-bridge-circle-xmark","fal fa-bridge-circle-xmark","fas fa-bridge-lock","far fa-bridge-lock","fal fa-bridge-lock","fas fa-bridge-water","far fa-bridge-water","fal fa-bridge-water","fas fa-bucket","far fa-bucket","fal fa-bucket","fas fa-bugs","far fa-bugs","fal fa-bugs","fas fa-building","far fa-building","fal fa-building","fas fa-building-circle-arrow-right","far fa-building-circle-arrow-right","fal fa-building-circle-arrow-right","fas fa-building-circle-check","far fa-building-circle-check","fal fa-building-circle-check","fas fa-building-circle-exclamation","far fa-building-circle-exclamation","fal fa-building-circle-exclamation","fas fa-building-circle-xmark","far fa-building-circle-xmark","fal fa-building-circle-xmark","fas fa-building-columns","far fa-building-columns","fal fa-building-columns","fas fa-building-flag","far fa-building-flag","fal fa-building-flag","fas fa-building-lock","far fa-building-lock","fal fa-building-lock","fas fa-building-ngo","far fa-building-ngo","fal fa-building-ngo","fas fa-building-shield","far fa-building-shield","fal fa-building-shield","fas fa-building-un","far fa-building-un","fal fa-building-un","fas fa-building-user","far fa-building-user","fal fa-building-user","fas fa-building-wheat","far fa-building-wheat","fal fa-building-wheat","fas fa-burst","far fa-burst","fal fa-burst","fas fa-bus","far fa-bus","fal fa-bus","fas fa-car","far fa-car","fal fa-car","fas fa-car-on","far fa-car-on","fal fa-car-on","fas fa-car-tunnel","far fa-car-tunnel","fal fa-car-tunnel","fas fa-child-combatant","far fa-child-combatant","fal fa-child-combatant","fas fa-children","far fa-children","fal fa-children","fas fa-church","far fa-church","fal fa-church","fas fa-circle-h","far fa-circle-h","fal fa-circle-h","fas fa-circle-nodes","far fa-circle-nodes","fal fa-circle-nodes","fas fa-clipboard-question","far fa-clipboard-question","fal fa-clipboard-question","fas fa-clipboard-user","far fa-clipboard-user","fal fa-clipboard-user","fas fa-cloud-bolt","far fa-cloud-bolt","fal fa-cloud-bolt","fas fa-cloud-showers-heavy","far fa-cloud-showers-heavy","fal fa-cloud-showers-heavy","fas fa-cloud-showers-water","far fa-cloud-showers-water","fal fa-cloud-showers-water","fas fa-computer","far fa-computer","fal fa-computer","fas fa-cow","far fa-cow","fal fa-cow","fas fa-cubes-stacked","far fa-cubes-stacked","fal fa-cubes-stacked","fas fa-display","far fa-display","fal fa-display","fas fa-droplet","far fa-droplet","fal fa-droplet","fas fa-envelope","far fa-envelope","fal fa-envelope","fas fa-envelope-circle-check","far fa-envelope-circle-check","fal fa-envelope-circle-check","fas fa-explosion","far fa-explosion","fal fa-explosion","fas fa-faucet-drip","far fa-faucet-drip","fal fa-faucet-drip","fas fa-fax","far fa-fax","fal fa-fax","fas fa-ferry","far fa-ferry","fal fa-ferry","fas fa-file","far fa-file","fal fa-file","fas fa-file-circle-check","far fa-file-circle-check","fal fa-file-circle-check","fas fa-file-circle-exclamation","far fa-file-circle-exclamation","fal fa-file-circle-exclamation","fas fa-file-circle-minus","far fa-file-circle-minus","fal fa-file-circle-minus","fas fa-file-circle-plus","far fa-file-circle-plus","fal fa-file-circle-plus","fas fa-file-circle-question","far fa-file-circle-question","fal fa-file-circle-question","fas fa-file-circle-xmark","far fa-file-circle-xmark","fal fa-file-circle-xmark","fas fa-file-csv","far fa-file-csv","fal fa-file-csv","fas fa-file-pdf","far fa-file-pdf","fal fa-file-pdf","fas fa-file-pen","far fa-file-pen","fal fa-file-pen","fas fa-file-shield","far fa-file-shield","fal fa-file-shield","fas fa-fire-burner","far fa-fire-burner","fal fa-fire-burner","fas fa-fire-flame-simple","far fa-fire-flame-simple","fal fa-fire-flame-simple","fas fa-fish-fins","far fa-fish-fins","fal fa-fish-fins","fas fa-flag","far fa-flag","fal fa-flag","fas fa-flask-vial","far fa-flask-vial","fal fa-flask-vial","fas fa-gas-pump","far fa-gas-pump","fal fa-gas-pump","fas fa-glass-water","far fa-glass-water","fal fa-glass-water","fas fa-glass-water-droplet","far fa-glass-water-droplet","fal fa-glass-water-droplet","fas fa-gopuram","far fa-gopuram","fal fa-gopuram","fas fa-group-arrows-rotate","far fa-group-arrows-rotate","fal fa-group-arrows-rotate","fas fa-hammer","far fa-hammer","fal fa-hammer","fas fa-hand-holding-hand","far fa-hand-holding-hand","fal fa-hand-holding-hand","fas fa-handcuffs","far fa-handcuffs","fal fa-handcuffs","fas fa-hands-bound","far fa-hands-bound","fal fa-hands-bound","fas fa-hands-bubbles","far fa-hands-bubbles","fal fa-hands-bubbles","fas fa-hands-holding-child","far fa-hands-holding-child","fal fa-hands-holding-child","fas fa-hands-holding-circle","far fa-hands-holding-circle","fal fa-hands-holding-circle","fas fa-handshake-simple","far fa-handshake-simple","fal fa-handshake-simple","fas fa-headset","far fa-headset","fal fa-headset","fas fa-heart-circle-bolt","far fa-heart-circle-bolt","fal fa-heart-circle-bolt","fas fa-heart-circle-check","far fa-heart-circle-check","fal fa-heart-circle-check","fas fa-heart-circle-exclamation","far fa-heart-circle-exclamation","fal fa-heart-circle-exclamation","fas fa-heart-circle-minus","far fa-heart-circle-minus","fal fa-heart-circle-minus","fas fa-heart-circle-plus","far fa-heart-circle-plus","fal fa-heart-circle-plus","fas fa-heart-circle-xmark","far fa-heart-circle-xmark","fal fa-heart-circle-xmark","fas fa-helicopter","far fa-helicopter","fal fa-helicopter","fas fa-helicopter-symbol","far fa-helicopter-symbol","fal fa-helicopter-symbol","fas fa-helmet-un","far fa-helmet-un","fal fa-helmet-un","fas fa-hill-avalanche","far fa-hill-avalanche","fal fa-hill-avalanche","fas fa-hill-rockslide","far fa-hill-rockslide","fal fa-hill-rockslide","fas fa-hospital","far fa-hospital","fal fa-hospital","fas fa-hotel","far fa-hotel","fal fa-hotel","fas fa-house-chimney","far fa-house-chimney","fal fa-house-chimney","fas fa-house-chimney-crack","far fa-house-chimney-crack","fal fa-house-chimney-crack","fas fa-house-circle-check","far fa-house-circle-check","fal fa-house-circle-check","fas fa-house-circle-exclamation","far fa-house-circle-exclamation","fal fa-house-circle-exclamation","fas fa-house-circle-xmark","far fa-house-circle-xmark","fal fa-house-circle-xmark","fas fa-house-fire","far fa-house-fire","fal fa-house-fire","fas fa-house-flag","far fa-house-flag","fal fa-house-flag","fas fa-house-flood-water","far fa-house-flood-water","fal fa-house-flood-water","fas fa-house-flood-water-circle-arrow-right","far fa-house-flood-water-circle-arrow-right","fal fa-house-flood-water-circle-arrow-right","fas fa-house-lock","far fa-house-lock","fal fa-house-lock","fas fa-house-medical","far fa-house-medical","fal fa-house-medical","fas fa-house-medical-circle-check","far fa-house-medical-circle-check","fal fa-house-medical-circle-check","fas fa-house-medical-circle-exclamation","far fa-house-medical-circle-exclamation","fal fa-house-medical-circle-exclamation","fas fa-house-medical-circle-xmark","far fa-house-medical-circle-xmark","fal fa-house-medical-circle-xmark","fas fa-house-medical-flag","far fa-house-medical-flag","fal fa-house-medical-flag","fas fa-house-signal","far fa-house-signal","fal fa-house-signal","fas fa-house-tsunami","far fa-house-tsunami","fal fa-house-tsunami","fas fa-hurricane","far fa-hurricane","fal fa-hurricane","fas fa-id-card","far fa-id-card","fal fa-id-card","fas fa-jar","far fa-jar","fal fa-jar","fas fa-jar-wheat","far fa-jar-wheat","fal fa-jar-wheat","fas fa-jet-fighter-up","far fa-jet-fighter-up","fal fa-jet-fighter-up","fas fa-jug-detergent","far fa-jug-detergent","fal fa-jug-detergent","fas fa-kitchen-set","far fa-kitchen-set","fal fa-kitchen-set","fas fa-land-mine-on","far fa-land-mine-on","fal fa-land-mine-on","fas fa-landmark","far fa-landmark","fal fa-landmark","fas fa-landmark-dome","far fa-landmark-dome","fal fa-landmark-dome","fas fa-landmark-flag","far fa-landmark-flag","fal fa-landmark-flag","fas fa-laptop","far fa-laptop","fal fa-laptop","fas fa-laptop-file","far fa-laptop-file","fal fa-laptop-file","fas fa-life-ring","far fa-life-ring","fal fa-life-ring","fas fa-lines-leaning","far fa-lines-leaning","fal fa-lines-leaning","fas fa-location-pin-lock","far fa-location-pin-lock","fal fa-location-pin-lock","fas fa-locust","far fa-locust","fal fa-locust","fas fa-lungs","far fa-lungs","fal fa-lungs","fas fa-magnifying-glass-arrow-right","far fa-magnifying-glass-arrow-right","fal fa-magnifying-glass-arrow-right","fas fa-magnifying-glass-chart","far fa-magnifying-glass-chart","fal fa-magnifying-glass-chart","fas fa-mars-and-venus","far fa-mars-and-venus","fal fa-mars-and-venus","fas fa-mars-and-venus-burst","far fa-mars-and-venus-burst","fal fa-mars-and-venus-burst","fas fa-mask-face","far fa-mask-face","fal fa-mask-face","fas fa-mask-ventilator","far fa-mask-ventilator","fal fa-mask-ventilator","fas fa-mattress-pillow","far fa-mattress-pillow","fal fa-mattress-pillow","fas fa-microscope","far fa-microscope","fal fa-microscope","fas fa-mobile-retro","far fa-mobile-retro","fal fa-mobile-retro","fas fa-mobile-screen","far fa-mobile-screen","fal fa-mobile-screen","fas fa-money-bill-transfer","far fa-money-bill-transfer","fal fa-money-bill-transfer","fas fa-money-bill-trend-up","far fa-money-bill-trend-up","fal fa-money-bill-trend-up","fas fa-money-bill-wheat","far fa-money-bill-wheat","fal fa-money-bill-wheat","fas fa-money-bills","far fa-money-bills","fal fa-money-bills","fas fa-mosque","far fa-mosque","fal fa-mosque","fas fa-mosquito","far fa-mosquito","fal fa-mosquito","fas fa-mosquito-net","far fa-mosquito-net","fal fa-mosquito-net","fas fa-mound","far fa-mound","fal fa-mound","fas fa-mountain-city","far fa-mountain-city","fal fa-mountain-city","fas fa-mountain-sun","far fa-mountain-sun","fal fa-mountain-sun","fas fa-oil-well","far fa-oil-well","fal fa-oil-well","fas fa-parachute-box","far fa-parachute-box","fal fa-parachute-box","fas fa-people-arrows","far fa-people-arrows","fal fa-people-arrows","fas fa-people-group","far fa-people-group","fal fa-people-group","fas fa-people-line","far fa-people-line","fal fa-people-line","fas fa-people-pulling","far fa-people-pulling","fal fa-people-pulling","fas fa-people-robbery","far fa-people-robbery","fal fa-people-robbery","fas fa-people-roof","far fa-people-roof","fal fa-people-roof","fas fa-person","far fa-person","fal fa-person","fas fa-person-arrow-down-to-line","far fa-person-arrow-down-to-line","fal fa-person-arrow-down-to-line","fas fa-person-arrow-up-from-line","far fa-person-arrow-up-from-line","fal fa-person-arrow-up-from-line","fas fa-person-breastfeeding","far fa-person-breastfeeding","fal fa-person-breastfeeding","fas fa-person-burst","far fa-person-burst","fal fa-person-burst","fas fa-person-cane","far fa-person-cane","fal fa-person-cane","fas fa-person-chalkboard","far fa-person-chalkboard","fal fa-person-chalkboard","fas fa-person-circle-check","far fa-person-circle-check","fal fa-person-circle-check","fas fa-person-circle-exclamation","far fa-person-circle-exclamation","fal fa-person-circle-exclamation","fas fa-person-circle-minus","far fa-person-circle-minus","fal fa-person-circle-minus","fas fa-person-circle-plus","far fa-person-circle-plus","fal fa-person-circle-plus","fas fa-person-circle-question","far fa-person-circle-question","fal fa-person-circle-question","fas fa-person-circle-xmark","far fa-person-circle-xmark","fal fa-person-circle-xmark","fas fa-person-digging","far fa-person-digging","fal fa-person-digging","fas fa-person-dress","far fa-person-dress","fal fa-person-dress","fas fa-person-dress-burst","far fa-person-dress-burst","fal fa-person-dress-burst","fas fa-person-drowning","far fa-person-drowning","fal fa-person-drowning","fas fa-person-falling","far fa-person-falling","fal fa-person-falling","fas fa-person-falling-burst","far fa-person-falling-burst","fal fa-person-falling-burst","fas fa-person-half-dress","far fa-person-half-dress","fal fa-person-half-dress","fas fa-person-harassing","far fa-person-harassing","fal fa-person-harassing","fas fa-person-military-pointing","far fa-person-military-pointing","fal fa-person-military-pointing","fas fa-person-military-rifle","far fa-person-military-rifle","fal fa-person-military-rifle","fas fa-person-military-to-person","far fa-person-military-to-person","fal fa-person-military-to-person","fas fa-person-pregnant","far fa-person-pregnant","fal fa-person-pregnant","fas fa-person-rays","far fa-person-rays","fal fa-person-rays","fas fa-person-rifle","far fa-person-rifle","fal fa-person-rifle","fas fa-person-shelter","far fa-person-shelter","fal fa-person-shelter","fas fa-person-through-window","far fa-person-through-window","fal fa-person-through-window","fas fa-person-walking","far fa-person-walking","fal fa-person-walking","fas fa-person-walking-arrow-loop-left","far fa-person-walking-arrow-loop-left","fal fa-person-walking-arrow-loop-left","fas fa-person-walking-arrow-right","far fa-person-walking-arrow-right","fal fa-person-walking-arrow-right","fas fa-person-walking-dashed-line-arrow-right","far fa-person-walking-dashed-line-arrow-right","fal fa-person-walking-dashed-line-arrow-right","fas fa-person-walking-luggage","far fa-person-walking-luggage","fal fa-person-walking-luggage","fas fa-pills","far fa-pills","fal fa-pills","fas fa-plane-circle-check","far fa-plane-circle-check","fal fa-plane-circle-check","fas fa-plane-circle-exclamation","far fa-plane-circle-exclamation","fal fa-plane-circle-exclamation","fas fa-plane-circle-xmark","far fa-plane-circle-xmark","fal fa-plane-circle-xmark","fas fa-plane-lock","far fa-plane-lock","fal fa-plane-lock","fas fa-plane-up","far fa-plane-up","fal fa-plane-up","fas fa-plant-wilt","far fa-plant-wilt","fal fa-plant-wilt","fas fa-plate-wheat","far fa-plate-wheat","fal fa-plate-wheat","fas fa-plug","far fa-plug","fal fa-plug","fas fa-plug-circle-bolt","far fa-plug-circle-bolt","fal fa-plug-circle-bolt","fas fa-plug-circle-check","far fa-plug-circle-check","fal fa-plug-circle-check","fas fa-plug-circle-exclamation","far fa-plug-circle-exclamation","fal fa-plug-circle-exclamation","fas fa-plug-circle-minus","far fa-plug-circle-minus","fal fa-plug-circle-minus","fas fa-plug-circle-plus","far fa-plug-circle-plus","fal fa-plug-circle-plus","fas fa-plug-circle-xmark","far fa-plug-circle-xmark","fal fa-plug-circle-xmark","fas fa-pump-soap","far fa-pump-soap","fal fa-pump-soap","fas fa-radiation","far fa-radiation","fal fa-radiation","fas fa-radio","far fa-radio","fal fa-radio","fas fa-ranking-star","far fa-ranking-star","fal fa-ranking-star","fas fa-road","far fa-road","fal fa-road","fas fa-road-barrier","far fa-road-barrier","fal fa-road-barrier","fas fa-road-bridge","far fa-road-bridge","fal fa-road-bridge","fas fa-road-circle-check","far fa-road-circle-check","fal fa-road-circle-check","fas fa-road-circle-exclamation","far fa-road-circle-exclamation","fal fa-road-circle-exclamation","fas fa-road-circle-xmark","far fa-road-circle-xmark","fal fa-road-circle-xmark","fas fa-road-lock","far fa-road-lock","fal fa-road-lock","fas fa-road-spikes","far fa-road-spikes","fal fa-road-spikes","fas fa-rug","far fa-rug","fal fa-rug","fas fa-sack-dollar","far fa-sack-dollar","fal fa-sack-dollar","fas fa-sack-xmark","far fa-sack-xmark","fal fa-sack-xmark","fas fa-sailboat","far fa-sailboat","fal fa-sailboat","fas fa-satellite-dish","far fa-satellite-dish","fal fa-satellite-dish","fas fa-scale-balanced","far fa-scale-balanced","fal fa-scale-balanced","fas fa-school","far fa-school","fal fa-school","fas fa-school-circle-check","far fa-school-circle-check","fal fa-school-circle-check","fas fa-school-circle-exclamation","far fa-school-circle-exclamation","fal fa-school-circle-exclamation","fas fa-school-circle-xmark","far fa-school-circle-xmark","fal fa-school-circle-xmark","fas fa-school-flag","far fa-school-flag","fal fa-school-flag","fas fa-school-lock","far fa-school-lock","fal fa-school-lock","fas fa-seedling","far fa-seedling","fal fa-seedling","fas fa-sheet-plastic","far fa-sheet-plastic","fal fa-sheet-plastic","fas fa-shield-cat","far fa-shield-cat","fal fa-shield-cat","fas fa-shield-dog","far fa-shield-dog","fal fa-shield-dog","fas fa-shield-heart","far fa-shield-heart","fal fa-shield-heart","fas fa-ship","far fa-ship","fal fa-ship","fas fa-shirt","far fa-shirt","fal fa-shirt","fas fa-shop","far fa-shop","fal fa-shop","fas fa-shop-lock","far fa-shop-lock","fal fa-shop-lock","fas fa-shower","far fa-shower","fal fa-shower","fas fa-skull-crossbones","far fa-skull-crossbones","fal fa-skull-crossbones","fas fa-snowflake","far fa-snowflake","fal fa-snowflake","fas fa-soap","far fa-soap","fal fa-soap","fas fa-square-nfi","far fa-square-nfi","fal fa-square-nfi","fas fa-square-person-confined","far fa-square-person-confined","fal fa-square-person-confined","fas fa-square-virus","far fa-square-virus","fal fa-square-virus","fas fa-staff-snake","far fa-staff-snake","fal fa-staff-snake","fas fa-stethoscope","far fa-stethoscope","fal fa-stethoscope","fas fa-suitcase-medical","far fa-suitcase-medical","fal fa-suitcase-medical","fas fa-sun-plant-wilt","far fa-sun-plant-wilt","fal fa-sun-plant-wilt","fas fa-syringe","far fa-syringe","fal fa-syringe","fas fa-tarp","far fa-tarp","fal fa-tarp","fas fa-tarp-droplet","far fa-tarp-droplet","fal fa-tarp-droplet","fas fa-temperature-arrow-down","far fa-temperature-arrow-down","fal fa-temperature-arrow-down","fas fa-temperature-arrow-up","far fa-temperature-arrow-up","fal fa-temperature-arrow-up","fas fa-tent","far fa-tent","fal fa-tent","fas fa-tent-arrow-down-to-line","far fa-tent-arrow-down-to-line","fal fa-tent-arrow-down-to-line","fas fa-tent-arrow-left-right","far fa-tent-arrow-left-right","fal fa-tent-arrow-left-right","fas fa-tent-arrow-turn-left","far fa-tent-arrow-turn-left","fal fa-tent-arrow-turn-left","fas fa-tent-arrows-down","far fa-tent-arrows-down","fal fa-tent-arrows-down","fas fa-tents","far fa-tents","fal fa-tents","fas fa-toilet","far fa-toilet","fal fa-toilet","fas fa-toilet-portable","far fa-toilet-portable","fal fa-toilet-portable","fas fa-toilets-portable","far fa-toilets-portable","fal fa-toilets-portable","fas fa-tornado","far fa-tornado","fal fa-tornado","fas fa-tower-broadcast","far fa-tower-broadcast","fal fa-tower-broadcast","fas fa-tower-cell","far fa-tower-cell","fal fa-tower-cell","fas fa-tower-observation","far fa-tower-observation","fal fa-tower-observation","fas fa-train-subway","far fa-train-subway","fal fa-train-subway","fas fa-trash-can","far fa-trash-can","fal fa-trash-can","fas fa-tree-city","far fa-tree-city","fal fa-tree-city","fas fa-trowel","far fa-trowel","fal fa-trowel","fas fa-trowel-bricks","far fa-trowel-bricks","fal fa-trowel-bricks","fas fa-truck","far fa-truck","fal fa-truck","fas fa-truck-arrow-right","far fa-truck-arrow-right","fal fa-truck-arrow-right","fas fa-truck-droplet","far fa-truck-droplet","fal fa-truck-droplet","fas fa-truck-field","far fa-truck-field","fal fa-truck-field","fas fa-truck-field-un","far fa-truck-field-un","fal fa-truck-field-un","fas fa-truck-front","far fa-truck-front","fal fa-truck-front","fas fa-truck-medical","far fa-truck-medical","fal fa-truck-medical","fas fa-truck-plane","far fa-truck-plane","fal fa-truck-plane","fas fa-user-doctor","far fa-user-doctor","fal fa-user-doctor","fas fa-user-injured","far fa-user-injured","fal fa-user-injured","fas fa-users-between-lines","far fa-users-between-lines","fal fa-users-between-lines","fas fa-users-line","far fa-users-line","fal fa-users-line","fas fa-users-rays","far fa-users-rays","fal fa-users-rays","fas fa-users-rectangle","far fa-users-rectangle","fal fa-users-rectangle","fas fa-users-viewfinder","far fa-users-viewfinder","fal fa-users-viewfinder","fas fa-vial-circle-check","far fa-vial-circle-check","fal fa-vial-circle-check","fas fa-vial-virus","far fa-vial-virus","fal fa-vial-virus","fas fa-vihara","far fa-vihara","fal fa-vihara","fas fa-virus","far fa-virus","fal fa-virus","fas fa-virus-covid","far fa-virus-covid","fal fa-virus-covid","fas fa-volcano","far fa-volcano","fal fa-volcano","fas fa-walkie-talkie","far fa-walkie-talkie","fal fa-walkie-talkie","fas fa-wheat-awn","far fa-wheat-awn","fal fa-wheat-awn","fas fa-wheat-awn-circle-exclamation","far fa-wheat-awn-circle-exclamation","fal fa-wheat-awn-circle-exclamation","fas fa-wheelchair-move","far fa-wheelchair-move","fal fa-wheelchair-move","fas fa-wifi","far fa-wifi","fal fa-wifi","fas fa-wind","far fa-wind","fal fa-wind","fas fa-worm","far fa-worm","fal fa-worm","fas fa-xmarks-lines","far fa-xmarks-lines","fal fa-xmarks-lines"]},{"id":"gender","title":"Genders","icons":["fas fa-genderless","far fa-genderless","fal fa-genderless","fas fa-mars","far fa-mars","fal fa-mars","fas fa-mars-and-venus","far fa-mars-and-venus","fal fa-mars-and-venus","fas fa-mars-double","far fa-mars-double","fal fa-mars-double","fas fa-mars-stroke","far fa-mars-stroke","fal fa-mars-stroke","fas fa-mars-stroke-right","far fa-mars-stroke-right","fal fa-mars-stroke-right","fas fa-mars-stroke-up","far fa-mars-stroke-up","fal fa-mars-stroke-up","fas fa-mercury","far fa-mercury","fal fa-mercury","fas fa-neuter","far fa-neuter","fal fa-neuter","fas fa-person-half-dress","far fa-person-half-dress","fal fa-person-half-dress","fas fa-transgender","far fa-transgender","fal fa-transgender","fas fa-venus","far fa-venus","fal fa-venus","fas fa-venus-double","far fa-venus-double","fal fa-venus-double","fas fa-venus-mars","far fa-venus-mars","fal fa-venus-mars"]},{"id":"brands","title":"Brands","icons":["fab fa-youtube","fab fa-bluetooth-b","fab fa-accessible-icon","fab fa-napster","fab fa-soundcloud","fab fa-spotify","fab fa-bitcoin","fab fa-btc","fab fa-ethereum","fab fa-gg","fab fa-gg-circle","fab fa-galactic-republic","fab fa-galactic-senate","fab fa-jedi-order","fab fa-old-republic","fab fa-space-awesome","fab fa-alipay","fab fa-amazon-pay","fab fa-apple-pay","fab fa-cc-amazon-pay","fab fa-cc-amex","fab fa-cc-apple-pay","fab fa-cc-diners-club","fab fa-cc-discover","fab fa-cc-jcb","fab fa-cc-mastercard","fab fa-cc-paypal","fab fa-cc-stripe","fab fa-cc-visa","fab fa-google-pay","fab fa-google-wallet","fab fa-nfc-directional","fab fa-nfc-symbol","fab fa-paypal","fab fa-stripe","fab fa-stripe-s","fab fa-unsplash","fab fa-font-awesome","fab fa-web-awesome","fab fa-bluetooth","fab fa-critical-role","fab fa-d-and-d","fab fa-d-and-d-beyond","fab fa-fantasy-flight-games","fab fa-playstation","fab fa-square-steam","fab fa-steam","fab fa-steam-symbol","fab fa-twitch","fab fa-wizards-of-the-coast","fab fa-xbox","fab fa-bluesky","fab fa-facebook","fab fa-monero","fab fa-hooli","fab fa-yelp","fab fa-lastfm","fab fa-shopware","fab fa-creative-commons-nc","fab fa-aws","fab fa-redhat","fab fa-yoast","fab fa-cloudflare","fab fa-ups","fab fa-pixiv","fab fa-wpexplorer","fab fa-dyalog","fab fa-bity","fab fa-stackpath","fab fa-buysellads","fab fa-first-order","fab fa-modx","fab fa-guilded","fab fa-vnv","fab fa-square-js","fab fa-microsoft","fab fa-qq","fab fa-orcid","fab fa-java","fab fa-invision","fab fa-creative-commons-pd-alt","fab fa-centercode","fab fa-glide-g","fab fa-drupal","fab fa-jxl","fab fa-dart-lang","fab fa-hire-a-helper","fab fa-creative-commons-by","fab fa-unity","fab fa-whmcs","fab fa-rocketchat","fab fa-vk","fab fa-untappd","fab fa-mailchimp","fab fa-css3-alt","fab fa-square-reddit","fab fa-vimeo-v","fab fa-contao","fab fa-square-font-awesome","fab fa-deskpro","fab fa-brave","fab fa-sistrix","fab fa-square-instagram","fab fa-battle-net","fab fa-the-red-yeti","fab fa-square-hacker-news","fab fa-edge","fab fa-threads","fab fa-square-snapchat","fab fa-google-plus-g","fab fa-artstation","fab fa-markdown","fab fa-sourcetree","fab fa-google-plus","fab fa-diaspora","fab fa-foursquare","fab fa-stack-overflow","fab fa-github-alt","fab fa-phoenix-squadron","fab fa-pagelines","fab fa-algolia","fab fa-red-river","fab fa-creative-commons-sa","fab fa-safari","fab fa-google","fab fa-square-font-awesome-stroke","fab fa-atlassian","fab fa-linkedin-in","fab fa-digital-ocean","fab fa-nimblr","fab fa-chromecast","fab fa-evernote","fab fa-hacker-news","fab fa-creative-commons-sampling","fab fa-adversal","fab fa-creative-commons","fab fa-watchman-monitoring","fab fa-fonticons","fab fa-weixin","fab fa-shirtsinbulk","fab fa-codepen","fab fa-git-alt","fab fa-lyft","fab fa-rev","fab fa-windows","fab fa-square-viadeo","fab fa-meetup","fab fa-centos","fab fa-adn","fab fa-cloudsmith","fab fa-opensuse","fab fa-pied-piper-alt","fab fa-square-dribbble","fab fa-codiepie","fab fa-node","fab fa-mix","fab fa-scribd","fab fa-debian","fab fa-openid","fab fa-instalod","fab fa-expeditedssl","fab fa-sellcast","fab fa-square-twitter","fab fa-r-project","fab fa-delicious","fab fa-freebsd","fab fa-vuejs","fab fa-accusoft","fab fa-ioxhost","fab fa-fonticons-fi","fab fa-app-store","fab fa-itunes-note","fab fa-golang","fab fa-kickstarter","fab fa-grav","fab fa-weibo","fab fa-uncharted","fab fa-firstdraft","fab fa-square-youtube","fab fa-wikipedia-w","fab fa-wpressr","fab fa-angellist","fab fa-skype","fab fa-joget","fab fa-fedora","fab fa-meta","fab fa-laravel","fab fa-hotjar","fab fa-square-letterboxd","fab fa-sticker-mule","fab fa-creative-commons-zero","fab fa-hips","fab fa-behance","fab fa-reddit","fab fa-discord","fab fa-chrome","fab fa-app-store-ios","fab fa-wpbeginner","fab fa-confluence","fab fa-shoelace","fab fa-mdb","fab fa-dochub","fab fa-ebay","fab fa-amazon","fab fa-yarn","fab fa-500px","fab fa-square-vimeo","fab fa-asymmetrik","fab fa-gratipay","fab fa-apple","fab fa-hive","fab fa-gitkraken","fab fa-keybase","fab fa-padlet","fab fa-square-github","fab fa-stumbleupon","fab fa-fedex","fab fa-phoenix-framework","fab fa-shopify","fab fa-neos","fab fa-square-threads","fab fa-hackerrank","fab fa-researchgate","fab fa-swift","fab fa-angular","fab fa-speakap","fab fa-angrycreative","fab fa-y-combinator","fab fa-empire","fab fa-envira","fab fa-google-scholar","fab fa-square-gitlab","fab fa-studiovinari","fab fa-pied-piper","fab fa-wordpress","fab fa-product-hunt","fab fa-firefox","fab fa-linode","fab fa-goodreads","fab fa-square-odnoklassniki","fab fa-jsfiddle","fab fa-sith","fab fa-themeisle","fab fa-page4","fab fa-hashnode","fab fa-react","fab fa-squarespace","fab fa-creative-commons-share","fab fa-keycdn","fab fa-opera","fab fa-itch-io","fab fa-umbraco","fab fa-ubuntu","fab fa-draft2digital","fab fa-houzz","fab fa-dhl","fab fa-square-pinterest","fab fa-xing","fab fa-blackberry","fab fa-creative-commons-pd","fab fa-quinscape","fab fa-less","fab fa-blogger-b","fab fa-opencart","fab fa-vine","fab fa-signal-messenger","fab fa-gitlab","fab fa-typo3","fab fa-reddit-alien","fab fa-yahoo","fab fa-dailymotion","fab fa-affiliatetheme","fab fa-pied-piper-pp","fab fa-bootstrap","fab fa-odnoklassniki","fab fa-mintbit","fab fa-speaker-deck","fab fa-creative-commons-nc-eu","fab fa-patreon","fab fa-avianex","fab fa-ello","fab fa-gofore","fab fa-bimobject","fab fa-brave-reverse","fab fa-facebook-f","fab fa-square-google-plus","fab fa-mandalorian","fab fa-first-order-alt","fab fa-osi","fab fa-periscope","fab fa-fulcrum","fab fa-cloudscale","fab fa-forumbee","fab fa-mizuni","fab fa-schlix","fab fa-square-xing","fab fa-bandcamp","fab fa-wpforms","fab fa-cloudversify","fab fa-usps","fab fa-megaport","fab fa-magento","fab fa-optin-monster","fab fa-fly","fab fa-aviato","fab fa-itunes","fab fa-cuttlefish","fab fa-blogger","fab fa-flickr","fab fa-viber","fab fa-digg","fab fa-tencent-weibo","fab fa-letterboxd","fab fa-symfony","fab fa-maxcdn","fab fa-etsy","fab fa-facebook-messenger","fab fa-audible","fab fa-think-peaks","fab fa-bilibili","fab fa-erlang","fab fa-x-twitter","fab fa-cotton-bureau","fab fa-dashcube","fab fa-42-group","fab fa-stack-exchange","fab fa-elementor","fab fa-square-pied-piper","fab fa-creative-commons-nd","fab fa-palfed","fab fa-superpowers","fab fa-resolving","fab fa-square-web-awesome-stroke","fab fa-searchengin","fab fa-tiktok","fab fa-square-facebook","fab fa-renren","fab fa-linux","fab fa-glide","fab fa-linkedin","fab fa-hubspot","fab fa-deploydog","fab fa-flutter","fab fa-ravelry","fab fa-mixer","fab fa-square-lastfm","fab fa-vimeo","fab fa-mendeley","fab fa-uniregistry","fab fa-figma","fab fa-creative-commons-remix","fab fa-dropbox","fab fa-instagram","fab fa-cmplid","fab fa-upwork","fab fa-gripfire","fab fa-uikit","fab fa-fort-awesome-alt","fab fa-phabricator","fab fa-ussunnah","fab fa-earlybirds","fab fa-trade-federation","fab fa-autoprefixer","fab fa-whatsapp","fab fa-square-upwork","fab fa-slideshare","fab fa-google-play","fab fa-viadeo","fab fa-line","fab fa-google-drive","fab fa-servicestack","fab fa-simplybuilt","fab fa-bitbucket","fab fa-imdb","fab fa-deezer","fab fa-raspberry-pi","fab fa-jira","fab fa-docker","fab fa-screenpal","fab fa-gitter","fab fa-microblog","fab fa-pied-piper-hat","fab fa-kickstarter-k","fab fa-yandex","fab fa-readme","fab fa-html5","fab fa-sellsy","fab fa-square-web-awesome","fab fa-sass","fab fa-wirsindhandwerk","fab fa-buromobelexperte","fab fa-salesforce","fab fa-octopus-deploy","fab fa-medapps","fab fa-ns8","fab fa-pinterest-p","fab fa-apper","fab fa-fort-awesome","fab fa-waze","fab fa-snapchat","fab fa-rust","fab fa-wix","fab fa-square-behance","fab fa-supple","fab fa-webflow","fab fa-rebel","fab fa-css3","fab fa-staylinked","fab fa-kaggle","fab fa-deviantart","fab fa-cpanel","fab fa-goodreads-g","fab fa-square-git","fab fa-square-tumblr","fab fa-trello","fab fa-creative-commons-nc-jp","fab fa-get-pocket","fab fa-perbyte","fab fa-grunt","fab fa-weebly","fab fa-connectdevelop","fab fa-leanpub","fab fa-black-tie","fab fa-themeco","fab fa-python","fab fa-android","fab fa-bots","fab fa-free-code-camp","fab fa-hornbill","fab fa-js","fab fa-ideal","fab fa-git","fab fa-dev","fab fa-sketch","fab fa-yandex-international","fab fa-uber","fab fa-github","fab fa-php","fab fa-skyatlas","fab fa-firefox-browser","fab fa-replyd","fab fa-suse","fab fa-jenkins","fab fa-twitter","fab fa-rockrms","fab fa-pinterest","fab fa-buffer","fab fa-npm","fab fa-yammer","fab fa-dribbble","fab fa-stumbleupon-circle","fab fa-internet-explorer","fab fa-stubber","fab fa-telegram","fab fa-odysee","fab fa-square-whatsapp","fab fa-node-js","fab fa-edge-legacy","fab fa-slack","fab fa-medrt","fab fa-usb","fab fa-tumblr","fab fa-vaadin","fab fa-quora","fab fa-square-x-twitter","fab fa-reacteurope","fab fa-medium","fab fa-amilia","fab fa-mixcloud","fab fa-flipboard","fab fa-viacoin","fab fa-sitrox","fab fa-discourse","fab fa-joomla","fab fa-mastodon","fab fa-airbnb","fab fa-wolf-pack-battalion","fab fa-buy-n-large","fab fa-gulp","fab fa-creative-commons-sampling-plus","fab fa-strava","fab fa-ember","fab fa-canadian-maple-leaf","fab fa-teamspeak","fab fa-pushed","fab fa-wordpress-simple","fab fa-nutritionix","fab fa-wodu","fab fa-intercom","fab fa-zhihu","fab fa-korvue","fab fa-pix"]}]', true)
                )
            );
            return $config;
        }
    }
}