<?php
/**
 *
 * Name: Product Style 18
 * Shortcode: true
 * Theme Option: true
 **/
?>
<?php

global $product;

?>
<div class="product-inner">
    <?php
    /**
     * woocommerce_before_shop_loop_item hook.
     *
     * @removed woocommerce_template_loop_product_link_open - 10
     */
    do_action( 'woocommerce_before_shop_loop_item' );
    ?>
    <div class="product-thumb tooltip-wrap tooltip-start">
        <?php
        /**
         * woocommerce_before_shop_loop_item_title hook.
         *
         * @hooked woocommerce_show_product_loop_sale_flash - 10
         * @hooked woocommerce_template_loop_product_thumbnail - 10
         */
        do_action( 'woocommerce_before_shop_loop_item_title' );
        ?>
        <?php if ( !elinor_is_mobile( true ) ) : ?>
            <div class="product-cart">
                <?php elinor_template_loop_variable(); ?>
                <a href="<?php echo esc_url( $product->get_permalink() ) ?>" class="product-view-more"><?php echo esc_html__( 'More Details', 'elinor' ); ?></a>
            </div>
        <?php endif; ?>
    </div>
    <div class="product-info equal-elem">
        <?php elinor_loop_display_category(); ?>
        <?php
        /**
         * woocommerce_shop_loop_item_title hook.
         *
         * @hooked woocommerce_template_loop_product_title - 10
         */
        do_action( 'woocommerce_shop_loop_item_title' );
        ?>
        <?php
        /**
         * woocommerce_after_shop_loop_item_title hook.
         *
         * @hooked woocommerce_template_loop_rating - 5
         * @hooked woocommerce_template_loop_price - 10
         */
        do_action( 'woocommerce_after_shop_loop_item_title' );
        ?>
    </div>
</div>