<?php
/**
 * Name: Product Style List
 **/
?>
<?php
global $product;

$functions = array(
    array( 'remove_action', 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 ),
);
elinor_add_action( $functions );
?>
    <div class="product-inner">
        <?php
        /**
         * Hook: woocommerce_before_shop_loop_item.
         *
         * @hooked woocommerce_template_loop_product_link_open - 10
         */
        do_action( 'woocommerce_before_shop_loop_item' );
        ?>
        <div class="product-thumb">
            <?php
            /**
             * Hook: woocommerce_before_shop_loop_item_title.
             *
             * @hooked woocommerce_show_product_loop_sale_flash - 10
             * @hooked woocommerce_template_loop_product_thumbnail - 10
             */
            do_action( 'woocommerce_before_shop_loop_item_title' );
            ?>
        </div>
        <div class="product-info">
            <div class="info-start">
                <?php elinor_unit_of_measure_html(); ?>
                <div class="equal-elem">
                    <?php
                    /**
                     * woocommerce_shop_loop_item_title hook.
                     *
                     * @hooked woocommerce_template_loop_product_title - 10
                     */
                    do_action( 'woocommerce_shop_loop_item_title' );
                    ?>
                </div>
                <?php
                /**
                 * Hook: woocommerce_after_shop_loop_item_title.
                 *
                 * @hooked woocommerce_template_loop_rating - 5
                 * @hooked woocommerce_template_loop_price - 10
                 */
                do_action( 'woocommerce_after_shop_loop_item_title' );
                ?>
                <?php elinor_product_excerpt(); ?>
            </div>
            <div class="info-end">
                <?php
                echo wc_get_stock_html( $product );
                woocommerce_template_loop_price();
                /**
                 * Hook: woocommerce_after_shop_loop_item.
                 *
                 * @hooked woocommerce_template_loop_product_link_close - 5
                 * @hooked woocommerce_template_loop_add_to_cart - 10
                 */
                do_action( 'woocommerce_after_shop_loop_item' );
                ?>
                <?php if ( !elinor_is_mobile( true ) ) : ?>
                    <div class="group-button">
                        <?php
                        do_action( 'elinor_function_shop_loop_item_wishlist' );
                        do_action( 'elinor_function_shop_loop_item_compare' );
                        ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php
elinor_add_action( $functions, true );
