<?php
/**
 * Product Loop Start
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/loop-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.3.0
 */

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

/**
 *
 * SETUP SHOP LOOP
 */
elinor_woocommerce_setup_loop();

$disable_labels = elinor_get_option( 'disable_labels' );
$disable_rating = elinor_get_option( 'disable_rating' );
$short_text     = elinor_get_option( 'short_text' );
$columns        = wc_get_loop_prop( 'columns' );
$product_style  = wc_get_loop_prop( 'style' );
if ( in_array( $product_style, array(
    'list',
    'style-01',
    'style-02',
    'style-04',
    'style-05',
    'style-06',
    'style-09',
    'style-10',
    'style-11',
    'style-12',
    'style-13',
    'style-18'
) ) ) {
    $product_border = elinor_get_option( 'shop_product_border', 'product-border-2' );
} else {
    $product_border = '';
}
$class = array(
    "products",
    "shop-page",
    "response-content",
    "equal-container better-height",
    "columns-{$columns}",
    "ovic-products {$product_style} {$product_border}",
);
if ( $disable_labels == 1 )
    $class[] = 'labels-not-yes';
if ( $disable_rating == 1 )
    $class[] = 'rating-not-yes';
if ( $short_text == 1 )
    $class[] = 'short-text-yes';

/**
 *
 * SHOP CONTROL
 */
elinor_control_before_shop_loop();
?>
<ul class="<?php echo esc_attr( implode( ' ', $class ) ); ?>">
