<?php
/**
 * Content wrappers
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/wrapper-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.3.0
 */

if ( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$page_layout       = elinor_page_layout();
$builder_position  = elinor_get_option( 'shop_builder_position', 'outside' );
$product_thumbnail = elinor_get_option( 'single_product_thumbnail', 'standard' );
$page_title        = elinor_get_option( 'shop_page_title', 1 );
$page_title_bg     = elinor_get_option( 'shop_page_title_bg' );
$page_title_fixed  = elinor_get_option( 'shop_page_title_fixed' );

if ( is_product_taxonomy() && 0 === absint( get_query_var( 'paged' ) ) ) {
    $term = get_queried_object();
    if ( $term && $term->taxonomy !== 'dc_vendor_shop' ) {
        $image_taxonomy = get_term_meta( $term->term_id, 'banner_id', true );
        if ( $term->taxonomy === 'product_brand' )
            $image_taxonomy = get_term_meta( $term->term_id, 'thumbnail_id', true );
        if ( !empty( $image_taxonomy ) )
            $page_title_bg = $image_taxonomy;
    }
}
$class_contain = array(
    "container",
    "site-content",
    "sidebar-{$page_layout['layout']}",
);
if ( is_product() ) {
    $class_contain[] = "product-page";
    $class_contain[] = "product-page-{$product_thumbnail}";
} else {
    $class_contain[] = "shop-page";
}
?>

<?php if ( !is_product() ) elinor_get_template(
    "templates-parts/page-head.php",
    array(
        'page_title'       => $page_title,
        'page_title_bg'    => $page_title_bg,
        'page_title_fixed' => $page_title_fixed,
    )
); ?>
<?php elinor_breadcrumb(); ?>

<!-- .site-content-contain -->
<div id="content" class="<?php echo esc_attr( implode( ' ', $class_contain ) ); ?>">

    <?php if ( !is_product() && $builder_position == 'outside' ) {
        get_template_part( 'templates-parts/shop-builder', 'top' );
    } ?>

    <div id="primary" class="content-area">
        <main id="main" class="site-main">
            <?php if ( !is_product() && $builder_position != 'outside' ) {
                get_template_part( 'templates-parts/shop-builder', 'top' );
            } ?>
