<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
    echo get_the_password_form(); // WPCS: XSS ok.

    return;
}

if ( function_exists( 'ovic_set_post_views' ) ) {
    ovic_set_post_views( $product->get_id(), 'product' );
}

$product_summary = elinor_get_option( 'single_product_summary', 'standard' );

$hook = array(
    array( 'remove_action', 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 ),
    array( 'add_action', 'woocommerce_product_thumbnails', 'elinor_more_product_thumbnails', 30 ),
    array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 ),
    array( 'add_action', 'woocommerce_single_product_summary', function () {
        elinor_product_loop_countdown( 'style-02' );
    }, 10 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'elinor_unit_of_measure_html', 0 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'elinor_product_custom_info', 35 ),
    array( 'add_action', 'woocommerce_single_product_summary', 'elinor_product_share', 45 ),
    array( 'add_action', 'woocommerce_after_single_product_summary', function () {
        echo '<div class="woocommerce-tabs-wrap">';
    }, 9 ),
    array(
        'add_action', 'woocommerce_after_single_product_summary', function () {
        $page_layout = elinor_page_layout();
        if ( $page_layout['layout'] != 'full' ) : ?>
            <aside id="secondary" class="widget-area <?php echo esc_attr( $page_layout['sidebar'] ); ?>" role="complementary"
                   aria-label="<?php esc_attr_e( 'Shop Sidebar', 'elinor' ); ?>">
                <?php dynamic_sidebar( $page_layout['sidebar'] ); ?>
            </aside><!-- #secondary -->
        <?php endif;
    }, 10
    ),
    array(
        'add_action', 'woocommerce_after_single_product_summary', function () {
        echo '</div>';
    }, 11
    ),
);
if ( $product_summary == 'sub-column' ) {
    array_push( $hook,
        array( 'add_action', 'woocommerce_single_product_sub_column', 'elinor_product_sub_column_info', 10 ),
        array( 'add_action', 'woocommerce_single_product_sub_column', 'elinor_product_sub_column_payment', 10 )
    );
}
if ( $product_summary == 'sub-column-2' ) {
    array_push( $hook,
        array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 ),
        array( 'remove_action', 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 ),
        array( 'add_action', 'woocommerce_single_product_sub_column', 'woocommerce_template_single_price', 10 ),
        array( 'add_action', 'woocommerce_single_product_sub_column', 'woocommerce_template_single_add_to_cart', 10 )
    );
}
elinor_add_action( $hook );

$page_layout    = elinor_page_layout();
$attachment_ids = $product->get_gallery_image_ids();
$class_wrapper  = array( 'single-product-wrapper' );
if ( !empty( $attachment_ids ) && has_post_thumbnail() || !empty( $video_url ) || !empty( $galleries ) ) {
    $class_wrapper[] = 'has-gallery';
}
$slide      = apply_filters( 'elinor_slide_single_product_thumbnail', array(
    'infinite'      => false,
    'slidesMargin'  => 24,
    'slidesToShow'  => 4,
    'vertical'      => true,
    'variableWidth' => true,
    'responsive'    => array(
        array(
            'breakpoint' => 1500,
            'settings'   => array(
                'slidesMargin' => 16,
            ),
        ),
        array(
            'breakpoint' => 480,
            'settings'   => array(
                'slidesMargin' => 8,
                'vertical'     => false,
            ),
        ),
    ),
) );
$data_slide = json_encode( $slide );
?>
    <div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>

        <div class="<?php echo esc_attr( implode( ' ', $class_wrapper ) ); ?>"
             data-slick="<?php echo esc_attr( $data_slide ); ?>">
            <?php
            /**
             * Hook: woocommerce_before_single_product_summary.
             *
             * @hooked woocommerce_show_product_sale_flash - 10
             * @hooked woocommerce_show_product_images - 20
             */
            do_action( 'woocommerce_before_single_product_summary' );
            ?>
            <?php if ( $product_summary == 'sub-column' || $product_summary == 'sub-column-2' ): ?>
                <div class="entry-summary product-sub-column">
                    <div class="summary main-column">
                        <?php do_action( 'woocommerce_single_product_summary' ); ?>
                    </div>
                    <div class="summary sub-column">
                        <?php do_action( 'woocommerce_single_product_sub_column' ); ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="summary entry-summary">
                    <?php
                    /**
                     * Hook: woocommerce_single_product_summary.
                     *
                     * @hooked woocommerce_template_single_title - 5
                     * @hooked woocommerce_template_single_rating - 10
                     * @hooked woocommerce_template_single_price - 10
                     * @hooked woocommerce_template_single_excerpt - 20
                     * @hooked woocommerce_template_single_add_to_cart - 30
                     * @hooked woocommerce_template_single_meta - 40
                     * @hooked woocommerce_template_single_sharing - 50
                     * @hooked WC_Structured_Data::generate_product_data() - 60
                     */
                    do_action( 'woocommerce_single_product_summary' );
                    ?>
                </div>
            <?php endif; ?>
        </div>

        <?php
        /**
         * Hook: woocommerce_after_single_product_summary.
         *
         * @hooked woocommerce_output_product_data_tabs - 10
         * @hooked woocommerce_upsell_display - 15
         * @hooked woocommerce_output_related_products - 20
         */
        do_action( 'woocommerce_after_single_product_summary' );
        ?>
    </div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
<?php
elinor_add_action( $hook, true );

