<?php
$post_style = elinor_get_option( 'single_layout', 'standard' );
$share      = elinor_get_option( 'enable_share_post' );
if ( isset( $_GET['elementor-preview'] ) ) {
    $share = 0;
}
while ( have_posts() ): the_post(); ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class( 'post-item post-single' ); ?>>
        <?php if ( has_post_thumbnail() ) : ?>
            <div class="post-thumb">
                <?php if ( $post_style == 'standard' ) {
                    elinor_get_term_list();
                } ?>
                <?php the_post_thumbnail( 'full' ); ?>
            </div>
        <?php endif; ?>
        <div class="post-inner <?php if ( $share == 1 ) echo esc_attr( 'has-share' ); ?>">
            <?php elinor_post_share(); ?>
            <div class="post-info">
                <?php
                elinor_post_title( false );
                ?>
                <?php if ( !isset( $_GET['elementor-preview'] ) ) : ?>
                    <div class="post-metas">
                        <?php
                        if ( get_post_type() != 'product' ) {
                            if ( $post_style == 'fullwidth' ) {
                                elinor_get_term_list();
                            }
                            elinor_post_author();
                            elinor_post_date();
                            elinor_post_comment();
                        }
                        ?>
                    </div>
                <?php endif; ?>
                <?php
                elinor_post_content();
                elinor_get_term_list( 'post_tag' );
                elinor_pagination_post();
                elinor_author_info();
                ?>
                <?php
                /*If comments are open or we have at least one comment, load up the comment template.*/
                if ( comments_open() || get_comments_number() ) comments_template();
                ?>
            </div>
        </div>
    </article>
<?php endwhile;