<?php
/**
 * Name: Blog Grid
 **/
?>
<?php
$page_layout   = elinor_page_layout();
$columns       = elinor_get_option( 'blog_list_column', 2 );
$container     = elinor_theme_option_meta(
    '_custom_metabox_theme_options',
    'main_container',
    'metabox_main_container'
);
$sidebar_width = 0;
$sidebar_space = 0;
$blog_space    = 15;
$crop          = 0.566;
if ( $page_layout['layout'] == 'left' || $page_layout['layout'] == 'right' ) {
    $sidebar_width = elinor_get_option( 'sidebar_width', 400 );
    $sidebar_space = elinor_get_option( 'sidebar_space', 80 );
}
$width  = ( $container - $sidebar_width - $sidebar_space - ( ( $columns - 1 ) * ( $blog_space * 2 ) ) ) / $columns;
$height = $width * $crop;
?>
<div class="blog-content blog-grid response-content equal-container better-height shadow-yes"
     style="--blog-columns: <?php echo esc_attr( $columns ); ?>; --blog-space: <?php echo esc_attr( $blog_space ); ?>px;">
    <?php while ( have_posts() ): the_post(); ?>
        <article <?php post_class( 'blog-item post-item style-04' ); ?>>
            <div class="post-inner">
                <?php elinor_post_thumbnail( $width, $height, true ); ?>
                <div class="post-info">
                    <div class="post-metas">
                        <?php
                        if ( get_post_type() != 'product' ) {
                            elinor_post_author();
                            elinor_post_date();
                        }
                        ?>
                    </div>
                    <div class="equal-elem"><?php elinor_post_title(); ?></div>
                    <?php elinor_post_excerpt( 18 ); ?>
                </div>
            </div>
        </article>
    <?php endwhile; ?>
</div>
<?php elinor_post_pagination(); ?>
