<?php
$page_layout  = elinor_page_layout();
$enable = elinor_get_option( 'enable_related_post' );
$items  = array( 4, 3, 2, 1 );
if ( $page_layout['layout'] != 'full' ){
    $items  = array( 3, 2, 2, 1 );
}
if ( $enable == 1 ) : ?>
    <div class="post-related">
        <h3 class="title"><?php echo esc_html__( 'Related Posts', 'elinor' ); ?></h3>
        <?php echo elinor_do_shortcode( 'ovic_blog', apply_filters( 'elinor_related_post_args', array(
            'style'        => 'style-01',
            'target'       => 'related',
            'orderby'      => 'rand',
            'limit'        => '6',
            'order'        => '',
            'image_width'  => 440,
            'image_height' => 280,
            'carousel'     => array(
                'slidesToShow' => $items[0],
                'slidesMargin' => 0,
                'arrows'       => true,
                'infinite'     => false,
                'responsive'   => array(
                    array(
                        'breakpoint' => 1200,
                        'settings'   => array(
                            'slidesToShow' => $items[1],
                        ),
                    ),
                    array(
                        'breakpoint' => 992,
                        'settings'   => array(
                            'slidesToShow' => $items[2],
                        ),
                    ),
                    array(
                        'breakpoint' => 480,
                        'settings'   => array(
                            'slidesToShow' => $items[3],
                        ),
                    ),
                ),
            ),
        ) ) );
        ?>
    </div>
<?php endif; ?>