<?php
$header_info = elinor_theme_option_meta(
    '_custom_metabox_theme_options',
    'header_info',
    'metabox_header_info'
);
if ( !empty( $header_info ) ) : ?>
    <div class="header-info">
        <div class="inner">
            <?php foreach ( $header_info as $item ) :
                $link = $item['info_link'] ? $item['info_link'] : '#';
                ?>
                <a class="item" href="<?php echo esc_url( $link ); ?>">
                    <?php if ( !empty( $item['info_icon'] ) ): ?>
                        <span class="icon <?php echo esc_attr( $item['info_icon'] ); ?>"></span>
                    <?php endif; ?>
                    <span class="content">
                        <?php if ( !empty( $item['info_title'] ) ): ?>
                            <span class="title"><?php echo esc_html( $item['info_title'] ); ?></span>
                        <?php endif; ?>
                        <?php if ( !empty( $item['info_subtitle'] ) ): ?>
                            <span class="subtitle"><?php echo esc_html( $item['info_subtitle'] ); ?></span>
                        <?php endif; ?>
                    </span>
                </a>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif;