<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Products extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_products';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Products', 'elinor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-woocommerce';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'elinor' ),
            )
        );

        $this->start_controls_tabs( 'tabs_general' );

        $this->start_controls_tab(
            'tab_general',
            [
                'label' => esc_html__( 'Settings', 'elinor' ),
            ]
        );

        $this->add_control(
            'list_style',
            array(
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'List style', 'elinor' ),
                'options' => [
                    'none' => esc_html__( 'None', 'elinor' ),
                    'grid' => esc_html__( 'Bootstrap', 'elinor' ),
                    'owl'  => esc_html__( 'Carousel', 'elinor' ),
                ],
                'default' => 'owl',
            )
        );

        $this->add_control(
            'product_style',
            array(
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'Product style', 'elinor' ),
                'options' => elinor_product_options( 'Shortcode', true ),
                'default' => 'style-01',
            )
        );

        $this->add_responsive_control(
            'thumb_padding',
            [
                'label'      => esc_html__( 'Image Padding', 'elinor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .thumb-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'thumb_hidden',
            [
                'label'        => esc_html__( 'Image hidden on mobile', 'elinor' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'thumb-hidden-mobile-',
                'condition'    => [
                    'product_style' => [
                        'style-01',
                        'style-13'
                    ]
                ],
            ]
        );

        $this->product_size_field();

        $this->add_control(
            'product_border',
            array(
                'type'      => Controls_Manager::SELECT,
                'label'     => esc_html__( 'Product Border', 'elinor' ),
                'options'   => [
                    ''                 => esc_html__( 'None', 'elinor' ),
                    'product-border-1' => esc_html__( 'Border 1', 'elinor' ),
                    'product-border-2' => esc_html__( 'Border 2', 'elinor' ),
                ],
                'default'   => '',
                'condition' => [
                    'product_style' => [
                        'style-01',
                        'style-02',
                        'style-04',
                        'style-05',
                        'style-06',
                        'style-09',
                        'style-10',
                        'style-11',
                        'style-12',
                        'style-13',
                        'style-18'
                    ]
                ],
            )
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'product_border_wrap',
                'label'    => esc_html__( 'Border Type', 'elinor' ),
                'selector' => '{{WRAPPER}} ul.products',
            ]
        );

        $this->add_responsive_control(
            'product_border_wrap_r',
            [
                'label'      => esc_html__( 'Border Radius', 'elinor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} ul.products' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'product_padding_h',
            [
                'label'     => esc_html__( 'Product Padding - horizontal', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} .product-item' => '--product-pd-h: {{VALUE}}px;',
                ],
                'condition' => [
                    'product_style' => [
                        'style-01',
                        'style-02',
                        'style-04',
                        'style-05',
                        'style-06',
                        'style-09',
                        'style-10',
                        'style-11',
                        'style-12',
                        'style-13',
                        'style-18'
                    ]
                ],
            ]
        );

        $this->add_responsive_control(
            'product_padding_v',
            [
                'label'     => esc_html__( 'Product Padding - vertical', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} .product-item' => '--product-pd-v: {{VALUE}}px;',
                ],
                'condition' => [
                    'product_style' => [
                        'style-01',
                        'style-02',
                        'style-04',
                        'style-05',
                        'style-06',
                        'style-09',
                        'style-10',
                        'style-11',
                        'style-12',
                        'style-13',
                        'style-18'
                    ]
                ],
            ]
        );

        $this->add_control(
            'product_bg',
            [
                'label'     => esc_html__( 'Product Background', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ovic-products' => '--product-bg: {{VALUE}};',
                ],
                'condition' => [
                    'product_style' => 'style-12',
                ],
            ]
        );

        $this->add_control(
            'disable_labels',
            [
                'label'        => esc_html__( 'Disable Labels', 'elinor' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'labels-not-',
            ]
        );

        $this->add_control(
            'disable_rating',
            [
                'label'        => esc_html__( 'Disable Rating', 'elinor' ),
                'type'         => Controls_Manager::SWITCHER,
                'prefix_class' => 'rating-not-',
            ]
        );

        $this->add_control(
            'short_text',
            [
                'label'        => esc_html__( 'Short Title', 'elinor' ),
                'prefix_class' => 'short-text-',
                'type'         => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'overflow_visible',
            [
                'label' => esc_html__( 'Content Overflow', 'elinor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_products',
            [
                'label' => esc_html__( 'Products', 'elinor' ),
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label'   => esc_html__( 'Pagination', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'none'      => esc_html__( 'None', 'elinor' ),
                    'view_all'  => esc_html__( 'View all', 'elinor' ),
                    'load_more' => esc_html__( 'Load More', 'elinor' ),
                    'infinite'  => esc_html__( 'Infinite Scrolling', 'elinor' ),
                ],
                'default' => 'none',
            ]
        );

        $this->add_control(
            'link',
            [
                'type'        => Controls_Manager::URL,
                'label'       => esc_html__( 'Link', 'elinor' ),
                'placeholder' => esc_html__( 'https://your-link.com', 'elinor' ),
                'default'     => [
                    'url' => '#',
                ],
                'condition'   => [
                    'pagination' => 'view_all',
                ],
            ]
        );

        $this->add_control(
            'text_button',
            [
                'type'      => Controls_Manager::TEXT,
                'label'     => esc_html__( 'Text button', 'elinor' ),
                'default'   => 'VIEW ALL',
                'condition' => [
                    'pagination' => 'view_all',
                ],
            ]
        );

        $this->add_control(
            'target',
            [
                'label'   => esc_html__( 'Target', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'recent_products'       => esc_html__( 'Recent Products', 'elinor' ),
                    'featured_products'     => esc_html__( 'Feature Products', 'elinor' ),
                    'sale_products'         => esc_html__( 'Sale Products', 'elinor' ),
                    'best_selling_products' => esc_html__( 'Best Selling Products', 'elinor' ),
                    'top_rated_products'    => esc_html__( 'Top Rated Products', 'elinor' ),
                    'products'              => esc_html__( 'Products', 'elinor' ),
                    'product_category'      => esc_html__( 'Products Category', 'elinor' ),
                    'product_brand'         => esc_html__( 'Products Brand', 'elinor' ),
                    'related_products'      => esc_html__( 'Products Related', 'elinor' ),
                ],
                'default' => 'recent_products',
            ]
        );

        if ( class_exists( 'ElementorPro\Modules\QueryControl\Module' ) ) {
            $this->add_control(
                'ids',
                [
                    'label'        => esc_html__( 'Search Product', 'elinor' ),
                    'type'         => ElementorPro\Modules\QueryControl\Module::QUERY_CONTROL_ID,
                    'options'      => [],
                    'label_block'  => true,
                    'multiple'     => true,
                    'autocomplete' => [
                        'object' => ElementorPro\Modules\QueryControl\Module::QUERY_OBJECT_POST,
                        'query'  => [
                            'post_type' => 'product'
                        ],
                    ],
                    'condition'    => [
                        'target' => 'products'
                    ],
                    'export'       => false,
                ]
            );
        } else {
            $this->add_control(
                'ids',
                [
                    'label'       => esc_html__( 'Product', 'elinor' ),
                    'type'        => Controls_Manager::TEXT,
                    'description' => esc_html__( 'Product ids', 'elinor' ),
                    'placeholder' => '1,2,3',
                    'label_block' => true,
                    'condition'   => [
                        'target' => 'products'
                    ],
                ]
            );
        }

        $this->add_control(
            'category',
            [
                'label'       => esc_html__( 'Products Category', 'elinor' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy( [
                    'hide_empty' => true,
                    'taxonomy'   => 'product_cat',
                ] ),
                'label_block' => true,
                'condition'   => [
                    'target!' => 'products'
                ],
            ]
        );

        $this->add_control(
            'category_brand',
            [
                'label'       => esc_html__( 'Products Brand', 'elinor' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy( [
                    'hide_empty' => true,
                    'taxonomy'   => 'product_brand',
                ] ),
                'label_block' => true,
                'condition'   => [
                    'target!' => 'products'
                ],
            ]
        );

        $this->add_control(
            'limit',
            [
                'label'       => esc_html__( 'Limit', 'elinor' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 6,
                'placeholder' => 6,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'   => esc_html__( 'Order by', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''              => esc_html__( 'None', 'elinor' ),
                    'date'          => esc_html__( 'Date', 'elinor' ),
                    'ID'            => esc_html__( 'ID', 'elinor' ),
                    'author'        => esc_html__( 'Author', 'elinor' ),
                    'title'         => esc_html__( 'Title', 'elinor' ),
                    'modified'      => esc_html__( 'Modified', 'elinor' ),
                    'rand'          => esc_html__( 'Random', 'elinor' ),
                    'comment_count' => esc_html__( 'Comment count', 'elinor' ),
                    'menu_order'    => esc_html__( 'Menu order', 'elinor' ),
                    'price'         => esc_html__( 'Price: low to high', 'elinor' ),
                    'price-desc'    => esc_html__( 'Price: high to low', 'elinor' ),
                    'rating'        => esc_html__( 'Average Rating', 'elinor' ),
                    'popularity'    => esc_html__( 'Popularity', 'elinor' ),
                    'post__in'      => esc_html__( 'Post In', 'elinor' ),
                    'most-viewed'   => esc_html__( 'Most Viewed', 'elinor' ),
                ],
                'default' => 'date',
            ]
        );

        $this->add_control(
            'order',
            [
                'label'   => esc_html__( 'Sort order', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    ''     => esc_html__( 'None', 'elinor' ),
                    'DESC' => esc_html__( 'Descending', 'elinor' ),
                    'ASC'  => esc_html__( 'Ascending', 'elinor' ),
                ],
                'default' => 'DESC',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'carousel_section',
            [
                'tab'       => Controls_Manager::TAB_SETTINGS,
                'label'     => esc_html__( 'Carousel settings', 'elinor' ),
                'condition' => [
                    'list_style' => 'owl',
                ],
            ]
        );

        $this->add_control(
            'slide_nav',
            [
                'label'   => esc_html__( 'Nav style', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => elinor_nav_style(),
                'default' => '',
            ]
        );

        $this->add_control(
            'slide_dot',
            [
                'label'   => esc_html__( 'Dot style', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => elinor_dot_style(),
                'default' => '',
            ]
        );

        $this->carousel_settings( false );

        $this->end_controls_section();

        $this->bootstrap_settings( [
            'tab'       => Controls_Manager::TAB_SETTINGS,
            'label'     => esc_html__( 'Bootstrap settings', 'elinor' ),
            'condition' => [
                'list_style' => 'grid',
            ],
        ] );
    }

    protected function render()
    {
        $settings        = $this->get_settings_for_display();
        $settings['_id'] = substr( $this->get_id_int(), 0, 3 );

        echo ovic_do_shortcode( $this->get_name(), $settings );
    }
}