<?php
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if ( !class_exists( 'Widget_Ovic_Newsletter' ) ) {
    class Widget_Ovic_Newsletter extends OVIC_Widget
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
            $this->widget_cssclass = 'ovic-newsletter';
            $this->widget_id       = 'ovic_newsletter';
            $this->widget_name     = esc_html__( 'Ovic: Newsletter', 'elinor' );
            $this->settings        = array(
                'title'       => array(
                    'type'  => 'text',
                    'title' => esc_html__( 'Title', 'elinor' ),
                ),
                'subtitle'    => array(
                    'type'  => 'textarea',
                    'title' => esc_html__( 'Subtitle', 'elinor' ),
                ),
                'placeholder' => array(
                    'type'  => 'text',
                    'title' => esc_html__( 'Input Placeholder', 'elinor' ),
                ),
                'button'      => array(
                    'type'  => 'text',
                    'title' => esc_html__( 'Button', 'elinor' ),
                ),
            );

            parent::__construct();
        }

        /**
         * Output widget.
         *
         * @param  array $args
         * @param  array $instance
         *
         * @see WP_Widget
         *
         */
        public function widget( $args, $instance )
        {
            $atts          = $instance;
            $atts['title'] = '';

            $this->widget_start( $args, $instance );

            unset( $instance['title'] );

            echo ovic_do_shortcode( 'ovic_newsletter', $atts );

            $this->widget_end( $args );
        }
    }
}