<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Menu extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_menu';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Menu', 'elinor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-nav-menu';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'elinor' ),
            )
        );

        $this->add_control(
            'layout',
            [
                'type'         => Controls_Manager::SELECT,
                'label'        => esc_html__( 'Layout', 'elinor' ),
                'options'      => [
                    ''           => esc_html__( 'Vertical', 'elinor' ),
                    'horizontal' => esc_html__( 'Horizontal', 'elinor' ),
                ],
                'prefix_class' => 'yes-',
                'default'      => '',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label'     => esc_html__( 'Columns', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 2,
                'selectors' => [
                    '{{WRAPPER}} .widget > ul > li'     => 'width: calc((100% / {{VALUE}}) - (var(--menu-space,0px) * 2));',
                    '{{WRAPPER}} .widget > * > ul > li' => 'width: calc((100% / {{VALUE}}) - (var(--menu-space,0px) * 2));',
                ],
                'condition' => [
                    'layout' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'columns_space',
            [
                'label'     => esc_html__( 'Columns Space', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'default'   => 5,
                'selectors' => [
                    '{{WRAPPER}} ul'                    => '--menu-space: {{VALUE}}px;',
                    '{{WRAPPER}} .widget > ul'          => 'margin-left: -{{VALUE}}px;margin-right: -{{VALUE}}px;',
                    '{{WRAPPER}} .widget > * > ul'      => 'margin-left: -{{VALUE}}px;margin-right: -{{VALUE}}px;',
                    '{{WRAPPER}} .widget > ul > li'     => 'margin-left: {{VALUE}}px;margin-right: {{VALUE}}px;',
                    '{{WRAPPER}} .widget > * > ul > li' => 'margin-left: {{VALUE}}px;margin-right: {{VALUE}}px;',
                ],
                'condition' => [
                    'layout'   => '',
                    'columns!' => '',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'label'       => esc_html__( 'Title', 'elinor' ),
            ]
        );

        $this->add_control(
            'delimiter',
            [
                'label_block' => true,
                'type'        => Controls_Manager::TEXT,
                'label'       => esc_html__( 'Delimiter', 'elinor' ),
                'selectors'   => [
                    '{{WRAPPER}} .ovic-custommenu' => '--menu-delimiter: "{{VALUE}}";',
                ],
                'condition'   => [
                    'layout' => 'horizontal',
                ],
            ]
        );

        $this->add_control(
            'delimiter_opacity',
            [
                'label'     => esc_html__( 'Delimiter Opacity', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ovic-custommenu' => '--menu-delimiter-o: {{VALUE}};',
                ],
                'condition' => [
                    'layout' => 'horizontal',
                ],
            ]
        );

        $locations = array();
        $menus     = get_terms( 'nav_menu', array( 'hide_empty' => true ) );
        if ( !empty( $menus ) ) {
            foreach ( $menus as $menu ) {
                $locations[ $menu->slug ] = $menu->name;
            }
        }

        $this->add_control(
            'nav_menu',
            [
                'label_block' => true,
                'options'     => $locations,
                'type'        => Controls_Manager::SELECT2,
                'label'       => esc_html__( 'Menu', 'elinor' ),
                'description' => esc_html__( 'Select menu to display.', 'elinor' ),
            ]
        );

        $this->add_control(
            'list_style',
            [
                'type'         => Controls_Manager::SELECT,
                'label'        => esc_html__( 'List Style', 'elinor' ),
                'options'      => [
                    ''      => esc_html__( 'None', 'elinor' ),
                    'dot'   => esc_html__( 'Dot', 'elinor' ),
                    'arrow' => esc_html__( 'Arrow', 'elinor' ),
                    'char'  => esc_html__( 'Char', 'elinor' ),
                ],
                'prefix_class' => 'list-',
                'default'      => '',
            ]
        );

        $this->add_control(
            'list_char',
            [
                'type'      => Controls_Manager::TEXT,
                'label'     => esc_html__( 'Char', 'elinor' ),
                'selectors' => [
                    '{{WRAPPER}} .ovic-custommenu' => '--menu-char: "{{VALUE}}";',
                ],
                'condition' => [
                    'list_style' => 'char',
                ],
            ]
        );

        $this->add_control(
            'dropdown',
            [
                'type'  => Controls_Manager::SWITCHER,
                'label' => esc_html__( 'Submenu Dropdown', 'elinor' ),
            ]
        );

        $this->add_control(
            'toggle',
            [
                'type'  => Controls_Manager::SWITCHER,
                'label' => esc_html__( 'Toggle Items on Mobile', 'elinor' ),
            ]
        );

        $this->add_control(
            'toggle_color',
            [
                'label'       => esc_html__( 'Toggle Icon Color', 'elinor' ),
                'description' => esc_html__( 'Default is Title Color', 'elinor' ),
                'type'        => Controls_Manager::COLOR,
                'selectors'   => [
                    '{{WRAPPER}} .widget-title .text::after' => 'color: {{VALUE}};',
                ],
                'condition'   => [
                    'toggle' => 'yes',
                ],
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'        => esc_html__( 'Alignment', 'elinor' ),
                'type'         => Controls_Manager::CHOOSE,
                'options'      => [
                    'left'   => [
                        'title' => esc_html__( 'Left', 'elinor' ),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elinor' ),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'  => [
                        'title' => esc_html__( 'Right', 'elinor' ),
                        'icon'  => 'eicon-text-align-right',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'default'      => '',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'title_section',
            [
                'label' => esc_html__( 'Title', 'elinor' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'elinor' ),
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .widget-title',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__( 'Color', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .widget-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label'     => esc_html__( 'Margin', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} .widget-title' => 'margin-bottom: {{VALUE}}px;',
                ],
                'condition' => [
                    'layout!' => 'horizontal',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_margin_h',
            [
                'label'     => esc_html__( 'Margin', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'selectors' => [
                    '{{WRAPPER}} .widget-title' => 'margin-inline-end: {{VALUE}}px;',
                ],
                'condition' => [
                    'layout' => 'horizontal',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_section',
            [
                'label' => esc_html__( 'Item', 'elinor' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label'    => esc_html__( 'Typography', 'elinor' ),
                'name'     => 'item_typography',
                'selector' => '{{WRAPPER}} .ovic-custommenu',
            ]
        );

        $this->add_control(
            'item_color',
            [
                'label'     => esc_html__( 'Color', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ovic-custommenu' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_space',
            [
                'label'     => esc_html__( 'Item Space', 'elinor' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'selectors' => [
                    '{{WRAPPER}} .ovic-custommenu' => '--item-space: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'item_color_h',
            [
                'label'     => esc_html__( 'Color Hover', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ovic-custommenu .menu-item > a' => '--current-item: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        echo ovic_do_shortcode( $this->get_name(), $settings );
    }
}