<?php
if (!defined('ABSPATH')) {
    die('-1');
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Imgbox"
 * @version 1.0.0
 */
class Shortcode_Ovic_Imgbox extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode = 'ovic_imgbox';
    public $default   = array();

    public function content($atts, $content = null)
    {
        $css_class = $this->main_class(
            $atts,
            array(
                'ovic-imgbox'
            )
        );

        ob_start();
        ?>
        <div class="<?php echo esc_attr($css_class); ?>">
            <?php if (!empty($atts['imgbox'])): ?>
                <div class="img-list owl-slick" data-slick={"slidesToShow":1,"infinite":true,"speed":800,"autoplay":true,"autoplaySpeed":5000,"arrows":true,"slidesMargin":40,"dots":false,"responsive":[{"breakpoint":1500,"settings":{"slidesMargin":30}},{"breakpoint":1200,"settings":{"slidesMargin":20}},{"breakpoint":768,"settings":{"slidesMargin":10}}]}
                     style="--show:1;--margin:40px;--margin-laptop:30px;--margin-ipad:20px;--margin-landscape:10px">
                    <?php foreach ($atts['imgbox'] as $item) : ?>
                        <?php
                        $item['link']['url'] = apply_filters('ovic_shortcode_vc_link', $item['link']['url']);
                        $link                = $this->add_link_attributes($item['link'], true);
                        ?>
                        <div class="item">
                            <?php if (!empty($item['selected_image']['id'])): ?>
                                <a <?php echo esc_attr($link) ?> class="image <?php echo esc_attr($item['image_effect']) ?>">
                                    <?php echo wp_get_attachment_image($item['selected_image']['id'], 'full'); ?>
                                </a>
                            <?php endif; ?>
                            <div class="content">
                                <?php if (!empty($item['title'])): ?>
                                    <h3 class="title"><?php echo wp_specialchars_decode($item['title']); ?></h3>
                                <?php endif; ?>
                                <?php if (!empty($item['button'])): ?>
                                    <a <?php echo esc_attr($link) ?> class="button"><?php echo wp_specialchars_decode($item['button']); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}