<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Countdown"
 * @version 1.0.0
 */
class Shortcode_Ovic_Countdown extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode = 'ovic_countdown';
    public $default   = array(
        'style'     => 'style-01',
        'days_text' => '',
        'hrs_text'  => '',
        'mins_text' => '',
        'secs_text' => '',
        'text_posi' => '',
    );

    public function get_params( $params, $atts )
    {
        if ( $atts['format'] && $format = explode( ',', $atts['format'] ) ) {
            $format = (array)$format;
            foreach ( $params as $key => $param ) {
                if ( !in_array( $key, $format ) ) {
                    unset( $params[ $key ] );
                }
            }
        }

        return $params;
    }

    public function content( $atts, $content = null )
    {
        $classes = array(
            'ovic-countdown',
            $atts['style'],
            $atts['text_posi']
        );
        if ( !empty( $atts['position'] ) ) {
            $classes[] = 'position-' . $atts['position'];
        }
        if ( !empty( $atts['date'] ) ) {
            $atts['date'] = apply_filters( 'ovic_change_datetime_countdown', $atts['date'], 0 );
        }
        $css_class = $this->main_class( $atts, $classes );

        ob_start();
        ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <?php if ( !empty( $atts['date'] ) ):
                $params = array(
                    'days_text' => $atts['days_text'],
                    'hrs_text'  => $atts['hrs_text'],
                    'mins_text' => $atts['mins_text'],
                    'secs_text' => $atts['secs_text'],
                );
                wp_enqueue_script( 'elinor-countdown' );
                ?>
                <div class="elinor-countdown-wrapper">
                    <div class="elinor-countdown"
                         data-datetime="<?php echo esc_attr( $atts['date'] ); ?>"
                         data-params="<?php echo esc_attr( wp_json_encode( $params ) ) ?>">
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php

        return ob_get_clean();
    }
}