<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Category"
 * @version 1.0.0
 */
class Shortcode_Ovic_Category extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode      = 'ovic_category';
    public $is_woocommerce = true;
    public $default        = array(
        'style' => 'style-01',
    );

    public function content( $atts, $content = null )
    {
        $css_class = $this->main_class( $atts, array(
            'ovic-category',
            $atts['style']
        ) );

        ob_start(); ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <?php if ( !empty( $atts['category'] ) ):
                $term = get_term_by( 'slug', $atts['category'], 'product_cat' );
                if ( !is_wp_error( $term ) && !empty( $term ) ): ?>
                    <?php
                    if ( !empty( $atts['link']['url'] ) ) {
                        $link = $atts['link']['url'];
                    } else {
                        $link = get_term_link( $term->term_id, 'product_cat' );
                    }
                    $link = apply_filters( 'ovic_shortcode_vc_link', $link );
                    if ( !empty( $atts['image']['id'] ) ) {
                        $image = $atts['image']['id'];
                    } else {
                        $image = get_term_meta( $term->term_id, 'thumbnail_id', true );
                    }
                    if ( !empty( $atts['title'] ) ) {
                        $title = $atts['title'];
                    } else {
                        $title = $term->name;
                    }
                    if ( !empty( $atts['desc'] ) ) {
                        $desc = $atts['desc'];
                    } else {
                        $desc = $term->description;
                    }
                    ?>
                    <a href="<?php echo esc_url( $link ); ?>" class="link <?php if ( !empty($atts['image_effect']) ) echo esc_attr( $atts['image_effect'] ); ?>">
                        <?php if ( !empty( $image ) && $atts['style'] != 'style-03' ): ?>
                            <span class="thumb <?php if ( $atts['style'] != 'style-04' ) echo esc_attr( $atts['image_effect'] ); ?>"><?php echo wp_get_attachment_image( $image, 'full' ); ?></span>
                        <?php endif; ?>
                        <?php if ( $atts['style'] == 'style-04' || $atts['style'] == 'style-06' ): ?>
                            <span class="content">
                                <?php if ( !empty( $title ) ): ?>
                                    <span class="title"><?php echo wp_specialchars_decode( $title ); ?></span>
                                <?php endif; ?>
                                <?php if ( $atts['count'] == 'yes' ): ?>
                                    <span class="count">
                                    <?php if ( $term->count == 1 ) {
                                        echo esc_html( $term->count ) . esc_html__( ' product', 'elinor' );
                                    } else {
                                        echo esc_html( $term->count ) . esc_html__( ' products', 'elinor' );
                                    } ?>
                                </span>
                                <?php endif; ?>
                                <?php if ( !empty( $desc ) && $atts['style'] = 'style-04' ): ?>
                                    <span class="desc" style="<?php if ( !empty( $atts['desc_line'] ) ) echo esc_attr( '--desc-line: ' . $atts['desc_line'] . ';' ); ?>">
                                        <?php echo wp_specialchars_decode( $desc ); ?>
                                        <span class="button-link"><?php echo esc_html__( 'Shop now', 'elinor' ); ?></span>
                                    </span>
                                <?php endif; ?>
                            </span>
                        <?php else: ?>
                            <?php if ( !empty( $title ) ): ?>
                                <span class="title"><?php echo wp_specialchars_decode( $title ); ?></span>
                            <?php endif; ?>
                            <?php if ( $atts['count'] == 'yes' ): ?>
                                <span class="count">
                                    <?php if ( $term->count == 1 ) {
                                        echo esc_html( $term->count ) . esc_html__( ' product', 'elinor' );
                                    } else {
                                        echo esc_html( $term->count ) . esc_html__( ' products', 'elinor' );
                                    } ?>
                                </span>
                            <?php endif; ?>
                            <?php if ( !empty( $image ) && $atts['style'] == 'style-03' ): ?>
                                <span class="thumb"><?php echo wp_get_attachment_image( $image, 'full' ); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </a>
                <?php endif; ?>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}