<?php
if ( !defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Brand"
 * @version 1.0.0
 */
class Shortcode_Ovic_Brand extends Ovic_Addon_Shortcode
{
    /**
     * Shortcode name.
     *
     * @var  string
     */
    public $shortcode      = 'ovic_brand';
    public $is_woocommerce = true;
    public $default        = array(
        'style'             => 'style-01',
        'slides_rows_space' => '',
        'slide_nav'         => '',
        'slide_dot'         => '',
    );

    public function content( $atts, $content = null )
    {
        $css_class             = $this->main_class( $atts, array(
            'ovic-brand',
            $atts['slides_rows_space'],
            $atts['slide_nav'],
            $atts['slide_dot']
        ) );
        $atts['link']['class'] = 'button';
        $atts['link']['url']   = apply_filters( 'ovic_shortcode_vc_link', $atts['link']['url'] );
        $link                  = $this->add_link_attributes( $atts['link'], true );
        ob_start(); ?>
        <div class="<?php echo esc_attr( $css_class ); ?>">
            <?php
            if ( !empty( $atts['brands'] ) ):
                $owl_settings = $this->generate_carousel( $atts ); ?>
                <div class="owl-slick" <?php echo esc_attr( $owl_settings ); ?>>
                    <?php foreach ( $atts['brands'] as $brand ) : ?>
                        <?php
                        $term = get_term_by( 'slug', $brand, 'product_brand' );
                        if ( !is_wp_error( $term ) && !empty( $term ) ): ?>
                            <?php
                            $term_link    = get_term_link( $term->term_id, 'product_brand' );
                            $thumbnail_id = get_term_meta( $term->term_id, 'logo_id', true );
                            ?>
                            <div class="item">
                                <a href="<?php echo esc_url( $term_link ); ?>" class="link <?php echo esc_attr( $atts['image_effect'] ); ?>">
                                    <span class="thumb">
                                        <span class="image">
                                            <?php if ( $atts['show_name'] == 'yes' && !empty( $term->name ) ): ?>
                                                <span class="name"><?php echo esc_html( $term->name ); ?></span>
                                            <?php endif; ?>
                                            <?php echo wp_get_attachment_image( $thumbnail_id, 'full' ); ?>
                                            <?php if ( $atts['show_desc'] == 'yes' && !empty( $term->description ) ): ?>
                                                <span class="desc"><?php echo esc_html( $term->description ); ?></span>
                                            <?php endif; ?>
                                        </span>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            <?php endif;
            ?>
            <?php if ( !empty( $atts['button'] ) ) : ?>
                <div class="button-wrap">
                    <a <?php echo esc_attr( $link ); ?>>
                        <?php echo esc_html( $atts['button'] ); ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }
}