<?php
if ( !defined( 'ABSPATH' ) ) {
    exit();
}

use Elementor\Core\Schemes;
use Elementor\Controls_Manager as Controls_Manager;

class Elementor_Ovic_Brand extends Ovic_Widget_Elementor
{
    /**
     * Get widget name.
     *
     * Retrieve image widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'ovic_brand';
    }

    /**
     * Get widget title.
     *
     * Retrieve image widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__( 'Brand', 'elinor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve image widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-review';
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'general_section',
            array(
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => esc_html__( 'General', 'elinor' ),
            )
        );

        $this->add_control(
            'brands',
            [
                'label'       => esc_html__( 'Products Brand', 'elinor' ),
                'type'        => Controls_Manager::SELECT2,
                'options'     => $this->get_taxonomy( [
                    'hide_empty' => false,
                    'taxonomy'   => 'product_brand',
                ] ),
                'multiple'    => true,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'show_name',
            [
                'label' => esc_html__( 'Show name', 'elinor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'show_desc',
            [
                'label' => esc_html__( 'Show description', 'elinor' ),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'button',
            [
                'type'  => Controls_Manager::TEXT,
                'label' => esc_html__( 'Button', 'elinor' ),
            ]
        );

        $this->add_control(
            'link',
            [
                'type'  => Controls_Manager::URL,
                'label' => esc_html__( 'Button link', 'elinor' ),
            ]
        );

        $this->add_responsive_control(
            'height',
            [
                'label'     => esc_html__( 'Height', 'elinor' ),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .image' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'space',
            [
                'label'      => esc_html__( 'Padding', 'elinor' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'full_width',
            [
                'label'     => esc_html__( 'Item Full Width', 'elinor' ),
                'type'      => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .thumb' => 'width: 100%;',
                ],
            ]
        );

        $this->start_controls_tabs( 'tabs_general' );

        $this->start_controls_tab(
            'tab_normal',
            [
                'label' => esc_html__( 'Normal', 'elinor' ),
            ]
        );

        $this->add_control(
            'background',
            [
                'label'     => esc_html__( 'Background', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .image' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'border',
                'label'    => esc_html__( 'Border', 'elinor' ),
                'selector' => '{{WRAPPER}} .image',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'elinor' ),
                'selector' => '{{WRAPPER}} .image',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_hover',
            [
                'label' => esc_html__( 'Hover', 'elinor' ),
            ]
        );

        $this->add_control(
            'hover_background',
            [
                'label'     => esc_html__( 'Background', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .link:hover .image' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'hover_border',
            [
                'label'     => esc_html__( 'Border', 'elinor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .link:hover .image' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'hover_box_shadow',
                'label'    => esc_html__( 'Box Shadow', 'elinor' ),
                'selector' => '{{WRAPPER}} .link:hover .image',
            ]
        );

        $this->add_control(
            'image_effect',
            [
                'type'    => Controls_Manager::SELECT,
                'label'   => esc_html__( 'Hover Effect', 'elinor' ),
                'options' => elinor_effect_style(),
                'default' => '',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'carousel_section',
            [
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'label' => esc_html__( 'Carousel settings', 'elinor' ),
            ]
        );

        $this->add_control(
            'slide_nav',
            [
                'label'   => esc_html__( 'Nav style', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => elinor_nav_style(),
                'default' => '',
            ]
        );

        $this->add_control(
            'slide_dot',
            [
                'label'   => esc_html__( 'Dot style', 'elinor' ),
                'type'    => Controls_Manager::SELECT,
                'options' => elinor_dot_style(),
                'default' => '',
            ]
        );

        $this->carousel_settings( false );
    }
}