<?php if ( !defined( 'ABSPATH' ) ) {
    die;
} // Cannot access pages directly.
/*==========================================================================
THEME BOX OPTIONS
===========================================================================*/
if ( !function_exists( 'elinor_theme_options' ) && class_exists( 'OVIC_Options' ) ) {
    function elinor_theme_options()
    {
        $vertical_menu = 'style-01,style-03,style-04,style-05,style-08';
        $options       = array();
        // -----------------------------------------
        // Theme Options              -
        // -----------------------------------------
        $options['general_main'] = array(
            'name'     => 'general_main',
            'icon'     => 'fa fa-wordpress',
            'title'    => esc_html__( 'General', 'elinor' ),
            'sections' => array(
                array(
                    'title'  => esc_html__( 'General', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'    => 'logo',
                            'type'  => 'image',
                            'title' => esc_html__( 'Logo', 'elinor' ),
                            'desc'  => esc_html__( 'Setting Logo For Site', 'elinor' ),
                        ),
                        array(
                            'id'      => 'default_color',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#3E445A',
                            'title'   => esc_html__( 'Default Color', 'elinor' ),
                        ),
                        array(
                            'id'      => 'main_color',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#219653',
                            'title'   => esc_html__( 'Main Color', 'elinor' ),
                        ),
                        array(
                            'id'      => 'main_color_t',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#fff',
                            'title'   => esc_html__( 'Main Color - Text Inside', 'elinor' ),
                            'desc'    => esc_html__( 'Text inside "Boxes has background main color" will has this color', 'elinor' ),
                        ),
                        array(
                            'id'      => 'main_color_2',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#FFB800',
                            'title'   => esc_html__( 'Main Color 2', 'elinor' ),
                        ),
                        array(
                            'id'      => 'main_color_2_t',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#18191B',
                            'title'   => esc_html__( 'Main Color 2 - Text Inside', 'elinor' ),
                            'desc'    => esc_html__( 'Text inside "Boxes has background main color 2" will has this color', 'elinor' ),
                        ),
                        array(
                            'id'      => 'main_color_3',
                            'type'    => 'color',
                            'rgba'    => true,
                            'default' => '#E80E29',
                            'title'   => esc_html__( 'Main Color 3', 'elinor' ),
                        ),
                        array(
                            'id'      => 'main_container',
                            'type'    => 'slider',
                            'title'   => esc_html__( 'Main Container', 'elinor' ),
                            'min'     => 1140,
                            'max'     => 1470,
                            'step'    => 10,
                            'unit'    => esc_html__( 'px', 'elinor' ),
                            'default' => 1400,
                        ),
                        array(
                            'id'      => 'main_fw',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Main Font Weight', 'elinor' ),
                            'options' => array(
                                400 => esc_html__( 'Regular', 'elinor' ),
                                500 => esc_html__( 'Medium', 'elinor' ),
                                600 => esc_html__( 'Semi-bold', 'elinor' ),
                                700 => esc_html__( 'Bold', 'elinor' ),
                            ),
                            'default' => 500,
                        ),
                        array(
                            'id'      => 'main_bora',
                            'type'    => 'number',
                            'title'   => esc_html__( 'Main Border Radius', 'elinor' ),
                            'min'     => 0,
                            'max'     => 1000,
                            'unit'    => esc_html__( 'px', 'elinor' ),
                            'default' => 90,
                        ),
                        array(
                            'id'    => 'main_bora_button',
                            'type'  => 'text',
                            'title' => esc_html__( 'Button Border Radius', 'elinor' ),
                            'desc'  =>
                                '<ul>
                                    <li>' . esc_html__( 'Example:', 'elinor' ) . '</li>
                                    <li>' . esc_html__( '+ top-left <space> top-right <space> bottom-right <space> bottom-left:', 'elinor' ) . '</li>
                                    <li><b>' . esc_html__( '20px 20px 20px 20px', 'elinor' ) . '</b></li>
                                    <li>' . esc_html__( '+ top-left-bottom-right <space> top-right-bottom-left:', 'elinor' ) . '</li>
                                    <li><b>' . esc_html__( '20px 0', 'elinor' ) . '</b></li>
                                    <li>' . esc_html__( '+ all:', 'elinor' ) . '</li>
                                    <li><b>' . esc_html__( '20px', 'elinor' ) . '</b></li>
                                </ul>',
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Enable/Disable', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'    => 'disable_equal',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Disable Equal Height', 'elinor' ),
                        ),
                        array(
                            'id'    => 'enable_cache_option',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Cache Options', 'elinor' ),
                        ),
                        array(
                            'id'    => 'enable_ajax_comment',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Nav Ajax Comment', 'elinor' ),
                        ),
                        array(
                            'id'      => 'enable_backtotop',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Enable Back To Top Button', 'elinor' ),
                            'default' => 1,
                        ),
                        array(
                            'id'      => 'enable_ovic_rtl',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Enable Ovic RTL', 'elinor' ),
                            'desc'    =>
                                '<ul>
                                    <li>' . esc_html__( 'If RTL Language:', 'elinor' ) . '</li>
                                    <li>' . esc_html__( '- Sections has class "rtl-bg" will be has rtl background', 'elinor' ) . '</li>
                                    <li>' . esc_html__( '- Align has direction left/right will be start/end', 'elinor' ) . '</li>
                                </ul>',
                            'default' => 1,
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Sidebar Settings', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'      => 'sidebar_width',
                            'type'    => 'slider',
                            'title'   => esc_html__( 'Sidebar Width', 'elinor' ),
                            'min'     => 200,
                            'max'     => 500,
                            'step'    => 1,
                            'unit'    => esc_html__( 'px', 'elinor' ),
                            'default' => 400,
                        ),
                        array(
                            'id'      => 'sidebar_space',
                            'type'    => 'spinner',
                            'title'   => esc_html__( 'Sidebar Space', 'elinor' ),
                            'min'     => 0,
                            'max'     => 200,
                            'step'    => 1,
                            'unit'    => 'px',
                            'default' => 78,
                        ),
                        array(
                            'id'      => 'sidebar_width_tablet',
                            'type'    => 'slider',
                            'title'   => esc_html__( 'Sidebar Width Tablet', 'elinor' ),
                            'desc'    => esc_html__( 'resolution < 1500px', 'elinor' ),
                            'min'     => 200,
                            'max'     => 500,
                            'step'    => 1,
                            'unit'    => esc_html__( 'px', 'elinor' ),
                            'default' => 300,
                        ),
                        array(
                            'id'      => 'sidebar_space_tablet',
                            'type'    => 'spinner',
                            'title'   => esc_html__( 'Sidebar Space Tablet', 'elinor' ),
                            'desc'    => esc_html__( 'resolution < 1500px', 'elinor' ),
                            'min'     => 0,
                            'max'     => 200,
                            'step'    => 1,
                            'unit'    => 'px',
                            'default' => 30,
                        ),
                        array(
                            'id'    => 'sticky_sidebar',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Sticky Sidebar', 'elinor' ),
                        ),
                        array(
                            'id'           => 'multi_sidebar',
                            'type'         => 'repeater',
                            'button_title' => esc_html__( 'Add Sidebar', 'elinor' ),
                            'title'        => esc_html__( 'Multi Sidebar', 'elinor' ),
                            'fields'       => array(
                                array(
                                    'id'    => 'add_sidebar',
                                    'type'  => 'text',
                                    'title' => esc_html__( 'Name Sidebar', 'elinor' ),
                                ),
                            ),
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Popup Newsletter', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'    => 'enable_popup',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Popup', 'elinor' ),
                        ),
                        array(
                            'id'         => 'popup_page',
                            'type'       => 'select',
                            'title'      => esc_html__( 'Popup Page', 'elinor' ),
                            'options'    => 'page',
                            'multiple'   => true,
                            'chosen'     => true,
                            'query_args' => array(
                                'posts_per_page' => -1,
                            ),
                            'desc'       => esc_html__( 'The page popup will be show.', 'elinor' ),
                        ),
                        array(
                            'id'      => 'popup_effect',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Popup Effect', 'elinor' ),
                            'options' => array(
                                'mfp-zoom-in'         => esc_html__( 'Zoom In', 'elinor' ),
                                'mfp-newspaper'       => esc_html__( 'Newspaper', 'elinor' ),
                                'mfp-move-horizontal' => esc_html__( 'Horizontal Move', 'elinor' ),
                                'mfp-move-from-top'   => esc_html__( 'Move From Top', 'elinor' ),
                                'mfp-3d-unfold'       => esc_html__( '3D Unfold', 'elinor' ),
                                'mfp-zoom-out'        => esc_html__( 'Zoom Out', 'elinor' ),
                            ),
                            'default' => 'mfp-zoom-in',
                        ),
                        array(
                            'id'    => 'popup_bg',
                            'type'  => 'image',
                            'title' => esc_html__( 'Background', 'elinor' ),
                        ),
                        array(
                            'id'    => 'popup_img',
                            'type'  => 'image',
                            'title' => esc_html__( 'Image', 'elinor' ),
                        ),
                        array(
                            'id'    => 'popup_text_1',
                            'type'  => 'text',
                            'title' => esc_html__( 'Text 1', 'elinor' ),
                        ),
                        array(
                            'id'    => 'popup_text_2',
                            'type'  => 'text',
                            'title' => esc_html__( 'Text 2', 'elinor' ),
                        ),
                        array(
                            'id'    => 'popup_text_3',
                            'type'  => 'text',
                            'title' => esc_html__( 'Text 3', 'elinor' ),
                        ),
                        array(
                            'id'    => 'input_placeholder',
                            'type'  => 'text',
                            'title' => esc_html__( 'Input Placeholder', 'elinor' ),
                        ),
                        array(
                            'id'    => 'popup_button',
                            'type'  => 'text',
                            'title' => esc_html__( 'Button', 'elinor' ),
                        ),
                        array(
                            'id'    => 'popup_text_4',
                            'type'  => 'text',
                            'title' => esc_html__( 'Text 4', 'elinor' ),
                        ),
                        array(
                            'id'      => 'popup_delay',
                            'type'    => 'spinner',
                            'title'   => esc_html__( 'Delay', 'elinor' ),
                            'step'    => 1,
                            'min'     => 0,
                            'max'     => 9999,
                            'unit'    => 'milliseconds',
                            'default' => 1000,
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( '404 Error', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'    => '404_image',
                            'type'  => 'image',
                            'title' => esc_html__( '404 Image', 'elinor' ),
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'ACE Settings', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'       => 'ace_style',
                            'type'     => 'code_editor',
                            'settings' => array(
                                'theme' => 'dracula',
                                'mode'  => 'css',
                            ),
                            'title'    => esc_html__( 'Editor Style', 'elinor' ),
                        ),
                        array(
                            'id'       => 'ace_script',
                            'type'     => 'code_editor',
                            'settings' => array(
                                'theme' => 'dracula',
                                'mode'  => 'javascript',
                            ),
                            'title'    => esc_html__( 'Editor Javascript', 'elinor' ),
                        ),
                    ),
                ),
            ),
        );
        $options['header_main']  = array(
            'name'     => 'header_main',
            'icon'     => 'fa fa-folder-open-o',
            'title'    => esc_html__( 'Header', 'elinor' ),
            'sections' => array(
                array(
                    'title'  => esc_html__( 'Header Main', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'      => 'sticky_menu',
                            'type'    => 'button_set',
                            'title'   => esc_html__( 'Header Sticky', 'elinor' ),
                            'options' => array(
                                'none'     => esc_html__( 'None', 'elinor' ),
                                'template' => esc_html__( 'Template', 'elinor' ),
                                'jquery'   => esc_html__( 'jQuery', 'elinor' ),
                            ),
                            'default' => 'none',
                        ),
                        array(
                            'id'         => 'header_template',
                            'type'       => 'select_preview',
                            'title'      => esc_html__( 'Header Layout', 'elinor' ),
                            'options'    => elinor_file_options( '/templates/header/', 'header' ),
                            'default'    => 'style-01',
                            'attributes' => array(
                                'data-depend-id' => 'header_template',
                            ),
                        ),
                        array(
                            'id'         => 'header_home_bg',
                            'type'       => 'switcher',
                            'title'      => esc_html__( 'Homepage has Background', 'elinor' ),
                            'default'    => 1,
                            'dependency' => array(
                                'header_template', 'any',
                                'style-04'
                            ),
                        ),
                        array(
                            'id'          => 'header_banner',
                            'type'        => 'select',
                            'options'     => 'page',
                            'chosen'      => true,
                            'ajax'        => true,
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'title'       => esc_html__( 'Header Banner', 'elinor' ),
                            'desc'        => esc_html__( 'Get banner on header from page builder', 'elinor' ),
                        ),
                        array(
                            'id'         => 'header_bg',
                            'type'       => 'image',
                            'title'      => esc_html__( 'Header Background', 'elinor' ),
                            'dependency' => array(
                                'header_template', 'any',
                                'style-02,style-06'
                            ),
                        ),
                        array(
                            'id'      => 'enable_primary_menu',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Enable Primary Menu', 'elinor' ),
                            'default' => 1,
                        ),
                        array(
                            'id'         => 'primary_menu_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Primary Menu Title', 'elinor' ),
                            'dependency' => array(
                                'header_template', 'any',
                                'style-05'
                            ),
                        ),
                        array(
                            'id'          => 'brand_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Brands Menu', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'dependency'  => array(
                                'header_template', 'any',
                                'style-05'
                            ),
                        ),
                        array(
                            'id'         => 'brand_menu_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Brands Menu Title', 'elinor' ),
                            'dependency' => array(
                                'header_template', 'any',
                                'style-05'
                            ),
                        ),
                        array(
                            'id'          => 'header_submenu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Header Submenu', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                        ),
                        array(
                            'id'          => 'header_submenu_2',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Header Submenu 2', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                        ),
                        array(
                            'id'          => 'header_submenu_3',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Header Submenu 3', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'dependency'  => array(
                                'header_template', 'any',
                                'style-03,style-07'
                            ),
                        ),
                        array(
                            'id'              => 'header_info',
                            'type'            => 'group',
                            'title'           => esc_html__( 'Header Info', 'elinor' ),
                            'button_title'    => esc_html__( 'Add item', 'elinor' ),
                            'accordion_title' => esc_html__( 'Add New item', 'elinor' ),
                            'max'             => 1,
                            'fields'          => array(
                                array(
                                    'id'    => 'info_title',
                                    'type'  => 'text',
                                    'title' => esc_html__( 'Title', 'elinor' ),
                                ),
                                array(
                                    'id'    => 'info_subtitle',
                                    'type'  => 'text',
                                    'title' => esc_html__( 'Subtitle', 'elinor' ),
                                ),
                                array(
                                    'id'    => 'info_icon',
                                    'type'  => 'icon',
                                    'title' => esc_html__( 'Icon', 'elinor' ),
                                ),
                                array(
                                    'id'    => 'info_link',
                                    'type'  => 'text',
                                    'title' => esc_html__( 'Link', 'elinor' ),
                                ),
                            ),
                            'dependency'      => array(
                                'header_template', 'any',
                                'style-01,style-04'
                            ),
                        ),
                        array(
                            'id'         => 'header_search_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Header Search Title', 'elinor' ),
                            'dependency' => array(
                                'header_template', 'any',
                                'style-09'
                            ),
                        ),
                        array(
                            'id'         => 'header_minicart_bg',
                            'type'       => 'image',
                            'title'      => esc_html__( 'Mini cart Background', 'elinor' ),
                            'dependency' => array(
                                'header_template', 'any',
                                'style-07'
                            ),
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Vertical Menu', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'       => 'vertical_always_open',
                            'type'     => 'select',
                            'options'  => 'page',
                            'multiple' => true,
                            'chosen'   => true,
                            'ajax'     => true,
                            'title'    => esc_html__( 'Vertical Menu Always Open', 'elinor' ),
                        ),
                        array(
                            'type'       => 'notice',
                            'style'      => 'warning',
                            'content'    => esc_html__( 'Style header do not support vertical menu.', 'elinor' ),
                            'dependency' => array( 'header_template', 'not-any', $vertical_menu, true ),
                        ),
                        array(
                            'id'          => 'vertical_menu',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Vertical Menu', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                            'dependency'  => array( 'header_template', 'any', $vertical_menu, true ),
                        ),
                        array(
                            'id'         => 'vertical_title',
                            'type'       => 'text',
                            'title'      => esc_html__( 'Vertical Title', 'elinor' ),
                            'dependency' => array( 'header_template', 'any', $vertical_menu, true ),
                        ),
                    ),
                ),
            ),
        );
        $options['footer_main']  = array(
            'name'   => 'footer_main',
            'icon'   => 'fa fa-folder-open-o',
            'title'  => esc_html__( 'Footer', 'elinor' ),
            'fields' => array(
                array(
                    'id'      => 'footer_template',
                    'type'    => 'select_preview',
                    'default' => 'footer-01',
                    'title'   => esc_html__( 'Footer Layout', 'elinor' ),
                    'options' => elinor_footer_preview(),
                ),
            ),
        );
        $options['mobile_main']  = array(
            'name'     => 'mobile_main',
            'icon'     => 'fa fa-wordpress',
            'title'    => esc_html__( 'Mobile', 'elinor' ),
            'sections' => array(
                array(
                    'title'  => esc_html__( 'Mobile Layout', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'      => 'mobile_enable',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Mobile Version', 'elinor' ),
                            'default' => 1,
                        ),
                        array(
                            'id'    => 'logo_mobile',
                            'type'  => 'image',
                            'title' => esc_html__( 'Mobile Logo', 'elinor' ),
                            'desc'  => esc_html__( 'Setting Logo For Site', 'elinor' ),
                        ),
                        array(
                            'id'      => 'mobile_layout',
                            'type'    => 'image_select',
                            'default' => 'style-01',
                            'title'   => esc_html__( 'Mobile Layout', 'elinor' ),
                            'options' => array(
                                'style-01' => get_theme_file_uri( 'templates/mobile/mobile-style-01.png' ),
                                'style-02' => get_theme_file_uri( 'templates/mobile/mobile-style-02.png' ),
                                'style-03' => get_theme_file_uri( 'templates/mobile/mobile-style-03.png' ),
                                'style-04' => get_theme_file_uri( 'templates/mobile/mobile-style-04.png' ),
                            ),
                        ),
                        array(
                            'id'    => 'mobile_banner',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Main Menu - Top Banner', 'elinor' ),
                        ),
                        array(
                            'id'      => 'background_mobile',
                            'type'    => 'background',
                            'title'   => esc_html__( 'Main Menu - Top Banner Background', 'elinor' ),
                            'desc'    => esc_html__( 'Setting Background For Mobile Menu', 'elinor' ),
                            'default' => array(
                                'background-position'   => 'center center',
                                'background-repeat'     => 'no-repeat',
                                'background-attachment' => 'scroll',
                                'background-size'       => 'cover',
                            ),
                            'output'  => '.ovic-menu-clone-wrap .head-menu-mobile'
                        ),
                    )
                ),
                array(
                    'title'  => esc_html__( 'Mobile Content', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'          => 'mobile_menu_top',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Mobile Menu Top', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                        ),
                        array(
                            'id'          => 'mobile_menu_bottom',
                            'type'        => 'select',
                            'title'       => esc_html__( 'Mobile Menu Bottom', 'elinor' ),
                            'options'     => 'menus',
                            'chosen'      => true,
                            'ajax'        => true,
                            'query_args'  => array(
                                'data-slug' => true,
                            ),
                            'placeholder' => esc_html__( 'None', 'elinor' ),
                        ),
                        array(
                            'id'      => 'mobile_footer',
                            'type'    => 'select_preview',
                            'default' => 'inherit',
                            'title'   => esc_html__( 'Mobile Footer', 'elinor' ),
                            'options' => elinor_footer_preview( true ),
                        ),
                    )
                ),
            )
        );
        $options['posts_main']   = array(
            'name'     => 'posts_main',
            'icon'     => 'fa fa-rss',
            'title'    => esc_html__( 'Posts Settings', 'elinor' ),
            'sections' => array(
                array(
                    'title'  => esc_html__( 'Blog Page', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'      => 'blog_page_title',
                            'type'    => 'switcher',
                            'title'   => esc_html__( 'Page Title', 'elinor' ),
                            'default' => 1,
                        ),
                        array(
                            'id'         => 'blog_page_title_bg',
                            'type'       => 'image',
                            'title'      => esc_html__( 'Page Title Background', 'elinor' ),
                            'dependency' => array( 'blog_page_title', '==', 1 ),
                        ),
                        array(
                            'id'         => 'blog_page_title_fixed',
                            'type'       => 'switcher',
                            'title'      => esc_html__( 'Background - Fixed', 'elinor' ),
                            'dependency' => array( 'blog_page_title', '==', 1 ),
                        ),
                        array(
                            'id'          => 'blog_builder_top',
                            'type'        => 'select',
                            'options'     => 'page',
                            'query_args'  => array(
                                'posts_per_page' => -1,
                            ),
                            'chosen'      => true,
                            'ajax'        => true,
                            'placeholder' => esc_html__( 'Select Page', 'elinor' ),
                            'title'       => esc_html__( 'Blog Builder Top', 'elinor' ),
                        ),
                        array(
                            'id'      => 'blog_list_style',
                            'type'    => 'select',
                            'title'   => esc_html__( 'Blog Style', 'elinor' ),
                            'options' => array(
                                'standard' => esc_html__( 'Standard', 'elinor' ),
                                'grid'     => esc_html__( 'Grid', 'elinor' ),
                            ),
                            'default' => 'standard',
                        ),
                        array(
                            'id'         => 'blog_list_column',
                            'type'       => 'spinner',
                            'title'      => esc_html__( 'Blog Column', 'elinor' ),
                            'desc'       => esc_html__( 'for Grid', 'elinor' ),
                            'max'        => 6,
                            'min'        => 2,
                            'step'       => 1,
                            'unit'       => 'columns',
                            'default'    => 2,
                            'dependency' => array( 'blog_list_style', '==', 'grid' ),
                        ),
                        array(
                            'id'      => 'sidebar_blog_layout',
                            'type'    => 'image_select',
                            'title'   => esc_html__( 'Sidebar Blog Layout', 'elinor' ),
                            'desc'    => esc_html__( 'Select sidebar position on Blog.', 'elinor' ),
                            'options' => array(
                                'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                            ),
                            'default' => 'left',
                        ),
                        array(
                            'id'         => 'blog_used_sidebar',
                            'type'       => 'select',
                            'default'    => 'widget-area',
                            'title'      => esc_html__( 'Blog Sidebar', 'elinor' ),
                            'options'    => 'sidebars',
                            'dependency' => array( 'sidebar_blog_layout', '!=', 'full' ),
                        ),
                        array(
                            'id'      => 'blog_pagination',
                            'type'    => 'button_set',
                            'title'   => esc_html__( 'Blog Pagination', 'elinor' ),
                            'options' => array(
                                'pagination' => esc_html__( 'Pagination', 'elinor' ),
                                'load_more'  => esc_html__( 'Load More', 'elinor' ),
                                'infinite'   => esc_html__( 'Infinite Scrolling', 'elinor' ),
                            ),
                            'default' => 'pagination',
                            'desc'    => esc_html__( 'Select style pagination on blog page.', 'elinor' ),
                        ),
                    ),
                ),
                array(
                    'title'  => esc_html__( 'Post Single', 'elinor' ),
                    'fields' => array(
                        array(
                            'id'      => 'single_layout',
                            'type'    => 'select',
                            'default' => 'standard',
                            'title'   => esc_html__( 'Single Post Layout', 'elinor' ),
                            'options' => array(
                                'standard'  => esc_html__( 'Standard', 'elinor' ),
                                'fullwidth' => esc_html__( 'Full Width', 'elinor' ),
                            ),
                        ),
                        array(
                            'id'      => 'sidebar_single_layout',
                            'type'    => 'image_select',
                            'title'   => esc_html__( ' Sidebar Single Post Layout', 'elinor' ),
                            'desc'    => esc_html__( 'Select sidebar position on Blog.', 'elinor' ),
                            'options' => array(
                                'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                            ),
                            'default' => 'left',
                        ),
                        array(
                            'id'         => 'single_used_sidebar',
                            'type'       => 'select',
                            'default'    => 'widget-area',
                            'title'      => esc_html__( 'Blog Single Sidebar', 'elinor' ),
                            'options'    => 'sidebars',
                            'dependency' => array( 'sidebar_single_layout', '!=', 'full' ),
                        ),
                        array(
                            'id'    => 'enable_share_post',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Share', 'elinor' ),
                        ),
                        array(
                            'id'    => 'enable_pagination_post',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Prev/Next Post', 'elinor' ),
                        ),
                        array(
                            'id'    => 'enable_author_info',
                            'type'  => 'switcher',
                            'title' => esc_html__( 'Enable Author Info', 'elinor' ),
                        ),
                    ),
                ),
            ),
        );
        if ( class_exists( 'WooCommerce' ) ) {
            $options['woocommerce_mains'] = array(
                'name'     => 'woocommerce_mains',
                'icon'     => 'fa fa-shopping-bag',
                'title'    => esc_html__( 'WooCommerce', 'elinor' ),
                'sections' => array(
                    array(
                        'title'  => esc_html__( 'Shop Page', 'elinor' ),
                        'fields' => array(
                            array(
                                'id'      => 'shop_page_title',
                                'type'    => 'switcher',
                                'title'   => esc_html__( 'Page Title', 'elinor' ),
                                'default' => 1,
                            ),
                            array(
                                'id'         => 'shop_page_title_bg',
                                'type'       => 'image',
                                'title'      => esc_html__( 'Page Title Background', 'elinor' ),
                                'dependency' => array( 'shop_page_title', '==', 1 ),
                            ),
                            array(
                                'id'         => 'shop_page_title_fixed',
                                'type'       => 'switcher',
                                'title'      => esc_html__( 'Background - Fixed', 'elinor' ),
                                'dependency' => array( 'shop_page_title', '==', 1 ),
                            ),
                            array(
                                'id'          => 'shop_builder_top',
                                'type'        => 'select',
                                'options'     => 'page',
                                'query_args'  => array(
                                    'posts_per_page' => -1,
                                ),
                                'chosen'      => true,
                                'ajax'        => true,
                                'placeholder' => esc_html__( 'Select Page', 'elinor' ),
                                'title'       => esc_html__( 'Shop Builder Top', 'elinor' ),
                                'desc'        => esc_html__( 'Get shop banner from page builder.', 'elinor' ),
                            ),
                            array(
                                'id'      => 'shop_builder_position',
                                'type'    => 'select',
                                'title'   => esc_html__( 'Shop Builder Position', 'elinor' ),
                                'options' => array(
                                    'outside' => esc_html__( 'Outside', 'elinor' ),
                                    'inside'  => esc_html__( 'Inside', 'elinor' ),
                                ),
                                'default' => 'outside',
                            ),
                            array(
                                'id'          => 'shop_builder_bot',
                                'type'        => 'select',
                                'options'     => 'page',
                                'query_args'  => array(
                                    'posts_per_page' => -1,
                                ),
                                'chosen'      => true,
                                'ajax'        => true,
                                'placeholder' => esc_html__( 'Select Page', 'elinor' ),
                                'title'       => esc_html__( 'Shop Builder Bottom', 'elinor' ),
                                'desc'        => esc_html__( 'Get shop banner from page builder.', 'elinor' ),
                            ),
                            array(
                                'id'      => 'shop_page_layout',
                                'type'    => 'image_select',
                                'default' => 'grid',
                                'title'   => esc_html__( 'Shop Layout', 'elinor' ),
                                'desc'    => esc_html__( 'Select layout for shop product, product category archive.',
                                    'elinor' ),
                                'options' => array(
                                    'grid' => get_theme_file_uri( 'assets/images/grid-display.png' ),
                                    'list' => get_theme_file_uri( 'assets/images/list-display.png' ),
                                ),
                            ),
                            array(
                                'id'      => 'product_loop_columns',
                                'type'    => 'spinner',
                                'title'   => esc_html__( 'Products Columns', 'elinor' ),
                                'desc'    => esc_html__( 'for Grid', 'elinor' ),
                                'max'     => 6,
                                'min'     => 2,
                                'step'    => 1,
                                'unit'    => 'columns',
                                'default' => 4,
                            ),
                            array(
                                'id'      => 'product_per_page',
                                'type'    => 'spinner',
                                'default' => 16,
                                'unit'    => 'items',
                                'title'   => esc_html__( 'Products Per Page', 'elinor' ),
                            ),
                            array(
                                'id'      => 'product_newness',
                                'default' => 100,
                                'type'    => 'spinner',
                                'unit'    => 'days',
                                'title'   => esc_html__( 'Products Newness', 'elinor' ),
                            ),
                            array(
                                'id'      => 'product_hover',
                                'type'    => 'button_set',
                                'title'   => esc_html__( 'Product Image Hover', 'elinor' ),
                                'options' => array(
                                    ''       => esc_html__( 'None', 'elinor' ),
                                    'zoom'   => esc_html__( 'Zoom Image', 'elinor' ),
                                    'change' => esc_html__( 'Change Image', 'elinor' ),
                                    'slide'  => esc_html__( 'Slide Image', 'elinor' ),
                                ),
                                'default' => '',
                            ),
                            array(
                                'id'      => 'woocommerce_pagination',
                                'type'    => 'button_set',
                                'title'   => esc_html__( 'Shop Pagination', 'elinor' ),
                                'options' => array(
                                    'pagination' => esc_html__( 'Pagination', 'elinor' ),
                                    'load_more'  => esc_html__( 'Load More', 'elinor' ),
                                    'infinite'   => esc_html__( 'Infinite Scrolling', 'elinor' ),
                                ),
                                'default' => 'pagination',
                                'desc'    => esc_html__( 'Select style pagination on shop page.', 'elinor' ),
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Shop Page Sidebar', 'elinor' ),
                        'fields' => array(
                            array(
                                'id'      => 'sidebar_shop_layout',
                                'type'    => 'image_select',
                                'title'   => esc_html__( 'Shop Page Sidebar Layout', 'elinor' ),
                                'desc'    => esc_html__( 'Select sidebar position on Shop Page.', 'elinor' ),
                                'options' => array(
                                    'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                    'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                    'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                                ),
                                'default' => 'left',
                            ),
                            array(
                                'id'         => 'shop_used_sidebar',
                                'type'       => 'select',
                                'default'    => 'shop-widget-area',
                                'title'      => esc_html__( 'Sidebar Used For Shop', 'elinor' ),
                                'options'    => 'sidebars',
                                'dependency' => array( 'sidebar_shop_layout', '!=', 'full' ),
                            ),
                            array(
                                'id'         => 'shop_vendor_used_sidebar',
                                'type'       => 'select',
                                'default'    => 'shop-widget-area',
                                'title'      => esc_html__( 'Sidebar Used For Vendor', 'elinor' ),
                                'options'    => 'sidebars',
                                'dependency' => array( 'sidebar_shop_layout', '!=', 'full' ),
                            ),
                            array(
                                'id'      => 'shop_sidebar_width',
                                'type'    => 'slider',
                                'title'   => esc_html__( 'Sidebar Width', 'elinor' ),
                                'desc'    => esc_html__( 'Default is General / Sidebar settings', 'elinor' ),
                                'min'     => 200,
                                'max'     => 500,
                                'step'    => 1,
                                'unit'    => esc_html__( 'px', 'elinor' ),
                                'default' => 330,
                            ),
                            array(
                                'id'      => 'shop_sidebar_space',
                                'type'    => 'spinner',
                                'title'   => esc_html__( 'Sidebar Space', 'elinor' ),
                                'desc'    => esc_html__( 'Default is General / Sidebar settings', 'elinor' ),
                                'min'     => 0,
                                'max'     => 200,
                                'step'    => 1,
                                'unit'    => 'px',
                                'default' => 30,
                            ),
                            array(
                                'id'      => 'shop_sidebar_width_tablet',
                                'type'    => 'slider',
                                'title'   => esc_html__( 'Sidebar Width Tablet', 'elinor' ),
                                'desc'    => esc_html__( 'resolution < 1500px', 'elinor' ),
                                'min'     => 200,
                                'max'     => 500,
                                'step'    => 1,
                                'unit'    => esc_html__( 'px', 'elinor' ),
                                'default' => 270,
                            ),
                            array(
                                'id'      => 'shop_sidebar_space_tablet',
                                'type'    => 'spinner',
                                'title'   => esc_html__( 'Sidebar Space Tablet', 'elinor' ),
                                'desc'    => esc_html__( 'resolution < 1500px', 'elinor' ),
                                'min'     => 0,
                                'max'     => 200,
                                'step'    => 1,
                                'unit'    => 'px',
                                'default' => 30,
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Shop Page Items', 'elinor' ),
                        'fields' => array(
                            array(
                                'id'      => 'shop_product_style',
                                'type'    => 'select_preview',
                                'default' => 'style-01',
                                'title'   => esc_html__( 'Grid Items Style', 'elinor' ),
                                'options' => elinor_product_options( 'Theme Option' ),
                            ),
                            array(
                                'id'         => 'shop_product_border',
                                'type'       => 'select',
                                'title'      => esc_html__( 'Product Border', 'elinor' ),
                                'options'    => array(
                                    ''                 => esc_html__( 'None', 'elinor' ),
                                    'product-border-1' => esc_html__( 'Border 1', 'elinor' ),
                                    'product-border-2' => esc_html__( 'Border 2', 'elinor' ),
                                ),
                                'default'    => 'product-border-2',
                                'dependency' => array(
                                    'shop_product_style',
                                    'any',
                                    'style-01,style-02,style-04,style-05,style-06,style-09,style-10,style-11,style-12,style-13,style-18'
                                ),
                            ),
                            array(
                                'id'      => 'price_typo',
                                'type'    => 'select',
                                'title'   => esc_html__( 'Product Price Typography', 'elinor' ),
                                'options' => array(
                                    'default' => esc_html__( 'Default', 'elinor' ),
                                    'special' => esc_html__( 'Special', 'elinor' ),
                                ),
                                'default' => 'special',
                            ),
                            array(
                                'id'    => 'disable_labels',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Disable Labels', 'elinor' ),
                            ),
                            array(
                                'id'    => 'disable_rating',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Disable Rating', 'elinor' ),
                            ),
                            array(
                                'id'    => 'short_text',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Short Title', 'elinor' ),
                            ),
                            array(
                                'id'    => 'enable_short_title',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Short Title on Mobile ( < 768px )', 'elinor' ),
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Product Single', 'elinor' ),
                        'fields' => array(
                            array(
                                'id'      => 'single_product_thumbnail',
                                'type'    => 'select',
                                'title'   => esc_html__( 'Product Gallery', 'elinor' ),
                                'options' => array(
                                    'standard' => esc_html__( 'Standard', 'elinor' ),
                                    'grid'     => esc_html__( 'Grid Gallery', 'elinor' ),
                                    'slide'    => esc_html__( 'Slide Gallery', 'elinor' ),
                                    'sticky'   => esc_html__( 'Scroll Gallery', 'elinor' ),
                                ),
                                'default' => 'standard',
                            ),
                            array(
                                'id'      => 'single_product_summary',
                                'type'    => 'select',
                                'title'   => esc_html__( 'Product Summary', 'elinor' ),
                                'options' => array(
                                    'standard'     => esc_html__( 'Standard', 'elinor' ),
                                    'sub-column'   => esc_html__( 'Sub Column', 'elinor' ),
                                    'sub-column-2' => esc_html__( 'Sub Column v2', 'elinor' ),
                                ),
                                'default' => 'standard',
                            ),
                            array(
                                'id'              => 'sub_column_info',
                                'type'            => 'group',
                                'title'           => esc_html__( 'Sub Column Info', 'elinor' ),
                                'button_title'    => esc_html__( 'Add item', 'elinor' ),
                                'accordion_title' => esc_html__( 'Add New item', 'elinor' ),
                                'fields'          => array(
                                    array(
                                        'id'    => 'title',
                                        'type'  => 'text',
                                        'title' => esc_html__( 'Title', 'elinor' ),
                                    ),
                                    array(
                                        'id'    => 'image',
                                        'type'  => 'image',
                                        'title' => esc_html__( 'Image', 'elinor' ),
                                    ),
                                    array(
                                        'id'    => 'icon',
                                        'type'  => 'icon',
                                        'title' => esc_html__( 'Icon', 'elinor' ),
                                    ),
                                ),
                                'dependency'      => array(
                                    'single_product_summary', '==', 'sub-column'
                                ),
                            ),
                            array(
                                'id'         => 'sub_column_payment',
                                'type'       => 'image',
                                'title'      => esc_html__( 'Sub Column Payment', 'elinor' ),
                                'dependency' => array(
                                    'single_product_summary', '==', 'sub-column'
                                ),
                            ),
                            array(
                                'id'      => 'sidebar_product_layout',
                                'type'    => 'image_select',
                                'title'   => esc_html__( 'Product Sidebar', 'elinor' ),
                                'desc'    => esc_html__( 'Select sidebar position on Product Page.', 'elinor' ),
                                'options' => array(
                                    'left'  => get_theme_file_uri( 'assets/images/left-sidebar.png' ),
                                    'right' => get_theme_file_uri( 'assets/images/right-sidebar.png' ),
                                    'full'  => get_theme_file_uri( 'assets/images/no-sidebar.png' ),
                                ),
                                'default' => 'left',
                            ),
                            array(
                                'id'         => 'product_used_sidebar',
                                'type'       => 'select',
                                'default'    => 'product-widget-area',
                                'title'      => esc_html__( 'Sidebar Used For Product', 'elinor' ),
                                'options'    => 'sidebars',
                                'dependency' => array( 'sidebar_product_layout', '!=', 'full' ),
                            ),
                            array(
                                'id'    => 'enable_countdown_product',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Enable Countdown', 'elinor' ),
                            ),
                            array(
                                'id'    => 'enable_share_product',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Enable Share', 'elinor' ),
                            ),
                            array(
                                'id'    => 'disable_zoom',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Disable Zoom Gallery', 'elinor' ),
                            ),
                            array(
                                'id'    => 'disable_lightbox',
                                'type'  => 'switcher',
                                'title' => esc_html__( 'Disable Lightbox Gallery', 'elinor' ),
                            ),
                            array(
                                'id'      => 'single_product_tabs',
                                'type'    => 'select',
                                'title'   => esc_html__( 'Product Tabs', 'elinor' ),
                                'options' => array(
                                    ''         => esc_html__( 'Default', 'elinor' ),
                                    'show-all' => esc_html__( 'Show All', 'elinor' ),
                                ),
                                'default' => '',
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Related Products', 'elinor' ),
                        'fields' => array(
                            array(
                                'id'      => 'woo_related_enable',
                                'type'    => 'button_set',
                                'default' => 'enable',
                                'options' => array(
                                    'enable'  => esc_html__( 'Enable', 'elinor' ),
                                    'disable' => esc_html__( 'Disable', 'elinor' ),
                                ),
                                'title'   => esc_html__( 'Enable Related Products', 'elinor' ),
                            ),
                            array(
                                'id'         => 'woo_related_title',
                                'type'       => 'text',
                                'title'      => esc_html__( 'Related products title', 'elinor' ),
                                'desc'       => esc_html__( 'Related products title', 'elinor' ),
                                'dependency' => array( 'woo_related_enable', '==', 'enable' ),
                                'default'    => esc_html__( 'Related Products', 'elinor' ),
                            ),
                            array(
                                'id'         => 'woo_related_perpage',
                                'type'       => 'spinner',
                                'title'      => esc_html__( 'Related products Items', 'elinor' ),
                                'desc'       => esc_html__( 'Number Related products to show', 'elinor' ),
                                'dependency' => array( 'woo_related_enable', '==', 'enable' ),
                                'default'    => 6,
                                'unit'       => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_desktop',
                                'title'   => esc_html__( 'items on Desktop', 'elinor' ),
                                'desc'    => esc_html__( '1500px <= resolution', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_laptop',
                                'title'   => esc_html__( 'items on Laptop', 'elinor' ),
                                'desc'    => esc_html__( '1200px <= resolution < 1500px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_ipad',
                                'title'   => esc_html__( 'items on Ipad', 'elinor' ),
                                'desc'    => esc_html__( '992px <= resolution < 1200px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_landscape',
                                'title'   => esc_html__( 'items on Landscape Tablet', 'elinor' ),
                                'desc'    => esc_html__( '768px <= resolution < 992px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_portrait',
                                'title'   => esc_html__( 'items on Portrait Tablet', 'elinor' ),
                                'desc'    => esc_html__( '480px <= resolution < 768px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_related_mobile',
                                'title'   => esc_html__( 'items on Mobile', 'elinor' ),
                                'desc'    => esc_html__( 'resolution < 480px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 2,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Upsell Products', 'elinor' ),
                        'fields' => array(
                            array(
                                'id'      => 'woo_upsell_enable',
                                'type'    => 'button_set',
                                'default' => 'enable',
                                'options' => array(
                                    'enable'  => esc_html__( 'Enable', 'elinor' ),
                                    'disable' => esc_html__( 'Disable', 'elinor' ),
                                ),
                                'title'   => esc_html__( 'Enable Upsell Products', 'elinor' ),
                            ),
                            array(
                                'id'         => 'woo_upsell_title',
                                'type'       => 'text',
                                'title'      => esc_html__( 'Upsell products title', 'elinor' ),
                                'desc'       => esc_html__( 'Upsell products title', 'elinor' ),
                                'dependency' => array( 'woo_upsell_enable', '==', 'enable' ),
                                'default'    => esc_html__( 'Upsell Products', 'elinor' ),
                            ),
                            array(
                                'id'      => 'woo_upsell_desktop',
                                'title'   => esc_html__( 'items on Desktop', 'elinor' ),
                                'desc'    => esc_html__( '1500px <= resolution', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_laptop',
                                'title'   => esc_html__( 'items on Laptop', 'elinor' ),
                                'desc'    => esc_html__( '1200px <= resolution < 1500px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_ipad',
                                'title'   => esc_html__( 'items on Ipad', 'elinor' ),
                                'desc'    => esc_html__( '992px <= resolution < 1200px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_landscape',
                                'title'   => esc_html__( 'items on Landscape Tablet', 'elinor' ),
                                'desc'    => esc_html__( '768px <= resolution < 992px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_portrait',
                                'title'   => esc_html__( 'items on Portrait Tablet', 'elinor' ),
                                'desc'    => esc_html__( '480px <= resolution < 768px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_upsell_mobile',
                                'title'   => esc_html__( 'items on Mobile', 'elinor' ),
                                'desc'    => esc_html__( 'resolution < 480px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 2,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                        ),
                    ),
                    array(
                        'title'  => esc_html__( 'Cross Sell Products', 'elinor' ),
                        'fields' => array(
                            array(
                                'id'      => 'woo_crosssell_enable',
                                'type'    => 'button_set',
                                'default' => 'enable',
                                'options' => array(
                                    'enable'  => esc_html__( 'Enable', 'elinor' ),
                                    'disable' => esc_html__( 'Disable', 'elinor' ),
                                ),
                                'title'   => esc_html__( 'Enable Cross Sell Products', 'elinor' ),
                            ),
                            array(
                                'id'         => 'woo_crosssell_title',
                                'type'       => 'text',
                                'title'      => esc_html__( 'Cross Sell products title', 'elinor' ),
                                'desc'       => esc_html__( 'Cross Sell products title', 'elinor' ),
                                'dependency' => array( 'woo_crosssell_enable', '==', 'enable' ),
                                'default'    => esc_html__( 'Cross Sell Products', 'elinor' ),
                            ),
                            array(
                                'id'      => 'woo_crosssell_desktop',
                                'title'   => esc_html__( 'items on Desktop', 'elinor' ),
                                'desc'    => esc_html__( '1500px <= resolution', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_laptop',
                                'title'   => esc_html__( 'items on Laptop', 'elinor' ),
                                'desc'    => esc_html__( '1200px <= resolution < 1500px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 5,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_ipad',
                                'title'   => esc_html__( 'items on Ipad', 'elinor' ),
                                'desc'    => esc_html__( '992px <= resolution < 1200px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 4,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_landscape',
                                'title'   => esc_html__( 'items on Landscape Tablet', 'elinor' ),
                                'desc'    => esc_html__( '768px <= resolution < 992px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_portrait',
                                'title'   => esc_html__( 'items on Portrait Tablet', 'elinor' ),
                                'desc'    => esc_html__( '480px <= resolution < 768px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 3,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                            array(
                                'id'      => 'woo_crosssell_mobile',
                                'title'   => esc_html__( 'items on Mobile', 'elinor' ),
                                'desc'    => esc_html__( 'resolution < 480px', 'elinor' ),
                                'type'    => 'slider',
                                'default' => 2,
                                'min'     => 1,
                                'max'     => 6,
                                'unit'    => 'item(s)',
                            ),
                        ),
                    ),
                ),
            );
        }
        $options['social']     = array(
            'name'   => 'social',
            'icon'   => 'fa fa-users',
            'title'  => esc_html__( 'Social', 'elinor' ),
            'fields' => array(
                array(
                    'id'              => 'user_all_social',
                    'type'            => 'group',
                    'title'           => esc_html__( 'Social', 'elinor' ),
                    'button_title'    => esc_html__( 'Add New Social', 'elinor' ),
                    'accordion_title' => esc_html__( 'Social Settings', 'elinor' ),
                    'fields'          => array(
                        array(
                            'id'      => 'title_social',
                            'type'    => 'text',
                            'title'   => esc_html__( 'Title Social', 'elinor' ),
                            'default' => esc_html__( 'Facebook', 'elinor' ),
                        ),
                        array(
                            'id'      => 'link_social',
                            'type'    => 'text',
                            'title'   => esc_html__( 'Link Social', 'elinor' ),
                            'default' => 'https://facebook.com',
                        ),
                        array(
                            'id'      => 'icon_social',
                            'type'    => 'icon',
                            'title'   => esc_html__( 'Icon Social', 'elinor' ),
                            'default' => 'fa fa-facebook',
                        ),
                    ),
                    'default'         => array(
                        array(
                            'title_social' => esc_html__( 'Facebook', 'elinor' ),
                            'link_social'  => 'https://facebook.com/',
                            'icon_social'  => 'fa fa-facebook',
                        ),
                        array(
                            'title_social' => esc_html__( 'Twitter', 'elinor' ),
                            'link_social'  => 'https://twitter.com/',
                            'icon_social'  => 'fa fa-twitter',
                        ),
                        array(
                            'title_social' => esc_html__( 'Instagram', 'elinor' ),
                            'link_social'  => 'https://instagram.com/',
                            'icon_social'  => 'fa fa-instagram',
                        ),
                        array(
                            'title_social' => esc_html__( 'Youtube', 'elinor' ),
                            'link_social'  => 'https://youtube.com/',
                            'icon_social'  => 'fa fa-youtube-play',
                        ),
                    ),
                ),
            ),
        );
        $options['typography'] = array(
            'name'   => 'typography',
            'icon'   => 'fa fa-font',
            'title'  => esc_html__( 'Typography', 'elinor' ),
            'fields' => array(
                array(
                    'id'             => 'body_typography',
                    'type'           => 'typography',
                    'title'          => esc_html__( 'Typography of Body', 'elinor' ),
                    'font_family'    => true,
                    'font_weight'    => true,
                    'font_style'     => true,
                    'subset'         => true,
                    'text_align'     => true,
                    'text_transform' => true,
                    'font_size'      => true,
                    'line_height'    => true,
                    'letter_spacing' => true,
                    'extra_styles'   => true,
                    'color'          => true,
                    'output'         => 'body',
                ),
                array(
                    'id'             => 'special_typography',
                    'type'           => 'typography',
                    'title'          => esc_html__( 'Typography of Special texts', 'elinor' ),
                    'font_family'    => true,
                    'font_weight'    => true,
                    'font_style'     => true,
                    'subset'         => false,
                    'text_align'     => false,
                    'text_transform' => false,
                    'font_size'      => false,
                    'line_height'    => false,
                    'letter_spacing' => false,
                    'extra_styles'   => true,
                    'color'          => false,
                    'output'         => '.main-special-font',
                    'default'        => array(
                        'font-family'  => 'Cairo',
                        'font-weight'  => '600',
                        'extra-styles' => array(
                            0 => 'normal',
                            1 => '600'
                        ),
                        'type'         => 'google',
                        'unit'         => 'px',
                    ),
                ),
            ),
        );
        $options['backup']     = array(
            'name'   => 'backup',
            'icon'   => 'fa fa-bold',
            'title'  => esc_html__( 'Backup / Reset', 'elinor' ),
            'fields' => array(
                array(
                    'id'    => 'reset',
                    'type'  => 'backup',
                    'title' => esc_html__( 'Reset', 'elinor' ),
                ),
                array(
                    'id'      => 'delete_transients',
                    'type'    => 'content',
                    'content' => '<a href="#" data-text-done="' . esc_attr__( '%n transient database entries have been deleted.', 'elinor' ) . '" class="button button-primary delete-transients"/>' . esc_html__( 'Delete Transients', 'elinor' ) . '</a><span class="spinner" style="float:none;"></span>',
                    'title'   => esc_html__( 'Delete Transients', 'elinor' ),
                    'desc'    => esc_html__( 'All transient related database entries will be deleted.', 'elinor' ),
                    'after'   => ' <p class="ovic-text-success"></p>',
                ),
            ),
        );
        //
        // Framework Settings
        //
        $settings = array(
            'option_name'      => '_ovic_customize_options',
            'menu_title'       => esc_html__( 'Theme Options', 'elinor' ),
            'menu_type'        => 'submenu', // menu, submenu, options, theme, etc.
            'menu_parent'      => 'ovic_addon-dashboard',
            'menu_slug'        => 'ovic_theme_options',
            'menu_position'    => 5,
            'show_search'      => true,
            'show_reset'       => true,
            'show_footer'      => false,
            'show_all_options' => true,
            'ajax_save'        => true,
            'sticky_header'    => false,
            'save_defaults'    => true,
            'framework_title'  => sprintf(
                '%s <small>%s <a href="%s" target="_blank">%s</a></small>',
                esc_html__( 'Theme Options', 'elinor' ),
                esc_html__( 'by', 'elinor' ),
                esc_url( 'https://kutethemes.com/' ),
                esc_html__( 'Kutethemes', 'elinor' )
            ),
        );

        OVIC_Options::instance( $settings, apply_filters( 'elinor_framework_theme_options', $options ) );
    }

    add_action( 'init', 'elinor_theme_options' );
}