<?php
if ( !defined( 'ABSPATH' ) ) {
    exit;
}
if ( !function_exists( 'elinor_enqueue_inline_css' ) ) {
    function elinor_enqueue_inline_css()
    {
        $css                       = html_entity_decode( elinor_get_option( 'ace_style', '' ) );
        $body_typography           = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'body_typography',
            'body_typography'
        );
        $special_typo              = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'special_typography',
            'metabox_special_typography',
            array(
                'font-family'  => 'Cairo',
                'font-weight'  => '600',
                'extra-styles' => array(
                    0 => 'normal',
                    1 => '600'
                ),
                'type'         => 'google',
                'unit'         => 'px',
            )
        );
        $default_color             = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'default_color',
            'metabox_default_color',
            '#3E445A'
        );
        $main_color                = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_color',
            'metabox_main_color',
            '#219653'
        );
        $main_color_t              = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_color_t',
            'metabox_main_color_t',
            '#FFF'
        );
        $main_color_2              = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_color_2',
            'metabox_main_color_2',
            '#FFB800'
        );
        $main_color_2_t            = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_color_2_t',
            'metabox_main_color_2_t',
            '#18191B'
        );
        $main_color_3              = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_color_3',
            'metabox_main_color_3',
            '#E80E29'
        );
        $container                 = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_container',
            'metabox_main_container',
            1400
        );
        $main_fw                   = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_fw',
            'metabox_main_fw',
            500
        );
        $main_bora                 = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_bora',
            'metabox_main_bora',
            90
        );
        $main_bora_b               = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'main_bora_button',
            'metabox_main_bora_button'
        );
        $header_bg                 = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'header_bg',
            'metabox_header_bg'
        );
        $price_typo                = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'price_typo',
            'metabox_price_typo',
            'special'
        );
        $sidebar_width             = elinor_get_option( 'sidebar_width', 400 );
        $sidebar_space             = elinor_get_option( 'sidebar_space', 78 );
        $shop_sidebar_width        = elinor_get_option( 'shop_sidebar_width', 300 );
        $shop_sidebar_space        = elinor_get_option( 'shop_sidebar_space', 30 );
        $sidebar_width_tablet      = elinor_get_option( 'sidebar_width_tablet', 330 );
        $sidebar_space_tablet      = elinor_get_option( 'sidebar_space_tablet', 30 );
        $shop_sidebar_width_tablet = elinor_get_option( 'shop_sidebar_width_tablet', 270 );
        $shop_sidebar_space_tablet = elinor_get_option( 'shop_sidebar_space_tablet', 30 );
        $mc_rgb_r                  = Biolife_Colors::hexToRgb( $main_color )['r'];
        $mc_rgb_g                  = Biolife_Colors::hexToRgb( $main_color )['g'];
        $mc_rgb_b                  = Biolife_Colors::hexToRgb( $main_color )['b'];
        $mc_hsl_h                  = Biolife_Colors::hexToHsl( $main_color )['h'];
        $mc_hsl_s                  = Biolife_Colors::hexToHsl( $main_color )['s'];
        $mc_hsl_l                  = Biolife_Colors::hexToHsl( $main_color )['l'];

        if ( !empty( $body_typography ) && $body_typography['font-family'] == 'Emerland' || !empty( $special_typo ) && $special_typo['font-family'] == 'Emerland' ) {
            $css .= '
            @font-face{
                font-family: Emerland;
                src: url(' . get_theme_file_uri( '/assets/fonts/Emerland.ttf' ) . ') format("truetype");
                font-weight: 400;
                font-style: normal;
                font-display: swap;
            }
            ';
        }
        $css .= 'body{
        --mc-rgb-r:' . $mc_rgb_r . ';
        --mc-rgb-g:' . $mc_rgb_g . ';
        --mc-rgb-b:' . $mc_rgb_b . ';
        --mc-hsl-h:' . $mc_hsl_h . ';
        --mc-hsl-s:' . $mc_hsl_s . '%;
        --mc-hsl-l:' . $mc_hsl_l . '%;
        ';
        if ( !empty( $body_typography ) ) {
            if ( !empty( $body_typography['font-family'] ) )
                $css .= '--main-ff:' . $body_typography['font-family'] . ';';
            if ( !empty( $body_typography['font-size'] ) )
                $css .= '--main-fz:' . $body_typography['font-size'] . 'px;';
            if ( !empty( $body_typography['line-height'] ) )
                $css .= '--main-lh:' . $body_typography['line-height'] . 'px;';
            if ( !empty( $body_typography['color'] ) )
                $css .= '--main-cl:' . $body_typography['color'] . ';';
        }
        if ( !empty( $special_typo ) ) {
            if ( !empty( $special_typo['font-family'] ) ) {
                $css .= '--main-special:' . $special_typo['font-family'] . ';';
                $css .= '--main-special-fw:' . $special_typo['font-weight'] . ';';
                if ( $price_typo == 'special' ) {
                    $css .= '--price-typo: var(--main-special);';
                    $css .= '--price-typo-fw: var(--main-special-fw);';
                }
            }
        }
        if ( !empty( $header_bg ) ) {
            $css .= '--header-bg: url(' . wp_get_attachment_image_url( $header_bg, 'full' ) . ');';
        }
        if ( $default_color != '#3E445A' )
            $css .= '--default-color:' . $default_color . ';';
        if ( $main_color != '#219653' )
            $css .= '--main-color:' . $main_color . ';';
        if ( $main_color_t != '#FFF' )
            $css .= '--main-color-t:' . $main_color_t . ';';
        if ( $main_color_2 != '#FFB800' )
            $css .= '--main-color-2:' . $main_color_2 . ';';
        if ( $main_color_2_t != '#18191B' )
            $css .= '--main-color-2-t:' . $main_color_2_t . ';';
        if ( $main_color_3 != '#E80E29' )
            $css .= '--main-color-3:' . $main_color_3 . ';';
        if ( $main_fw != 500 )
            $css .= '--main-h-fw:' . $main_fw . ';';
        if ( $main_bora != 90 )
            $css .= '--main-bora:' . $main_bora . 'px;';
        if ( !empty( $main_bora_b ) )
            $css .= '--main-bora-b:' . $main_bora_b . ';';
        if ( $sidebar_width != 400 )
            $css .= '--sidebar-width:' . $sidebar_width . 'px;';
        if ( $sidebar_space != 78 )
            $css .= '--sidebar-space:' . $sidebar_space . 'px;';
        if ( $shop_sidebar_width != 330 )
            $css .= '--shop-sidebar-width:' . $shop_sidebar_width . 'px;';
        if ( $shop_sidebar_space != 30 )
            $css .= '--shop-sidebar-space:' . $shop_sidebar_space . 'px;';
        $css .= '}';
        $css .= '@media (max-width:1499px) and (min-width:992px){body{';
        if ( $sidebar_width_tablet != 300 )
            $css .= '--sidebar-width:' . $sidebar_width_tablet . 'px;';
        if ( $sidebar_space_tablet != 30 )
            $css .= '--sidebar-space:' . $sidebar_space_tablet . 'px;';
        if ( $shop_sidebar_width_tablet != 270 )
            $css .= '--shop-sidebar-width:' . $shop_sidebar_width_tablet . 'px;';
        if ( $shop_sidebar_space_tablet != 30 )
            $css .= '--shop-sidebar-space:' . $shop_sidebar_space_tablet . 'px;';
        $css .= '}}';
        if ( !empty( $container ) && $container != 1140 ) {
            $css               .= '
            @media (min-width: 1500px){
                body{
                    --main-container:' . $container . 'px;
                }
                body.wcfm-store-page .site #main{
                    width:calc(var(--main-container) + var(--main-container-pd) * 2) !important;
                }
            }
            ';
        }

        $css = preg_replace( '/\s+/', ' ', $css );

        wp_add_inline_style( 'elinor-main',
            apply_filters( 'elinor_custom_inline_css', $css, $main_color, $container )
        );
    }

    add_action( 'wp_enqueue_scripts', 'elinor_enqueue_inline_css', 30 );
}