<?php if ( !defined( 'ABSPATH' ) ) {
    die;
} // Cannot access pages directly.

if ( elinor_is_mobile() ) {
    require_once get_theme_file_path( '/framework/function-mobile.php' );
}

add_filter( 'ovic_get_api_libary_elementor', function ( $url, $api, $info ) {
    return str_replace(
        '{THEME_URI}/libary-elementor/',
        'https://elinor.kutethemes.net/elinor/',
        $api
    );
}, 10, 3 );

add_filter( 'ovic_menu_toggle_mobile', '__return_false' );
add_filter( 'ovic_menu_locations_mobile', 'elinor_extend_mobile_menu', 10, 2 );
add_filter( 'ovic_override_footer_template', 'elinor_footer_template' );
add_filter( 'elementor/icons_manager/native', 'elinor_elementor_icons' );
add_action( 'import_sample_data_after_install_sample_data', 'elinor_after_install_sample_data' );
add_action( 'elinor_before_mobile_header', 'elinor_mobile_menu_top', 10 );
add_action( 'elinor_after_mobile_header', 'elinor_mobile_menu_bottom', 10 );
add_action( 'dynamic_sidebar_before', 'elinor_dynamic_sidebar_before', 10, 2 );
add_action( 'dynamic_sidebar_after', 'elinor_dynamic_sidebar_after', 10, 2 );
add_action( 'dgwt/wcas/search_query/args', 'elinor_search_query_args' );

/**
 *
 * ajax search query
 */
if ( !function_exists( 'elinor_search_query_args' ) ) {
    function elinor_search_query_args( $args )
    {
        if ( !empty( $_REQUEST['product_cat'] ) ) {

            $product_cat = sanitize_text_field( $_REQUEST['product_cat'] );

            $args['tax_query'][] = array(
                'taxonomy' => 'product_cat',
                'field'    => 'slug',
                'terms'    => array( $product_cat ),
            );
        }

        return $args;
    }
}
/**
 *
 * dynamic sidebar
 */
if ( !function_exists( 'elinor_dynamic_sidebar_before' ) ) {
    function elinor_dynamic_sidebar_before()
    {
        if ( !is_admin() ) {
            if ( elinor_is_mobile() ) :?>
                <div class="sidebar-head">
                    <span class="title"><?php echo esc_html__( 'Sidebar', 'elinor' ); ?></span>
                    <a href="#" class="close-sidebar"></a>
                </div>
            <?php endif;
            echo '<div class="sidebar-inner">';
        }
    }
}
if ( !function_exists( 'elinor_dynamic_sidebar_after' ) ) {
    function elinor_dynamic_sidebar_after()
    {
        if ( !is_admin() ) {
            echo '</div>';
        }
    }
}
/**
 *
 * TEMPLATE HEADER
 */
if ( !function_exists( 'elinor_header_template' ) ) {
    function elinor_header_template()
    {
        $light = array( 'style-02' );
        if ( in_array( elinor_get_header(), $light ) ) {
            $light_class = 'light';
        } else {
            $light_class = '';
        }
        if ( elinor_is_mobile() ) {
            elinor_mobile_template( $light_class );
        } else {
            $sticky_menu = elinor_get_option( 'sticky_menu', 'none' );
            get_template_part( 'templates-parts/header', 'banner' );
            get_template_part( 'templates/header/header', elinor_get_header() );
            if ( $sticky_menu == 'template' ) {
                elinor_get_template(
                    "templates-parts/header-sticky.php",
                    array(
                        'light_class' => $light_class,
                    )
                );
            }
            if ( !class_exists( 'Ovic_Megamenu_Settings' ) ) {
                elinor_mobile_menu( 'primary' );
            }
        }
    }
}
if ( !function_exists( 'elinor_footer_template' ) ) {
    function elinor_footer_template()
    {
        return elinor_get_footer();
    }
}
if ( !function_exists( 'elinor_extend_mobile_menu' ) ) {
    function elinor_extend_mobile_menu( $menus, $locations )
    {

        $vertical_menu = apply_filters( 'elinor_extend_mobile_menu_vertical', elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'vertical_menu',
            'metabox_vertical_menu'
        ) );
        $primary_menu  = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            null,
            'metabox_primary_menu'
        );
        if ( !empty( $primary_menu ) ) {
            $term = get_term_by( 'slug', $primary_menu, 'nav_menu' );
            if ( !is_wp_error( $term ) && !empty( $term ) ) {
                $menus = array( $primary_menu );
            }
        }
        if ( empty( $menus ) && !empty( $locations['primary'] ) ) {
            $mobile_menu = wp_get_nav_menu_object( $locations['primary'] );
            $menus[]     = $mobile_menu->slug;
        }
        if ( !empty( $vertical_menu ) ) {
            $menus[] = $vertical_menu;
        }

        return $menus;
    }
}
/**
 *
 * PRIMARY MENU
 */
if ( !function_exists( 'elinor_primary_menu' ) ) {
    function elinor_primary_menu( $layout = 'horizontal' )
    {
        $enable_primary_menu = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'enable_primary_menu',
            'metabox_enable_primary_menu',
            1
        );
        if ( $enable_primary_menu != 1 )
            return;
        $enable_metabox = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            null,
            "enable_metabox_options"
        );
        $primary_menu   = '';
        $brand_menu     = elinor_get_option( 'brand_menu' );
        if ( $enable_metabox == 1 ) {
            $primary_menu = elinor_theme_option_meta(
                '_custom_metabox_theme_options',
                null,
                "metabox_primary_menu"
            );
            $brand_menu   = elinor_theme_option_meta(
                '_custom_metabox_theme_options',
                null,
                "metabox_brand_menu"
            );
        }
        if ( !empty( $primary_menu ) ) {
            $term = get_term_by( 'slug', $primary_menu, 'nav_menu' );
            if ( !is_wp_error( $term ) && !empty( $term ) ) {
                wp_nav_menu( array(
                        'menu'            => $primary_menu,
                        'theme_location'  => $primary_menu,
                        'depth'           => 3,
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'menu_class'      => 'elinor-nav primary-menu active main-menu ' . $layout . '-menu',
                        'megamenu_layout' => $layout,
                    )
                );
            }
        } else {
            if ( has_nav_menu( 'primary' ) ) {
                wp_nav_menu( array(
                        'menu'            => 'primary',
                        'theme_location'  => 'primary',
                        'depth'           => 3,
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'menu_class'      => 'elinor-nav primary-menu active main-menu ' . $layout . '-menu',
                        'megamenu_layout' => $layout,
                    )
                );
            }
        }
        if ( !empty( $brand_menu ) ) {
            $term = get_term_by( 'slug', $brand_menu, 'nav_menu' );
            if ( !is_wp_error( $term ) && !empty( $term ) ) {
                wp_nav_menu( array(
                        'menu'            => $brand_menu,
                        'theme_location'  => $brand_menu,
                        'depth'           => 3,
                        'container'       => '',
                        'container_class' => '',
                        'container_id'    => '',
                        'menu_class'      => 'elinor-nav brand-menu main-menu ' . $layout . '-menu',
                        'megamenu_layout' => $layout,
                    )
                );
            }
        }
    }
}
if ( !function_exists( 'elinor_header_menu_bar' ) ) {
    function elinor_header_menu_bar()
    {
        ?>
        <div class="mobile-block block-menu-bar">
            <a href="javascript:void(0)" class="menu-bar menu-toggle">
                <span class="icon main-icon-e-menu-square"></span>
                <span class="text">
                    <span class="sub"><?php echo esc_html__( 'Nav', 'elinor' ); ?></span>
                    <?php echo esc_html__( 'Menu', 'elinor' ); ?>
                </span>
            </a>
        </div>
        <?php
    }
}
if ( !function_exists( 'elinor_header_switch_menu' ) ) {
    function elinor_header_switch_menu()
    {
        $enable_primary_menu = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'enable_primary_menu',
            'metabox_enable_primary_menu',
            1
        );
        $enable_metabox = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            null,
            "enable_metabox_options"
        );
        $brand_menu     = elinor_get_option( 'brand_menu' );
        if ( $enable_metabox == 1 ) {
            $brand_menu   = elinor_theme_option_meta(
                '_custom_metabox_theme_options',
                null,
                "metabox_brand_menu"
            );
        }
        $primary_menu_title  = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'primary_menu_title',
            "metabox_primary_menu_title",
            ''
        );
        $brand_menu_title    = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'brand_menu_title',
            "metabox_brand_menu_title",
            ''
        );
        if ( $enable_primary_menu == 1 && !empty( $brand_menu ) ) : ?>
            <div class="switch-menu">
                <div class="inner">
                    <a href="javascript:void(0)" data-menu="primary-menu" class="active">
                        <?php echo esc_html( $primary_menu_title ); ?>
                    </a>
                    <a href="javascript:void(0)" data-menu="brand-menu">
                        <?php echo esc_html( $brand_menu_title ); ?>
                    </a>
                </div>
            </div>
        <?php endif;
    }
}
/**
 *
 * VERTICAL MENU
 */
if ( !function_exists( 'elinor_vertical_menu' ) ) {
    function elinor_vertical_menu( $layout = 'default' )
    {
        elinor_get_template(
            "templates-parts/header-vertical.php",
            array(
                'layout' => $layout,
            )
        );
    }
}
if ( !function_exists( 'elinor_vertical_menu_button' ) ) {
    function elinor_vertical_menu_button()
    {
        $vertical_menu = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            'vertical_menu',
            'metabox_vertical_menu'
        );
        if ( !elinor_is_mobile() && !empty( $vertical_menu ) ): ?>
            <div class="button-vertical">
                <a href="#" class="vertical-open">
                    <span class="icon main-icon-e-menu"></span>
                </a>
            </div>
        <?php endif;
    }
}
/**
 *
 * HEADER SUBMENU
 */
if ( !function_exists( 'elinor_header_submenu' ) ) {
    function elinor_header_submenu( $menu_location, $depth = 2 )
    {
        $header_menu = elinor_theme_option_meta(
            '_custom_metabox_theme_options',
            $menu_location,
            "metabox_{$menu_location}"
        );
        if ( !empty( $header_menu ) ) {
            echo '<div class="' . $menu_location . '">';
            do_action( "elinor_before_header_menu_{$header_menu}", $header_menu );
            wp_nav_menu( array(
                    'menu'           => $header_menu,
                    'theme_location' => $header_menu,
                    'link_before'    => '<span class="text">',
                    'link_after'     => '</span>',
                    'depth'          => $depth,
                    'menu_class'     => 'ovic-menu header-submenu',
                )
            );
            do_action( "elinor_after_header_menu_{$header_menu}", $header_menu );
            echo '</div>';
        }
    }
}
/**
 *
 * HEADER BANNER
 */
if ( !function_exists( 'elinor_header_banner' ) ) {
    function elinor_header_banner()
    {
        get_template_part( 'templates-parts/header', 'banner' );
    }
}
/**
 *
 * HEADER SOCIAL
 */
if ( !function_exists( 'elinor_header_social' ) ) {
    function elinor_header_social()
    {
        get_template_part( 'templates-parts/header', 'social' );
    }
}
/**
 *
 * HEADER INFO
 */
if ( !function_exists( 'elinor_header_info' ) ) {
    function elinor_header_info()
    {
        get_template_part( 'templates-parts/header', 'info' );
    }
}
/**
 *
 * HEADER SEARCH
 */
if ( !function_exists( 'elinor_header_search' ) ) {
    function elinor_header_search( $category = false, $text = '' )
    {
        echo '<div class="block-search">';
        elinor_get_template(
            "templates-parts/header-search.php",
            array(
                'category' => $category,
                'text'     => $text,
            )
        );
        echo '</div>';
    }
}
/**
 *
 * HEADER SEARCH POPUP
 */
if ( !function_exists( 'elinor_header_search_popup' ) ) {
    function elinor_header_search_popup( $category = false, $text = '' )
    {
        ?>
        <div class="block-search elinor-dropdown">
            <a data-elinor="elinor-dropdown" class="woo-search-link" href="javascript:void(0)">
                <span class="icon main-icon-e-search"></span>
                <span class="text">
                    <span class="sub"><?php echo esc_html__( 'Looking for', 'elinor' ); ?></span>
                    <?php echo esc_html__( 'Search', 'elinor' ); ?>
                </span>
            </a>
            <div class="sub-menu">
                <a class="close-search" href="javascript:void(0)"><span class="main-icon-e-close-circle"></span></a>
                <?php
                elinor_get_template(
                    "templates-parts/header-search.php",
                    array(
                        'category' => $category,
                        'text'     => $text,
                    )
                );
                ?>
            </div>
        </div>
        <?php
    }
}
/**
 *
 * HEADER ACCOUNT MENU
 */
if ( !function_exists( 'elinor_header_user' ) ) {
    function elinor_header_user()
    {
        get_template_part( 'templates-parts/header', 'user' );
    }
}
/**
 *
 * CUSTOM MOBILE MENU
 */
if ( !function_exists( 'elinor_before_mobile_menu' ) ) {
    function elinor_before_mobile_menu( $menu_locations, $data_menus )
    {
        elinor_get_template(
            "templates-parts/mobile-header.php",
            array(
                'menu_locations' => $menu_locations,
                'data_menus'     => $data_menus,
            )
        );
    }

    add_action( 'ovic_before_html_mobile_menu', 'elinor_before_mobile_menu', 10, 2 );
}
if ( !function_exists( 'elinor_after_mobile_menu' ) ) {
    function elinor_after_mobile_menu( $menu_locations, $data_menus )
    {
        elinor_get_template(
            "templates-parts/mobile-footer.php",
            array(
                'menu_locations' => $menu_locations,
                'data_menus'     => $data_menus,
            )
        );
    }

    add_action( 'ovic_after_html_mobile_menu', 'elinor_after_mobile_menu', 10, 2 );
}
/**
 *
 * MEGAMENU ICON
 */
if ( !function_exists( 'elinor_theme_options_icons' ) ) {
    function elinor_theme_options_icons( $icon )
    {
        elinor_get_template( "templates-parts/icon-options.php" );

        return elinor_get_icon_options( $icon );
    }

    add_filter( 'ovic_field_icon_add_icons', 'elinor_theme_options_icons' );
}
/**
 *
 * MEGAMENU ICON
 */
if ( !function_exists( 'elinor_megamenu_options_icons' ) ) {
    function elinor_megamenu_options_icons()
    {
        elinor_get_template( "templates-parts/icon-megamenu.php" );

        return elinor_get_icon_megamenu();
    }

    add_filter( 'ovic_menu_icons_setting', 'elinor_megamenu_options_icons' );
}
if ( !function_exists( 'elinor_elementor_icons' ) ) {
    function elinor_elementor_icons( $tabs )
    {
        $tabs['main-icon'] = [
            'name'          => 'main-icon',
            'label'         => esc_html__( 'Theme Icons', 'elinor' ),
            'url'           => '',
            'enqueue'       => [],
            'prefix'        => '',
            'displayPrefix' => '',
            'labelIcon'     => 'fab fa-font-awesome-alt',
            'ver'           => '1.0.0',
            'fetchJson'     => get_theme_file_uri( '/assets/json/main-icons.json' ),
            'native'        => true,
        ];

        return $tabs;
    }
}
if ( !function_exists( 'elinor_after_install_sample_data' ) ) {
    function elinor_after_install_sample_data()
    {
        $cpt_support   = get_option( 'elementor_cpt_support', [ 'page', 'post' ] );
        $cpt_support[] = 'ovic_menu';
        $cpt_support[] = 'ovic_footer';

        update_option( 'elementor_cpt_support', $cpt_support );
        update_option( 'elementor_disable_color_schemes', 'yes' );
        update_option( 'elementor_disable_typography_schemes', 'yes' );
        update_option( 'elementor_load_fa4_shim', 'yes' );

        if ( class_exists( 'Elementor\Plugin' ) ) {
            $manager = new Elementor\Core\Files\Manager();
            $manager->clear_cache();
        }
    }
}
/**
 *
 * POPUP NEWSLETTER
 */
if ( !function_exists( 'elinor_popup_newsletter' ) ) {
    function elinor_popup_newsletter()
    {
        global $post;
        $enable = elinor_get_option( 'enable_popup' );
        if ( $enable != 1 ) {
            return;
        }
        if ( isset( $_COOKIE['elinor_disabled_popup_by_user'] ) && $_COOKIE['elinor_disabled_popup_by_user'] == 'true' ) {
            return;
        }
        $page = (array)elinor_get_option( 'popup_page' );
        if ( isset( $post->ID ) && is_array( $page ) && in_array( $post->ID, $page ) && $post->post_type == 'page' ) {
            wp_enqueue_style( 'magnific-popup' );
            wp_enqueue_script( 'magnific-popup' );
            get_template_part( 'templates-parts/popup', 'newsletter' );
        }
    }
}
/**
 *
 * CUSTOM FONT
 */
add_filter( 'elementor/fonts/additional_fonts', 'elinor_elementor_fonts' );
if ( !function_exists( 'elinor_elementor_fonts' ) ) {
    function elinor_elementor_fonts( $additional_fonts )
    {
        return array(
            'Reingttoon'        => 'system',
            'Emerland'          => 'system',
            'Cyclone'           => 'system',
            'SVN-Futura'        => 'system',
        );
    }
}
add_filter( 'ovic_field_typography_customwebfonts', 'elinor_customwebfonts' );
if ( !function_exists( 'elinor_customwebfonts' ) ) {
    function elinor_customwebfonts( $additional_fonts )
    {
        $additional_fonts[] = 'Reingttoon';
        $additional_fonts[] = 'Emerland';
        $additional_fonts[] = 'Cyclone';
        $additional_fonts[] = 'SVN-Futura';

        return $additional_fonts;
    }
}