<?php
if (!class_exists('tnm_overlay_8_data_image')) {
    class tnm_overlay_8_data_image {
        
        function render($postAttr) {
            ob_start();
            $postID = $postAttr['postID'];
            
            if(isset($postAttr['postIcon']) && ($postAttr['postIcon'] != '')) {
                $postIcon = $postAttr['postIcon']; 
            }else {
                $postIcon = '';
            }
            
            if(isset($postAttr['catClass']) && ($postAttr['catClass'] != '')) {
                $catClass = $postAttr['catClass']; 
            }else {
                $catClass = '';
            }
            
            $bk_permalink = get_permalink($postID);
            $bk_post_title = get_the_title($postID);
            $thumbAttr = array (
                'postID'        => $postID,
                'thumbSize'     => $postAttr['thumbSize'],                                
            );
            $theBGLink = tnm_core::bk_get_post_thumbnail_bg_link($thumbAttr);
            if(($theBGLink == '') || ($theBGLink == null)){
                $theBGLink = get_template_directory_uri().'/images/placeholder.jpg';
            }
            ?>
            <article class="post--overlay <?php if(isset($postAttr['additionalClass']) && ($postAttr['additionalClass'] != null)) echo esc_attr($postAttr['additionalClass']);?>">
                <div class="background-img <?php if(isset($postAttr['additionalBGClass']) && ($postAttr['additionalBGClass'] != null)) echo esc_attr($postAttr['additionalBGClass']);?>" style="background-image: url('<?php echo esc_url($theBGLink);?>');" data-image-hover="<?php echo esc_url($theBGLink);?>"></div>
                <div class="post__text <?php if(isset($postAttr['additionalTextClass']) && ($postAttr['additionalTextClass'] != null)) echo esc_attr($postAttr['additionalTextClass']);?>">
                    <div class="post__text-wrap">
                        <div class="post__text-inner <?php if(isset($postAttr['additionalTextInnerClass']) && ($postAttr['additionalTextInnerClass'] != null)) echo esc_attr($postAttr['additionalTextInnerClass']);?>">
                            <div class="post__text-column flexbox-item-1">
                                <?php if(isset($postAttr['cat']) && ($postAttr['cat'] != 0) && ($postAttr['cat'] != '1')): ?>
                                <?php echo tnm_core::bk_get_post_cat_link($postID, $catClass);?>
                                <?php endif; ?>
                                <h3 class="post__title <?php if(isset($postAttr['typescale'])) echo esc_attr($postAttr['typescale']);?>"><?php echo tnm_core::bk_get_post_title_link(get_the_ID());?></h3>
                                <?php
                                if (isset($postAttr['meta']) && ($postAttr['meta'] != '')) :
                                    echo '<div class="post__meta">';
                                    echo tnm_core::bk_get_post_meta($postAttr['meta']);
                                    echo '</div>';
                                endif;
                                ?>
                            </div>
                            <?php if (isset($postAttr['readmore']) && ($postAttr['readmore'] != '')) : ?>
                            <div class="post__text-column flexbox-wrap flexbox-center-y">

                                <div class="post__readmore <?php if(isset($postAttr['additionalReadmoreClass']) && ($postAttr['additionalReadmoreClass'] != null)) echo esc_attr($postAttr['additionalReadmoreClass']);?>">
                                    <a href="<?php echo esc_url($bk_permalink);?>" class="button__readmore">
                                        <span class="readmore__text"> <i class="mdicon mdicon mdicon-arrow_forward"></i></span>
                                    </a>
                                </div>

                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php 
                    if($postIcon != '') :
                        echo tnm_core::bk_get_post_icon($postID, $postIcon);
                    endif;
                    ?>
                </div>
                <a href="<?php echo esc_url($bk_permalink);?>" class="link-overlay"></a>
            </article>
            <?php return ob_get_clean();
        }
        
    }
}