<?php
if (!class_exists('tnm_overlay_5')) {
    class tnm_overlay_5 {
        
        function render($postAttr) {
            ob_start();
            $postID = $postAttr['postID'];
            
            if(isset($postAttr['postIcon']) && ($postAttr['postIcon'] != '')) {
                $postIcon = $postAttr['postIcon']; 
            }else {
                $postIcon = '';
            }
            
            if(isset($postAttr['catClass']) && ($postAttr['catClass'] != '')) {
                $catClass = $postAttr['catClass']; 
            }else {
                $catClass = '';
            }
            
            $bk_permalink = get_permalink($postID);
            $bk_post_title = get_the_title($postID);
            $thumbAttr = array (
                'postID'        => $postID,
                'thumbSize'     => $postAttr['thumbSize'],                                
            );
            $theBGLink = tnm_core::bk_get_post_thumbnail_bg_link($thumbAttr);
            ?>
            <article class="post--overlay <?php if(isset($postAttr['additionalClass']) && ($postAttr['additionalClass'] != null)) echo esc_attr($postAttr['additionalClass']);?>">
                <div class="background-img <?php if(isset($postAttr['additionalBGClass']) && ($postAttr['additionalBGClass'] != null)) echo esc_attr($postAttr['additionalBGClass']);?>" style="background-image: url('<?php echo esc_url($theBGLink);?>');"></div>
                <div class="post__text <?php if(isset($postAttr['additionalTextClass']) && ($postAttr['additionalTextClass'] != null)) echo esc_attr($postAttr['additionalTextClass']);?>">
                    <div class="post__text-wrap">
                        <div class="post__text-inner <?php if(isset($postAttr['additionalTextInnerClass']) && ($postAttr['additionalTextInnerClass'] != null)) echo esc_attr($postAttr['additionalTextInnerClass']);?>">
                            <?php if(isset($postAttr['cat']) && ($postAttr['cat'] != 0) && ($postAttr['cat'] != '1')) echo tnm_core::bk_get_post_cat_link($postID, $catClass);?>
                            <h3 class="post__title <?php if(isset($postAttr['typescale'])) echo esc_attr($postAttr['typescale']);?>"><?php echo tnm_core::bk_get_post_title_link(get_the_ID());?></h3>
                            <?php if(isset($postAttr['except_length']) && ($postAttr['except_length'] != null) && (tnm_core::bk_get_post_excerpt($postAttr['except_length']) != '')) {?>
                            <div class="post__excerpt <?php if(isset($postAttr['additionalExcerptClass']) && ($postAttr['additionalExcerptClass'] != null)) echo esc_attr($postAttr['additionalExcerptClass']);?>">
                                <?php echo tnm_core::bk_get_post_excerpt($postAttr['except_length']);?>
                            </div>
                            <?php }?>
                            <?php
                            if (isset($postAttr['meta']) && ($postAttr['meta'] != '')) :
                                echo '<div class="post__meta">';
                                echo tnm_core::bk_get_post_meta($postAttr['meta'], $metaSeperator);
                                echo '</div>';
                            endif;
                            ?>
                            <?php if (isset($postAttr['readmore']) && ($postAttr['readmore'] != '')) : ?>
                            <div class="post__readmore <?php if(isset($postAttr['additionalReadmoreClass']) && ($postAttr['additionalReadmoreClass'] != null)) echo esc_attr($postAttr['additionalReadmoreClass']);?>">
                                <a href="<?php echo esc_url($bk_permalink);?>" class="button__readmore">
                                    <span class="readmore__text"><?php esc_html_e('See More','the-next-mag');?> <i class="mdicon mdicon mdicon-arrow_forward"></i></span>
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <?php 
                if($postIcon != '') :
                    echo tnm_core::bk_get_post_icon($postID, $postIcon);
                endif;
                ?>
                <a href="<?php echo esc_url($bk_permalink);?>" class="link-overlay"></a>
                <?php if(isset($postAttr['cat']) && ($postAttr['cat'] == '1')) echo tnm_core::bk_get_post_cat_link($postID, $catClass);?>
            </article>
            <?php return ob_get_clean();
        }
        
    }
}