<?php
$tnm_default_options = array
(
    'last_tab' => '',
    'bk-primary-color' => '#EF3A2B',
    'bk-dark-color' => '#23282D',
    'bk-button-hover-color' => '#ef392b',
    'body-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'subsets' => '',
            'letter-spacing' => '',
        ),
    'heading-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'subsets' => '',
            'letter-spacing' => '',
        ),
    'meta-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'subsets' => '',
            'letter-spacing' => '',
        ),
    'tertiary-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'subsets' => '',
            'letter-spacing' => '',
        ),
    'bk-load-more-text' => 'Load more news',
    'bk-no-more-text' => 'No more news',
    'bk-default-module-heading' => 'line',
    'bk-default-widget-heading' => 'line',
    'bk-header-type' => 'site-header-1',
    'bk-header-bg-style' => 'default',
    'bk-header-bg-image' => array
        (
            'background-image' => '',
            'media' => array
                (
                    'id' => '',
                    'height' => '',
                    'width' => '',
                    'thumbnail' => '',
                ),
        ),
    'bk-header-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-header-bg-gradient-direction' => '',
    'bk-header-bg-color' => array
        (
            'background-color' => '#fff',
        ),
    'bk-header-inverse' => '0',
    'bk-sticky-menu-switch' => '1',
    'bk-sticky-menu-bg-style' => 'default',
    'bk-sticky-menu-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-sticky-menu-bg-gradient-direction' => '',
    'bk-sticky-menu-bg-color' => array
        (
            'background-color' => '#fff',
        ),
    'bk-sticky-menu-inverse' => '0',
    'bk-mobile-menu-bg-style' => 'default',
    'bk-mobile-menu-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-mobile-menu-bg-gradient-direction' => '',
    'bk-mobile-menu-bg-color' => array
        (
            'background-color' => '#fff',
        ),
    'bk-mobile-menu-inverse' => '0',
    'bk-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'site-logo-width' => '300',
    'bk-mobile-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'bk-offcanvas-desktop-switch' => '1',
    'bk-offcanvas-desktop-menu' => 'offcanvas-menu',
    'bk-offcanvas-desktop-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'bk-offcanvas-desktop-subscribe-switch' => '0',
    'bk-offcanvas-desktop-mailchimp-shortcode' => '',
    'bk-offcanvas-mobile-menu' => 'main-menu',
    'bk-offcanvas-mobile-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'bk-offcanvas-mobile-subscribe-switch' => '0',
    'bk-offcanvas-mobile-mailchimp-shortcode' => '',
    'bk-social-header' => array(),
    'bk-header-subscribe-switch' => '0',
    'bk-mailchimp-title' => '',
    'bk-mailchimp-shortcode' => '',
    'bk-social-media-links' => array
        (
            'fb' => '',
            'twitter' => '',
            'gplus' => '',
            'linkedin' => '',
            'pinterest' => '',
            'instagram' => '',
            'dribbble' => '',
            'youtube' => '',
            'vimeo' => '',
            'vk' => '',
            'vine' => '',
            'snapchat' => '',
            'rss' => '',
        ),
    'bk-post-view--cache-time' => '300',
    'bk-single-template' => 'single-1',
    'bk-single-header--bg-color' => '#12162d',
    'bk-single-header--bg-pattern' => '1',
    'bk-single-header--inverse' => '1',
    'bk-feat-img-status' => '1',
    'bk-single-meta-items' => '8',
    'single-sections-sorter' => array
        (
            'enabled' => array
                (
                    'placebo' => 'placebo',
                    'related' => 'Related Section',
                    'comment' => 'Comment Section',
                    'same-cat' => 'Same Category Section',
                ),
        ),
    'bk_post_sb_select' => 'home_sidebar',
    'bk_post_sb_position' => 'right',
    'bk_post_sb_sticky' => '1',
    'bk-sharebox-sw' => '1',
    'bk-fb-sw' => '1',
    'bk-fb-text' => 'Share',
    'bk-tw-sw' => '1',
    'bk-tw-text' => 'Tweet',
    'bk-gp-sw' => '1',
    'bk-gp-text' => '',
    'bk-pi-sw' => '1',
    'bk-pi-text' => '',
    'bk-stu-sw' => '1',
    'bk-stu-text' => '',
    'bk-li-sw' => '1',
    'bk-li-text' => '',
    'bk-authorbox-sw' => '1',
    'bk-postnav-sw' => '1',
    'bk-related-sw' => '0',
    'bk_related_post_layout' => 'listing_grid',
    'bk_related_heading_style' => 'no-line',
    'bk_related_source' => 'category_tag',
    'bk_number_related' => '3',
    'bk_related_post_category' => 1,
    'bk_related_post_excerpt' => '0',
    'bk_related_post_meta' => '3',
    'bk_related_post_icon' => 'disable',
    'bk-same-cat-sw' => '0',
    'bk_same_cat_post_layout' => 'listing_grid',
    'bk_same_cat_heading_style' => 'no-line',
    'bk_same_cat_number_posts' => '3',
    'bk_same_cat_post_category' => 1,
    'bk_same_cat_post_excerpt' => '0',
    'bk_same_cat_post_meta' => '3',
    'bk_same_cat_post_icon' => 'disable',
    'bk_same_cat_more_link' => '',
    'bk-related-sw-wide' => '1',
    'bk_related_heading_style_wide' => 'no-line',
    'bk_related_source_wide' => 'category_tag',
    'bk_related_post_icon_wide' => 'disable',
    'bk-same-cat-sw-wide' => '1',
    'bk_same_cat_heading_style_wide' => 'no-line',
    'bk_same_cat_post_icon_wide' => 'disable',
    'bk_same_cat_more_link_wide' => '1',
    'bk_category_feature_area' => 'mosaic_a',
    'bk_category_feature_area__post_option' => 'latest',
    'bk_feature_area__show_hide' => '0',
    'bk_category_header_style' => 'grey-bg',
    'bk_category_content_layout' => 'listing_list',
    'bk_category_post_icon' => 'disable',
    'bk_category_pagination' => 'default',
    'bk_category_exclude_posts' => '1',
    'bk_category_sidebar_select' => 'home_sidebar',
    'bk_category_sidebar_position' => 'right',
    'bk_category_sidebar_sticky' => '1',
    'bk_archive_header_style' => 'grey-bg',
    'bk_archive_content_layout' => 'listing_list',
    'bk_archive_pagination' => 'default',
    'bk_archive_sidebar_select' => 'home_sidebar',
    'bk_archive_sidebar_position' => 'right',
    'bk_archive_sidebar_sticky' => '1',
    'bk_author_content_layout' => 'listing_list',
    'bk_author_pagination' => 'default',
    'bk_author_sidebar_select' => 'home_sidebar',
    'bk_author_sidebar_position' => 'right',
    'bk_author_sidebar_sticky' => '1',
    'bk_search_content_layout' => 'listing_list',
    'bk_search_pagination' => 'default',
    'bk_author_results_active' => '1',
    'bk_author_results_entries' => '',
    'bk_author_results_pagination' => 'ajax-pagination',
    'bk_search_sidebar_select' => 'home_sidebar',
    'bk_search_sidebar_position' => 'right',
    'bk_search_sidebar_sticky' => '1',
    '404-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    '404-logo-width' => '200',
    'bk-404-image' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    '404--main-text' => '',
    '404--sub-text' => '',
    '404-search' => '1',
    'bk_page_header_style' => 'grey-bg',
    'bk_page_feat_img' => '1',
    'bk_page_layout' => 'has_sidebar',
    'bk_page_sidebar_select' => 'home_sidebar',
    'bk_page_sidebar_position' => 'right',
    'bk_page_sidebar_sticky' => '1',
    'bk-footer-template' => 'footer-1',
    'bk-footer-bg-style' => 'default',
    'bk-footer-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-footer-bg-gradient-direction' => '',
    'bk-footer-bg-color' => array
        (
            'background-color' => '#333',
        ),
    'bk-footer-pattern' => '0',
    'bk-footer-inverse' => '0',
    'footer-col-scale' => '1',
    'footer-col-1' => 'footer_sidebar_1',
    'footer-col-2' => 'footer_sidebar_2',
    'footer-col-3' => 'footer_sidebar_3',
    'bk-footer--mailchimp-bg' => array
        (
            'background-image' => '',
            'media' => array
                (
                    'id' => '',
                    'height' => '',
                    'width' => '',
                    'thumbnail' => '',
                ),
        ),
    'footer-mailchimp--shortcode' => '',
    'bk-footer-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'footer-logo-width' => '200',
    'footer-copyright-text' => '',
);
if (!class_exists('tnm_core')) {
    class tnm_core {
        
        static $globalBuff = array();
        
        static $globalGradientBG = array();
        
        static function bk_get_global_var($bk_var){  
            if ($bk_var == 'tnm_option') {
                if ( defined( 'TNM_FUNCTIONS_PLUGIN_DIR' ) ) {
                    global $tnm_option;
                    return $tnm_option;
                }else {
                    global $tnm_default_options;
                    return $tnm_default_options;
                }
            }
        }
        static function bk_get_theme_option($theoption = '') {
            $tnm_option = tnm_core::bk_get_global_var('tnm_option');
            $output = '';
            
            if ((isset($tnm_option[$theoption])) && (($tnm_option[$theoption]) != NULL)){ 
                $output = $tnm_option[$theoption];
            }else {
                $output = '';
            }
            
            return $output;
        }
        static function tnm_rwmb_meta($theoption, $arg, $termID ){
            $ret = '';
            if(function_exists('rwmb_meta')) {
                $ret = rwmb_meta( $theoption, $arg, $termID );  
            }else {
                $ret = '';
            }
            return $ret;
        }
        static function bk_check_isset($var, $strCompare) {
            if(isset($var) && ($var != $strCompare)) {
                return 1;
            }else {
                return 0;
            }
        }
        static function bk_check_array($var) {
            if((is_array($var) && (count($var) > 0))) {
                return true;
            }else {
                return false;
            }
        }
/**
* ************* Post Views *********************
*---------------------------------------------------
*/ 
        static function bk_getPostViews($postID){
            $count_key = 'post_views_count';
            $count = get_post_meta($postID, $count_key, true);
            if($count==''){
                delete_post_meta($postID, $count_key);
                add_post_meta($postID, $count_key, '0');
                return "0";
           }
           return $count;
        }
        static function bk_setPostViews($postID){
            $count_key = 'post_views_count';
            $count = get_post_meta($postID, $count_key, true);
            if($count==''){
                $count = 0;
                delete_post_meta($postID, $count_key);
                add_post_meta($postID, $count_key, '0');
            }else{
                $count++;
                update_post_meta($postID, $count_key, $count);
            }
            return false;   
        }
/**
* ************* Socical Media Links *********************
*---------------------------------------------------
*/    
        static function bk_get_social_media_links($socialOptions){
            $socialHTML = '';
            $tnm_option = tnm_core::bk_get_global_var('tnm_option');
            
            if(isset($tnm_option['bk-social-media-links'])):
                $socialItems = $tnm_option['bk-social-media-links'];
            endif;
            
            foreach($socialOptions as $socialItem) :
                switch ($socialItem) {
                    case 'fb':
                        if ($socialItems['fb']){
                            $socialHTML .= '<li><a href="'.$socialItems['fb'].'" target="_blank"><i class="mdicon mdicon-facebook"></i></a></li>';
            			}
                        break;
                    case 'twitter' :
                        if ($socialItems['twitter']){
            				$socialHTML .= '<li><a href="'.$socialItems['twitter'].'" target="_blank"><i class="mdicon mdicon-twitter"></i></a></li>';
            			}
                        break;
                    case 'gplus' :
                        if ($socialItems['gplus']){
            				$socialHTML .= '<li><a href="'.$socialItems['gplus'].'" target="_blank"><i class="mdicon mdicon-google-plus"></i></a></li>';
            			}
                        break;
                    case 'linkedin' :
                        if ($socialItems['linkedin']){
            				$socialHTML .= '<li><a href="'.$socialItems['linkedin'].'" target="_blank"><i class="mdicon mdicon-linkedin"></i></a></li>';
            			}
                        break;
                    case 'pinterest' :
                        if ($socialItems['pinterest']){
            				$socialHTML .= '<li><a href="'.$socialItems['pinterest'].'" target="_blank"><i class="mdicon mdicon-pinterest-p"></i></a></li>';
            			}
                        break;
                    case 'instagram' :
                        if ($socialItems['instagram']){
            				$socialHTML .= '<li><a href="'.$socialItems['instagram'].'" target="_blank"><i class="mdicon mdicon-instagram"></i></a></li>';
            			}
                        break;
                    case 'dribbble';
                        if ($socialItems['dribbble']){
            				$socialHTML .= '<li><a href="'.$socialItems['dribbble'].'" target="_blank"><i class="mdicon mdicon-dribbble"></i></a></li>';
            			}
                        break;
                    case 'youtube';
                        if ($socialItems['youtube']){
            				$socialHTML .= '<li><a href="'.$socialItems['youtube'].'" target="_blank"><i class="mdicon mdicon-youtube"></i></a></li>';
            			}
                        break;
                    case 'vimeo';
                        if ($socialItems['vimeo']){
            				$socialHTML .= '<li><a href="'.$socialItems['vimeo'].'" target="_blank"><i class="mdicon mdicon-vimeo"></i></a></li>';
            			}
                        break;
                    case 'vk';
                        if ($socialItems['vk']){
            				$socialHTML .= '<li><a href="'.$socialItems['vk'].'" target="_blank"><i class="mdicon mdicon-vk"></i></a></li>';
            			}
                        break;
                    case 'vine';
                        if ($socialItems['vine']){
            				$socialHTML .= '<li><a href="'.$socialItems['vine'].'" target="_blank"><i class="mdicon mdicon-vine"></i></a></li>';
            			}
                        break;
                    case 'snapchat';
                        if ($socialItems['snapchat']){
            				$socialHTML .= '<li><a href="'.$socialItems['snapchat'].'" target="_blank"><i class="mdicon mdicon-snapchat-ghost"></i></a></li>';
            			}
                        break;
                    case 'telegram';
                        if ($socialItems['telegram']){
            				$socialHTML .= '<li><a href="'.$socialItems['telegram'].'" target="_blank"><i class="mdicon mdicon-telegram"></i></a></li>';
            			}
                        break;
                    case 'rss';
                        if ($socialItems['rss']){
            				$socialHTML .= '<li><a href="'.$socialItems['rss'].'" target="_blank"><i class="mdicon mdicon-rss_feed"></i></a></li>';
            			}
                        break;
                    default:
                        break;
                }
            endforeach;
            
            return $socialHTML;
        }
    
        static function bk_get_block_heading($bk_heading, $headingClass = '', $viewallButton = ''){
            $tnm_option = tnm_core::bk_get_global_var('tnm_option');
            $block_heading = '';
            
            //Check default heading condition
            if( isset($tnm_option['bk-default-module-heading']) && 
               (($tnm_option['bk-default-module-heading'] == 'center')            || 
                ($tnm_option['bk-default-module-heading'] == 'large-center')      || 
                ($tnm_option['bk-default-module-heading'] == 'line-around')       || 
                ($tnm_option['bk-default-module-heading'] == 'large-line-around')) ){
                $viewallButton = '';
            }
            if($bk_heading != null) {
                $heading_allow_html = array(
                    'span' => array(),
                );
                $block_heading .= '<div class="block-heading '.$headingClass.'">';
    			$block_heading .= '<h4 class="block-heading__title">'.wp_kses($bk_heading, $heading_allow_html).'</h4>';
                if(($viewallButton != '') && (isset($viewallButton['view_all_link']) && ($viewallButton['view_all_link'] != ''))) {
                    if(isset($viewallButton['view_all_text']) && ($viewallButton['view_all_text'] != '')) {
                        $viewAllText = $viewallButton['view_all_text'];
                    }else {
                        $viewAllText = esc_html__('View all','the-next-mag');
                    }
                    if(isset($viewallButton['view_all_link']) && ($viewallButton['view_all_link'] != '')) {
                        $viewAllLink = $viewallButton['view_all_link'];
                    }else {
                        $viewAllLink = '#';
                    }
                    if(isset($viewallButton['view_all_target']) && ($viewallButton['view_all_target'] != '')) {
                        $viewAllTarget = $viewallButton['view_all_target'];
                    }else {
                        $viewAllTarget = '_blank';
                    }

                    $block_heading .= '<a href="'.esc_url($viewAllLink).'" target="'.esc_attr($viewAllTarget).'" class="block-heading__secondary">';
                    $block_heading .= '<span class="first-word">'.esc_attr($viewAllText).'</span>';
                    $block_heading .= '<i class="mdicon mdicon-arrow_forward mdicon--last"></i>';
                    $block_heading .= '</a>';
                }
    			$block_heading .= '</div>';
            }
            return $block_heading;
        }
        static function bk_get_block_heading_class($headingStyle = '', $heading_inverse = 'no'){
            $tnm_option = tnm_core::bk_get_global_var('tnm_option');
            $headingClass = '';
            
            //Check default heading condition
            if(($headingStyle == 'default') && isset($tnm_option['bk-default-module-heading'])) {
                $headingStyle = $tnm_option['bk-default-module-heading'];
            }
            switch($headingStyle) {
                case 'line':
                    $headingClass = 'block-heading--line';
                    break;
                case 'large-line':
                    $headingClass = 'block-heading--line block-heading--lg';
                    break;
                case 'no-line':
                    $headingClass = '';
                    break;
                case 'large-no-line':
                    $headingClass = 'block-heading--lg';
                    break;
                case 'line-under':
                    $headingClass = 'block-heading--line-under';
                    break;
                case 'large-line-under':
                    $headingClass = 'block-heading--lg block-heading--line-under';
                    break;
                case 'center':
                    $headingClass = 'block-heading--center';
                    break; 
                case 'large-center':
                    $headingClass = 'block-heading--lg block-heading--center';
                    break;    
                case 'line-around':
                    $headingClass = 'has-block-heading-line-around';
                    break;
                case 'large-line-around':
                    $headingClass = 'block-heading--lg has-block-heading-line-around';
                    break;
                default:
                    $headingClass = 'block-heading--line';
                    break;
            }
            if($heading_inverse == 'yes') {
                $headingClass .= ' block-heading--inverse';
            }
            return $headingClass;
        }
        static function bk_get_widget_heading_class($headingStyle = '', $heading_inverse = 'no'){
            $tnm_option = tnm_core::bk_get_global_var('tnm_option');
            $headingClass = '';
            
            //Check force condition
            if(($headingStyle == 'default') && isset($tnm_option['bk-default-widget-heading'])) {
                $headingStyle = $tnm_option['bk-default-widget-heading'];
            }
            switch($headingStyle) {
                case 'line':
                    $headingClass = 'block-heading--line';
                    break;
                case 'no-line':
                    $headingClass = '';
                    break;
                case 'line-under':
                    $headingClass = 'block-heading--line-under';
                    break;
                case 'center':
                    $headingClass = 'block-heading--center';
                    break;    
                case 'line-around':
                    $headingClass = 'has-block-heading-line-around';
                    break;
                default:
                    $headingClass = 'block-heading--line';
                    break;
            }
            if($heading_inverse == 'yes') {
                $headingClass .= ' block-heading--inverse';
            }
            return $headingClass;
        }
        static function bk_get_post_excerpt($length) {
            $bk_excerpt = '';
            $the_excerpt = get_the_excerpt();
            if($the_excerpt != ''){
                $bk_excerpt .= '<div class="excerpt">';
                $bk_excerpt .= self::the_excerpt_limit_by_word($the_excerpt, $length); 
                $bk_excerpt .= '</div>';
            }
            return $bk_excerpt;
        }
        static function the_excerpt_limit_by_word($string, $word_limit){
            $words = explode(' ', $string, ($word_limit + 1));
            if(count($words) > $word_limit)
            array_pop($words);
            $strout = implode(' ', $words);
            if (strlen($strout) < strlen($string))
                $strout .=" ...";
            return $strout;
        }
        static function bk_add_buff($buffType= '', $buffID = '', $buffContent = '', $val = ''){  
            
            if($buffType != '') :
                if($buffID != '') :
                    //self::$globalBuff[$buffType][$buffID] = '';
                    if($buffContent != '') :
                        self::$globalBuff[$buffType][$buffID][$buffContent] = $val;
                    endif;
                endif;
            endif;
            
        }
        static function tnm_create_ajax_security_code(){
            $tnm_security_code = wp_create_nonce( 'tnm_ajax_security' );
            self::bk_add_buff('tnm_security', 'tnm_security_code', 'content', $tnm_security_code);
        }
        static function bk_get_sub_categories($bkParentCat) {  
            $catList = array();
            $args = array('child_of' => $bkParentCat);
            $categories = get_categories( $args );
            if(count($categories) > 0) {
                foreach($categories as $key => $category) { 
                    //$catList[$key] = '<a class="post__cat post__cat--bg cat-theme-bg" href="' . get_category_link( $category->term_id ) . '" title="'.$category->name.'" ' . '>' . $category->name.'</a>';
                    $catList[$key] = $category;
                }
            }
            return $catList;
            
        }
        static function bk_get_post_title_link( $bkPostId ) {
            $titleLink = '';
            $category = get_the_category($bkPostId); 
            $titleLink .= '<a href="'.get_permalink($bkPostId).'">';
            $titleLink .= get_the_title($bkPostId);
            $titleLink .= '</a>';
            return $titleLink;
        }
        static function bk_get_post_icon_video_only ($bkPostID) {
            $str_ret = '';
            $postformat = get_post_format( $bkPostID );
            switch($postformat) {
                case "video":
                    $str_ret = '<span><i class="fa fa-play post-icon video-icon"></i></span>';
                    break;
                default:
                    $str_ret = '';
                    break;
            }
            return $str_ret;
        }
        static function bk_check_has_post_thumbnail($postID){
            if($postID == '') {
                $postID = get_the_ID();
            }
            $featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( $postID ) );
            if  ( ! empty( $featured_image_url ) ) {
                return true;
            }else {
                return false;
            }
        }
        static function get_feature_image($postID = '', $thumbSize = '', $clickable = true, $postIcon = ''){
            $feat_img = '';
            
            if($postID == '') {
                $postID = get_the_ID();
            }
            
            if(tnm_core::bk_check_has_post_thumbnail($postID)) { 
                if($clickable == true) {
                    $feat_img .= '<a href="'.get_permalink($postID).'">';
                }
                
                $feat_img .= get_the_post_thumbnail($postID, $thumbSize);
                
                if($postIcon != '') {
                    $feat_img .= self::bk_get_post_icon($postID, $postIcon);
                }
                
                if($clickable == true) {
                    $feat_img .= '</a> <!-- close a tag -->';
                }
            }
            return $feat_img;
        }
        static function bk_get_post_thumbnail_bg_link($customArgs){
            $bkThumbId = get_post_thumbnail_id( $customArgs['postID'] );
            $bkThumbUrl = wp_get_attachment_image_src( $bkThumbId, $customArgs['thumbSize'] );
            
            return esc_url($bkThumbUrl[0]);
        }
/**
 * ********* Get Post Category ************
 *---------------------------------------------------
 */ 
        static function bk_get_post_cat_link($postID, $catClass = '', $allowALL = ''){
            $html = '';
            $category = get_the_category($postID); 
            if(isset($category[0]) && $category[0]){
                foreach ($category as $key => $value) {
                    $html.= '<a class="cat-'.$value->term_id.' '.$catClass.'" href="'.get_category_link($value->term_id ).'">'.$value->cat_name.'</a>';  
                    if($allowALL != 1) return $html;
                }
            }
            return $html;
        }
/**
* ********* Count Post Category ************
*---------------------------------------------------
*/ 
        static function bk_count_post_in_category($categoryIDs){
            $html = '';
            $category = array();
            $postCount = array();
            $catArray = array();
            if($categoryIDs[0] == 0) {
                $catArray = get_terms(
                    array( 'category' ), // Taxonomies
                    array( 'fields' => 'ids' ) // Fields
                ); 
            }else {
                $catArray = $categoryIDs;
            }     
            foreach ($catArray as $key => $catID) {               
                $category[$key] = get_category($catID); 
                $postCount[$catID] = $category[$key]->category_count;
            }
            return $postCount;
        }
/**
* ************* Meta Cases *********************
*---------------------------------------------------
*/ 
        static function bk_get_comment_number_and_text ($postID) {
            $comments = '';
            $num_comments = get_comments_number($postID);
            if ( $num_comments == 0 ) {
        		$comments = esc_html__('0 Comments', 'the-next-mag');
        	} elseif ( $num_comments > 1 ) {
        		$comments = $num_comments . esc_html__(' Comments', 'the-next-mag');
        	} else {
        		$comments = esc_html__('1 Comment', 'the-next-mag');
        	}
            return $comments;
        }
        static function bk_meta_cases( $meta_type ) {
            $bk_meta = $meta_type;
            $postID = get_the_ID();
            $tnm_article_date_unix = get_the_time('U', $postID);      
            $bk_meta_str = '';
            switch ($bk_meta) {
                case 'date':
                    $timestamp_lastweek  = strtotime("-1 week");
                    $timestamp_post      = get_the_time('U', $postID);
                    if($timestamp_post <= $timestamp_lastweek) {
                        $bk_meta_str .= '<time class="time published" datetime="'.date(DATE_W3C, $tnm_article_date_unix).'" title="'.get_the_time('F j, Y \a\t g:i a', $postID) .'"><i class="mdicon mdicon-schedule"></i>'.get_the_date('', $postID).'</time>';
                    }else {
                        $bk_meta_str .= '<time class="time published" datetime="'.date(DATE_W3C, $tnm_article_date_unix).'" title="'.get_the_time('F j, Y \a\t g:i a', $postID) .'"><i class="mdicon mdicon-schedule"></i>'.human_time_diff( get_the_time('U'), current_time('timestamp') ) . esc_html__(' ago', 'the-next-mag') .'</time>';
                    }
                    break;
                case 'date_without_icon':
                    $timestamp_lastweek  = strtotime("-1 week");
                    $timestamp_post      = get_the_time('U', $postID);
                    if($timestamp_post <= $timestamp_lastweek) {
                        $bk_meta_str .= '<time class="time published" datetime="'.date(DATE_W3C, $tnm_article_date_unix).'" title="'.get_the_time('F j, Y \a\t g:i a', $postID) .'">'.get_the_date('', $postID).'</time>';
                    }else {
                        $bk_meta_str .= '<time class="time published" datetime="'.date(DATE_W3C, $tnm_article_date_unix).'" title="'.get_the_time('F j, Y \a\t g:i a', $postID) .'">'.human_time_diff( get_the_time('U'), current_time('timestamp') ) . esc_html__(' ago', 'the-next-mag') .'</time>';
                    }
                    break;
                case 'author':
                    $bk_meta_str .=  '<span class="entry-author"> '.esc_html__('By ', 'the-next-mag');
                    $bk_meta_str .=  '<a class="entry-author__name" href="'. get_author_posts_url(get_the_author_meta( 'ID' )).'">'. get_the_author() .'</a>';          
                    $bk_meta_str .=  '</span>';
                    break;
                case 'bg':
                    $thumb130 = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'tnm-xxs-1_1');
                    $bk_meta_str .=  '<div class="meta-bg" style="background-image:url('.$thumb130['0'].');background-size:cover;background-position:50% 50%;background-repeat:no-repeat;"></div>';
                    break;
                case 'view':
                    if(self::bk_getPostViews($postID) > 1) {
                        $bk_meta_str .=  '<span><i class="mdicon mdicon-visibility"></i>'. self::bk_getPostViews($postID) .' '. esc_html__('views', 'the-next-mag') .'</span>';
                    }else {
                        $bk_meta_str .=  '<span><i class="mdicon mdicon-visibility"></i>'. self::bk_getPostViews($postID) .' '. esc_html__('view', 'the-next-mag') .'</span>';
                    }
                    break;
                case 'comment':
                    $bk_meta_str .=  '<span><a title="'.self::bk_get_comment_number_and_text($postID).'" href="'.get_permalink($postID).'"><i class="mdicon mdicon-chat_bubble_outline"></i>'.get_comments_number($postID).'</a></span>';                  
                    break;
                case 'comment_text':
                    $bk_meta_str .=  '<span><a title="'.self::bk_get_comment_number_and_text($postID).'" href="'.get_permalink($postID).'"><i class="mdicon mdicon-chat_bubble_outline"></i>'.self::bk_get_comment_number_and_text($postID).'</a></span>';                  
                    break;
                default:
                    esc_html_e('No Case Matched!', 'the-next-mag');
            }
            return $bk_meta_str;
        }
    
        static function bk_get_post_meta( $meta_arg, $metaSeperator = 0 ) {
            $bk_meta = '';
            $seperator = '';
            if($metaSeperator == 1) {
                $seperator = '<span class="meta-seperator">&middot;</span>';
            }
            if ((isset($meta_arg[0])) && ($meta_arg[0] != null)) {
                $bk_meta .= self::bk_meta_cases($meta_arg[0]);
            }
            if ((isset($meta_arg[1])) && ($meta_arg[1] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[1]);
            }
            if ((isset($meta_arg[2])) && ($meta_arg[2] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[2]);
            }
            if ((isset($meta_arg[3])) && ($meta_arg[3] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[3]);
            }
            if ((isset($meta_arg[4])) && ($meta_arg[4] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[4]);
            }
            if ((isset($meta_arg[5])) && ($meta_arg[5] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[5]);
            }
            if ((isset($meta_arg[6])) && ($meta_arg[6] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[6]);
            }
            if ((isset($meta_arg[7])) && ($meta_arg[7] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[7]);
            }
            return $bk_meta;
        }
        static function bk_count_gallery_length($postID){
            $postFormat = self::bk_post_format_detect($postID);
            $galleryLength = 0;
            if($postFormat == 'gallery') :
                $galleryImages = self::tnm_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
                $galleryLength = count($galleryImages); 
            endif;
            
            return $galleryLength;
        }
/**
 *  Review Score Star
 */ 
        static function bk_get_post_score_star( $reviewScore = 0 ) {
            $starHalf = '<span class="mdicon mdicon-star_half">';
            $starHTML = '';
            $starCount = intval($reviewScore/2);
            $i = 0;
            for($i = 0; $i < $starCount; $i++) {
                $starHTML .= '<span class="mdicon mdicon-star"></span>';
            }
            if($reviewScore%2){
                $starHTML .= '<span class="mdicon mdicon-star_half">';
            }
            return $starHTML;
        }
/**
 * Return Post Format
 */
        static function bk_post_format_detect($postID) { 
            if(function_exists('has_post_format')) {
                if(get_post_format( $postID ) != '') {
                    return get_post_format( $postID );
                }else {
                    //Is this review post?
                    $reviewCheck = get_post_meta($postID, 'bk_review_checkbox', true );
                    if($reviewCheck == 1) {
                        $postScore = get_post_meta($postID, 'bk_review_score', true );
                        if(($postScore != 0) && ($postScore != '')) {
                            return 'review';
                        }else {
                            return '';
                        }
                    }else {
                        return '';
                    }
                }
            }else {
                return '';
            }
        }
        static function bk_get_post_icon($postID, $postIcon){
            $postIconStr = '';
            if($postID == ''){
                $postID = $postID;
            }
            if(isset($postIcon['postIconClass'])) {
                $iconClass = $postIcon['postIconClass'];
            }else {
                $iconClass = '';
            }
            if($postIcon['iconType'] == 'gallery') {
                $postIconStr .= '<div class="'.$iconClass.'">';
				$postIconStr .= '<i class="mdicon mdicon-filter"></i><span>'.self::bk_count_gallery_length($postID).'</span>';
				$postIconStr .= '</div>';
            }elseif($postIcon['iconType'] == 'review') {
                $reviewScore  = get_post_meta($postID, 'bk_review_score', true);
                $postIconStr  = '<div class="'.$iconClass.'">';
                $postIconStr .= '<div class="post-score-hexagon '.$postID.'">';
				$postIconStr .= '<svg class="hexagon-svg" version="1.1" xmlns="http://www.w3.org/2000/svg" viewbox="-5 -5 184 210">';
				$postIconStr .= '<g>';
				$postIconStr .= '<path fill="#FC3C2D" stroke="#fff" stroke-width="10px" d="M81.40638795573723 2.9999999999999996Q86.60254037844386 0 91.7986928011505 2.9999999999999996L168.0089283341811 47Q173.20508075688772 50 173.20508075688772 56L173.20508075688772 144Q173.20508075688772 150 168.0089283341811 153L91.7986928011505 197Q86.60254037844386 200 81.40638795573723 197L5.196152422706632 153Q0 150 0 144L0 56Q0 50 5.196152422706632 47Z"></path>';
				$postIconStr .= '</g>';
				$postIconStr .= '</svg>';
				$postIconStr .= '<span class="post-score-value">'.$reviewScore.'</span>';
				$postIconStr .= '</div>';
                $postIconStr .= '</div>';
            }elseif($postIcon['iconType'] == 'video') {
                $postIconStr .= '<div class="post-type-icon '.$iconClass.'">';
				$postIconStr .= '<i class="mdicon mdicon-play_circle_outline"></i>';
				$postIconStr .= '</div>';
            }elseif($postIcon['iconType'] == 'comment_box') {
                if(get_comments_number($postID) > 0) {
                    $postIconStr .= '<a href="'.get_permalink($postID).'" title="'.self::bk_get_comment_number_and_text($postID).'" class="comments-count-box overlay-item">'.get_comments_number($postID).'</a>';
                }else {
                    $postIconStr .= '';
                }
            }else {
                $postIconStr .= '';
            }
            
            return $postIconStr;
        }
/**
 * bk_overlay_footer_style
 * 
 */
        static function bk_overlay_footer_style($footerStyle) { 
            $footerArgs = array();
            switch ($footerStyle) {
                case '1-col':
                    $footerArgs['footerType'] = '';
                    $footerArgs['footerClass'] = '';
                    break;
                case '1-col-border':
                    $footerArgs['footerType'] = '';
                    $footerArgs['footerClass'] = 'post__meta--border-top';
                    break;
                case '2-cols':
                    $footerArgs['footerType'] = '2-cols';
                    $footerArgs['footerClass'] = 'post__meta--flex';
                    break;
                case '2-cols-border':
                    $footerArgs['footerType'] = '2-cols';
                    $footerArgs['footerClass'] = 'post__meta--flex post__meta--border-top';
                    break;
                default:
                    $footerArgs['footerType'] = '';
                    $footerArgs['footerClass'] = '';
                    break;
            }
            return $footerArgs;
        }
/**
 * bk_get_meta_list
 * 
 */
        static function bk_get_meta_list($metaInput) { 
            $metaCase = $metaInput;
            $metaArray = array();
            switch ($metaCase) {
                case 1:
                    $metaArray = array('author');
                    break;
                case 2:
                    $metaArray = array('author', 'date');
                    break;
                case 3:
                    $metaArray = array('author', 'date', 'comment');
                    break;
                case 4:
                    $metaArray = array('author', 'date', 'view');
                    break;
                case 5:
                    $metaArray = array('author', 'comment', 'view');
                    break;
                case 6:
                    $metaArray = array('author', 'view');
                    break;
                case 7:
                    $metaArray = array('author', 'comment');
                    break;
                case 8:
                    $metaArray = array('date');
                    break;
                case 9:
                    $metaArray = array('date', 'comment');
                    break;
                case 10:
                    $metaArray = array('date', 'view');
                    break;
                case 11:
                    $metaArray = array('date', 'comment', 'view');
                    break;
                case 12:
                    $metaArray = array('comment', 'view');
                    break;
                default:
                    $metaArray = array('author', 'date', 'comment');
                    break;
            }
            return $metaArray;
        }
 /**
 * bk_get_cat_class
 *   1           => Category Top Left
 *   2           => Category Overlap
 *   3           => Category Above Title (No Background)
 *   4           => Category Above Title (Has Background)
 *   0           => Disable Category
 * 
 */
        static function bk_get_cat_class($catStyle) {
            $catClass = '';
            switch ($catStyle) {
                case 1:
                    $catClass = 'post__cat post__cat--bg cat-theme-bg overlay-item--top-left';
                    break;
                case 2:
                    $catClass = 'post__cat post__cat--bg post__cat--overlap cat-theme-bg';
                    break;
                case 3:
                    $catClass = 'post__cat cat-theme';
                    break;
                case 4:
                    $catClass = 'post__cat post__cat--bg cat-theme-bg';
                    break;
                default:
                    $catClass = 'post__cat post__cat--bg cat-theme-bg overlay-item--top-left';
                    break;
            }
            return $catClass;
        }
 /**
 * media - post format
 * 
 */
        static function bk_get_gallery_1($postID){
            $htmlOutput = '';
            $galleryImages = self::tnm_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
            $htmlOutput .= '<div class="mnmd-gallery-wrap">';
            $htmlOutput .= '<div class="fotorama mnmd-gallery-slider mnmd-post-media-wide" data-width="100%" data-allowfullscreen="true" data-click="false" data-nav="false">';
            foreach ( $galleryImages as $image ){
                $attachment = wp_get_attachment_image_src($image['ID'], 'tnm-l-16_9');
                $caption = wp_get_attachment_caption($image['ID']);
                $htmlOutput .= '<a href="'.$attachment[0].'" data-size="1200x675" data-caption="'.$caption.'"></a>';
            }
            $htmlOutput .= '</div>';
            $htmlOutput .= '</div>';
            return $htmlOutput;
        }
        static function bk_get_gallery_2($postID){
            $htmlOutput = '';
            $galleryImages = self::tnm_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
            $htmlOutput .= '<div class="mnmd-gallery-wrap">';
            $htmlOutput .= '<div class="fotorama mnmd-gallery-slider mnmd-post-media-wide" data-width="100%" data-allowfullscreen="true" data-click="false">';
            foreach ( $galleryImages as $image ){
                $attachment = wp_get_attachment_image_src($image['ID'], 'tnm-l-16_9');
                $caption = wp_get_attachment_caption($image['ID']);
                $htmlOutput .= '<a href="'.$attachment[0].'" data-size="1200x675" data-caption="'.$caption.'"></a>';
            }
            $htmlOutput .= '</div>';
            $htmlOutput .= '</div>';
            return $htmlOutput;
        }
        static function bk_get_gallery_3($postID){
            $htmlOutput = '';
            $galleryImages = self::tnm_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
            $htmlOutput .= '<div class="mnmd-gallery-wrap">';
            $htmlOutput .= '<div class="fotorama mnmd-gallery-slider mnmd-post-media-wide" data-width="100%" data-nav="thumbs" data-allowfullscreen="true" data-click="false">';
            foreach ( $galleryImages as $image ){
                $attachment = wp_get_attachment_image_src($image['ID'], 'tnm-l-16_9');
                $attachmentThumb = wp_get_attachment_image_src($image['ID'], 'tnm-xxs-4_3');
                $caption = wp_get_attachment_caption($image['ID']);
                $htmlOutput .= '<a href="'.$attachment[0].'" data-size="1200x675" data-caption="'.$caption.'">';
                $htmlOutput .= '<img src="'.$attachmentThumb[0].'" alt="'.esc_attr__('Image alt', 'the-next-mag').'" width="180" height="135" />';
                $htmlOutput .= '</a>';
            }
            $htmlOutput .= '</div>';
            $htmlOutput .= '</div>';
            return $htmlOutput;
        }
        static function bk_get_gallery_4($postID){
            $htmlOutput = '';
            $galleryID = uniqid('gallery-');
            $galleryImages = self::tnm_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
            
            $htmlOutput .= '<div id="'.$galleryID.'" class="gallery '.$galleryID.' gallery-columns-4 gallery-size-thumbnail js-mnmd-lightbox-gallery mnmd-post-media-wide">';
            foreach ( $galleryImages as $image ){
                $attachment = wp_get_attachment_image_src($image['ID'], 'tnm-l-16_9');
                $attachmentThumb = wp_get_attachment_image($image['ID'], 'tnm-xs-1_1');
                $caption = wp_get_attachment_caption($image['ID']);
                $htmlOutput .= '<figure class="gallery-item">';
            	$htmlOutput .= '<div class="gallery-icon landscape">';
            	$htmlOutput .= '<a href="'.$attachment[0].'" title="Image caption">'.$attachmentThumb.'</a>';
            	$htmlOutput .= '</div>';
            	$htmlOutput .= '<figcaption class="wp-caption-text gallery-caption">';
            	$htmlOutput .= $caption;
            	$htmlOutput .= '</figcaption>';
            	$htmlOutput .= '</figure>';
            }
            $htmlOutput .= '</div>';
            return $htmlOutput;
        }
        static function bk_get_video_media($bkURL){
            $htmlOutput = '';
            
            if($bkURL != ''):
                $bkUrlParse = parse_url($bkURL);
                if (isset($bkUrlParse['host']) && (($bkUrlParse['host'] == 'www.youtube.com')||($bkUrlParse['host'] == 'youtube.com'))) { 
                    $videoID = self::bk_parse_youtube($bkURL);
                    $htmlOutput .= '<div class="mnmd-responsive-video">';
                    $htmlOutput .= '<iframe width="1050" height="591" src="//www.youtube.com/embed/'.$videoID.'" allowFullScreen ></iframe>';
                    $htmlOutput .= '</div>';
                }else if (isset($bkUrlParse['host']) && (($bkUrlParse['host'] == 'www.vimeo.com')||($bkUrlParse['host'] == 'vimeo.com'))) {
                    $videoID = self::bk_parse_vimeo($bkURL);
                    $htmlOutput .= '<div class="mnmd-responsive-video">';
                    $htmlOutput .= '<iframe src="//player.vimeo.com/video/'.$videoID.'?title=0&byline=0&portrait=0" allowfullscreen></iframe>';
                    $htmlOutput .= '</div>';
                }else {
                    $htmlOutput .= '<div class="tnm-error--notice"><span>'.esc_html__('Please put the correct video link to the video post format section', 'the-next-mag').'</span></div>';
                }
            endif;
            return $htmlOutput;
        }
    /**
    * ************* Get youtube ID  *****************
    *---------------------------------------------------
    */ 
      
        static function bk_parse_youtube($link){
         
            $regexstr = '~
                # Match Youtube link and embed code
                (?:                             # Group to match embed codes
                    (?:<iframe [^>]*src=")?       # If iframe match up to first quote of src
                    |(?:                        # Group to match if older embed
                        (?:<object .*>)?      # Match opening Object tag
                        (?:<param .*</param>)*  # Match all param tags
                        (?:<embed [^>]*src=")?  # Match embed tag to the first quote of src
                    )?                          # End older embed code group
                )?                              # End embed code groups
                (?:                             # Group youtube url
                    https?:\/\/                 # Either http or https
                    (?:[\w]+\.)*                # Optional subdomains
                    (?:                         # Group host alternatives.
                    youtu\.be/                  # Either youtu.be,
                    | youtube\.com              # or youtube.com
                    | youtube-nocookie\.com     # or youtube-nocookie.com
                    )                           # End Host Group
                    (?:\S*[^\w\-\s])?           # Extra stuff up to VIDEO_ID
                    ([\w\-]{11})                # $1: VIDEO_ID is numeric
                    [^\s]*                      # Not a space
                )                               # End group
                "?                              # Match end quote if part of src
                (?:[^>]*>)?                       # Match any extra stuff up to close brace
                (?:                             # Group to match last embed code
                    </iframe>                 # Match the end of the iframe
                    |</embed></object>          # or Match the end of the older embed
                )?                              # End Group of last bit of embed code
                ~ix';
        
            preg_match($regexstr, $link, $matches);
        
            return $matches[1];
        
        }
        
    /**
     * ************* Get vimeo ID *****************
     *---------------------------------------------------
     */  
        
        static function bk_parse_vimeo($link){
         
            $regexstr = '~
                # Match Vimeo link and embed code
                (?:<iframe [^>]*src=")?       # If iframe match up to first quote of src
                (?:                         # Group vimeo url
                    https?:\/\/             # Either http or https
                    (?:[\w]+\.)*            # Optional subdomains
                    vimeo\.com              # Match vimeo.com
                    (?:[\/\w]*\/videos?)?   # Optional video sub directory this handles groups links also
                    \/                      # Slash before Id
                    ([0-9]+)                # $1: VIDEO_ID is numeric
                    [^\s]*                  # Not a space
                )                           # End group
                "?                          # Match end quote if part of src
                (?:[^>]*></iframe>)?        # Match the end of the iframe
                (?:<p>.*</p>)?              # Match any title information stuff
                ~ix';
        
            preg_match($regexstr, $link, $matches);
        
            return $matches[1];
        }
        /**
         * ************* Get Dailymotion ID *****************
         *---------------------------------------------------
         */  
        static function bk_parse_dailymotion($link){
            preg_match('#<object[^>]+>.+?http://www.dailymotion.com/swf/video/([A-Za-z0-9]+).+?</object>#s', $link, $matches);
        
                // Dailymotion url
                if(!isset($matches[1])) {
                    preg_match('#http://www.dailymotion.com/video/([A-Za-z0-9]+)#s', $link, $matches);
                }
        
                // Dailymotion iframe
                if(!isset($matches[1])) {
                    preg_match('#http://www.dailymotion.com/embed/video/([A-Za-z0-9]+)#s', $link, $matches);
                }
            return $matches[1];
        }
        static function get_post_icon_class($postSource, $iconSize = '', $iconPosition = 'top-right', $addClass = ''){
            
            $postIconClass = '';
            
            if($iconPosition == 'top-right'){
                $postIconClass = 'overlay-item post-type-icon--inverse';
            }elseif($iconPosition == 'top-left'){
                $postIconClass = 'overlay-item--top-left post-type-icon--inverse';
            }elseif($iconPosition == 'left-bottom'){
                $postIconClass = 'overlay-item--left-bottom post-type-icon--inverse';
            }elseif($iconPosition == 'right-bottom'){
                $postIconClass = 'overlay-item--right-bottom post-type-icon--inverse';
            }else {
                $postIconClass = 'overlay-item--center-xy post-type-icon';
            }
            
            if($postSource == 'gallery'){
                $postIconClass = 'overlay-item post-type-icon--inverse gallery-icon';
            }else {
                if($iconSize == 'large') {
                    $postIconClass .= ' post-type-icon--lg';
                }else if($iconSize == 'medium') {
                    $postIconClass .= ' post-type-icon--md';
                }else if($iconSize == 'small') {
                    $postIconClass .= ' post-type-icon--sm';
                }
            }
            
            $postIconClass .= ' '.$addClass;
            
            return $postIconClass;
            
        }
        static function tnm_html_render($html_render, $check = 0){
            if($check != 0) {
                return $html_render;
            }else {
                return $html_render;
            }
        }
        //the default options
        static function pagenavi_init() {
            $pagenavi_options = array();
            $pagenavi_options['pages_text'] = esc_html__('Page %CURRENT_PAGE% of %TOTAL_PAGES%', 'the-next-mag');
            $pagenavi_options['current_text'] = '%PAGE_NUMBER%';
            $pagenavi_options['page_text'] = '%PAGE_NUMBER%';
            $pagenavi_options['first_text'] = esc_html__('1', 'the-next-mag');
            $pagenavi_options['last_text'] = esc_html__('%TOTAL_PAGES%', 'the-next-mag');

            $pagenavi_options['next_text'] = '<span class="mnmd-pagination__item mnmd-pagination__item-next"><i class="mdicon mdicon-arrow_forward"></i></span>';
            $pagenavi_options['prev_text'] = '<span class="mnmd-pagination__item mnmd-pagination__item-prev"><i class="mdicon mdicon-arrow_back"></i></span>';
        
            $pagenavi_options['dotright_text'] = esc_html__('...', 'the-next-mag');
            $pagenavi_options['dotleft_text'] = esc_html__('...', 'the-next-mag');
    
    
            $pagenavi_options['num_pages'] = 3;
    
            $pagenavi_options['always_show'] = 0;
            $pagenavi_options['num_larger_page_numbers'] = 3;
            $pagenavi_options['larger_page_numbers_multiple'] = 1000;
    
            return $pagenavi_options;
        }
        
        static function tnm_round_number($num, $tonearest) {
            return floor($num/$tonearest)*$tonearest;
        }
        
        static function tnm_get_pagination() {
    
            if (is_singular()) {
                return; //no pagination on single pages
            }
    
            global $wpdb, $wp_query;
            $pagenavi_options = self::pagenavi_init();
        
            $pagination_ret = '';
            $request = $wp_query->request;
            $posts_per_page = intval(get_query_var('posts_per_page'));
            $paged = intval(get_query_var('paged'));
            $numposts = $wp_query->found_posts;
            $max_page = $wp_query->max_num_pages;

            if(empty($paged) || $paged == 0) {
                $paged = 1;
            }
            $pages_to_show = intval($pagenavi_options['num_pages']);
            $larger_page_to_show = intval($pagenavi_options['num_larger_page_numbers']);
            $larger_page_multiple = intval($pagenavi_options['larger_page_numbers_multiple']);
            $pages_to_show_minus_1 = $pages_to_show - 1;
            $half_page_start = floor($pages_to_show_minus_1/2);
            $half_page_end = ceil($pages_to_show_minus_1/2);
            $start_page = $paged - $half_page_start;
            if($start_page <= 0) {
                $start_page = 1;
            }
            $end_page = $paged + $half_page_end;
            if(($end_page - $start_page) != $pages_to_show_minus_1) {
                $end_page = $start_page + $pages_to_show_minus_1;
            }
            if($end_page > $max_page) {
                $start_page = $max_page - $pages_to_show_minus_1;
                $end_page = $max_page;
            }
            if($start_page <= 0) {
                $start_page = 1;
            }
            $larger_per_page = $larger_page_to_show*$larger_page_multiple;
            $larger_start_page_start = (self::tnm_round_number($start_page, 10) + $larger_page_multiple) - $larger_per_page;
            $larger_start_page_end = self::tnm_round_number($start_page, 10) + $larger_page_multiple;
            $larger_end_page_start = self::tnm_round_number($end_page, 10) + $larger_page_multiple;
            $larger_end_page_end = self::tnm_round_number($end_page, 10) + ($larger_per_page);
            if($larger_start_page_end - $larger_page_multiple == $start_page) {
                $larger_start_page_start = $larger_start_page_start - $larger_page_multiple;
                $larger_start_page_end = $larger_start_page_end - $larger_page_multiple;
            }
            if($larger_start_page_start <= 0) {
                $larger_start_page_start = $larger_page_multiple;
            }
            if($larger_start_page_end > $max_page) {
                $larger_start_page_end = $max_page;
            }
            if($larger_end_page_end > $max_page) {
                $larger_end_page_end = $max_page;
            }
    
            if($max_page > 1 || intval($pagenavi_options['always_show']) == 1) {
    
                $pagination_ret .= '<div class="mnmd-pagination">';
    			$pagination_ret .= '<h4 class="mnmd-pagination__title sr-only">'.esc_html__('Posts navigation', 'the-next-mag').'</h4>';
                $pagination_ret .= '<div class="mnmd-pagination__links text-center">';
    			$pagination_ret .= get_previous_posts_link($pagenavi_options['prev_text']);
                                             
                if ($start_page >= 2 && $pages_to_show < $max_page) {
                    $first_page_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pagenavi_options['first_text']);
                    $pagination_ret .= '<a href="'.esc_url(get_pagenum_link()).'" class="mnmd-pagination__item" title="'.$first_page_text.'">'.$first_page_text.'</a>';
                    if(!empty($pagenavi_options['dotleft_text']) && ($start_page > 2)) {
                        $pagination_ret .= '<span class="mnmd-pagination__item mnmd-pagination__dots">'.$pagenavi_options['dotleft_text'].'</span>';
                    }
                }
                if($larger_page_to_show > 0 && $larger_start_page_start > 0 && $larger_start_page_end <= $max_page) {
                    for($i = $larger_start_page_start; $i < $larger_start_page_end; $i+=$larger_page_multiple) {
                        $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                        $pagination_ret .= '<a href="'.esc_url(get_pagenum_link($i)).'" class="mnmd-pagination__item" title="'.$page_text.'">'.$page_text.'</a>';
                    }
                }
                
                for($i = $start_page; $i  <= $end_page; $i++) {
                    if($i == $paged) {
                        $current_page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['current_text']);
                        $pagination_ret .= '<span class="mnmd-pagination__item mnmd-pagination__item-current">'.$current_page_text.'</span>';
                    } else {
                        $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                        $pagination_ret .= '<a href="'.esc_url(get_pagenum_link($i)).'" class="mnmd-pagination__item" title="'.$page_text.'">'.$page_text.'</a>';
                    }
                }
                
                if($larger_page_to_show > 0 && $larger_end_page_start < $max_page) {
                    for($i = $larger_end_page_start; $i <= $larger_end_page_end; $i+=$larger_page_multiple) {
                        $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                        $pagination_ret .= '<a href="'.esc_url(get_pagenum_link($i)).'" class="mnmd-pagination__item" title="'.$page_text.'">'.$page_text.'</a>';
                    }
                }
                if ($end_page < $max_page) {
                    if(!empty($pagenavi_options['dotright_text']) && ($end_page + 1 < $max_page)) {
                        $pagination_ret .= '<span class="mnmd-pagination__item mnmd-pagination__dots">'.$pagenavi_options['dotright_text'].'</span>';
                    }
                    $last_page_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pagenavi_options['last_text']);
                    $pagination_ret .= '<a href="'.esc_url(get_pagenum_link($max_page)).'" class="mnmd-pagination__item" title="'.$last_page_text.'">'.$last_page_text.'</a>';
                }
    			$pagination_ret .= get_next_posts_link($pagenavi_options['next_text'], $max_page);
    
                $pagination_ret .= '</div>';
                $pagination_ret .= '</div>';
            }
            
            return $pagination_ret;
        
        }

        static function tnm_svgUrlEncode($svgPath) {
            $data = $svgPath;
            $data = \preg_replace('/\v(?:[\v\h]+)/', ' ', $data);
            $data = \str_replace('"', "'", $data);
            $data = \rawurlencode($data);
            // re-decode a few characters understood by browsers to improve compression
            $data = \str_replace('%20', ' ', $data);
            $data = \str_replace('%3D', '=', $data);
            $data = \str_replace('%3A', ':', $data);
            $data = \str_replace('%2F', '/', $data);
            return $data;
        }
    } // Close tnm_core class
    
}
