<?php
/* 
 * Sections Configuration
 */
 if ( ! function_exists( 'bk_init_sections' ) ) {
	function bk_init_sections() {
		$sections = array(
            'fullwidth'=>__('FullWidth Section','the-next-mag'), 'has-rsb' => esc_html__('Content Section', 'the-next-mag')
		);
		wp_localize_script( 'bk-composer-script', 'bk_sections', $sections );
        $modules = array(
            'featured_with_list_vertical' => array(
				'title' => esc_html__( 'Featured With List Vertical', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/1.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Author Meta', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Author Meta', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Author Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),        
            'featured_with_list_horizontal' => array(
				'title' => esc_html__( 'Featured With List Horizontal', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/2.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    //Tab 1
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type - This module does not show the post icons', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Author Meta', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Author Meta', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Author Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'featured_with_overlap' => array(
				'title' => esc_html__( 'Featured With Overlap', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/3.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    //Tab 1
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'Select All - Show All Post Type', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Meta List', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Meta List', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),       
            'featured_block_a' => array(
				'title' => esc_html__( 'Featured Block A', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/4.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, should pick 5 posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Author Meta', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Author Meta', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Author Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'featured_block_b' => array(
				'title' => esc_html__( 'Featured Block B', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/5.png',
                'tabdisable' => '',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                    'tab-6' => 'News Ticker',
                ),
				'options' => array(
                    // Tab 1      
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),
                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#43C6AC',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#191654',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 225,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, should pick 5 posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    // Tab 6
                    'ticker_title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'The News Ticker Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'text',
						'default' => '',
					),
                    'ticker_limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'number',
						'default' => 5
					),
                    'ticker_offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-6',
                        'field' => 'number',
						'default' => 0
					),
                    'ticker_feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-6',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
					'ticker_category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-6',
                        'field' => 'category',
						'default' => '0',
					),
                    'ticker_editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, should pick 5 posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'text',
						'default' => '',
					),
                    'ticker_editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'text',
						'default' => '',
					),
				),
            ),
            'featured_block_c' => array(
				'title' => esc_html__( 'Featured Block C', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/6.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',        
                    'tab-5' => 'Post Info',            
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'no-line'           => esc_html__( 'Heading Left', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large Left', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Medium Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'featured_block_d' => array(
				'title' => esc_html__( 'Featured Block D', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/7.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',       
                    'tab-5' => 'Post Info',                                        
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 7,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'footer_style_l' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
                    'footer_style_s' => array(
						'title' => esc_html__('Small Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
						'default' => '2-cols',
						'options' => array(
							'1-col'          => esc_html__( 'Center', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
						),
					),
				),
            ),
            'featured_block_e' => array(
				'title' => esc_html__( 'Featured Block E', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/14.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'large-center',
						'options' => array(
                            'no-line'           => esc_html__( 'Heading Left', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large Left', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
						),
					),
                    'module_inverse' => array(
						'title' => esc_html__('Module Text Dark/White', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'yes',
						'options' => array(
                            'no'  => esc_html__( 'Dark', 'the-next-mag' ),
							'yes' => esc_html__( 'White', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),

                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#004e66',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#19165400',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 180,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 5
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 12,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 12,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),
            'featured_block_f' => array(
				'title' => esc_html__( 'Featured Block F', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/15.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),    
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),
            'featured_block_g' => array(
				'title' => esc_html__( 'Featured Block G', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/16.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 5
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
                        'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),
            'featured_block_h' => array(
				'title' => esc_html__( 'Featured Block H', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_2.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',       
                    'tab-5' => 'Post Info',                                        
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('View More Button', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
						'required'    => array('load_more' => 'viewall'),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('load_more' => 'viewall'),
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
						'required'    => array('load_more' => 'viewall'),
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),

                    'meta' => array(
                        'title' => esc_html__('Large Post Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
                        'default' => 0,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    'meta_s' => array(
                        'title' => esc_html__('Small Post Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 0,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
				),
            ),
            'featured_block_i' => array(
				'title' => esc_html__( 'Featured Block I', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_3.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),    
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),  
				),
            ),
            'featured_block_j' => array(
				'title' => esc_html__( 'Featured Block J', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_4.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),   
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
					'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'excerpt_s' => array(
                        'title' => esc_html__('Small Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 1,
                        'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
                        ),
                    ),
                    'meta' => array(
                        'title' => esc_html__('Large Post Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    'meta_s' => array(
                        'title' => esc_html__('Small Post Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 0,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
				),
            ),
            'featured_block_k' => array(
				'title' => esc_html__( 'Featured Block K', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_8.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'required'    => array('ajax_load_more' => 'viewall'),
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('ajax_load_more' => 'viewall'),
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
						'required'    => array('ajax_load_more' => 'viewall'),
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
                    'excerpt_s' => array(
						'title' => esc_html__('Small Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),
            'featured_block_l' => array(
				'title' => esc_html__( 'Featured Block L', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_9.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'required'    => array('ajax_load_more' => 'viewall'),
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('ajax_load_more' => 'viewall'),
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
						'required'    => array('ajax_load_more' => 'viewall'),
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
					'background_primary' => array(
						'title' => esc_html__('Background Color Primary', 'the-next-mag' ),
                        'description' => esc_html__( 'on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Background Color Primary', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Background Color Primary', 'the-next-mag' ),
						),
					),
					'text_color' => array(
						'title' => esc_html__('Text Color White/Black', 'the-next-mag' ),
                        'description' => esc_html__( 'on This Module Background', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'white',
						'options' => array(
                            'white'           => esc_html__( 'White Color', 'the-next-mag' ),
							'black'            => esc_html__( 'Black Color', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 9
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					), 
					'meta_l' => array(
						'title' => esc_html__('Large Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
                        'title' => esc_html__('Small Post Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
				),
            ),
            'featured_block_m' => array(
				'title' => esc_html__( 'Featured Block M', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_6.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
					'background_primary' => array(
						'title' => esc_html__('Background Color Primary', 'the-next-mag' ),
                        'description' => esc_html__( 'on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Background Color Primary', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Background Color Primary', 'the-next-mag' ),
						),
					),
					'text_color' => array(
						'title' => esc_html__('Text Color White/Black', 'the-next-mag' ),
                        'description' => esc_html__( 'on This Module Background', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'white',
						'options' => array(
                            'white'           => esc_html__( 'White Color', 'the-next-mag' ),
							'black'            => esc_html__( 'Black Color', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
					'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
                        'title' => esc_html__('Large Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),
            'featured_block_n' => array(
				'title' => esc_html__( 'Featured Block N', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_17.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('load_more' => 'viewall'),
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('load_more' => 'viewall'),
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
						'required'    => array('load_more' => 'viewall'),
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					), 
                    'excerpt_l' => array(
						'title' => esc_html__('Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),        
            'featured_block_o' => array(
				'title' => esc_html__( 'Featured Block O', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_25.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
					'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'carousel_nav' => array(
						'title' => esc_html__('Carousel Navigation', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1     => esc_html__( 'Enable', 'the-next-mag' ),
							0     => esc_html__( 'Disable', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 3
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type - This module does not show the post icons', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat' => array(
						'title' => esc_html__('Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'excerpt' => array(
						'title' => esc_html__('Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
					'meta' => array(
						'title' => esc_html__('Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',	
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
				),
            ),
            'featured_block_p' => array(
				'title' => esc_html__( 'Featured Block P', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_26.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type - This module does not show the post icons', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
                        'title' => esc_html__('Large Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    'meta_s' => array(
                        'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),
            'featured_block_q' => array(
				'title' => esc_html__( 'Featured Block Q', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_29.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type - This module does not show the post icons', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),

                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat' => array(
						'title' => esc_html__('Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'meta' => array(
						'title' => esc_html__('Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
                        'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    'excerpt' => array(
						'title' => esc_html__('Post No Thumbnail: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),
            'featured_block_s' => array(
				'title' => esc_html__( 'Featured Block S', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_31.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
					'small_title' => array(
						'title' => esc_html__('Small Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type - This module does not show the post icons', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),

                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',	
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
					'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'mosaic_a' => array(
				'title' => esc_html__( 'Mosaic A', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/8.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),     
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be 5, 9, 13', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 5
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'mosaic_a_bg' => array(
				'title' => esc_html__( 'Mosaic A Wide BG', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/9.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),
                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#43C6AC',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#191654',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 225,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),  
				),
            ),
            'mosaic_b' => array(
				'title' => esc_html__( 'Mosaic B', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/10.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),  
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),  
				),
            ),
            'mosaic_b_bg' => array(
				'title' => esc_html__( 'Mosaic B Wide BG', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/11.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),
                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#004e66',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#19165400',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 180,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),    
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),  
				),
            ),
            'mosaic_c' => array(
				'title' => esc_html__( 'Mosaic C', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/12.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),  
				),
            ),
            'mosaic_c_bg' => array(
				'title' => esc_html__( 'Mosaic C Wide BG', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/13.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),
                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#004e66',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#19165400',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 180,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),                      
				),
            ),
            'news_ticker' => array(
				'title' => esc_html__( 'News Ticker', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/17.png',
                'tabdisable' => 'tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'newsticker_fw' => array(
						'title' => esc_html__('Newsticker Full Width', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no' => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
				),
			),
            'countdown' => array(
				'title' => esc_html__( 'Countdown', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/18.png',
                'tabdisable' => 'tab-option-3 tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Custom Class'
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'subtitle' => array(
						'title' => esc_html__('Sub Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Module Sub Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'date' => array(
						'title' => esc_html__('Date Setup', 'the-next-mag' ),
						'description' => esc_html__( 'Set the date we are counting down to', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'datepicker',
						'default' => '',
					),
                    'des_link' => array(
						'title' => esc_html__('Destination Link', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'button_text' => array(
						'title' => esc_html__('Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),
                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#43C6AC',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#191654',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 225,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    //Tab 2
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
				),
			),         
            'posts_block_a' => array(
				'title' => esc_html__( 'Post Block A', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/20.png',
                'tabdisable' => 'tab-option-6 tab-option-5',
                'tabnames'  => array(
                    'tab-1' => 'Column 1',
                    'tab-2' => 'Column 2',
                    'tab-3' => 'Post Info',
                    'tab-4' => 'Custom Class',
                ),
				'options' => array(
                    // Tab 1
                    'left_title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style_1' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more_1' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link_1' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text_1' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target_1' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'limit_1' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'number',
						'default' => 4
					),
                    'offset_1' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'number',
						'default' => 0
					),
                    'feature_1' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_1' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_1' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'category_1' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'category',
						'default' => '0',
					),
                    'editor_exclude_1' => array(
						'title' => esc_html__('Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    //Tab 2
                    'right_title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style_2' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more_2' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-2 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link_2' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text_2' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target_2' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-2 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'limit_2' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 3
					),
                    'offset_2' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature_2' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_2' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_2' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category_2' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    'editor_exclude_2' => array(
						'title' => esc_html__('Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    //Tab 3
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Medium Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 option-column-1',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Medium Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
                    // Tab 4
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'text',
						'default' => '',
					),
				),
            ),
            'posts_block_b' => array(
				'title' => esc_html__( 'Post Block B', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/21.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_c' => array(
				'title' => esc_html__( 'Post Block C', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/22.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'heading_inverse' => array(
						'title' => esc_html__('Heading Dark/White', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'yes',
						'options' => array(
                            'no'  => esc_html__( 'Dark', 'the-next-mag' ),
							'yes' => esc_html__( 'White', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
                            'no_bg'      => esc_html__( 'No Background', 'the-next-mag' ),
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),

                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#12162D',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#12162D',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 180,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 4
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5',
                        'field' => 'select',
						'default' => 'center',
						'options' => array(
							'center' => esc_html__( 'Center', 'the-next-mag' ),
                            '2-cols' => esc_html__( '2 Columns', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_d' => array(
				'title' => esc_html__( 'Post Block D', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/23.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    
                    'align' => array(
						'title' => esc_html__('Module Align', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'text-left',
						'options' => array(
							'text-left' => esc_html__( 'Left', 'the-next-mag' ),
                            'text-center' => esc_html__( 'Center', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 4
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_e' => array(
				'title' => esc_html__( 'Post Block E', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/24.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 4
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_e_wide_bg' => array(
				'title' => esc_html__( 'Post Block E Wide BG', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/25.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),
                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#004e66',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#19165400',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 180,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 4
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_f' => array(
				'title' => esc_html__( 'Post Block F', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/26.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'Column 1',
                    'tab-2' => 'Column 2',
                    'tab-3' => 'Column 3',
                    'tab-4' => 'Post Info',
                    'tab-5' => 'Custom Class',
                ),
				'options' => array(
                    // Tab 1
                    'title_1' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Column Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style_1' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more_1' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link_1' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text_1' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target_1' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'limit_1' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'number',
						'default' => 5
					),
                    'offset_1' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'number',
						'default' => 0
					),
                    'feature_1' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_1' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_1' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'category_1' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'onecategory',
						'default' => '0',
					),
                    'editor_exclude_1' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_1' => array(
						'title' => esc_html__('Enable View More Button', 'the-next-mag' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'the-next-mag'),
                        'optionclass' => 'option-tab-1 tnm-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'view_more_link_1' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_1' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_1' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    // Tab 2
                    'title_2' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Column Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style_2' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more_2' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-2 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link_2' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text_2' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target_2' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-2 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'limit_2' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 5
					),
                    'offset_2' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature_2' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_2' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_2' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category_2' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'onecategory',
						'default' => '0',
					),
                    'editor_exclude_2' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_2' => array(
						'title' => esc_html__('Enable View More Button', 'the-next-mag' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'the-next-mag'),
                        'optionclass' => 'option-tab-2 tnm-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'view_more_link_2' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_2' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_2' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-2 tnm-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    // Tab 3
                    'title_3' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Column Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style_3' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more_3' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-3 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link_3' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text_3' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target_3' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-3 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'limit_3' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'number',
						'default' => 5
					),
                    'offset_3' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-3',
                        'field' => 'number',
						'default' => 0
					),
                    'feature_3' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-3',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_3' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_3' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
					'category_3' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-3',
                        'field' => 'onecategory',
						'default' => '0',
					),
                    'editor_exclude_3' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_3' => array(
						'title' => esc_html__('Enable View More Button', 'the-next-mag' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'the-next-mag'),
                        'optionclass' => 'option-tab-3 tnm-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'view_more_link_3' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_3' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_3' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-3 tnm-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    //Tab 4
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Meta List', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Meta List', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Medium Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Meta List', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Meta List', 'the-next-mag' ),
						),
					),
                    
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
				),
            ),
            'posts_block_g' => array(
				'title' => esc_html__( 'Post Block G', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/27.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'Column 1',
                    'tab-2' => 'Column 2',
                    'tab-3' => 'Column 3',
                    'tab-4' => 'Column 4',
                    'tab-5' => 'Custom Class'
                ),
				'options' => array(
                    // Tab 1
                    'title_1' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Column Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'offset_1' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'number',
						'default' => 0
					),
                    'feature_1' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_1' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_1' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'category_1' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'onecategory',
						'default' => '0',
					),
                    'editor_exclude_1' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'background_1' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'image',
						'default' => '',
					),      
                    'viewmore_1' => array(
						'title' => esc_html__('Enable View More Button', 'the-next-mag' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'the-next-mag'),
                        'optionclass' => 'option-tab-1 tnm-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'view_more_link_1' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_1' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_1' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    // Tab 2
                    'title_2' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Column Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'offset_2' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature_2' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_2' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_2' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category_2' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'onecategory',
						'default' => '0',
					),
                    'editor_exclude_2' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'background_2' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'image',
						'default' => '',
					),
                    'viewmore_2' => array(
						'title' => esc_html__('Enable View More Button', 'the-next-mag' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'the-next-mag'),
                        'optionclass' => 'option-tab-2 tnm-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'view_more_link_2' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_2' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_2' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-2 tnm-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    // Tab 3
                    'title_3' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Column Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'limit_3' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'number',
						'default' => 4
					),
                    'feature_3' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-3',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_3' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_3' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
					'category_3' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-3',
                        'field' => 'onecategory',
						'default' => '0',
					),
                    'editor_exclude_3' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'background_3' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-3',
                        'field' => 'image',
						'default' => '',
					),
                    'viewmore_3' => array(
						'title' => esc_html__('Enable View More Button', 'the-next-mag' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'the-next-mag'),
                        'optionclass' => 'option-tab-3 tnm-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'view_more_link_3' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_3' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_3' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-3 tnm-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    //Tab 4
                    'title_4' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Column Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'text',
						'default' => '',
					),
                    'offset_4' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-4',
                        'field' => 'number',
						'default' => 0
					),
                    'feature_4' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-4',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby_4' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags_4' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'text',
						'default' => '',
					),
					'category_4' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-4',
                        'field' => 'onecategory',
						'default' => '0',
					),
                    'editor_exclude_4' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'text',
						'default' => '',
					),
                    'background_4' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-4',
                        'field' => 'image',
						'default' => '',
					),
                    'viewmore_4' => array(
						'title' => esc_html__('Enable View More Button', 'the-next-mag' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'the-next-mag'),
                        'optionclass' => 'option-tab-4 tnm-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'view_more_link_4' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_4' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_4' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-4 tnm-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
				),
            ),
            'posts_block_h' => array(
				'title' => esc_html__( 'Post Block H', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_7.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Normal Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
                        'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
				),
            ),
            'posts_block_i' => array(
				'title' => esc_html__( 'Post Block I', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/28.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 5
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_j' => array(
				'title' => esc_html__( 'Post Block J', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/50.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					), 
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_k' => array(
				'title' => esc_html__( 'Post Block K', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_1.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
                        'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    'meta_s' => array(
                        'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    
                    'meta_nothumb_s' => array(
                        'title' => esc_html__('Small Posts No thumbnail: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 0,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
				),
            ),
            'posts_block_l' => array(
				'title' => esc_html__( 'Post Block L', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_5.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
                        'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
				),
            ),
            'posts_block_m' => array(
				'title' => esc_html__( 'Post Block M', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_12.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
					'pattern_background' => array(
						'title' => esc_html__('Pattern Background', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Pattern Background on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_n' => array(
				'title' => esc_html__( 'Post Block N', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_16.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
					//
                    'view_all' => array(
						'title' => esc_html__('View All', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
						'required'    => array('view_all' => 'viewall'),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
						'required'    => array('view_all' => 'viewall'),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'required'    => array('view_all' => 'viewall'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 9
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
                        'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                    'meta_s' => array(
                        'title' => esc_html__('Small Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
					'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_o' => array(
				'title' => esc_html__( 'Post Block O', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_21.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'small_title' => array(
						'title' => esc_html__('Small Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'view_all' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
						'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-ajax-load-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-ajax-load-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'meta_l' => array(
						'title' => esc_html__('Large Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',	
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_p' => array(
				'title' => esc_html__( 'Post Block P', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_19.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'view_all' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
						'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
					'excerpt_s' => array(
						'title' => esc_html__('Small Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
					'meta_l' => array(
						'title' => esc_html__('Large Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
					'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
				),
            ),
            'posts_block_q' => array(
				'title' => esc_html__( 'Post Block Q', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_24.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'view_all' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
						'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
					'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
				),
            ),
            'posts_block_r' => array(
				'title' => esc_html__( 'Post Block R', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_18.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'view_all' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
						'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
                        'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
                        'field' => 'select',
                        'default' => 1,
                        'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
                        ),
                    ),
					'meta_l' => array(
						'title' => esc_html__('Large Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',	
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_s' => array(
				'title' => esc_html__( 'Post Block S', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_27.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'view_all' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
						'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
					'learn_more' => array(
						'title' => esc_html__('View More Button', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View More Button', 'the-next-mag' ),
						),
					),
                    'learn_more_link' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('learn_more' => 'viewall'),
						'field' => 'text',
						'default' => '',
					),
                    'learn_more_text' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('learn_more' => 'viewall'),
						'field' => 'text',
						'default' => esc_html__('View More', 'the-next-mag'),
					),
                    'learn_more_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
						'required'    => array('learn_more' => 'viewall'),
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat' => array(
						'title' => esc_html__('Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
					'meta_l' => array(
						'title' => esc_html__('Large Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',	
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
					'meta_s' => array(
						'title' => esc_html__('Small Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',	
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_t' => array(
				'title' => esc_html__( 'Post Block T', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_28.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'view_all' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
						'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat' => array(
						'title' => esc_html__('Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
					'meta_l' => array(
						'title' => esc_html__('Large Post Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
					'meta_s' => array(
						'title' => esc_html__('Small Post Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
				),
            ),
            'horizontal_list' => array(
				'title' => esc_html__( 'Horizontal List', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/29.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'large-center',
						'options' => array(
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
						),
					),
                    'heading_inverse' => array(
						'title' => esc_html__('Heading Dark/White', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'Dark', 'the-next-mag' ),
							'yes' => esc_html__( 'White', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 3
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Comment Meta', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Comment Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'category_tiles' => array(
				'title' => esc_html__( 'Category Tiles', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/30.png',
                'tabdisable' => 'tab-option-3 tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Custom Class',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'category',
						'default' => '0',
					),
                    'category_description' => array(
						'title' => esc_html__('Category Description', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'post-count',
						'options' => array(
                            'description'       => esc_html__( 'Category Description', 'the-next-mag' ),
                            'post-count'        => esc_html__( 'Post Count', 'the-next-mag' ),
                            'disable'           => esc_html__( 'Disable', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
				),
            ),
            'carousel_overlap' => array(
				'title' => esc_html__( 'Carousel Overlap', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/31.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'large-center',
						'options' => array(
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
						),
					),
                    'heading_inverse' => array(
						'title' => esc_html__('Heading Dark/White', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'yes',
						'options' => array(
                            'no'  => esc_html__( 'Dark', 'the-next-mag' ),
							'yes' => esc_html__( 'White', 'the-next-mag' ),
						),
					),
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),
                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#43C6AC',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#191654',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 160,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'carousel_heading_aside_bg' => array(
				'title' => esc_html__( 'Carousel Heading Aside BG', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/32.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'subtitle' => array(
						'title' => esc_html__('Sub Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Module Sub Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'center',
						'options' => array(
							'center' => esc_html__( 'Center', 'the-next-mag' ),
                            '2-cols' => esc_html__( '2 Columns', 'the-next-mag' ),
						),
					),
                    'bg_option' => array(
						'title' => esc_html__('Background Options', 'the-next-mag'),
                        'description' => esc_html__( 'Select Background Image or Background Gradient', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-bg-options',
                        'field' => 'select',
						'default' => 'gradient',
						'options' => array(
							'image'      => esc_html__( 'Image', 'the-next-mag' ),
                            'gradient'   => esc_html__( 'Gradient', 'the-next-mag' ),
						),
					),
                    'background_img' => array(
						'title' => esc_html__('Background Image', 'the-next-mag' ),
						'description' => esc_html__( 'Upload your background image here', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'image'),
                        'field' => 'image',
						'default' => '',
					),
                    'background_gradient_from' => array(
						'title' => esc_html__('From', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#43C6AC',
					),
                    'background_gradient_to' => array(
						'title' => esc_html__('To', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'colorpicker',
						'default' => '#191654',
					),
                    'background_gradient_direction' => array(
						'title' => esc_html__('Direction', 'the-next-mag' ),
                        'description' => esc_html__( 'Degree Number', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 gradient-color',
                        'required'    => array('bg_option' => 'gradient'),
						'field' => 'text',
						'default' => 225,
					),
                    'background_pattern' => array(
						'title' => esc_html__('Background Pattern', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('bg_option' => 'gradient'),
						'field'       => 'select',
                        'options'     => array(
							1    => esc_html__( 'Enable', 'the-next-mag' ),
                            0    => esc_html__( 'Disable', 'the-next-mag' ),
						),
						'default' => 1,
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),   
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'carousel_heading_aside' => array(
				'title' => esc_html__( 'Carousel Heading Aside', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/33.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'subtitle' => array(
						'title' => esc_html__('Sub Title', 'the-next-mag' ),
						'description' => esc_html__( 'The Module Sub Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_background' => array(
						'title' => esc_html__('Heading Background', 'the-next-mag' ),
						'description' => esc_html__( 'Select a color for the background', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'colorpicker',
						'default' => '',
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'center',
						'options' => array(
							'center' => esc_html__( 'Center', 'the-next-mag' ),
                            '2-cols' => esc_html__( '2 Columns', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 12,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'carousel_overlay_post_3i' => array(
				'title' => esc_html__( 'Carousel Overlay Post 3i', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/34.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),    
                    'carousel_dot_nav' => array(
						'title' => esc_html__('Carousel Dot Navigation', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1     => esc_html__( 'True', 'the-next-mag' ),
							0     => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'carousel_overlay_post_3i_2' => array(
				'title' => esc_html__( 'Carousel Overlay Post 3i 2', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/35.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'carousel_dot_nav' => array(
						'title' => esc_html__('Carousel Dot Navigation', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1     => esc_html__( 'True', 'the-next-mag' ),
							0     => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'carousel_overlay_post_4i' => array(
				'title' => esc_html__( 'Carousel Overlay Post 4i', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/36.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'carousel_dot_nav' => array(
						'title' => esc_html__('Carousel Dot Navigation', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1     => esc_html__( 'True', 'the-next-mag' ),
							0     => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'carousel_overlay_post_4i_2' => array(
				'title' => esc_html__( 'Carousel Overlay Post 4i 2', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/37.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'carousel_dot_nav' => array(
						'title' => esc_html__('Carousel Dot Navigation', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1     => esc_html__( 'True', 'the-next-mag' ),
							0     => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'carousel_overlay_post_4i_3' => array(
				'title' => esc_html__( 'Carousel Overlay Post 4i 3', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_14.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					), 
					'meta' => array(
						'title' => esc_html__('Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
				),
            ),
            'carousel_card_3i' => array(
				'title' => esc_html__( 'Carousel Card 3i', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/38.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'carousel_dot_nav' => array(
						'title' => esc_html__('Carousel Dot Navigation', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1     => esc_html__( 'True', 'the-next-mag' ),
							0     => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),   
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
                    'footer_style' => array(
						'title' => esc_html__('Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5',
                        'field' => 'select',
						'default' => 'center',
						'options' => array(
							'center' => esc_html__( 'Center', 'the-next-mag' ),
                            '2-cols' => esc_html__( '2 Columns', 'the-next-mag' ),
						),
					),
				),
            ),
            'carousel_card_4i' => array(
				'title' => esc_html__( 'Carousel Card 4i', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/39.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'carousel_dot_nav' => array(
						'title' => esc_html__('Carousel Dot Navigation', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1     => esc_html__( 'True', 'the-next-mag' ),
							0     => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),  
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 9,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
                    'footer_style' => array(
						'title' => esc_html__('Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5',
                        'field' => 'select',
						'default' => 'center',
						'options' => array(
							'center' => esc_html__( 'Center', 'the-next-mag' ),
                            '2-cols' => esc_html__( '2 Columns', 'the-next-mag' ),
						),
					),
				),
            ),
            'slider_thumb_overlap' => array(
				'title' => esc_html__( 'Slider Thumb Overlap', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/40.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'Query Option',
                    'tab-2' => 'Manually Pick Post',
                    'tab-3' => 'Post Type',
                    'tab-4' => 'Post Info',
                    'tab-5' => 'Custom Class'
                ),
				'options' => array(
                    // Tab 1
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 2
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                   // Tab 3
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 4
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
                    'excerpt' => array(
						'title' => esc_html__('Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
				),
            ),
            'carousel_overlay_post_2i' => array(
				'title' => esc_html__( 'Carousel Overlay Post 2i', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/41.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'carousel_dot_nav' => array(
						'title' => esc_html__('Carousel Dot Navigation', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1     => esc_html__( 'True', 'the-next-mag' ),
							0     => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
				),
            ),
            'carousel_overlay_post_1i' => array(
				'title' => esc_html__( 'Carousel Overlay Post 1i', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/42.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'the-next-mag' ),
							'false'    => esc_html__( 'False', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The review Post', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
                    'excerpt' => array(
						'title' => esc_html__('Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_grid_alt_fw' => array(
				'title' => esc_html__( 'Posts Listing Grid ALT FW', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/43.png',
                'tabdisable' => '',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Subscribe Form',
                    'tab-4' => 'Manually Pick Post',
                    'tab-5' => 'Post Type',
                    'tab-6' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),  
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'viewmore' => array(
						'title' => esc_html__('Enable View More Button', 'the-next-mag' ),
                        'description' => esc_html__('Should be displayed at the bottom of the module', 'the-next-mag'),
                        'optionclass' => 'option-tab-1 tnm-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'the-next-mag' ),
							'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'view_more_link' => array(
						'title' => esc_html__('View More Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text' => array(
						'title' => esc_html__('View More Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    'mailchimp_title' => array(
						'title' => esc_html__('Mailchimp Title', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'mailchimp_shortcode' => array(
						'title' => esc_html__('Mailchimp Shortcode', 'the-next-mag' ),
                        'description' => esc_html__( 'Leave this field empty if you do not want to insert the subscribe form to this module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 5
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 6
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Meta List', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Meta List', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-6 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-6 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_grid_overlay_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid Overlay', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_32.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 9
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'listing_grid_posts_card_no_sidebar' => array(
				'title' => esc_html__( 'Listing Grid Posts Card', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_35.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_grid_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/44.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
                    'excerpt' => array(
						'title' => esc_html__('Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_grid_b_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid B', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_13.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
				),
            ),
            'posts_listing_grid_c_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid C', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_22.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
                        'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
                        'field' => 'select',
                        'default' => 8,
                        'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
                        ),
                    ),
                ),
            ),
            'posts_listing_grid_d_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid D', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_23.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
							'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 

                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					), 
					'meta' => array(
						'title' => esc_html__('Posts: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
				),
            ),
            'posts_listing_grid_small_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid Small', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/45.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be divisible by 4. Default: 8.)', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'posts_listing_grid_overlay_small_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid Overlay Small', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_34.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts (Should be divisible by 4. Default: 8.)', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),  
				),
            ),
            'posts_listing_list_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/46.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
                    'excerpt' => array(
						'title' => esc_html__('Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_list_b_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List B', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_11.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
                    'excerpt' => array(
						'title' => esc_html__('Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_list_c_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List C', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_15.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'excerpt' => array(
						'title' => esc_html__('Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_list_alt_a_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List Alt A', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/47.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_style' => array(
						'title' => esc_html__('Category Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta' => array(
						'title' => esc_html__('Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
                    'excerpt' => array(
						'title' => esc_html__('Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_list_alt_b_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List Alt B', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/48.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 2,
						'options' => array(
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
                    'meta_s' => array(
						'title' => esc_html__('Small Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'excerpt_s' => array(
						'title' => esc_html__('Small Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'footer_style' => array(
						'title' => esc_html__('Large Post: Footer Style', 'the-next-mag'),
						'optionclass' => 'option-tab-5 option-column-1',
                        'field' => 'select',
						'default' => '2-cols-border',
						'options' => array(
							'1-col'          => esc_html__( '1 Column', 'the-next-mag' ),
                            '1-col-border'   => esc_html__( '1 Column has border', 'the-next-mag' ),
                            '2-cols'         => esc_html__( '2 Columns', 'the-next-mag' ),
                            '2-cols-border'  => esc_html__( '2 Columns has border', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_listing_list_alt_c_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List Alt C', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/49.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'the-next-mag'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'the-next-mag' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'the-next-mag' ),
                            'viewall' => esc_html__( 'View All Button', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					), 
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
                    'meta_s' => array(
						'title' => esc_html__('Small Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					), 
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
                    'excerpt_s' => array(
						'title' => esc_html__('Small Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),
				),
            ),
            'custom_html' => array(
				'title' => esc_html__( 'Custom HTML', 'the-next-mag'),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/51.png',
                'tabdisable' => 'tab-option-2 tab-option-3 tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'HTML Config Panel',
                ),
				'options' => array(
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'custom_html' => array(
						'title' => esc_html__('HTML Code', 'the-next-mag'),
						'description' => esc_html__( 'Put your custom HTML code here', 'the-next-mag'),
						'field' => 'textarea',
						'default' => '',
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
				),
			), 
            'shortcode' => array(
				'title' => esc_html__( 'Short Code', 'the-next-mag'),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/52.png',
                'tabdisable' => 'tab-option-2 tab-option-3 tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'Shortcode Config Panel',
                ),
				'options' => array(
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'shortcode' => array(
						'title' => esc_html__('Shortcode -- separated by [shortcode_separator]', 'the-next-mag'),
						'description' => esc_html__( 'Put Shortcode here -- the shortcodes are separated by [shortcode_separator] -- eg: [shortcode1]  [shortcode_separator]  [shortcode2]', 'the-next-mag'),
						'field' => 'textarea',
						'default' => '',
					),
				),
			),  
        );
		wp_localize_script( 'bk-composer-script', 'bk_fullwidth_modules', $modules );
        $modules = array(
            'posts_block_main_col_a' => array(
				'title' => esc_html__( 'Posts Block Main Col A', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/main-1.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info'
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the number of posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
						'default' => 1,
						'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 8,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'excerpt_l' => array(
						'title' => esc_html__('Large Post: Excerpt', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1            => esc_html__( 'Enable Excerpt', 'the-next-mag' ),
                            0            => esc_html__( 'Disable Excerpt', 'the-next-mag' ),
						),
					),                    
				),
            ),
            'posts_block_main_col_b' => array(
				'title' => esc_html__( 'Posts Block Main Col B', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/main-2.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info'
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'the-next-mag' ),
                            'viewall' => esc_html__( 'Enable', 'the-next-mag' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'the-next-mag'),
						'optionclass' => 'option-tab-1 tnm-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'the-next-mag' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'the-next-mag' ),
						),
					), 
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'the-next-mag' ),
						'description' => esc_html__( 'Enter the offset number', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'the-next-mag'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'the-next-mag' ),
                            'yes' => esc_html__( 'Yes', 'the-next-mag' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'the-next-mag' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'the-next-mag' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'the-next-mag' ),
                            'top_review'        => esc_html__( 'Best Review', 'the-next-mag' ),
                            'modified'          => esc_html__( 'Modified', 'the-next-mag' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'the-next-mag' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'the-next-mag' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'the-next-mag' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'the-next-mag' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'the-next-mag' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'the-next-mag' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'the-next-mag' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'the-next-mag' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'the-next-mag' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'the-next-mag' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'the-next-mag' ),
							'video'      => esc_html__( 'Video', 'the-next-mag' ),
                            'gallery'    => esc_html__( 'Gallery', 'the-next-mag' ),
                            'review'     => esc_html__( 'Review', 'the-next-mag' ),
						),
					),   
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'the-next-mag' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'the-next-mag' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'the-next-mag' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'the-next-mag' ),
						),
					),
                    //Tab 5
                    'cat_l' => array(
						'title' => esc_html__('Large Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'cat_s' => array(
						'title' => esc_html__('Small Post: Category', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 1,
						'options' => array(
                            1           => esc_html__( 'Enable Category', 'the-next-mag' ),
                            0           => esc_html__( 'Disable Category', 'the-next-mag' ),
						),
					),
                    'meta_l' => array(
						'title' => esc_html__('Large Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-1',
						'field' => 'select',
						'default' => 3,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            3       => esc_html__( 'Meta Items: Author + Date + Comments', 'the-next-mag' ),
                            4       => esc_html__( 'Meta Items: Author + Date + Views', 'the-next-mag' ),
                            5       => esc_html__( 'Meta Items: Author + Comments + Views', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            11      => esc_html__( 'Meta Items: Date + Comments + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
                    'meta_s' => array(
						'title' => esc_html__('Small Post: Meta List', 'the-next-mag' ),
                        'optionclass' => 'option-tab-5 option-column-2',
						'field' => 'select',
						'default' => 0,
						'options' => array(
                            1       => esc_html__( 'Meta Items: Author', 'the-next-mag' ),
                            2       => esc_html__( 'Meta Items: Author + Date', 'the-next-mag' ),
                            6       => esc_html__( 'Meta Items: Author + Views', 'the-next-mag' ),
                            7       => esc_html__( 'Meta Items: Author + Comments', 'the-next-mag' ),
                            8       => esc_html__( 'Meta Items: Date', 'the-next-mag' ),
                            9       => esc_html__( 'Meta Items: Date + Comments', 'the-next-mag' ),
                            10      => esc_html__( 'Meta Items: Date + Views', 'the-next-mag' ),
                            12      => esc_html__( 'Meta Items: Comments + Views', 'the-next-mag' ),
                            0       => esc_html__( 'Disable Post Meta', 'the-next-mag' ),
						),
					),
				),
            ),
            'posts_block_main_col_c' => array(
				'title' => esc_html__( 'Posts Block Main Col C', 'the-next-mag' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/main-3.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Post Info'
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'the-next-mag' ),
						'description' => esc_html__( 'Lower Font Weight by put the text inside <span> tag', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_style' => array(
						'title' => esc_html__('Title Style', 'the-next-mag' ),
                        'optionclass' => 'option-tab-1 tnm-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
                            'default'           => esc_html__( 'Default - From Theme Option', 'the-next-mag' ),
                            'line'              => esc_html__( 'Heading Line', 'the-next-mag' ),
                            'large-line'        => esc_html__( 'Heading Large Line', 'the-next-mag' ),
                            'no-line'           => esc_html__( 'Heading No Line', 'the-next-mag' ),
							'large-no-line'     => esc_html__( 'Heading Large No Line', 'the-next-mag' ),
                            'line-under'        => esc_html__( 'Heading Line Under', 'the-next-mag' ),
                            'large-line-under'  => esc_html__( 'Heading Large Line Under', 'the-next-mag' ),
                            'center'            => esc_html__( 'Heading Center', 'the-next-mag' ),
                            'large-center'      => esc_html__( 'Heading Large Center', 'the-next-mag' ),
                            'line-around'       => esc_html__( 'Heading Line Around', 'the-next-mag' ),
                            'large-line-around' => esc_html__( 'Heading Large Line Around', 'the-next-mag' ),
						),
					),
                    'load_more' => array(
						'title' => esc_html__('Header View More Button', 'the-next-mag'),
                        'description' => esc_html__( 'Only Enable if Title Style different: Center || Large Center || Line Around || Large Line Around', 'the-next-mag' ),
						'optionclass' => 'option-tab-1 tnm-ajax-load-more',
                        'field' => 'select