<?php
if (!class_exists('tnm_posts_block_s')) {
    class tnm_posts_block_s {
        static $pageInfo=0;
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_posts_block_s-');
            $moduleConfigs = array();
            $moduleData = array();
            
            //get config
            
            $moduleConfigs['title'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit'] = 4;
            $moduleConfigs['offset'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );

            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            $moduleConfigs['view_all'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all', true );
            $viewallButton = array();
            if ($moduleConfigs['view_all'] == 'viewall') :            
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleInfo = array(
                'post_source'   => $moduleConfigs['post_source'],
                'post_icon'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true ),
                'iconPosition'  => 'top-right',
                'cat'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat', true ), // Category Style
                'learn_more'    => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_learn_more', true ),
                'meta_l'        => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_l', true ),
                'meta_s'        => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_s', true ),
                'learn_more_link' => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_learn_more_link', true ),
                'learn_more_text' => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_learn_more_text', true ),
                'learn_more_target' => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_learn_more_target', true ),
            );
            tnm_core::bk_add_buff('query', $moduleID, 'moduleInfo', $moduleInfo);
            $the_query = bk_get_query::tnm_query($moduleConfigs, $moduleID);              //get query
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-posts-block-s'.$moduleCustomClass.'">';
            $block_str .= '<div class="container">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
            
            $block_str .= '<div class="mnmd-block__inner">';
            $block_str .= '<div class="mnmd-block__inner-group flexbox-wrap flex-space-30">';
            if ( $the_query->have_posts() ) :
                $block_str .= $this->render_modules($the_query, $moduleInfo); 
            endif;
            $block_str .= '</div><!-- .mnmd-block__inner-group -->';
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .container -->';
            $block_str .= '</div><!-- .mnmd-block -->';
                        
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
        }
        public function render_modules($the_query, $moduleInfo = ''){
            $render_modules = '';
            $postSource = $moduleInfo['post_source'];
            $postIcon = $moduleInfo['post_icon'];
            $iconPosition = 'top-right';
            $iconSize = 'small';
            $cat_l = $moduleInfo['cat'];

            $learn_more = $moduleInfo['learn_more'];
            $learn_more_link = '';
            $learn_more_text = '';
            $learn_more_target = '';
            if($learn_more == 'viewall'){
                $learn_more_link = $moduleInfo['learn_more_link'];
                $learn_more_text = $moduleInfo['learn_more_text'];
                $learn_more_target = $moduleInfo['learn_more_target'];
            }
            if($learn_more_link == null){
                $learn_more_link = '';
            }
            if(($learn_more_target == null) || ($learn_more_target == '')){
                $target = '_blank';
            }else{
                $target = $learn_more_target;
            }
            if($cat_l != 0){
                $catStyle_l = 4;
                $cat_Class_l = tnm_core::bk_get_cat_class($catStyle_l);
            }else {
                $catStyle_l = '';
                $cat_Class_l = '';
            }
            $meta_l =  $moduleInfo['meta_l'];
            if($meta_l != 0) {
                $metaArray_l = tnm_core::bk_get_meta_list($meta_l);
            }else {
                $metaArray_l = '';
            }
            $meta_s = $moduleInfo['meta_s'];
            if($meta_s != 0) {
                $metaArray_s = tnm_core::bk_get_meta_list($meta_s);
            }else {
                $metaArray_s = '';
            }
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }    
            
            if ( $the_query->have_posts() ) :
                $postOverlayHTML = new tnm_overlay_4;                        
                $postOverlayAttr = array (
                    'additionalClass'        => 'post--overlay-md post--overlay-bottom post--overlay-floorfade post--overlay-padding-lg',
                    'additionalTextClass'    => 'inverse-text',
                    'thumbSize'              => 'tnm-m-4_3',
                    'cat'                    => $catStyle_l,
                    'catClass'               => $cat_Class_l.' post__cat-inverse',
                    'typescale'              => 'typescale-3',
                    'meta'                   => $metaArray_l,
                    'postIcon'               => $postIconAttr,  
                );
                $postOverlayAttr_1 = array (
                    'additionalClass'        => 'post--overlay-xs post--overlay-bottom post--overlay-floorfade post--overlay-padding-lg',
                    'additionalTextClass'    => 'inverse-text',
                    'thumbSize'              => 'tnm-xs-4_3',
                    'cat'                    => $catStyle_l,
                    'catClass'               => $cat_Class_l.' post__cat-inverse',
                    'typescale'              => 'typescale-2',
                    'meta'                   => $metaArray_s,
                    'postIcon'               => $postIconAttr,  
                );
                $postOverlayAttr_2 = array (
                    'additionalClass'        => 'post--overlay-md post--overlay-bottom post--overlay-floorfade post--overlay-padding-lg',
                    'additionalTextClass'    => 'inverse-text',
                    'thumbSize'              => 'tnm-l-16_9',
                    'cat'                    => $catStyle_l,
                    'meta'                   => $metaArray_s,
                    'catClass'               => $cat_Class_l.' post__cat-inverse',
                    'typescale'              => 'typescale-3',
                    'postIcon'               => $postIconAttr,  
                );
                $currentPost = '';
                $maxPost = $the_query->current_count; 
                while ( $the_query->have_posts() ): $the_query->the_post();   
                    $currentPost = $the_query->current_post; 
                    if($currentPost <  3):
                        if($currentPost == 0):
                            $postOverlayAttr['postID'] = get_the_ID();
                            if($bypassPostIconDetech != 1) {
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                                }
                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], '', $iconPosition, '');
                                
                                $postOverlayAttr['postIcon'] = $postIconAttr;
                            }
                            $render_modules .= '<div class="section-main">';
                            $render_modules .= '<div class="posts-list flexbox-wrap flex-space-30">';
                            $render_modules .= '<div class="list-item flexbox-item-100">';
                            $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                            $render_modules .= '</div><!-- .list-item -->';
                        else:
                            $postOverlayAttr_1['postID'] = get_the_ID();
                            if($bypassPostIconDetech != 1) {
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                                }
                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'small', $iconPosition, 'overlay-item--sm-p');
                                
                                $postOverlayAttr_1['postIcon'] = $postIconAttr;
                            }
                            $render_modules .= '<div class="list-item flexbox-item-50">';
                            $render_modules .= $postOverlayHTML->render($postOverlayAttr_1);
                            $render_modules .= '</div><!-- .list-item -->';
                        endif;
                        if($currentPost == 2):
                            $render_modules .= '</div><!-- .posts-list -->';
                            $render_modules .= '</div><!-- .section-main -->';
                        endif;
                    else:
                        $postOverlayAttr_2['postID'] = get_the_ID();
                        $render_modules .= '<div class="section-sub flexbox-wrap flexbox-wrap-direction-column flex-space-30">';
                        $render_modules .= '<div class="posts-list flexbox-item-1">';
                        $render_modules .= '<div class="list-item">';
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'small', $iconPosition, 'overlay-item--sm-p');
                            
                            $postOverlayAttr_2['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= $postOverlayHTML->render($postOverlayAttr_2);
                        $render_modules .= '</div><!-- .list-item -->';
                        $render_modules .= '</div><!-- .posts-list -->'; 
                    endif; 
                endwhile;
                if($currentPost < 2):
                    $render_modules .= '</div><!-- .posts-list -->';
                    $render_modules .= '</div><!-- .section-main -->';
                elseif($currentPost > 2):
                    if($learn_more_link != ''):
                        $render_modules .= '<div class="text-left btn-view-all">';
                        $render_modules .= '<a href="'.esc_attr($learn_more_link).'" target="'.esc_attr($target).'_blank" class="btn-rectangle-large flexbox-wrap flexbox-center-xy">'.esc_attr($learn_more_text).'<i class="mdicon mdicon-arrow_forward mdicon--last"></i></a>';
                        $render_modules .= '</div>';
                    endif;
                    $render_modules .= '</div><!-- .section-sub -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}