<?php
if (!class_exists('tnm_posts_block_r')) {
    class tnm_posts_block_r {
        static $pageInfo=0;
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_posts_block_r-');
            $moduleConfigs = array();
            $moduleData = array();
            
            //get config
            
            $moduleConfigs['title'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit'] = 7;
            $moduleConfigs['offset'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );

            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            $moduleConfigs['view_all'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all', true );
            $viewallButton = array();
            if ($moduleConfigs['view_all'] == 'viewall') :            
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleInfo = array(
                'post_source'   => $moduleConfigs['post_source'],
                'post_icon'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true ),
                'iconPosition'  => 'top-right',
                'cat_l'         => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_l', true ), // Category Style
                'cat_s'         => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_l', true ), // Category Style
                'meta_l'        => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_l', true ),
            );
            tnm_core::bk_add_buff('query', $moduleID, 'moduleInfo', $moduleInfo);
            $the_query = bk_get_query::tnm_query($moduleConfigs, $moduleID);              //get query
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-posts-block-r has-background'.$moduleCustomClass.'">';
            $block_str .= '<div class="container">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
            
            $block_str .= '<div class="mnmd-block__inner">';
            $block_str .= '<div class="mnmd-block__inner-group flexbox-wrap flex-space-30">';
            if ( $the_query->have_posts() ) :
                $block_str .= $this->render_modules($the_query, $moduleInfo); 
            endif;
            $block_str .= '</div><!-- .mnmd-block__inner-group -->';
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .container -->';
            $block_str .= '</div><!-- .mnmd-block -->';
                        
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
        }
        public function render_modules($the_query, $moduleInfo = ''){
            $render_modules = '';
            $postSource = $moduleInfo['post_source'];
            $postIcon = $moduleInfo['post_icon'];
            $iconPosition = 'top-right';
            $iconSize = 'small';
            $cat_l = $moduleInfo['cat_l'];
            if($cat_l != 0){
                $catStyle_l = 1;
                $cat_Class_l = tnm_core::bk_get_cat_class($catStyle_l);
            }else {
                $catStyle_l = '';
                $cat_Class_l = '';
            }
            $cat_s = $moduleInfo['cat_s'];
            if($cat_s != 0){
                $catStyle_s = 1;
                $cat_Class_s = tnm_core::bk_get_cat_class($catStyle_s);
            }else {
                $catStyle_s = '';
                $cat_Class_s = '';
            }
            $meta_l =  $moduleInfo['meta_l'];
            if($meta_l != 0) {
                $metaArray_l = tnm_core::bk_get_meta_list($meta_l);
            }else {
                $metaArray_l = '';
            }
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }    
            
            if ( $the_query->have_posts() ) :
                $postOverlayHTML = new tnm_overlay_4;                        
                $postOverlayAttr = array (
                    'additionalClass'        => 'post--overlay-lg post--overlay-bottom post--overlay-padding-lg post--overlay-floorfade',
                    'additionalTextClass'    => 'inverse-text',
                    'thumbSize'              => 'tnm-s-1_1',
                    'cat'                    => $catStyle_l,
                    'catClass'               => $cat_Class_l.' post__cat-inverse',
                    'additionalExcerptClass' => 'line-limit line-limit-3',
                    'meta'                   => $metaArray_l,
                    'typescale'              => 'typescale-3',
                    'postIcon'               => $postIconAttr,  
                );
                $postVerticalHTML = new tnm_vertical_1;                        
                $postVerticalAttr = array (
                    'additionalClass'        => 'post--vertical-small-only-title',
                    'additionalThumbClass'   => 'atbs-thumb-object-fit',
                    'thumbSize'              => 'tnm-xs-1_1',
                    'cat'                    => $catStyle_s,
                    'catClass'               => $cat_Class_s.' post__cat-inverse',
                    'typescale'              => 'typescale-1 line-limit line-limit-3',
                    'postIcon'               => $postIconAttr,  
                );
                $currentPost = '';
                $maxPost = $the_query->current_count; 
                while ( $the_query->have_posts() ): $the_query->the_post();   
                    $currentPost = $the_query->current_post; 
                    if($currentPost == 0):
                        $postOverlayAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], '', $iconPosition, '');
                            
                            $postOverlayAttr['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= '<div class="section-main">';
                        $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                        $render_modules .= '</div><!-- .section-main -->';
                    else:
                        if($currentPost == 1):
                            $render_modules .= '<div class="section-sub">';
                            $render_modules .= '<div class="posts-list flexbox-wrap flexbox-wrap-3i flex-space-30">';
                        endif;
                        $postVerticalAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'small', $iconPosition, 'overlay-item--sm-p');
                            
                            $postVerticalAttr['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= '<div class="list-item">';
                        $render_modules .= $postVerticalHTML->render($postVerticalAttr);
                        $render_modules .= '</div><!-- .list-item -->';
                    endif; 
                endwhile;
                if($currentPost > 0):
                    $render_modules .= '</div><!-- .posts-list -->';
                    $render_modules .= '</div><!-- .section-sub -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}