<?php
if (!class_exists('tnm_posts_block_main_col_m')) {
    class tnm_posts_block_main_col_m {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_posts_block_main_col_m-');
            $moduleConfigs = array();
            
            self::$pageInfo = $page_info;
            
            //get config
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_limit', true );
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            $moduleConfigs['viewmore'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_viewmore', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            $moduleConfigs['carousel_loop'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_carousel_loop', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleInfo = array(
                'post_source'   => $moduleConfigs['post_source'],
                'post_icon'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true ),
                'cat_l'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_l', true ),
                'cat_s'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_s', true ),
                'excerpt_l'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_excerpt_l', true ),
                'meta_l'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_l', true ),
                'meta_s'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_s', true ),
                'carousel_loop' => $moduleConfigs['carousel_loop'],
            );
            
            $the_query = bk_get_query::query($moduleConfigs);              //get query
            if ($the_query->have_posts() ) :
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-posts-block-main-col-m'.$moduleCustomClass.'">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
            $block_str .= '<div class="mnmd-block__inner">';
            $block_str .= '<div class="mnmd-block__inner-group">';
            if ( $the_query->have_posts() ) :
                $block_str .= $this->render_modules($the_query, $moduleInfo);            //render modules
            endif;
            $block_str .= '</div><!-- .mnmd-block__inner-group -->';
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .mnmd-block -->';
            endif;
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query, $moduleInfo){
            $render_modules = '';
            $currentPost = 0;
            // Category
            $cat_L = $moduleInfo['cat_l'];
            if($cat_L != 0){
                $cat_L_Style = 3; //Above Title No BG
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            
            $cat_S = $moduleInfo['cat_s'];
            if($cat_S != 0){
                $cat_S_Style = 1; //Above Title No BG
                $cat_S_Class = tnm_core::bk_get_cat_class($cat_S_Style);
            }else {
                $cat_S_Style = '';
                $cat_S_Class = '';
            }

            $meta = $moduleInfo['meta_l'];
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }
            $meta_s = $moduleInfo['meta_s'];
            if($meta_s != 0) {
                $metaArray_s = tnm_core::bk_get_meta_list($meta_s);
            }else {
                $metaArray_s = '';
            }

            $excerpt_L = $moduleInfo['excerpt_l'];
            
            if($excerpt_L == 1){
                $excerptLength = 20;
            }else {
                $excerptLength = '';
            }
            $iconPosition = 'top-right';
            $postSource = $moduleInfo['post_source'];
            $postIcon = $moduleInfo['post_icon'];
            
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }

            $carousel_loop = $moduleInfo['carousel_loop'];
            if($the_query->post_count < 5):
                $carousel_loop = 0;
            endif;
            if ( $the_query->have_posts() ) :
                $postOverlayHTML = new tnm_overlay_6;
                $postOverlayAttr = array (
                    'cat'               => $cat_L_Style,
                    'catClass'          => $cat_L_Class.' post__cat-space-sm',
                    'additionalClass'   => 'post--overlay-fullwidth-text-bottom post--overlay-bottom post--overlay-padding-lg post--overlay-md',
                    'additionalBGClass'   => 'background-img--darkened',
                    'additionalTextInnerClass'   => 'flexbox-wrap',
                    'thumbSize'         => 'tnm-l-2_1',
                    'meta'                => $metaArray,
                    'typescale'         => 'typescale-3',
                    'postIcon'          => $postIconAttr,
                );
                $postOverlayHTML_1 = new tnm_overlay_1;
                $postOverlayAttr_1 = array (
                    'cat'               => $cat_S_Style,
                    'catClass'          => $cat_S_Class,
                    'additionalClass'   => 'post--overlay-xs post--overlay-bottom post--overlay-floorfade',
                    'additionalTextClass'   => 'inverse-text',
                    'thumbSize'         => 'tnm-xs-4_3',
                    'typescale'         => 'typescale-2',
                    'postIcon'          => $postIconAttr,
                    'meta'              => $metaArray_s,
                );
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    $maxPost = $the_query->post_count;
                    if($currentPost == 0):
                        $postOverlayAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'medium', $iconPosition);
                            
                            $postOverlayAttr['postIcon']    = $postIconAttr;
                        }
                        $render_modules .= '<div class="section-main">';
                        $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                        $render_modules .= '</div><!-- .section-main -->';
                    else:
                        if($currentPost == 1):
                            $render_modules .= '<div class="section-sub">';
                            if($maxPost < 5):
                                $render_modules .= '<div class="owl-carousel-under-post">';
                            else:
                                $render_modules .= '<div class="owl-carousel mnmd-carousel js-carousel-2i10m dots-vertical" data-carousel-loop="'.$carousel_loop.'">';
                            endif;
                        endif;
                        $render_modules .= '<div class="slide-content">';
                        $postOverlayAttr_1['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'small', $iconPosition, 'overlay-item--sm-p');
                            
                            $postOverlayAttr_1['postIcon']    = $postIconAttr;
                        }
                        $render_modules .= $postOverlayHTML_1->render($postOverlayAttr_1);
                        $render_modules .= '</div><!-- .slide-content -->';
                    endif;
                endwhile;
                if($currentPost > 0):
                    $render_modules .= '</div><!-- .owl-carousel -->';
                    $render_modules .= '</div><!-- .section-sub -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}