<?php
if (!class_exists('tnm_featured_block_p-')) {
    class tnm_featured_block_p {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_featured_block_p-');
            $carouselID = uniqid('carousel-');
            $moduleConfigs = array();
            $moduleData = array();
            
            self::$pageInfo = $page_info;
            
            //get config
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = 3;
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = $moduleConfigs['custom_class'].' ';
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleConfigs['post_icon'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true );      
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            
            
            if ( $the_query->have_posts() ) :
                $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-featured-block-p'.$moduleCustomClass.'">';
               	$block_str .= '<div class="container">';
                $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
                $block_str .= '</div><!-- .container -->';
                $block_str .= '<div class="mnmd-block__inner">';
                $block_str .= '<div class="mnmd-block__inner-group flexbox-wrap flexbox-space-y">';
                $block_str .= $this->render_modules($the_query);            //render modules
                $block_str .= '</div><!-- .mnmd-block__inner-group -->';
                $block_str .= '</div><!-- .mnmd-block__inner -->';
                $block_str .= '</div><!-- .mnmd-block -->';         
            endif;
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query){
            
            $render_modules = '';
            $iconPosition = 'top-right';
            // Category Style ($cat)
            $cat_l = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_l', true );
            if($cat_l != 0){
                $catStyle_l = 3; // Category Above Title (Has Background)
                $cat_Class_l = tnm_core::bk_get_cat_class($catStyle_l);
            }else {
                $catStyle_l = '';
                $cat_Class_l = '';
            }
            $cat_s = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_s', true );
            if($cat_s != 0){
                $catStyle_s = 3; // Category Above Title (Has Background)
                $cat_Class_s = tnm_core::bk_get_cat_class($catStyle_s);
                $cat_Overlay_Style_s = 4;
                $cat_Overlay_Class_s = tnm_core::bk_get_cat_class($cat_Overlay_Style_s);

            }else {
                $catStyle_s = '';
                $cat_Class_s = '';
                $cat_Overlay_Style_s = '';
                $cat_Overlay_Class_s = '';
            }
            $excerpt = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt_l', true );
            
            if($excerpt == 1){
                $excerptLength = 15;
            }else {
                $excerptLength = '';
            }

            $meta = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta', true );
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }

            $meta_s = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta_s', true );
            if($meta_s != 0) {
                $metaArray_s = tnm_core::bk_get_meta_list($meta_s);
            }else {
                $metaArray_s = '';
            }
            $postSource = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_source', true );
            $postIcon = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_icon', true );
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }
            if ( $the_query->have_posts() ) :
                $postOverlayHTML = new tnm_overlay_4;
                $postOverlayAttr = array (
                    'additionalClass'     => 'post--overlay-xs post--overlay-bottom post--overlay-floorfade',
                    'additionalTextClass' => 'inverse-text',
                    'thumbSize'           => 'tnm-xs-4_3',
                    'cat'                 => $cat_Overlay_Style_s,
                    'catClass'            => $cat_Overlay_Class_s.' post__cat-inverse', 
                    'typescale'           => 'typescale-1',
                    'postIcon'            => $postIconAttr,                        
                );
                $postHorizontalHTML = new tnm_horizontal_not_thumb;
                $postHorizontalAttr = array (
                    'additionalClass'        => 'post--horizontal-reverse post--horizontal-text-color-effect',
                    'additionalThumbClass'   => 'atbs-thumb-object-fit',
                    'thumbSize'              => 'tnm-l-4_3',
                    'cat'                    => $catStyle_l,
                    'catClass'               => $cat_Class_l,
                    'typescale'              => 'typescale-6',
                    'except_length'          => $excerptLength,
                    'additionalExcerptClass' => 'line-limit line-limit-3',
                    'meta'                   => $metaArray,
                    'postIcon'               => $postIconAttr,                        
                );
                $postVerticalHTML = new tnm_vertical_1;
                $postVerticalAttr = array (
                    'additionalClass'      => 'post--vertical-small-only-title',
                    'additionalThumbClass' => 'atbs-thumb-object-fit',
                    'thumbSize'            => 'tnm-s-1_1',
                    'cat'                  => $catStyle_s,
                    'catClass'             => $cat_Class_s,
                    'meta'                 => $metaArray_s,
                    'typescale'            => 'typescale-3 line-limit line-limit-3',
                    'postIcon'             => $postIconAttr,                        
                );
                $currentPost = 0;
                $maxPost = $the_query->post_count;
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    if($currentPost == 0):
                        $render_modules .= '<div class="section-main flexbox-wrap flexbox-wrap-direction-column">';
                        $render_modules .= '<div class="post-main">';
                        $postHorizontalAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], '', $iconPosition, '');
                            
                            $postHorizontalAttr['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= $postHorizontalHTML->render($postHorizontalAttr);
                        $render_modules .= '</div><!-- .post-main -->';
                    elseif($currentPost == 1):
                        $render_modules .= '<div class="post-sub flexbox-space-y-bottom">';
                        $postOverlayAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'small', $iconPosition, 'overlay-item--sm-p');
                            
                            $postOverlayAttr['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                        $render_modules .= '</div><!-- .post-sub -->';
                        $render_modules .= '</div><!-- .section-main -->';
                    elseif($currentPost == 2):
                        $render_modules .= '<div class="section-sub flexbox-wrap flexbox-center-y">';
                        $postVerticalAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'small', $iconPosition, 'overlay-item--sm-p');
                            
                            $postVerticalAttr['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= $postVerticalHTML->render($postVerticalAttr);
                        $render_modules .= '</div><!-- .section-sub -->';
                    endif;
                endwhile;
                if($currentPost < 2):
                    $render_modules .= '</div><!-- .section-main -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}
/*if($bypassPostIconDetech != 1) {
    if($postSource != 'all') {
        $postIconAttr['iconType'] = $postSource;
    }else {
        $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
    }
    
    if($iconPosition == 'left-bottom') {
        $postOverlayHTML = new tnm_overlay_icon_side_left;
        if($postIconAttr['iconType'] != 'gallery') { 
            $postIconAttr['postIconClass']  = '';
        }else {
            $postIconAttr['postIconClass']  = 'overlay-item gallery-icon';
        }
        $postOverlayAttr['additionalTextClass'] = 'inverse-text';
    }else if($iconPosition == 'right-bottom') {
        $postOverlayHTML = new tnm_overlay_icon_side_right;
        if($postIconAttr['iconType'] != 'gallery') { 
            $postIconAttr['postIconClass']  = '';
        }else {
            $postIconAttr['postIconClass']  = 'overlay-item gallery-icon';
        }
        $postOverlayAttr['additionalTextClass'] = 'inverse-text';
    }else {
        if($postIconAttr['iconType'] == 'gallery') {
            $postIconAttr['postIconClass']  = 'overlay-item gallery-icon';
        }else {
            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], '', $iconPosition);
        }
    }
    
    $postOverlayAttr['postIcon']    = $postIconAttr;
}*/