<?php
if (!class_exists('tnm_featured_block_n')) {
    class tnm_featured_block_n {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_featured_block_n-');
            $moduleConfigs = array();
            $moduleData = array();
            self::$pageInfo = $page_info;
            //get config
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = 4;
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            $viewallButton['view_all_target'] = '';
            $viewallButton['view_all_link'] = '';
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            if(isset($viewallButton['view_all_target']) || ($viewallButton['view_all_target'] == '')){
                $viewallButton['view_all_target'] ='_blank';
            }else{
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            }
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true ); 
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            
            if ( $the_query->have_posts() ) :
                $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-featured-block-n has-background'.$moduleCustomClass.'">';
               	$block_str .= '<div class="container">';
                $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, '');
                $block_str .= '</div><!-- .container -->';
                $block_str .= '<div class="mnmd-block__inner">';
                $block_str .= '<div class="mnmd-block__inner-group layout-full-container--right">';
                $block_str .= '<div class="section-main">';
                $block_str .= $this->render_modules($the_query , $viewallButton);            //render modules
                if(($viewallButton['view_all_link'] != '') && isset($viewallButton['view_all_link'])){
                    $block_str .= '<div class="text-left btn-view-all">';
                        $block_str .= '<a href="'.$viewallButton['view_all_link'].'" target="'.$viewallButton['view_all_target'].'" class="btn-only-text">'.$viewallButton['view_all_text'].'<i class="mdicon mdicon-arrow_forward mdicon--last"></i></a>';
                    $block_str .= '</div>';
                }
                $block_str .= '</div><!-- .section-main-->';
                $block_str .= '</div><!-- .mnmd-block__inner-group -->';
                $block_str .= '</div><!-- .mnmd-block__inner -->';
                $block_str .= '</div><!-- .mnmd-block -->';       
            endif;
            
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query){
            $render_modules = '';
            // Category Style ($cat)
            $cat_l = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_l', true );

            if($cat_l != 0){
                $cat_L_Style = 3;
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            $excerpt_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt_l', true );
            if($excerpt_L == 1){
                $excerptLength = 15;
            }else {
                $excerptLength = '';
            }
            $postSource = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_source', true );
            if ( $the_query->have_posts() ) :
                $postHorizontalHTML = new tnm_horizontal_not_thumb;
                $postHorizontalAttr = array (
                    'additionalClass'          => 'post--horizontal-xs post--horizontal-thumb-follow-parent',
                    'additionalThumbClass'     => 'atbs-thumb-object-fit',
                    'additionalTextClass'      => '',
                    'thumbSize'                => 'tnm-xl-4_3',
                    'cat'                      => $cat_L_Style,
                    'catClass'                 => $cat_L_Class,
                    'typescale'                => 'typescale-3 line-limit line-limit-3',
                    'except_length'            => $excerptLength,
                    'additionalExcerptClass'   => 'line-limit line-limit-3',     
                    'readmore'                 => 1,       
                );
                $currentPost = '';
                
                $render_modules .= '<div class="posts-list posts-horizontal-style-2 flexbox-wrap flexbox-wrap-2i flex-space-70">';
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    if($currentPost == 0):
                        $render_modules .= '<div class="list-item active">';
                    else:
                        $render_modules .= '<div class="list-item">';
                    endif;
                        $postHorizontalAttr['postID'] = get_the_ID();
                        $render_modules .= $postHorizontalHTML->render($postHorizontalAttr);
                        $render_modules .= '</div><!-- .list-item-->';
                endwhile;
                $render_modules .= '</div><!-- .posts-list -->';
                
            endif;
            return $render_modules;
        }
    }
}