<?php
if (!class_exists('tnm_featured_block_m')) {
    class tnm_featured_block_m {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_featured_block_m-');
            $moduleConfigs = array();
            $moduleData = array();
            self::$pageInfo = $page_info;
            //get config
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = 3;
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['background_primary'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_background_primary', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true ); 
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            if($moduleConfigs['background_primary'] == 'enable'):
                $background_primary = ' background-primary';
            else:
                $background_primary = '';
            endif;
            if ( $the_query->have_posts() ) :
                $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-featured-block-m mnmd-block--contiguous'.$moduleCustomClass.$background_primary.'">';
               	$block_str .= '<div class="container">';
                $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
                $block_str .= '</div><!-- .container -->';
                $block_str .= '<div class="mnmd-block__inner">';
                $block_str .= '<div class="mnmd-block__inner-group layout-full-container--right">';
                $block_str .= $this->render_modules($the_query);            //render modules
                $block_str .= '</div><!-- .mnmd-block__inner-group -->';
                $block_str .= '</div><!-- .mnmd-block__inner -->';
                $block_str .= '</div><!-- .mnmd-block -->';       
            endif;
            
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query){
            $render_modules = '';
            // Category Style ($cat)
            $cat_l = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_l', true );
            $cat_s = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_s', true );
            $text_color = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_text_color', true );
            if($cat_s != 0){
                $cat_S_Style = 3;
                $cat_S_Class = tnm_core::bk_get_cat_class($cat_S_Style);
            }else {
                $cat_S_Style = '';
                $cat_S_Class = '';
            }
            if($cat_l != 0){
                $cat_L_Style = 4;
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            $excerpt_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt_l', true );
            
            if($excerpt_L == 1){
                $excerptLength = 20;
            }else {
                $excerptLength = '';
            }

            $meta = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta', true );
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }


            $iconPosition = 'top-right';
            $postIcon = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_icon', true );
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }
            $postSource = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_source', true );
            if ( $the_query->have_posts() ) :
                if($text_color != 'black') {
                    $text_inverse = 'inverse-text';
                    $cat_inverse = ' post__cat-inverse';
                }else {
                    $text_inverse = '';
                    $cat_inverse = '';
                }

                $postHorizontalHTML = new tnm_horizontal_1;
                $postHorizontalAttr = array (
                    'additionalClass'          => 'post--horizontal-reverse post--horizontal-reverse-fullwidth',
                    'additionalThumbClass'     => 'atbs-thumb-object-fit',
                    'additionalTextClass'      => ' '.$text_inverse,
                    'thumbSize'                => 'tnm-xxl',
                    'cat'                      => $cat_L_Style,
                    'catClass'                 => $cat_L_Class.$cat_inverse,
                    'typescale'                => 'typescale-3',  
                    'except_length'            => $excerptLength,
                    'meta'                     => $metaArray,
                    'additionalExcerptClass'   => 'line-limit line-limit-3',
                );
                $postHorizontalAttr_2 = array (
                    'additionalClass'            => 'post--horizontal-counter-index post--horizontal-middle post--horizontal-xs',
                    'thumbSize'                  => 'tnm-xxs-1_1',
                    'cat'                        => $cat_S_Style,
                    'catClass'                   => $cat_S_Class,
                    'typescale'                  => 'typescale-1',                      
                );

                $maxPost = $the_query->post_count;
                $currentPost = '';
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    if($currentPost == 0):
                        $render_modules .= '<div class="section-main">';
                        $postHorizontalAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'medium', $iconPosition, '');
                            
                            $postHorizontalAttr['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= $postHorizontalHTML->render($postHorizontalAttr);
                        $render_modules .= '</div><!-- .section-main-->';
                    else:
                        if($currentPost == 1):
                            $render_modules .= '<div class="section-sub layout-full-container--left flexbox-wrap">';
                            $render_modules .= '<div class="posts-list posts-list-counter-item flexbox-wrap flexbox-wrap-1i flex-space-20">';
                        endif;
                         $render_modules .= '<div class="list-item">';
                        $postHorizontalAttr_2['postID'] = get_the_ID();
                        $render_modules .= $postHorizontalHTML->render($postHorizontalAttr_2);
                        $render_modules .= '</div><!-- .list-item-->';
                    endif;
                endwhile;
                if($currentPost > 0):
                    $render_modules .= '</div><!-- .posts-list -->';
                    $render_modules .= '</div><!-- .section-sub -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}