<?php
if (!class_exists('tnm_featured_block_h')) {
    class tnm_featured_block_h {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_featured_block_h-');
            
            $moduleConfigs = array();
            $moduleData = array();
            
            self::$pageInfo = $page_info;
            
            //get config
            
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true );
            $moduleConfigs['limit']     = 4;
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();

            if ($moduleConfigs['load_more'] == 'viewall') :   
                $viewallButton = array(        
                'view_all_link' => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true ),
                'view_all_text' => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true ),

                'view_all_target' => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true ),
                );
            endif;
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            
            if ( $the_query->have_posts()) :
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-featured-block-h'.$moduleCustomClass.'">';
           	$block_str .= '<div class="container">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, '');
            $block_str .= '</div><!-- .container -->';
            $block_str .= '<div class="mnmd-block__inner">';
            $block_str .= '<div class="mnmd-block__inner-group">';
            $block_str .= $this->render_modules($the_query, $viewallButton);            //render modules
            $block_str .= '</div><!-- .mnmd-block__inner-group -->';
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .mnmd-block -->';
            
            endif;
            
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query, $viewallButton = ''){
            
            $currentPost = 0;
            $render_modules = '';
            
            $iconPosition_L = 'top-right';
            $iconPosition_S = 'center';

            if(($viewallButton != '') && (isset($viewallButton['view_all_link']) && ($viewallButton['view_all_link'] != ''))) {
                
                $viewall_Link =  $viewallButton['view_all_link'];
            }else{
                $viewall_Link ='';
            }
            if(($viewallButton != '') && (isset($viewallButton['view_all_text']) && ($viewallButton['view_all_text'] != ''))) {
                $viewall_text =  $viewallButton['view_all_text'];
            }else{
                
                $viewall_text ='';
            }
            if(($viewallButton != '') && (isset($viewallButton['view_all_target']) && ($viewallButton['view_all_target'] != ''))) {
                $viewAllTarget =  $viewallButton['view_all_target'];
            }else{
                $viewAllTarget = '_blank';
            }
            
            // Meta
            $meta_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta_l', true );
            $meta_S = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta_s', true );
            
            if($meta_L != 0) {
                $metaArray_L = tnm_core::bk_get_meta_list($meta_L);
            }else {
                $metaArray_L = '';
            }
            if($meta_S != 0) {
                $metaArray_S = tnm_core::bk_get_meta_list($meta_S);
            }else {
                $metaArray_S = '';
            }
            
            // Category
            $cat_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_l', true );
            if($cat_L != 0){
                $cat_L_Style = 4; //Above Title Has BG
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            
            $cat_S = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_s', true );
            if($cat_S != 0){
                $cat_S_Style = 3;
                $cat_S_Class = tnm_core::bk_get_cat_class($cat_S_Style);
                $articleAdditionalClass_S = 'post--vertical-cat-overlap text-center';
            }else {
                $cat_S_Style = '';
                $cat_S_Class = '';
                $articleAdditionalClass_S = 'text-center';
            }
            
            $excerpt_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt_l', true );
            
            if($excerpt_L == 1){
                $excerptLength = 20;
            }else {
                $excerptLength = '';
            }

            $meta = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta', true );
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }

            $meta_s = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta_s', true );
            if($meta_s != 0) {
                $metaArray_s = tnm_core::bk_get_meta_list($meta_s);
            }else {
                $metaArray_s = '';
            }
            
            $postSource = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_source', true );
            if ( $the_query->have_posts() ) :
                $postOverlayHTML = new tnm_overlay_4;
                $postOverlayAttr = array (
                    'additionalClass'    => 'post--overlay-featured-fullwidth-text-center post--overlay-lg post--overlay-padding-lg',
                    'additionalBGClass'  => 'background-img--darkened',
                    'additionalTextClass'=> 'inverse-text container',
                    'catClass'           => $cat_L_Class,
                    'cat'                => $cat_L_Style,
                    'thumbSize'          => 'tnm-xl-16_9',
                    'typescale'          => 'typescale-4',
                    'meta'               => $metaArray,
                    'except_length'      => $excerptLength,
                );
                $postNothumbHTML = new tnm_no_thumb_2;
                $postNothumbAttr = array (
                    'additionalClass'   => 'post-no-thumb-count-media',
                    'catClass'          => $cat_S_Class,
                    'cat'               => $cat_S_Style,
                    'index'             => 1,
                    'meta'               => $metaArray_s,
                    'typescale'         => 'typescale-1',
                );
                
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    $maxPost = $the_query->post_count;
                    if($currentPost == 0):
                        $postOverlayAttr['postID'] = get_the_ID();
                        $render_modules .= '<div class="section-main">';
                        $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                        $render_modules .= '</div><!-- .section-main -->';
                    else:
                        if($currentPost == 1):
                            $render_modules .= '<div class="section-sub">';
                            $render_modules .= '<div class="sub-row flexbox-wrap flexbox-wrap-2i flex-space-30">';
                        endif;
                            $postNothumbAttr['postID'] = get_the_ID();
                            $render_modules .= '<div class="sub-col">';
                            $render_modules .= $postNothumbHTML->render($postNothumbAttr);
                            $render_modules .= '</div><!-- .sub-col -->';
                            $postNothumbAttr['index'] +=1;
                        if($currentPost == ($maxPost - 1)):
                            if($viewall_text != ''):
                                $render_modules .= '<div class="sub-col sub-col-button flexbox-wrap flexbox-center-y flexbox-center-x">';
                                $render_modules .= '<div class="text-center">';
                                $render_modules .= '<a href="'.esc_url($viewall_Link).'" target="'.esc_attr($viewAllTarget).'" class="btn btn-default btn-see-all-lg">'.esc_attr($viewall_text).'<i class="mdicon mdicon-arrow_forward mdicon--last"></i></a>';
                                $render_modules .= '</div><!-- .text-center -->';
                                $render_modules .= '</div><!-- .sub-col -->';
                            endif;
                            $render_modules .= '</div><!-- .sub-row -->';
                            $render_modules .= '</div><!-- .section-sub -->';
                        endif;
                    endif;
                endwhile;
            endif;
            return $render_modules;
        }
    }
}