<?php
if (!class_exists('tnm_posts_block_q')) {
    class tnm_posts_block_q {
        static $pageInfo=0;
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_posts_block_q-');
            $moduleConfigs = array();
            $moduleData = array();
            
            //get config
            
            $moduleConfigs['title'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit'] = 5;
            $moduleConfigs['offset'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );

            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            $moduleConfigs['view_all'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all', true );
            $viewallButton = array();
            if ($moduleConfigs['view_all'] == 'viewall') :            
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleInfo = array(
                'post_source'   => $moduleConfigs['post_source'],
                'post_icon'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true ),
                'iconPosition'  => 'top-right',
                'cat_l'         => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_l', true ), // Category Style
                'cat_s'         => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_s', true ), // Category Style
                'meta_s'        => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_s', true ),
                'excerpt_l'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_excerpt_l', true ),
            );
            tnm_core::bk_add_buff('query', $moduleID, 'moduleInfo', $moduleInfo);
            $the_query = bk_get_query::tnm_query($moduleConfigs, $moduleID);              //get query
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-posts-block-q'.$moduleCustomClass.'">';
            $block_str .= '<div class="container">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
            $block_str .= '</div><!-- .container -->';
            $block_str .= '<div class="mnmd-block__inner">';
            $block_str .= '<div class="mnmd-block__inner-group layout-full-container--left flexbox-wrap">';
            if ( $the_query->have_posts() ) :
                $block_str .= $this->render_modules($the_query, $moduleInfo); 
            endif;
            $block_str .= '</div><!-- .mnmd-block__inner-group -->';
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .mnmd-block -->';
                        
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
        }
        public function render_modules($the_query, $moduleInfo = ''){
            $render_modules = '';
            $postSource = $moduleInfo['post_source'];
            $postIcon = $moduleInfo['post_icon'];
            $iconPosition = 'top-right';
            $iconSize = 'small';
            $cat_l = $moduleInfo['cat_l'];
            if($cat_l != 0){
                $catStyle_l = 4;
                $cat_Class_l = tnm_core::bk_get_cat_class($catStyle_l);
            }else {
                $catStyle_l = '';
                $cat_Class_l = '';
            }
            $cat_s = $moduleInfo['cat_s'];
            if($cat_s != 0){
                $catStyle_s = 3;
                $cat_Class_s = tnm_core::bk_get_cat_class($catStyle_s);
            }else {
                $catStyle_s = '';
                $cat_Class_s = '';
            }
            $excerpt_l = $moduleInfo['excerpt_l'];
            if($excerpt_l == 1){
                $excerptLength = 20;
            }else {
                $excerptLength = '';
            }
            $meta_s = $moduleInfo['meta_s'];

            if($meta_s != 0) {
                $metaArray_s = tnm_core::bk_get_meta_list($meta_s);
            }else {
                $metaArray_s = '';
            }
            
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }    
            
            if ( $the_query->have_posts() ) :
                $postOverlayHTML = new tnm_overlay_4;                        
                $postOverlayAttr = array (
                    'additionalClass'        => 'post--overlay-featured-fullwidth-text-center post--overlay-middle post--overlay-lg post--overlay-padding-lg',
                    'additionalTextClass'    => 'inverse-text',
                    'additionalBGClass'      => 'background-img--darkened',
                    'thumbSize'              => 'tnm-xl-16_9',
                    'cat'                    => $catStyle_l,
                    'catClass'               => $cat_Class_l.' post__cat-inverse',
                    'except_length'          => $excerptLength,
                    'additionalExcerptClass' => 'line-limit line-limit-3',
                    'typescale'              => 'typescale-4',
                    'postIcon'               => $postIconAttr,  
                );
                $postHorizontalHTML = new tnm_horizontal_3;                        
                $postHorizontalAttr = array (
                    'additionalClass'        => 'post--horizontal-read-more-rotate post--horizontal-middle post--horizontal-xs',
                    'additionalThumbClass'   => 'atbs-thumb-object-fit',
                    'additionalTextClass'    => 'flexbox-wrap',
                    'thumbSize'              => 'tnm-xxs-1_1',
                    'typescale'              => 'typescale-1 line-limit line-limit-2',
                    'cat'                    => $catStyle_s,
                    'catClass'               => $cat_Class_s,
                    'readmore'               => 1,
                    'meta'                   => $metaArray_s, 
                    'postIcon'               => $postIconAttr,  
                );
                $postVerticalHTML = new tnm_vertical_1;                        
                $postVerticalAttr = array (
                    'additionalClass'        => 'post--vertical-small-only-title',
                    'additionalThumbClass'   => 'atbs-thumb-object-fit',
                    'thumbSize'              => 'tnm-xs-1_1',
                    'cat'                    => $catStyle_s,
                    'catClass'               => $cat_Class_s,
                    'typescale'              => 'typescale-2 line-limit line-limit-3',
                    'postIcon'               => $postIconAttr,  
                );
                $postNothumbHTML = new tnm_no_thumb_1;                        
                $postNothumbAttr = array (
                    'additionalClass'        => 'post-no-thumb-only-title-cat',
                    'additionalTextClass'    => 'inverse-text',
                    'meta'                   => $metaArray_s,
                    'typescale'              => 'typescale-1',
                );
                $currentPost = '';
                $maxPost = $the_query->current_count; 
                while ( $the_query->have_posts() ): $the_query->the_post();   
                    $currentPost = $the_query->current_post; 
                    if($currentPost < 2):
                        if($currentPost == 0):
                            $render_modules .= '<div class="section-main flexbox-wrap flexbox-wrap-direction-column">';
                            $postOverlayAttr['postID'] = get_the_ID();
                            if($bypassPostIconDetech != 1) {
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                                }
                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], '', $iconPosition, '');
                                
                                $postOverlayAttr['postIcon'] = $postIconAttr;
                            }
                            $render_modules .= '<div class="post-main">';
                            $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                            $render_modules .= '</div><!-- .post-main -->';
                        endif;
                        if($currentPost == 1):
                            $postHorizontalAttr['postID'] = get_the_ID();
                            $render_modules .= '<div class="post-sub flexbox-space-y-bottom">';
                            $render_modules .= '<div class="post-sub-wrap">';
                            $render_modules .= $postHorizontalHTML->render($postHorizontalAttr);
                            $render_modules .= '</div><!-- .post-sub-wrap -->';
                            $render_modules .= '</div><!-- .post-sub -->';
                            $render_modules .= '</div><!-- .section-main -->';
                        endif;
                    else:
                        if($currentPost == 2):
                            $postVerticalAttr['postID'] = get_the_ID();
                            $render_modules .= '<div class="section-sub flexbox-wrap flexbox-wrap-direction-column">';
                            $render_modules .= '<div class="post-main">';
                            if($bypassPostIconDetech != 1) {
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                                }
                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], $iconSize, $iconPosition, 'overlay-item--sm-p');
                                
                                $postVerticalAttr['postIcon'] = $postIconAttr;
                            }
                            $render_modules .= $postVerticalHTML->render($postVerticalAttr);
                            $render_modules .= '</div><!-- .post-main -->';
                        else:
                            if($currentPost == 3):
                                $render_modules .= '<div class="post-sub flexbox-space-y-bottom">';
                                $render_modules .= '<div class="post-sub-wrap">';
                                $render_modules .= '<div class="posts-list list-space-md list-unstyled">';
                            endif;
                            $postNothumbAttr['postID'] = get_the_ID();
                            $render_modules .= '<div class="list-item">';
                            $render_modules .= $postNothumbHTML->render($postNothumbAttr);
                            $render_modules .= '</div><!-- .list-item -->';
                        endif;
                    endif; 
                endwhile;
                if($currentPost == 0):
                    $render_modules .= '</div><!-- .section-main -->';
                elseif($currentPost > 2):
                    $render_modules .= '</div><!-- .posts-list -->';
                    $render_modules .= '</div><!-- .post-sub-wrap -->';
                    $render_modules .= '</div><!-- .post-sub -->';
                endif;
                if($currentPost > 1):
                    $render_modules .= '</div><!-- .section-sub -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}