<?php
if (!class_exists('tnm_posts_block_m')) {
    class tnm_posts_block_m {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_posts_block_m-');
            $moduleConfigs = array();
            $moduleData = array();
            
            self::$pageInfo = $page_info;
            
            //get config
            
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = 5;
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['pattern_background']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_pattern_background', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true ); 
            
            $moduleInfo = array(
                'post_source'   => $moduleConfigs['post_source'],
                'post_icon'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true ),
                'iconPosition'  => 'top-right',
                'cat_L'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_l', true ),
                'cat_S'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_s', true ),
                'excerpt_l'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_excerpt_l', true ),
            );
              
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            if($moduleConfigs['pattern_background'] == 'disable'){
                $pattern_background = ' disable-pattern-background';
            }else{
                $pattern_background = '';
            }
            if ( $the_query->have_posts()) :
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-posts-block-m'.$moduleCustomClass.$pattern_background.'">';
           	$block_str .= '<div class="container">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
            
            $block_str .= '<div class="mnmd-block__inner">';
            $block_str .= '<div class="mnmd-block__inner-group  flexbox-wrap flex-space-50">';
            $block_str .= $this->render_modules($the_query, $moduleInfo);            //render modules
            $block_str .= '</div><!-- .mnmd-block__inner-group -->';
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .container -->';
            $block_str .= '</div><!-- .mnmd-block -->';
            
            endif;
            
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query, $moduleInfo = ''){
            
            
            $currentPost = 0;
            $render_modules = '';
            
            $iconPosition = $moduleInfo['iconPosition'];
            $iconSize_L = 'medium';
            $iconSize_S = '';

            // Category
            $cat_L = $moduleInfo['cat_L'];
            if($cat_L != 0){
                $cat_L_Style = 3; //Top-Left
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            
            $cat_S = $moduleInfo['cat_S'];
            if($cat_S != 0){
                $cat_overlay = 4;
                $cat_S_Style = 1; //Top-left
                $cat_S_Class = tnm_core::bk_get_cat_class($cat_S_Style);
            }else {
                $cat_overlay = '';
                $cat_S_Style = '';
                $cat_S_Class = '';
            }
            $excerpt_L = $moduleInfo['excerpt_l'];
            
            if($excerpt_L == 1){
                $excerptLength = 20;
            }else {
                $excerptLength = '';
            }

            $postSource = $moduleInfo['post_source'];
            $postIcon = $moduleInfo['post_icon'];
            
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }
            if ( $the_query->have_posts() ) :
                $postVerticalHTML = new tnm_vertical_1;
                $postVerticalAttr = array (
                    'additionalClass'        => 'post--vertical-thumb-background-point-circle',
                    'additionalThumbClass'   => 'atbs-thumb-object-fit',
                    'cat'                    => $cat_L_Style,
                    'catClass'               => $cat_L_Class,
                    'thumbSize'              => 'tnm-xs-16_9',
                    'typescale'              => 'typescale-3',
                    'except_length'          => $excerptLength,
                    'additionalExcerptClass' => 'line-limit line-limit-3',
                    'postIcon'               => $postIconAttr,
                );
                $postOverlayHTML = new tnm_overlay_4;
                $postOverlayAttr_S = array (
                    'additionalClass'   => 'post--overlay-xs post--overlay-bottom post--overlay-floorfade',
                    'additionalTextClass'   => 'inverse-text',
                    'cat'               => $cat_S_Style,
                    'catClass'          => $cat_S_Class.' post__cat-inverse',
                    'thumbSize'         => 'tnm-xs-4_3',
                    'typescale'         => 'typescale-1',
                    'postIcon'          => $postIconAttr,
                );

                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    $maxPost = $the_query->post_count;
                        if($currentPost == 0):
                            $render_modules .= '<div class="section-main">';
                            $postVerticalAttr['postID'] = get_the_ID();
                            if($bypassPostIconDetech != 1) {
                                $addClass = 'overlay-item--md-p';
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
                                }

                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], $iconSize_L, 'top-right', $addClass);
                                
                                $postVerticalAttr['postIcon']    = $postIconAttr;
                            }
                            $render_modules .= $postVerticalHTML->render($postVerticalAttr);
                            $render_modules .= '</div><!-- .section-main -->';
                        elseif( (($currentPost > 0) && ($currentPost < ($maxPost - 2) )) || ($maxPost < 4) ):
                            if($currentPost == 1):
                                $render_modules .= '<div class="section-sub item-order-1  flexbox-wrap flexbox-wrap-2i flex-space-30">';
                                $render_modules .= '<div class="sub-column-left pattern-circle-background-stripe">';
                                $render_modules .= '<div class="posts-list flexbox-wrap flexbox-wrap-1i flex-space-30">';
                            endif;
                            $postOverlayAttr_S['postID'] = get_the_ID();
                            if($bypassPostIconDetech != 1) {
                                $addClass = 'overlay-item--sm-p';
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
                                }

                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], $iconSize_S, 'top-right', $addClass);
                                
                                $postOverlayAttr_S['postIcon']    = $postIconAttr;
                            }
                            $render_modules .= '<div class="list-item">'; 
                            $render_modules .= $postOverlayHTML->render($postOverlayAttr_S);
                            $render_modules .= '</div><!-- .list-item -->';
                            if($currentPost == ($maxPost - 3)):
                                
                            endif;
                        else:
                            if($currentPost == 3):
                                $render_modules .= '</div><!-- .posts-list -->';
                                $render_modules .= '</div><!-- .sub-column-left -->';
                                $render_modules .= '<div class="sub-column-right">';
                                $render_modules .= '<div class="posts-list flexbox-wrap flexbox-wrap-1i flex-space-30">';
                            endif;
                            $render_modules .= '<div class="list-item">';
                            $postOverlayAttr_S['postID'] = get_the_ID();
                            if($bypassPostIconDetech != 1) {
                                $addClass = 'overlay-item--sm-p';
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
                                }

                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], $iconSize_S, 'top-right', $addClass);
                                
                                $postOverlayAttr_S['postIcon']    = $postIconAttr;
                            }
                            $render_modules .= $postOverlayHTML->render($postOverlayAttr_S);
                            $render_modules .= '</div><!-- .list-item -->';
                        endif;
                endwhile;
                if(($currentPost > 0) && ($maxPost < 4)):
                    $render_modules .= '</div><!-- .posts-list -->';
                    $render_modules .= '</div><!-- .sub-column-left -->';
                    $render_modules .= '</div><!-- .section-sub -->'; 
                endif;
                if($currentPost > 2):
                    $render_modules .= '</div><!-- .posts-list -->';
                    $render_modules .= '</div><!-- .sub-column-right -->';
                    $render_modules .= '</div><!-- .section-sub -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}