<?php
if (!class_exists('tnm_posts_block_k')) {
    class tnm_posts_block_k {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_posts_block_k-');
            $moduleConfigs = array();
            $moduleData = array();
            
            self::$pageInfo = $page_info;
            
            //get config
            
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = 5;
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true ); 
            
            $moduleInfo = array(
                'post_source'   => $moduleConfigs['post_source'],
                'post_icon'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true ),
                'iconPosition_L'  => 'top-right',
                'iconPosition_S'  => 'top-right',
                'cat_L'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_l', true ),
                'cat_S'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_s', true ),
                'meta'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta', true ),
                'meta_s'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_s', true ),
                'meta_nothumb_s'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_nothumb_s', true ),
            );
              
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            
            if ( $the_query->have_posts()) :
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-posts-block-k'.$moduleCustomClass.'">';
           	$block_str .= '<div class="container">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
            $block_str .= '</div><!-- .container -->';
            $block_str .= '<div class="mnmd-block__inner flexbox-wrap layout-full-container--left">';
            $block_str .= $this->render_modules($the_query, $moduleInfo);            //render modules
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .mnmd-block -->';
            
            endif;
            
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query, $moduleInfo = ''){
            
            
            $currentPost = 0;
            $render_modules = '';
            
            $iconPosition_L = $moduleInfo['iconPosition_L'];
            $iconPosition_S = $moduleInfo['iconPosition_S'];
            $iconSize_L = 'medium';
            $iconSize_S = '';

            // Category
            $cat_L = $moduleInfo['cat_L'];
            if($cat_L != 0){
                $cat_L_Style = 3; //Top-Left
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            
            $cat_S = $moduleInfo['cat_S'];
            if($cat_S != 0){
                $cat_overlay = 1;
                $cat_S_Style = 3; //Top-left
                $cat_S_Class = tnm_core::bk_get_cat_class($cat_S_Style);
            }else {
                $cat_overlay = '';
                $cat_S_Style = '';
                $cat_S_Class = '';
                $iconPosition_S = 'center';
                $iconSize_S = 'medium';
            }
            $meta = $moduleInfo['meta'];
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }
            $meta_s = $moduleInfo['meta_s'];
            if($meta_s != 0) {
                $metaArray_s = tnm_core::bk_get_meta_list($meta_s);
            }else {
                $metaArray_s = '';
            }

            $meta_nothumb_s = $moduleInfo['meta_nothumb_s'];
            if($meta_nothumb_s != 0) {
                $metaArray_nothumb_s = tnm_core::bk_get_meta_list($meta_nothumb_s);
            }else {
                $metaArray_nothumb_s = '';
            }


            $postSource = $moduleInfo['post_source'];
            $postIcon = $moduleInfo['post_icon'];
            
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }
            
            if ( $the_query->have_posts() ) :
                $postHorizontalHTML = new tnm_horizontal_1;
                $postHorizontalAttr = array (
                    'additionalClass'        => 'post--horizontal-full-width',
                    'additionalThumbClass'   => 'atbs-thumb-object-fit',
                    'cat'                    => $cat_L_Style,
                    'catClass'               => $cat_L_Class,
                    'thumbSize'              => 'tnm-xl-16_9',
                    'typescale'              => 'typescale-3',
                    'except_length'          => 20,
                    'meta'                   => $metaArray,
                    'additionalExcerptClass' =>'line-limit line-limit-3',
                );
                $postNothumbHTML = new tnm_no_thumb_1;
                $postNothumbAttr = array (
                    'additionalClass'       => 'post-no-thumb-only-title-cat',
                    'cat'                   => $cat_S_Style,
                    'catClass'              => $cat_S_Class,
                    'typescale'             => 'typescale-1',
                    'meta'                  => $metaArray_nothumb_s,
                );
                $postOverlayHTML = new tnm_overlay_1;
                $postOverlayAttr = array (
                    'additionalClass'   => 'post--overlay-xs post--overlay-bottom post--overlay-floorfade post--overlay-padding-lg',
                    'cat'               => $cat_overlay,
                    'catClass'          => 'post__cat post__cat--bg cat-theme-bg overlay-item--top-left',
                    'thumbSize'         => 'tnm-xs-4_3',
                    'typescale'         => 'typescale-2',
                    'postIcon'          => $postIconAttr,
                    'meta'            => $metaArray_s,
                );
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    $maxPost = $the_query->post_count;
                    if($currentPost < 3):
                        if($currentPost == 0):
                            $render_modules .= '<div class="section-main flexbox-wrap flexbox-wrap-direction-column">';
                            $render_modules .= '<div class="post-main">';
                            $postHorizontalAttr['postID'] = get_the_ID();
                            if($bypassPostIconDetech != 1) {
                                $addClass = '';
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
                                }

                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], $iconSize_L, 'top-right', $addClass);
                                
                                $postHorizontalAttr['postIcon']    = $postIconAttr;
                            }
                            $render_modules .= $postHorizontalHTML->render($postHorizontalAttr);
                            $render_modules .= '</div><!-- .post-main -->';
                        else:
                            if($currentPost == 1):
                                $render_modules .= '<div class="post-sub flexbox-space-y-bottom">';
                                $render_modules .= '<div class="posts-list list-space-md list-seperated list-unstyled">';
                            endif;
                            $postNothumbAttr['postID'] = get_the_ID();
                            $render_modules .= '<div class="list-item">';
                            $render_modules .= $postNothumbHTML->render($postNothumbAttr);
                            $render_modules .= '</div><!-- .list-item -->';
                            if($currentPost == 2):
                                $render_modules .= '</div><!-- .posts-list -->';
                                $render_modules .= '</div><!-- .post-sub -->';
                                $render_modules .= '</div><!-- .section-main -->';
                            endif;
                        endif;
                    else:
                        if($currentPost == 3):
                            $render_modules .= '<div class="section-sub">';
                            $render_modules .= '<div class="posts-list flexbox-wrap flex-space-15 flexbox-wrap-1i">';
                        endif;
                            $postOverlayAttr['postID'] = get_the_ID();
                            if($bypassPostIconDetech != 1) {
                                $addClass = 'overlay-item--sm-p';
                                if($postSource != 'all') {
                                    $postIconAttr['iconType'] = $postSource;
                                }else {
                                    $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
                                }

                                $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], $iconSize_S, 'top-right', $addClass);
                                
                                $postOverlayAttr['postIcon']    = $postIconAttr;
                            }
                            $render_modules .= '<div class="list-item">';
                            $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                            $render_modules .= '</div><!-- .list-item -->';
                        if( $currentPost == ($maxPost - 1)):
                            $render_modules .= '</div><!-- .posts-list -->';
                            $render_modules .= '</div><!-- .section-sub -->';
                        endif;
                    endif;
                endwhile;
                if($currentPost == 0):
                    $render_modules .= '</div><!-- .section-main -->';
                elseif($currentPost == 1):
                    $render_modules .= '</div><!-- .posts-list -->';
                    $render_modules .= '</div><!-- .post-sub -->';
                    $render_modules .= '</div><!-- .section-main -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}