<?php
if (!class_exists('tnm_posts_block_h')) {
    class tnm_posts_block_h {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_posts_block_h-');
            $moduleConfigs = array();
            $moduleData = array();
            
            self::$pageInfo = $page_info;
            
            //get config
            
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true );
            $moduleConfigs['limit']     = 6; // 6
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            
             //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleConfigs['post_icon'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true ); 
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            
            if ( $the_query->have_posts()) :
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-posts-block-h has-background'.$moduleCustomClass.'">';
            $block_str .= '<div class="container">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
            $block_str .= '<div class="mnmd-block__inner">';
            $block_str .= '<div class="posts-list flexbox-wrap flex-space-30">';
            $block_str .= $this->render_modules($the_query);            //render modules
            $block_str .= '</div><!-- .posts-list -->';
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .container -->';
            $block_str .= '</div><!-- .mnmd-block -->';
            endif;
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
        }
        public function render_modules ($the_query){
            
            $currentPost = 0;
            $postCount = $the_query->post_count;
            $iconPosition_S = 'center';
            
            // Category
            $cat_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_l', true );
            if($cat_L != 0){
                $cat_L_Style = 4; //Category Top Left
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            
            $cat_S = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_s', true );            
            if($cat_S != 0){
                $cat_S_Style = 2; // Overlap
                $cat_S_Class = tnm_core::bk_get_cat_class($cat_S_Style);
                $articleAddtionalClass = '';
            }else {
                $articleAddtionalClass = 'cat--not-overlap';
                $cat_S_Style = '';
                $cat_S_Class = '';
            }
            // Meta
            $meta_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta_l', true );
            $meta_S = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta_s', true );
            
            if($meta_L != 0) {
                $metaArray_L = tnm_core::bk_get_meta_list($meta_L);
            }else {
                $metaArray_L = '';
            }
            if($meta_S != 0) {
                $metaArray_S = tnm_core::bk_get_meta_list($meta_S);
            }else {
                $metaArray_S = '';
            }
            
            $excerpt_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt_l', true );
            
            if($excerpt_L == 1){
                $excerptLength = 15;
            }else {
                $excerptLength = '';
            }
            //Footer Style
            $footerArgs = array();
            $footerStyle_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_footer_style_l', true );
            $footerArgs_L = tnm_core::bk_overlay_footer_style($footerStyle_L);
            
            $footerStyle_S = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_footer_style_s', true );
            
            $postSource = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_source', true );
            $postIcon = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_icon', true );
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }
            $render_modules = '';
            if ( $the_query->have_posts() ) :
                $postNothumbHTML = new tnm_no_thumb_1;
                $postNothumbAttr = array (
                    'additionalClass'       => 'post-no-thumb-has-background post-cat-no-thumb',
                    'additionalTextClass'       => 'text-center',
                    'cat'                   => $cat_L_Style,
                    'catClass'              => $cat_L_Class,
                    'meta'                  => $metaArray_L,
                    'typescale'             => 'typescale-3',
                    'except_length'         => $excerptLength,
                    'additionalExcerptClass'=> 'line-limit line-limit-3',
                    'postIcon'              => $postIconAttr,
                );
                $postCardHTML = new tnm_card_1;
                $postCardAttr = array (
                    'cat'               => $cat_S_Style,
                    'catClass'          => $cat_S_Class,
                    'additionalClass'   => 'post--card-sm text-center '.$articleAddtionalClass,
                    'thumbSize'         => 'tnm-xs-16_9 400x225',
                    'typescale'         => 'typescale-1',
                    'meta'              => $metaArray_S,    
                    'footerType'        => 'center',
                    'postIcon'          => $postIconAttr,                        
                );
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    $postNothumbAttr['postID'] = get_the_ID();
                    if(($currentPost == 0) || ($currentPost == 4) ) {
                        $render_modules .= '<div class="list-item flexbox-item-50">';
                        $render_modules .= $postNothumbHTML->render($postNothumbAttr);
                        $render_modules .= '</div>';
                    }else{
                        $postCardAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            $postCardAttr['postID'] = get_the_ID();
                            $addClass = 'overlay-item--sm-p';
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'small', 'center', $addClass);
                            $postCardAttr['postIcon']       = $postIconAttr;
                        }
                        $render_modules .= '<div class="list-item flexbox-item-25">';
                        $render_modules .= $postCardHTML->render($postCardAttr);
                        $render_modules .= '</div>';
                    }
                endwhile;
            endif;
            return $render_modules;
        }
    }
}