<?php
if (!class_exists('tnm_featured_block_o')) {
    class tnm_featured_block_o {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_featured_block_o-');
            $carouselID = uniqid('carousel-');
            $moduleConfigs = array();
            $moduleData = array();
            
            self::$pageInfo = $page_info;
            
            //get config
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );     
            $moduleConfigs['carousel_loop'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_carousel_loop', true );
            $moduleConfigs['carousel_nav'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_carousel_nav', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_limit', true );
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = $moduleConfigs['custom_class'].' ';
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleConfigs['post_icon'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true );      
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            
            if($the_query->post_count < 4):
                $moduleConfigs['carousel_loop'] = 0;
            endif;
            
            if($moduleConfigs['carousel_nav'] != 1) {
                $dotNavClass = 'mnmd-carousel-nav-none';
            }else {
                $dotNavClass = '';
            }
            
            if ( $the_query->have_posts() ) :
                $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-featured-block-o'.$moduleCustomClass.'">';
               	$block_str .= '<div class="container">';
                $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
                $block_str .= '</div><!-- .container -->';
                $block_str .= '<div class="mnmd-block__inner">';
                $block_str .= '<div class="mnmd-block__inner-group">';
                $block_str .= $this->render_modules($the_query);            //render modules
                $block_str .= '</div><!-- .mnmd-block__inner-group -->';
                $block_str .= '</div><!-- .mnmd-block__inner -->';
                $block_str .= '</div><!-- .mnmd-block -->';         
            endif;
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query){
            
            $render_modules = '';
            $iconPosition = 'top-right';
            $carousel_loop = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_carousel_loop', true );
            $carousel_nav = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_carousel_nav', true );
            if(($carousel_loop == '') || ($carousel_loop == null) ){
                $carousel_loop = 'true';
            }
            if(($carousel_nav == '') || ($carousel_nav == null) ){
                $carousel_nav = 1;
            }
            if($carousel_nav != 1) {
                $NavClass = ' mnmd-carousel-nav-none';
            }else {
                $NavClass = '';
            }
            // Category Style ($cat)
            $cat = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat', true );
            if($cat != 0){
                $catStyle = 4; // Category Above Title (Has Background)
                $cat_Class = tnm_core::bk_get_cat_class($catStyle);
            }else {
                $catStyle = '';
                $cat_Class = '';
            }
            $excerpt = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt', true );
            
            if($excerpt == 1){
                $excerptLength = 20;
            }else {
                $excerptLength = '';
            }

            $meta = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta', true );
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }
            $postSource = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_source', true );
            $postIcon = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_icon', true );
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }
            if ( $the_query->have_posts() ) :
                $postOverlayHTML = new tnm_overlay_4;
                $postOverlayAttr = array (
                    'additionalClass'     => 'post--overlay-featured-fullwidth-text-center post--overlay-middle post--overlay-lg post--overlay-padding-lg',
                    'additionalBGClass'   => 'background-img--darkened',
                    'additionalTextClass' => 'inverse-text container',
                    'thumbSize'           => 'tnm-xxl',
                    'cat'                 => $catStyle,
                    'catClass'            => $cat_Class,
                    'except_length'       => $excerptLength,
                    'meta'                => $metaArray,
                    'typescale'           => 'typescale-4',
                    'postIcon'            => $postIconAttr,                        
                );
                $currentPost = 0;
                $maxPost = $the_query->post_count;
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    if($currentPost == 0):
                        if($maxPost > 1):
                            $render_modules .= '<div class="owl-carousel mnmd-carousel js-carousel-1i0m-transition dots-circle dots-white owl-nav-square'.esc_attr($NavClass).'" data-carousel-loop="'.esc_attr($carousel_loop).'">';
                        else:
                            $render_modules .= '<div class="owl-carousel-under-post">';
                        endif;
                            
                    endif;
                    $postOverlayAttr['postID'] = get_the_ID();
                    $render_modules .= '<div class="slide-content">';
                    $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                    $render_modules .= '</div>';
                endwhile;
                if($currentPost >= 0):
                    $render_modules .= '</div><!-- .owl-carousel -->';
                endif;
            endif;
            
            return $render_modules;
        }
    }
}
/*if($bypassPostIconDetech != 1) {
    if($postSource != 'all') {
        $postIconAttr['iconType'] = $postSource;
    }else {
        $postIconAttr['iconType']   = tnm_core::bk_post_format_detect(get_the_ID());
    }
    
    if($iconPosition == 'left-bottom') {
        $postOverlayHTML = new tnm_overlay_icon_side_left;
        if($postIconAttr['iconType'] != 'gallery') { 
            $postIconAttr['postIconClass']  = '';
        }else {
            $postIconAttr['postIconClass']  = 'overlay-item gallery-icon';
        }
        $postOverlayAttr['additionalTextClass'] = 'inverse-text';
    }else if($iconPosition == 'right-bottom') {
        $postOverlayHTML = new tnm_overlay_icon_side_right;
        if($postIconAttr['iconType'] != 'gallery') { 
            $postIconAttr['postIconClass']  = '';
        }else {
            $postIconAttr['postIconClass']  = 'overlay-item gallery-icon';
        }
        $postOverlayAttr['additionalTextClass'] = 'inverse-text';
    }else {
        if($postIconAttr['iconType'] == 'gallery') {
            $postIconAttr['postIconClass']  = 'overlay-item gallery-icon';
        }else {
            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], '', $iconPosition);
        }
    }
    
    $postOverlayAttr['postIcon']    = $postIconAttr;
}*/