<?php
if (!class_exists('tnm_featured_block_k')) {
    class tnm_featured_block_k {
        static $pageInfo=0;
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_featured_block_k-');
            $moduleConfigs = array();
            $moduleData = array();
            
            //get config
            
            $moduleConfigs['title'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_limit', true );
            $moduleConfigs['offset'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['ajax_load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_ajax_load_more', true );
            $viewallButton = array();
            if ($moduleConfigs['ajax_load_more'] == 'viewall') :            
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleInfo = array(
                'post_source'   => $moduleConfigs['post_source'],
                'post_icon'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true ),
                'iconPosition'  => 'center',
                'meta_l'          => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_l', true ),
                'cat_l'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_l', true ), // Category Style
                'excerpt_l'       => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_excerpt_l', true ),
                'meta_s'          => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_meta_s', true ),
                'cat_s'           => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_cat_s', true ), // Category Style
                'excerpt_s'       => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_excerpt_s', true ),
            );
            tnm_core::bk_add_buff('query', $moduleID, 'moduleInfo', $moduleInfo);
            $increaseOffset = 1;
            $the_query = bk_get_query::tnm_query($moduleConfigs, $moduleID, $increaseOffset);              //get query
            
            $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-featured-block-k'.$moduleCustomClass.'">';
            $block_str .= '<div class="container">';
            $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass);
            $block_str .= '</div><!-- .container -->';
            $block_str .= '<div class="mnmd-block__inner">';
            $block_str .= '<div class="mnmd-block__inner-group flexbox-wrap">';
            if ( $the_query->have_posts() ) :
                $block_str .= $this->render_modules_left($the_query, $moduleInfo);            //render modules
                if($the_query->have_posts()):
                    $block_str .= '<div class="section-sub">';
                    if($moduleConfigs['ajax_load_more'] == 'loadmore') {
                        $block_str .= '<div class="js-ajax-load-post" data-posts-to-load="'.$moduleConfigs['limit'].'">';
                    }
                    $block_str .= '<div class="posts-list flexbox-wrap flex-space-60 flexbox-wrap-1i">';
                    $block_str .= $this->render_modules($the_query, 0, $moduleInfo); 
                    $currentPost = $the_query->current_post;
                    $block_str .= '</div>';
                    $tnmMaxPages = tnm_ajax_function::max_num_pages_cal($the_query, $moduleConfigs['offset'], $moduleConfigs['limit']);
                    $block_str .= tnm_ajax_function::ajax_load_buttons($moduleConfigs['ajax_load_more'], $tnmMaxPages, $viewallButton);
                    if($moduleConfigs['ajax_load_more'] == 'loadmore') {
                        $block_str .= '</div><!-- .js-ajax-load-post-->';
                    }
                    $block_str .= '</div><!-- .section-sub -->';
                endif;
            endif;
            $block_str .= '</div><!-- .mnmd-block__inner-group -->';
            $block_str .= '</div><!-- .mnmd-block__inner -->';
            $block_str .= '</div><!-- .mnmd-block -->';
                        
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
        }
        
        public function render_modules_left($the_query, $moduleInfo = ''){
            $render_modules = '';
            
            $postSource = $moduleInfo['post_source'];
            $postIcon = $moduleInfo['post_icon'];
            $iconPosition = 'top-right';
            $iconSize = 'medium';
            $cat = $moduleInfo['cat_l'];
            if($cat != 0){
                $catStyle = 4;
                $cat_Class = tnm_core::bk_get_cat_class($catStyle);
            }else {
                $catStyle = '';
                $cat_Class = '';
            }
            $meta = $moduleInfo['meta_l'];
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }
            if ( $the_query->have_posts() ) :
                $postOverlayHTML = new tnm_overlay_1;                        
                $postOverlayAttr = array (
                    'additionalClass'    => 'post--overlay-large-featured post--overlay-md post--overlay-middle post--overlay-padding-lg',
                    'additionalTextClass'=> 'inverse-text text-center',
                    'cat'                => $catStyle,
                    'catClass'           => $cat_Class.' post__cat-inverse',
                    'thumbSize'          => 'tnm-xl-4_3',
                    'typescale'          => 'typescale-5',
                    'meta'                   => $metaArray,
                    'postIcon'           => $postIconAttr,  
                );
                while ( $the_query->have_posts() ): $the_query->the_post();   
                    $currentPost = $the_query->current_post;
                    if($currentPost == 0):
                        $postOverlayAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], $iconSize, $iconPosition);
                            
                            $postOverlayAttr['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= '<div class="section-main js-sticky-sidebar">';
                        $render_modules .= '<div class="section-main-wrap">';
                        $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                        $render_modules .= '</div><!-- .section-main-wrap --> ';
                        $render_modules .= '</div><!-- .section-main --> ';
                         break;
                    endif;
                endwhile;
                
            endif;
            
            return $render_modules;
        }
        public function render_modules($the_query, $the__lastPost = 0, $moduleInfo = ''){
            $render_modules = '';
            $postSource = $moduleInfo['post_source'];
            $postIcon = $moduleInfo['post_icon'];
            $iconPosition = 'top-right';
            $iconSize = 'small';
            
            $cat = $moduleInfo['cat_s'];
            if($cat != 0){
                $catStyle = 3;
                $cat_Class = tnm_core::bk_get_cat_class($catStyle);
            }else {
                $catStyle = '';
                $cat_Class = '';
            }
            
            $meta = $moduleInfo['meta_s'];
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }
            $excerpt = $moduleInfo['excerpt_s'];
            if($excerpt == 1){
                $excerptLength = 15;
            }else {
                $excerptLength = '';
            }
            
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }    
            
            if ( $the_query->have_posts() ) :
                $postHorizontalHTML = new tnm_horizontal_1;                        
                $postHorizontalAttr = array (
                    'additionalClass'        => 'post--horizontal-large-normal post--horizontal-middle',
                    'additionalThumbClass'   => 'atbs-thumb-object-fit',
                    'thumbSize'              => 'tnm-xs-1_1',
                    'cat'                    => $catStyle,
                    'catClass'               => $cat_Class,
                    'typescale'              => 'typescale-3',
                    'except_length'          => $excerptLength,
                    'additionalExcerptClass' => 'line-limit line-limit-3',
                    'meta'                   => $metaArray,
                    'postIcon'          => $postIconAttr,  
                );
                $currentPost = '';
                $maxPost = $the_query->current_count; 
                while ( $the_query->have_posts() ): $the_query->the_post();   
                    $currentPost = $the_query->current_post; 
                    $postHorizontalAttr['postID'] = get_the_ID();
                    if($bypassPostIconDetech != 1) {
                        if($postSource != 'all') {
                            $postIconAttr['iconType'] = $postSource;
                        }else {
                            $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                        }
                        
                        $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], $iconSize, $iconPosition, 'overlay-item--sm-p');
                        
                        $postHorizontalAttr['postIcon'] = $postIconAttr;
                    }
                    $render_modules .= '<div class="list-item">';
                    $render_modules .= $postHorizontalHTML->render($postHorizontalAttr);
                    $render_modules .= '</div>';  
                endwhile;
            endif;
            return $render_modules;
        }
    }
}