<?php
if (!class_exists('tnm_featured_block_j')) {
    class tnm_featured_block_j {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_featured_block_j-');
            $moduleConfigs = array();
            $moduleData = array();
            self::$pageInfo = $page_info;
            //get config
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = 4;
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleConfigs['post_icon'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true );      
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            
            
            if ( $the_query->have_posts() ) :
                $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-featured-block-j'.$moduleCustomClass.'">';
               	$block_str .= '<div class="container">';
                $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
                $block_str .= '</div><!-- .container -->';
                $block_str .= '<div class="mnmd-block__inner">';
                $block_str .= '<div class="mnmd-block__inner-group">';
                $block_str .= $this->render_modules($the_query);            //render modules
                $block_str .= '</div><!-- .mnmd-block__inner-group -->';
                $block_str .= '</div><!-- .mnmd-block__inner -->';
                $block_str .= '</div><!-- .mnmd-block -->';
                        
            endif;
            
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query){
            
            $render_modules = '';
            $iconPosition = 'top-right';

            // Category Style ($cat)
            $cat_l = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_l', true );
            $cat_s = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_s', true );
            if($cat_s != 0){
                $cat_S_Style = 3;
                $cat_S_Class = tnm_core::bk_get_cat_class($cat_S_Style);
                $cat_overlay_S_Style = 4;
                $cat_overlay_S_Class = tnm_core::bk_get_cat_class($cat_overlay_S_Style);
            }else {
                $cat_S_Style = '';
                $cat_S_Class = '';
                $cat_overlay_S_Style = '';
                $cat_overlay_S_Class = '';
            }
            if($cat_l != 0){
                $cat_L_Style = 3;
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            $excerpt_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt_l', true );
            
            if($excerpt_L == 1){
                $excerptLength = 25;
            }else {
                $excerptLength = '';
            }
            $excerpt_S = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt_s', true );
            
            if($excerpt_S == 1){
                $excerptLength_s = 15;
            }else {
                $excerptLength_s = '';
            }
            if($excerptLength_s == 15){
                $excerptLength_s_horizontal = 10;
            }else{
                $excerptLength_s_horizontal = 0;
            }
            $meta = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta', true );
            if($meta != 0) {
                $metaArray = tnm_core::bk_get_meta_list($meta);
            }else {
                $metaArray = '';
            }

            $meta_s = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_meta_s', true );
            if($meta_s != 0) {
                $metaArray_s = tnm_core::bk_get_meta_list($meta_s);
            }else {
                $metaArray_s = '';
            }

            $postSource = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_source', true );
            $postIcon = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_icon', true );
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }     
            
            if ( $the_query->have_posts() ) :
                $postHorizontalHTML = new tnm_horizontal_1;
                $postHorizontalAttr = array (
                    'additionalClass'          => 'post--horizontal-medium-normal post--horizontal-md',
                    'thumbSize'                => 'tnm-xxs-1_1',
                    'cat'                      => $cat_S_Style,
                    'catClass'                 => $cat_S_Class,
                    'typescale'                => 'typescale-2',  
                    'except_length'            => $excerptLength_s_horizontal,
                    'additionalExcerptClass'   => 'disable-tablet line-limit line-limit-3',                    
                );
                $postOverlayHTML = new tnm_overlay_5;
                $postOverlayAttr = array (
                    'additionalClass'            => 'post--overlay-background-theme post--overlay-md post--overlay-padding-lg',
                    'additionalTextClass'        => 'inverse-text',
                    'additionalTextInnerClass'   => 'flexbox-wrap flexbox-wrap-1i flexbox-wrap-direction-column',
                    'thumbSize'                  => 'tnm-xl-16_9',
                    'cat'                        => $cat_overlay_S_Style,
                    'catClass'                   => $cat_overlay_S_Class.' post__cat-inverse',
                    'except_length'              => $excerptLength_s,
                    'meta'                       => $metaArray_s,
                    'additionalExcerptClass'     => 'line-limit line-limit-3',
                    'additionalReadmoreClass'    => 'text-right flexbox-space-y-bottom flexbox-space-y',
                    'typescale'                  => 'typescale-3',                      
                );
                $postVerticalHTML = new tnm_vertical_1_group_post_text;
                $postVerticalAttr = array (
                    'additionalClass'          => 'post--vertical-reverse-text-three-row flexbox-wrap',
                    'additionalThumbClass'     => 'atbs-thumb-object-fit',
                    'additionalTextClass'      => 'item-order-1 container',
                    'additionalTextGroupClass' => 'flexbox-wrap flex-space-100',
                    'thumbSize'                => 'tnm-xxl',
                    'cat'                      => $cat_L_Style,
                    'catClass'                 => $cat_L_Class,
                    'except_length'            => $excerptLength,
                    'meta'                     => $metaArray,
                    'additionalExcerptClass'   => 'line-limit line-limit-3',
                    'additionalReadmoreClass'  => 'text-right',
                    'typescale'                => 'typescale-4',                      
                );
                $maxPost = $the_query->post_count;
                $currentPost = '';
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    if($currentPost == 0):
                        $render_modules .= '<div class="section-main">';
                        $postVerticalAttr['postID'] = get_the_ID();
                        $render_modules .= $postVerticalHTML->render($postVerticalAttr);
                        $render_modules .= '</div><!-- .section-main-->';
                    elseif($currentPost == 1):
                        $render_modules .= '<div class="section-sub layout-full-container--left flexbox-wrap">';
                        $render_modules .= '<div class="sub-column-left">';
                        $postOverlayAttr['postID'] = get_the_ID();
                        $render_modules .= $postOverlayHTML->render($postOverlayAttr);
                        $render_modules .= '</div><!-- .sub-column-left -->';
                    elseif($currentPost > 1):
                        if($currentPost == 2):
                            $render_modules .= '<div class="sub-column-right">';
                            $render_modules .= '<div class="posts-list flexbox-wrap flex-space-30">';
                        endif;
                        $render_modules .= '<div class="list-item">';
                        $postHorizontalAttr['postID'] = get_the_ID();
                        if($bypassPostIconDetech != 1) {
                            if($postSource != 'all') {
                                $postIconAttr['iconType'] = $postSource;
                            }else {
                                $postIconAttr['iconType'] = tnm_core::bk_post_format_detect(get_the_ID());
                            }
                            $postIconAttr['postIconClass']  = tnm_core::get_post_icon_class($postIconAttr['iconType'], 'small', $iconPosition, 'overlay-item--sm-p');
                            
                            $postHorizontalAttr['postIcon'] = $postIconAttr;
                        }
                        $render_modules .= $postHorizontalHTML->render($postHorizontalAttr);
                        $render_modules .= '</div><!-- .list-item -->';
                    endif;
                endwhile;
                if($currentPost >= 1):
                    if($currentPost > 1):
                        $render_modules .= '</div><!-- .posts-list -->';
                        $render_modules .= '</div><!-- .sub-column-right -->';
                    endif;
                    $render_modules .= '</div><!-- .section-sub -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}
