<?php
if (!class_exists('tnm_featured_block_i')) {
    class tnm_featured_block_i {
        
        static $pageInfo=0;
        
        public function render( $page_info ) {
            $block_str = '';
            $moduleID = uniqid('tnm_featured_block_i-');
            $carouselID = uniqid('carousel-');
            $moduleConfigs = array();
            $moduleData = array();
            
            self::$pageInfo = $page_info;
            
            //get config
            $moduleConfigs['title']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true );     
            $moduleConfigs['carousel_loop'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_carousel_loop', true );
            $moduleConfigs['orderby']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_orderby', true );
            $moduleConfigs['tags']      = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_tags', true ); 
            $moduleConfigs['limit']     = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_limit', true );
            $moduleConfigs['offset']    = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_offset', true );
            $moduleConfigs['feature']   = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_feature', true );
            $moduleConfigs['category_id'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_category', true );
            $moduleConfigs['editor_pick'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_pick', true );
            $moduleConfigs['editor_exclude'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_editor_exclude', true );
            $moduleConfigs['load_more'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_load_more', true );
            
            $moduleConfigs['custom_class']  = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_custom_class', true );
            if($moduleConfigs['custom_class'] != '') {
                $moduleCustomClass = ' '.$moduleConfigs['custom_class'];
            }else {
                $moduleCustomClass = '';
            }
            
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $viewallButton = array();
            if (($moduleConfigs['load_more'] == 'viewall') && ($moduleConfigs['heading_style'] != 'center') && ($moduleConfigs['heading_style'] != 'large-center') && ($moduleConfigs['heading_style'] != 'line-around') && ($moduleConfigs['heading_style'] != 'large-line-around')) :           
                $viewallButton['view_all_link'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_link', true );
                $viewallButton['view_all_text'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_text', true );
                $viewallButton['view_all_target'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_view_all_target', true );
            endif;
            
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = tnm_core::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            //Post Source & Icon
            $moduleConfigs['post_source'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_source', true );
            $moduleConfigs['post_icon'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_post_icon', true );      
            $the_query = bk_get_query::tnm_query($moduleConfigs);              //get query
            
            $carousel_loop = array(
                'carousel_loop' => $moduleConfigs['carousel_loop']
            );
            
            if ( $the_query->have_posts() ) :
                $block_str .= '<div id="'.$moduleID.'" class="mnmd-block mnmd-block--fullwidth mnmd-featured-block-i'.$moduleCustomClass.'">';
               	$block_str .= '<div class="container">';
                $block_str .= tnm_core::bk_get_block_heading($moduleConfigs['title'], $headingClass, $viewallButton);
                $block_str .= '</div><!-- .container -->';
                $block_str .= '<div class="mnmd-block__inner">';
                $block_str .= '<div class="mnmd-block__inner-group">';
                $block_str .= $this->render_modules($the_query,$carousel_loop);            //render modules
                $block_str .= '</div><!-- .mnmd-block__inner-group -->';
                $block_str .= '</div><!-- .mnmd-block__inner -->';
                $block_str .= '</div><!-- .mnmd-block -->';
                        
            endif;
            
            unset($moduleConfigs); unset($the_query);     //free
            wp_reset_postdata();
            return $block_str;            
    	}
        public function render_modules ($the_query, $carousel_loop = ''){
            
            $render_modules = '';
            $Carousel_loop = $carousel_loop['carousel_loop'];
            $iconPosition = 'top-right';

            // Category Style ($cat)
            $cat_l = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_l', true );
            $cat_s = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_cat_s', true );
            if($cat_s != 0){
                $cat_S_Style = 4;
                $cat_S_Class = tnm_core::bk_get_cat_class($cat_S_Style);
            }else {
                $cat_S_Style = '';
                $cat_S_Class = '';
            }
            if($cat_l != 0){
                $cat_L_Style = 3;
                $cat_L_Class = tnm_core::bk_get_cat_class($cat_L_Style);
            }else {
                $cat_L_Style = '';
                $cat_L_Class = '';
            }
            $excerpt_L = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_excerpt_l', true );
            
            if($excerpt_L == 1){
                $excerptLength = 15;
            }else {
                $excerptLength = '';
            }

            $postSource = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_source', true );
            $postIcon = get_post_meta( self::$pageInfo['page_id'], self::$pageInfo['block_prefix'].'_post_icon', true );
            $bypassPostIconDetech = 0;         
            $postIconAttr = array(); 
            $postIconAttr['postIconClass'] = '';
            $postIconAttr['iconType'] = '';
            
            if($postIcon == 'disable') {
                $bypassPostIconDetech = 1;
            }else {
                $bypassPostIconDetech = 0;
            }     
            
            if ( $the_query->have_posts() ) :
                $postHorizontalHTML = new tnm_horizontal_1;
                $postHorizontalAttr = array (
                    'additionalClass'   => 'post--horizontal-small-has-padding post--horizontal-middle post--horizontal-xs',
                    'thumbSize'         => 'tnm-xs-1_1',
                    'cat'               => $cat_S_Style,
                    'catClass'          => $cat_S_Class.' cat-hover-inverse',
                    'typescale'         => 'typescale-0 line-limit line-limit-2',                      
                );
                $postHorizontalHTML_L = new tnm_horizontal_not_thumb;
                $postHorizontalAttr_L = array (
                    'additionalClass'        => 'post--horizontal-fullwidth-feature-reverse post--horizontal-reverse post--horizontal-middle',
                    'additionalThumbClass'   => 'atbs-thumb-object-fit',
                    'thumbSize'              => 'tnm-xxl',
                    'cat'                    => $cat_L_Style,
                    'catClass'               => $cat_L_Class.' cat-hover-inverse',
                    'except_length'          => $excerptLength,
                    'additionalExcerptClass' => 'line-limit line-limit-3',
                    'typescale'              => 'typescale-4 border-bottom-md',
                    'postIcon'               => $postIconAttr,                        
                );
                $maxPost = $the_query->post_count;
                if(($maxPost < 2) || ($maxPost == 4)):
                    $Carousel_loop = 0;
                endif;
                $currentPost = '';
                while ( $the_query->have_posts() ): $the_query->the_post();
                    $currentPost = $the_query->current_post;
                    
                    if( (($currentPost >= 0) && ($currentPost < ($maxPost - 3))) || (($maxPost < 4) && ($currentPost >= 0))  ):
                        if($currentPost == 0):
                            $render_modules .= '<div class="section-main layout-full-container--right">';
                            if(($maxPost == 1) || ($maxPost == 4)):
                                $render_modules .= '<div class="carousel">';
                            else:
                                $render_modules .= '<div class="owl-carousel mnmd-carousel js-carousel-1i30m-data-loop dots-vertical dots-circle dots-white" data-carousel-loop="'.$Carousel_loop.'">';
                            endif;
                        endif;
                        $postHorizontalAttr_L['postID'] = get_the_ID();
                        $render_modules .= '<div class="slide-content">';
                        $render_modules .= $postHorizontalHTML_L->render($postHorizontalAttr_L);
                        $render_modules .= '</div>';
                        if($currentPost == ($maxPost - 4)):
                            $render_modules .= '</div><!-- .owl-carousel -->';
                            $render_modules .= '</div><!-- .section-main -->';
                        endif; 
                    elseif(($currentPost > ($maxPost - 4) && ($maxPost > 3)) ):
                        if($currentPost == ($maxPost - 3)):
                            $render_modules .= '<div class="section-sub">';
                            $render_modules .= '<div class="container">';
                            $render_modules .= '<div class="posts-list flexbox-wrap flexbox-wrap-3i">';
                            $render_modules .= '<div class="list-item active">';
                        else:
                            $render_modules .= '<div class="list-item">';
                        endif;
                            $postHorizontalAttr['postID'] = get_the_ID();
                            $render_modules .= $postHorizontalHTML->render($postHorizontalAttr);
                            $render_modules .= '</div><!-- .list-item -->';
                        if($currentPost == ($maxPost - 1)):
                            $render_modules .= '</div><!-- .posts-list -->';
                            $render_modules .= '</div><!-- .container -->';
                            $render_modules .= '</div><!-- .section-sub -->';
                        endif;
                    endif;
                endwhile;
                if($maxPost < 4):
                    $render_modules .= '</div><!-- .owl-carousel -->';
                    $render_modules .= '</div><!-- .section-main -->';
                endif;
            endif;
            return $render_modules;
        }
    }
}