<?php
/*Front end view of project shortcode
==================================*/
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$paged = (get_query_var('paged'))?get_query_var('paged'):1;
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );

	if($project_grid_column==2)
	{
		$carousel_col_class = 6;
	}
	elseif($project_grid_column==4)
	{
		$carousel_col_class = 3;
	}
	elseif($project_grid_column==3)
	{
		$carousel_col_class = 4;
	}
	elseif($project_grid_column==6)
	{
		$carousel_col_class = 2;
	}
	elseif($project_grid_column==12)
	{
		$carousel_col_class = 1;
	}
	$post_output = '<div class="'.esc_attr( $css_class ).'">';
	// Project Filters
	if($project_filters_style == 'pills'){
		$filter_style = 'nav-pills';
	} else {
		$filter_style = 'nav-tabs nav-justified ';
	}
	if($project_filters == 1 && $project_view != "carousel"){
		if($project_terms!=''){
			$project_cats = explode(',', $project_terms);
		} else {
			$project_cats = get_terms('project-category');
		}
		if($project_cats != array()){
			$post_output .= '<ul class="project-filter-nav nav '.$filter_style.' sort-source" data-sort-id="portfolio" data-option-key="filter">';
			$post_output .= '<li data-option-value="*" class="active"><a href="#"><span>' .esc_html__('Show All', 'tentered').'</span></a></li>';
			foreach($project_cats as $project_cat) {
				if($project_terms!=''){
					$term = get_term( $project_cat, 'project-category' );
				} else {
					$term = $project_cat;
				}
				$post_output .= '<li data-option-value=".cat-'.$term->slug.'"><a href="#"><span>'. $term->name.'</span></a></li>';
			}
			$post_output .= '</ul>';
		}
	} else {
		$post_output .= '';
	}
	if($project_view=="carousel"){
		$post_output .= '<div class="carousel-wrapper">';
	} else {
		if($project_spacing == 'spaced'){
			$post_output .= '<div class="row">';
		}
	}
	if($project_view=="carousel")
	{
		if ( is_rtl() )
		{
			$data_rtl = 'data-rtl="rtl"';
		}
		else
		{
			$data_rtl = 'data-rtl="ltr"';
		}
		if($project_carousel_arrows==1){
			$carrows = 'yes';
		} else {
			$carrows = 'no';
		}
		if($project_carousel_pagi==1){
			$cpagi = 'yes';
		} else {
			$cpagi = 'no';
		}
		if($project_carousel_rotate!=''){
			$cauto = $project_carousel_rotate;
		} else {
			$cauto = '';
		}
		$post_output .= '<div class="row"><ul class="owl-carousel carousel-fw project-carousel" data-columns="'.esc_attr($carousel_col_class).'" data-autoplay="'.$cauto.'" data-pagination="'.$cpagi.'" data-arrows="'.$carrows.'" data-single-item="no" data-items-desktop="'.esc_attr($carousel_col_class).'" data-items-desktop-small="'.esc_attr($carousel_col_class).'" data-items-tablet="2" data-items-mobile="1" '.$data_rtl.'>';
	}
	elseif($project_view=="grid")
	{
		$post_output .= '<ul class="portfolio-list isotope sort-destination" data-sort-id="portfolio">';
	}
	
	if($project_terms!='')
	{
		$terms = explode(',', $project_terms);
		$post_args = array('post_type'=>'project', 'posts_per_page'=>$project_number, 'paged' => $paged, 'tax_query'=>array(array('taxonomy'=>'project-category', 'field'=>'term_id', 'terms'=>$terms, 'operator'=>'IN')));
	}
	else
	{
		$post_args = array('post_type'=>'project', 'posts_per_page'=>$project_number, 'paged' => $paged);
	}
	
	$post_list = new WP_Query($post_args);
	if($post_list->have_posts()):while($post_list->have_posts()):$post_list->the_post();
	$thumbnail = '';
	if($project_img_size != ''){
		$post_thumbnail = wpb_getImageBySize( array('post_id' => get_the_ID(),'thumb_size' => $project_img_size) );
		$post_full_thumbnail = get_the_post_thumbnail_url(get_the_ID(),'full');
		$thumbnail = $post_thumbnail['thumbnail'];
	} else {
		$post_thumbnail = get_the_post_thumbnail(get_the_ID(),'tentered-600x400');
		$post_full_thumbnail = get_the_post_thumbnail_url(get_the_ID(),'full');
		$thumbnail = $post_thumbnail;
	}
	// Carousel View
	if($project_view=="carousel")
	{
	$post_output .= '<li class="item">
                     <div class="grid-item portfolio-item portfolio-carousel-item format-standard">';
	if(has_post_thumbnail())
	{
		$post_output .= '<div class="portfolio-image">';
		$post_output .= $thumbnail;
		$post_output .= '</div>';
	} else {
		$post_output .= '<div class="portfolio-image">';
		$post_output .= '<img src="' . vc_asset_url( 'vc/no_image.png' ) . '" alt="Image" height="100%">';
		$post_output .= '</div>';
	}
	$post_output .= '<div class="project-overlay">
					<div class="project-info"><div>';
					if($project_more == 1 || $project_zoom == 1){
	$post_output .= '<div class="action-icons">';
					if($project_more == 1){
	$post_output .= '<a title="View Project" href="'.get_permalink().'"><i class="fa fa-link fa-2x"></i></a>';
					}
					if($project_zoom == 1){
	$post_output .= '<a class="magnific-image" href="'.$post_full_thumbnail.'"><i class="fa fa-plus fa-2x"></i></a>';
					}	
	$post_output .= '</div>';			
					}
	$post_output .= '<h4><a href="'.get_permalink().'" class="project-name">'.get_the_title().'</a></h4>';
	$post = get_post();
	$categories = get_the_terms( $post->ID, 'project-category' );
	if($categories != array()){
		$post_output .= '<div class="project-categories">';
		foreach( $categories as $category ) {
			$post_output .= '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->name ) . '</a>';
		}
		$post_output .= '</div>';
	}
	$post_output .= '</div></div></div></div></li>';
	}
	
	// Grid View
	else
	
	{
		if($project_spacing == 'spaced'){
			$spaced = '';
		} else {
			$spaced = 'non-spaced';
		}
		$post_output .= '<li class="col-md-'.$project_grid_column.' col-sm-6 '.$spaced.' grid-item portfolio-item project-grid-item format-standard ';
		$term_slug = get_the_terms(get_the_ID(), 'project-category');
		if (!empty($term_slug)) {
			foreach ($term_slug as $term) {
			  $post_output .= ' cat-'.$term->slug.' ';
			}
		}
		$post_output .= ' ">
                        <div class="grid-item-inner">';
		if(has_post_thumbnail())
		{
			$post_output .= '<div class="portfolio-image">';
			$post_output .= $thumbnail;
			$post_output .= '</div>';
		} else {
			$post_output .= '<div class="portfolio-image">';
			$post_output .= '<img src="' . vc_asset_url( 'vc/no_image.png' ) . '" alt="Image" height="100%">';
			$post_output .= '</div>';
		}
		$post_output .= '<div class="project-overlay">
						<div class="project-info"><div>';
						if($project_more == 1 || $project_zoom == 1){
		$post_output .= '<div class="action-icons">';
						if($project_more == 1){
		$post_output .= '<a title="View Project" href="'.get_permalink().'"><i class="fa fa-link fa-2x"></i></a>';
						}
						if($project_zoom == 1){
		$post_output .= '<a class="magnific-image" href="'.$post_full_thumbnail.'"><i class="fa fa-plus fa-2x"></i></a>';
						}	
		$post_output .= '</div>';			
						}
		$post_output .= '<h4><a href="'.get_permalink().'" class="project-name">'.get_the_title().'</a></h4>';
		$post = get_post();
		$categories = get_the_terms( $post->ID, 'project-category' );
		if($categories != array()){
			$post_output .= '<div class="project-categories">';
			foreach( $categories as $category ) {
				$post_output .= '<a href="' . esc_url( get_category_link( $category->term_id ) ) . '">' . esc_html( $category->name ) . '</a>';
			}
			$post_output .= '</div>';
		}
		$post_output .= '</div></div></div></div></li>';
	}
	endwhile; endif; wp_reset_postdata();
	$post_output .= '</ul>';
	if($project_view=="carousel"){
		$post_output .= '</div></div>';
	} else {
		if($project_spacing == 'spaced'){
			$post_output .= '</div>';
		}
	}
	
	$post_output .= '</div>';
	global $tentered_allowed_tags;
	echo wp_kses($post_output, $tentered_allowed_tags);
	if($project_pagination == 1){
		$post_output .= '<div class="margin-10"></div>';
		$GLOBALS['wp_query'] = $post_list;
		$post_output .= tentered_pagination();
 		wp_reset_query();
	}
?>