<?php
/*Front end view of posts shortcode
==================================*/
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$paged = (get_query_var('paged'))?get_query_var('paged'):1;
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ) );

	if($posts_grid_column==4)
	{
		$carousel_col_class = 3;
	}
	elseif($posts_grid_column==3)
	{
		$carousel_col_class = 4;
	}
	elseif($posts_grid_column==6)
	{
		$carousel_col_class = 2;
	}
	elseif($posts_grid_column==12)
	{
		$carousel_col_class = 1;
	}

	if($tentered_style == '1'){
		$style_border = 'no-border-style';
	} else {
		$style_border = '';
	}
	$post_output = '<div class="'.esc_attr( $css_class ).' '.esc_html($style_border).'">';
	if($posts_view=="carousel"){
		$post_output .= '<div class="carousel-wrapper">';
	} elseif($posts_view=="grid"){
		$post_output .= '<div class="row">';
	}

	if ( is_rtl() )
	{
		$data_rtl = 'data-rtl="rtl"';
	}
	else
	{
		$data_rtl = 'data-rtl="ltr"';
	}
	if($posts_view=="carousel")
	{
		if($posts_carousel_arrows==1){
			$carrows = 'yes';
		} else {
			$carrows = 'no';
		}
		if($posts_carousel_pagi==1){
			$cpagi = 'yes';
		} else {
			$cpagi = 'no';
		}
		if($posts_carousel_rotate!=''){
			$cauto = $posts_carousel_rotate;
		} else {
			$cauto = '';
		}
		$post_output .= '<div class="row"><ul class="owl-carousel carousel-fw posts-carousel blog-posts" data-columns="'.esc_attr($carousel_col_class).'" data-autoplay="'.$cauto.'" data-pagination="'.$cpagi.'" data-arrows="'.$carrows.'" data-single-item="no" data-items-desktop="'.esc_attr($carousel_col_class).'" data-items-desktop-small="'.esc_attr($carousel_col_class).'" data-items-tablet="2" data-items-mobile="1" '.$data_rtl.'>';
	}
	elseif($posts_view=="grid")
	{
		$post_output .= '<ul class="grid-holder isotope blog-posts" data-sort-id="gallery">';
	}
	else
	{
		$post_output .= '<div class="blog-posts">';
	}
	if($posts_terms!='')
	{
		$terms = explode(',', $posts_terms);
		$post_args = array('post_type'=>'post', 'posts_per_page'=>$posts_number, 'paged' => $paged, 'tax_query'=>array(array('taxonomy'=>'category', 'field'=>'term_id', 'terms'=>$terms, 'operator'=>'IN')));
	}
	else
	{
		$post_args = array('post_type'=>'post', 'posts_per_page'=>$posts_number, 'paged' => $paged);
	}
	$post_list = new WP_Query($post_args);
	if($post_list->have_posts()):while($post_list->have_posts()):$post_list->the_post();
	$post_format = get_post_format();
	$post_format = ($post_format=="")?"image":$post_format;
	$post_author_id = get_post_field( 'post_author', get_the_ID() );
	$meta_data_date = esc_html(get_the_date(get_option('date_format'), get_the_ID()));
	$meta_data_author = '<a href="'. esc_url(get_author_posts_url($post_author_id)).'">'.esc_attr(get_the_author_meta( 'display_name', $post_author_id )).'</a> ';
	$comments_count = wp_count_comments(get_the_ID());
	$categories = get_the_category();
	$categories_list = '';
	if(!empty($categories))
	{
	   foreach($categories as $category)
	   {
			$categories_list = '<a href="'.get_category_link($category->term_id).'">'.$category->name.'</a>';
	   }
	}


	$post_media = '';
	// If only featured image show is active
	if($posts_media_image_only == 1){
		$thumbnail = '';
		if($posts_img_size != ''){
			$post_thumbnail = wpb_getImageBySize( array('post_id' => get_the_ID(),'thumb_size' => $posts_img_size) );
			$thumbnail = $post_thumbnail['thumbnail'];
		} else {
			$post_thumbnail = get_the_post_thumbnail(get_the_ID(),'tentered-600x400');
			$thumbnail = $post_thumbnail;
		}
	  	if ( has_post_thumbnail() ) {
			$post_media = '<a href="'.get_the_permalink().'" class="media-box">'.$thumbnail.'</a>';
		}
	} else
	{
		// Else get post media as per the post format
		if($post_format == 'image' || $post_format == 'standard'){
			$thumbnail = '';
			if($posts_img_size != ''){
				$post_thumbnail = wpb_getImageBySize( array('post_id' => get_the_ID(),'thumb_size' => $posts_img_size) );
				$thumbnail = $post_thumbnail['thumbnail'];
			} else {
				$post_thumbnail = get_the_post_thumbnail(get_the_ID(),'tentered-600x400');
				$thumbnail = $post_thumbnail;
			}
			if ( has_post_thumbnail() ) {
				$post_media = '<a href="'.get_the_permalink().'" class="media-box">'.$thumbnail.'</a>';
			}	
		}elseif($post_format == 'gallery'){
			$gallery = '';
			$speed = (get_post_meta(get_the_ID(), 'tentered_post_slider_speed', true)!='')?get_post_meta(get_the_ID(), 'tentered_post_slider_speed', true):5000;
			$pagination = get_post_meta(get_the_ID(), 'tentered_post_slider_pagination', true);
			$auto_slide = get_post_meta(get_the_ID(), 'tentered_post_slider_auto_slide', true);
			$direction = get_post_meta(get_the_ID(), 'tentered_post_slider_direction_arrows', true);
			$image_data=  get_post_meta(get_the_ID(),'tentered_post_gallery_images',false);
			$pagination = !empty($pagination) ? $pagination : 'yes';
			$auto_slide = !empty($auto_slide) ? $auto_slide : '';
			$direction = !empty($direction) ? $direction : 'yes';
			if (count($image_data) > 0) {
				$gallery .= '<div class="carousel-wrapper"><ul class="owl-carousel single-carousel post-media-carousel" data-columns="1" data-autoplay="'.$auto_slide.'" data-pagination="'.$pagination.'" data-arrows="'.$direction.'" data-single-item="yes" data-items-desktop="1" data-items-desktop-small="1" data-items-tablet="2" data-items-mobile="1" '.$data_rtl.'>';
				foreach ($image_data as $custom_gallery_images) {
					$large_src = wp_get_attachment_image_src($custom_gallery_images, 'full');
					$gallery .= '<li class="item"><a href="' . esc_url($large_src[0]) . '" class="popup-image">';
					if($posts_view=="full"){
						$gallery .= wp_get_attachment_image($custom_gallery_images, 'full');
					} else {
						$gallery .= wp_get_attachment_image($custom_gallery_images, 'tentered-600x400');
					}
					$gallery .= '</a></li>';
				}
				$gallery .= '</ul></div>';
			}
			global $tentered_allowed_tags;
			$post_media = wp_kses($gallery, $tentered_allowed_tags);

		}elseif($post_format == 'audio'){
			$audio_url = get_post_meta(get_the_ID(),'tentered_post_uploaded_audio',true);
			if($audio_url != ''){
				$post_media = tentered_audio_soundcloud($audio_url,"100%",250);
			}

		}elseif($post_format == 'video'){
			$video_url = get_post_meta(get_the_ID(),'tentered_post_video_url',true);
			if($video_url != ''){
				$post_media = tentered_video_embed($video_url,"500","338");
			}
		}
	}
	
	// Carousel View
	if($posts_view=="carousel")
	{
		$post_output .= '<li class="item">
                     <div class="grid-item post blog-masonry-item post-carousel-item format-'.$post_format.'">';
		if($posts_media_show == 1 && $post_media != ''){
			$post_output .= '<div class="post-media">'.$post_media.'</div>';
		}
		
		$post_output .= '<div class="grid-item-content">';
		
		$post_output .= '<h3 class="post-title"><a href="'.get_permalink().'">'.get_the_title().'</a></h3>';
		if($posts_date == 1 || $posts_author == 1 || $posts_categories == 1 || $posts_comments == 1){
			$post_output .= '<div class="blog-post-details">';
			if($posts_date == 1){
				$post_output .= '<div class="post-date"><i class="fa fa-calendar-o"></i> '.$meta_data_date.' </div>';
			}
			if($posts_author == 1){
				$post_output .= '<div class="post-author"><i class="icon-pencil"></i> '.$meta_data_author.' '.'</div>';
			}
			if($posts_categories == 1){
				$post_output .= '<div class="post-categories"><i class="fa fa-folder-o"></i> '.$categories_list.'</div>';
			}
			if($posts_comments == 1){
				$post_output .= '<div class="comments-likes"><a href="'.get_the_permalink().'"><i class="fa fa-comment-o"></i>  '.$comments_count->approved.'</a></div>';
			}
			$post_output .= '</div>';
		}
		if($posts_excerpt == 1 && ($posts_excerpt_number != '' && $posts_excerpt_number != '0')){
			$post_output .= tentered_excerpt($posts_excerpt_number);
		}
		if($posts_more == 1){
			$post_output .= '<a href="'.get_permalink().'" class="btn btn-primary btn-secondary">'.$posts_more_text.'</a>';
		}
		$post_output .= '</div>
		</div></li>';
	}
	elseif($posts_view=="medium")
	{
		$post_output .= '<div class="post-list-item post format-'.$post_format.'">
                        	<div class="row">';
		if($posts_media_show == 1 && $post_media != ''){
			$post_output .= '<div class="col-md-4"><div class="post-media">'.$post_media.'</div></div>';
		}
		if($posts_media_show == 1 && $post_media != ''){
			$post_output .= '<div class="col-md-8">';
		} else {
			$post_output .= '<div class="col-md-12">';	
		}
		
		$post_output .= '<h3 class="post-title"><a href="'.get_permalink().'">'.get_the_title().'</a></h3>';
		if($posts_date == 1 || $posts_author == 1 || $posts_categories == 1 || $posts_comments == 1){
			$post_output .= '<div class="blog-post-details">';
			if($posts_date == 1){
				$post_output .= '<div class="post-date"><i class="fa fa-calendar-o"></i> '.$meta_data_date.' </div>';
			}
			if($posts_author == 1){
				$post_output .= '<div class="post-author"><i class="icon-pencil"></i> '.$meta_data_author.' '.'</div>';
			}
			if($posts_categories == 1){
				$post_output .= '<div class="post-categories"><i class="fa fa-folder-o"></i> '.$categories_list.'</div>';
			}
			if($posts_comments == 1){
				$post_output .= '<div class="comments-likes"><a href="'.get_the_permalink().'"><i class="fa fa-comment-o"></i>  '.$comments_count->approved.'</a></div>';
			}
			$post_output .= '</div>';
		}
		if($posts_excerpt == 1 && ($posts_excerpt_number != '' && $posts_excerpt_number != '0')){
			$post_output .= tentered_excerpt($posts_excerpt_number);
		}
		if($posts_more == 1){
			$post_output .= '<a href="'.get_permalink().'" class="btn btn-primary btn-secondary">'.$posts_more_text.'</a>';
		}
		$post_output .= '</div>
				</div>
			</div>';
	}
	elseif($posts_view=="full")
	{
		$post_output .= '<div class="post blog-full-item format-'.$post_format.'">';
		if($posts_media_show == 1 && $post_media != ''){
			$post_output .= '<div class="post-media">'.$post_media.'</div>';
		}
		
		$post_output .= '<div class="full-item-content">';
		
		$post_output .= '<h3 class="post-title"><a href="'.get_permalink().'">'.get_the_title().'</a></h3>';
		if($posts_date == 1 || $posts_author == 1 || $posts_categories == 1 || $posts_comments == 1){
			$post_output .= '<div class="blog-post-details">';
			if($posts_date == 1){
				$post_output .= '<div class="post-date"><i class="fa fa-calendar-o"></i> '.$meta_data_date.' </div>';
			}
			if($posts_author == 1){
				$post_output .= '<div class="post-author"><i class="icon-pencil"></i> '.$meta_data_author.' '.'</div>';
			}
			if($posts_categories == 1){
				$post_output .= '<div class="post-categories"><i class="fa fa-folder-o"></i> '.$categories_list.'</div>';
			}
			if($posts_comments == 1){
				$post_output .= '<div class="comments-likes"><a href="'.get_the_permalink().'"><i class="fa fa-comment-o"></i>  '.$comments_count->approved.'</a></div>';
			}
			$post_output .= '</div>';
		}
		if($posts_excerpt == 1 && ($posts_excerpt_number != '' && $posts_excerpt_number != '0')){
			$post_output .= tentered_excerpt($posts_excerpt_number);
		}
		if($posts_more == 1){
			$post_output .= '<a href="'.get_permalink().'" class="btn btn-primary btn-secondary">'.$posts_more_text.'</a>';
		}
		$post_output .= '</div></div>';
	}
	else
	{
		$post_output .= '<li class="col-md-'.$posts_grid_column.' col-sm-6 grid-item post blog-masonry-item format-'.$post_format.'">
                        <div class="grid-item-inner">';
		
		if($posts_media_show == 1 && $post_media != ''){
			$post_output .= '<div class="post-media">'.$post_media.'</div>';
		}
		
		$post_output .= '<div class="grid-item-content">';
		
		$post_output .= '<h3 class="post-title"><a href="'.get_permalink().'">'.get_the_title().'</a></h3>';
		if($posts_date == 1 || $posts_author == 1 || $posts_categories == 1 || $posts_comments == 1){
			$post_output .= '<div class="blog-post-details">';
			if($posts_date == 1){
				$post_output .= '<div class="post-date"><i class="fa fa-calendar-o"></i> '.$meta_data_date.' </div>';
			}
			if($posts_author == 1){
				$post_output .= '<div class="post-author"><i class="icon-pencil"></i> '.$meta_data_author.' '.'</div>';
			}
			if($posts_categories == 1){
				$post_output .= '<div class="post-categories"><i class="fa fa-folder-o"></i> '.$categories_list.'</div>';
			}
			if($posts_comments == 1){
				$post_output .= '<div class="comments-likes"><a href="'.get_the_permalink().'"><i class="fa fa-comment-o"></i>  '.$comments_count->approved.'</a></div>';
			}
			$post_output .= '</div>';
		}
		if($posts_excerpt == 1 && ($posts_excerpt_number != '' && $posts_excerpt_number != '0')){
			$post_output .= tentered_excerpt($posts_excerpt_number);
		}
		if($posts_more == 1){
			$post_output .= '<a href="'.get_permalink().'" class="btn btn-primary btn-secondary">'.$posts_more_text.'</a>';
		}
		$post_output .= '</div>
                        </div>
                    </li>';
	}
	endwhile; endif; wp_reset_postdata();
	if($posts_view=="carousel")
	{
		$post_output .= '</ul></div></div>';
	}
	elseif($posts_view=="grid")
	{
		$post_output .= '</ul></div>';
	}
	else
	{
		$post_output .= '</div>';
	}
	
	$post_output .= '</div>';
	global $tentered_allowed_tags;
	echo wp_kses($post_output, $tentered_allowed_tags);
	if($posts_pagination == 1){
		$post_output .= '<div class="margin-10"></div>';
		$GLOBALS['wp_query'] = $post_list;
		$post_output .= tentered_pagination();
 		wp_reset_query();
	}
?>