<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1
 * @author     Thomas Griffin <thomasgriffinmedia.com>
 * @author     Gary Jones <gamajo.com>
 * @copyright  Copyright (c) 2014, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/tentered-framework/tgm/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'tentered_register_required_plugins' );
function tentered_register_required_plugins() {
    $plugins = array(
        array(
			'name' => esc_html__('Breadcrumb NavXT', 'tentered'),
			'slug' => 'breadcrumb-navxt',
			'required' 	=> false,
		),
		array(
			'name' => esc_html__('Pojo Sidebars', 'tentered'),
			'slug' => 'pojo-sidebars',
			'required' 	=> false,
		),
		array(
			'name' => esc_html__('Simple Twitter Tweets', 'tentered'),
		    'slug' => 'simple-twitter-tweets',
			'required' 	=> false,
		),
       	array(
			'name' => esc_html__('WooCommerce', 'tentered'),
		    'slug' => 'woocommerce',
			'required' 	=> false,
		),
		array(
			'name' => esc_html__('Contact Form 7', 'tentered'),
		    'slug' => 'contact-form-7',
			'required' 	=> false,
		),
		array(
			'name' => esc_html__('TinyMCE Advanced', 'tentered'),
		    'slug' => 'tinymce-advanced',
			'required' 	=> false,
		),
		array(
			'name' => esc_html__('Meta Box', 'tentered'),
		   	'slug' => 'meta-box',
			'required' => true,
		),
		array(
            'name'               => esc_html__('Revolution Slider', 'tentered'),
            'slug'               => 'revslider',
            'source'             => get_template_directory() . '/tentered-framework'. '/plugins/revslider.zip',
            'required'           => true,
            'version' 			 => '6.1.2',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),
			array(
            'name'               => esc_html__('TENTERED Core', 'tentered'),
            'slug'               => 'tentered-core',
            'source'             => get_template_directory() . '/tentered-framework'. '/plugins/tentered-core.zip',
            'required'           => true,
            'version'            => '1.4',
            'force_activation'   => false,
            'force_deactivation' => false,
            'external_url'       => '',
        ),
		array(
            'name'               => esc_html__('Redux Framework', 'tentered'),
            'slug'               => 'redux-framework',
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
		array(
            'name'               => esc_html__('imic Shortcodes', 'tentered'),
            'slug'               => 'imic-shortcodes',
			'source'  			 => get_template_directory() . '/tentered-framework'. '/plugins/imic-shortcodes.zip',
			'version' 			 => '1.2',
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
		array(
            'name'               => esc_html__('WP Bakery Page Builder', 'tentered'),
            'slug'               => 'js_composer',
			'source'             => get_template_directory() . '/tentered-framework'. '/plugins/js_composer.zip',
			'version' 			 => '6.0.5',
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
            
    );
    
    $config = array(
        'default_path' => '',
        'menu'         => 'tgmpa-install-plugins',
        'has_notices'  => true,
        'dismissable'  => true,
        'dismiss_msg'  => '',
        'is_automatic' => false,
        'message'      => '',
        'strings'      => array(
            'page_title'                      => esc_html__( 'Install Required Plugins', 'tentered' ),
            'menu_title'                      => esc_html__( 'Install Plugins', 'tentered' ),
            'installing'                      => esc_html__( 'Installing Plugin: %s', 'tentered' ),
            'oops'                            => esc_html__( 'Something went wrong with the plugin API.', 'tentered' ),
            'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'tentered' ),
            'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'tentered' ),
            'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'tentered' ),
            'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'tentered' ),
            'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'tentered' ),
            'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'tentered' ),
            'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'tentered' ),
            'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'tentered' ),
            'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'tentered' ),
            'activate_link'                   => _n_noop( 'Begin activating plugin', 'Begin activating plugins', 'tentered' ),
            'return'                          => esc_html__( 'Return to Required Plugins Installer', 'tentered' ),
            'plugin_activated'                => esc_html__( 'Plugin activated successfully.', 'tentered' ),
            'complete'                        => __( 'All plugins installed and activated successfully. %s', 'tentered' ),
            'nag_type'                        => 'updated'
        )
    );
    tgmpa( $plugins, $config );
}